/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, ViewChild, forwardRef } from '@angular/core';
import { FormControl, NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { AbstractFieldComponent } from '../../abstract-field.component';
import * as i0 from "@angular/core";
import * as i1 from "../../../../../core/services/system-settings.service";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "@ng-bootstrap/ng-bootstrap";
import * as i5 from "../../../../form-messages/form-messages.component";
const _c0 = ["toggleButton"];
const _c1 = a0 => ({ "is-invalid": a0 });
function DatetimeFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 21);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function DatetimeFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 22);
    i0.ɵɵelement(1, "i", 23);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r1.field.tooltip);
} }
function DatetimeFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 18);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, DatetimeFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 19)(3, DatetimeFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 20);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "input-" + ctx_r1.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.tooltip);
} }
function DatetimeFieldComponent_div_0_button_19_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 24);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_button_19_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r1.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function DatetimeFieldComponent_div_0_xf_form_messages_20_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 25);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r1.fieldGroup.controls.inputDate);
} }
function DatetimeFieldComponent_div_0_xf_form_messages_21_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 25);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r1.fieldGroup.controls.inputTime);
} }
function DatetimeFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, DatetimeFieldComponent_div_0_label_1_Template, 4, 4, "label", 4);
    i0.ɵɵelementStart(2, "div", 5)(3, "div", 6)(4, "div", 7);
    i0.ɵɵlistener("openChange", function DatetimeFieldComponent_div_0_Template_div_openChange_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.setDefaultValue($event)); });
    i0.ɵɵelementStart(5, "button", 8, 0);
    i0.ɵɵtext(7);
    i0.ɵɵpipe(8, "date");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "div", 9)(10, "ngb-datepicker", 10, 1);
    i0.ɵɵlistener("dateSelect", function DatetimeFieldComponent_div_0_Template_ngb_datepicker_dateSelect_10_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.dateSelected($event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(12, "div", 11);
    i0.ɵɵelement(13, "ngb-timepicker", 12);
    i0.ɵɵelementStart(14, "div", 13)(15, "button", 14);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.ngbDropdown.close()); });
    i0.ɵɵtext(16, "Apply");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(17, "button", 15);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_Template_button_click_17_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.clear()); });
    i0.ɵɵtext(18, "Clear");
    i0.ɵɵelementEnd()()()()();
    i0.ɵɵtemplate(19, DatetimeFieldComponent_div_0_button_19_Template, 2, 3, "button", 16);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(20, DatetimeFieldComponent_div_0_xf_form_messages_20_Template, 1, 1, "xf-form-messages", 17)(21, DatetimeFieldComponent_div_0_xf_form_messages_21_Template, 1, 1, "xf-form-messages", 17);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    let tmp_7_0;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showLabel);
    i0.ɵɵadvance(4);
    i0.ɵɵclassMapInterpolate1("datepicker btn btn-input text-start w-100 ", ctx_r1.fieldClass, "");
    i0.ɵɵproperty("id", "input-" + ctx_r1.field.name)("ngClass", i0.ɵɵpureFunction1(14, _c1, ((tmp_7_0 = ctx_r1.fieldGroup.get("inputDate")) == null ? null : tmp_7_0.touched) && ((tmp_7_0 = ctx_r1.fieldGroup.get("inputDate")) == null ? null : tmp_7_0.invalid)));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", ctx_r1.value ? i0.ɵɵpipeBind2(8, 11, ctx_r1.value, ctx_r1.systemSettings.preferences.dateTimeFormat) : "Select Date", " ");
    i0.ɵɵadvance(12);
    i0.ɵɵproperty("ngIf", ctx_r1.field.allowJinjaToggle);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showError);
} }
export class DatetimeFieldComponent extends AbstractFieldComponent {
    constructor(systemSettingsService, changeDetectorRef, formBuilder) {
        super(changeDetectorRef, formBuilder);
        this.systemSettingsService = systemSettingsService;
        this.isFirstChange = true;
        this.systemSettings = this.systemSettingsService.get();
    }
    get value() {
        return this._value;
    }
    set value(value) {
        super.value = value;
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.removeControl('input');
        const date = this.getDateFromValue();
        const time = this.getTimeFromValue();
        this.fieldGroup?.addControl('inputDate', new FormControl(date, this.fieldService.getValidators(this.field)));
        this.fieldGroup?.addControl('inputTime', new FormControl(time));
        this.fieldGroup?.valueChanges
            .subscribe((value) => {
            this.isFirstChange = false;
            if (!value.inputDate || !value.inputTime) {
                this.value = null;
                this.changeDetectorRef.detectChanges();
                return;
            }
            let date = new Date(Date.UTC(value.inputDate.year, value.inputDate.month - 1, value.inputDate.day, value.inputTime ? value.inputTime.hour : 0, value.inputTime ? value.inputTime.minute : 0));
            let timezoneOffset = new Date().getTimezoneOffset();
            date.setMinutes(date.getMinutes() + timezoneOffset);
            //this.value = date.getTime() / 1000;
            this.value = date;
            this.changeDetectorRef.detectChanges();
        });
    }
    getTimeFromValue() {
        if (!this.value) {
            return null;
        }
        let currentDate = new Date(this.value);
        return {
            minute: currentDate.getMinutes(),
            hour: currentDate.getHours()
        };
    }
    getDateFromValue() {
        if (!this.value) {
            return null;
        }
        let currentDate = new Date(this.value);
        return {
            year: currentDate.getFullYear(),
            month: currentDate.getMonth() + 1,
            day: currentDate.getDate()
        };
    }
    writeValue(value) {
        this.value = value;
        if (this.fieldGroup && this.fieldGroup.controls.inputDate && this.fieldGroup.controls.inputTime) {
            const date = this.getDateFromValue();
            const time = this.getTimeFromValue();
            this.fieldGroup.controls.inputDate.setValue(date);
            this.fieldGroup.controls.inputTime.setValue(time);
        }
    }
    validate(control) {
        this.control = control;
        if (!this.fieldGroup?.controls.inputDate?.valid) {
            return this.fieldGroup?.controls.inputDate?.errors || null;
        }
        if (!this.fieldGroup.controls.inputTime?.valid) {
            return this.fieldGroup.controls.inputTime?.errors || null;
        }
        return null;
    }
    dateSelected(event) {
        if (this.isFirstChange && event.day === this.fieldGroup?.controls.inputDate.value.day) {
            this.fieldGroup?.controls.inputDate.setValue(event);
        }
        this.isFirstChange = false;
    }
    setDefaultValue(opened) {
        if (opened && !this.value) {
            this.writeValue(new Date());
        }
    }
    clear() {
        this.writeValue(null);
        this.ngbDropdown.close();
    }
    focus() {
        this.ngbDropdownToggle.nativeElement.focus();
        this.fieldGroup?.markAllAsTouched();
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function DatetimeFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DatetimeFieldComponent)(i0.ɵɵdirectiveInject(i1.SystemSettingsService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DatetimeFieldComponent, selectors: [["xf-datetime-field"]], viewQuery: function DatetimeFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.ngbDropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.ngbDropdownToggle = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }]), i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["toggleButton", ""], ["dp", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "input-group", "mw-250px", "w-100"], [1, "d-flex"], ["ngbDropdown", "", 1, "flex-grow-1", "datepicker-container", 3, "openChange"], ["type", "button", "ngbDropdownToggle", "", 3, "id", "ngClass"], ["ngbDropdownMenu", ""], ["formControlName", "inputDate", 3, "dateSelect"], [1, "d-flex", "align-items-center", "justify-content-center"], ["formControlName", "inputTime"], [1, "ms-2"], ["type", "button", 1, "btn", "btn-sm", "btn-primary", 3, "click"], ["type", "button", 1, "btn", "btn-sm", "btn-default", "mt-1", 3, "click"], ["type", "button", "class", "ms-2 btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], [3, "control", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], ["type", "button", "title", "Add Custom Expression", 1, "ms-2", "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"], [3, "control"]], template: function DatetimeFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, DatetimeFieldComponent_div_0_Template, 22, 16, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i3.NgClass, i3.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i4.NgbTooltip, i4.NgbDatepicker, i4.NgbTimepicker, i4.NgbDropdown, i4.NgbDropdownToggle, i4.NgbDropdownMenu, i5.FormMessagesComponent, i3.DatePipe] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-datetime-field', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"input-group mw-250px w-100\">\n    <div class=\"d-flex\">\n      <div ngbDropdown class=\"flex-grow-1 datepicker-container\" (openChange)=\"setDefaultValue($event)\">\n        <button type=\"button\" [id]=\"'input-' + field.name\"\n          class=\"datepicker btn btn-input text-start w-100 {{fieldClass}}\" #toggleButton\n          [ngClass]=\"{'is-invalid': fieldGroup.get('inputDate')?.touched && fieldGroup.get('inputDate')?.invalid}\"\n          ngbDropdownToggle>\n          {{ value ? ( value | date: systemSettings.preferences.dateTimeFormat) : 'Select Date' }}\n        </button>\n        <div ngbDropdownMenu>\n          <ngb-datepicker #dp formControlName=\"inputDate\" (dateSelect)=\"dateSelected($event)\"></ngb-datepicker>\n          <div class=\"d-flex align-items-center justify-content-center\">\n            <ngb-timepicker formControlName=\"inputTime\"></ngb-timepicker>\n            <div class=\"ms-2\">\n              <button type=\"button\" class=\"btn btn-sm btn-primary\" (click)=\"ngbDropdown.close()\">Apply</button>\n              <button type=\"button\" class=\"btn btn-sm btn-default mt-1\" (click)=\"clear()\">Clear</button>\n            </div>\n          </div>\n        </div>\n      </div>\n      <button type=\"button\" class=\"ms-2 btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n    <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.inputDate\"></xf-form-messages>\n    <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.inputTime\"></xf-form-messages>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1.SystemSettingsService }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { ngbDropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], ngbDropdownToggle: [{
            type: ViewChild,
            args: ['toggleButton']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DatetimeFieldComponent, { className: "DatetimeFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/datetime/datetime-field/datetime-field.component.ts", lineNumber: 27 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0ZXRpbWUtZmllbGQuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL3NyYy9saWIvZm9ybS1maWVsZHMvZmllbGQtcmVuZGVyZXJzL2J1aWx0LWlucy9kYXRldGltZS9kYXRldGltZS1maWVsZC9kYXRldGltZS1maWVsZC5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9mb3JtLWZpZWxkcy9maWVsZC1yZW5kZXJlcnMvYnVpbHQtaW5zL2RhdGV0aW1lL2RhdGV0aW1lLWZpZWxkL2RhdGV0aW1lLWZpZWxkLmNvbXBvbmVudC5odG1sIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7O2tCQUlrQjtBQUNsQixPQUFPLEVBQXFCLFNBQVMsRUFBYyxTQUFTLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQ2hHLE9BQU8sRUFBZ0MsV0FBVyxFQUFFLGFBQWEsRUFBRSxpQkFBaUIsRUFBb0IsTUFBTSxnQkFBZ0IsQ0FBQztBQUMvSCxPQUFPLEVBQUUsV0FBVyxFQUFxQixNQUFNLDRCQUE0QixDQUFDO0FBQzVFLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxNQUFNLGdDQUFnQyxDQUFDOzs7Ozs7Ozs7O0lDQXBFLGdDQUE4RTtJQUFBLGlCQUFDO0lBQUEsaUJBQU87OztJQUN0RixnQ0FBMkQ7SUFDekQsd0JBQTRDO0lBQzlDLGlCQUFPOzs7SUFGcUIsNERBQThCOzs7SUFINUQsaUNBQXlHO0lBQ3ZHLFlBQ0E7SUFDQSxBQURBLHdGQUE4RSwyRUFDbkI7SUFHN0QsaUJBQVE7OztJQU5ELGtEQUE2QjtJQUNsQyxjQUNBO0lBREEsbURBQ0E7SUFBTyxjQUFnQztJQUFoQyxnR0FBZ0M7SUFDaEMsY0FBbUI7SUFBbkIsMkNBQW1COzs7O0lBd0J4QixrQ0FDMkc7SUFEeEMsNkxBQVMsbUJBQVksSUFBSSxDQUFDLEtBQUM7SUFDYSxZQUN2RztJQUFBLGlCQUFTOzs7SUFEa0QsZ0ZBQTJDO0lBQUMsY0FDdkc7SUFEdUcsMEJBQ3ZHOzs7SUFFTix1Q0FBOEc7OztJQUE3RCw4REFBeUM7OztJQUMxRix1Q0FBOEc7OztJQUE3RCw4REFBeUM7Ozs7SUFqQzlGLDhCQUFvRTtJQUNsRSxpRkFBeUc7SUFTckcsQUFERixBQURGLDhCQUF3QyxhQUNsQixhQUMrRTtJQUF2QywrTEFBYyw4QkFBdUIsS0FBQztJQUM5RixvQ0FHb0I7SUFDbEIsWUFDRjs7SUFBQSxpQkFBUztJQUVQLEFBREYsOEJBQXFCLDZCQUNpRTtJQUFwQywyTUFBYywyQkFBb0IsS0FBQztJQUFDLGlCQUFpQjtJQUNyRyxnQ0FBOEQ7SUFDNUQsc0NBQTZEO0lBRTNELEFBREYsZ0NBQWtCLGtCQUNtRTtJQUE5QixtTEFBUywwQkFBbUIsS0FBQztJQUFDLHNCQUFLO0lBQUEsaUJBQVM7SUFDakcsbUNBQTRFO0lBQWxCLG1MQUFTLGNBQU8sS0FBQztJQUFDLHNCQUFLO0lBSXpGLEFBREUsQUFERSxBQURFLEFBRG1GLGlCQUFTLEVBQ3RGLEVBQ0YsRUFDRixFQUNGO0lBQ04sc0ZBQzJHO0lBRTdHLGlCQUFNO0lBRU4sQUFEQSwwR0FBMkYsNkZBQ0E7SUFFL0YsQUFERSxpQkFBTSxFQUNGOzs7O0lBbkNxQyw2Q0FBd0I7SUFDVSxjQUE0QjtJQUE1QixvREFBNEI7SUFXL0YsZUFBZ0U7SUFBaEUsOEZBQWdFO0lBQ2hFLEFBRm9CLGlEQUE0QixnTkFFd0Q7SUFFeEcsZUFDRjtJQURFLHFKQUNGO0lBYUMsZ0JBQTRCO0lBQTVCLG9EQUE0QjtJQUdkLGNBQTRCO0lBQTVCLG9EQUE0QjtJQUM1QixjQUE0QjtJQUE1QixvREFBNEI7O0FEWm5ELE1BQU0sT0FBTyxzQkFBdUIsU0FBUSxzQkFBc0I7SUFPaEUsWUFDVSxxQkFBNEMsRUFDcEQsaUJBQW9DLEVBQ3BDLFdBQXdCO1FBRXhCLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxXQUFXLENBQUMsQ0FBQztRQUo5QiwwQkFBcUIsR0FBckIscUJBQXFCLENBQXVCO1FBSHRELGtCQUFhLEdBQVksSUFBSSxDQUFDO1FBUTVCLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEdBQUcsRUFBRSxDQUFDO0lBQ3pELENBQUM7SUFFRCxJQUFJLEtBQUs7UUFDUCxPQUFPLElBQUksQ0FBQyxNQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFFRCxJQUFJLEtBQUssQ0FBQyxLQUFrQjtRQUMxQixLQUFLLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUN0QixDQUFDO0lBRUQsUUFBUTtRQUNOLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUNqQixJQUFJLENBQUMsVUFBVSxFQUFFLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN4QyxNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztRQUNyQyxNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztRQUNyQyxJQUFJLENBQUMsVUFBVSxFQUFFLFVBQVUsQ0FBQyxXQUFXLEVBQUUsSUFBSSxXQUFXLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDN0csSUFBSSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsV0FBVyxFQUFFLElBQUksV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDaEUsSUFBSSxDQUFDLFVBQVUsRUFBRSxZQUFZO2FBQzFCLFNBQVMsQ0FBQyxDQUFDLEtBQVUsRUFBRSxFQUFFO1lBQ3hCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxDQUFDO2dCQUN6QyxJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztnQkFDbEIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO2dCQUN2QyxPQUFPO1lBQ1QsQ0FBQztZQUNELElBQUksSUFBSSxHQUFHLElBQUksSUFBSSxDQUNqQixJQUFJLENBQUMsR0FBRyxDQUNOLEtBQUssQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUNwQixLQUFLLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxDQUFDLEVBQ3pCLEtBQUssQ0FBQyxTQUFTLENBQUMsR0FBRyxFQUNuQixLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUMxQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUM3QyxDQUNGLENBQUM7WUFDRixJQUFJLGNBQWMsR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDLGlCQUFpQixFQUFFLENBQUM7WUFDcEQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLEdBQUcsY0FBYyxDQUFDLENBQUM7WUFDcEQscUNBQXFDO1lBQ3JDLElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO1lBQ2xCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQztRQUN6QyxDQUFDLENBQUMsQ0FBQztJQUNQLENBQUM7SUFFTyxnQkFBZ0I7UUFDdEIsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUNoQixPQUFPLElBQUksQ0FBQztRQUNkLENBQUM7UUFDRCxJQUFJLFdBQVcsR0FBRyxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDdkMsT0FBTztZQUNMLE1BQU0sRUFBRSxXQUFXLENBQUMsVUFBVSxFQUFFO1lBQ2hDLElBQUksRUFBRSxXQUFXLENBQUMsUUFBUSxFQUFFO1NBQzdCLENBQUM7SUFDSixDQUFDO0lBRU8sZ0JBQWdCO1FBQ3RCLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDaEIsT0FBTyxJQUFJLENBQUM7UUFDZCxDQUFDO1FBQ0QsSUFBSSxXQUFXLEdBQUcsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3ZDLE9BQU87WUFDTCxJQUFJLEVBQUUsV0FBVyxDQUFDLFdBQVcsRUFBRTtZQUMvQixLQUFLLEVBQUUsV0FBVyxDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUM7WUFDakMsR0FBRyxFQUFFLFdBQVcsQ0FBQyxPQUFPLEVBQUU7U0FDM0IsQ0FBQztJQUNKLENBQUM7SUFFTSxVQUFVLENBQUMsS0FBVTtRQUMxQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLElBQUksQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ2hHLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQ3JDLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQ3JDLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDbEQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNwRCxDQUFDO0lBQ0gsQ0FBQztJQUVELFFBQVEsQ0FBQyxPQUF3QjtRQUMvQixJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztRQUN2QixJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxRQUFRLENBQUMsU0FBUyxFQUFFLEtBQUssRUFBRSxDQUFDO1lBQ2hELE9BQU8sSUFBSSxDQUFDLFVBQVUsRUFBRSxRQUFRLENBQUMsU0FBUyxFQUFFLE1BQU0sSUFBSSxJQUFJLENBQUM7UUFDN0QsQ0FBQztRQUNELElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUUsS0FBSyxFQUFFLENBQUM7WUFDL0MsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUUsTUFBTSxJQUFJLElBQUksQ0FBQztRQUM1RCxDQUFDO1FBQ0QsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQsWUFBWSxDQUFDLEtBQVU7UUFDckIsSUFBSSxJQUFJLENBQUMsYUFBYSxJQUFJLEtBQUssQ0FBQyxHQUFHLEtBQUssSUFBSSxDQUFDLFVBQVUsRUFBRSxRQUFRLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsQ0FBQztZQUN0RixJQUFJLENBQUMsVUFBVSxFQUFFLFFBQVEsQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3RELENBQUM7UUFDRCxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBRUQsZUFBZSxDQUFDLE1BQWU7UUFDN0IsSUFBSSxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDMUIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLElBQUksRUFBRSxDQUFDLENBQUM7UUFDOUIsQ0FBQztJQUNILENBQUM7SUFFRCxLQUFLO1FBQ0gsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN0QixJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxDQUFDO0lBQzNCLENBQUM7SUFFTSxLQUFLO1FBQ1YsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUM3QyxJQUFJLENBQUMsVUFBVSxFQUFFLGdCQUFnQixFQUFFLENBQUM7UUFDcEMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pDLENBQUM7dUhBMUhVLHNCQUFzQjtvRUFBdEIsc0JBQXNCOzJCQUd0QixXQUFXOzs7Ozs7OENBYlgsQ0FBQztvQkFDVixPQUFPLEVBQUUsaUJBQWlCO29CQUMxQixXQUFXLEVBQUUsVUFBVSxDQUFDLEdBQUcsRUFBRSxDQUFDLHNCQUFzQixDQUFDO29CQUNyRCxLQUFLLEVBQUUsSUFBSTtpQkFDWixFQUFFO29CQUNELE9BQU8sRUFBRSxhQUFhO29CQUN0QixXQUFXLEVBQUUsVUFBVSxDQUFDLEdBQUcsRUFBRSxDQUFDLHNCQUFzQixDQUFDO29CQUNyRCxLQUFLLEVBQUUsSUFBSTtpQkFDWixDQUFDO1lDbkJKLHlFQUFvRTs7WUFBM0MscUNBQWdCOzs7aUZEcUI1QixzQkFBc0I7Y0FkbEMsU0FBUzsyQkFDRSxtQkFBbUIsYUFHbEIsQ0FBQzt3QkFDVixPQUFPLEVBQUUsaUJBQWlCO3dCQUMxQixXQUFXLEVBQUUsVUFBVSxDQUFDLEdBQUcsRUFBRSxDQUFDLHNCQUFzQixDQUFDO3dCQUNyRCxLQUFLLEVBQUUsSUFBSTtxQkFDWixFQUFFO3dCQUNELE9BQU8sRUFBRSxhQUFhO3dCQUN0QixXQUFXLEVBQUUsVUFBVSxDQUFDLEdBQUcsRUFBRSxDQUFDLHNCQUFzQixDQUFDO3dCQUNyRCxLQUFLLEVBQUUsSUFBSTtxQkFDWixDQUFDO2dIQUtzQixXQUFXO2tCQUFsQyxTQUFTO21CQUFDLFdBQVc7WUFDSyxpQkFBaUI7a0JBQTNDLFNBQVM7bUJBQUMsY0FBYzs7a0ZBSmQsc0JBQXNCIiwic291cmNlc0NvbnRlbnQiOlsiLyogQ29weXJpZ2h0IHN0YXJ0XG4gIENvcHlyaWdodCAoQykgMjAwOCAtIDIwMjUgRm9ydGluZXQgSW5jLlxuICBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICBGT1JUSU5FVCBDT05GSURFTlRJQUwgJiBGT1JUSU5FVCBQUk9QUklFVEFSWSBTT1VSQ0UgQ09ERVxuICBDb3B5cmlnaHQgZW5kICovXG5pbXBvcnQgeyBDaGFuZ2VEZXRlY3RvclJlZiwgQ29tcG9uZW50LCBFbGVtZW50UmVmLCBWaWV3Q2hpbGQsIGZvcndhcmRSZWYgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEFic3RyYWN0Q29udHJvbCwgRm9ybUJ1aWxkZXIsIEZvcm1Db250cm9sLCBOR19WQUxJREFUT1JTLCBOR19WQUxVRV9BQ0NFU1NPUiwgVmFsaWRhdGlvbkVycm9ycyB9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcbmltcG9ydCB7IE5nYkRyb3Bkb3duLCBOZ2JEcm9wZG93blRvZ2dsZSB9IGZyb20gJ0BuZy1ib290c3RyYXAvbmctYm9vdHN0cmFwJztcbmltcG9ydCB7IEFic3RyYWN0RmllbGRDb21wb25lbnQgfSBmcm9tICcuLi8uLi9hYnN0cmFjdC1maWVsZC5jb21wb25lbnQnO1xuaW1wb3J0IHsgU3lzdGVtU2V0dGluZ3NTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy9zeXN0ZW0tc2V0dGluZ3Muc2VydmljZSc7XG5pbXBvcnQgeyBTeXN0ZW1TZXR0aW5ncyB9IGZyb20gJy4uLy4uLy4uLy4uLy4uL2NvcmUvbW9kZWxzL3N5c3RlbS1zZXR0aW5ncyc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ3hmLWRhdGV0aW1lLWZpZWxkJyxcbiAgdGVtcGxhdGVVcmw6ICcuL2RhdGV0aW1lLWZpZWxkLmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vZGF0ZXRpbWUtZmllbGQuY29tcG9uZW50LnNjc3MnXSxcbiAgcHJvdmlkZXJzOiBbe1xuICAgIHByb3ZpZGU6IE5HX1ZBTFVFX0FDQ0VTU09SLFxuICAgIHVzZUV4aXN0aW5nOiBmb3J3YXJkUmVmKCgpID0+IEFic3RyYWN0RmllbGRDb21wb25lbnQpLFxuICAgIG11bHRpOiB0cnVlXG4gIH0sIHtcbiAgICBwcm92aWRlOiBOR19WQUxJREFUT1JTLFxuICAgIHVzZUV4aXN0aW5nOiBmb3J3YXJkUmVmKCgpID0+IEFic3RyYWN0RmllbGRDb21wb25lbnQpLFxuICAgIG11bHRpOiB0cnVlXG4gIH1dXG59KVxuZXhwb3J0IGNsYXNzIERhdGV0aW1lRmllbGRDb21wb25lbnQgZXh0ZW5kcyBBYnN0cmFjdEZpZWxkQ29tcG9uZW50IHtcblxuICBzeXN0ZW1TZXR0aW5nczogU3lzdGVtU2V0dGluZ3M7XG4gIEBWaWV3Q2hpbGQoTmdiRHJvcGRvd24pIG5nYkRyb3Bkb3duITogTmdiRHJvcGRvd247XG4gIEBWaWV3Q2hpbGQoJ3RvZ2dsZUJ1dHRvbicpIG5nYkRyb3Bkb3duVG9nZ2xlITogRWxlbWVudFJlZjtcbiAgaXNGaXJzdENoYW5nZTogYm9vbGVhbiA9IHRydWU7XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSBzeXN0ZW1TZXR0aW5nc1NlcnZpY2U6IFN5c3RlbVNldHRpbmdzU2VydmljZSxcbiAgICBjaGFuZ2VEZXRlY3RvclJlZjogQ2hhbmdlRGV0ZWN0b3JSZWYsXG4gICAgZm9ybUJ1aWxkZXI6IEZvcm1CdWlsZGVyXG4gICkge1xuICAgIHN1cGVyKGNoYW5nZURldGVjdG9yUmVmLCBmb3JtQnVpbGRlcik7XG4gICAgdGhpcy5zeXN0ZW1TZXR0aW5ncyA9IHRoaXMuc3lzdGVtU2V0dGluZ3NTZXJ2aWNlLmdldCgpO1xuICB9XG5cbiAgZ2V0IHZhbHVlKCkge1xuICAgIHJldHVybiB0aGlzLl92YWx1ZSBhcyBEYXRlIHwgbnVsbDtcbiAgfVxuXG4gIHNldCB2YWx1ZSh2YWx1ZTogRGF0ZSB8IG51bGwpIHtcbiAgICBzdXBlci52YWx1ZSA9IHZhbHVlO1xuICB9XG5cbiAgbmdPbkluaXQoKSB7XG4gICAgc3VwZXIubmdPbkluaXQoKTtcbiAgICB0aGlzLmZpZWxkR3JvdXA/LnJlbW92ZUNvbnRyb2woJ2lucHV0Jyk7XG4gICAgY29uc3QgZGF0ZSA9IHRoaXMuZ2V0RGF0ZUZyb21WYWx1ZSgpO1xuICAgIGNvbnN0IHRpbWUgPSB0aGlzLmdldFRpbWVGcm9tVmFsdWUoKTtcbiAgICB0aGlzLmZpZWxkR3JvdXA/LmFkZENvbnRyb2woJ2lucHV0RGF0ZScsIG5ldyBGb3JtQ29udHJvbChkYXRlLCB0aGlzLmZpZWxkU2VydmljZS5nZXRWYWxpZGF0b3JzKHRoaXMuZmllbGQpKSk7XG4gICAgdGhpcy5maWVsZEdyb3VwPy5hZGRDb250cm9sKCdpbnB1dFRpbWUnLCBuZXcgRm9ybUNvbnRyb2wodGltZSkpO1xuICAgIHRoaXMuZmllbGRHcm91cD8udmFsdWVDaGFuZ2VzXG4gICAgICAuc3Vic2NyaWJlKCh2YWx1ZTogYW55KSA9PiB7XG4gICAgICAgIHRoaXMuaXNGaXJzdENoYW5nZSA9IGZhbHNlO1xuICAgICAgICBpZiAoIXZhbHVlLmlucHV0RGF0ZSB8fCAhdmFsdWUuaW5wdXRUaW1lKSB7XG4gICAgICAgICAgdGhpcy52YWx1ZSA9IG51bGw7XG4gICAgICAgICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG4gICAgICAgIGxldCBkYXRlID0gbmV3IERhdGUoXG4gICAgICAgICAgRGF0ZS5VVEMoXG4gICAgICAgICAgICB2YWx1ZS5pbnB1dERhdGUueWVhcixcbiAgICAgICAgICAgIHZhbHVlLmlucHV0RGF0ZS5tb250aCAtIDEsXG4gICAgICAgICAgICB2YWx1ZS5pbnB1dERhdGUuZGF5LFxuICAgICAgICAgICAgdmFsdWUuaW5wdXRUaW1lID8gdmFsdWUuaW5wdXRUaW1lLmhvdXIgOiAwLFxuICAgICAgICAgICAgdmFsdWUuaW5wdXRUaW1lID8gdmFsdWUuaW5wdXRUaW1lLm1pbnV0ZSA6IDBcbiAgICAgICAgICApXG4gICAgICAgICk7XG4gICAgICAgIGxldCB0aW1lem9uZU9mZnNldCA9IG5ldyBEYXRlKCkuZ2V0VGltZXpvbmVPZmZzZXQoKTtcbiAgICAgICAgZGF0ZS5zZXRNaW51dGVzKGRhdGUuZ2V0TWludXRlcygpICsgdGltZXpvbmVPZmZzZXQpO1xuICAgICAgICAvL3RoaXMudmFsdWUgPSBkYXRlLmdldFRpbWUoKSAvIDEwMDA7XG4gICAgICAgIHRoaXMudmFsdWUgPSBkYXRlO1xuICAgICAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBnZXRUaW1lRnJvbVZhbHVlKCkge1xuICAgIGlmICghdGhpcy52YWx1ZSkge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICAgIGxldCBjdXJyZW50RGF0ZSA9IG5ldyBEYXRlKHRoaXMudmFsdWUpO1xuICAgIHJldHVybiB7XG4gICAgICBtaW51dGU6IGN1cnJlbnREYXRlLmdldE1pbnV0ZXMoKSxcbiAgICAgIGhvdXI6IGN1cnJlbnREYXRlLmdldEhvdXJzKClcbiAgICB9O1xuICB9XG5cbiAgcHJpdmF0ZSBnZXREYXRlRnJvbVZhbHVlKCkge1xuICAgIGlmICghdGhpcy52YWx1ZSkge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICAgIGxldCBjdXJyZW50RGF0ZSA9IG5ldyBEYXRlKHRoaXMudmFsdWUpO1xuICAgIHJldHVybiB7XG4gICAgICB5ZWFyOiBjdXJyZW50RGF0ZS5nZXRGdWxsWWVhcigpLFxuICAgICAgbW9udGg6IGN1cnJlbnREYXRlLmdldE1vbnRoKCkgKyAxLFxuICAgICAgZGF5OiBjdXJyZW50RGF0ZS5nZXREYXRlKClcbiAgICB9O1xuICB9XG5cbiAgcHVibGljIHdyaXRlVmFsdWUodmFsdWU6IGFueSk6IHZvaWQge1xuICAgIHRoaXMudmFsdWUgPSB2YWx1ZTtcbiAgICBpZiAodGhpcy5maWVsZEdyb3VwICYmIHRoaXMuZmllbGRHcm91cC5jb250cm9scy5pbnB1dERhdGUgJiYgdGhpcy5maWVsZEdyb3VwLmNvbnRyb2xzLmlucHV0VGltZSkge1xuICAgICAgY29uc3QgZGF0ZSA9IHRoaXMuZ2V0RGF0ZUZyb21WYWx1ZSgpO1xuICAgICAgY29uc3QgdGltZSA9IHRoaXMuZ2V0VGltZUZyb21WYWx1ZSgpO1xuICAgICAgdGhpcy5maWVsZEdyb3VwLmNvbnRyb2xzLmlucHV0RGF0ZS5zZXRWYWx1ZShkYXRlKTtcbiAgICAgIHRoaXMuZmllbGRHcm91cC5jb250cm9scy5pbnB1dFRpbWUuc2V0VmFsdWUodGltZSk7XG4gICAgfVxuICB9XG5cbiAgdmFsaWRhdGUoY29udHJvbDogQWJzdHJhY3RDb250cm9sKTogVmFsaWRhdGlvbkVycm9ycyB8IG51bGwge1xuICAgIHRoaXMuY29udHJvbCA9IGNvbnRyb2w7XG4gICAgaWYgKCF0aGlzLmZpZWxkR3JvdXA/LmNvbnRyb2xzLmlucHV0RGF0ZT8udmFsaWQpIHtcbiAgICAgIHJldHVybiB0aGlzLmZpZWxkR3JvdXA/LmNvbnRyb2xzLmlucHV0RGF0ZT8uZXJyb3JzIHx8IG51bGw7XG4gICAgfVxuICAgIGlmICghdGhpcy5maWVsZEdyb3VwLmNvbnRyb2xzLmlucHV0VGltZT8udmFsaWQpIHtcbiAgICAgIHJldHVybiB0aGlzLmZpZWxkR3JvdXAuY29udHJvbHMuaW5wdXRUaW1lPy5lcnJvcnMgfHwgbnVsbDtcbiAgICB9XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cblxuICBkYXRlU2VsZWN0ZWQoZXZlbnQ6IGFueSkge1xuICAgIGlmICh0aGlzLmlzRmlyc3RDaGFuZ2UgJiYgZXZlbnQuZGF5ID09PSB0aGlzLmZpZWxkR3JvdXA/LmNvbnRyb2xzLmlucHV0RGF0ZS52YWx1ZS5kYXkpIHtcbiAgICAgIHRoaXMuZmllbGRHcm91cD8uY29udHJvbHMuaW5wdXREYXRlLnNldFZhbHVlKGV2ZW50KTtcbiAgICB9XG4gICAgdGhpcy5pc0ZpcnN0Q2hhbmdlID0gZmFsc2U7XG4gIH1cblxuICBzZXREZWZhdWx0VmFsdWUob3BlbmVkOiBib29sZWFuKSB7XG4gICAgaWYgKG9wZW5lZCAmJiAhdGhpcy52YWx1ZSkge1xuICAgICAgdGhpcy53cml0ZVZhbHVlKG5ldyBEYXRlKCkpO1xuICAgIH1cbiAgfVxuXG4gIGNsZWFyKCkge1xuICAgIHRoaXMud3JpdGVWYWx1ZShudWxsKTtcbiAgICB0aGlzLm5nYkRyb3Bkb3duLmNsb3NlKCk7XG4gIH1cblxuICBwdWJsaWMgZm9jdXMoKTogdm9pZCB7XG4gICAgdGhpcy5uZ2JEcm9wZG93blRvZ2dsZS5uYXRpdmVFbGVtZW50LmZvY3VzKCk7XG4gICAgdGhpcy5maWVsZEdyb3VwPy5tYXJrQWxsQXNUb3VjaGVkKCk7XG4gICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gIH1cblxufVxuIiwiPCEtLSBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgLS0+XG48ZGl2IGNsYXNzPVwiZm9ybS1ncm91cFwiICpuZ0lmPVwiZmllbGRHcm91cFwiIFtmb3JtR3JvdXBdPVwiZmllbGRHcm91cFwiPlxuICA8bGFiZWwgW2Zvcl09XCInaW5wdXQtJyArIGZpZWxkLm5hbWVcIiBjbGFzcz1cImZvcm0tbGFiZWwgbWFyZ2luLWJvdHRvbS00cHhcIiAqbmdJZj1cImZpZWxkT3B0aW9ucy5zaG93TGFiZWxcIj5cbiAgICB7eyBmaWVsZC50aXRsZSB9fVxuICAgIDxzcGFuICpuZ0lmPVwiZmllbGQudmFsaWRhdGlvbj8ucmVxdWlyZWRcIiBjbGFzcz1cInRleHQtZGFuZ2VyIG1hcmdpbi1yaWdodC00cHhcIj4qPC9zcGFuPlxuICAgIDxzcGFuICpuZ0lmPVwiZmllbGQudG9vbHRpcFwiIG5nYlRvb2x0aXA9XCJ7e2ZpZWxkLnRvb2x0aXB9fVwiPlxuICAgICAgPGkgY2xhc3M9XCJmYSBmYS1kdW90b25lIGZhLWluZm8tY2lyY2xlXCI+PC9pPlxuICAgIDwvc3Bhbj5cbiAgPC9sYWJlbD5cbiAgPGRpdiBjbGFzcz1cImlucHV0LWdyb3VwIG13LTI1MHB4IHctMTAwXCI+XG4gICAgPGRpdiBjbGFzcz1cImQtZmxleFwiPlxuICAgICAgPGRpdiBuZ2JEcm9wZG93biBjbGFzcz1cImZsZXgtZ3Jvdy0xIGRhdGVwaWNrZXItY29udGFpbmVyXCIgKG9wZW5DaGFuZ2UpPVwic2V0RGVmYXVsdFZhbHVlKCRldmVudClcIj5cbiAgICAgICAgPGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCIgW2lkXT1cIidpbnB1dC0nICsgZmllbGQubmFtZVwiXG4gICAgICAgICAgY2xhc3M9XCJkYXRlcGlja2VyIGJ0biBidG4taW5wdXQgdGV4dC1zdGFydCB3LTEwMCB7e2ZpZWxkQ2xhc3N9fVwiICN0b2dnbGVCdXR0b25cbiAgICAgICAgICBbbmdDbGFzc109XCJ7J2lzLWludmFsaWQnOiBmaWVsZEdyb3VwLmdldCgnaW5wdXREYXRlJyk/LnRvdWNoZWQgJiYgZmllbGRHcm91cC5nZXQoJ2lucHV0RGF0ZScpPy5pbnZhbGlkfVwiXG4gICAgICAgICAgbmdiRHJvcGRvd25Ub2dnbGU+XG4gICAgICAgICAge3sgdmFsdWUgPyAoIHZhbHVlIHwgZGF0ZTogc3lzdGVtU2V0dGluZ3MucHJlZmVyZW5jZXMuZGF0ZVRpbWVGb3JtYXQpIDogJ1NlbGVjdCBEYXRlJyB9fVxuICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgPGRpdiBuZ2JEcm9wZG93bk1lbnU+XG4gICAgICAgICAgPG5nYi1kYXRlcGlja2VyICNkcCBmb3JtQ29udHJvbE5hbWU9XCJpbnB1dERhdGVcIiAoZGF0ZVNlbGVjdCk9XCJkYXRlU2VsZWN0ZWQoJGV2ZW50KVwiPjwvbmdiLWRhdGVwaWNrZXI+XG4gICAgICAgICAgPGRpdiBjbGFzcz1cImQtZmxleCBhbGlnbi1pdGVtcy1jZW50ZXIganVzdGlmeS1jb250ZW50LWNlbnRlclwiPlxuICAgICAgICAgICAgPG5nYi10aW1lcGlja2VyIGZvcm1Db250cm9sTmFtZT1cImlucHV0VGltZVwiPjwvbmdiLXRpbWVwaWNrZXI+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwibXMtMlwiPlxuICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBjbGFzcz1cImJ0biBidG4tc20gYnRuLXByaW1hcnlcIiAoY2xpY2spPVwibmdiRHJvcGRvd24uY2xvc2UoKVwiPkFwcGx5PC9idXR0b24+XG4gICAgICAgICAgICAgIDxidXR0b24gdHlwZT1cImJ1dHRvblwiIGNsYXNzPVwiYnRuIGJ0bi1zbSBidG4tZGVmYXVsdCBtdC0xXCIgKGNsaWNrKT1cImNsZWFyKClcIj5DbGVhcjwvYnV0dG9uPlxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBjbGFzcz1cIm1zLTIgYnRuIGJ0bi1zZWNvbmRhcnkgYnRuLXNtIGgtMzZweFwiIChjbGljayk9XCJ0b2dnbGVKaW5qYSh0cnVlKVwiXG4gICAgICAgICpuZ0lmPVwiZmllbGQuYWxsb3dKaW5qYVRvZ2dsZVwiIHRpdGxlPVwiQWRkIEN1c3RvbSBFeHByZXNzaW9uXCIgaWQ9XCJ0b2dnbGUtamluamEtY2hlY2tib3gte3sgZmllbGQubmFtZSB9fVwiPnt7ICd7fSdcbiAgICAgICAgfX08L2J1dHRvbj5cbiAgICA8L2Rpdj5cbiAgICA8eGYtZm9ybS1tZXNzYWdlcyAqbmdJZj1cImZpZWxkT3B0aW9ucy5zaG93RXJyb3JcIiBbY29udHJvbF09XCJmaWVsZEdyb3VwLmNvbnRyb2xzLmlucHV0RGF0ZVwiPjwveGYtZm9ybS1tZXNzYWdlcz5cbiAgICA8eGYtZm9ybS1tZXNzYWdlcyAqbmdJZj1cImZpZWxkT3B0aW9ucy5zaG93RXJyb3JcIiBbY29udHJvbF09XCJmaWVsZEdyb3VwLmNvbnRyb2xzLmlucHV0VGltZVwiPjwveGYtZm9ybS1tZXNzYWdlcz5cbiAgPC9kaXY+XG48L2Rpdj5cbiJdfQ==