import { Injectable } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import * as _ from 'lodash-es';
import { isObject } from 'lodash-es';
import { forEach } from 'lodash-es';
import { of, throwError, catchError, Subject } from 'rxjs';
import { map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API } from '../../../../core/constants';
import { PicklistName } from './models/picklistName';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "../../../../core/services/storage.service";
import * as i3 from "../../../../core/services/entity.service";
export class PicklistService {
    constructor(http, storage, entityService) {
        this.http = http;
        this.storage = storage;
        this.entityService = entityService;
        this.picklists = null;
    }
    loadPicklistName(picklistName) {
        if (this.picklists && this.picklists[picklistName]) {
            return of(plainToInstance(PicklistName, this.picklists[picklistName]));
        }
        return this.http
            .get(API.API_3_BASE + 'picklist_names', {
            params: {
                name: picklistName
            }
        })
            .pipe(map((response) => plainToInstance(PicklistName, response['hydra:member'][0])));
    }
    getPicklistByIri(iri) {
        let iriParts = iri.split('/');
        let getChildPicklistValue = iriParts[3] === 'picklists';
        return this.loadAllPicklists().pipe(map((picklistNames) => {
            let result;
            if (getChildPicklistValue) {
                for (let i = 0; i < picklistNames.length; i++) {
                    let _picklistName = picklistNames[i];
                    result = _.find(_picklistName.picklists, (picklist) => {
                        return picklist['@id'] === iri;
                    });
                    if (result) {
                        break;
                    }
                }
            }
            else {
                result = _.find(picklistNames, (picklistName) => {
                    return picklistName['@id'] === iri;
                });
            }
            if (result) {
                return result;
            }
            else {
                return;
            }
        }));
    }
    getPicklistByUUID(uuid) {
        return this.loadAllPicklists().pipe(map((picklists) => {
            let result = _.find(picklists, (picklist) => {
                return picklist.uuid === uuid;
            });
            return result;
        }));
    }
    removeFromCache(picklist) {
        if (isObject(picklist)) {
            // this.storage.remove('picklists.'+picklist.name);
            // localStorageService.remove('picklists.'+$filter('getEndPathName')(picklist['@id']));
        }
        else {
            //localStorageService.remove('picklists.'+picklist);
        }
    }
    loadAllPicklists(useExport = false) {
        // TODO: Picklist URL needs to change
        //const url = `${API.API_3_BASE}picklist_names?$export=${useExport}&$limit=${ALL_RECORDS_SIZE}&$orderby=name&$relationships=true`;
        const url = 'assets/dummyData/picklists.json';
        if (this.picklists) {
            return of(this.picklists);
        }
        return this.http.get(url).pipe(map((response) => {
            this.picklists = {};
            forEach(response['hydra:member'], (picklist) => {
                this.picklists[picklist.name] = picklist;
            });
            return response['hydra:member'];
        }));
    }
    loadPicklists(field, metadata) {
        let picklists$ = new Subject();
        let entity$;
        if (!metadata) {
            entity$ = this.entityService.build('picklists').pipe(map((entity) => {
                metadata = entity;
                return metadata;
            }));
        }
        else {
            entity$ = of(metadata);
        }
        entity$.subscribe({
            next: (entity) => {
                if (field?.dataSource?.query?.filters?.length > 0 && field.dataSource?.query.filters[0]?.value) {
                    const picklists = this.storage.getItem('picklists.' + field.dataSource.query.filters[0].value);
                    if (picklists && picklists.length > 0) {
                        field.options = picklists;
                        this.entityService.setDisplayName(field, entity);
                        picklists$.next(field);
                        picklists$.complete();
                    }
                    else {
                        this.loadPicklistsByParams(field.dataSource.query.filters[0].value, 'name').subscribe({
                            next: (result) => {
                                if (result && result.length > 0) {
                                    field.options = result;
                                    this.entityService.setDisplayName(field, entity);
                                    this.storage.setItem('picklists.' + field.dataSource.query.filters[0].value, field.options);
                                    picklists$.next(field);
                                    picklists$.complete();
                                }
                                else {
                                    picklists$.next({});
                                    picklists$.complete();
                                }
                            }, error: (error) => {
                                picklists$.error(error);
                            }
                        });
                    }
                }
                else {
                    picklists$.error(false);
                }
            }, error: (error) => {
                picklists$.error(error);
            }
        });
        return picklists$.asObservable();
    }
    loadPicklistsByParams(itemVal, itemKey) {
        let picklists = this.storage.getItem(`picklists.${itemVal}`);
        if (picklists && picklists.length > 0) {
            return of(picklists);
        }
        else {
            let query = {
                limit: ALL_RECORDS_SIZE,
                $orderby: 'orderIndex'
            };
            query['listName__' + itemKey] = itemVal;
            return this.http.get(`${API.BASE}picklists`, { params: query }).pipe(map((result) => {
                if (result && result['hydra:member']) {
                    this.storage.setItem('picklists.' + itemVal, picklists);
                    return result['hydra:member'];
                }
                else {
                    return throwError(() => new Error('Not a valid picklist query'));
                }
            }), catchError(error => {
                return throwError(() => error);
            }));
        }
    }
    static { this.ɵfac = function PicklistService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService), i0.ɵɵinject(i3.EntityService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PicklistService, factory: PicklistService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }, { type: i3.EntityService }], null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlja2xpc3Quc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zcmMvbGliL2Zvcm0tZmllbGRzL2ZpZWxkLXJlbmRlcmVycy9idWlsdC1pbnMvcGlja2xpc3QvcGlja2xpc3Quc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFNQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzNDLE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQztBQUNwRCxPQUFPLEtBQUssQ0FBQyxNQUFNLFdBQVcsQ0FBQztBQUMvQixPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQ3JDLE9BQU8sRUFBRSxPQUFPLEVBQUUsTUFBTSxXQUFXLENBQUM7QUFDcEMsT0FBTyxFQUFjLEVBQUUsRUFBRSxVQUFVLEVBQUUsVUFBVSxFQUFFLE9BQU8sRUFBRSxNQUFNLE1BQU0sQ0FBQztBQUN2RSxPQUFPLEVBQUUsR0FBRyxFQUFhLE1BQU0sZ0JBQWdCLENBQUM7QUFDaEQsT0FBTyxFQUFFLGdCQUFnQixFQUFFLEdBQUcsRUFBRSxNQUFNLDRCQUE0QixDQUFDO0FBU25FLE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQzs7Ozs7QUFLckQsTUFBTSxPQUFPLGVBQWU7SUFHMUIsWUFDVSxJQUFnQixFQUNoQixPQUF1QixFQUN2QixhQUE0QjtRQUY1QixTQUFJLEdBQUosSUFBSSxDQUFZO1FBQ2hCLFlBQU8sR0FBUCxPQUFPLENBQWdCO1FBQ3ZCLGtCQUFhLEdBQWIsYUFBYSxDQUFlO1FBTHRDLGNBQVMsR0FBb0MsSUFBSSxDQUFDO0lBTTlDLENBQUM7SUFFTCxnQkFBZ0IsQ0FBQyxZQUFvQjtRQUNuQyxJQUFJLElBQUksQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDO1lBQ25ELE9BQU8sRUFBRSxDQUFDLGVBQWUsQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQVcsQ0FBQyxDQUFDLENBQUM7UUFDbkYsQ0FBQztRQUNELE9BQU8sSUFBSSxDQUFDLElBQUk7YUFDYixHQUFHLENBQUMsR0FBRyxDQUFDLFVBQVUsR0FBRyxnQkFBZ0IsRUFBRTtZQUN0QyxNQUFNLEVBQUU7Z0JBQ04sSUFBSSxFQUFFLFlBQVk7YUFDbkI7U0FDRixDQUFDO2FBQ0QsSUFBSSxDQUNILEdBQUcsQ0FBQyxDQUFDLFFBQWEsRUFBRSxFQUFFLENBQUMsZUFBZSxDQUFDLFlBQVksRUFBRSxRQUFRLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFXLENBQUMsQ0FBQyxDQUM3RixDQUFDO0lBQ04sQ0FBQztJQUVELGdCQUFnQixDQUFDLEdBQVc7UUFDMUIsSUFBSSxRQUFRLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUM5QixJQUFJLHFCQUFxQixHQUFHLFFBQVEsQ0FBQyxDQUFDLENBQUMsS0FBSyxXQUFXLENBQUM7UUFDeEQsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsYUFBa0IsRUFBRSxFQUFFO1lBQzdELElBQUksTUFBTSxDQUFDO1lBQ1gsSUFBSSxxQkFBcUIsRUFBRSxDQUFDO2dCQUMxQixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsYUFBYSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDO29CQUM5QyxJQUFJLGFBQWEsR0FBRyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ3JDLE1BQU0sR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUUsQ0FBQyxRQUFRLEVBQUUsRUFBRTt3QkFDcEQsT0FBTyxRQUFRLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxDQUFDO29CQUNqQyxDQUFDLENBQUMsQ0FBQztvQkFDSCxJQUFJLE1BQU0sRUFBRSxDQUFDO3dCQUNYLE1BQU07b0JBQ1IsQ0FBQztnQkFDSCxDQUFDO1lBQ0gsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE1BQU0sR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDLFlBQVksRUFBRSxFQUFFO29CQUM5QyxPQUFPLFlBQVksQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLENBQUM7Z0JBQ3JDLENBQUMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztZQUNELElBQUksTUFBTSxFQUFFLENBQUM7Z0JBQ1gsT0FBTyxNQUFNLENBQUM7WUFDaEIsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE9BQU87WUFDVCxDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNOLENBQUM7SUFFRCxpQkFBaUIsQ0FBQyxJQUFZO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFNBQXlCLEVBQUUsRUFBRTtZQUNwRSxJQUFJLE1BQU0sR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDLFFBQWtCLEVBQUUsRUFBRTtnQkFDcEQsT0FBTyxRQUFRLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQztZQUNoQyxDQUFDLENBQUMsQ0FBQztZQUNILE9BQU8sTUFBTSxDQUFDO1FBQ2hCLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDTixDQUFDO0lBRUQsZUFBZSxDQUFDLFFBQWE7UUFDM0IsSUFBSSxRQUFRLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQztZQUN2QixtREFBbUQ7WUFDbkQsdUZBQXVGO1FBQ3pGLENBQUM7YUFBTSxDQUFDO1lBQ04sb0RBQW9EO1FBQ3RELENBQUM7SUFDSCxDQUFDO0lBRUQsZ0JBQWdCLENBQUMsWUFBcUIsS0FBSztRQUN6QyxxQ0FBcUM7UUFDckMsa0lBQWtJO1FBQ2xJLE1BQU0sR0FBRyxHQUFHLGlDQUFpQyxDQUFDO1FBQzlDLElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ25CLE9BQU8sRUFBRSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUM1QixDQUFDO1FBQ0QsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsUUFBYSxFQUFFLEVBQUU7WUFDbkQsSUFBSSxDQUFDLFNBQVMsR0FBRyxFQUFFLENBQUM7WUFDcEIsT0FBTyxDQUFDLFFBQVEsQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLFFBQWtCLEVBQUUsRUFBRTtnQkFDdkQsSUFBSSxDQUFDLFNBQVUsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEdBQUcsUUFBUSxDQUFDO1lBQzVDLENBQUMsQ0FBQyxDQUFDO1lBQ0gsT0FBTyxRQUFRLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDbEMsQ0FBQyxDQUFDLENBQ0QsQ0FBQztJQUNKLENBQUM7SUFFRCxhQUFhLENBQUMsS0FBb0IsRUFBRSxRQUFjO1FBQ2hELElBQUksVUFBVSxHQUFHLElBQUksT0FBTyxFQUFPLENBQUM7UUFDcEMsSUFBSSxPQUEyQixDQUFDO1FBQ2hDLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUNkLE9BQU8sR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUU7Z0JBQ2xFLFFBQVEsR0FBRyxNQUFNLENBQUM7Z0JBQ2xCLE9BQU8sUUFBUSxDQUFDO1lBQ2xCLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDTixDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sR0FBRyxFQUFFLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDekIsQ0FBQztRQUNELE9BQU8sQ0FBQyxTQUFTLENBQUM7WUFDaEIsSUFBSSxFQUFFLENBQUMsTUFBYyxFQUFFLEVBQUU7Z0JBQ3ZCLElBQUksS0FBSyxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsT0FBTyxFQUFFLE1BQU0sR0FBRyxDQUFDLElBQUksS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEtBQUssRUFBRSxDQUFDO29CQUMvRixNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMvRixJQUFJLFNBQVMsSUFBSSxTQUFTLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO3dCQUN0QyxLQUFLLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQzt3QkFDMUIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDO3dCQUNqRCxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO3dCQUN2QixVQUFVLENBQUMsUUFBUSxFQUFFLENBQUM7b0JBQ3hCLENBQUM7eUJBQU0sQ0FBQzt3QkFDTixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQyxTQUFTLENBQUM7NEJBQ3BGLElBQUksRUFBRSxDQUFDLE1BQVcsRUFBRSxFQUFFO2dDQUNwQixJQUFJLE1BQU0sSUFBSSxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO29DQUNoQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQztvQ0FDdkIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDO29DQUNqRCxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7b0NBQzVGLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7b0NBQ3ZCLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQ0FDeEIsQ0FBQztxQ0FBTSxDQUFDO29DQUNOLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUM7b0NBQ3BCLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQ0FDeEIsQ0FBQzs0QkFDSCxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUMsS0FBSyxFQUFFLEVBQUU7Z0NBQ2xCLFVBQVUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7NEJBQzFCLENBQUM7eUJBQ0YsQ0FBQyxDQUFDO29CQUNMLENBQUM7Z0JBQ0gsQ0FBQztxQkFBTSxDQUFDO29CQUNOLFVBQVUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQzFCLENBQUM7WUFDSCxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUMsS0FBSyxFQUFFLEVBQUU7Z0JBQ2xCLFVBQVUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDMUIsQ0FBQztTQUNGLENBQUMsQ0FBQztRQUNILE9BQU8sVUFBVSxDQUFDLFlBQVksRUFBRSxDQUFDO0lBQ25DLENBQUM7SUFFRCxxQkFBcUIsQ0FBQyxPQUFlLEVBQUUsT0FBZTtRQUNwRCxJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxhQUFhLE9BQU8sRUFBRSxDQUFDLENBQUM7UUFDN0QsSUFBSSxTQUFTLElBQUksU0FBUyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUN0QyxPQUFPLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUN2QixDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksS0FBSyxHQUFRO2dCQUNmLEtBQUssRUFBRSxnQkFBZ0I7Z0JBQ3ZCLFFBQVEsRUFBRSxZQUFZO2FBQ3ZCLENBQUM7WUFDRixLQUFLLENBQUMsWUFBWSxHQUFHLE9BQU8sQ0FBQyxHQUFHLE9BQU8sQ0FBQztZQUN4QyxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsR0FBRyxDQUFDLElBQUksV0FBVyxFQUFFLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLE1BQVcsRUFBRSxFQUFFO2dCQUN2RixJQUFJLE1BQU0sSUFBSSxNQUFNLENBQUMsY0FBYyxDQUFDLEVBQUUsQ0FBQztvQkFDckMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsWUFBWSxHQUFHLE9BQU8sRUFBRSxTQUFTLENBQUMsQ0FBQztvQkFDeEQsT0FBTyxNQUFNLENBQUMsY0FBYyxDQUFDLENBQUM7Z0JBQ2hDLENBQUM7cUJBQU0sQ0FBQztvQkFDTixPQUFPLFVBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLEtBQUssQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDLENBQUM7Z0JBQ25FLENBQUM7WUFDSCxDQUFDLENBQUMsRUFBRSxVQUFVLENBQUMsS0FBSyxDQUFDLEVBQUU7Z0JBQ3JCLE9BQU8sVUFBVSxDQUFDLEdBQUcsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ2pDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDTixDQUFDO0lBQ0gsQ0FBQztnSEE1SlUsZUFBZTt1RUFBZixlQUFlLFdBQWYsZUFBZSxtQkFGZCxNQUFNOztpRkFFUCxlQUFlO2NBSDNCLFVBQVU7ZUFBQztnQkFDVixVQUFVLEVBQUUsTUFBTTthQUNuQiIsInNvdXJjZXNDb250ZW50IjpbIi8qIENvcHlyaWdodCBzdGFydFxuICBDb3B5cmlnaHQgKEMpIDIwMDggLSAyMDI1IEZvcnRpbmV0IEluYy5cbiAgQWxsIHJpZ2h0cyByZXNlcnZlZC5cbiAgRk9SVElORVQgQ09ORklERU5USUFMICYgRk9SVElORVQgUFJPUFJJRVRBUlkgU09VUkNFIENPREVcbiAgQ29weXJpZ2h0IGVuZCAqL1xuaW1wb3J0IHsgSHR0cENsaWVudCB9IGZyb20gJ0Bhbmd1bGFyL2NvbW1vbi9odHRwJztcbmltcG9ydCB7IEluamVjdGFibGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IHBsYWluVG9JbnN0YW5jZSB9IGZyb20gJ2NsYXNzLXRyYW5zZm9ybWVyJztcbmltcG9ydCAqIGFzIF8gZnJvbSAnbG9kYXNoLWVzJztcbmltcG9ydCB7IGlzT2JqZWN0IH0gZnJvbSAnbG9kYXNoLWVzJztcbmltcG9ydCB7IGZvckVhY2ggfSBmcm9tICdsb2Rhc2gtZXMnO1xuaW1wb3J0IHsgT2JzZXJ2YWJsZSwgb2YsIHRocm93RXJyb3IsIGNhdGNoRXJyb3IsIFN1YmplY3QgfSBmcm9tICdyeGpzJztcbmltcG9ydCB7IG1hcCwgc3dpdGNoTWFwIH0gZnJvbSAncnhqcy9vcGVyYXRvcnMnO1xuaW1wb3J0IHsgQUxMX1JFQ09SRFNfU0laRSwgQVBJIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29yZS9jb25zdGFudHMnO1xuaW1wb3J0IHsgRW50aXR5IH0gZnJvbSAnLi4vLi4vLi4vLi4vY29yZS9tb2RlbHMvZW50aXR5JztcbmltcG9ydCB7IEZpZWxkIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29yZS9tb2RlbHMvZmllbGQnO1xuaW1wb3J0IHsgRW50aXR5U2VydmljZSB9IGZyb20gJy4uLy4uLy4uLy4uL2NvcmUvc2VydmljZXMvZW50aXR5LnNlcnZpY2UnO1xuaW1wb3J0IHsgTW9kZWxNZXRhZGF0YVNlcnZpY2UgfSBmcm9tICcuLi8uLi8uLi8uLi9jb3JlL3NlcnZpY2VzL21vZGVsLW1ldGFkYXRhLnNlcnZpY2UnO1xuaW1wb3J0IHsgU3RvcmFnZVNlcnZpY2UgfSBmcm9tICcuLi8uLi8uLi8uLi9jb3JlL3NlcnZpY2VzL3N0b3JhZ2Uuc2VydmljZSc7XG5pbXBvcnQgeyBTdWJzY3JpcHRpb25RdWV1ZVNlcnZpY2UgfSBmcm9tICcuLi8uLi8uLi8uLi9jb3JlL3NlcnZpY2VzL3N1YnNjcmlwdGlvbi1xdWV1ZS5zZXJ2aWNlJztcbmltcG9ydCB7IFBpY2tsaXN0RmllbGQgfSBmcm9tICcuLi8uLi8uLi9maWVsZC10eXBlcy9waWNrbGlzdCc7XG5pbXBvcnQgeyBQaWNrbGlzdCB9IGZyb20gJy4vbW9kZWxzL3BpY2tsaXN0JztcbmltcG9ydCB7IFBpY2tsaXN0TmFtZSB9IGZyb20gJy4vbW9kZWxzL3BpY2tsaXN0TmFtZSc7XG5cbkBJbmplY3RhYmxlKHtcbiAgcHJvdmlkZWRJbjogJ3Jvb3QnXG59KVxuZXhwb3J0IGNsYXNzIFBpY2tsaXN0U2VydmljZSB7XG4gIHBpY2tsaXN0czogUmVjb3JkPHN0cmluZywgUGlja2xpc3Q+IHwgbnVsbCA9IG51bGw7XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSBodHRwOiBIdHRwQ2xpZW50LFxuICAgIHByaXZhdGUgc3RvcmFnZTogU3RvcmFnZVNlcnZpY2UsXG4gICAgcHJpdmF0ZSBlbnRpdHlTZXJ2aWNlOiBFbnRpdHlTZXJ2aWNlXG4gICkgeyB9XG5cbiAgbG9hZFBpY2tsaXN0TmFtZShwaWNrbGlzdE5hbWU6IHN0cmluZyk6IE9ic2VydmFibGU8UGlja2xpc3ROYW1lPiB7XG4gICAgaWYgKHRoaXMucGlja2xpc3RzICYmIHRoaXMucGlja2xpc3RzW3BpY2tsaXN0TmFtZV0pIHtcbiAgICAgIHJldHVybiBvZihwbGFpblRvSW5zdGFuY2UoUGlja2xpc3ROYW1lLCB0aGlzLnBpY2tsaXN0c1twaWNrbGlzdE5hbWVdIGFzIG9iamVjdCkpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy5odHRwXG4gICAgICAuZ2V0KEFQSS5BUElfM19CQVNFICsgJ3BpY2tsaXN0X25hbWVzJywge1xuICAgICAgICBwYXJhbXM6IHtcbiAgICAgICAgICBuYW1lOiBwaWNrbGlzdE5hbWVcbiAgICAgICAgfVxuICAgICAgfSlcbiAgICAgIC5waXBlKFxuICAgICAgICBtYXAoKHJlc3BvbnNlOiBhbnkpID0+IHBsYWluVG9JbnN0YW5jZShQaWNrbGlzdE5hbWUsIHJlc3BvbnNlWydoeWRyYTptZW1iZXInXVswXSBhcyBvYmplY3QpKVxuICAgICAgKTtcbiAgfVxuXG4gIGdldFBpY2tsaXN0QnlJcmkoaXJpOiBzdHJpbmcpOiBPYnNlcnZhYmxlPFBpY2tsaXN0TmFtZT4ge1xuICAgIGxldCBpcmlQYXJ0cyA9IGlyaS5zcGxpdCgnLycpO1xuICAgIGxldCBnZXRDaGlsZFBpY2tsaXN0VmFsdWUgPSBpcmlQYXJ0c1szXSA9PT0gJ3BpY2tsaXN0cyc7XG4gICAgcmV0dXJuIHRoaXMubG9hZEFsbFBpY2tsaXN0cygpLnBpcGUobWFwKChwaWNrbGlzdE5hbWVzOiBhbnkpID0+IHtcbiAgICAgIGxldCByZXN1bHQ7XG4gICAgICBpZiAoZ2V0Q2hpbGRQaWNrbGlzdFZhbHVlKSB7XG4gICAgICAgIGZvciAobGV0IGkgPSAwOyBpIDwgcGlja2xpc3ROYW1lcy5sZW5ndGg7IGkrKykge1xuICAgICAgICAgIGxldCBfcGlja2xpc3ROYW1lID0gcGlja2xpc3ROYW1lc1tpXTtcbiAgICAgICAgICByZXN1bHQgPSBfLmZpbmQoX3BpY2tsaXN0TmFtZS5waWNrbGlzdHMsIChwaWNrbGlzdCkgPT4ge1xuICAgICAgICAgICAgcmV0dXJuIHBpY2tsaXN0WydAaWQnXSA9PT0gaXJpO1xuICAgICAgICAgIH0pO1xuICAgICAgICAgIGlmIChyZXN1bHQpIHtcbiAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmVzdWx0ID0gXy5maW5kKHBpY2tsaXN0TmFtZXMsIChwaWNrbGlzdE5hbWUpID0+IHtcbiAgICAgICAgICByZXR1cm4gcGlja2xpc3ROYW1lWydAaWQnXSA9PT0gaXJpO1xuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICAgIGlmIChyZXN1bHQpIHtcbiAgICAgICAgcmV0dXJuIHJlc3VsdDtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybjtcbiAgICAgIH1cbiAgICB9KSk7XG4gIH1cblxuICBnZXRQaWNrbGlzdEJ5VVVJRCh1dWlkOiBzdHJpbmcpOiBPYnNlcnZhYmxlPGFueSB8IHVuZGVmaW5lZD4ge1xuICAgIHJldHVybiB0aGlzLmxvYWRBbGxQaWNrbGlzdHMoKS5waXBlKG1hcCgocGlja2xpc3RzOiBQaWNrbGlzdE5hbWVbXSkgPT4ge1xuICAgICAgbGV0IHJlc3VsdCA9IF8uZmluZChwaWNrbGlzdHMsIChwaWNrbGlzdDogUGlja2xpc3QpID0+IHtcbiAgICAgICAgcmV0dXJuIHBpY2tsaXN0LnV1aWQgPT09IHV1aWQ7XG4gICAgICB9KTtcbiAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgfSkpO1xuICB9XG5cbiAgcmVtb3ZlRnJvbUNhY2hlKHBpY2tsaXN0OiBhbnkpIHtcbiAgICBpZiAoaXNPYmplY3QocGlja2xpc3QpKSB7XG4gICAgICAvLyB0aGlzLnN0b3JhZ2UucmVtb3ZlKCdwaWNrbGlzdHMuJytwaWNrbGlzdC5uYW1lKTtcbiAgICAgIC8vIGxvY2FsU3RvcmFnZVNlcnZpY2UucmVtb3ZlKCdwaWNrbGlzdHMuJyskZmlsdGVyKCdnZXRFbmRQYXRoTmFtZScpKHBpY2tsaXN0WydAaWQnXSkpO1xuICAgIH0gZWxzZSB7XG4gICAgICAvL2xvY2FsU3RvcmFnZVNlcnZpY2UucmVtb3ZlKCdwaWNrbGlzdHMuJytwaWNrbGlzdCk7XG4gICAgfVxuICB9XG5cbiAgbG9hZEFsbFBpY2tsaXN0cyh1c2VFeHBvcnQ6IGJvb2xlYW4gPSBmYWxzZSkge1xuICAgIC8vIFRPRE86IFBpY2tsaXN0IFVSTCBuZWVkcyB0byBjaGFuZ2VcbiAgICAvL2NvbnN0IHVybCA9IGAke0FQSS5BUElfM19CQVNFfXBpY2tsaXN0X25hbWVzPyRleHBvcnQ9JHt1c2VFeHBvcnR9JiRsaW1pdD0ke0FMTF9SRUNPUkRTX1NJWkV9JiRvcmRlcmJ5PW5hbWUmJHJlbGF0aW9uc2hpcHM9dHJ1ZWA7XG4gICAgY29uc3QgdXJsID0gJ2Fzc2V0cy9kdW1teURhdGEvcGlja2xpc3RzLmpzb24nO1xuICAgIGlmICh0aGlzLnBpY2tsaXN0cykge1xuICAgICAgcmV0dXJuIG9mKHRoaXMucGlja2xpc3RzKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuaHR0cC5nZXQodXJsKS5waXBlKG1hcCgocmVzcG9uc2U6IGFueSkgPT4ge1xuICAgICAgdGhpcy5waWNrbGlzdHMgPSB7fTtcbiAgICAgIGZvckVhY2gocmVzcG9uc2VbJ2h5ZHJhOm1lbWJlciddLCAocGlja2xpc3Q6IFBpY2tsaXN0KSA9PiB7XG4gICAgICAgIHRoaXMucGlja2xpc3RzIVtwaWNrbGlzdC5uYW1lXSA9IHBpY2tsaXN0O1xuICAgICAgfSk7XG4gICAgICByZXR1cm4gcmVzcG9uc2VbJ2h5ZHJhOm1lbWJlciddO1xuICAgIH0pXG4gICAgKTtcbiAgfVxuXG4gIGxvYWRQaWNrbGlzdHMoZmllbGQ6IFBpY2tsaXN0RmllbGQsIG1ldGFkYXRhPzogYW55KSB7XG4gICAgbGV0IHBpY2tsaXN0cyQgPSBuZXcgU3ViamVjdDxhbnk+KCk7XG4gICAgbGV0IGVudGl0eSQ6IE9ic2VydmFibGU8RW50aXR5PjtcbiAgICBpZiAoIW1ldGFkYXRhKSB7XG4gICAgICBlbnRpdHkkID0gdGhpcy5lbnRpdHlTZXJ2aWNlLmJ1aWxkKCdwaWNrbGlzdHMnKS5waXBlKG1hcCgoZW50aXR5KSA9PiB7XG4gICAgICAgIG1ldGFkYXRhID0gZW50aXR5O1xuICAgICAgICByZXR1cm4gbWV0YWRhdGE7XG4gICAgICB9KSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGVudGl0eSQgPSBvZihtZXRhZGF0YSk7XG4gICAgfVxuICAgIGVudGl0eSQuc3Vic2NyaWJlKHtcbiAgICAgIG5leHQ6IChlbnRpdHk6IEVudGl0eSkgPT4ge1xuICAgICAgICBpZiAoZmllbGQ/LmRhdGFTb3VyY2U/LnF1ZXJ5Py5maWx0ZXJzPy5sZW5ndGggPiAwICYmIGZpZWxkLmRhdGFTb3VyY2U/LnF1ZXJ5LmZpbHRlcnNbMF0/LnZhbHVlKSB7XG4gICAgICAgICAgY29uc3QgcGlja2xpc3RzID0gdGhpcy5zdG9yYWdlLmdldEl0ZW0oJ3BpY2tsaXN0cy4nICsgZmllbGQuZGF0YVNvdXJjZS5xdWVyeS5maWx0ZXJzWzBdLnZhbHVlKTtcbiAgICAgICAgICBpZiAocGlja2xpc3RzICYmIHBpY2tsaXN0cy5sZW5ndGggPiAwKSB7XG4gICAgICAgICAgICBmaWVsZC5vcHRpb25zID0gcGlja2xpc3RzO1xuICAgICAgICAgICAgdGhpcy5lbnRpdHlTZXJ2aWNlLnNldERpc3BsYXlOYW1lKGZpZWxkLCBlbnRpdHkpO1xuICAgICAgICAgICAgcGlja2xpc3RzJC5uZXh0KGZpZWxkKTtcbiAgICAgICAgICAgIHBpY2tsaXN0cyQuY29tcGxldGUoKTtcbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgdGhpcy5sb2FkUGlja2xpc3RzQnlQYXJhbXMoZmllbGQuZGF0YVNvdXJjZS5xdWVyeS5maWx0ZXJzWzBdLnZhbHVlLCAnbmFtZScpLnN1YnNjcmliZSh7XG4gICAgICAgICAgICAgIG5leHQ6IChyZXN1bHQ6IGFueSkgPT4ge1xuICAgICAgICAgICAgICAgIGlmIChyZXN1bHQgJiYgcmVzdWx0Lmxlbmd0aCA+IDApIHtcbiAgICAgICAgICAgICAgICAgIGZpZWxkLm9wdGlvbnMgPSByZXN1bHQ7XG4gICAgICAgICAgICAgICAgICB0aGlzLmVudGl0eVNlcnZpY2Uuc2V0RGlzcGxheU5hbWUoZmllbGQsIGVudGl0eSk7XG4gICAgICAgICAgICAgICAgICB0aGlzLnN0b3JhZ2Uuc2V0SXRlbSgncGlja2xpc3RzLicgKyBmaWVsZC5kYXRhU291cmNlLnF1ZXJ5LmZpbHRlcnNbMF0udmFsdWUsIGZpZWxkLm9wdGlvbnMpO1xuICAgICAgICAgICAgICAgICAgcGlja2xpc3RzJC5uZXh0KGZpZWxkKTtcbiAgICAgICAgICAgICAgICAgIHBpY2tsaXN0cyQuY29tcGxldGUoKTtcbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgcGlja2xpc3RzJC5uZXh0KHt9KTtcbiAgICAgICAgICAgICAgICAgIHBpY2tsaXN0cyQuY29tcGxldGUoKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH0sIGVycm9yOiAoZXJyb3IpID0+IHtcbiAgICAgICAgICAgICAgICBwaWNrbGlzdHMkLmVycm9yKGVycm9yKTtcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgfVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHBpY2tsaXN0cyQuZXJyb3IoZmFsc2UpO1xuICAgICAgICB9XG4gICAgICB9LCBlcnJvcjogKGVycm9yKSA9PiB7XG4gICAgICAgIHBpY2tsaXN0cyQuZXJyb3IoZXJyb3IpO1xuICAgICAgfVxuICAgIH0pO1xuICAgIHJldHVybiBwaWNrbGlzdHMkLmFzT2JzZXJ2YWJsZSgpO1xuICB9XG5cbiAgbG9hZFBpY2tsaXN0c0J5UGFyYW1zKGl0ZW1WYWw6IHN0cmluZywgaXRlbUtleTogc3RyaW5nKTogT2JzZXJ2YWJsZTxhbnk+IHtcbiAgICBsZXQgcGlja2xpc3RzID0gdGhpcy5zdG9yYWdlLmdldEl0ZW0oYHBpY2tsaXN0cy4ke2l0ZW1WYWx9YCk7XG4gICAgaWYgKHBpY2tsaXN0cyAmJiBwaWNrbGlzdHMubGVuZ3RoID4gMCkge1xuICAgICAgcmV0dXJuIG9mKHBpY2tsaXN0cyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGxldCBxdWVyeTogYW55ID0ge1xuICAgICAgICBsaW1pdDogQUxMX1JFQ09SRFNfU0laRSxcbiAgICAgICAgJG9yZGVyYnk6ICdvcmRlckluZGV4J1xuICAgICAgfTtcbiAgICAgIHF1ZXJ5WydsaXN0TmFtZV9fJyArIGl0ZW1LZXldID0gaXRlbVZhbDtcbiAgICAgIHJldHVybiB0aGlzLmh0dHAuZ2V0KGAke0FQSS5CQVNFfXBpY2tsaXN0c2AsIHsgcGFyYW1zOiBxdWVyeSB9KS5waXBlKG1hcCgocmVzdWx0OiBhbnkpID0+IHtcbiAgICAgICAgaWYgKHJlc3VsdCAmJiByZXN1bHRbJ2h5ZHJhOm1lbWJlciddKSB7XG4gICAgICAgICAgdGhpcy5zdG9yYWdlLnNldEl0ZW0oJ3BpY2tsaXN0cy4nICsgaXRlbVZhbCwgcGlja2xpc3RzKTtcbiAgICAgICAgICByZXR1cm4gcmVzdWx0WydoeWRyYTptZW1iZXInXTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICByZXR1cm4gdGhyb3dFcnJvcigoKSA9PiBuZXcgRXJyb3IoJ05vdCBhIHZhbGlkIHBpY2tsaXN0IHF1ZXJ5JykpO1xuICAgICAgICB9XG4gICAgICB9KSwgY2F0Y2hFcnJvcihlcnJvciA9PiB7XG4gICAgICAgIHJldHVybiB0aHJvd0Vycm9yKCgpID0+IGVycm9yKTtcbiAgICAgIH0pKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==