/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { CheckboxFieldComponent } from "../field-renderers/built-ins/checkbox/checkbox-field.component";
import { CheckboxViewComponent } from "../field-renderers/built-ins/checkbox/checkbox-view.component";
import { Field } from "../../core/models/field";
import { Operator } from "../../query-filters/models/operator";
import { CheckboxFloatingFilterComponent } from "../field-renderers/built-ins/checkbox/checkbox-floating-filter/checkbox-floating-filter.component";
import { CheckboxGridFilterComponent } from "../field-renderers/built-ins/checkbox/checkbox-grid-filter/checkbox-grid-filter.component";
export class CheckboxField extends Field {
    static { this.checkboxOperators = [
        new Operator('eq', 'Equals', CheckboxFieldComponent, this.evaluateEqual)
    ]; }
    static { this.operators = [...CheckboxField.checkboxOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.CHECKBOX);
        this.viewMode = 'toggle';
        this.customLabel = { labelOn: '', labelOff: '' };
        this.isFormField = true;
        this.isRelationship = false;
        this.alwaysEditMode = true;
        this.fieldComponent = CheckboxFieldComponent;
        this.viewComponent = CheckboxViewComponent;
        this.defaultColDef = {
            filter: CheckboxGridFilterComponent,
            floatingFilterComponent: CheckboxFloatingFilterComponent,
            cellRenderer: (params) => {
                let valueMappings = 'values' in params.colDef?.filterParams ? (params.colDef?.filterParams).values : {};
                return `<i class="align-middle fa fa-circle fa-lg font-size-8px ${params.value ? 'text-success' : 'text-muted muted-40'}"></i><span class="font-size-12px margin-left-8px muted-10">${params.value ? valueMappings.true || 'Checked' : valueMappings.false || 'Unchecked'}</span>`;
            },
            suppressFloatingFilterButton: true
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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