/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Field } from "../../core/models/field";
import { InputFieldComponent } from "../field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../field-renderers/built-ins/input/input-view.component";
export class DomainField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.DOMAIN);
        this.isFormField = true;
        this.isRelationship = false;
        this.placeholder = 'Example, www.fortisoar.com';
        this.validation.pattern = /^(?!:\/\/)([a-zA-Z0-9]+\.)?[a-zA-Z0-9][a-zA-Z0-9-]+\.[a-zA-Z]{2,14}?$/i;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,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