/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { InputFieldComponent } from "../field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../field-renderers/built-ins/input/input-view.component";
import { Field } from "../../core/models/field";
export class IPv4Field extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.IPv4);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,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