/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { isObject } from "lodash-es";
import { PicklistFieldComponent } from "../field-renderers/built-ins/picklist/picklist-field.component";
import { PicklistViewComponent } from "../field-renderers/built-ins/picklist/picklist-view.component";
import { Field } from "../../core/models/field";
export class PicklistField extends Field {
    static { this.operators = [...Field.equalOperators,
        ...Field.listOperators,
        ...Field.nullOperator]; }
    constructor(name, formType) {
        super(name, formType ? formType : Field.BuiltInType.PICKLIST);
        this._picklistName = '';
        this.displayConditions = {};
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = PicklistFieldComponent;
        this.viewComponent = PicklistViewComponent;
        this.alwaysEditMode = true;
    }
    set dataSource(value) {
        super.dataSource = value;
        this.model = value.model;
        this._picklistName = value.query.filters[0].value;
    }
    get picklistName() {
        return this._picklistName;
    }
    set picklistName(value) {
        this._picklistName = value;
        if (this._dataSource) {
            this._dataSource.query = {
                filters: [{
                        field: 'listName.name',
                        operator: 'eq',
                        value: value
                    }]
            };
        }
    }
    getFlatValue(value) {
        if (isObject(value)) {
            value = value['@id'];
        }
        else {
            value = value;
        }
        return value;
    }
}
//# sourceMappingURL=data:application/json;base64,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