/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { MAX_TEXT_LENGTH } from "../../core/constants";
import { Field } from "../../core/models/field";
import { RichtextHTMLFieldComponent } from "../field-renderers/built-ins/richtext-html/richtext-html-field.component";
import { RichtextHTMLViewComponent } from "../field-renderers/built-ins/richtext-html/richtext-html-view.component";
export class RichtextHTMLField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.RICHTEXTHTML);
        this.allowJinjaToggle = false;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = RichtextHTMLFieldComponent;
        this.viewComponent = RichtextHTMLViewComponent;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: MAX_TEXT_LENGTH
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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