/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Operator } from "../../query-filters/models/operator";
import { Field } from "../../core/models/field";
import { SelectFieldComponent } from "../field-renderers/built-ins/select-field/select-field.component";
import { SelectViewComponent } from "../field-renderers/built-ins/select-field/select-view.component";
export class SelectField extends Field {
    static { this.selectEqualsOperators = [
        new Operator('eq', 'Equals', SelectFieldComponent, this.evaluateEqual),
        new Operator('neq', 'Not Equals', SelectFieldComponent, this.evaluateNotEqual),
    ]; }
    static { this.operators = [...SelectField.selectEqualsOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.SELECT);
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = SelectFieldComponent;
        this.viewComponent = SelectViewComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,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