/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Field } from "../../core/models/field";
import { Operator } from "../../query-filters/models/operator";
import { TagsFieldComponent } from "../field-renderers/built-ins/tags/tags-field.component";
import { TagsViewComponent } from "../field-renderers/built-ins/tags/tags-view.component";
export class TagsField extends Field {
    static { this.operators = [
        new Operator('in', 'Is In List', TagsFieldComponent, this.evaluateIsInList),
        new Operator('nin', 'Is Not In List', TagsFieldComponent, this.evaluateIsNotInList)
    ]; }
    constructor(name, baseUrl) {
        super(name, Field.BuiltInType.TAGS);
        this.baseUrl = baseUrl;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = TagsFieldComponent;
        this.viewComponent = TagsViewComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,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