/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { ReactiveFormsModule } from '@angular/forms';
import { NgJsonEditorModule } from 'ang-jsoneditor';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { SearchableDropdownModule } from '../components/searchable-dropdown/searchable-dropdown.module';
import { CheckboxFieldComponent } from './field-renderers/built-ins/checkbox/checkbox-field.component';
import { CheckboxViewComponent } from './field-renderers/built-ins/checkbox/checkbox-view.component';
import { DatetimeViewComponent } from './field-renderers/built-ins/datetime/datetime-view/datetime-view.component';
import { EditableFieldComponent } from './field-renderers/built-ins/editable-field/editable-field.component';
import { FormFieldComponent } from './field-renderers/built-ins/form-field/form-field.component';
import { FormViewComponent } from './field-renderers/built-ins/form-view/form-view.component';
import { InputFieldComponent } from './field-renderers/built-ins/input/input-field.component';
import { InputViewComponent } from './field-renderers/built-ins/input/input-view.component';
import { LookupFieldComponent } from './field-renderers/built-ins/lookup/lookup-field.component';
import { LookupViewComponent } from './field-renderers/built-ins/lookup/lookup-view.component';
import { MultiselectFieldComponent } from './field-renderers/built-ins/multiselect/multiselect-field.component';
import { PicklistFieldComponent } from './field-renderers/built-ins/picklist/picklist-field.component';
import { PicklistViewComponent } from './field-renderers/built-ins/picklist/picklist-view.component';
import { RichtextHTMLFieldComponent } from './field-renderers/built-ins/richtext-html/richtext-html-field.component';
import { RichtextHTMLViewComponent } from './field-renderers/built-ins/richtext-html/richtext-html-view.component';
import { TextareaFieldComponent } from './field-renderers/built-ins/textarea/textarea-field.component';
import { FormMessagesComponent } from './form-messages/form-messages.component';
import { NgbDatepickerModule, NgbDropdownModule, NgbTimepickerModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { FieldRendererComponent } from './field-renderer/field-renderer.component';
import { DatetimeFieldComponent } from './field-renderers/built-ins/datetime/datetime-field/datetime-field.component';
import { SelectFieldComponent } from './field-renderers/built-ins/select-field/select-field.component';
import { SelectViewComponent } from './field-renderers/built-ins/select-field/select-view.component';
import { RadioFieldComponent } from './field-renderers/built-ins/radio/radio-field.component';
import { MultiSelectCheckboxDropdownFieldComponent } from './field-renderers/built-ins/multi-select-checkbox-dropdown/multi-select-checkbox-dropdown-field.component';
import { MultiSelectCheckboxDropdownViewComponent } from './field-renderers/built-ins/multi-select-checkbox-dropdown/multi-select-checkbox-dropdown-view.component';
import { RadioViewComponent } from './field-renderers/built-ins/radio/radio-view.component';
import { ToggleFieldComponent } from './field-renderers/built-ins/toggle/toggle-field.component';
import { ToggleViewComponent } from './field-renderers/built-ins/toggle/toggle-view.component';
import { ToggleDropdownFieldComponent } from './field-renderers/built-ins/toggle-dropdown/toggle-dropdown-field.component';
import { JsonEditorFieldComponent } from './field-renderers/built-ins/json-editor-field/json-editor-field.component';
import { DatetimeFloatingFilterComponent } from './field-renderers/built-ins/datetime/datetime-floating-filter/datetime-floating-filter.component';
import { SlideToggleComponent } from '../components/slide-toggle/slide-toggle.component';
import { LookupFloatingFilterComponent } from './field-renderers/built-ins/lookup/lookup-floating-filter/lookup-floating-filter.component';
import { LookupGridFilterComponent } from './field-renderers/built-ins/lookup/lookup-grid-filter/lookup-grid-filter.component';
import { HtmlEditorModule } from './field-renderers/built-ins/richtext-html/html-editor-module/editor.module';
import { TagsFieldComponent } from './field-renderers/built-ins/tags/tags-field.component';
import { TagsViewComponent } from './field-renderers/built-ins/tags/tags-view.component';
import { TagsInputComponent } from '../components/tags-input/tags-input.component';
import { CheckboxGridFilterComponent } from './field-renderers/built-ins/checkbox/checkbox-grid-filter/checkbox-grid-filter.component';
import { CheckboxFloatingFilterComponent } from './field-renderers/built-ins/checkbox/checkbox-floating-filter/checkbox-floating-filter.component';
import { TranslocoModule } from '@jsverse/transloco';
import { RichtextMarkdownFieldComponent } from './field-renderers/built-ins/richtext-markdown/richtext-markdown-field.component';
import { UtilityModule } from '../utility/utility.module';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "../components/tags-input/tags-input.component";
export class XFFormFieldsModule {
    static { this.ɵfac = function XFFormFieldsModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || XFFormFieldsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: XFFormFieldsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            UtilityModule,
            ReactiveFormsModule,
            SearchableDropdownModule,
            NgMultiSelectDropDownModule,
            NgbTooltipModule,
            NgbDatepickerModule,
            NgbTimepickerModule,
            NgbDropdownModule,
            NgJsonEditorModule,
            SlideToggleComponent,
            HtmlEditorModule,
            TagsInputComponent,
            TranslocoModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(XFFormFieldsModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    CheckboxFieldComponent,
                    CheckboxViewComponent,
                    CheckboxGridFilterComponent,
                    CheckboxFloatingFilterComponent,
                    FormFieldComponent,
                    InputFieldComponent,
                    InputViewComponent,
                    FormMessagesComponent,
                    FormViewComponent,
                    LookupFieldComponent,
                    LookupViewComponent,
                    LookupFloatingFilterComponent,
                    LookupGridFilterComponent,
                    PicklistFieldComponent,
                    PicklistViewComponent,
                    TextareaFieldComponent,
                    RichtextHTMLFieldComponent,
                    RichtextHTMLViewComponent,
                    EditableFieldComponent,
                    MultiselectFieldComponent,
                    FieldRendererComponent,
                    SelectFieldComponent,
                    SelectViewComponent,
                    DatetimeFieldComponent,
                    DatetimeViewComponent,
                    DatetimeFloatingFilterComponent,
                    RadioFieldComponent,
                    RadioViewComponent,
                    TagsFieldComponent,
                    TagsViewComponent,
                    ToggleViewComponent,
                    ToggleFieldComponent,
                    MultiSelectCheckboxDropdownFieldComponent,
                    MultiSelectCheckboxDropdownViewComponent,
                    ToggleDropdownFieldComponent,
                    JsonEditorFieldComponent,
                    RichtextMarkdownFieldComponent
                ],
                imports: [
                    CommonModule,
                    UtilityModule,
                    ReactiveFormsModule,
                    SearchableDropdownModule,
                    NgMultiSelectDropDownModule,
                    NgbTooltipModule,
                    NgbDatepickerModule,
                    NgbTimepickerModule,
                    NgbDropdownModule,
                    NgJsonEditorModule,
                    SlideToggleComponent,
                    HtmlEditorModule,
                    TagsInputComponent,
                    TranslocoModule
                ],
                exports: [
                    PicklistFieldComponent,
                    LookupFieldComponent,
                    LookupFloatingFilterComponent,
                    LookupGridFilterComponent,
                    CheckboxFieldComponent,
                    CheckboxGridFilterComponent,
                    CheckboxFloatingFilterComponent,
                    InputFieldComponent,
                    FormFieldComponent,
                    FormViewComponent,
                    EditableFieldComponent,
                    FormMessagesComponent,
                    MultiselectFieldComponent,
                    SelectFieldComponent,
                    SelectViewComponent,
                    FieldRendererComponent,
                    DatetimeFieldComponent,
                    DatetimeViewComponent,
                    DatetimeFloatingFilterComponent,
                    RadioFieldComponent,
                    RadioViewComponent,
                    JsonEditorFieldComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(XFFormFieldsModule, { declarations: [CheckboxFieldComponent,
        CheckboxViewComponent,
        CheckboxGridFilterComponent,
        CheckboxFloatingFilterComponent,
        FormFieldComponent,
        InputFieldComponent,
        InputViewComponent,
        FormMessagesComponent,
        FormViewComponent,
        LookupFieldComponent,
        LookupViewComponent,
        LookupFloatingFilterComponent,
        LookupGridFilterComponent,
        PicklistFieldComponent,
        PicklistViewComponent,
        TextareaFieldComponent,
        RichtextHTMLFieldComponent,
        RichtextHTMLViewComponent,
        EditableFieldComponent,
        MultiselectFieldComponent,
        FieldRendererComponent,
        SelectFieldComponent,
        SelectViewComponent,
        DatetimeFieldComponent,
        DatetimeViewComponent,
        DatetimeFloatingFilterComponent,
        RadioFieldComponent,
        RadioViewComponent,
        TagsFieldComponent,
        TagsViewComponent,
        ToggleViewComponent,
        ToggleFieldComponent,
        MultiSelectCheckboxDropdownFieldComponent,
        MultiSelectCheckboxDropdownViewComponent,
        ToggleDropdownFieldComponent,
        JsonEditorFieldComponent,
        RichtextMarkdownFieldComponent], imports: [CommonModule,
        UtilityModule,
        ReactiveFormsModule,
        SearchableDropdownModule,
        NgMultiSelectDropDownModule,
        NgbTooltipModule,
        NgbDatepickerModule,
        NgbTimepickerModule,
        NgbDropdownModule,
        NgJsonEditorModule,
        SlideToggleComponent,
        HtmlEditorModule,
        TagsInputComponent,
        TranslocoModule], exports: [PicklistFieldComponent,
        LookupFieldComponent,
        LookupFloatingFilterComponent,
        LookupGridFilterComponent,
        CheckboxFieldComponent,
        CheckboxGridFilterComponent,
        CheckboxFloatingFilterComponent,
        InputFieldComponent,
        FormFieldComponent,
        FormViewComponent,
        EditableFieldComponent,
        FormMessagesComponent,
        MultiselectFieldComponent,
        SelectFieldComponent,
        SelectViewComponent,
        FieldRendererComponent,
        DatetimeFieldComponent,
        DatetimeViewComponent,
        DatetimeFloatingFilterComponent,
        RadioFieldComponent,
        RadioViewComponent,
        JsonEditorFieldComponent] }); })();
i0.ɵɵsetComponentScope(LookupFloatingFilterComponent, [i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FormFieldComponent], []);
i0.ɵɵsetComponentScope(TagsFieldComponent, [i1.NgClass, i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, i4.TagsInputComponent, FormMessagesComponent], []);
//# sourceMappingURL=data:application/json;base64,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