/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, forwardRef, Input, ViewChildren } from '@angular/core';
import { FormControl, NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import { Filter } from '../models/filter';
import { FilterGroup } from '../models/filter-group';
import { map } from 'rxjs';
import { compact } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/common";
import * as i3 from "../filter/filter.component";
const _c0 = ["filterComponent"];
const _c1 = ["entity", ""];
const _c2 = (a0, a1) => ({ "margin-top-16px": a0, "border-start ms-0": a1 });
function FilterGroupComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 13);
    i0.ɵɵtext(1, "Filter Conditions");
    i0.ɵɵelementEnd();
} }
function FilterGroupComponent_div_0_label_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 14);
    i0.ɵɵtext(1, "Where");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "field-" + ctx_r1.depth);
} }
function FilterGroupComponent_div_0_select_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "select", 15)(1, "option");
    i0.ɵɵtext(2, "AND");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "option");
    i0.ɵɵtext(4, "OR");
    i0.ɵɵelementEnd()();
} }
function FilterGroupComponent_div_0_div_7_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-filter-group", 18, 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const filterIndex_r3 = i0.ɵɵnextContext().index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.entity)("formControlName", filterIndex_r3)("depth", ctx_r1.depth + 1);
} }
function FilterGroupComponent_div_0_div_7_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-filter", 19, 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const filterIndex_r3 = i0.ɵɵnextContext().index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.entity)("formControlName", filterIndex_r3);
} }
function FilterGroupComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtemplate(1, FilterGroupComponent_div_0_div_7_ng_container_1_Template, 3, 3, "ng-container", 17)(2, FilterGroupComponent_div_0_div_7_ng_container_2_Template, 3, 2, "ng-container", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const formControl_r4 = ctx.$implicit;
    const filterIndex_r3 = ctx.index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(3, _c2, filterIndex_r3 > 0, ctx_r1.depth > 0));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", formControl_r4.value == null ? null : formControl_r4.value.filters == null ? null : formControl_r4.value.filters.length);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !(formControl_r4.value == null ? null : formControl_r4.value.filters == null ? null : formControl_r4.value.filters.length));
} }
function FilterGroupComponent_div_0_button_11_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 20);
    i0.ɵɵlistener("click", function FilterGroupComponent_div_0_button_11_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.addFilter(true)); });
    i0.ɵɵtext(1, "+ Add Group");
    i0.ɵɵelementEnd();
} }
function FilterGroupComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, FilterGroupComponent_div_0_label_1_Template, 2, 0, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5);
    i0.ɵɵtemplate(4, FilterGroupComponent_div_0_label_4_Template, 2, 1, "label", 6)(5, FilterGroupComponent_div_0_select_5_Template, 5, 0, "select", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "div", 8);
    i0.ɵɵtemplate(7, FilterGroupComponent_div_0_div_7_Template, 3, 6, "div", 9);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(8, "div", 10)(9, "button", 11);
    i0.ɵɵlistener("click", function FilterGroupComponent_div_0_Template_button_click_9_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.addFilter()); });
    i0.ɵɵtext(10, "+ Add Condition");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(11, FilterGroupComponent_div_0_button_11_Template, 2, 0, "button", 12);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.depth === 0);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r1.filtersFormArray.controls.length === 1);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.filtersFormArray.controls.length > 1);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.filtersFormArray.controls);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngIf", ctx_r1.depth < 2);
} }
export class FilterGroupComponent {
    constructor(changeDetectorRef, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.depth = 0;
        this.FilterGroup = FilterGroup;
        this.Filter = Filter;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.filtersFormArray = this.formBuilder.array([]);
        this.formGroup = this.formBuilder.group({
            logic: new FormControl('AND'),
            filters: this.filtersFormArray
        });
        this.formGroup.valueChanges.pipe(map((values) => {
            if (this.value) {
                this.value.logic = values.logic;
                values.filters.forEach((filter, filterIndex) => {
                    if (!filter) {
                        this.filtersFormArray.removeAt(filterIndex);
                    }
                });
                this.value.filters = compact(values.filters);
            }
            if (this.depth === 0 || this.value?.filters.length) {
                this.onChange(this.value);
            }
            else {
                // Remove the group if all filters are deleted
                this.onChange(null);
            }
            this.changeDetectorRef.detectChanges();
        })).subscribe();
    }
    writeValue(value) {
        // Clear it first
        while (this.filtersFormArray.length !== 0) {
            this.filtersFormArray.removeAt(0);
        }
        value?.filters.forEach((filter) => {
            this.filtersFormArray.push(new FormControl(filter));
        });
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    addFilter(group = false) {
        const newFilter = new Filter();
        const filter = group ? new FilterGroup([newFilter], 'AND') : newFilter;
        this.filtersFormArray.push(new FormControl(filter), {
            emitEvent: false
        });
        setTimeout(() => this.onChange(this.value));
    }
    validate(control) {
        return this.formGroup.invalid ? {
            required: true
        } : null;
    }
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        for (let filterComponent of this.filterComponents) {
            if (filterComponent.focusOnFirstInvalidInput()) {
                return true;
            }
        }
        return false;
    }
    static { this.ɵfac = function FilterGroupComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterGroupComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FilterGroupComponent, selectors: [["xf-filter-group", "entity", ""]], viewQuery: function FilterGroupComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.filterComponents = _t);
        } }, inputs: { entity: "entity", depth: "depth" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FilterGroupComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FilterGroupComponent),
                    multi: true
                }])], attrs: _c1, decls: 1, vars: 1, consts: [["filterComponent", ""], [3, "formGroup", 4, "ngIf"], [3, "formGroup"], ["class", "form-label", 4, "ngIf"], [1, "d-flex"], [1, "w-80px", "d-flex", "align-items-start"], ["class", "col-form-label font-size-14px mx-2", 3, "for", 4, "ngIf"], ["formControlName", "logic", "class", "form-select w-auto form-select-sm", 4, "ngIf"], ["formArrayName", "filters", 1, "flex-grow-1"], [3, "ngClass", 4, "ngFor", "ngForOf"], [1, "btn-group", "margin-top-16px"], ["type", "button", 1, "btn", "btn-link", "btn-xs", "p-0", "margin-right-12px", 3, "click"], ["type", "button", "class", "btn btn-link btn-xs p-0", 3, "click", 4, "ngIf"], [1, "form-label"], [1, "col-form-label", "font-size-14px", "mx-2", 3, "for"], ["formControlName", "logic", 1, "form-select", "w-auto", "form-select-sm"], [3, "ngClass"], [4, "ngIf"], [3, "entity", "formControlName", "depth"], [3, "entity", "formControlName"], ["type", "button", 1, "btn", "btn-link", "btn-xs", "p-0", 3, "click"]], template: function FilterGroupComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FilterGroupComponent_div_0_Template, 12, 6, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.value);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, i1.NgSelectOption, i1.ɵNgSelectMultipleOption, i1.SelectControlValueAccessor, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName, i1.FormArrayName, FilterGroupComponent, i3.FilterComponent], styles: [".w-120px[_ngcontent-%COMP%]{width:120px}.select-block[_ngcontent-%COMP%]{border:1px solid var(--element-default-border-color);border-radius:3px;color:var(--btn-select-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterGroupComponent, [{
        type: Component,
        args: [{ selector: 'xf-filter-group[entity]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FilterGroupComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FilterGroupComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *ngIf=\"value\" [formGroup]=\"formGroup\">\n  <label class=\"form-label\" *ngIf=\"depth === 0\">Filter Conditions</label>\n  <div class=\"d-flex\">\n    <div class=\"w-80px d-flex align-items-start\">\n      <label [for]=\"'field-' + depth\" class=\"col-form-label font-size-14px mx-2\"\n        *ngIf=\"filtersFormArray.controls.length === 1\">Where</label>\n      <select formControlName=\"logic\" class=\"form-select w-auto form-select-sm\" *ngIf=\"filtersFormArray.controls.length > 1\">\n        <option>AND</option>\n        <option>OR</option>\n      </select>\n    </div>\n    <div formArrayName=\"filters\" class=\"flex-grow-1\">\n      <div [ngClass]=\"{'margin-top-16px': filterIndex > 0, 'border-start ms-0': depth > 0}\"\n        *ngFor=\"let formControl of filtersFormArray.controls; let filterIndex = index\">\n        <!-- <span class=\"content-font padding-bottom-6px padding-left-16px padding-right-16px padding-top-6px select-block\" *ngIf=\"filterIndex > 1\">{{\n          value.logic }}</span> -->\n        <ng-container *ngIf=\"$any(formControl.value)?.filters?.length\">\n          <xf-filter-group [entity]=\"entity\" [formControlName]=\"filterIndex\" [depth]=\"depth + 1\" #filterComponent></xf-filter-group>\n        </ng-container>\n        <ng-container *ngIf=\"!$any(formControl.value)?.filters?.length\">\n          <xf-filter [entity]=\"entity\" [formControlName]=\"filterIndex\" #filterComponent></xf-filter>\n        </ng-container>\n      </div>\n    </div>\n  </div>\n  <div class=\"btn-group margin-top-16px\">\n    <button type=\"button\" class=\"btn btn-link btn-xs p-0 margin-right-12px\" (click)=\"addFilter()\">+ Add\n      Condition</button>\n    <button type=\"button\" class=\"btn btn-link btn-xs p-0\" (click)=\"addFilter(true)\" *ngIf=\"depth < 2\">+ Add\n      Group</button>\n  </div>\n\n</div>\n", styles: [".w-120px{width:120px}.select-block{border:1px solid var(--element-default-border-color);border-radius:3px;color:var(--btn-select-color)}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.FormBuilder }], { filterComponents: [{
            type: ViewChildren,
            args: ['filterComponent']
        }], entity: [{
            type: Input
        }], depth: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FilterGroupComponent, { className: "FilterGroupComponent", filePath: "lib/query-filters/filter-group/filter-group.component.ts", lineNumber: 30 }); })();
//# sourceMappingURL=data:application/json;base64,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