/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, forwardRef, Input, ViewChild } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR, Validators } from '@angular/forms';
import { of } from 'rxjs';
import { map } from 'rxjs/operators';
import { Filter } from '../models/filter';
import { FieldOptions } from '../../form-fields/models/field-options';
import { SearchableDropdownComponent } from '../../components/searchable-dropdown/searchable-dropdown.component';
import { InputFieldComponent } from '../../form-fields/field-renderers/built-ins/input/input-field.component';
import { ViewContainerDirective } from '../../utility/directives/view-container.directive';
import { cloneDeep, isString } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "../../core/services/entity.service";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "../../utility/directives/view-container.directive";
import * as i5 from "../../components/searchable-dropdown/searchable-dropdown.component";
const _c0 = ["formField"];
const _c1 = ["filterField"];
function FilterComponent_Conditional_6_option_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 12);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const operator_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", operator_r2.id);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(operator_r2.title);
} }
function FilterComponent_Conditional_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "select", 6);
    i0.ɵɵtemplate(1, FilterComponent_Conditional_6_option_1_Template, 2, 2, "option", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.field.operators);
} }
function FilterComponent_Conditional_8_ng_template_0_Template(rf, ctx) { }
function FilterComponent_Conditional_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, FilterComponent_Conditional_8_ng_template_0_Template, 0, 0, "ng-template", 7);
} }
function FilterComponent_Conditional_10_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 13);
    i0.ɵɵlistener("click", function FilterComponent_Conditional_10_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.deleteFilter()); });
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} }
function FilterComponent_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 10);
    i0.ɵɵelement(1, "xf-filter", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r2.subEntity)("isChild", true);
} }
export class FilterComponent {
    constructor(changeDetectorRef, entityService, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.formBuilder = formBuilder;
        this.isChild = false;
        this.items = [];
        this.field = null;
        this.fieldRenderer = null;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.value = new Filter();
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
        this.formGroup = this.formBuilder.group({
            filterField: [null, Validators.required],
            operator: [null, Validators.required],
            value: [null],
            subDataFilter: [null]
        });
    }
    writeValue(value) {
        this.value = value || new Filter();
        let field = this.value.field;
        let subFilter = null;
        if (this.value.field && this.value.field?.indexOf('.') > -1) {
            const parts = this.value.field.split('.');
            field = parts[0];
            parts.shift();
            subFilter = cloneDeep(value);
            subFilter.field = parts.join('.');
            this.formGroup.controls.operator.clearValidators();
        }
        else {
            this.formGroup.controls.operator.setValidators(Validators.required);
        }
        this.fieldValue = field && this.entity.fields[field] ? this.entity.fields[field].asSearchableItem() : null;
        if (this.fieldValue) {
            this.setField(this.fieldValue.value);
        }
        this.formGroup.setValue({
            filterField: this.fieldValue,
            operator: this.value.operator,
            value: this.value.originalValue || this.value.value,
            subDataFilter: subFilter
        }, {
            emitEvent: false
        });
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnInit() {
        this.formGroup.controls.operator.valueChanges.subscribe((value) => this.operatorChanged(value));
        this.formGroup.controls.value.valueChanges.subscribe((value) => this.valueChanged(value));
        this.formGroup.controls.filterField.valueChanges.subscribe((value) => {
            this.fieldValue = value;
            this.fieldChanged();
        });
        this.formGroup.controls.subDataFilter.valueChanges.subscribe((value) => {
            if (!value) {
                this.onChange(null);
                return;
            }
            let fullValue = cloneDeep(value);
            fullValue.field = this.field?.name + '.' + value.field;
            this.value = fullValue;
            this.onChange(fullValue);
        });
        this.filterFields('');
    }
    filterFields(search) {
        of(this.entity.attributes).pipe(map((fields) => {
            return fields.map((field) => field.asSearchableItem());
        }), map((items) => {
            return items.filter((item) => {
                return isString(item.display) && item.display.toLowerCase().indexOf(search.toLowerCase()) > -1;
            });
        })).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    setField(field) {
        if (field && this.entity.fields[field.name].formType !== field.formType) {
            // Reset view
            this.field = null;
            this.fieldRenderer = null;
            this.changeDetectorRef.detectChanges();
        }
        this.field = field;
        if (field.data) {
            this.subEntity = this.entityService.createEntityFromData(field.data, 'sub-field-' + field.name);
            this.changeDetectorRef.detectChanges();
            return;
        }
        else {
            this.subEntity = undefined;
            this.changeDetectorRef.detectChanges();
        }
        if (this.value.operator) {
            const operator = this.field?.getOperator(this.value.operator);
            this.setRenderer(operator);
        }
        else {
            const defaultOperator = field.operators[0];
            this.setRenderer(defaultOperator);
            this.formGroup.controls.operator.setValue(defaultOperator.id);
        }
        this.changeDetectorRef.detectChanges();
    }
    fieldChanged() {
        if (!this.fieldValue) {
            return;
        }
        this.value.operator = null;
        this.value.field = this.fieldValue.value.name;
        this.setField(this.fieldValue.value);
        this.onChange(this.value);
    }
    operatorChanged(newOperatorId) {
        const operator = this.field?.getOperator(newOperatorId);
        this.value.operator = operator?.id || null;
        this.setRenderer(operator);
        this.onChange(this.value);
    }
    setRenderer(operator) {
        if (operator?.renderer) {
            this.fieldRenderer = operator.renderer;
        }
        else {
            this.fieldRenderer = InputFieldComponent;
        }
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        if (!this.field) {
            return;
        }
        let field = cloneDeep(this.field);
        field.name = field.name + '-renderer';
        this.componentRef = viewContainerRef.createComponent(this.fieldRenderer);
        this.componentRef.instance.field = field;
        this.componentRef.instance.fieldClass = 'form-control-sm';
        this.componentRef.instance.fieldOptions = this.fieldOptions;
        this.componentRef.instance.writeValue(this.value.value);
        this.componentRef.instance.onChange = (value) => this.valueChanged(value);
        if (!this.value.value && this.field.defaultValue) {
            this.componentRef.instance.value = this.field.defaultValue;
        }
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    valueChanged(value) {
        this.value.originalValue = value;
        this.value.value = this.field?.getFlatValue(value, this.field?.operators.find((operator) => this.value.operator === operator.id));
        this.onChange(this.value);
    }
    deleteFilter() {
        this.onChange(null);
    }
    validate(control) {
        return !this.value?.operator || !this.value?.field ? {
            required: true
        } : null;
    }
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        if (this.filterField.invalid) {
            this.filterField.setTouched();
            this.filterField.focus();
            return true;
        }
        return false;
    }
    static { this.ɵfac = function FilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FilterComponent, selectors: [["xf-filter"]], viewQuery: function FilterComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(_c1, 5);
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.filterField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.fieldSelect = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { entity: "entity", isChild: "isChild" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FilterComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FilterComponent),
                    multi: true
                }])], decls: 12, vars: 6, consts: [["filterField", ""], [3, "formGroup"], [1, "d-flex", "align-items-center"], [1, "col", "pe-1"], ["buttonStyle", "select", "formControlName", "filterField", "placeholder", "Select Field", 3, "searchQueryChange", "items"], [1, "col", "px-1"], ["formControlName", "operator", 1, "form-select", "form-select-sm"], ["xfViewContainer", ""], [1, "col", "col-delete", "ps-1"], ["type", "button", 1, "btn", "btn-sm", "btn-outline"], [1, "mt-2"], [3, "ngValue", 4, "ngFor", "ngForOf"], [3, "ngValue"], ["type", "button", 1, "btn", "btn-sm", "btn-outline", 3, "click"], [1, "fa", "fa-close", "text-danger"], ["formControlName", "subDataFilter", 3, "entity", "isChild"]], template: function FilterComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2)(2, "div", 3)(3, "xf-searchable-dropdown", 4, 0);
            i0.ɵɵlistener("searchQueryChange", function FilterComponent_Template_xf_searchable_dropdown_searchQueryChange_3_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.filterFields($event)); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5);
            i0.ɵɵtemplate(6, FilterComponent_Conditional_6_Template, 2, 1, "select", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(7, "div", 5);
            i0.ɵɵtemplate(8, FilterComponent_Conditional_8_Template, 1, 0, null, 7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(9, "div", 8);
            i0.ɵɵtemplate(10, FilterComponent_Conditional_10_Template, 2, 0, "button", 9);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(11, FilterComponent_Conditional_11_Template, 2, 2, "div", 10);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("items", ctx.items);
            i0.ɵɵadvance(3);
            i0.ɵɵconditional(ctx.field && !ctx.subEntity ? 6 : -1);
            i0.ɵɵadvance(2);
            i0.ɵɵconditional(!ctx.subEntity ? 8 : -1);
            i0.ɵɵadvance(2);
            i0.ɵɵconditional(!ctx.isChild ? 10 : -1);
            i0.ɵɵadvance();
            i0.ɵɵconditional(ctx.field && ctx.subEntity ? 11 : -1);
        } }, dependencies: [i3.NgForOf, i4.ViewContainerDirective, i5.SearchableDropdownComponent, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FilterComponent], styles: [".col-delete[_ngcontent-%COMP%]{flex:0 0 0}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-filter', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FilterComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FilterComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div [formGroup]=\"formGroup\">\n  <div class=\"d-flex align-items-center\">\n    <div class=\"col pe-1\">\n      <xf-searchable-dropdown #filterField buttonStyle=\"select\" formControlName=\"filterField\" [items]=\"items\"\n      placeholder=\"Select Field\" (searchQueryChange)=\"filterFields($event)\"></xf-searchable-dropdown>\n    </div>\n    <div class=\"col px-1\">\n      @if (field && !subEntity) {\n        <select class=\"form-select form-select-sm\" formControlName=\"operator\">\n          <option *ngFor=\"let operator of field.operators\" [ngValue]=\"operator.id\">{{ operator.title }}</option>\n        </select>\n      }\n    </div>\n    <div class=\"col px-1\">\n      @if (!subEntity) {\n        <!-- <xf-form-field *ngIf=\"fieldRenderer\" formControlName=\"value\" [field]=\"fieldRenderer\" [fieldOptions]=\"fieldOptions\" [fieldClass]=\"'form-control-sm'\" #formField></xf-form-field> -->\n        <ng-template xfViewContainer></ng-template>\n      }\n    </div>\n    <div class=\"col col-delete ps-1\">\n      @if (!isChild) {\n        <button type=\"button\" class=\"btn btn-sm btn-outline\" (click)=\"deleteFilter()\">\n          <i class=\"fa fa-close text-danger\"></i>\n        </button>\n      }\n    </div>\n  </div>\n  @if (field && subEntity) {\n    <div class=\"mt-2\">\n      <xf-filter [entity]=\"subEntity\" formControlName=\"subDataFilter\" [isChild]=\"true\"></xf-filter>\n    </div>\n  }\n\n</div>\n", styles: [".col-delete{flex:0 0 0}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.EntityService }, { type: i2.FormBuilder }], { entity: [{
            type: Input
        }], isChild: [{
            type: Input
        }], formField: [{
            type: ViewChild,
            args: ['formField', { static: false }]
        }], filterField: [{
            type: ViewChild,
            args: ['filterField', { static: false }]
        }], fieldSelect: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }], xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FilterComponent, { className: "FilterComponent", filePath: "lib/query-filters/filter/filter.component.ts", lineNumber: 38 }); })();
//# sourceMappingURL=data:application/json;base64,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