/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Directive, Output, EventEmitter, HostListener } from '@angular/core';
import * as i0 from "@angular/core";
export class ScrollTrackerDirective {
    constructor() {
        this.scrollingFinished = new EventEmitter();
        this.emitted = false;
    }
    onScroll(event) {
        if ((window.innerHeight + window.scrollY) >= document.body.scrollHeight && !this.emitted) {
            this.emitted = true;
            this.scrollingFinished.emit();
        }
        else if ((window.innerHeight + window.scrollY) < document.body.scrollHeight) {
            this.emitted = false;
        }
    }
    static { this.ɵfac = function ScrollTrackerDirective_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScrollTrackerDirective)(); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: ScrollTrackerDirective, selectors: [["", "scrollTracker", ""]], hostBindings: function ScrollTrackerDirective_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("scroll", function ScrollTrackerDirective_scroll_HostBindingHandler($event) { return ctx.onScroll($event); }, false, i0.ɵɵresolveWindow);
        } }, outputs: { scrollingFinished: "scrollingFinished" } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScrollTrackerDirective, [{
        type: Directive,
        args: [{
                selector: '[scrollTracker]'
            }]
    }], null, { scrollingFinished: [{
            type: Output
        }], onScroll: [{
            type: HostListener,
            args: ['window:scroll', ['$event']]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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