/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable, Pipe } from '@angular/core';
import { cloneDeep } from 'lodash-es';
import * as i0 from "@angular/core";
export class GetEndPathNamePipe {
    transform(input) {
        if (typeof (input) === 'string') {
            let inputStr = cloneDeep(input);
            if (input.charAt(input.length - 1) === '/') {
                inputStr = inputStr.slice(0, -1);
            }
            var parameters = inputStr.split('/');
            var lastIndex = parameters.length - 1;
            return parameters[lastIndex].split('?')[0];
        }
        return input;
    }
    static { this.ɵfac = function GetEndPathNamePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GetEndPathNamePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "getEndPathName", type: GetEndPathNamePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GetEndPathNamePipe, factory: GetEndPathNamePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GetEndPathNamePipe, [{
        type: Pipe,
        args: [{
                name: 'getEndPathName'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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