/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Pipe, SecurityContext, inject } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import * as i0 from "@angular/core";
export class HighlightPipe {
    constructor() {
        this.domSanitizer = inject(DomSanitizer);
    }
    transform(input, searchText) {
        if (!searchText) {
            return input; // If no search term, return the input unchanged
        }
        // Split the searchText into words and escape them for regex
        const searchWords = searchText.split(' ').map(word => word.trim()).filter(word => word.length > 0);
        const regex = new RegExp(`(${searchWords.join('|')})`, 'gi');
        // Replace matched words with highlighted version
        input = input.replace(regex, match => `<mark class='highlighted-result p-0'>${match}</mark>`);
        const sanitized = this.domSanitizer.sanitize(SecurityContext.HTML, input) || '';
        return sanitized;
    }
    static { this.ɵfac = function HighlightPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || HighlightPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "highlight", type: HighlightPipe, pure: true }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(HighlightPipe, [{
        type: Pipe,
        args: [{
                name: 'highlight'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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