/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable, Pipe } from '@angular/core';
import * as i0 from "@angular/core";
/**
 * Changes camel case to a human readable format. So helloWorld, hello-world and hello_world becomes "Hello World".
 * */
export class humanizePipe {
    transform(value = '') {
        var output = "";
        var len = value.length;
        var char;
        for (var i = 0; i < len; i++) {
            char = value.charAt(i);
            if (i == 0) {
                output += char.toUpperCase();
            }
            else if (char !== char.toLowerCase() && char === char.toUpperCase() && value.charAt(i - 1) === value.charAt(i - 1).toLowerCase()) {
                output += " " + char;
            }
            else if (char == "-" || char == "_" || char == ".") {
                output += " ";
            }
            else {
                let previousChar = value.charAt(i - 1);
                if (previousChar == "-" || previousChar == "_" || previousChar == ".") {
                    output += char.toUpperCase();
                }
                else {
                    output += char;
                }
            }
        }
        return output;
    }
    static { this.ɵfac = function humanizePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || humanizePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "humanize", type: humanizePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: humanizePipe, factory: humanizePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(humanizePipe, [{
        type: Pipe,
        args: [{
                name: 'humanize'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHVtYW5pemUucGlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zcmMvbGliL3V0aWxpdHkvcGlwZXMvaHVtYW5pemUucGlwZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7OztrQkFJa0I7QUFDbEIsT0FBTyxFQUFFLFVBQVUsRUFBRSxJQUFJLEVBQWlCLE1BQU0sZUFBZSxDQUFDOztBQVFoRTs7S0FFSztBQUNMLE1BQU0sT0FBTyxZQUFZO0lBRXZCLFNBQVMsQ0FBQyxRQUFnQixFQUFFO1FBQzFCLElBQUksTUFBTSxHQUFHLEVBQUUsQ0FBQztRQUNoQixJQUFJLEdBQUcsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1FBQ3ZCLElBQUksSUFBSSxDQUFDO1FBRVQsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLEdBQUcsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDO1lBQzdCLElBQUksR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBRXZCLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO2dCQUNYLE1BQU0sSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7WUFDL0IsQ0FBQztpQkFDSSxJQUFJLElBQUksS0FBSyxJQUFJLENBQUMsV0FBVyxFQUFFLElBQUksSUFBSSxLQUFLLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBQyxDQUFDLENBQUMsS0FBSyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBQyxDQUFDLENBQUMsQ0FBQyxXQUFXLEVBQUUsRUFBRSxDQUFDO2dCQUM3SCxNQUFNLElBQUksR0FBRyxHQUFHLElBQUksQ0FBQztZQUN2QixDQUFDO2lCQUNJLElBQUksSUFBSSxJQUFJLEdBQUcsSUFBSSxJQUFJLElBQUksR0FBRyxJQUFJLElBQUksSUFBSSxHQUFHLEVBQUUsQ0FBQztnQkFDbkQsTUFBTSxJQUFJLEdBQUcsQ0FBQztZQUNoQixDQUFDO2lCQUNJLENBQUM7Z0JBQ0osSUFBSSxZQUFZLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUMsQ0FBQyxDQUFDLENBQUM7Z0JBQ3JDLElBQUcsWUFBWSxJQUFJLEdBQUcsSUFBSSxZQUFZLElBQUksR0FBRyxJQUFJLFlBQVksSUFBSSxHQUFHLEVBQUMsQ0FBQztvQkFDcEUsTUFBTSxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztnQkFDL0IsQ0FBQztxQkFBSSxDQUFDO29CQUNKLE1BQU0sSUFBSSxJQUFJLENBQUM7Z0JBQ2pCLENBQUM7WUFDSCxDQUFDO1FBQ0gsQ0FBQztRQUVELE9BQU8sTUFBTSxDQUFDO0lBQ2hCLENBQUM7NkdBOUJVLFlBQVk7a0ZBQVosWUFBWTt1RUFBWixZQUFZLFdBQVosWUFBWSxtQkFMWCxNQUFNOztpRkFLUCxZQUFZO2NBVHhCLElBQUk7ZUFBQztnQkFDSixJQUFJLEVBQUUsVUFBVTthQUNqQjs7Y0FDQSxVQUFVO2VBQUM7Z0JBQ1YsVUFBVSxFQUFFLE1BQU07YUFDbkIiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgKi9cbmltcG9ydCB7IEluamVjdGFibGUsIFBpcGUsIFBpcGVUcmFuc2Zvcm0gfSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuQFBpcGUoe1xuICBuYW1lOiAnaHVtYW5pemUnXG59KVxuQEluamVjdGFibGUoe1xuICBwcm92aWRlZEluOiAncm9vdCdcbn0pXG4vKipcbiAqIENoYW5nZXMgY2FtZWwgY2FzZSB0byBhIGh1bWFuIHJlYWRhYmxlIGZvcm1hdC4gU28gaGVsbG9Xb3JsZCwgaGVsbG8td29ybGQgYW5kIGhlbGxvX3dvcmxkIGJlY29tZXMgXCJIZWxsbyBXb3JsZFwiLiBcbiAqICovXG5leHBvcnQgY2xhc3MgaHVtYW5pemVQaXBlIGltcGxlbWVudHMgUGlwZVRyYW5zZm9ybSB7XG5cbiAgdHJhbnNmb3JtKHZhbHVlOiBzdHJpbmcgPSAnJyk6IHN0cmluZyB7XG4gICAgdmFyIG91dHB1dCA9IFwiXCI7XG4gICAgdmFyIGxlbiA9IHZhbHVlLmxlbmd0aDtcbiAgICB2YXIgY2hhcjtcblxuICAgIGZvciAodmFyIGkgPSAwOyBpIDwgbGVuOyBpKyspIHtcbiAgICAgIGNoYXIgPSB2YWx1ZS5jaGFyQXQoaSk7XG5cbiAgICAgIGlmIChpID09IDApIHtcbiAgICAgICAgb3V0cHV0ICs9IGNoYXIudG9VcHBlckNhc2UoKTtcbiAgICAgIH1cbiAgICAgIGVsc2UgaWYgKGNoYXIgIT09IGNoYXIudG9Mb3dlckNhc2UoKSAmJiBjaGFyID09PSBjaGFyLnRvVXBwZXJDYXNlKCkgJiYgdmFsdWUuY2hhckF0KGktMSkgPT09IHZhbHVlLmNoYXJBdChpLTEpLnRvTG93ZXJDYXNlKCkpIHtcbiAgICAgICAgb3V0cHV0ICs9IFwiIFwiICsgY2hhcjtcbiAgICAgIH1cbiAgICAgIGVsc2UgaWYgKGNoYXIgPT0gXCItXCIgfHwgY2hhciA9PSBcIl9cIiB8fCBjaGFyID09IFwiLlwiKSB7XG4gICAgICAgIG91dHB1dCArPSBcIiBcIjtcbiAgICAgIH1cbiAgICAgIGVsc2Uge1xuICAgICAgICBsZXQgcHJldmlvdXNDaGFyID0gdmFsdWUuY2hhckF0KGktMSk7XG4gICAgICAgIGlmKHByZXZpb3VzQ2hhciA9PSBcIi1cIiB8fCBwcmV2aW91c0NoYXIgPT0gXCJfXCIgfHwgcHJldmlvdXNDaGFyID09IFwiLlwiKXtcbiAgICAgICAgICBvdXRwdXQgKz0gY2hhci50b1VwcGVyQ2FzZSgpO1xuICAgICAgICB9ZWxzZXtcbiAgICAgICAgICBvdXRwdXQgKz0gY2hhcjtcbiAgICAgICAgfSBcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gb3V0cHV0O1xuICB9XG59Il19