/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, inject, Input } from '@angular/core';
import { NgbOffcanvas } from '@ng-bootstrap/ng-bootstrap';
import { PurgeNowComponent } from './purge-now/purge-now.component';
import { ManagePurge } from './manage-purge-model';
import { PurgeScheduleComponent } from './purge-schedule/purge-schedule.component';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
export class ManagePurgeComponent {
    constructor() {
        this.offcanvasService = inject(NgbOffcanvas);
        this.params = new ManagePurge();
    }
    ngOnInit() {
    }
    openPurgeNow() {
        this.offcanvasInstance = this.offcanvasService.open(PurgeNowComponent, {
            animation: true,
            position: 'end',
            panelClass: 'offcanvas-slide-left',
            scroll: false,
            backdrop: 'static'
        });
        this.offcanvasInstance.componentInstance.params = this.params.purgeNow;
    }
    openPurgeSchedule() {
        this.offcanvasInstance = this.offcanvasService.open(PurgeScheduleComponent, {
            animation: true,
            position: 'end',
            panelClass: 'offcanvas-slide-left',
            scroll: false,
            backdrop: 'static'
        });
        this.offcanvasInstance.componentInstance.params = this.params.schedulePurge;
        this.offcanvasInstance.componentInstance.scheduleClosed.subscribe((schedule) => {
            this.offcanvasInstance.componentInstance.scheduleMode = schedule.id ? 'edit' : 'new';
            this.offcanvasInstance.componentInstance.schedule = schedule;
        });
    }
    static { this.ɵfac = function ManagePurgeComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ManagePurgeComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ManagePurgeComponent, selectors: [["xf-manage-purge"]], inputs: { params: "params" }, decls: 11, vars: 10, consts: [["ngbDropdown", "", "container", "body", 1, "margin-right-20px", "ms-auto"], ["ngbDropdownToggle", "", "id", "playbook-purge-btn", "type", "button", 1, "dropdown-toggle", "btn", "btn-secondary", "btn-sm", 3, "title"], ["ngbDropdownMenu", "", 1, "dropdown-menu", "mx-0", "border-0", "shadow"], ["ngbDropdownItem", "", "id", "purge-no-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false"], ["ngbDropdownItem", "", "id", "edit-schedule-btn", 1, "cursor-pointer", 3, "click"]], template: function ManagePurgeComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "button", 1);
            i0.ɵɵtext(2);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "div", 2)(4, "li")(5, "a", 3);
            i0.ɵɵlistener("click", function ManagePurgeComponent_Template_a_click_5_listener() { return ctx.openPurgeNow(); });
            i0.ɵɵelement(6, "i", 4);
            i0.ɵɵtext(7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "a", 5);
            i0.ɵɵlistener("click", function ManagePurgeComponent_Template_a_click_8_listener() { return ctx.openPurgeSchedule(); });
            i0.ɵɵelement(9, "i", 4);
            i0.ɵɵtext(10);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵpropertyInterpolate("title", ctx.params.manageText);
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.manageText, " ");
            i0.ɵɵadvance(4);
            i0.ɵɵclassMapInterpolate1("", ctx.params.purgeNowIcon, " margin-right-4px");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.purgeNowText, " ");
            i0.ɵɵadvance(2);
            i0.ɵɵclassMapInterpolate1("", ctx.params.schedulePurgeIcon, " margin-right-4px");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.schedulePurgeText, " ");
        } }, dependencies: [i1.NgbDropdown, i1.NgbDropdownToggle, i1.NgbDropdownMenu, i1.NgbDropdownItem] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ManagePurgeComponent, [{
        type: Component,
        args: [{ selector: 'xf-manage-purge', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div ngbDropdown class=\"margin-right-20px ms-auto\" container=\"body\">\n    <button ngbDropdownToggle class=\"dropdown-toggle btn btn-secondary btn-sm\" id=\"playbook-purge-btn\"\n        type=\"button\" title=\"{{ params.manageText }}\">\n        {{ params.manageText }}\n    </button>\n    <div ngbDropdownMenu class=\"dropdown-menu mx-0 border-0 shadow\">\n        <li>\n            <a ngbDropdownItem id=\"purge-no-btn\" (click)=\"openPurgeNow()\" class=\"cursor-pointer\">\n                <i class=\"{{ params.purgeNowIcon }} margin-right-4px\" aria-hidden=\"false\"></i> {{ params.purgeNowText }}\n            </a>\n            <a ngbDropdownItem id=\"edit-schedule-btn\" (click)=\"openPurgeSchedule()\" class=\"cursor-pointer\">\n                <i class=\"{{ params.schedulePurgeIcon }} margin-right-4px\" aria-hidden=\"false\"></i> {{ params.schedulePurgeText }}\n            </a>\n        </li>\n    </div>\n</div>\n" }]
    }], null, { params: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ManagePurgeComponent, { className: "ManagePurgeComponent", filePath: "src/manage-purge/manage-purge.component.ts", lineNumber: 17 }); })();
//# sourceMappingURL=data:application/json;base64,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