/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, Input } from '@angular/core';
import { Validators } from '@angular/forms';
import { CheckboxField, DatetimeField, FieldOptions, Query } from 'shared';
import { PurgeNow } from '../manage-purge-model';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@ng-bootstrap/ng-bootstrap";
import * as i3 from "@angular/common";
import * as i4 from "shared";
import * as i5 from "@jsverse/transloco";
function PurgeNowComponent_ng_container_0_div_16_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 11)(1, "label", 19);
    i0.ɵɵtext(2, "Keep Unread");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(3, "xf-form-field", 20);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("field", ctx_r1.formFields.onlyRead)("fieldOptions", ctx_r1.fieldOptions);
} }
function PurgeNowComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 2)(2, "h4", 3);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 4);
    i0.ɵɵlistener("click", function PurgeNowComponent_ng_container_0_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "div", 5)(6, "form", 6, 0);
    i0.ɵɵlistener("ngSubmit", function PurgeNowComponent_ng_container_0_Template_form_ngSubmit_6_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.purge()); });
    i0.ɵɵelementStart(8, "div")(9, "label", 7);
    i0.ɵɵtext(10);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(11, "div", 8)(12, "div", 9)(13, "div", 10)(14, "div", 11);
    i0.ɵɵelement(15, "xf-form-field", 12);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(16, PurgeNowComponent_ng_container_0_div_16_Template, 4, 2, "div", 13);
    i0.ɵɵelementEnd()()()()();
    i0.ɵɵelementStart(17, "div", 14)(18, "button", 15);
    i0.ɵɵlistener("click", function PurgeNowComponent_ng_container_0_Template_button_click_18_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.purge()); });
    i0.ɵɵelement(19, "i", 16);
    i0.ɵɵtext(20);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(21, "button", 17);
    i0.ɵɵlistener("click", function PurgeNowComponent_ng_container_0_Template_button_click_21_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelement(22, "i", 18);
    i0.ɵɵtext(23);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const t_r3 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(ctx_r1.params.metadata.title);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(ctx_r1.params.metadata.description);
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("field", ctx_r1.formFields.purgeLogsBefore)("fieldClass", "form-control-sm margin-bottom-8px w-100")("autoFocus", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.params.extraFields.onlyRead);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("disabled", ctx_r1.formGroup.invalid);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1("", t_r3("buttons.purge"), " ");
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r3("buttons.cancel"), " ");
} }
export class PurgeNowComponent {
    constructor(formBuilder, activeOffCanvas) {
        this.formBuilder = formBuilder;
        this.activeOffCanvas = activeOffCanvas;
        this.formFields = {};
        this.purgePayload = new Query();
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
        this.params = new PurgeNow();
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({
            purgeLogsBefore: [new Date(), Validators.required],
            onlyRead: [false]
        });
        this.formFields.purgeLogsBefore = new DatetimeField(this.params.dateFieldParams.fieldTitle);
        this.formFields.purgeLogsBefore.validation = { required: true };
        this.formFields.onlyRead = new CheckboxField('Unread Only');
    }
    cancel() {
        this.activeOffCanvas.close();
    }
    purge() {
        let date = new Date(this.formGroup.value.purgeLogsBefore).toISOString();
        let data = {
            date: date,
            onlyRead: this.formGroup.value.onlyRead
        };
        this.params.save$(data).subscribe((options) => {
            if (options.closeAndRefresh) {
                this.activeOffCanvas.close('refresh');
            }
            else {
                this.activeOffCanvas.close();
            }
        });
    }
    static { this.ɵfac = function PurgeNowComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PurgeNowComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i2.NgbActiveOffcanvas)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PurgeNowComponent, selectors: [["xf-purge-now"]], inputs: { params: "params" }, decls: 1, vars: 0, consts: [["purgeNowForm", "ngForm"], [4, "transloco"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "font-size-16px", "fw-normal", "modal-title", "muted-10"], ["type", "button", "id", "close-btn-purge", 1, "btn", "btn-close", 3, "click"], [1, "margin-top-20px", "modal-body"], [1, "ms-2", 3, "ngSubmit", "formGroup"], [1, "form-check-label", "align-bottom", "margin-left-10px", "margin-bottom-10px", "label-font"], [1, "row", "m-0"], [1, "col-md-12"], [1, "form-group"], [1, "mb-1"], ["formControlName", "purgeLogsBefore", 3, "field", "fieldClass", "autoFocus"], ["class", "mb-1", 4, "ngIf"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "me-2"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-right-8px", 3, "click", "disabled"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"], ["for", "input-onlyRead", 1, "form-label", "mb-0"], ["fieldClass", "muted-40", "formControlName", "onlyRead", 3, "field", "fieldOptions"]], template: function PurgeNowComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PurgeNowComponent_ng_container_0_Template, 24, 10, "ng-container", 1);
        } }, dependencies: [i3.NgIf, i1.ɵNgNoValidate, i1.NgControlStatus, i1.NgControlStatusGroup, i4.FormFieldComponent, i1.FormGroupDirective, i1.FormControlName, i5.TranslocoDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PurgeNowComponent, [{
        type: Component,
        args: [{ selector: 'xf-purge-now', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<ng-container *transloco=\"let t\">\n  <!-- Header -->\n  <div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n    <h4 class=\"font-size-16px fw-normal modal-title muted-10\">{{ params.metadata.title }}</h4>\n    <button type=\"button\" id=\"close-btn-purge\" (click)=\"cancel()\" class=\"btn btn-close\"></button>\n  </div>\n  <!-- Body -->\n  <div class=\"margin-top-20px modal-body\">\n    <form #purgeNowForm=\"ngForm\" (ngSubmit)=\"purge()\" [formGroup]=\"formGroup\" class=\"ms-2\">\n      <div>\n        <label class=\"form-check-label align-bottom margin-left-10px margin-bottom-10px label-font\">{{\n          params.metadata.description }}</label>\n      </div>\n      <div class=\"row m-0\">\n        <div class=\"col-md-12\">\n          <div class=\"form-group\">\n            <div class=\"mb-1\">\n              <xf-form-field [field]=\"formFields.purgeLogsBefore\" formControlName=\"purgeLogsBefore\"\n                [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\" [autoFocus]=\"true\"></xf-form-field>\n            </div>\n            <div class=\"mb-1\" *ngIf=\"params.extraFields.onlyRead\">\n              <label for=\"input-onlyRead\" class=\"form-label mb-0\">Keep Unread</label>\n              <xf-form-field [field]=\"formFields.onlyRead\" fieldClass=\"muted-40\" formControlName=\"onlyRead\" [fieldOptions]=\"fieldOptions\"></xf-form-field>\n            </div>\n          </div>\n        </div>\n      </div>\n    </form>\n  </div>\n  <!-- Footer -->\n  <div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px me-2\">\n    <button type=\"button\" class=\"btn btn-primary btn-sm margin-right-8px\" [disabled]=\"formGroup.invalid\"\n      (click)=\"purge()\">\n      <i class=\"fa fa-check margin-right-4px\"></i>{{ t('buttons.purge') }}\n    </button>\n    <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" (click)=\"cancel()\">\n      <i class=\"fa fa-times margin-right-4px\"></i>{{ t('buttons.cancel') }}\n    </button>\n  </div>\n</ng-container>\n" }]
    }], () => [{ type: i1.FormBuilder }, { type: i2.NgbActiveOffcanvas }], { params: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PurgeNowComponent, { className: "PurgeNowComponent", filePath: "src/manage-purge/purge-now/purge-now.component.ts", lineNumber: 17 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHVyZ2Utbm93LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zY2hlZHVsZS9zcmMvbWFuYWdlLXB1cmdlL3B1cmdlLW5vdy9wdXJnZS1ub3cuY29tcG9uZW50LnRzIiwiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL3NjaGVkdWxlL3NyYy9tYW5hZ2UtcHVyZ2UvcHVyZ2Utbm93L3B1cmdlLW5vdy5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7OztrQkFJa0I7QUFDbEIsT0FBTyxFQUFFLFNBQVMsRUFBRSxLQUFLLEVBQVUsTUFBTSxlQUFlLENBQUM7QUFDekQsT0FBTyxFQUEwQixVQUFVLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUVwRSxPQUFPLEVBQUUsYUFBYSxFQUFFLGFBQWEsRUFBUyxZQUFZLEVBQUUsS0FBSyxFQUFFLE1BQU0sUUFBUSxDQUFDO0FBQ2xGLE9BQU8sRUFBRSxRQUFRLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQzs7Ozs7Ozs7SUNpQm5DLEFBREYsK0JBQXNELGdCQUNBO0lBQUEsMkJBQVc7SUFBQSxpQkFBUTtJQUN2RSxvQ0FBNEk7SUFDOUksaUJBQU07OztJQURXLGVBQTZCO0lBQWtELEFBQS9FLGtEQUE2QixxQ0FBK0U7Ozs7SUF0QnpJLDZCQUFpQztJQUc3QixBQURGLDhCQUFtSCxZQUN2RDtJQUFBLFlBQTJCO0lBQUEsaUJBQUs7SUFDMUYsaUNBQW9GO0lBQXpDLHNMQUFTLGVBQVEsS0FBQztJQUMvRCxBQURzRixpQkFBUyxFQUN6RjtJQUdKLEFBREYsOEJBQXdDLGlCQUNpRDtJQUExRCwwTEFBWSxjQUFPLEtBQUM7SUFFN0MsQUFERiwyQkFBSyxlQUN5RjtJQUFBLGFBQzVEO0lBQ2xDLEFBRGtDLGlCQUFRLEVBQ3BDO0lBSUEsQUFERixBQURGLEFBREYsK0JBQXFCLGNBQ0ksZUFDRyxlQUNKO0lBQ2hCLHFDQUM4RjtJQUNoRyxpQkFBTTtJQUNOLG9GQUFzRDtJQVFoRSxBQURFLEFBREUsQUFERSxBQURFLGlCQUFNLEVBQ0YsRUFDRixFQUNELEVBQ0g7SUFHSixBQURGLGdDQUF1RyxrQkFFakY7SUFBbEIsdUxBQVMsY0FBTyxLQUFDO0lBQ2pCLHlCQUE0QztJQUFBLGFBQzlDO0lBQUEsaUJBQVM7SUFDVCxtQ0FBK0U7SUFBbkIsdUxBQVMsZUFBUSxLQUFDO0lBQzVFLHlCQUE0QztJQUFBLGFBQzlDO0lBQ0YsQUFERSxpQkFBUyxFQUNMOzs7OztJQW5Dc0QsZUFBMkI7SUFBM0Isa0RBQTJCO0lBS25DLGVBQXVCO0lBQXZCLDRDQUF1QjtJQUV1QixlQUM1RDtJQUQ0RCx3REFDNUQ7SUFNWCxlQUFvQztJQUNRLEFBQXpELEFBRGEseURBQW9DLHlEQUNPLG1CQUFtQjtJQUU1RCxjQUFpQztJQUFqQyx5REFBaUM7SUFXVSxlQUE4QjtJQUE5QixtREFBOEI7SUFFdEQsZUFDOUM7SUFEOEMscURBQzlDO0lBRThDLGVBQzlDO0lBRDhDLHNEQUM5Qzs7QUQxQkosTUFBTSxPQUFPLGlCQUFpQjtJQVM1QixZQUNVLFdBQXdCLEVBQ3pCLGVBQW1DO1FBRGxDLGdCQUFXLEdBQVgsV0FBVyxDQUFhO1FBQ3pCLG9CQUFlLEdBQWYsZUFBZSxDQUFvQjtRQVQ1QyxlQUFVLEdBQTBCLEVBQUUsQ0FBQztRQUN2QyxpQkFBWSxHQUFVLElBQUksS0FBSyxFQUFFLENBQUM7UUFDbEMsaUJBQVksR0FBRyxJQUFJLFlBQVksQ0FBQztZQUM5QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDLENBQUM7UUFDTSxXQUFNLEdBQWEsSUFBSSxRQUFRLEVBQUUsQ0FBQztJQUt2QyxDQUFDO0lBRUwsUUFBUTtRQUNOLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUM7WUFDdEMsZUFBZSxFQUFFLENBQUMsSUFBSSxJQUFJLEVBQUUsRUFBRSxVQUFVLENBQUMsUUFBUSxDQUFDO1lBQ2xELFFBQVEsRUFBRSxDQUFDLEtBQUssQ0FBQztTQUNsQixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLGVBQWUsR0FBRyxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUM1RixJQUFJLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxVQUFVLEdBQUcsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUM7UUFDaEUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLEdBQUcsSUFBSSxhQUFhLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDOUQsQ0FBQztJQUVELE1BQU07UUFDSixJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxDQUFDO0lBQy9CLENBQUM7SUFFRCxLQUFLO1FBQ0gsSUFBSSxJQUFJLEdBQUcsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDeEUsSUFBSSxJQUFJLEdBQVE7WUFDZCxJQUFJLEVBQUUsSUFBSTtZQUNWLFFBQVEsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ3hDLENBQUM7UUFDRixJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxPQUE0QixFQUFDLEVBQUU7WUFDaEUsSUFBRyxPQUFPLENBQUMsZUFBZSxFQUFFLENBQUM7Z0JBQzNCLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1lBQ3hDLENBQUM7aUJBQU0sQ0FBQztnQkFDTixJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxDQUFDO1lBQy9CLENBQUM7UUFDSCxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7a0hBekNVLGlCQUFpQjtvRUFBakIsaUJBQWlCO1lDWDlCLHNGQUFpQzs7O2lGRFdwQixpQkFBaUI7Y0FMN0IsU0FBUzsyQkFDRSxjQUFjOzZFQVdmLE1BQU07a0JBQWQsS0FBSzs7a0ZBUEssaUJBQWlCIiwic291cmNlc0NvbnRlbnQiOlsiLyogQ29weXJpZ2h0IHN0YXJ0XG4gIENvcHlyaWdodCAoQykgMjAwOCAtIDIwMjUgRm9ydGluZXQgSW5jLlxuICBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICBGT1JUSU5FVCBDT05GSURFTlRJQUwgJiBGT1JUSU5FVCBQUk9QUklFVEFSWSBTT1VSQ0UgQ09ERVxuICBDb3B5cmlnaHQgZW5kICovXG5pbXBvcnQgeyBDb21wb25lbnQsIElucHV0LCBPbkluaXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEZvcm1CdWlsZGVyLCBGb3JtR3JvdXAsIFZhbGlkYXRvcnMgfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XG5pbXBvcnQgeyBOZ2JBY3RpdmVPZmZjYW52YXMgfSBmcm9tICdAbmctYm9vdHN0cmFwL25nLWJvb3RzdHJhcCc7XG5pbXBvcnQgeyBDaGVja2JveEZpZWxkLCBEYXRldGltZUZpZWxkLCBGaWVsZCwgRmllbGRPcHRpb25zLCBRdWVyeSB9IGZyb20gJ3NoYXJlZCc7XG5pbXBvcnQgeyBQdXJnZU5vdyB9IGZyb20gJy4uL21hbmFnZS1wdXJnZS1tb2RlbCc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ3hmLXB1cmdlLW5vdycsXG4gIHRlbXBsYXRlVXJsOiAnLi9wdXJnZS1ub3cuY29tcG9uZW50Lmh0bWwnLFxuICBzdHlsZVVybDogJy4vcHVyZ2Utbm93LmNvbXBvbmVudC5zY3NzJ1xufSlcbmV4cG9ydCBjbGFzcyBQdXJnZU5vd0NvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XG4gIGZvcm1Hcm91cCE6IEZvcm1Hcm91cDtcbiAgZm9ybUZpZWxkczogUmVjb3JkPHN0cmluZywgRmllbGQ+ID0ge307XG4gIHB1cmdlUGF5bG9hZDogUXVlcnkgPSBuZXcgUXVlcnkoKTtcbiAgZmllbGRPcHRpb25zID0gbmV3IEZpZWxkT3B0aW9ucyh7XG4gICAgc2hvd0xhYmVsOiBmYWxzZVxuICB9KTtcbiAgQElucHV0KCkgcGFyYW1zOiBQdXJnZU5vdyA9IG5ldyBQdXJnZU5vdygpO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgZm9ybUJ1aWxkZXI6IEZvcm1CdWlsZGVyLFxuICAgIHB1YmxpYyBhY3RpdmVPZmZDYW52YXM6IE5nYkFjdGl2ZU9mZmNhbnZhc1xuICApIHsgfVxuXG4gIG5nT25Jbml0KCkge1xuICAgIHRoaXMuZm9ybUdyb3VwID0gdGhpcy5mb3JtQnVpbGRlci5ncm91cCh7XG4gICAgICBwdXJnZUxvZ3NCZWZvcmU6IFtuZXcgRGF0ZSgpLCBWYWxpZGF0b3JzLnJlcXVpcmVkXSxcbiAgICAgIG9ubHlSZWFkOiBbZmFsc2VdXG4gICAgfSk7XG4gICAgdGhpcy5mb3JtRmllbGRzLnB1cmdlTG9nc0JlZm9yZSA9IG5ldyBEYXRldGltZUZpZWxkKHRoaXMucGFyYW1zLmRhdGVGaWVsZFBhcmFtcy5maWVsZFRpdGxlKTtcbiAgICB0aGlzLmZvcm1GaWVsZHMucHVyZ2VMb2dzQmVmb3JlLnZhbGlkYXRpb24gPSB7IHJlcXVpcmVkOiB0cnVlIH07XG4gICAgdGhpcy5mb3JtRmllbGRzLm9ubHlSZWFkID0gbmV3IENoZWNrYm94RmllbGQoJ1VucmVhZCBPbmx5Jyk7XG4gIH1cblxuICBjYW5jZWwoKSB7XG4gICAgdGhpcy5hY3RpdmVPZmZDYW52YXMuY2xvc2UoKTtcbiAgfVxuXG4gIHB1cmdlKCkge1xuICAgIGxldCBkYXRlID0gbmV3IERhdGUodGhpcy5mb3JtR3JvdXAudmFsdWUucHVyZ2VMb2dzQmVmb3JlKS50b0lTT1N0cmluZygpO1xuICAgIGxldCBkYXRhOiBhbnkgPSB7XG4gICAgICBkYXRlOiBkYXRlLFxuICAgICAgb25seVJlYWQ6IHRoaXMuZm9ybUdyb3VwLnZhbHVlLm9ubHlSZWFkXG4gICAgfTtcbiAgICB0aGlzLnBhcmFtcy5zYXZlJChkYXRhKS5zdWJzY3JpYmUoKG9wdGlvbnM6IFJlY29yZDxzdHJpbmcsIGFueT4pPT4ge1xuICAgICAgaWYob3B0aW9ucy5jbG9zZUFuZFJlZnJlc2gpIHtcbiAgICAgICAgdGhpcy5hY3RpdmVPZmZDYW52YXMuY2xvc2UoJ3JlZnJlc2gnKTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRoaXMuYWN0aXZlT2ZmQ2FudmFzLmNsb3NlKCk7XG4gICAgICB9XG4gICAgfSk7XG4gIH1cblxufVxuIiwiPCEtLSBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgLS0+XG48bmctY29udGFpbmVyICp0cmFuc2xvY289XCJsZXQgdFwiPlxuICA8IS0tIEhlYWRlciAtLT5cbiAgPGRpdiBjbGFzcz1cIm1vZGFsLWhlYWRlciBwYWRkaW5nLWJvdHRvbS04cHggcGFkZGluZy1sZWZ0LTE2cHggcGFkZGluZy1yaWdodC0xNnB4IHBhZGRpbmctdG9wLThweCBtb2RhbC1jbG9zZS1sZWZ0XCI+XG4gICAgPGg0IGNsYXNzPVwiZm9udC1zaXplLTE2cHggZnctbm9ybWFsIG1vZGFsLXRpdGxlIG11dGVkLTEwXCI+e3sgcGFyYW1zLm1ldGFkYXRhLnRpdGxlIH19PC9oND5cbiAgICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBpZD1cImNsb3NlLWJ0bi1wdXJnZVwiIChjbGljayk9XCJjYW5jZWwoKVwiIGNsYXNzPVwiYnRuIGJ0bi1jbG9zZVwiPjwvYnV0dG9uPlxuICA8L2Rpdj5cbiAgPCEtLSBCb2R5IC0tPlxuICA8ZGl2IGNsYXNzPVwibWFyZ2luLXRvcC0yMHB4IG1vZGFsLWJvZHlcIj5cbiAgICA8Zm9ybSAjcHVyZ2VOb3dGb3JtPVwibmdGb3JtXCIgKG5nU3VibWl0KT1cInB1cmdlKClcIiBbZm9ybUdyb3VwXT1cImZvcm1Hcm91cFwiIGNsYXNzPVwibXMtMlwiPlxuICAgICAgPGRpdj5cbiAgICAgICAgPGxhYmVsIGNsYXNzPVwiZm9ybS1jaGVjay1sYWJlbCBhbGlnbi1ib3R0b20gbWFyZ2luLWxlZnQtMTBweCBtYXJnaW4tYm90dG9tLTEwcHggbGFiZWwtZm9udFwiPnt7XG4gICAgICAgICAgcGFyYW1zLm1ldGFkYXRhLmRlc2NyaXB0aW9uIH19PC9sYWJlbD5cbiAgICAgIDwvZGl2PlxuICAgICAgPGRpdiBjbGFzcz1cInJvdyBtLTBcIj5cbiAgICAgICAgPGRpdiBjbGFzcz1cImNvbC1tZC0xMlwiPlxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCI+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwibWItMVwiPlxuICAgICAgICAgICAgICA8eGYtZm9ybS1maWVsZCBbZmllbGRdPVwiZm9ybUZpZWxkcy5wdXJnZUxvZ3NCZWZvcmVcIiBmb3JtQ29udHJvbE5hbWU9XCJwdXJnZUxvZ3NCZWZvcmVcIlxuICAgICAgICAgICAgICAgIFtmaWVsZENsYXNzXT1cIidmb3JtLWNvbnRyb2wtc20gbWFyZ2luLWJvdHRvbS04cHggdy0xMDAnXCIgW2F1dG9Gb2N1c109XCJ0cnVlXCI+PC94Zi1mb3JtLWZpZWxkPlxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwibWItMVwiICpuZ0lmPVwicGFyYW1zLmV4dHJhRmllbGRzLm9ubHlSZWFkXCI+XG4gICAgICAgICAgICAgIDxsYWJlbCBmb3I9XCJpbnB1dC1vbmx5UmVhZFwiIGNsYXNzPVwiZm9ybS1sYWJlbCBtYi0wXCI+S2VlcCBVbnJlYWQ8L2xhYmVsPlxuICAgICAgICAgICAgICA8eGYtZm9ybS1maWVsZCBbZmllbGRdPVwiZm9ybUZpZWxkcy5vbmx5UmVhZFwiIGZpZWxkQ2xhc3M9XCJtdXRlZC00MFwiIGZvcm1Db250cm9sTmFtZT1cIm9ubHlSZWFkXCIgW2ZpZWxkT3B0aW9uc109XCJmaWVsZE9wdGlvbnNcIj48L3hmLWZvcm0tZmllbGQ+XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgPC9kaXY+XG4gICAgICA8L2Rpdj5cbiAgICA8L2Zvcm0+XG4gIDwvZGl2PlxuICA8IS0tIEZvb3RlciAtLT5cbiAgPGRpdiBjbGFzcz1cIm1vZGFsLWZvb3RlciBwYWRkaW5nLWJvdHRvbS04cHggcGFkZGluZy1sZWZ0LTE2cHggcGFkZGluZy1yaWdodC0xNnB4IHBhZGRpbmctdG9wLThweCBtZS0yXCI+XG4gICAgPGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCIgY2xhc3M9XCJidG4gYnRuLXByaW1hcnkgYnRuLXNtIG1hcmdpbi1yaWdodC04cHhcIiBbZGlzYWJsZWRdPVwiZm9ybUdyb3VwLmludmFsaWRcIlxuICAgICAgKGNsaWNrKT1cInB1cmdlKClcIj5cbiAgICAgIDxpIGNsYXNzPVwiZmEgZmEtY2hlY2sgbWFyZ2luLXJpZ2h0LTRweFwiPjwvaT57eyB0KCdidXR0b25zLnB1cmdlJykgfX1cbiAgICA8L2J1dHRvbj5cbiAgICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBjbGFzcz1cImJ0biBidG4tc2Vjb25kYXJ5IGJ0bi1zbSBtZS0yXCIgKGNsaWNrKT1cImNhbmNlbCgpXCI+XG4gICAgICA8aSBjbGFzcz1cImZhIGZhLXRpbWVzIG1hcmdpbi1yaWdodC00cHhcIj48L2k+e3sgdCgnYnV0dG9ucy5jYW5jZWwnKSB9fVxuICAgIDwvYnV0dG9uPlxuICA8L2Rpdj5cbjwvbmctY29udGFpbmVyPlxuIl19