/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
const _c0 = (a0, a1) => ({ "active": a0, "inactive": a1 });
export class StatusRenderer {
    // gets called once before the renderer is used
    agInit(params) {
        this.cellValue = this.getValueToDisplay(params);
    }
    // gets called whenever the cell refreshes
    refresh(params) {
        // set value into cell again
        this.cellValue = this.getValueToDisplay(params);
        return true;
    }
    getValueToDisplay(params) {
        return params.valueFormatted ? params.valueFormatted : params.data;
    }
    static { this.ɵfac = function StatusRenderer_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || StatusRenderer)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: StatusRenderer, selectors: [["ng-component"]], decls: 5, vars: 5, consts: [[1, "fa-solid", "fa-circle", "me-2", 3, "ngClass"]], template: function StatusRenderer_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div")(1, "span");
            i0.ɵɵelement(2, "i", 0);
            i0.ɵɵelementStart(3, "span");
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(2, _c0, ctx.cellValue.enabled, !ctx.cellValue.enabled));
            i0.ɵɵadvance(2);
            i0.ɵɵtextInterpolate(ctx.cellValue.enabled ? " Active" : " Inactive");
        } }, dependencies: [i1.NgClass], styles: [".active[_ngcontent-%COMP%]{color:green}.inactive[_ngcontent-%COMP%]{color:red}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(StatusRenderer, [{
        type: Component,
        args: [{ template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div>\n    <span>\n        <i class=\"fa-solid fa-circle me-2\" [ngClass]=\"{'active': cellValue.enabled, 'inactive': !cellValue.enabled}\"></i>\n        <span>{{cellValue.enabled ? ' Active' : ' Inactive'}}</span>\n    </span>\n</div>", styles: [".active{color:green}.inactive{color:red}\n"] }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(StatusRenderer, { className: "StatusRenderer", filePath: "src/schedule-list/cell-renderers/status/status.component.ts", lineNumber: 14 }); })();
//# sourceMappingURL=data:application/json;base64,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