/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, ViewChildren, inject } from "@angular/core";
import { Validators } from "@angular/forms";
import { concatMap, map, of, tap } from "rxjs";
import { FormFieldComponent } from "shared";
import { UniqueValidatorService } from "./unique.validator";
import { ViewTemplate } from "./models/view-template";
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/router";
import * as i3 from "./view-template/view-template.service";
import * as i4 from "shared";
import * as i5 from "@angular/forms";
export class AbstractViewTemplateComponent {
    constructor(offcanvasService, router, viewTemplateService, route, changeDetectorRef, spinnerService, modalService, formBuilder) {
        this.offcanvasService = offcanvasService;
        this.router = router;
        this.viewTemplateService = viewTemplateService;
        this.route = route;
        this.changeDetectorRef = changeDetectorRef;
        this.spinnerService = spinnerService;
        this.modalService = modalService;
        this.viewTemplates = [];
        this.types = ViewTemplate.Types;
        this.loading = true;
        this.loadMultipleViews = true;
        this.uniqueValidatorService = inject(UniqueValidatorService);
        this.headerButtons = [];
        this.formGroup = formBuilder.group({
            viewTemplateTitle: ['', Validators.required]
        });
    }
    ngOnInit() {
        this.route.queryParamMap.pipe(concatMap((params) => {
            this.mode = params.get('mode') || 'view';
            this.uuid = params.get('uuid');
            this.loading = true;
            this.changeDetectorRef.detectChanges();
            if (this.mode === 'new') {
                return this.loadViews().pipe(map(() => this.newViewTemplate()));
            }
            else if (this.loadMultipleViews) {
                return this.loadViews().pipe(tap(() => {
                    if (this.viewTemplates && this.viewTemplates?.length > 0) {
                        this.uuid = this.uuid ?? this.viewTemplates[0]?.uuid;
                        this.viewTemplate = this.viewTemplates.find((viewTemplate) => viewTemplate.uuid === this.uuid) || null;
                        this.updateHeaderButtons();
                    }
                    else {
                        this.mode == null;
                        this.uuid = null;
                        this.updateHeaderButtons();
                        this.navigate();
                    }
                    this.changeDetectorRef.detectChanges();
                }));
            }
            else if (this.mode === 'view' && this.uuid) {
                return this.loadView();
            }
            return of();
        })).subscribe();
    }
    ;
    onSaveTemplate() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            this.formFields.forEach((formField) => {
                if (!formField.valid) {
                    formField.focus();
                    return;
                }
            });
            this.changeDetectorRef.detectChanges();
            return;
        }
        let updateMode;
        this.viewTemplateService.save(this.viewTemplate).subscribe({
            next: (viewTemplate) => {
                updateMode = this.mode === 'new' ? 'new' : 'view';
                this.mode = 'view';
                this.uuid = viewTemplate.uuid;
                this.updateViews(updateMode, viewTemplate);
                this.updateHeaderButtons();
                this.navigate();
            },
            error: (error) => {
                console.log(error);
                this.formGroup.controls.viewTemplateTitle.setErrors({ unique: true });
                this.formGroup.controls.viewTemplateTitle.markAsTouched();
                return of();
            }
        });
    }
    onDuplicateTemplate() {
        if (!this.viewTemplate) {
            return;
        }
        if (!this.viewTemplate.uuid) {
            return;
        }
        this.spinnerService.start();
        return this.viewTemplateService.duplicate(this.viewTemplate.uuid).subscribe((viewTemplate) => {
            this.spinnerService.stop();
            this.uuid = viewTemplate.uuid;
            this.mode = 'edit';
            this.navigate();
        });
    }
    onDeleteTemplate() {
        if (!this.viewTemplate) {
            return;
        }
        else {
            const message = 'Are you sure you want to delete the current view?';
            this.modalService.confirm(message).pipe(concatMap(() => {
                if (!this.viewTemplate?.uuid) {
                    return of();
                }
                this.spinnerService.start();
                return this.viewTemplateService.delete(this.viewTemplate?.uuid);
            })).subscribe(() => {
                this.spinnerService.stop();
                this.updateViews(undefined, this.viewTemplate);
            });
        }
    }
    onCancel() {
        if (this.mode === 'edit') {
            if (!this.uuid) {
                this.viewTemplate = null;
            }
            this.mode = 'view';
            this.updateHeaderButtons();
            this.navigate();
        }
        else {
            this.viewTemplate = null;
            this.viewTemplateService.navigateToView(null, this.route);
        }
    }
    onEditTemplate() {
        if (this.uuid) {
            this.mode = 'edit';
            this.updateHeaderButtons();
            this.navigate();
        }
    }
    updateViews(mode, viewTemplate) {
        if (mode && viewTemplate) {
            if (mode === 'new') {
                this._updateOnNew(viewTemplate);
            }
            else if (mode === 'view') {
                this.viewTemplates.forEach((item) => {
                    if (item.uuid === viewTemplate.uuid) {
                        item.title = viewTemplate.title;
                    }
                });
            }
        }
        else if (!mode && viewTemplate) { // Delete Case
            this.viewTemplates = this.viewTemplates.filter(item => item.uuid !== viewTemplate.uuid);
            if (this.viewTemplates.length > 0) {
                this.uuid = this.viewTemplates[0].uuid;
                this.loading = true;
                this.loadView();
            }
            else {
                this.uuid = null;
            }
        }
        this.changeDetectorRef.detectChanges();
    }
    _updateOnNew(viewTemplate) {
        this.uuid = viewTemplate.uuid;
        this.viewTemplates.unshift(viewTemplate);
    }
    loadViews() {
        // Pick it from context
        this.viewTemplate = null;
        this.viewTemplates = [];
        const module = this.route.snapshot.paramMap.get('module');
        let filters = [{
                field: 'type',
                operator: 'eq',
                value: this.viewTemplateType
            }];
        if (module) {
            this.currentModule = module;
            filters.push({
                field: 'module',
                operator: 'eq',
                value: module
            });
        }
        return this.viewTemplateService.loadWithParams(filters).pipe(map((viewTemplates) => {
            if (viewTemplates && viewTemplates?.length > 0) {
                this.viewTemplates = viewTemplates;
                const viewTemplatesWithoutCurrent = this.viewTemplates.filter((viewTemplate) => viewTemplate.uuid !== this.uuid);
                this.formGroup.controls.viewTemplateTitle.addValidators(this.uniqueValidatorService.validate(viewTemplatesWithoutCurrent.map((viewTemplate) => viewTemplate.title)));
                this.formGroup.controls.viewTemplateTitle.updateValueAndValidity();
            }
            this.loading = false;
            this.changeDetectorRef.detectChanges();
        }));
    }
    loadView() {
        return this.viewTemplateService.loadByUuid(this.uuid).pipe(map((viewTemplate) => {
            this.viewTemplate = viewTemplate;
            this.loading = false;
            this.updateHeaderButtons();
            this.changeDetectorRef.detectChanges();
        }));
    }
    navigate() {
        let params = {
            mode: this.mode,
            uuid: this.uuid
        };
        // this.viewTemplateService.navigateToView(params, this.route);
        var url = this.router.createUrlTree([], { relativeTo: this.route, queryParams: params }).toString();
        this.router.navigateByUrl(url);
        // if (this.openedInPreview) {
        //   this.mode = this.params.mode;
        //   this.recordId = this.params.recordId;
        //   this.onAddViewTemplate.emit();
        // } else {
        //   this.viewTemplateService.navigateToView(this.params, this.route);
        // }
    }
    updateHeaderButtons() {
        const isSystem = this.viewTemplate?.system;
        this.headerButtons = [
            {
                id: 'actions',
                text: 'Actions',
                class: 'dropdown-toggle btn btn-primary btn-sm',
                visible: this.mode === 'view' && this.viewTemplate?.type !== 'dashboard',
                menuItems: [{
                        id: 'new',
                        text: 'New',
                        visible: true,
                        onClick: () => {
                            this.mode = 'new';
                            this.uuid = null;
                            this.navigate();
                        }
                    }, {
                        id: 'clone',
                        text: 'Clone & Edit',
                        visible: isSystem,
                        onClick: () => { this.onDuplicateTemplate(); }
                    }, {
                        id: 'edit',
                        text: 'Edit',
                        visible: !isSystem,
                        onClick: () => { this.onEditTemplate(); }
                    }, {
                        id: 'delete',
                        text: 'Delete',
                        visible: !isSystem,
                        onClick: () => { this.onDeleteTemplate(); }
                    }],
                onClick: () => null
            }, {
                id: 'cancel',
                text: 'Cancel',
                class: 'btn btn-secondary btn-sm me-2',
                visible: this.mode !== null && this.mode !== 'view',
                onClick: () => { this.onCancel(); }
            }, {
                id: 'save',
                text: 'Save and Publish',
                class: 'btn btn-primary btn-sm me-2',
                visible: this.mode !== null && this.mode !== 'view',
                onClick: () => { this.onSaveTemplate(); }
            }
        ];
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function AbstractViewTemplateComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractViewTemplateComponent)(i0.ɵɵdirectiveInject(i1.NgbOffcanvas), i0.ɵɵdirectiveInject(i2.Router), i0.ɵɵdirectiveInject(i3.ViewTemplateService), i0.ɵɵdirectiveInject(i2.ActivatedRoute), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i4.SpinnerService), i0.ɵɵdirectiveInject(i4.ModalService), i0.ɵɵdirectiveInject(i5.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractViewTemplateComponent, selectors: [["xf-abstract-view-template"]], viewQuery: function AbstractViewTemplateComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, decls: 0, vars: 0, template: function AbstractViewTemplateComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractViewTemplateComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-view-template',
                template: ''
            }]
    }], () => [{ type: i1.NgbOffcanvas }, { type: i2.Router }, { type: i3.ViewTemplateService }, { type: i2.ActivatedRoute }, { type: i0.ChangeDetectorRef }, { type: i4.SpinnerService }, { type: i4.ModalService }, { type: i5.FormBuilder }], { formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractViewTemplateComponent, { className: "AbstractViewTemplateComponent", filePath: "src/abstract-view-template.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,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