/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, ViewChild } from '@angular/core';
import { CompactType, GridType } from 'angular-gridster2';
import { ViewLayoutItem } from '../../models/view-layout-item';
import { ContainerLayoutComponent } from '../container-layout/container-layout.component';
import { TabLayoutComponent } from '../tab-layout/tab-layout.component';
import { TabsLayoutComponent } from '../tabs-layout/tabs-layout.component';
import { WidgetsViewLayoutComponent } from '../widgets-view-layout/widgets-view-layout.component';
import { AbstractLayoutItemComponent } from './abstract-layout-item.component';
import { ViewContainerDirective } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "shared";
function LayoutItemComponent_ng_template_0_Template(rf, ctx) { }
export class LayoutItemComponent extends AbstractLayoutItemComponent {
    constructor() {
        super(...arguments);
        this.components = {
            [ViewLayoutItem.Types.WIDGET]: WidgetsViewLayoutComponent,
            [ViewLayoutItem.Types.CONTAINER]: ContainerLayoutComponent,
            [ViewLayoutItem.Types.TABS]: TabsLayoutComponent,
            [ViewLayoutItem.Types.TAB]: TabLayoutComponent
        };
    }
    ngOnInit() {
        this.createComponent();
    }
    findGridItem(itemId) {
        let itemFound;
        this.layoutItem.contents.forEach((item) => {
            if (item.id === itemId) {
                itemFound = item;
            }
        });
        return itemFound;
    }
    createComponent() {
        const viewContainerRef = this.viewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.components[this.layoutItem.type]);
        this.componentRef.instance.layoutItem = this.layoutItem;
        this.componentRef.instance.layoutItemChange = this.layoutItemChange;
        this.componentRef.instance.viewTemplate = this.viewTemplate;
        this.componentRef.instance.context = this.context;
        this.componentRef.instance.mode = this.mode;
        this.componentRef.instance.widgetSelection$ = this.widgetSelection$;
        this.componentRef.instance.onUpdateGridsterHeight = this.onUpdateGridsterHeight;
        this.componentRef.instance.gridsterConfig = this.getGridsterConfig(this.mode);
        this.componentRef.instance.onUpdateGridsterHeight.subscribe((data) => {
            let itemComponent = this.componentRef.instance.gridsterConfig.api?.getItemComponent(this.findGridItem(data.id));
            itemComponent.item.rows = data.height;
            itemComponent.resize.setItemHeight(data.height * this.fixedGridItemHeight);
            this.updateGridsterHeight();
        });
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    //TODO:- Re-Visit the logic
    ngOnChanges(changes) {
        let update = false;
        if (this.componentRef && changes.mode && changes.mode.currentValue && changes.mode.previousValue && changes.mode.currentValue !== changes.mode.previousValue) {
            update = true;
        }
        else if (this.componentRef && changes.layoutItem && changes.layoutItem.currentValue !== changes.layoutItem.previousValue) {
            update = true;
        }
        if (update) {
            this.componentRef.instance.mode = this.mode;
            this.componentRef.instance.gridsterConfig = this.getGridsterConfig(this.mode);
            this.componentRef.instance.layoutItem = this.layoutItem;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    getGridsterConfig(mode) {
        let gridsterConfig = {
            gridType: GridType.VerticalFixed,
            compactType: CompactType.None,
            pushItems: true,
            maxRows: undefined,
            fixedRowHeight: this.fixedGridItemHeight,
            enableEmptyCellDrop: mode !== 'view' ? true : false,
            enableEmptyCellDrag: mode !== 'view' ? true : false,
            draggable: {
                enabled: mode !== 'view' ? true : false
            },
            resizable: {
                enabled: mode !== 'view' ? true : false
            },
            itemChangeCallback: this.updateGridsterHeight.bind(this),
            itemResizeCallback: this.updateGridsterHeight.bind(this),
            itemInitCallback: this.updateGridsterHeight.bind(this)
        };
        return gridsterConfig;
    }
    updateGridsterHeight() {
        let height = 0;
        let margin = 100;
        this.layoutItem.contents.forEach((item) => {
            height += item.rows * this.fixedGridItemHeight;
        });
        this.gridsterHeight = height + margin;
        this.componentRef.instance.gridsterHeight = this.gridsterHeight;
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵLayoutItemComponent_BaseFactory; return function LayoutItemComponent_Factory(__ngFactoryType__) { return (ɵLayoutItemComponent_BaseFactory || (ɵLayoutItemComponent_BaseFactory = i0.ɵɵgetInheritedFactory(LayoutItemComponent)))(__ngFactoryType__ || LayoutItemComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LayoutItemComponent, selectors: [["xf-layout-item"]], viewQuery: function LayoutItemComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature, i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["xfViewContainer", ""]], template: function LayoutItemComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LayoutItemComponent_ng_template_0_Template, 0, 0, "ng-template", 0);
        } }, dependencies: [i1.ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LayoutItemComponent, [{
        type: Component,
        args: [{ selector: 'xf-layout-item', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<ng-template xfViewContainer></ng-template>" }]
    }], null, { viewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LayoutItemComponent, { className: "LayoutItemComponent", filePath: "src/view-template/layout-item/layout-item.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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