/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/router";
import * as i3 from "../view-template.service";
import * as i4 from "shared";
import * as i5 from "@angular/common";
import * as i6 from "@ng-bootstrap/ng-bootstrap";
function ViewTemplateHeaderComponent_xf_breadcrumbs_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-breadcrumbs");
} }
function ViewTemplateHeaderComponent_select_3_option_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const viewTemplate_r3 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", viewTemplate_r3.uuid);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(viewTemplate_r3.title);
} }
function ViewTemplateHeaderComponent_select_3_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "select", 5);
    i0.ɵɵlistener("ngModelChange", function ViewTemplateHeaderComponent_select_3_Template_select_ngModelChange_0_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); ctx_r1.selectedViewUuid = $event; return i0.ɵɵresetView(ctx_r1.navigateToView(ctx_r1.selectedViewUuid || "", "view")); });
    i0.ɵɵtemplate(1, ViewTemplateHeaderComponent_select_3_option_1_Template, 2, 2, "option", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngModel", ctx_r1.selectedViewUuid);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.viewTemplates);
} }
function ViewTemplateHeaderComponent_div_4_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 9)(1, "button", 10);
    i0.ɵɵtext(2, "Actions");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 11)(4, "button", 12);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_1_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["new"]()); });
    i0.ɵɵtext(5, "New");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(6, "div", 13);
    i0.ɵɵelementStart(7, "button", 12);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_1_Template_button_click_7_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["edit"](ctx_r1.selectedViewUuid)); });
    i0.ɵɵtext(8, "Edit ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "button", 12);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_1_Template_button_click_9_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["duplicate"]()); });
    i0.ɵɵtext(10, "Duplicate");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(11, "div", 13);
    i0.ɵɵelementStart(12, "button", 14);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_1_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["delete"]()); });
    i0.ɵɵtext(13, "Delete");
    i0.ɵɵelementEnd()()();
} }
function ViewTemplateHeaderComponent_div_4_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "button", 15);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_2_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["cancel"](null, ctx_r1.mode)); });
    i0.ɵɵtext(2, "Cancel");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "button", 16);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_2_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["save"]()); });
    i0.ɵɵtext(4, "Apply and Publish Changes");
    i0.ɵɵelementEnd()();
} }
function ViewTemplateHeaderComponent_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, ViewTemplateHeaderComponent_div_4_div_1_Template, 14, 0, "div", 8)(2, ViewTemplateHeaderComponent_div_4_div_2_Template, 5, 0, "div", 1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.mode === "view" || !ctx_r1.mode);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.mode && ctx_r1.mode !== "view");
} }
export class ViewTemplateHeaderComponent {
    constructor(rootFormGroup, changeDetectorRef, router, route, viewTemplateService, systemViewTemplateService, modalService, spinnerService) {
        this.rootFormGroup = rootFormGroup;
        this.changeDetectorRef = changeDetectorRef;
        this.router = router;
        this.route = route;
        this.viewTemplateService = viewTemplateService;
        this.systemViewTemplateService = systemViewTemplateService;
        this.modalService = modalService;
        this.spinnerService = spinnerService;
        this.showBreadcrumbs = true;
        this.viewTemplates = [];
        this.buttons = [];
        this.allowEdit = false;
        this.loadViews = new EventEmitter();
        this.params = {};
        this.backLink = this.route.snapshot.queryParamMap.get('returnPath') || '..';
    }
    ngOnInit() {
        this.selectedViewUuid = this.uuid;
        if (this.recordId) {
            this.params.recordId = this.recordId;
        }
    }
    //TODO : Re-Visit nessted if else
    ngOnChanges(changes) {
        if (changes.context && changes.context.currentValue !== changes.context.previousValue) {
            this.viewTemplates = [];
            this.loadViews.emit();
        }
        else if (changes.uuid && changes.uuid.currentValue !== changes.uuid.previousValue) {
            this.selectedViewUuid = this.uuid;
        }
        else {
            this.changeDetectorRef.detectChanges();
        }
        // else if (changes.mode && changes.mode.currentValue !== 'new') {
        //   if (!changes.uuid && changes.mode.currentValue === 'view') {
        //     this.loadViews.emit();
        //   } else {
        //     this.changeDetectorRef.detectChanges();
        //   }
        // }
    }
    navigateToView(uuid, mode) {
        this.params.uuid = uuid;
        this.params.mode = mode;
        this.viewTemplateService.navigateToView(this.params, this.route);
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function ViewTemplateHeaderComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateHeaderComponent)(i0.ɵɵdirectiveInject(i1.FormGroupDirective), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.Router), i0.ɵɵdirectiveInject(i2.ActivatedRoute), i0.ɵɵdirectiveInject(i3.ViewTemplateService), i0.ɵɵdirectiveInject(i3.ViewTemplateService), i0.ɵɵdirectiveInject(i4.ModalService), i0.ɵɵdirectiveInject(i4.SpinnerService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ViewTemplateHeaderComponent, selectors: [["xf-view-template-header"]], inputs: { mode: "mode", uuid: "uuid", showBreadcrumbs: "showBreadcrumbs", context: "context", viewTemplate: "viewTemplate", viewTemplates: "viewTemplates", recordId: "recordId", actions: "actions", buttons: "buttons", allowEdit: "allowEdit" }, outputs: { loadViews: "loadViews" }, features: [i0.ɵɵNgOnChangesFeature], decls: 6, vars: 4, consts: [[1, "breadcrumb-bar", "d-flex", "padding-left-10px"], [4, "ngIf"], [1, "m-2", "ms-auto", "d-flex"], ["name", "selectedView", "class", "form-select form-select-sm me-3 w-auto", 3, "ngModel", "ngModelChange", 4, "ngIf"], [3, "buttons"], ["name", "selectedView", 1, "form-select", "form-select-sm", "me-3", "w-auto", 3, "ngModelChange", "ngModel"], [3, "ngValue", 4, "ngFor", "ngForOf"], [3, "ngValue"], ["ngbDropdown", "", "class", "show dropdown", 4, "ngIf"], ["ngbDropdown", "", 1, "show", "dropdown"], ["type", "button", "ngbDropdownToggle", "", "aria-expanded", "true", 1, "dropdown-toggle", "btn", "btn-primary", "btn-sm"], ["ngbDropdownMenu", ""], ["ngbDropdownItem", "", 3, "click"], [1, "dropdown-divider"], ["ngbDropdownItem", "", 1, "text-danger", 3, "click"], ["type", "button", "aria-expanded", "true", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], ["type", "button", "aria-expanded", "true", 1, "btn", "btn-primary", "btn-sm", 3, "click"]], template: function ViewTemplateHeaderComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "header", 0);
            i0.ɵɵtemplate(1, ViewTemplateHeaderComponent_xf_breadcrumbs_1_Template, 1, 0, "xf-breadcrumbs", 1);
            i0.ɵɵelementStart(2, "div", 2);
            i0.ɵɵtemplate(3, ViewTemplateHeaderComponent_select_3_Template, 2, 2, "select", 3)(4, ViewTemplateHeaderComponent_div_4_Template, 3, 2, "div", 1);
            i0.ɵɵelement(5, "xf-button-group", 4);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.showBreadcrumbs);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.viewTemplates.length > 0 && ctx.mode === "view");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.allowEdit);
            i0.ɵɵadvance();
            i0.ɵɵproperty("buttons", ctx.buttons);
        } }, dependencies: [i5.NgForOf, i5.NgIf, i1.NgSelectOption, i1.ɵNgSelectMultipleOption, i1.SelectControlValueAccessor, i1.NgControlStatus, i1.NgModel, i6.NgbDropdown, i6.NgbDropdownToggle, i6.NgbDropdownMenu, i6.NgbDropdownItem, i6.NgbDropdownButtonItem, i4.BreadcrumbsComponent, i4.ButtonGroupComponent], styles: [".border-bottom-primary[_ngcontent-%COMP%]{border-bottom:2px solid var(--primary-tabs-default-border-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateHeaderComponent, [{
        type: Component,
        args: [{ selector: 'xf-view-template-header', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<header class=\"breadcrumb-bar d-flex padding-left-10px\">\n  <xf-breadcrumbs *ngIf=\"showBreadcrumbs\"></xf-breadcrumbs>\n  <div class=\"m-2 ms-auto d-flex\">\n    <select *ngIf=\"viewTemplates.length > 0 && mode === 'view'\" name=\"selectedView\"\n      class=\"form-select form-select-sm me-3 w-auto\" [ngModel]=\"selectedViewUuid\"\n      (ngModelChange)=\"selectedViewUuid = $event; navigateToView(selectedViewUuid || '', 'view');\">\n      <option *ngFor=\"let viewTemplate of viewTemplates\" [ngValue]=\"viewTemplate.uuid\">{{ viewTemplate.title }}</option>\n    </select>\n    <div *ngIf=\"allowEdit\">\n      <div ngbDropdown class=\"show dropdown\" *ngIf=\"mode === 'view' || !mode\">\n        <button type=\"button\" ngbDropdownToggle class=\"dropdown-toggle btn btn-primary btn-sm\"\n          aria-expanded=\"true\">Actions</button>\n        <div ngbDropdownMenu>\n          <button ngbDropdownItem (click)=\"actions['new']()\">New</button>\n          <div class=\"dropdown-divider\"></div>\n          <button ngbDropdownItem (click)=\"actions['edit'](selectedViewUuid)\">Edit\n          </button>\n          <button ngbDropdownItem (click)=\"actions['duplicate']()\">Duplicate</button>\n          <div class=\"dropdown-divider\"></div>\n          <button ngbDropdownItem class=\"text-danger\" (click)=\"actions['delete']()\">Delete</button>\n        </div>\n      </div>\n\n      <div *ngIf=\"mode && mode !== 'view'\">\n        <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" aria-expanded=\"true\"\n          (click)=\"actions['cancel'](null, mode)\">Cancel</button>\n        <button type=\"button\" class=\"btn btn-primary btn-sm\" aria-expanded=\"true\" (click)=\"actions['save']()\">Apply and\n          Publish\n          Changes</button>\n      </div>\n    </div>\n    <xf-button-group [buttons]=\"buttons\"></xf-button-group>\n\n  </div>\n</header>", styles: [".border-bottom-primary{border-bottom:2px solid var(--primary-tabs-default-border-color)}\n"] }]
    }], () => [{ type: i1.FormGroupDirective }, { type: i0.ChangeDetectorRef }, { type: i2.Router }, { type: i2.ActivatedRoute }, { type: i3.ViewTemplateService }, { type: i3.ViewTemplateService }, { type: i4.ModalService }, { type: i4.SpinnerService }], { mode: [{
            type: Input
        }], uuid: [{
            type: Input
        }], showBreadcrumbs: [{
            type: Input
        }], context: [{
            type: Input
        }], viewTemplate: [{
            type: Input
        }], viewTemplates: [{
            type: Input
        }], recordId: [{
            type: Input
        }], actions: [{
            type: Input
        }], buttons: [{
            type: Input
        }], allowEdit: [{
            type: Input
        }], loadViews: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ViewTemplateHeaderComponent, { className: "ViewTemplateHeaderComponent", filePath: "src/view-template/view-template-header/view-template-header.component.ts", lineNumber: 21 }); })();
export var ViewTemplateHeaderActions;
(function (ViewTemplateHeaderActions) {
    ViewTemplateHeaderActions["NEW"] = "new";
    ViewTemplateHeaderActions["SAVE"] = "save";
    ViewTemplateHeaderActions["EDIT"] = "edit";
    ViewTemplateHeaderActions["DUPLICATE"] = "duplicate";
    ViewTemplateHeaderActions["DELETE"] = "delete";
    ViewTemplateHeaderActions["CANCEL"] = "cancel";
})(ViewTemplateHeaderActions || (ViewTemplateHeaderActions = {}));
//# sourceMappingURL=data:application/json;base64,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