/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { FieldOptions, TextField } from 'shared';
import { ViewLayoutItem } from '../models/view-layout-item';
import { Widget } from '../models/widget';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "shared";
import * as i3 from "@angular/router";
import * as i4 from "./view-template.service";
import * as i5 from "@angular/common";
import * as i6 from "@ng-bootstrap/ng-bootstrap";
import * as i7 from "./layout-item/layout-item.component";
import * as i8 from "./widget-library/widget-library.component";
function ViewTemplateComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0, 3);
    i0.ɵɵelementStart(1, "div", 4)(2, "div", 5)(3, "label", 6);
    i0.ɵɵtext(4, "Title");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(5, "xf-form-field", 7);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.viewTemplateForm);
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("field", ctx_r0.titleField)("fieldOptions", ctx_r0.titleFieldOptions);
} }
function ViewTemplateComponent_div_1_xf_layout_item_2_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "xf-layout-item", 13);
    i0.ɵɵlistener("layoutItemChange", function ViewTemplateComponent_div_1_xf_layout_item_2_Template_xf_layout_item_layoutItemChange_0_listener($event) { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.onLayoutItemChange($event)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const container_r3 = ctx.$implicit;
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("context", ctx_r0.context)("layoutItem", container_r3)("viewTemplate", ctx_r0.viewTemplate)("mode", ctx_r0.mode)("widgetSelection$", ctx_r0.widgetSelection$);
} }
function ViewTemplateComponent_div_1_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 14)(1, "button", 15);
    i0.ɵɵlistener("click", function ViewTemplateComponent_div_1_div_3_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.addContainer()); });
    i0.ɵɵtext(2, "+ Add Container");
    i0.ɵɵelementEnd()();
} }
function ViewTemplateComponent_div_1_xf_widget_library_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "xf-widget-library", 16);
    i0.ɵɵlistener("widgetCollapsible", function ViewTemplateComponent_div_1_xf_widget_library_4_Template_xf_widget_library_widgetCollapsible_0_listener($event) { i0.ɵɵrestoreView(_r5); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.widgetLibraryCollapsible($event)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("widgetSelection$", ctx_r0.widgetSelection$);
} }
function ViewTemplateComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8)(1, "div", 9);
    i0.ɵɵtemplate(2, ViewTemplateComponent_div_1_xf_layout_item_2_Template, 1, 5, "xf-layout-item", 10)(3, ViewTemplateComponent_div_1_div_3_Template, 3, 0, "div", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(4, ViewTemplateComponent_div_1_xf_widget_library_4_Template, 1, 1, "xf-widget-library", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", ctx_r0.getWidth());
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r0.viewTemplate.layout);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.mode !== "view");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.mode !== "view");
} }
function ViewTemplateComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 17)(1, "ngb-alert", 18);
    i0.ɵɵtext(2, " View template not found. ");
    i0.ɵɵelementStart(3, "button", 19);
    i0.ɵɵlistener("click", function ViewTemplateComponent_div_2_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r6); const ctx_r0 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r0.newViewTemplate()); });
    i0.ɵɵtext(4, "Create one");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    i0.ɵɵadvance();
    i0.ɵɵproperty("dismissible", false);
} }
export class ViewTemplateComponent {
    constructor(rootFormGroup, utilityService, changeDetectorRef, route, viewTemplateService, spinnerService, modalService, router) {
        this.rootFormGroup = rootFormGroup;
        this.utilityService = utilityService;
        this.changeDetectorRef = changeDetectorRef;
        this.route = route;
        this.viewTemplateService = viewTemplateService;
        this.spinnerService = spinnerService;
        this.modalService = modalService;
        this.router = router;
        this.openedInPreview = false;
        this.loading = true;
        this.onAddViewTemplate = new EventEmitter();
        this.navigationCollapsed = false;
        this.widgetLibraryCollapsed = false;
        this.titleFieldOptions = new FieldOptions({
            showLabel: false,
            customErrorMessages: {
                unique: 'A view template with this title already exists'
            }
        });
        this.params = {};
        this.titleField = new TextField('viewTemplateTitle');
        this.titleField.title = 'Title';
        this.titleField.validation.required = true;
        this.widgetSelection$ = new BehaviorSubject(new Widget('', ''));
    }
    ngOnInit() {
        this.viewTemplateForm = this.rootFormGroup.control;
        this.viewTemplateForm?.controls.viewTemplateTitle.setValue(this.viewTemplate?.title);
        this.viewTemplateForm?.controls.viewTemplateTitle.valueChanges.subscribe((title) => this.viewTemplate ? this.viewTemplate.title = title : null);
        if (this.recordId) {
            this.params.recordId = this.recordId;
        }
        this.utilityService.navigationChanged.subscribe((value) => {
            this.navigationCollapsed = value;
            this.changeDetectorRef.detectChanges();
        });
    }
    onLayoutItemChange(layoutItem) {
        if (!this.viewTemplate) {
            return;
        }
        this.viewTemplate.layout.map((l) => l.id != layoutItem.id ? l : layoutItem);
        this.changeDetectorRef.detectChanges();
    }
    setSelectedWidget(widget) {
        this.selectedWidget = widget;
        this.changeDetectorRef.detectChanges();
    }
    widgetLibraryCollapsible(value) {
        // make use of the replay subject in viewTemplateService
        this.widgetLibraryCollapsed = value;
        this.changeDetectorRef.detectChanges();
    }
    addContainer() {
        let containerLayout = new ViewLayoutItem.Container([]);
        this.viewTemplate?.layout.push(containerLayout);
    }
    getWidth() {
        switch (this.mode) {
            case 'edit':
            case 'new': {
                if (this.widgetLibraryCollapsed && this.navigationCollapsed) {
                    return 'all-collapsed';
                }
                else if (this.navigationCollapsed && !this.widgetLibraryCollapsed) {
                    return 'navigation-collapsed';
                }
                else if (this.widgetLibraryCollapsed && !this.navigationCollapsed) {
                    return 'widget-library-collapsed';
                }
                else if (!this.widgetLibraryCollapsed && !this.navigationCollapsed) {
                    return 'none-collapsed';
                }
                else {
                    return 'none-collapsed';
                }
                break;
            }
            case 'view': {
                if (this.navigationCollapsed) {
                    return 'all-collapsed-view-mode';
                }
                else {
                    return 'widget-library-collapsed-view-mode';
                }
            }
            default: {
                return 'widget-library-collapsed-view-mode';
            }
        }
    }
    onWidgetDrop(event) {
        console.log(this.selectedWidget);
    }
    newViewTemplate() {
        this.params.mode = 'new';
        this.onAddViewTemplate.emit();
    }
    static { this.ɵfac = function ViewTemplateComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateComponent)(i0.ɵɵdirectiveInject(i1.FormGroupDirective), i0.ɵɵdirectiveInject(i2.UtilityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.ActivatedRoute), i0.ɵɵdirectiveInject(i4.ViewTemplateService), i0.ɵɵdirectiveInject(i2.SpinnerService), i0.ɵɵdirectiveInject(i2.ModalService), i0.ɵɵdirectiveInject(i3.Router)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ViewTemplateComponent, selectors: [["xf-view-template"]], inputs: { mode: "mode", uuid: "uuid", recordId: "recordId", viewTemplate: "viewTemplate", context: "context", openedInPreview: "openedInPreview", loading: "loading" }, outputs: { onAddViewTemplate: "onAddViewTemplate" }, decls: 3, vars: 3, consts: [[3, "formGroup", 4, "ngIf"], ["class", "d-flex", "cdkDropListGroup", "", 4, "ngIf"], ["class", "d-inline-flex p-2", 4, "ngIf"], [3, "formGroup"], [1, "row", "m-3", "pb-2", "border-bottom-primary"], [1, "col-xl-4", "col-lg-6", "col-md-12", "d-flex"], ["for", "viewTemplateTitle", 1, "form-label", "me-2", "mb-0", "align-self-center"], ["formControlName", "viewTemplateTitle", 3, "field", "fieldOptions"], ["cdkDropListGroup", "", 1, "d-flex"], [1, "view-template", 3, "ngClass"], [3, "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$", "layoutItemChange", 4, "ngFor", "ngForOf"], ["class", "m-2", 4, "ngIf"], [3, "widgetSelection$", "widgetCollapsible", 4, "ngIf"], [3, "layoutItemChange", "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$"], [1, "m-2"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "float-start", 3, "click"], [3, "widgetCollapsible", "widgetSelection$"], [1, "d-inline-flex", "p-2"], [3, "dismissible"], ["type", "button", 1, "btn", "btn-link", 3, "click"]], template: function ViewTemplateComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ViewTemplateComponent_ng_container_0_Template, 6, 3, "ng-container", 0)(1, ViewTemplateComponent_div_1_Template, 5, 4, "div", 1)(2, ViewTemplateComponent_div_2_Template, 5, 1, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.viewTemplateForm && (ctx.mode === "edit" || ctx.mode === "new"));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.viewTemplate && ctx.viewTemplate.layout);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.loading && !ctx.viewTemplate);
        } }, dependencies: [i5.NgClass, i5.NgForOf, i5.NgIf, i6.NgbAlert, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName, i2.FormFieldComponent, i7.LayoutItemComponent, i8.WidgetLibraryComponent], styles: [".view-template[_ngcontent-%COMP%]{width:calc(60vw - 58px);display:flex;flex-direction:column}.view-template.all-collapsed[_ngcontent-%COMP%]{width:calc(100vw - 100px)}.view-template.all-collapsed-view-mode[_ngcontent-%COMP%]{width:100vw}.view-template.navigation-collapsed[_ngcontent-%COMP%]{width:calc(75vw - 60px)}.view-template.widget-library-collapsed[_ngcontent-%COMP%]{width:calc(100vw - 60px)}.view-template.widget-library-collapsed-view-mode[_ngcontent-%COMP%]{width:100vw}.view-template.none-collapsed[_ngcontent-%COMP%]{width:calc(80vw - 90px)}.view-template[_ngcontent-%COMP%]   .data-toggle[_ngcontent-%COMP%]{width:inherit}.view-template[_ngcontent-%COMP%]   .template-containers[_ngcontent-%COMP%]{height:calc(100vh - 150px);max-width:calc(100vw - 10px)}.border-bottom-primary[_ngcontent-%COMP%]{border-bottom:2px solid var(--primary-tabs-default-border-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateComponent, [{
        type: Component,
        args: [{ selector: 'xf-view-template', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<ng-container [formGroup]=\"viewTemplateForm\" *ngIf=\"viewTemplateForm && (mode === 'edit' || mode === 'new')\">\n  <div class=\"row m-3 pb-2 border-bottom-primary\">\n    <div class=\"col-xl-4 col-lg-6 col-md-12 d-flex\">\n      <label for=\"viewTemplateTitle\" class=\"form-label me-2 mb-0 align-self-center\">Title</label>\n      <xf-form-field [field]=\"titleField\" formControlName=\"viewTemplateTitle\" [fieldOptions]=\"titleFieldOptions\">\n      </xf-form-field>\n    </div>\n  </div>\n</ng-container>\n\n<div class=\"d-flex\" *ngIf=\"viewTemplate && viewTemplate.layout\" cdkDropListGroup>\n  <div class=\"view-template\" [ngClass]=\"getWidth()\">\n    <!-- Show Data Toggle -->\n    <!-- <div class=\"col-md-12 data-toggle\" *ngIf=\"mode !== 'view'\">\n      <div class=\"form-switch float-end w-150px\">\n        <input class=\"form-check-input float-none\" type=\"checkbox\">\n        <label class=\"align-top font-size-14px form-check-label margin-left-6px\">Show Data</label>\n      </div>\n    </div> -->\n    <xf-layout-item *ngFor=\"let container of viewTemplate.layout\" [context]=\"context\" [layoutItem]=\"container\"\n      [viewTemplate]=\"viewTemplate\" [mode]=\"mode\" [widgetSelection$]=\"widgetSelection$\"\n      (layoutItemChange)=\"onLayoutItemChange($event)\"></xf-layout-item>\n    <!-- Add Container -->\n    <div class=\"col-md-12\" class=\"m-2\" *ngIf=\"mode !== 'view'\">\n      <button type=\"button\" class=\"btn btn-primary btn-sm float-start\" (click)=\"addContainer()\">+ Add\n        Container</button>\n    </div>\n\n  </div>\n  <xf-widget-library (widgetCollapsible)=\"widgetLibraryCollapsible($event)\" [widgetSelection$]=\"widgetSelection$\"\n    *ngIf=\"mode !== 'view'\"></xf-widget-library>\n</div>\n<div *ngIf=\"!loading && !viewTemplate\" class=\"d-inline-flex p-2\">\n  <ngb-alert [dismissible]=\"false\">\n    View template not found. <button class=\"btn btn-link\" type=\"button\" (click)=\"newViewTemplate()\">Create\n      one</button>\n  </ngb-alert>\n</div>", styles: [".view-template{width:calc(60vw - 58px);display:flex;flex-direction:column}.view-template.all-collapsed{width:calc(100vw - 100px)}.view-template.all-collapsed-view-mode{width:100vw}.view-template.navigation-collapsed{width:calc(75vw - 60px)}.view-template.widget-library-collapsed{width:calc(100vw - 60px)}.view-template.widget-library-collapsed-view-mode{width:100vw}.view-template.none-collapsed{width:calc(80vw - 90px)}.view-template .data-toggle{width:inherit}.view-template .template-containers{height:calc(100vh - 150px);max-width:calc(100vw - 10px)}.border-bottom-primary{border-bottom:2px solid var(--primary-tabs-default-border-color)}\n"] }]
    }], () => [{ type: i1.FormGroupDirective }, { type: i2.UtilityService }, { type: i0.ChangeDetectorRef }, { type: i3.ActivatedRoute }, { type: i4.ViewTemplateService }, { type: i2.SpinnerService }, { type: i2.ModalService }, { type: i3.Router }], { mode: [{
            type: Input
        }], uuid: [{
            type: Input
        }], recordId: [{
            type: Input
        }], viewTemplate: [{
            type: Input
        }], context: [{
            type: Input
        }], openedInPreview: [{
            type: Input
        }], loading: [{
            type: Input
        }], onAddViewTemplate: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ViewTemplateComponent, { className: "ViewTemplateComponent", filePath: "src/view-template/view-template.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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