/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component } from '@angular/core';
import { flattenDeep } from 'lodash-es';
import { concatMap } from 'rxjs';
import { Query } from "shared";
import { AbstractWidgetComponent } from '../../abstract-widget.component';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common";
function FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "xf-editable-field", 9);
    i0.ɵɵlistener("valueChange", function FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_div_3_Template_xf_editable_field_valueChange_1_listener($event) { i0.ɵɵrestoreView(_r1); const field_r2 = i0.ɵɵnextContext(2).$implicit; const ctx_r2 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r2.valueChanged(field_r2.name, $event)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const field_r2 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngClass", (ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.showInline) ? "d-inline-block w-70" : "d-block");
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r2.entity.fields[field_r2.name])("value", ctx_r2.entity.values[field_r2.name])("readOnly", field_r2.readOnly || ctx_r2.mode === "edit");
} }
function FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "h5", 6);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_div_3_Template, 2, 4, "div", 7);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const field_r2 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", (ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.showInline) ? "d-inline-block w-30 align-self-center margin-top-8px" : "d-block");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r2.entity.fields[field_r2.name].title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.entity.fields[field_r2.name]);
} }
function FieldGroupViewComponent_div_0_div_1_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 4);
    i0.ɵɵtemplate(1, FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_Template, 4, 3, "ng-container", 5);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r2 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngClass", (ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.showInline) ? "d-flex" : "d-block");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.entity.fields[field_r2.name]);
} }
function FieldGroupViewComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, FieldGroupViewComponent_div_0_div_1_div_1_Template, 2, 2, "div", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const col_r4 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵclassMap("col-md-" + 12 / ((ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.cols == null ? null : ctx_r2.widgetConfig.configuration.cols.length) || 12));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", col_r4);
} }
function FieldGroupViewComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, FieldGroupViewComponent_div_0_div_1_Template, 2, 3, "div", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.cols);
} }
export class FieldGroupViewComponent extends AbstractWidgetComponent {
    constructor(_changeDetectorRef, dataProvider, entityService) {
        super(_changeDetectorRef);
        this.dataProvider = dataProvider;
        this.entityService = entityService;
        this.editModes = {};
        this.allFieldNames = [];
    }
    subscribeToData() {
        if (!this.context?.module) {
            return;
        }
        this.allFieldNames = flattenDeep(this.fieldGroupConfig.configuration.cols.map((col) => col.map((field) => field.name)));
        let topic = this.context?.uuid + this.allFieldNames.join('-');
        if (this.existingRequest === topic) {
            return;
        }
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
        this.existingRequest = topic;
        this.subscription = this.entityService.build(this.context.module).pipe(concatMap((entity) => {
            return this.dataProvider.observe(entity, this.context?.uuid, undefined, new Query({ selectedFields: this.allFieldNames }));
        })).subscribe((entityChange) => {
            this.entity = entityChange.entity;
            this.existingRequest = undefined;
            this.changeDetectorRef.detectChanges();
        });
    }
    widgetConfigChanged(widgetConfig) {
        this.fieldGroupConfig = widgetConfig;
        this.subscribeToData();
    }
    valueChanged(fieldName, value) {
        if (!this.entity) {
            return;
        }
        this.entity.values[fieldName] = value;
        this.dataProvider.save({
            entity: this.entity,
            changedFields: [fieldName],
            sourceId: this.fieldGroupConfig.uuid || null
        }).subscribe();
    }
    ngOnDestroy() {
        this.subscription.unsubscribe();
    }
    contextChanged(context) {
        this.context = context;
        this.subscribeToData();
    }
    static { this.ɵfac = function FieldGroupViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldGroupViewComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.DataProviderService), i0.ɵɵdirectiveInject(i1.EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldGroupViewComponent, selectors: [["xf-field-group-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["class", "row", 4, "ngIf"], [1, "row"], [3, "class", 4, "ngFor", "ngForOf"], ["class", "form-group mb-4 mt-3", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "form-group", "mb-4", "mt-3", 3, "ngClass"], [4, "ngIf"], [1, "detail-view-label", 3, "ngClass"], [3, "ngClass", 4, "ngIf"], [3, "ngClass"], [3, "valueChange", "field", "value", "readOnly"]], template: function FieldGroupViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FieldGroupViewComponent_div_0_Template, 2, 1, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.entity);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, i1.EditableFieldComponent], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldGroupViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-group-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"row\" *ngIf=\"entity\">\n  <div *ngFor=\"let col of widgetConfig.configuration?.cols; let colIndex = index\"\n    [class]=\"'col-md-' + 12 / (widgetConfig.configuration?.cols?.length || 12)\">\n    <div class=\"form-group mb-4 mt-3\" [ngClass]=\"widgetConfig.configuration?.showInline ? 'd-flex' : 'd-block'\"\n      *ngFor=\"let field of col\">\n      <ng-container *ngIf=\"entity.fields[field.name]\">\n        <h5 class=\"detail-view-label\"\n          [ngClass]=\"widgetConfig.configuration?.showInline ? 'd-inline-block w-30 align-self-center margin-top-8px' : 'd-block'\">\n          {{ entity.fields[field.name]!.title }}\n        </h5>\n        <div [ngClass]=\"widgetConfig.configuration?.showInline ? 'd-inline-block w-70' : 'd-block'\"\n          *ngIf=\"entity.fields[field.name]\">\n          <xf-editable-field [field]=\"entity.fields[field.name]!\" [value]=\"entity.values[field.name]\"\n            (valueChange)=\"valueChanged(field.name, $event)\" [readOnly]=\"field.readOnly || mode === 'edit'\">\n          </xf-editable-field>\n        </div>\n      </ng-container>\n    </div>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.DataProviderService }, { type: i1.EntityService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldGroupViewComponent, { className: "FieldGroupViewComponent", filePath: "src/widgets/field-group/field-group-view/field-group-view.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,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