import * as i1 from '@angular/common';
import { CommonModule, DOCUMENT, isPlatformBrowser } from '@angular/common';
import * as i0 from '@angular/core';
import { inject, SecurityContext, Pipe, EventEmitter, ElementRef, forwardRef, Component, ChangeDetectionStrategy, ViewChild, ViewChildren, Input, Output, Directive, HostListener, Injectable, NgModule, Inject, InjectionToken, PLATFORM_ID, Optional, ChangeDetectorRef, HostBinding, numberAttribute } from '@angular/core';
import * as i2 from '@angular/forms';
import { Validators, NG_VALUE_ACCESSOR, NG_VALIDATORS, FormControl, FormBuilder, FormsModule, FormGroup, ReactiveFormsModule } from '@angular/forms';
import * as i4$1 from 'ang-jsoneditor';
import { JsonEditorOptions, JsonEditorComponent, NgJsonEditorModule } from 'ang-jsoneditor';
import * as i5 from 'ng-multiselect-dropdown';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import * as i3 from '@ng-bootstrap/ng-bootstrap';
import { NgbDropdown, NgbDropdownItem, NgbDropdownModule, NgbTooltipModule, NgbDatepickerModule, NgbTimepickerModule, NgbNavModule, NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
import { fromEvent, of, from, map as map$1, Subject, ReplaySubject, throwError, catchError as catchError$1, takeUntil, forkJoin, concatMap as concatMap$1, combineLatest, debounceTime as debounceTime$1, filter, BehaviorSubject, tap as tap$1, timer, zip, finalize as finalize$1, switchMap as switchMap$1 } from 'rxjs';
import { map, startWith, debounceTime, distinctUntilChanged, tap, concatMap, catchError, skip, filter as filter$1, retry, take, finalize, switchAll, scan, switchMap, takeWhile, last } from 'rxjs/operators';
import * as i4 from '@jsverse/transloco';
import { TranslocoModule, TranslocoService } from '@jsverse/transloco';
import { DomSanitizer } from '@angular/platform-browser';
import * as _ from 'lodash-es';
import ___default, { cloneDeep, extend, forEach, isUndefined, isObject, isEqual, isString, keys, keyBy, values, sortBy, isArray, merge, isBoolean, compact, isNumber, difference, intersection, flatten, uniq } from 'lodash-es';
import * as i1$1 from '@angular/common/http';
import { HttpContextToken, HttpClient, HttpContext, HttpParams, HttpErrorResponse } from '@angular/common/http';
import { plainToInstance, Type, Transform, Expose } from 'class-transformer';
import { loadRemoteModule } from '@angular-architects/native-federation';
import { v4 } from 'uuid';
import { __decorate } from 'tslib';
import * as i1$2 from '@angular/router';
import { RouterModule, NavigationEnd } from '@angular/router';
import * as i2$1 from 'xng-breadcrumb';
import { BreadcrumbItemDirective, BreadcrumbComponent } from 'xng-breadcrumb';
import { exampleSetup } from 'prosemirror-example-setup';
import { defaultMarkdownParser, schema, defaultMarkdownSerializer } from 'prosemirror-markdown';
import { EditorState } from 'prosemirror-state';
import { EditorView } from 'prosemirror-view';
import { DOMSerializer } from 'prosemirror-model';
import { autocompletion, completionKeymap } from '@codemirror/autocomplete';
import { StreamLanguage, HighlightStyle, syntaxHighlighting } from '@codemirror/language';
import { jinja2 } from '@codemirror/legacy-modes/mode/jinja2';
import { Prec, EditorState as EditorState$1 } from '@codemirror/state';
import { keymap, placeholder } from '@codemirror/view';
import { basicSetup, EditorView as EditorView$1 } from 'codemirror';
import { linter } from '@codemirror/lint';
import { tags } from '@lezer/highlight';
import { ToastrService } from 'ngx-toastr';
import { TreeComponent } from '@ali-hm/angular-tree-component';
import { webSocket } from 'rxjs/webSocket';
import * as i2$2 from 'ngx-filesaver';
import cronstrue from 'cronstrue';

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class HighlightPipe {
    constructor() {
        this.domSanitizer = inject(DomSanitizer);
    }
    transform(input, searchText) {
        if (!searchText) {
            return input; // If no search term, return the input unchanged
        }
        // Split the searchText into words and escape them for regex
        const searchWords = searchText.split(' ').map(word => word.trim()).filter(word => word.length > 0);
        const regex = new RegExp(`(${searchWords.join('|')})`, 'gi');
        // Replace matched words with highlighted version
        input = input.replace(regex, match => `<mark class='highlighted-result p-0'>${match}</mark>`);
        const sanitized = this.domSanitizer.sanitize(SecurityContext.HTML, input) || '';
        return sanitized;
    }
    static { this.ɵfac = function HighlightPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || HighlightPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "highlight", type: HighlightPipe, pure: true }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(HighlightPipe, [{
        type: Pipe,
        args: [{
                name: 'highlight'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$z = ["searchInput"];
const _c1$m = ["inputField"];
const _c2$b = a0 => ({ "d-inline-block": a0 });
const _c3$5 = (a0, a1, a2) => ({ "btn-select d-flex form-select": a0, "btn-link p-0": a1, "is-invalid": a2 });
const _c4$2 = a0 => ({ "active": a0 });
function SearchableDropdownComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 13);
    i0.ɵɵlistener("click", function SearchableDropdownComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.selectItem(null)); })("keydown.arrowup", function SearchableDropdownComponent_div_0_div_7_button_1_Template_button_keydown_arrowup_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.dropdownItems.last.nativeElement.previousElementSibling.previousElementSibling.focus()); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(2, _c4$2, !ctx_r1.value));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.clearText);
} }
function SearchableDropdownComponent_div_0_div_7_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 14);
} }
function SearchableDropdownComponent_div_0_div_7_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 15);
    i0.ɵɵpipe(1, "highlight");
    i0.ɵɵlistener("click", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_click_0_listener() { const item_r5 = i0.ɵɵrestoreView(_r4).$implicit; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.selectItem(item_r5)); })("keydown.arrowup", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_keydown_arrowup_0_listener() { const i_r6 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.focusOnItem(i_r6 - 1)); })("keydown.arrowdown", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_keydown_arrowdown_0_listener() { const i_r6 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.focusOnItem(i_r6 + 1)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r5 = ctx.$implicit;
    const t_r7 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c4$2, ctx_r1.value && item_r5.value.uuid === ctx_r1.value.uuid))("innerHTML", i0.ɵɵpipeBind2(1, 3, t_r7(item_r5.display) + "", ctx_r1.searchText), i0.ɵɵsanitizeHtml)("title", t_r7(item_r5.display));
} }
function SearchableDropdownComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵtemplate(1, SearchableDropdownComponent_div_0_div_7_button_1_Template, 2, 4, "button", 10)(2, SearchableDropdownComponent_div_0_div_7_div_2_Template, 1, 0, "div", 11)(3, SearchableDropdownComponent_div_0_div_7_button_3_Template, 2, 8, "button", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.items);
} }
function SearchableDropdownComponent_div_0_div_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵelement(1, "div", 17)(2, "div", 17)(3, "div", 17);
    i0.ɵɵelementEnd();
} }
function SearchableDropdownComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵlistener("openChange", function SearchableDropdownComponent_div_0_Template_div_openChange_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.firstLoad()); });
    i0.ɵɵelementStart(1, "button", 4, 0);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 5)(5, "input", 6, 1);
    i0.ɵɵlistener("keyup.arrowdown", function SearchableDropdownComponent_div_0_Template_input_keyup_arrowdown_5_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.focusOnItem(0)); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, SearchableDropdownComponent_div_0_div_7_Template, 4, 3, "div", 7)(8, SearchableDropdownComponent_div_0_div_8_Template, 4, 0, "div", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r7 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c2$b, ctx_r1.buttonStyle !== "select"))("container", ctx_r1.container);
    i0.ɵɵadvance();
    i0.ɵɵproperty("disabled", ctx_r1.disabled)("ngClass", i0.ɵɵpureFunction3(9, _c3$5, ctx_r1.buttonStyle === "select", ctx_r1.buttonStyle !== "select", ctx_r1.touched && ctx_r1.invalid));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.value ? t_r7(ctx_r1.value.display) : t_r7(ctx_r1.placeholder) || "Select");
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.loading);
} }
class SearchableDropdownComponent {
    constructor(_formBuilder, changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.onChange = null;
        this.onTouched = null;
        this.buttonStyle = 'button';
        this.searchQueryChange = new EventEmitter();
        this.required = false;
        this.invalid = false;
        this.touched = false;
        this.clearValueOnSelect = false;
        this.placeholder = 'Choose';
        this.clearText = 'None';
        this.container = null;
        this.disabled = false;
        this.searchText = '';
        this.loading = true;
    }
    ngOnChanges(changes) {
        if (changes.items) {
            this.loading = false;
        }
    }
    ngDoCheck() {
        if (this.touched) {
            return;
        }
        if (this.control?.touched) {
            this.touched = true;
            this.changeDetectorRef.detectChanges();
        }
    }
    focusOnSearchInput() {
        setTimeout(() => {
            this.searchInput.nativeElement.focus();
            this.searchInput.nativeElement.select();
        });
    }
    focusOnItem(index) {
        if (index === -1) {
            this.focusOnSearchInput();
        }
        this.dropdownItems.get(index)?.nativeElement.focus();
    }
    firstLoad() {
        if (!this.dropdown.isOpen()) {
            this.searchInput.nativeElement.value = '';
            return;
        }
        this.setTouched();
        this.loading = true;
        if (this.keyupSubscription) {
            this.keyupSubscription.unsubscribe();
        }
        //this.searchQueryChange.next('');
        this.keyupSubscription = fromEvent(this.searchInput.nativeElement, 'keyup')
            .pipe(map(event => event.target.value), startWith(''), debounceTime(300), distinctUntilChanged(), tap((search) => this.searchText = search))
            .subscribe((search) => this.searchQueryChange.next(search));
        setTimeout(() => {
            this.focusOnSearchInput();
        });
    }
    selectItem(item) {
        if (!this.clearValueOnSelect) {
            this.value = item;
        }
        if (this.onChange) {
            this.onChange(item);
        }
        this.dropdown.close();
    }
    open() {
        this.dropdown.open();
    }
    focus() {
        this.inputField.nativeElement.focus();
    }
    setTouched() {
        this.touched = true;
        this.control?.markAsTouched();
        this.changeDetectorRef.detectChanges();
    }
    writeValue(value) {
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    validate(control) {
        this.control = control;
        this.required = control.hasValidator(Validators.required);
        if (this.required && !this.value) {
            this.invalid = true;
            return {
                required: true
            };
        }
        this.invalid = false;
        return null;
    }
    static { this.ɵfac = function SearchableDropdownComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SearchableDropdownComponent)(i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: SearchableDropdownComponent, selectors: [["xf-searchable-dropdown"]], viewQuery: function SearchableDropdownComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$z, 5);
            i0.ɵɵviewQuery(_c1$m, 5);
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(NgbDropdownItem, 5, ElementRef);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.inputField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownItems = _t);
        } }, inputs: { items: "items", buttonStyle: "buttonStyle", clearValueOnSelect: "clearValueOnSelect", placeholder: "placeholder", clearText: "clearText", container: "container", disabled: "disabled" }, outputs: { searchQueryChange: "searchQueryChange" }, features: [i0.ɵɵProvidersFeature([
                {
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => SearchableDropdownComponent),
                    multi: true,
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => SearchableDropdownComponent),
                    multi: true
                }
            ]), i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["inputField", ""], ["searchInput", ""], ["ngbDropdown", "", 3, "ngClass", "container", "openChange", 4, "transloco"], ["ngbDropdown", "", 3, "openChange", "ngClass", "container"], ["type", "button", "id", "dropdownForm1", "ngbDropdownToggle", "", 1, "btn", "btn-sm", 3, "disabled", "ngClass"], ["ngbDropdownMenu", "", "aria-labelledby", "dropdownForm1", 1, "dropdown-menu-wide"], ["type", "text", "id", "searchDropdown", "placeholder", "Search", "autocomplete", "off", 1, "form-control", "form-control-sm", "lookup-search", 3, "keyup.arrowdown"], ["class", "dropdown-items", 4, "ngIf"], ["class", "p-3", 4, "ngIf"], [1, "dropdown-items"], ["type", "button", "ngbDropdownItem", "", 3, "ngClass", "click", "keydown.arrowup", 4, "ngIf"], ["class", "dropdown-divider", 4, "ngIf"], ["type", "button", "ngbDropdownItem", "", 3, "ngClass", "innerHTML", "title", "click", "keydown.arrowup", "keydown.arrowdown", 4, "ngFor", "ngForOf"], ["type", "button", "ngbDropdownItem", "", 3, "click", "keydown.arrowup", "ngClass"], [1, "dropdown-divider"], ["type", "button", "ngbDropdownItem", "", 3, "click", "keydown.arrowup", "keydown.arrowdown", "ngClass", "innerHTML", "title"], [1, "p-3"], [1, "bg-shimmer", "content-line"]], template: function SearchableDropdownComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, SearchableDropdownComponent_div_0_Template, 9, 13, "div", 2);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu, i3.NgbDropdownItem, i3.NgbDropdownButtonItem, i4.TranslocoDirective, HighlightPipe], styles: [".max-width-200[_ngcontent-%COMP%]{width:100%;max-width:200px}.lookup-search[_ngcontent-%COMP%]{width:calc(100% - 30px);margin:5px 15px 10px}.dropdown-toggle[_ngcontent-%COMP%]:after{display:none}.dropdown-menu-wide[_ngcontent-%COMP%]{width:100%;font-size:12px}.dropdown-menu-wide[_ngcontent-%COMP%]   .dropdown-items[_ngcontent-%COMP%]{max-height:300px;overflow:auto}.dropdown-menu-wide[_ngcontent-%COMP%]   .dropdown-items[_ngcontent-%COMP%]   .dropdown-item[_ngcontent-%COMP%]{padding:8px 25px;font-size:12px;white-space:normal;max-width:500px}.btn-select[_ngcontent-%COMP%]{width:100%;border:1px solid var(--form-default-border-color);background-color:var(--form-default-bg-color);border-radius:3px;text-align:left;color:var(--btn-select-color)}.btn-select.btn-sm[_ngcontent-%COMP%]{padding:8.25px 10px}.btn-select.btn-sm[_ngcontent-%COMP%]:disabled{cursor:not-allowed;pointer-events:auto}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SearchableDropdownComponent, [{
        type: Component,
        args: [{ selector: 'xf-searchable-dropdown', changeDetection: ChangeDetectionStrategy.OnPush, providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => SearchableDropdownComponent),
                        multi: true,
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => SearchableDropdownComponent),
                        multi: true
                    }
                ], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div ngbDropdown [ngClass]=\"{'d-inline-block': buttonStyle !== 'select'}\" (openChange)=\"firstLoad()\" *transloco=\"let t\"\n  [container]=\"container\">\n  <button type=\"button\" class=\"btn btn-sm\" [disabled]=\"disabled\"\n    [ngClass]=\"{'btn-select d-flex form-select': buttonStyle === 'select', 'btn-link p-0': buttonStyle !== 'select', 'is-invalid': touched && invalid}\"\n    id=\"dropdownForm1\" ngbDropdownToggle #inputField>{{ value ? t(value.display) : t(placeholder) || 'Select' }}</button>\n  <div ngbDropdownMenu aria-labelledby=\"dropdownForm1\" class=\"dropdown-menu-wide\">\n    <input type=\"text\" class=\"form-control form-control-sm lookup-search\" id=\"searchDropdown\" #searchInput\n      placeholder=\"Search\" (keyup.arrowdown)=\"focusOnItem(0)\" autocomplete=\"off\">\n    <div *ngIf=\"!loading\" class=\"dropdown-items\">\n      <button type=\"button\" ngbDropdownItem *ngIf=\"!required\" (click)=\"selectItem(null)\"\n        (keydown.arrowup)=\"dropdownItems.last.nativeElement.previousElementSibling.previousElementSibling.focus()\"\n        [ngClass]=\"{'active': !value}\">{{ clearText }}</button>\n      <div class=\"dropdown-divider\" *ngIf=\"!required\"></div>\n      <button type=\"button\" ngbDropdownItem *ngFor=\"let item of items; let i = index\" (click)=\"selectItem(item)\"\n        (keydown.arrowup)=\"focusOnItem(i - 1)\" (keydown.arrowdown)=\"focusOnItem(i + 1)\"\n        [ngClass]=\"{'active': value && item.value.uuid === value.uuid}\" [innerHTML]=\"(t(item.display) + '') | highlight: searchText\" [title]=\"t(item.display)\"></button>\n    </div>\n    <div class=\"p-3\" *ngIf=\"loading\">\n      <div class=\"bg-shimmer content-line\"></div>\n      <div class=\"bg-shimmer content-line\"></div>\n      <div class=\"bg-shimmer content-line\"></div>\n    </div>\n  </div>\n</div>\n", styles: [".max-width-200{width:100%;max-width:200px}.lookup-search{width:calc(100% - 30px);margin:5px 15px 10px}.dropdown-toggle:after{display:none}.dropdown-menu-wide{width:100%;font-size:12px}.dropdown-menu-wide .dropdown-items{max-height:300px;overflow:auto}.dropdown-menu-wide .dropdown-items .dropdown-item{padding:8px 25px;font-size:12px;white-space:normal;max-width:500px}.btn-select{width:100%;border:1px solid var(--form-default-border-color);background-color:var(--form-default-bg-color);border-radius:3px;text-align:left;color:var(--btn-select-color)}.btn-select.btn-sm{padding:8.25px 10px}.btn-select.btn-sm:disabled{cursor:not-allowed;pointer-events:auto}\n"] }]
    }], () => [{ type: i2.FormBuilder }, { type: i0.ChangeDetectorRef }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], inputField: [{
            type: ViewChild,
            args: ['inputField']
        }], dropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], dropdownItems: [{
            type: ViewChildren,
            args: [NgbDropdownItem, { read: ElementRef }]
        }], items: [{
            type: Input
        }], buttonStyle: [{
            type: Input
        }], searchQueryChange: [{
            type: Output
        }], clearValueOnSelect: [{
            type: Input
        }], placeholder: [{
            type: Input
        }], clearText: [{
            type: Input
        }], container: [{
            type: Input
        }], disabled: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(SearchableDropdownComponent, { className: "SearchableDropdownComponent", filePath: "lib/components/searchable-dropdown/searchable-dropdown.component.ts", lineNumber: 30 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class FocusInvalidInputDirective {
    constructor(el) {
        this.el = el;
    }
    onFormSubmit() {
        const invalidControl = this.el.nativeElement.querySelector('.ng-invalid');
        if (invalidControl) {
            invalidControl.focus();
        }
    }
    static { this.ɵfac = function FocusInvalidInputDirective_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FocusInvalidInputDirective)(i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: FocusInvalidInputDirective, selectors: [["", "focusInvalidInput", ""]], hostBindings: function FocusInvalidInputDirective_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("submit", function FocusInvalidInputDirective_submit_HostBindingHandler() { return ctx.onFormSubmit(); });
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FocusInvalidInputDirective, [{
        type: Directive,
        args: [{
                selector: '[focusInvalidInput]'
            }]
    }], () => [{ type: i0.ElementRef }], { onFormSubmit: [{
            type: HostListener,
            args: ['submit']
        }] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class AsPipe {
    transform(value, _type) {
        return value;
    }
    static { this.ɵfac = function AsPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AsPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "as", type: AsPipe, pure: true }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AsPipe, [{
        type: Pipe,
        args: [{
                name: 'as',
                pure: true
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class GetEndPathNamePipe {
    transform(input) {
        if (typeof (input) === 'string') {
            let inputStr = cloneDeep(input);
            if (input.charAt(input.length - 1) === '/') {
                inputStr = inputStr.slice(0, -1);
            }
            var parameters = inputStr.split('/');
            var lastIndex = parameters.length - 1;
            return parameters[lastIndex].split('?')[0];
        }
        return input;
    }
    static { this.ɵfac = function GetEndPathNamePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GetEndPathNamePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "getEndPathName", type: GetEndPathNamePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GetEndPathNamePipe, factory: GetEndPathNamePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GetEndPathNamePipe, [{
        type: Pipe,
        args: [{
                name: 'getEndPathName'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class InterpolatePipe {
    transform(stringTemplate, interpolateObject) {
        function getNestedValue(obj, keyPath) {
            return keyPath.split('.').reduce((acc, key) => (acc && acc[key] !== undefined) ? acc[key] : '', obj);
        }
        function interpolate(template, data) {
            return template.replace(/{{([\s\S]+?)}}/g, (match, p1) => getNestedValue(data, p1.trim()) || '');
        }
        const extendedContext = interpolateObject;
        return interpolate(stringTemplate, extendedContext);
    }
    static { this.ɵfac = function InterpolatePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || InterpolatePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "interpolate", type: InterpolatePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: InterpolatePipe, factory: InterpolatePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(InterpolatePipe, [{
        type: Pipe,
        args: [{
                name: 'interpolate'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class IsHexColorLightPipe {
    transform(color) {
        if (!color) {
            return false;
        }
        const hex = color.replace('#', '');
        const colorRed = parseInt(hex.substring(0, 2), 16);
        const colorGreen = parseInt(hex.substring(2, 2), 16);
        const colorBlue = parseInt(hex.substring(4, 2), 16);
        const brightness = ((colorRed * 299) + (colorGreen * 587) + (colorBlue * 114)) / 1000;
        return brightness > 155;
    }
    static { this.ɵfac = function IsHexColorLightPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IsHexColorLightPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "isHexColorLight", type: IsHexColorLightPipe, pure: true }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IsHexColorLightPipe, [{
        type: Pipe,
        args: [{
                name: 'isHexColorLight'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SlugifyPipe {
    transform(str) {
        return str
            .toLowerCase()
            .trim()
            .replace(/[^\w\s-]/g, '')
            .replace(/[\s_-]+/g, '-')
            .replace(/^-+|-+$/g, '');
    }
    static { this.ɵfac = function SlugifyPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SlugifyPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "slugify", type: SlugifyPipe, pure: true }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SlugifyPipe, [{
        type: Pipe,
        args: [{
                name: 'slugify'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$y = ["confirmButton"];
const _c1$l = ["button"];
const _c2$a = a0 => ({ "float-end ms-1": a0 });
function ModalComponent_button_9_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 13);
    i0.ɵɵlistener("click", function ModalComponent_button_9_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.activeModal.close(false)); });
    i0.ɵɵtext(1, "Cancel");
    i0.ɵɵelementEnd();
} }
function ModalComponent_button_10_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 14, 0);
    i0.ɵɵlistener("click", function ModalComponent_button_10_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.activeModal.close(true)); });
    i0.ɵɵtext(2, "Yes, Confirm");
    i0.ɵɵelementEnd();
} }
function ModalComponent_button_11_i_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i");
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵclassMap(button_r5.iconClass);
} }
function ModalComponent_button_11_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 15, 1);
    i0.ɵɵlistener("click", function ModalComponent_button_11_Template_button_click_0_listener() { const button_r5 = i0.ɵɵrestoreView(_r4).$implicit; const ctx_r1 = i0.ɵɵnextContext(); button_r5.onClick(); return i0.ɵɵresetView(ctx_r1.activeModal.dismiss()); });
    i0.ɵɵtemplate(2, ModalComponent_button_11_i_2_Template, 1, 2, "i", 16);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const button_r5 = ctx.$implicit;
    i0.ɵɵclassMapInterpolate1("btn ", button_r5.class ? button_r5.class : "btn-secondary", " btn-sm");
    i0.ɵɵpropertyInterpolate("title", button_r5.title ? button_r5.title : button_r5.text);
    i0.ɵɵproperty("disabled", button_r5.disabled)("ngClass", i0.ɵɵpureFunction1(9, _c2$a, button_r5.pullRight))("id", button_r5.id);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", button_r5.iconClass);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", button_r5.text, " ");
} }
class ModalComponent {
    constructor(activeModal) {
        this.activeModal = activeModal;
        this.buttons = [];
        this.hideCancelButton = false;
        this.showConfirmButton = true;
        this.showCancelButton = true;
    }
    ngOnInit() {
        this.showCancelButton = this.hideCancelButton ? this.hideCancelButton : true;
        if (this.buttons && this.buttons.length > 0) {
            this.showConfirmButton = false;
        }
    }
    ngAfterViewInit() {
        let index = this.buttons.findIndex((button) => button.class && button.type === 'submit');
        setTimeout(() => this.buttonElements.get(index)?.nativeElement.focus());
        if (this.showConfirmButton) {
            setTimeout(() => this.confirmButton.nativeElement.focus());
        }
    }
    static { this.ɵfac = function ModalComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModalComponent)(i0.ɵɵdirectiveInject(i3.NgbActiveModal)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ModalComponent, selectors: [["xf-modal"]], viewQuery: function ModalComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$y, 5);
            i0.ɵɵviewQuery(_c1$l, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.confirmButton = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.buttonElements = _t);
        } }, inputs: { confirmationBoxTitle: "confirmationBoxTitle", confirmationMessage: "confirmationMessage", buttons: "buttons", hideCancelButton: "hideCancelButton" }, decls: 12, vars: 6, consts: [["confirmButton", ""], ["button", ""], [1, "modal-header", "padding-bottom-0px", "padding-left-18px", "padding-right-18px", "padding-top-20px", "confirmation-modal-header"], [1, "d-flex"], [1, "confirmation-icon"], [1, "modal-title", "font-size-20px"], ["type", "button", "aria-label", "Close", 1, "btn", "btn-close", "btn-sm", "modal-btn-close", 3, "click"], [1, "modal-body"], [1, "font-size-14px", "margin-left-40px", "muted-10", "padding-left-12px", "padding-right-12px", 3, "innerHtml"], [1, "modal-footer", "padding-bottom-8px", "padding-top-8px", "padding-left-18px", "padding-right-18px", "confirmation-modal-footer", 3, "ngClass"], ["type", "button", "class", "btn btn-secondary btn-sm", "title", "Cancel", 3, "click", 4, "ngIf"], ["type", "submit", "class", "btn btn-primary btn-sm", "title", "Confirm", 3, "click", 4, "ngIf"], ["type", "button", 3, "class", "title", "disabled", "ngClass", "id", "click", 4, "ngFor", "ngForOf"], ["type", "button", "title", "Cancel", 1, "btn", "btn-secondary", "btn-sm", 3, "click"], ["type", "submit", "title", "Confirm", 1, "btn", "btn-primary", "btn-sm", 3, "click"], ["type", "button", 3, "click", "title", "disabled", "ngClass", "id"], [3, "class", 4, "ngIf"]], template: function ModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 2)(1, "div", 3);
            i0.ɵɵelement(2, "span", 4);
            i0.ɵɵelementStart(3, "h4", 5);
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "button", 6);
            i0.ɵɵlistener("click", function ModalComponent_Template_button_click_5_listener() { return ctx.activeModal.dismiss("Cross click"); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 7);
            i0.ɵɵelement(7, "p", 8);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 9);
            i0.ɵɵtemplate(9, ModalComponent_button_9_Template, 2, 0, "button", 10)(10, ModalComponent_button_10_Template, 3, 0, "button", 11)(11, ModalComponent_button_11_Template, 4, 11, "button", 12);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵtextInterpolate(ctx.confirmationBoxTitle);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("innerHtml", ctx.confirmationMessage, i0.ɵɵsanitizeHtml);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", ctx.buttons ? "" : "d-flex justify-content-end");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.showCancelButton);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.showConfirmButton);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.buttons);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf], styles: [".modal-header[_ngcontent-%COMP%]{border-top:4px solid var(--toaster-info-color)}.modal-header.confirmation-modal-header[_ngcontent-%COMP%]{border-bottom:none}.modal-header[_ngcontent-%COMP%]   .confirmation-icon[_ngcontent-%COMP%]{background-image:var(--toaster-info-svg);background-size:28px 28px;width:28px;height:28px;margin-right:12px;background-repeat:no-repeat}.modal-header[_ngcontent-%COMP%]   .modal-btn-close[_ngcontent-%COMP%]{background-image:var(--modal-close-btn-icon);background-size:10px}.modal-footer[_ngcontent-%COMP%]{border-top:1px solid var(--highlight-default-color)}.modal-footer.confirmation-modal-footer[_ngcontent-%COMP%]{border-top:1px solid var(--modal-footer-border-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModalComponent, [{
        type: Component,
        args: [{ selector: 'xf-modal', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div\n  class=\"modal-header padding-bottom-0px padding-left-18px padding-right-18px padding-top-20px confirmation-modal-header\">\n  <div class=\"d-flex\">\n    <span class=\"confirmation-icon\"></span>\n    <h4 class=\"modal-title font-size-20px\">{{confirmationBoxTitle}}</h4>\n  </div>\n  <button type=\"button\" class=\"btn btn-close btn-sm modal-btn-close\" aria-label=\"Close\"\n    (click)=\"activeModal.dismiss('Cross click')\"></button>\n</div>\n<div class=\"modal-body\">\n  <p class=\"font-size-14px margin-left-40px muted-10 padding-left-12px padding-right-12px\"\n    [innerHtml]=\"confirmationMessage\"></p>\n</div>\n<div\n  class=\"modal-footer padding-bottom-8px padding-top-8px padding-left-18px padding-right-18px confirmation-modal-footer\"\n  [ngClass]=\"buttons ? '' : 'd-flex justify-content-end'\">\n  <button *ngIf=\"showCancelButton\" type=\"button\" class=\"btn btn-secondary btn-sm\" title=\"Cancel\"\n    (click)=\"activeModal.close(false)\">Cancel</button>\n  <button *ngIf=\"showConfirmButton\" type=\"submit\" class=\"btn btn-primary btn-sm\" title=\"Confirm\"\n    (click)=\"activeModal.close(true)\" #confirmButton>Yes, Confirm</button>\n\n  <button type=\"button\" class=\"btn {{button.class ? button.class : 'btn-secondary' }} btn-sm\"\n    *ngFor=\"let button of buttons\" (click)=\"button.onClick(); activeModal.dismiss();\"\n    title=\"{{button.title ? button.title : button.text}}\" [disabled]=\"button.disabled\" #button\n    [ngClass]=\"{'float-end ms-1': button.pullRight}\" [id]=\"button.id\">\n    <i *ngIf=\"button.iconClass\" [class]=\"button.iconClass\"></i>\n    {{button.text }}\n  </button>\n</div>\n", styles: [".modal-header{border-top:4px solid var(--toaster-info-color)}.modal-header.confirmation-modal-header{border-bottom:none}.modal-header .confirmation-icon{background-image:var(--toaster-info-svg);background-size:28px 28px;width:28px;height:28px;margin-right:12px;background-repeat:no-repeat}.modal-header .modal-btn-close{background-image:var(--modal-close-btn-icon);background-size:10px}.modal-footer{border-top:1px solid var(--highlight-default-color)}.modal-footer.confirmation-modal-footer{border-top:1px solid var(--modal-footer-border-color)}\n"] }]
    }], () => [{ type: i3.NgbActiveModal }], { confirmationBoxTitle: [{
            type: Input
        }], confirmationMessage: [{
            type: Input
        }], buttons: [{
            type: Input
        }], hideCancelButton: [{
            type: Input
        }], buttonElements: [{
            type: ViewChildren,
            args: ['button']
        }], confirmButton: [{
            type: ViewChild,
            args: ['confirmButton']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ModalComponent, { className: "ModalComponent", filePath: "lib/utility/modal/modal/modal.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class UnixToDatePipe {
    transform(value) {
        return value * 1000;
    }
    static { this.ɵfac = function UnixToDatePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UnixToDatePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "unixToDate", type: UnixToDatePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UnixToDatePipe, factory: UnixToDatePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UnixToDatePipe, [{
        type: Pipe,
        args: [{
                name: 'unixToDate'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ConvertToCamelCasePipe {
    transform(value = '', replaceChar = '') {
        return value.replace(/(?:^\w|[A-Z]|\b\w)/g, (letter, index) => {
            return index === 0 ? letter.toLowerCase() : letter.toUpperCase();
        }).replace(/\s+/g, replaceChar);
    }
    static { this.ɵfac = function ConvertToCamelCasePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ConvertToCamelCasePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "convertToCamelCase", type: ConvertToCamelCasePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ConvertToCamelCasePipe, factory: ConvertToCamelCasePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ConvertToCamelCasePipe, [{
        type: Pipe,
        args: [{
                name: 'convertToCamelCase'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SearchByPipe {
    transform(value = [], query = '', keys = []) {
        if (query === '') {
            return value;
        }
        else {
            return value.filter((val) => keys.some(key => val.hasOwnProperty(key) && new RegExp(query, 'gi').test(val[key])));
        }
    }
    static { this.ɵfac = function SearchByPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SearchByPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "searchBy", type: SearchByPipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: SearchByPipe, factory: SearchByPipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SearchByPipe, [{
        type: Pipe,
        args: [{
                name: 'searchBy',
                pure: true
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class OrderByPipe {
    transform(value, orderBy, order = 'asc', customOrder = []) {
        if (customOrder.length > 0) {
            const orderMap = customOrder.reduce((map, value, index) => {
                map[value] = index;
                return map;
            }, {});
            return ___default.orderBy(value, [item => orderMap[item[orderBy[0]]]], order);
        }
        else {
            return ___default.orderBy(value, orderBy, order);
        }
    }
    static { this.ɵfac = function OrderByPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || OrderByPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "orderBy", type: OrderByPipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: OrderByPipe, factory: OrderByPipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(OrderByPipe, [{
        type: Pipe,
        args: [{
                name: 'orderBy'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
/**
 * Changes camel case to a human readable format. So helloWorld, hello-world and hello_world becomes "Hello World".
 * */
class humanizePipe {
    transform(value = '') {
        var output = "";
        var len = value.length;
        var char;
        for (var i = 0; i < len; i++) {
            char = value.charAt(i);
            if (i == 0) {
                output += char.toUpperCase();
            }
            else if (char !== char.toLowerCase() && char === char.toUpperCase() && value.charAt(i - 1) === value.charAt(i - 1).toLowerCase()) {
                output += " " + char;
            }
            else if (char == "-" || char == "_" || char == ".") {
                output += " ";
            }
            else {
                let previousChar = value.charAt(i - 1);
                if (previousChar == "-" || previousChar == "_" || previousChar == ".") {
                    output += char.toUpperCase();
                }
                else {
                    output += char;
                }
            }
        }
        return output;
    }
    static { this.ɵfac = function humanizePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || humanizePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "humanize", type: humanizePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: humanizePipe, factory: humanizePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(humanizePipe, [{
        type: Pipe,
        args: [{
                name: 'humanize'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ViewContainerDirective {
    constructor(viewContainerRef) {
        this.viewContainerRef = viewContainerRef;
    }
    static { this.ɵfac = function ViewContainerDirective_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewContainerDirective)(i0.ɵɵdirectiveInject(i0.ViewContainerRef)); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: ViewContainerDirective, selectors: [["", "xfViewContainer", ""]] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewContainerDirective, [{
        type: Directive,
        args: [{
                selector: '[xfViewContainer]'
            }]
    }], () => [{ type: i0.ViewContainerRef }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class TextareaAutoresizeDirective {
    constructor(elementRef) {
        this.elementRef = elementRef;
    }
    onInput() {
        this.resize();
    }
    ngOnInit() {
        if (this.elementRef.nativeElement.scrollHeight) {
            setTimeout(() => this.resize());
        }
    }
    resize() {
        this.elementRef.nativeElement.style.height = '0';
        this.elementRef.nativeElement.style.height = (this.elementRef.nativeElement.scrollHeight + 2) + 'px';
    }
    static { this.ɵfac = function TextareaAutoresizeDirective_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TextareaAutoresizeDirective)(i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: TextareaAutoresizeDirective, selectors: [["", "xfTextareaAutoresize", ""]], hostBindings: function TextareaAutoresizeDirective_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("ngModelChange", function TextareaAutoresizeDirective_ngModelChange_HostBindingHandler() { return ctx.onInput(); });
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextareaAutoresizeDirective, [{
        type: Directive,
        args: [{
                selector: '[xfTextareaAutoresize]'
            }]
    }], () => [{ type: i0.ElementRef }], { onInput: [{
            type: HostListener,
            args: ['ngModelChange']
        }] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ScrollTrackerDirective {
    constructor() {
        this.scrollingFinished = new EventEmitter();
        this.emitted = false;
    }
    onScroll(event) {
        if ((window.innerHeight + window.scrollY) >= document.body.scrollHeight && !this.emitted) {
            this.emitted = true;
            this.scrollingFinished.emit();
        }
        else if ((window.innerHeight + window.scrollY) < document.body.scrollHeight) {
            this.emitted = false;
        }
    }
    static { this.ɵfac = function ScrollTrackerDirective_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScrollTrackerDirective)(); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: ScrollTrackerDirective, selectors: [["", "scrollTracker", ""]], hostBindings: function ScrollTrackerDirective_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("scroll", function ScrollTrackerDirective_scroll_HostBindingHandler($event) { return ctx.onScroll($event); }, false, i0.ɵɵresolveWindow);
        } }, outputs: { scrollingFinished: "scrollingFinished" } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScrollTrackerDirective, [{
        type: Directive,
        args: [{
                selector: '[scrollTracker]'
            }]
    }], null, { scrollingFinished: [{
            type: Output
        }], onScroll: [{
            type: HostListener,
            args: ['window:scroll', ['$event']]
        }] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class IndeterminateDirective {
    set indeterminate(value) {
        this.elem.nativeElement.indeterminate = value;
    }
    constructor(elem) {
        this.elem = elem;
    }
    static { this.ɵfac = function IndeterminateDirective_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IndeterminateDirective)(i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: IndeterminateDirective, selectors: [["", "indeterminate", ""]], inputs: { indeterminate: "indeterminate" } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IndeterminateDirective, [{
        type: Directive,
        args: [{
                selector: '[indeterminate]'
            }]
    }], () => [{ type: i0.ElementRef }], { indeterminate: [{
            type: Input
        }] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class UtilityModule {
    static { this.ɵfac = function UtilityModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UtilityModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: UtilityModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UtilityModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    GetEndPathNamePipe,
                    InterpolatePipe,
                    IsHexColorLightPipe,
                    SlugifyPipe,
                    FocusInvalidInputDirective,
                    AsPipe,
                    ModalComponent,
                    UnixToDatePipe,
                    ConvertToCamelCasePipe,
                    SearchByPipe,
                    OrderByPipe,
                    humanizePipe,
                    ViewContainerDirective,
                    TextareaAutoresizeDirective,
                    ScrollTrackerDirective,
                    HighlightPipe,
                    IndeterminateDirective
                ],
                imports: [
                    CommonModule
                ],
                exports: [
                    GetEndPathNamePipe,
                    IsHexColorLightPipe,
                    SlugifyPipe,
                    FocusInvalidInputDirective,
                    AsPipe,
                    ConvertToCamelCasePipe,
                    SearchByPipe,
                    OrderByPipe,
                    humanizePipe,
                    ViewContainerDirective,
                    TextareaAutoresizeDirective,
                    ScrollTrackerDirective,
                    HighlightPipe,
                    IndeterminateDirective
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(UtilityModule, { declarations: [GetEndPathNamePipe,
        InterpolatePipe,
        IsHexColorLightPipe,
        SlugifyPipe,
        FocusInvalidInputDirective,
        AsPipe,
        ModalComponent,
        UnixToDatePipe,
        ConvertToCamelCasePipe,
        SearchByPipe,
        OrderByPipe,
        humanizePipe,
        ViewContainerDirective,
        TextareaAutoresizeDirective,
        ScrollTrackerDirective,
        HighlightPipe,
        IndeterminateDirective], imports: [CommonModule], exports: [GetEndPathNamePipe,
        IsHexColorLightPipe,
        SlugifyPipe,
        FocusInvalidInputDirective,
        AsPipe,
        ConvertToCamelCasePipe,
        SearchByPipe,
        OrderByPipe,
        humanizePipe,
        ViewContainerDirective,
        TextareaAutoresizeDirective,
        ScrollTrackerDirective,
        HighlightPipe,
        IndeterminateDirective] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SearchableDropdownModule {
    static { this.ɵfac = function SearchableDropdownModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SearchableDropdownModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: SearchableDropdownModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            NgbDropdownModule,
            TranslocoModule,
            UtilityModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SearchableDropdownModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    SearchableDropdownComponent
                ],
                imports: [
                    CommonModule,
                    NgbDropdownModule,
                    TranslocoModule,
                    UtilityModule
                ],
                exports: [
                    SearchableDropdownComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(SearchableDropdownModule, { declarations: [SearchableDropdownComponent], imports: [CommonModule,
        NgbDropdownModule,
        TranslocoModule,
        UtilityModule], exports: [SearchableDropdownComponent] }); })();

class FieldOptions {
    constructor(options) {
        this.showLabel = true;
        this.size = 'normal';
        this.options = [];
        this.customErrorMessages = {};
        this.showError = true;
        Object.assign(this, options);
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DynamicContent {
    constructor(name, title, type) {
        this.name = name;
        this.title = title;
        this.type = type;
        this.remote = false;
        this.draft = false;
        this.publishing = false;
        this.npmInstalled = false;
        this.exposedModule = './Config';
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
var TOKEN;
(function (TOKEN) {
    TOKEN["ACCESS_KEY"] = "access.token";
    TOKEN["REFRESH_KEY"] = "refresh.token";
    TOKEN["RESTRICTED_KEY"] = "restricted.token";
})(TOKEN || (TOKEN = {}));
var MMD;
(function (MMD) {
    MMD["MODEL_METADATAS_KEY"] = "model_metadatas";
    MMD["STAGING_METADATAS_KEY"] = "staging_model_metadatas";
    MMD["STAGING_ATTRIBUTE_METADATA_KEY"] = "attribute_metadatas";
    MMD["SYSTEM_MODEL_METADATAS_KEY"] = "system_model_metadatas";
    MMD["VIEW_TEMPLATES_KEY"] = "view_templates";
    MMD["WIDGET_CONFIG_KEY"] = "widget_configs";
})(MMD || (MMD = {}));
const RESERVED_KEYWORDS = {
    PLAYBOOKS: ['items', 'result', 'input', 'request', 'values', 'keys', 'files', 'env', 'message', 'step_variables', 'do_until', 'ignore_errors', 'when', 'for_each', 'cyops_playbook_iri', 'cyops_playbook_name', 'collaborationNote', 'inputVariables', 'displayConditions'],
    MMD_FIELDS: ['id', 'recordtags', 'createUser', 'createdate', 'modifyUser', 'modifydate', 'owners', 'tenant']
};
var VIEW_TEMPLATES;
(function (VIEW_TEMPLATES) {
    VIEW_TEMPLATES["GRID_COLUMNS"] = "grid_columns";
    VIEW_TEMPLATES["TYPE"] = "SystemViewTemplate";
    VIEW_TEMPLATES["CACHE_PREFIX"] = "views.";
    VIEW_TEMPLATES["VIEW_API_BASE"] = "/api/views/1/";
    VIEW_TEMPLATES["SYSTEM_VIEW_TEMPLATES_MODEL"] = "system_view_templates";
})(VIEW_TEMPLATES || (VIEW_TEMPLATES = {}));
var API;
(function (API) {
    API["API"] = "api/";
    API["BASE"] = "api/3/";
    API["API_APPMANAGER"] = "api/appmanager/";
    API["DELETE_WITH_QUERY"] = "api/3/delete-with-query/";
    API["BULK_UPDATE"] = "api/3/update/";
    API["API_3_BASE"] = "api/3/";
    API["INSERT"] = "api/3/insert/";
    API["QUERY"] = "api/query/";
    API["SYSTEM_MODULES"] = "api/system/fixtures";
    API["CURRENT_ACTOR"] = "actors/current";
    API["AUTH"] = "api/auth/";
    API["DAS"] = "auth/";
    API["WEBSOCKET"] = "websocket/cyops-websocket";
    API["INTEGRATIONS"] = "api/integration/";
    API["INTEGRATION_CONFIGURATION"] = "api/integration/configuration/";
    API["WORKFLOW_ACTION"] = "xf/api/workflows/actions";
    API["PUBLIC"] = "api/public/";
    API["RULE"] = "api/rule/";
    API["WORKFLOW"] = "api/workflow/";
    API["WORKFLOW_GROUPS"] = "workflow_groups/";
    API["WORKFLOW_STEPS"] = "workflow_steps/";
    API["WORKFLOWS"] = "workflows/";
    API["USERS"] = "api/auth/users/";
    API["TEAMS"] = "api/auth/teams/";
    API["QUERY_PART"] = "query/";
    API["SEALAB"] = "api/workflow/";
    API["TEMP_WORKFLOWS"] = "wf/api/";
    API["EXPRESSIONS"] = "api/workflow/expressions/";
    API["LOGOUT"] = "token/logout/";
    API["SCHEDULE"] = "api/workflow/schedules/";
    API["AUDIT"] = "api/audit/";
    API["PORTER"] = "api/appmanager/";
    API["RULE_ENGINE"] = "api/rule-engine/";
})(API || (API = {}));
const OPERATOR_MAPPINGS = {
    contains: 'icontains',
    notContains: 'nicontains',
    equals: 'eq',
    notEqual: 'neq',
    startsWith: 'istartswith',
    endsWith: 'iendswith',
    lessThan: 'lt',
    lessThanOrEqual: 'lte',
    greaterThan: 'gt',
    greaterThanOrEqual: 'gte',
    in: 'in'
};
const ALL_RECORDS_SIZE = 2147483647;
const DEFAULT_NEW_MODULE_PERMISSIONS = { create: false, read: false, update: false, delete: false, execute: false, fields: {} };
const DEFAULT_REPO_URL = 'https://@product_yum_server@/';
var STORAGE_KEYS;
(function (STORAGE_KEYS) {
    STORAGE_KEYS["LOCAL_STORAGE_PREFIX"] = "xf.";
    STORAGE_KEYS["LOCAL_STORAGE_PERSIST_PREFIX"] = "persist:";
    STORAGE_KEYS["CURRENT_USER"] = "current_user";
    STORAGE_KEYS["CURRENT_PERMISSIONS"] = "current_user.roles";
    STORAGE_KEYS["SETTINGS_HISTORY"] = "settings_history";
    STORAGE_KEYS["SETTINGS_ACCOUNT_CONFIG"] = "account_configuration";
    STORAGE_KEYS["SYSTEM_SETTINGS"] = "system_settings";
    STORAGE_KEYS["USER_PREFERENCES"] = "user_preferences";
    STORAGE_KEYS["AUDIT_PURGE_SETTINGS"] = "audit_purge_settings";
    STORAGE_KEYS["WF_PURGE_SETTINGS"] = "wf_purge_settings";
    STORAGE_KEYS["LICENSE_DETAILS"] = "license_details";
})(STORAGE_KEYS || (STORAGE_KEYS = {}));
var AUTH;
(function (AUTH) {
    AUTH["TOKEN"] = "TOKEN";
})(AUTH || (AUTH = {}));
var THEMES;
(function (THEMES) {
    THEMES["DEFAULT"] = "dark";
})(THEMES || (THEMES = {}));
var FIXED_MODULE;
(function (FIXED_MODULE) {
    FIXED_MODULE["XF_QUEUES"] = "xf_queues";
    FIXED_MODULE["SHIFTS"] = "shifts";
    FIXED_MODULE["APPROVAL"] = "approvals";
    FIXED_MODULE["APPLICATION"] = "application";
    FIXED_MODULE["PLAYBOOK"] = "playbooks";
    FIXED_MODULE["PLAYBOOK_VERSIONS"] = "versions";
    FIXED_MODULE["PLAYBOOK_STEPS"] = "playbook-steps";
    FIXED_MODULE["EVENTS"] = "events";
    FIXED_MODULE["PLAYBOOK_COLLECTION"] = "playbook-collections";
    FIXED_MODULE["PEOPLE"] = "people";
    FIXED_MODULE["COMMENTS"] = "comments";
    FIXED_MODULE["TEAMS"] = "teams";
    FIXED_MODULE["ROLES"] = "roles";
    FIXED_MODULE["ROLE_SERVICES"] = "services";
    FIXED_MODULE["ROLE_ENTITIES"] = "entities";
    FIXED_MODULE["ROLE_PERMISSIONS"] = "permissions";
    FIXED_MODULE["USERS"] = "users";
    FIXED_MODULE["AUDIT_LOGS"] = "audit-logs";
    FIXED_MODULE["APPLIANCES"] = "appliances";
    FIXED_MODULE["SECURITY"] = "security";
    FIXED_MODULE["EXPORT_TEMPLATES"] = "export-templates";
    FIXED_MODULE["EXPORT_JOBS"] = "export-jobs";
    FIXED_MODULE["IMPORT_JOBS"] = "import-jobs";
    FIXED_MODULE["FILES"] = "files";
    FIXED_MODULE["PICKLIST_NAMES"] = "picklist_names";
    FIXED_MODULE["PICKLISTS"] = "picklists";
    FIXED_MODULE["LEGACY_SYSTEM_VIEW_TEMPLATE"] = "system_view_templates";
    FIXED_MODULE["WIDGET_METADATAS"] = "widget_metadatas";
    FIXED_MODULE["DYNAMIC_CONTENT"] = "dynamic_content";
    FIXED_MODULE["SETTINGS_CATEGORIES"] = "settings_categories";
    FIXED_MODULE["SETTINGS_LINKS"] = "settings_links";
    FIXED_MODULE["SETTINGS_PAGES"] = "settings_pages";
    FIXED_MODULE["SCHEDULES"] = "schedules";
    FIXED_MODULE["VIEW_TEMPLATES"] = "view-templates";
    FIXED_MODULE["WIDGET_CONFIGS"] = "widget-configs";
    FIXED_MODULE["AGENTS"] = "agents";
    FIXED_MODULE["WORKFLOW_LOGS"] = "workflow_logs";
    FIXED_MODULE["CONNECTORS"] = "connectors";
    FIXED_MODULE["GLOBAL_VARIABLES"] = "global-variables";
    FIXED_MODULE["RULE"] = "rules";
    FIXED_MODULE["CHANNEL"] = "channels";
    FIXED_MODULE["PENDING_NOTIFICATION"] = "pending-notification";
    FIXED_MODULE["SYSTEM_NOTIFICATION"] = "system-notification";
    FIXED_MODULE["SOLUTION_PACK"] = "solution-packs";
    FIXED_MODULE["WIDGETS"] = "widgets";
    FIXED_MODULE["PLAYBOOK_EXECUTION_LOGS"] = "playbook-execution-logs";
    FIXED_MODULE["CONNECTOR_CONFIGURATIONS"] = "connector-configurations";
    FIXED_MODULE["REFERENCE_BLOCKS"] = "reference-blocks";
    FIXED_MODULE["CONTENT_HUB"] = "contenthub";
    FIXED_MODULE["DASHBOARD"] = "dashboard";
    FIXED_MODULE["DELIVERY_RULES"] = "delivery-rules";
    FIXED_MODULE["NOTIFICATIONS"] = "notifications";
    FIXED_MODULE["EXPRESSIONS"] = "expressions";
    FIXED_MODULE["APPLICATION_CONFIGURATION"] = "application-configuration";
    FIXED_MODULE["TAGS"] = "tags";
    FIXED_MODULE["SYSTEM_SETTINGS"] = "system-settings";
    FIXED_MODULE["API_KEYS"] = "apikeys";
})(FIXED_MODULE || (FIXED_MODULE = {}));
const MAX_PLAYBOOK_RECORDS = 250;
const DEFAULT_GRID_ROWS = 20;
const DEFAULT_LOOKUP_RECORDS = 30;
const DEFAULT_CACHE_BLOCK_SIZE = 30;
const MAX_TEXT_LENGTH = 10485761;
const MIN_NUMBER_LIMIT = -2147483648;
const SORT_ORDER = [{
        value: 'ASC',
        label: 'Ascending'
    }, {
        value: 'DESC',
        label: 'Descending'
    }];
var CS_USER_TYPE;
(function (CS_USER_TYPE) {
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_SECADMIN"] = 1] = "CS_USERTYPE_SECADMIN";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_USER"] = 2] = "CS_USERTYPE_USER";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_APPLIANCE"] = 3] = "CS_USERTYPE_APPLIANCE";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_MSSP"] = 4] = "CS_USERTYPE_MSSP";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_NO_IDLE"] = 5] = "CS_USERTYPE_NO_IDLE";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_SAML"] = 6] = "CS_USERTYPE_SAML";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_LDAP"] = 7] = "CS_USERTYPE_LDAP";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_RADIUS"] = 8] = "CS_USERTYPE_RADIUS";
})(CS_USER_TYPE || (CS_USER_TYPE = {}));
var USER_ACCESS_TYPE;
(function (USER_ACCESS_TYPE) {
    USER_ACCESS_TYPE["NAMED"] = "Named";
    USER_ACCESS_TYPE["CONCURRENT"] = "Concurrent";
})(USER_ACCESS_TYPE || (USER_ACCESS_TYPE = {}));
const BRANDING_FALLBACK = {
    light: {
        'largeLogo': 'data:image/png;base64,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'
    },
    dark: {
        'largeLogo': 'data:image/png;base64,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'
    },
    'favicon': 'data:image/vnd.microsoft.icon;base64,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',
};
const CONTENTHUB = {
    CONTENT_TYPE: { CONNECTOR: 'connector', WIDGET: 'widget', SOLUTION_PACK: 'solutionpack' },
    CONTENT_PERMISSION: { CONNECTOR: 'connectors', WIDGET: 'widgets', SOLUTION_PACK: 'solution-packs' },
    CONTENT_LABEL: { CONNECTOR: 'Connectors', WIDGET: 'Widgets', SOLUTION_PACK: 'Solution Packs' },
    CONTENT_TYPE_LABEL: { connector: 'Connector', widget: 'Widget', solutionpack: 'Solution Pack' },
    CONTENT_TYPE_LABEL_PLURAL: { connectors: 'Connectors', widgets: 'Widgets', solutionpacks: 'Solution Packs' }
};
const CONFIGURATION_LABELS = {
    dependency: 'Dependency(s)',
    prerequisite: 'Prerequisite(s)',
    modules: 'Module Schema(s)',
    recordSets: 'Record Set(s)',
    viewTemplates: 'Module View(s)',
    views: 'System View(s)',
    reports: 'Report(s)',
    dashboards: 'Dashboard(s)',
    picklistNames: 'Picklist(s)',
    roles: 'Role(s)',
    teams: 'Team(s)',
    actors: 'User(s)',
    playbooks: 'Playbook Collection(s)',
    playbookCollections: 'Playbook Collection(s)',
    playbookBlocks: 'Playbook Block(s)',
    globalVariables: 'Global Variable(s)',
    rules: 'Rule(s)',
    ruleChannels: 'Rule Channel(s)',
    connectors: 'Connector(s)',
    widgets: 'Widget(s)',
    appSettings: 'Administrative Setting(s)'
};
const CONFIG_IMPORT_ORDER = [
    'starting',
    'picklistNames',
    'modules',
    'viewTemplates',
    'views',
    'roles',
    'actors',
    'teams',
    'playbooks',
    'rules',
    'ruleChannels',
    'reports',
    'dashboards',
    'connectors',
    'widgets',
    'recordSets',
    'appSettings',
    'completed'
];
const APP_SETTINGS = [{
        name: 'systemSettings',
        title: 'Application Configuration (theme, branding, notifications, and more)'
    }, {
        name: 'LDAP',
        title: 'LDAP Configuration'
    }, {
        name: 'RADIUS',
        title: 'RADIUS Configuration'
    }, {
        name: 'TOKEN',
        title: 'Account Configuration (timeouts and token refresh)'
    }, {
        name: 'HA',
        title: 'System & Cluster Health Monitoring'
    }, {
        name: 'sso',
        title: 'SAML Configuration'
    }, {
        name: 'syslog',
        title: 'Logging Configuration'
    }, {
        name: 'proxy',
        title: 'Proxy & Environment Variables'
    }];
const LANGUAGE_DATA = [
    {
        "id": "en",
        "label": "English"
    },
    {
        "id": "es",
        "label": "Spanish"
    },
    {
        "id": "hi",
        "label": "Hindi"
    }
];
const REGEX = {
    ATTACHMENT_IRI: /^\/api\/3\/attachments\/[a-z0-9-]+$/,
    FILE_IRI: /^\/api\/3\/files\/[a-z0-9-]+$/,
    XSS_SVG_FILTER: /<img\s+[^>]*src="((ftp|http)s?:\/\/.*?\.(svg))"[^>]*>/g,
    HTML_ENTITIES_XSS_SVG_FILTER: /\&lt\;img\s+[^>]*src=[^>]*((ftp|http)s?:\/\/.*?\.(svg))[^>]*\&gt\;/g,
    ALPHA_NUMERIC_UNDERSCORE: /^[a-zA-Z_0-9]*$/g,
    ALPHA_NUMERIC_UNDERSCORE_SPACE: /^[a-zA-Z_0-9\s]*$/g,
    PB_STEP_NAME: /^[A-Za-z0-9`~!@#$%^&*()\-_=+|{}:;'<>,./?\s]*$/
};
const COMMENT_TYPES = {
    ACTION_LOG: '/api/3/picklists/1165899b-7091-4291-aafc-487c4309e8ff',
    COMMENT: '/api/3/picklists/ff599189-3eeb-4c86-acb0-a7915e85ac3b'
};
const UUID_REGEX = /^[0-9A-F]{8}-[0-9A-F]{4}-[4][0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i;
const JINJA_REGEX = /\{\{(.*?)\}\}/g;
const TOKEN_STORAGE_KEY = 'token';
const TITLE_POSTFIX = 'FortiSOAR Cloud Platform';
const TITLE_POSTFIX_ABBR = 'FCP';
const AGENT_CONFIG_HEALTH = { 'in_progress': 'fb340c77-c2c6-471d-8081-77c9302b4bfb', 'complete_on_message_exchange': 'b5566a53-7af5-48f6-9dbd-5bf5fc9f432b', 'remote_node_connected': 'ab6a1713-9280-4619-9fbd-7694edad2159', 'missed_heartbeats': '0b916872-03d7-49aa-b809-e5471fa970df', 'failed_on_message_exchange': '4b7645c0-cafa-45dd-ad57-44882ce57f21', 'message_exchange_unreachable': '945621cd-f169-44b8-bc28-807a6f17d00a', 'remote_node_unreachable': '135030fa-1b0b-453d-9fed-df9be5d4397f' };
var CONNECTOR_STATUS;
(function (CONNECTOR_STATUS) {
    CONNECTOR_STATUS["INSTALLED"] = "installed";
})(CONNECTOR_STATUS || (CONNECTOR_STATUS = {}));
const CHANNEL_UUIDS = { 'IN_APP': '7a04788b-5128-4288-a0fc-6e82d18c3b7b', 'EMAIL': '2a817063-e12a-496d-934d-381d22a95b3b', 'QUEUE': '44fd54ca-f82d-431e-a6fa-dfde019a1ed6', 'RESUME_CONDITIONAL_PB_STEP': 'e2ce87c2-c55a-11ec-9d64-0242ac120002', 'ON_PLAYBOOK_FAILURE': '4c7f3cd4-b9a4-44c9-b372-de68070d0d67' };
const POLL_INTERVAL = 5000;
var PERMISSION;
(function (PERMISSION) {
    PERMISSION["READ"] = "read";
    PERMISSION["CREATE"] = "create";
    PERMISSION["UPDATE"] = "update";
    PERMISSION["DELETE"] = "delete";
    PERMISSION["EXECUTE"] = "execute";
    PERMISSION["DEBUG"] = "debug";
    PERMISSION["INSTALL"] = "install";
    PERMISSION["RETRY"] = "retry";
})(PERMISSION || (PERMISSION = {}));
const ERROR_OBJECTS = {
    404: {
        code: 404,
        icon: 'assets/images/404_icon.png',
        error: 'Page Not Found',
        errorText: 'Sorry, we could not find the page you are looking for.',
        description: 'This error occurs when the server cannot find the requested resource. The user may have entered a incorrect URL, or the resource may have been deleted or moved.'
    },
    403: {
        code: 403,
        icon: 'assets/images/403_icon.png',
        error: 'Access Denied',
        errorText: 'You do not have permission to access this resource.',
        description: 'The request could not be fulfilled by the server due to insufficient access privileges. If you believe this is an error, please contact the website administrator for assistance.'
    },
    500: {
        code: 500,
        icon: 'assets/images/500_icon.png',
        error: 'Internal server error',
        errorText: 'Sorry for the inconvenience. Please report this message. Thank you very much!',
    },
    501: {
        code: 501,
        icon: 'assets/images/501_icon.png',
        error: 'Not Implemented',
        errorText: 'Sorry, the page you were looking for cannot be accessed as the server does not support the requested method. Please try again later or contact the website administrator if you need assistance. Thank you for your understanding.',
    },
    502: {
        code: 502,
        icon: 'assets/images/502_icon.png',
        error: 'Bad gateway',
        errorText: 'Error indicates a bad gateway, typically caused by server communication issues.',
        description: 'Try refreshing the page, clearing the browser cache, or contact the administrator if the issue persists.'
    },
    503: {
        code: 503,
        icon: 'assets/images/503_icon.png',
        error: 'Service unavailable',
        errorText: 'We apologize for the inconvenience. Our team is working to resolve the issue as quickly as possible. ',
    },
    504: {
        code: 504,
        icon: 'assets/images/504_icon.png',
        error: 'Gateway timeout',
        errorText: 'This error signifies a gateway timeout, indicating that a server didn\'t receive a timely response from another server it was accessing.',
        description: 'Try refreshing the page, checking their internet connection, or contacting the administrator if the issue persists'
    }
};
const IGNORE_ERRORS = new HttpContextToken(() => false);
const MODULE_MAPPING = {
    manualinput: "User Input"
};
const DEFAULT_SCHEDULE_TASKS = {
    AUDIT: {
        SETTING: 'purge_audit_task',
        TASK: 'tasks.default_tasks.purge_audit_task'
    },
    PLAYBOOK: {
        SETTING: 'purge_workflow_task',
        TASK: 'tasks.default_tasks.purge_workflow_task'
    },
    SYSTEM_NOTOFICATIONS: {
        SETTING: 'purge_system_notifications',
        TASK: 'tasks.default_tasks.purge_system_notifications'
    },
    FAILURE_NOTOFICATIONS: {
        SETTING: 'purge_failed_notifications',
        TASK: 'tasks.default_tasks.purge_failed_notifications'
    }
};
const MASK_KEY_FORMAT = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxx';
const cloudURL = 'https://platform.fortisoar.forticloud.com/';

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class FieldService {
    constructor() {
        this.customFields = {};
        this.http = inject(HttpClient);
    }
    loadDynamicContent(name, type) {
        return of(null); // Dynamic content is not implemented yet in XF
        return this.http.get(API.BASE + FIXED_MODULE.DYNAMIC_CONTENT, {
            params: {
                limit: ALL_RECORDS_SIZE,
                type: type,
                name: name
            }
        }).pipe(map((response) => {
            if (!response['hydra:member'].length) {
                return null;
            }
            return plainToInstance(DynamicContent, response['hydra:member'][0]);
        }));
    }
    getFieldRenderer(name) {
        if (this.customFields[name]) {
            return of(this.customFields[name]);
        }
        return this.loadDynamicContent(name, 'field-renderer').pipe(concatMap((fieldRenderer) => {
            if (!fieldRenderer?.className) {
                return of(null);
            }
            const options = {
                remoteEntry: '/widget/' + fieldRenderer.name + '/remoteEntry.json',
                exposedModule: fieldRenderer.exposedModule || './Config',
                className: fieldRenderer.className
            };
            const component$ = from(loadRemoteModule(options)).pipe(catchError((error) => {
                console.error(error);
                return of(null);
            }), map((exposedModules) => {
                const widgetConfigType = exposedModules[options.className];
                this.customFields[fieldRenderer.name] = widgetConfigType;
                return widgetConfigType;
            }));
            return component$;
        }));
    }
    getValidators(field) {
        let validators = [];
        if (field.validation.minLength) {
            validators.push(Validators.minLength(field.validation.minLength));
        }
        if (field.validation.maxLength) {
            validators.push(Validators.maxLength(field.validation.maxLength));
        }
        if (field.validation.pattern) {
            validators.push(Validators.pattern(field.validation.pattern));
        }
        if (field.validation.custom) {
            validators.push(field.validation.custom);
        }
        if (field.validation.min) { // in case of integer field
            validators.push(Validators.min(field.validation.min));
        }
        if (field.validation.max) { // in case of integer field
            validators.push(Validators.max(field.validation.max));
        }
        if (field.formType == 'email') {
            validators.push(Validators.email);
        }
        if (field.validation.required) {
            validators.push(Validators.required);
        }
        return validators;
    }
    static { this.ɵfac = function FieldService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FieldService, factory: FieldService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$x = ["inputField"];
class AbstractFieldComponent {
    constructor(changeDetectorRef, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.fieldOptions = new FieldOptions();
        this.autoFocus = false;
        this.jinjaToggled = new EventEmitter();
        this.onSubmit = new EventEmitter();
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.isDisabled = false;
        this.fieldService = inject(FieldService);
    }
    ngAfterViewInit() {
        if (this.autoFocus) {
            this.inputField?.nativeElement.focus();
            this.inputField?.nativeElement.setAttribute('ngbAutofocus', '');
        }
        if (this.isDisabled) {
            this.fieldGroup?.get('input')?.disable();
        }
    }
    ngOnInit() {
        this.fieldGroup = this.formBuilder.group({
            input: [this.value, this.fieldService.getValidators(this.field)]
        });
    }
    setDisabledState(isDisabled) {
        this.isDisabled = isDisabled;
        if (isDisabled) {
            this.fieldGroup?.get('input')?.disable();
        }
        else {
            this.fieldGroup?.get('input')?.enable();
        }
    }
    get value() {
        return this._value;
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.onChange(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    writeValue(value) {
        this.value = value;
        if (this.fieldGroup && this.fieldGroup.controls.input) {
            this.fieldGroup.controls.input.setValue(value);
        }
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    onBlur() {
        this.onTouched();
    }
    onFocus() {
        // setTimeout(() => {
        //   if (this.inputField && 'select' in this.inputField.nativeElement) {
        //     this.inputField.nativeElement.select();
        //   }
        // });
    }
    validate(control) {
        this.control = control;
        return this.fieldGroup?.controls.input?.valid ? null : this.fieldGroup?.controls.input?.errors ?? null;
    }
    get valid() {
        return this.fieldGroup?.valid === false ? false : true;
    }
    focus() {
        this.inputField?.nativeElement.focus();
    }
    ngDoCheck() {
        if (this.fieldGroup?.touched) {
            this.control?.markAsTouched();
            return;
        }
        if (this.control?.touched && this.fieldGroup?.controls.input) {
            this.fieldGroup?.controls.input.markAsTouched();
        }
    }
    toggleJinja(jinjaEnabled) {
        this.jinjaToggled.emit(jinjaEnabled);
    }
    static { this.ɵfac = function AbstractFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractFieldComponent, selectors: [["xf-abstract-field"]], viewQuery: function AbstractFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$x, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.inputField = _t.first);
        } }, inputs: { field: "field", fieldOptions: "fieldOptions", fieldClass: "fieldClass", autoFocus: "autoFocus" }, outputs: { jinjaToggled: "jinjaToggled", onSubmit: "onSubmit" }, decls: 0, vars: 0, template: function AbstractFieldComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractFieldComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-field',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { field: [{
            type: Input
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], jinjaToggled: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], inputField: [{
            type: ViewChild,
            args: ['inputField']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractFieldComponent, { className: "AbstractFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/abstract-field.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$w = (a0, a1) => ({ min: a0, actual: a1 });
const _c1$k = (a0, a1) => ({ max: a0, actual: a1 });
const _c2$9 = a0 => ({ min: a0 });
const _c3$4 = a0 => ({ max: a0 });
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(3).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.customErrorMessages.required || t_r1("error.required"), " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_3_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.customErrorMessages.minlength);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_3_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtext(0);
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(4).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵtextInterpolate(t_r1("error.minlength", i0.ɵɵpureFunction2(1, _c0$w, ctx_r1.control.errors == null ? null : ctx_r1.control.errors["minlength"].requiredLength, ctx_r1.control.errors == null ? null : ctx_r1.control.errors["minlength"].actualLength)));
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtemplate(1, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_3_span_1_Template, 2, 1, "span", 10)(2, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_3_ng_template_2_Template, 1, 4, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const minLengthMsg_r3 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.customErrorMessages.minlength)("ngIfElse", minLengthMsg_r3);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_4_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.customErrorMessages.maxlength);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_4_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtext(0);
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(4).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵtextInterpolate1(" ", t_r1("error.maxlength", i0.ɵɵpureFunction2(1, _c1$k, ctx_r1.control.errors == null ? null : ctx_r1.control.errors["maxlength"].requiredLength, ctx_r1.control.errors == null ? null : ctx_r1.control.errors["maxlength"].actualLength)), " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtemplate(1, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_4_span_1_Template, 2, 1, "span", 10)(2, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_4_ng_template_2_Template, 1, 4, "ng-template", null, 1, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const maxLengthMsg_r4 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.customErrorMessages.maxlength)("ngIfElse", maxLengthMsg_r4);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_5_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.customErrorMessages.min);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_5_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtext(0);
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(4).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵtextInterpolate1(" ", t_r1("error.minValue", i0.ɵɵpureFunction1(1, _c2$9, ctx_r1.control.errors == null ? null : ctx_r1.control.errors["min"].min)), " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtemplate(1, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_5_span_1_Template, 2, 1, "span", 10)(2, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_5_ng_template_2_Template, 1, 3, "ng-template", null, 2, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const minValueMsg_r5 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.customErrorMessages.min)("ngIfElse", minValueMsg_r5);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_6_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.customErrorMessages.max);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_6_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtext(0);
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(4).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵtextInterpolate1(" ", t_r1("error.maxValue", i0.ɵɵpureFunction1(1, _c3$4, ctx_r1.control.errors == null ? null : ctx_r1.control.errors["max"].max)), " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtemplate(1, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_6_span_1_Template, 2, 1, "span", 10)(2, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_6_ng_template_2_Template, 1, 3, "ng-template", null, 3, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const maxValueMsg_r6 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.customErrorMessages.max)("ngIfElse", maxValueMsg_r6);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(3).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.customErrorMessages.email || t_r1("error.mustBeValidEmail"), " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(3).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.customErrorMessages.pattern || t_r1("error.mustBeValidInput"), " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_9_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.customErrorMessages.maxlength);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_9_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(2, "span");
    i0.ɵɵtext(3, "is a reserved key. Please use a different variable name.");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(5);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r1.control.value, " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtemplate(1, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_9_span_1_Template, 2, 1, "span", 10)(2, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_9_ng_template_2_Template, 4, 1, "ng-template", null, 4, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const reservedKeyError_r7 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.customErrorMessages.reservedKey)("ngIfElse", reservedKeyError_r7);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(3).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.customErrorMessages.alphaNumeric || t_r1("error.canOnlyContainAlphanumeric"), " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "small");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r1 = i0.ɵɵnextContext(3).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.customErrorMessages.unique || (ctx_r1.control.errors == null ? null : ctx_r1.control.errors["unique"]) || t_r1("error.mustBeUnique"), " ");
} }
function FormMessagesComponent_ng_container_0_Conditional_1_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 6);
    i0.ɵɵelement(1, "i", 8);
    i0.ɵɵtemplate(2, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_2_Template, 2, 1, "small", 9)(3, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_3_Template, 4, 2, "small", 9)(4, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_4_Template, 4, 2, "small", 9)(5, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_5_Template, 4, 2, "small", 9)(6, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_6_Template, 4, 2, "small", 9)(7, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_7_Template, 2, 1, "small", 9)(8, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_8_Template, 2, 1, "small", 9)(9, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_9_Template, 4, 2, "small", 9)(10, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_10_Template, 2, 1, "small", 9)(11, FormMessagesComponent_ng_container_0_Conditional_1_div_0_small_11_Template, 2, 1, "small", 9);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["required"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["minlength"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["maxlength"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["min"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["max"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["email"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["pattern"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["reservedKey"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["alphaNumeric"]);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.control.errors == null ? null : ctx_r1.control.errors["unique"]);
} }
function FormMessagesComponent_ng_container_0_Conditional_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, FormMessagesComponent_ng_container_0_Conditional_1_div_0_Template, 12, 10, "div", 7);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngIf", ctx_r1.control.invalid && (ctx_r1.control.dirty || ctx_r1.control.touched));
} }
function FormMessagesComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, FormMessagesComponent_ng_container_0_Conditional_1_Template, 1, 1, "div", 6);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.control ? 1 : -1);
} }
class FormMessagesComponent {
    constructor() {
        this.customErrorMessages = {};
    }
    static { this.ɵfac = function FormMessagesComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FormMessagesComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FormMessagesComponent, selectors: [["xf-form-messages"]], inputs: { control: "control", customErrorMessages: "customErrorMessages" }, decls: 1, vars: 0, consts: [["minLengthMsg", ""], ["maxLengthMsg", ""], ["minValueMsg", ""], ["maxValueMsg", ""], ["reservedKeyError", ""], [4, "transloco"], [1, "text-danger", "content-font", "fw-medium", "line-height-15px", "margin-top-8px"], ["class", "text-danger content-font fw-medium line-height-15px margin-top-8px", 4, "ngIf"], [1, "fa", "fa-exclamation-circle", "fa-regular", "margin-right-4px"], [4, "ngIf"], [4, "ngIf", "ngIfElse"], [1, "fw-bold"]], template: function FormMessagesComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FormMessagesComponent_ng_container_0_Template, 2, 1, "ng-container", 5);
        } }, dependencies: [i1.NgIf, i4.TranslocoDirective], styles: [".text-danger[_ngcontent-%COMP%]   small[_ngcontent-%COMP%]{font-size:12px}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormMessagesComponent, [{
        type: Component,
        args: [{ selector: 'xf-form-messages', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<ng-container *transloco=\"let t\">\n  @if (control) {\n  <div *ngIf=\"control.invalid && (control.dirty || control.touched)\"\n    class=\"text-danger content-font fw-medium line-height-15px margin-top-8px\">\n    <i class=\"fa fa-exclamation-circle fa-regular margin-right-4px\"></i>\n    <small *ngIf=\"control.errors?.['required']\">\n      {{customErrorMessages.required || t('error.required')}}\n    </small>\n    <small *ngIf=\"control.errors?.['minlength']\">\n      <span *ngIf=\"customErrorMessages.minlength; else minLengthMsg\">{{ customErrorMessages.minlength }}</span>\n      <ng-template #minLengthMsg>{{ t('error.minlength', {min: control.errors?.['minlength'].requiredLength, actual:\n        control.errors?.['minlength'].actualLength})}}</ng-template>\n    </small>\n    <small *ngIf=\"control.errors?.['maxlength']\">\n      <span *ngIf=\"customErrorMessages.maxlength; else maxLengthMsg\">{{ customErrorMessages.maxlength }}</span>\n      <ng-template #maxLengthMsg>\n        {{ t('error.maxlength', {max: control.errors?.['maxlength'].requiredLength, actual:\n        control.errors?.['maxlength'].actualLength})}}\n      </ng-template>\n    </small>\n    <small *ngIf=\"control.errors?.['min']\">\n      <span *ngIf=\"customErrorMessages.min; else minValueMsg\">{{ customErrorMessages.min }}</span>\n      <ng-template #minValueMsg>\n        {{ t('error.minValue', {min: control.errors?.['min'].min})}}\n      </ng-template>\n    </small>\n    <small *ngIf=\"control.errors?.['max']\">\n      <span *ngIf=\"customErrorMessages.max; else maxValueMsg\">{{ customErrorMessages.max }}</span>\n      <ng-template #maxValueMsg>\n        {{ t('error.maxValue', {max: control.errors?.['max'].max})}}\n      </ng-template>\n    </small>\n    <small *ngIf=\"control.errors?.['email']\">\n      {{ customErrorMessages.email || t('error.mustBeValidEmail') }}\n    </small>\n    <small *ngIf=\"control.errors?.['pattern']\">\n      {{ customErrorMessages.pattern || t('error.mustBeValidInput')}}\n    </small>\n    <small *ngIf=\"control.errors?.['reservedKey']\">\n      <span *ngIf=\"customErrorMessages.reservedKey; else reservedKeyError\">{{ customErrorMessages.maxlength }}</span>\n      <ng-template #reservedKeyError>\n        <span class=\"fw-bold\">{{ control.value }} </span><span>is a reserved key. Please use a different variable\n          name.</span>\n      </ng-template>\n    </small>\n    <small *ngIf=\"control.errors?.['alphaNumeric']\">\n      {{ customErrorMessages.alphaNumeric || t('error.canOnlyContainAlphanumeric') }}\n    </small>\n    <small *ngIf=\"control.errors?.['unique']\">\n      {{ customErrorMessages.unique || control.errors?.['unique'] || t('error.mustBeUnique')}}\n    </small>\n  </div>\n  }\n</ng-container>\n", styles: [".text-danger small{font-size:12px}\n"] }]
    }], () => [], { control: [{
            type: Input
        }], customErrorMessages: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FormMessagesComponent, { className: "FormMessagesComponent", filePath: "lib/form-fields/form-messages/form-messages.component.ts", lineNumber: 14 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$v = a0 => ({ "form-switch form-check": a0 });
const _c1$j = (a0, a1, a2) => ({ "is-invalid": a0, "form-control": a1, "form-check-input-lg": a2 });
function CheckboxFieldComponent_div_0_label_2_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 8);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function CheckboxFieldComponent_div_0_label_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 6);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, CheckboxFieldComponent_div_0_label_2_span_2_Template, 2, 0, "span", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r0.field.customLabel.labelOn !== "" ? ctx_r0.value ? ctx_r0.field.customLabel.labelOn : ctx_r0.field.customLabel.labelOff : ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
} }
function CheckboxFieldComponent_div_0_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 9);
    i0.ɵɵlistener("click", function CheckboxFieldComponent_div_0_button_3_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function CheckboxFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵelement(1, "input", 3);
    i0.ɵɵtemplate(2, CheckboxFieldComponent_div_0_label_2_Template, 3, 3, "label", 4)(3, CheckboxFieldComponent_div_0_button_3_Template, 2, 3, "button", 5);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup)("ngClass", i0.ɵɵpureFunction1(7, _c0$v, ctx_r0.field.viewMode === "toggle"));
    i0.ɵɵadvance();
    i0.ɵɵproperty("indeterminate", ctx_r0.field.params.indeterminate)("ngClass", i0.ɵɵpureFunction3(9, _c1$j, ctx_r0.fieldGroup.controls.input.invalid, ctx_r0.field.viewMode === "toggle", ctx_r0.field.viewMode === "toggle" && ctx_r0.fieldOptions.size === "large"))("id", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function CheckboxFieldComponent_div_1_p_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "p", 13);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.subtitle);
} }
function CheckboxFieldComponent_div_1_xf_form_messages_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 14);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
function CheckboxFieldComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 10);
    i0.ɵɵtemplate(1, CheckboxFieldComponent_div_1_p_1_Template, 2, 1, "p", 11)(2, CheckboxFieldComponent_div_1_xf_form_messages_2_Template, 1, 1, "xf-form-messages", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.subtitle);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldGroup && ctx_r0.fieldOptions.showError);
} }
class CheckboxFieldComponent extends AbstractFieldComponent {
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map$1(values => values.input))
            .subscribe((value) => {
            this.value = value;
        });
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵCheckboxFieldComponent_BaseFactory; return function CheckboxFieldComponent_Factory(__ngFactoryType__) { return (ɵCheckboxFieldComponent_BaseFactory || (ɵCheckboxFieldComponent_BaseFactory = i0.ɵɵgetInheritedFactory(CheckboxFieldComponent)))(__ngFactoryType__ || CheckboxFieldComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CheckboxFieldComponent, selectors: [["xf-field-checkbox"]], inputs: { field: "field" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }]), i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 2, consts: [["class", "d-flex align-items-center h-40px", 3, "formGroup", "ngClass", 4, "ngIf"], ["class", "margin-left-10px", 4, "ngIf"], [1, "d-flex", "align-items-center", "h-40px", 3, "formGroup", "ngClass"], ["type", "checkbox", "formControlName", "input", 1, "form-check-input", 3, "indeterminate", "ngClass", "id"], ["class", "flex-grow-1 form-check-label mt-1 margin-left-10px content-font", 3, "for", 4, "ngIf"], ["type", "button", "class", "float-end ms-2 btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], [1, "flex-grow-1", "form-check-label", "mt-1", "margin-left-10px", "content-font", 3, "for"], ["class", "text-danger margin-left-4px", 4, "ngIf"], [1, "text-danger", "margin-left-4px"], ["type", "button", "title", "Add Custom Expression", 1, "float-end", "ms-2", "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"], [1, "margin-left-10px"], ["class", "font-size-10px muted-30 font-italic", 4, "ngIf"], [3, "control", 4, "ngIf"], [1, "font-size-10px", "muted-30", "font-italic"], [3, "control"]], template: function CheckboxFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, CheckboxFieldComponent_div_0_Template, 4, 13, "div", 0)(1, CheckboxFieldComponent_div_1_Template, 3, 2, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.field.subtitle && ctx.fieldOptions.showError);
        } }, dependencies: [i1.NgClass, i1.NgIf, IndeterminateDirective, i2.CheckboxControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FormMessagesComponent], encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CheckboxFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-checkbox', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"d-flex align-items-center h-40px\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\" [ngClass]=\"{'form-switch form-check': field.viewMode === 'toggle'}\">\n  <input class=\"form-check-input\" type=\"checkbox\" [indeterminate]=\"field.params.indeterminate\"\n    [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid, 'form-control': field.viewMode === 'toggle', 'form-check-input-lg': field.viewMode === 'toggle' && fieldOptions.size === 'large'}\"\n    [id]=\"'input-' + field.name\" formControlName=\"input\">\n  <label class=\"flex-grow-1 form-check-label mt-1 margin-left-10px content-font\" [for]=\"'input-' + field.name\"\n    *ngIf=\"fieldOptions.showLabel\">{{field.customLabel.labelOn !== '' ? (value ? field.customLabel.labelOn : field.customLabel.labelOff) :\n    field.title }}\n  <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-left-4px\">*</span>\n  </label>\n  \n  <button type=\"button\" class=\"float-end ms-2 btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n    *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n    }}</button>\n</div>\n<div class=\"margin-left-10px\" *ngIf=\"field.subtitle && fieldOptions.showError\">\n  <p *ngIf=\"field.subtitle\" class=\"font-size-10px muted-30 font-italic\">{{field.subtitle}}</p>\n  <xf-form-messages *ngIf=\"fieldGroup && fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n</div>\n" }]
    }], null, { field: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CheckboxFieldComponent, { className: "CheckboxFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/checkbox/checkbox-field.component.ts", lineNumber: 25 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class AbstractViewComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.fieldOptions = new FieldOptions();
    }
    ngOnInit() { }
    static { this.ɵfac = function AbstractViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractViewComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractViewComponent, selectors: [["xf-abstract-view"]], inputs: { value: "value", field: "field", fieldOptions: "fieldOptions", fieldClass: "fieldClass" }, decls: 0, vars: 0, template: function AbstractViewComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractViewComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-view',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }], { value: [{
            type: Input
        }], field: [{
            type: Input
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractViewComponent, { className: "AbstractViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/abstract-view.component.ts", lineNumber: 14 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class CheckboxViewComponent extends AbstractViewComponent {
    ngOnInit() {
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵCheckboxViewComponent_BaseFactory; return function CheckboxViewComponent_Factory(__ngFactoryType__) { return (ɵCheckboxViewComponent_BaseFactory || (ɵCheckboxViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(CheckboxViewComponent)))(__ngFactoryType__ || CheckboxViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CheckboxViewComponent, selectors: [["xf-checkbox-view"]], inputs: { field: "field" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 1, template: function CheckboxViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "p");
            i0.ɵɵtext(1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1("", ctx.field.customLabel.labelOn !== "" ? ctx.value ? ctx.field.customLabel.labelOn : ctx.field.customLabel.labelOff : ctx.value ? "Yes" : "No", " ");
        } }, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CheckboxViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-checkbox-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p>{{field.customLabel.labelOn !== '' ? (value ? field.customLabel.labelOn : field.customLabel.labelOff) :\n    ( value ? 'Yes' : 'No' ) }} </p>\n" }]
    }], null, { field: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CheckboxViewComponent, { className: "CheckboxViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/checkbox/checkbox-view.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class StorageService {
    constructor() { }
    /**
     *
     * @param {string} key The key of Storage Entry
     * @param {any} value The value to store
     * @param {boolean} persist Flag to define the key existance post session timeout
     */
    setItem(key, value, persist) {
        let storageKey = this._getStorageKey(key, persist);
        localStorage.setItem(storageKey, JSON.stringify(value));
    }
    /**
     * Clean up all non-persisted storage entries post user session timeout.
     */
    clearAll() {
        for (let key in localStorage) {
            const length = STORAGE_KEYS.LOCAL_STORAGE_PREFIX.length;
            if (key.substring(0, length) == STORAGE_KEYS.LOCAL_STORAGE_PREFIX) {
                localStorage.removeItem(key);
            }
        }
    }
    /**
     * Retrive the storage entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     * @returns {any} the value
     */
    getItem(key, persist) {
        let storageKey = this._getStorageKey(key, persist);
        let result = localStorage.getItem(storageKey);
        try {
            return result ? JSON.parse(result) : null;
        }
        catch (error) {
            return result;
        }
    }
    /**
     * Remove the specified storage entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     */
    removeItem(key, persist) {
        let storageKey = this._getStorageKey(key, persist);
        localStorage.removeItem(storageKey);
    }
    /**
     * Build the key string of the storgae entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     * @returns {string} key string
     */
    _getStorageKey(key, persist) {
        return persist ? STORAGE_KEYS.LOCAL_STORAGE_PERSIST_PREFIX + key : STORAGE_KEYS.LOCAL_STORAGE_PREFIX + key;
    }
    static { this.ɵfac = function StorageService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || StorageService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: StorageService, factory: StorageService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(StorageService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();

class SystemSettingsService {
    constructor(http, storageService) {
        this.http = http;
        this.storageService = storageService;
    }
    getSSOStatus() {
        return this.http.get(`${API.PUBLIC}saml/login`);
    }
    get() {
        return this.storageService.getItem(STORAGE_KEYS.SYSTEM_SETTINGS);
    }
    load() {
        return this.http.get(`${API.API_APPMANAGER}${FIXED_MODULE.SYSTEM_SETTINGS}/`).pipe(map$1((result) => {
            this.storageService.setItem(STORAGE_KEYS.SYSTEM_SETTINGS, result['hydra:member'][0]);
            return result['hydra:member'][0];
        }));
    }
    save(systemSettings) {
        return this.http.put(`${API.API_APPMANAGER}${FIXED_MODULE.SYSTEM_SETTINGS}/${systemSettings.uuid}/`, systemSettings).pipe(map$1((result) => {
            this.storageService.setItem(STORAGE_KEYS.SYSTEM_SETTINGS, result);
            return result;
        }));
    }
    saveUserPreferences(settings) {
        let userPreferences = this.storageService.getItem(STORAGE_KEYS.USER_PREFERENCES, true) || {};
        userPreferences = extend(userPreferences, settings);
        this.storageService.setItem(STORAGE_KEYS.USER_PREFERENCES, userPreferences, false);
        return of(userPreferences);
    }
    getUserPreferences() {
        return this.storageService.getItem(STORAGE_KEYS.USER_PREFERENCES, false) || {};
    }
    getDateFormats() {
        return this.http.get('assets/settings/dateFormat.json').pipe(map$1((response) => {
            return {
                dateFormat: this.getDateFormat(response),
                dateTimeFormat: this.getdateTimeFormat(response)
            };
        }));
    }
    getdateTimeFormat(data) {
        let dateTimeFormatOptions = data
            .filter((date) => date.type === 'datetime')
            .map((date) => {
            date.label = date.value;
            delete date.type;
            return date;
        });
        return dateTimeFormatOptions;
    }
    getDateFormat(data) {
        let dateFormatOptions = data
            .filter((date) => date.type === 'date')
            .map((date) => {
            date.label = date.value;
            delete date.type;
            return date;
        });
        return dateFormatOptions;
    }
    static { this.ɵfac = function SystemSettingsService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SystemSettingsService)(i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: SystemSettingsService, factory: SystemSettingsService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SystemSettingsService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }, { type: StorageService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$u = a0 => ({ "font-size-18px fw-semibold": a0 });
class DatetimeViewComponent extends AbstractViewComponent {
    constructor(systemSettingsService, changeDetectorRef) {
        super(changeDetectorRef);
        this.systemSettingsService = systemSettingsService;
        this.systemSettings = this.systemSettingsService.get();
    }
    static { this.ɵfac = function DatetimeViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DatetimeViewComponent)(i0.ɵɵdirectiveInject(SystemSettingsService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DatetimeViewComponent, selectors: [["xf-datetime-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 11, consts: [[3, "ngClass", "title"]], template: function DatetimeViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "p", 0);
            i0.ɵɵtext(1);
            i0.ɵɵpipe(2, "date");
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵclassMapInterpolate1("mb-0 p-0 d-inline ", ctx.fieldClass, "");
            i0.ɵɵpropertyInterpolate("title", ctx.value);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(9, _c0$u, ctx.fieldOptions.size === "large"));
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.value ? i0.ɵɵpipeBind2(2, 6, ctx.value * 1000, ctx.systemSettings.preferences.dateTimeFormat) : "--", "");
        } }, dependencies: [i1.NgClass, i1.DatePipe] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-datetime-view', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p class=\"mb-0 p-0 d-inline {{fieldClass}}\" [ngClass]=\"{'font-size-18px fw-semibold': fieldOptions.size === 'large'}\" title=\"{{value}}\">\n  {{ value ? (value * 1000 | date: systemSettings.preferences.dateTimeFormat) : '--' }}</p>\n" }]
    }], () => [{ type: SystemSettingsService }, { type: i0.ChangeDetectorRef }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DatetimeViewComponent, { className: "DatetimeViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/datetime/datetime-view/datetime-view.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$t = a0 => ({ "pe-0": a0 });
const _c1$i = a0 => ({ "is-invalid": a0 });
function InputFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function InputFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 13);
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r1.field.tooltip);
} }
function InputFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 9);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, InputFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 10)(3, InputFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "input-" + ctx_r1.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.tooltip);
} }
function InputFieldComponent_div_0_xf_form_messages_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 15);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r1.fieldGroup.controls.input)("customErrorMessages", ctx_r1.fieldOptions.customErrorMessages);
} }
function InputFieldComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 18);
    i0.ɵɵlistener("click", function InputFieldComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r1.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function InputFieldComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtemplate(1, InputFieldComponent_div_0_div_7_button_1_Template, 2, 3, "button", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.allowJinjaToggle);
} }
function InputFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, InputFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5)(4, "input", 6, 0);
    i0.ɵɵlistener("focus", function InputFieldComponent_div_0_Template_input_focus_4_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onFocus()); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, InputFieldComponent_div_0_xf_form_messages_6_Template, 1, 2, "xf-form-messages", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, InputFieldComponent_div_0_div_7_Template, 2, 1, "div", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(13, _c0$t, ctx_r1.field.allowJinjaToggle));
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("form-control ", ctx_r1.fieldClass, "");
    i0.ɵɵproperty("type", ctx_r1.numberTypes.indexOf(ctx_r1.field.formType) !== -1 ? "number" : ctx_r1.field.formType)("id", "input-" + ctx_r1.field.name)("ngClass", i0.ɵɵpureFunction1(15, _c1$i, ctx_r1.fieldGroup.controls.input.invalid && ctx_r1.fieldGroup.controls.input.touched))("size", ctx_r1.fieldGroup.value.input && ctx_r1.fieldGroup.value.input.length > 20 ? ctx_r1.fieldGroup.value.input.length : 20)("placeholder", ctx_r1.field.placeholder || "");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showError && ctx_r1.fieldGroup.controls.input);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.allowJinjaToggle);
} }
class InputFieldComponent extends AbstractFieldComponent {
    constructor() {
        super(...arguments);
        this.numberTypes = [Field.BuiltInType.INTEGER, Field.BuiltInType.DECIMAL];
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((value) => {
            this.value = !value || this.numberTypes.indexOf(this.field.formType) === -1 ? value : +value;
        });
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵInputFieldComponent_BaseFactory; return function InputFieldComponent_Factory(__ngFactoryType__) { return (ɵInputFieldComponent_BaseFactory || (ɵInputFieldComponent_BaseFactory = i0.ɵɵgetInheritedFactory(InputFieldComponent)))(__ngFactoryType__ || InputFieldComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: InputFieldComponent, selectors: [["xf-field-input"]], features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }]), i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["inputField", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], ["formControlName", "input", 3, "focus", "type", "id", "ngClass", "size", "placeholder"], [3, "control", "customErrorMessages", 4, "ngIf"], ["class", "w-auto ps-2", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "control", "customErrorMessages"], [1, "w-auto", "ps-2"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"]], template: function InputFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, InputFieldComponent_div_0_Template, 8, 17, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.DefaultValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, FormMessagesComponent], styles: [".max-width-200[_ngcontent-%COMP%]{width:100%;max-width:200px}.picklist-search[_ngcontent-%COMP%]{width:90%;margin:10px 5% 0}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(InputFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-input', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <input [type]=\"numberTypes.indexOf(field.formType) !== -1 ? 'number' : field.formType\"\n        [id]=\"'input-' + field.name\" formControlName=\"input\" #inputField class=\"form-control {{fieldClass}}\"\n        [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid && fieldGroup.controls.input.touched }\"\n        [size]=\"fieldGroup.value.input && fieldGroup.value.input.length > 20 ? fieldGroup.value.input.length : 20\"\n        (focus)=\"onFocus()\" [placeholder]=\"field.placeholder || ''\" />\n      <xf-form-messages *ngIf=\"fieldOptions.showError && fieldGroup.controls.input\" [control]=\"fieldGroup.controls.input\"\n        [customErrorMessages]=\"fieldOptions.customErrorMessages\"></xf-form-messages>\n    </div>\n    <div class=\"w-auto ps-2\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\" *ngIf=\"field.allowJinjaToggle\"\n        title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n</div>\n", styles: [".max-width-200{width:100%;max-width:200px}.picklist-search{width:90%;margin:10px 5% 0}\n"] }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(InputFieldComponent, { className: "InputFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/input/input-field.component.ts", lineNumber: 27 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function InputViewComponent_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 3);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
} }
class InputViewComponent extends AbstractViewComponent {
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵInputViewComponent_BaseFactory; return function InputViewComponent_Factory(__ngFactoryType__) { return (ɵInputViewComponent_BaseFactory || (ɵInputViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(InputViewComponent)))(__ngFactoryType__ || InputViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: InputViewComponent, selectors: [["xf-input-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 4, vars: 7, consts: [[1, "form-group"], ["class", "form-label margin-bottom-4px d-block", 3, "for", 4, "ngIf"], [3, "ngClass", "title"], [1, "form-label", "margin-bottom-4px", "d-block", 3, "for"]], template: function InputViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, InputViewComponent_label_1_Template, 2, 2, "label", 1);
            i0.ɵɵelementStart(2, "p", 2);
            i0.ɵɵtext(3);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fieldOptions.showLabel);
            i0.ɵɵadvance();
            i0.ɵɵclassMapInterpolate1("mb-0 p-0 d-inline ", ctx.fieldClass, "");
            i0.ɵɵpropertyInterpolate("title", ctx.value);
            i0.ɵɵproperty("ngClass", ctx.fieldOptions.size === "large" ? "font-size-18px fw-semibold" : "font-size-14px");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.value ? ctx.value : "--");
        } }, dependencies: [i1.NgClass, i1.NgIf], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(InputViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-input-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px d-block\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n  </label>\n  <p class=\"mb-0 p-0 d-inline {{fieldClass}}\"\n    [ngClass]=\"fieldOptions.size === 'large' ? 'font-size-18px fw-semibold' : 'font-size-14px'\" title=\"{{value}}\">{{\n    value ? value : '--' }}</p>\n</div>\n" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(InputViewComponent, { className: "InputViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/input/input-view.component.ts", lineNumber: 15 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Filter {
    constructor(field = null, operator = null, value = null, oldValue) {
        this.type = '';
        this.evaluation = false;
        this.field = field;
        this.operator = operator;
        this.value = value;
        this.originalValue = value;
        this.oldValue = oldValue;
    }
    // public get value() {
    //   return this._value;
    // }
    // public set value(value: any) {
    //   this._value = value;
    // }
    populateFieldAndOperator(entity) {
        let fieldName = this.field;
        entity.attributes.forEach((field) => {
            if (field.name === fieldName) {
                let operator = this.operator ? field.getOperator(this.operator) : null;
                this.field = field.name;
                this.operator = operator?.savedId || null;
                this.value = field.getFlatValue(this.originalValue, operator);
            }
        });
    }
    evaluate(entity) {
        if (!this.field || !this.operator) {
            this.evaluation = false;
            return;
        }
        const field = entity.fields[this.field];
        const operator = field.getOperator(this.operator);
        this.evaluation = operator ? operator.evaluator(field, this.value) : false;
    }
    getFlatFilter() {
        // if(this.operator.getFlatValue) {
        //   return this.operator.getFlatValue();
        // } else {
        //   return this.value;
        // }
        // let value: any;
        // if (isArray(this.value)) {
        //   value = [];
        //   this.value.forEach((val: any) => {
        //     if (isObject(val)) {
        //       value.push(val['@id' as keyof typeof val])
        //     } else {
        //       value.push(val);
        //     }
        //   });
        // } else if (isObject(this.value)) {
        //   value = this.value['@id' as keyof typeof this.value];
        // } else {
        //   value = this.value;
        // }
        // let _value: any = (this.operator === 'like' || this.operator === 'notlike') ? value : value;
        return {
            operator: this.operator,
            field: this.field,
            value: this.value
        };
    }
    getURLQuery(entity) {
        const field = entity.fields[this.field];
        const operator = field.getOperator(this.operator);
        return field.getURLQueryValue(this.originalValue, operator);
    }
}

class Operator {
    constructor(id, title, renderer, evaluator, savedId = '') {
        this.id = '';
        this.savedId = '';
        this.title = '';
        this.id = id;
        this.savedId = savedId || this.id;
        this.title = title;
        this.renderer = renderer;
        this.evaluator = evaluator;
    }
}

class FilterGroup {
    constructor(filters, logic = 'AND') {
        this.logic = 'AND';
        this.filters = [];
        this.filters = filters;
        this.logic = logic;
    }
}
__decorate([
    Type(() => Filter, {
        discriminator: {
            property: 'logic',
            subTypes: [
                { value: FilterGroup, name: 'AND' },
                { value: FilterGroup, name: 'OR' },
            ],
        },
    })
], FilterGroup.prototype, "filters", void 0);

class Query {
    constructor(query) {
        this.limit = DEFAULT_GRID_ROWS;
        this.search = '';
        this.logic = 'AND';
        this.page = 1;
        this.relationships = false;
        this.selectedFields = [];
        this.filters = [];
        this.sort = [];
        this.aggregates = [];
        this.showDeleted = false;
        this.ignoreFields = [];
        this.queryParams = {};
        Object.assign(this, query);
    }
    getURLParameters() {
        let queryParams = {};
        if (this.limit) {
            queryParams.$limit = this.limit;
        }
        if (this.page > 0) {
            queryParams.$page = this.page;
        }
        if (this.relationships === true) {
            queryParams.$relationships = this.relationships;
        }
        if (this.search?.length > 0) {
            queryParams.$search = this.search;
        }
        if (this.showDeleted === true) {
            queryParams.$showDeleted = this.showDeleted;
        }
        if (this.queryParams) {
            forEach(this.queryParams, (value, key) => {
                queryParams[key] = value;
            });
        }
        if (this.sort.length > 0) {
            // if (entity) {
            //   var sorts = angular.copy(this.sort);
            //   this.sort = [];
            //   for (var i = 0, iLen = sorts.length; i < iLen; i++) {
            //     var fieldName = sorts[i].field;
            //     var fieldObj = entity.fields ? entity.fields[fieldName] : undefined;
            //     if (fieldObj) {
            //       var fieldSort = fieldObj.buildSort(sorts[i].direction || sorts[i].sort.direction);
            //       for (var fieldSortIndex = 0; fieldSortIndex < fieldSort.length; fieldSortIndex++) {
            //         this.sort.push(fieldSort[fieldSortIndex]);
            //       }
            //     }
            //   }
            // }
            let orderBy = '';
            this.sort.forEach((sortItem, index) => {
                if (index > 0) {
                    orderBy += ',';
                }
                let direction = sortItem.direction.toLowerCase() === 'desc' ? '-' : '+';
                orderBy += direction + sortItem.field;
            });
            queryParams.$orderby = orderBy;
        }
        return queryParams;
    }
    mergeQueries(queries) {
        forEach(queries, (query) => {
            this.filters.push(...query.filters);
            this.sort.push(...query.sort);
        });
    }
    getQueryObject(useValue = false) {
        let query = {
            sort: [],
            logic: this.logic,
            page: this.page
        };
        if (this.search.length > 0) {
            query.search = this.search;
        }
        if (this.showDeleted === true) {
            query.showDeleted = this.showDeleted;
        }
        query.filters = cloneDeep(this.filters);
        if (this.relationships) {
            query.$relationships = this.relationships;
        }
        if (query.filters.length > 0) {
            query.logic = this.logic;
            query.filters = this.transformFilters(query.filters, useValue);
        }
        if (this.aggregates && this.aggregates.length > 0) {
            query.aggregates = this.aggregates;
        }
        if (this.selectedFields.length > 0) {
            query.fields = this.selectedFields;
        }
        if (this.ignoreFields?.length > 0) {
            query.__ignoreFields = this.ignoreFields;
        }
        if (this.sort.length > 0) {
            query.sort = this.sort;
        }
        // else if (defaultQuery && defaultQuery.sort) {
        //   query.sort = defaultQuery.sort;
        // }
        return query;
    }
    ;
    transformFilters(filters, useValue) {
        let transFormedFilters = [];
        filters.forEach((filter) => {
            // this is a related record filter
            // if (filter.subFields) {
            //   delete filter.subFields;
            //   filter.field = filter.module + '.' + filter.field;
            //   delete filter.module;
            // }
            //if(filter.value && isString(filter.value) && filter.value.indexOf('{{') !== -1){
            //see for any query object in URL if yes then apply where ever the {{expressions}} are used.
            // if(!angular.isUndefined($state.params.qparam) && useValue){
            //   var interpolateObject = JSON.parse($state.params.qparam);
            //   interpolateObject.currentUserIri = currentUserIriService;
            //   filter.value = $interpolate(filter.value)(interpolateObject);
            //   if(filter.updateDateIntervalValue){//its a datetime filter
            //     filter.value = filter.value.indexOf('differenceType')>=0?JSON.parse(filter.value):filter.value;//this is case of dateRange where object is passed
            //     filter.updateDateIntervalValue(filter);
            //   }
            // }
            //}
            if (filter.filters?.length > 0) {
                filter = filter;
                let returnedFilter = this.transformFilters(filter.filters, useValue);
                let filterObj = {
                    logic: filter.logic,
                    filters: returnedFilter
                };
                transFormedFilters.push(filterObj);
            }
            else if (filter instanceof Filter) {
                transFormedFilters.push(filter.getFlatFilter());
            }
        });
        return transFormedFilters;
    }
    getURLQuery(entity) {
        let flatQuery = {};
        if (this.search) {
            flatQuery.$search = this.search;
        }
        Object.assign(flatQuery, this.getURLParameters());
        this.filters.forEach((filter) => {
            if (filter instanceof Filter) {
                console.log(filter.getURLQuery(entity));
                Object.assign(flatQuery, filter.getURLQuery(entity));
            }
        });
        return flatQuery;
    }
    asFilterGroup() {
        return new FilterGroup(this.filters, this.logic);
    }
}
__decorate([
    Type(() => Filter, {
        discriminator: {
            property: 'logic',
            subTypes: [
                { value: FilterGroup, name: 'AND' },
                { value: FilterGroup, name: 'OR' },
            ]
        },
        keepDiscriminatorProperty: true
    }),
    Transform(({ value }) => {
        return value.map((item) => {
            if (item.filters) {
                return plainToInstance(FilterGroup, item); // Manually convert FilterGroup if it contains filters
            }
            return plainToInstance(Filter, item); // Otherwise, convert to Filter
        });
    })
], Query.prototype, "filters", void 0);

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SearchableItem {
    constructor(display, value, uuid) {
        this.display = display;
        this.value = value;
        this.uuid = uuid;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$s = ["toggleButton"];
const _c1$h = a0 => ({ "is-invalid": a0 });
function DatetimeFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 21);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function DatetimeFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 22);
    i0.ɵɵelement(1, "i", 23);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r1.field.tooltip);
} }
function DatetimeFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 18);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, DatetimeFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 19)(3, DatetimeFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 20);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "input-" + ctx_r1.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.tooltip);
} }
function DatetimeFieldComponent_div_0_button_19_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 24);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_button_19_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r1.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function DatetimeFieldComponent_div_0_xf_form_messages_20_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 25);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r1.fieldGroup.controls.inputDate);
} }
function DatetimeFieldComponent_div_0_xf_form_messages_21_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 25);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r1.fieldGroup.controls.inputTime);
} }
function DatetimeFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, DatetimeFieldComponent_div_0_label_1_Template, 4, 4, "label", 4);
    i0.ɵɵelementStart(2, "div", 5)(3, "div", 6)(4, "div", 7);
    i0.ɵɵlistener("openChange", function DatetimeFieldComponent_div_0_Template_div_openChange_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.setDefaultValue($event)); });
    i0.ɵɵelementStart(5, "button", 8, 0);
    i0.ɵɵtext(7);
    i0.ɵɵpipe(8, "date");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "div", 9)(10, "ngb-datepicker", 10, 1);
    i0.ɵɵlistener("dateSelect", function DatetimeFieldComponent_div_0_Template_ngb_datepicker_dateSelect_10_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.dateSelected($event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(12, "div", 11);
    i0.ɵɵelement(13, "ngb-timepicker", 12);
    i0.ɵɵelementStart(14, "div", 13)(15, "button", 14);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.ngbDropdown.close()); });
    i0.ɵɵtext(16, "Apply");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(17, "button", 15);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_Template_button_click_17_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.clear()); });
    i0.ɵɵtext(18, "Clear");
    i0.ɵɵelementEnd()()()()();
    i0.ɵɵtemplate(19, DatetimeFieldComponent_div_0_button_19_Template, 2, 3, "button", 16);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(20, DatetimeFieldComponent_div_0_xf_form_messages_20_Template, 1, 1, "xf-form-messages", 17)(21, DatetimeFieldComponent_div_0_xf_form_messages_21_Template, 1, 1, "xf-form-messages", 17);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    let tmp_7_0;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showLabel);
    i0.ɵɵadvance(4);
    i0.ɵɵclassMapInterpolate1("datepicker btn btn-input text-start w-100 ", ctx_r1.fieldClass, "");
    i0.ɵɵproperty("id", "input-" + ctx_r1.field.name)("ngClass", i0.ɵɵpureFunction1(14, _c1$h, ((tmp_7_0 = ctx_r1.fieldGroup.get("inputDate")) == null ? null : tmp_7_0.touched) && ((tmp_7_0 = ctx_r1.fieldGroup.get("inputDate")) == null ? null : tmp_7_0.invalid)));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", ctx_r1.value ? i0.ɵɵpipeBind2(8, 11, ctx_r1.value, ctx_r1.systemSettings.preferences.dateTimeFormat) : "Select Date", " ");
    i0.ɵɵadvance(12);
    i0.ɵɵproperty("ngIf", ctx_r1.field.allowJinjaToggle);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showError);
} }
class DatetimeFieldComponent extends AbstractFieldComponent {
    constructor(systemSettingsService, changeDetectorRef, formBuilder) {
        super(changeDetectorRef, formBuilder);
        this.systemSettingsService = systemSettingsService;
        this.isFirstChange = true;
        this.systemSettings = this.systemSettingsService.get();
    }
    get value() {
        return this._value;
    }
    set value(value) {
        super.value = value;
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.removeControl('input');
        const date = this.getDateFromValue();
        const time = this.getTimeFromValue();
        this.fieldGroup?.addControl('inputDate', new FormControl(date, this.fieldService.getValidators(this.field)));
        this.fieldGroup?.addControl('inputTime', new FormControl(time));
        this.fieldGroup?.valueChanges
            .subscribe((value) => {
            this.isFirstChange = false;
            if (!value.inputDate || !value.inputTime) {
                this.value = null;
                this.changeDetectorRef.detectChanges();
                return;
            }
            let date = new Date(Date.UTC(value.inputDate.year, value.inputDate.month - 1, value.inputDate.day, value.inputTime ? value.inputTime.hour : 0, value.inputTime ? value.inputTime.minute : 0));
            let timezoneOffset = new Date().getTimezoneOffset();
            date.setMinutes(date.getMinutes() + timezoneOffset);
            //this.value = date.getTime() / 1000;
            this.value = date;
            this.changeDetectorRef.detectChanges();
        });
    }
    getTimeFromValue() {
        if (!this.value) {
            return null;
        }
        let currentDate = new Date(this.value);
        return {
            minute: currentDate.getMinutes(),
            hour: currentDate.getHours()
        };
    }
    getDateFromValue() {
        if (!this.value) {
            return null;
        }
        let currentDate = new Date(this.value);
        return {
            year: currentDate.getFullYear(),
            month: currentDate.getMonth() + 1,
            day: currentDate.getDate()
        };
    }
    writeValue(value) {
        this.value = value;
        if (this.fieldGroup && this.fieldGroup.controls.inputDate && this.fieldGroup.controls.inputTime) {
            const date = this.getDateFromValue();
            const time = this.getTimeFromValue();
            this.fieldGroup.controls.inputDate.setValue(date);
            this.fieldGroup.controls.inputTime.setValue(time);
        }
    }
    validate(control) {
        this.control = control;
        if (!this.fieldGroup?.controls.inputDate?.valid) {
            return this.fieldGroup?.controls.inputDate?.errors || null;
        }
        if (!this.fieldGroup.controls.inputTime?.valid) {
            return this.fieldGroup.controls.inputTime?.errors || null;
        }
        return null;
    }
    dateSelected(event) {
        if (this.isFirstChange && event.day === this.fieldGroup?.controls.inputDate.value.day) {
            this.fieldGroup?.controls.inputDate.setValue(event);
        }
        this.isFirstChange = false;
    }
    setDefaultValue(opened) {
        if (opened && !this.value) {
            this.writeValue(new Date());
        }
    }
    clear() {
        this.writeValue(null);
        this.ngbDropdown.close();
    }
    focus() {
        this.ngbDropdownToggle.nativeElement.focus();
        this.fieldGroup?.markAllAsTouched();
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function DatetimeFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DatetimeFieldComponent)(i0.ɵɵdirectiveInject(SystemSettingsService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DatetimeFieldComponent, selectors: [["xf-datetime-field"]], viewQuery: function DatetimeFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(_c0$s, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.ngbDropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.ngbDropdownToggle = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }]), i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["toggleButton", ""], ["dp", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "input-group", "mw-250px", "w-100"], [1, "d-flex"], ["ngbDropdown", "", 1, "flex-grow-1", "datepicker-container", 3, "openChange"], ["type", "button", "ngbDropdownToggle", "", 3, "id", "ngClass"], ["ngbDropdownMenu", ""], ["formControlName", "inputDate", 3, "dateSelect"], [1, "d-flex", "align-items-center", "justify-content-center"], ["formControlName", "inputTime"], [1, "ms-2"], ["type", "button", 1, "btn", "btn-sm", "btn-primary", 3, "click"], ["type", "button", 1, "btn", "btn-sm", "btn-default", "mt-1", 3, "click"], ["type", "button", "class", "ms-2 btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], [3, "control", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], ["type", "button", "title", "Add Custom Expression", 1, "ms-2", "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"], [3, "control"]], template: function DatetimeFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, DatetimeFieldComponent_div_0_Template, 22, 16, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, i3.NgbDatepicker, i3.NgbTimepicker, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu, FormMessagesComponent, i1.DatePipe] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-datetime-field', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"input-group mw-250px w-100\">\n    <div class=\"d-flex\">\n      <div ngbDropdown class=\"flex-grow-1 datepicker-container\" (openChange)=\"setDefaultValue($event)\">\n        <button type=\"button\" [id]=\"'input-' + field.name\"\n          class=\"datepicker btn btn-input text-start w-100 {{fieldClass}}\" #toggleButton\n          [ngClass]=\"{'is-invalid': fieldGroup.get('inputDate')?.touched && fieldGroup.get('inputDate')?.invalid}\"\n          ngbDropdownToggle>\n          {{ value ? ( value | date: systemSettings.preferences.dateTimeFormat) : 'Select Date' }}\n        </button>\n        <div ngbDropdownMenu>\n          <ngb-datepicker #dp formControlName=\"inputDate\" (dateSelect)=\"dateSelected($event)\"></ngb-datepicker>\n          <div class=\"d-flex align-items-center justify-content-center\">\n            <ngb-timepicker formControlName=\"inputTime\"></ngb-timepicker>\n            <div class=\"ms-2\">\n              <button type=\"button\" class=\"btn btn-sm btn-primary\" (click)=\"ngbDropdown.close()\">Apply</button>\n              <button type=\"button\" class=\"btn btn-sm btn-default mt-1\" (click)=\"clear()\">Clear</button>\n            </div>\n          </div>\n        </div>\n      </div>\n      <button type=\"button\" class=\"ms-2 btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n    <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.inputDate\"></xf-form-messages>\n    <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.inputTime\"></xf-form-messages>\n  </div>\n</div>\n" }]
    }], () => [{ type: SystemSettingsService }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { ngbDropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], ngbDropdownToggle: [{
            type: ViewChild,
            args: ['toggleButton']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DatetimeFieldComponent, { className: "DatetimeFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/datetime/datetime-field/datetime-field.component.ts", lineNumber: 27 }); })();

class Field {
    get visibility() {
        return this._visibility;
    }
    set visibility(value) {
        if (Array.isArray(value)) {
            value = value[0];
        }
        this._visibility = plainToInstance(Query, value);
    }
    getFlatValue(value, operator) {
        return value;
    }
    getViewValue(value) {
        return value;
    }
    static { this.listOperators = [
        new Operator('in', 'Is In List', null, this.evaluateIsInList),
        new Operator('nin', 'Is Not In List', null, this.evaluateIsNotInList),
    ]; }
    static { this.nullOperator = [
        new Operator('isnull', 'Is Null', CheckboxFieldComponent, this.evaluateIsNull),
    ]; }
    static { this.equalOperators = [
        new Operator('eq', 'Equals', InputFieldComponent, this.evaluateEqual),
        new Operator('neq', 'Not Equals', InputFieldComponent, this.evaluateNotEqual),
    ]; }
    static { this.greaterThanLessThanOperators = [
        new Operator('lt', 'Before', DatetimeFieldComponent, this.evaluateBefore),
        new Operator('lte', 'On or Before', DatetimeFieldComponent, this.evaluateOnOrBefore),
        new Operator('gt', 'After', DatetimeFieldComponent, this.evaluateAfter),
        new Operator('gte', 'On or After', DatetimeFieldComponent, this.evaluateOnOrAfter),
    ]; }
    static { this.numericGreaterThanLessThanOperators = [
        new Operator('lt', 'Less Than', InputFieldComponent, this.evaluateBefore),
        new Operator('lte', 'Less Than or Equal To', InputFieldComponent, this.evaluateOnOrBefore),
        new Operator('gt', 'Greater Than', InputFieldComponent, this.evaluateAfter),
        new Operator('gte', 'Greater Than or Equal To', InputFieldComponent, this.evaluateOnOrAfter),
    ]; }
    static { this.operators = this.equalOperators; }
    getOperator(operatorId) {
        return this.operators.find((op) => {
            return op.id === operatorId;
        });
    }
    get operators() {
        return Object.getPrototypeOf(this).constructor.operators;
    }
    constructor(name, formType) {
        this.defaultValue = '';
        this.blankDisplay = '';
        this.title = '';
        this.type = '';
        this.encrypted = false;
        this.gridColumn = false;
        this.orderIndex = 0;
        this.peerReplicable = false;
        this.htmlEscape = false;
        this.inversedField = null;
        this.ownsRelationship = false;
        this.recommend = false;
        this.searchable = false;
        this.system = false;
        this.tooltip = '';
        this.subtitle = '';
        this.validation = {
            required: false
        };
        this._visibility = true;
        this.writeable = true;
        this.visible = true;
        this.required = false;
        this.isFormField = false;
        this.isRelationship = false;
        this.displayTemplate = '';
        this.readOnly = false;
        this.trackable = false;
        this.placeholder = '';
        this.OPERATOR_KEY = '$';
        this.fieldContainerClass = ''; //for field container class like specific width (w-50, w-70) or col-md-6
        this.orphanRemoval = false;
        this.allowJinjaToggle = false;
        this.alwaysJinja = false;
        this.filter = Filter; //ArrayFilter|ObjectFilter
        this.params = {};
        this.mapping = {};
        //private _relationshipFields = ['manyToMany', 'oneToMany'];
        this.alwaysEditMode = false;
        this.name = name;
        this.formType = formType;
        this.descriptions = {
            singular: ''
        };
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    get descriptions() {
        return this._descriptions;
    }
    set descriptions(value) {
        this._descriptions = value;
        if (this._descriptions) {
            this.title = this._descriptions.singular || this.name;
        }
        else {
            this.title = this.title || this.name;
        }
    }
    get dataSource() {
        return this._dataSource;
    }
    set dataSource(value) {
        this._dataSource = value;
    }
    setMode(mode) {
        this.visibility = mode === 'archived' ? true : this.visibility;
        if (mode === 'archived') {
            this.visible = true;
            this.validation.required = false;
        }
        else {
            //this.evaluateRequired();
            //this.evaluateVisible();
        }
    }
    static evaluateIsInList(field, value) {
        return false;
    }
    static evaluateIsNotInList(field, value) {
        return false;
    }
    static evaluateIsNull(field, value) {
        return false;
    }
    ;
    static evaluateEqual(field, value) {
        return false;
    }
    static evaluateNotEqual(field, value) {
        return false;
    }
    static evaluateBefore(field, value) {
        return false;
    }
    static evaluateOnOrBefore(field, value) {
        return false;
    }
    static evaluateAfter(field, value) {
        return false;
    }
    static evaluateOnOrAfter(field, value) {
        return false;
    }
    asSearchableItem() {
        return new SearchableItem(this.title, this, this.name);
    }
    buildSort(order) {
        const sort = [];
        if (this.name === '@id') {
            sort.push({
                field: 'id',
                direction: order,
                _fieldName: this.name
            });
        }
        else if (!this.model) {
            sort.push({
                field: this.name,
                direction: order,
                _fieldName: this.name
            });
            return sort;
        }
        else if (this.defaultSort) {
            this.defaultSort.forEach((sortItem) => {
                sort.push({
                    field: this.name + '.' + sortItem.field,
                    direction: order,
                    _fieldName: this.name
                });
            });
        }
        return sort;
    }
    ;
    getURLQueryValue(value, operator) {
        let query = {};
        let _operator = operator.id === 'like_pattern' ? 'like' : operator.id;
        _operator = operator.id === 'notlike_pattern' ? 'notlike' : operator.id;
        query[`${this.name}${this.OPERATOR_KEY}${_operator}`] = this.getFlatValue(value, operator);
        return query;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: -1
        };
    }
}
(function (Field) {
    let BuiltInType;
    (function (BuiltInType) {
        BuiltInType["TEXT"] = "text";
        BuiltInType["PASSWORD"] = "password";
        BuiltInType["INTEGER"] = "integer";
        BuiltInType["DECIMAL"] = "decimal";
        BuiltInType["CHECKBOX"] = "checkbox";
        BuiltInType["EMAIL"] = "email";
        BuiltInType["DATETIME"] = "datetime";
        BuiltInType["LOOKUP"] = "lookup";
        BuiltInType["MULTISELECT_PICKLIST"] = "multiselectpicklist";
        BuiltInType["PICKLIST"] = "picklist";
        BuiltInType["MANY_TO_MANY"] = "manyToMany";
        BuiltInType["ONE_TO_MANY"] = "oneToMany";
        BuiltInType["FILE"] = "file";
        BuiltInType["JSON"] = "json";
        BuiltInType["JINJA"] = "jinja";
        BuiltInType["ARRAY"] = "array";
        BuiltInType["PHONE"] = "phone";
        BuiltInType["DOMAIN"] = "domain";
        BuiltInType["FILEHASH"] = "fileHash";
        BuiltInType["IPv4"] = "ipv4";
        BuiltInType["IPv6"] = "ipv6";
        BuiltInType["RICHTEXTHTML"] = "html";
        BuiltInType["RICHTEXTMARKDOWN"] = "richtext";
        BuiltInType["TEXTAREA"] = "textarea";
        BuiltInType["URL"] = "url";
        BuiltInType["TAGS"] = "tags";
        BuiltInType["SELECT"] = "select";
        BuiltInType["MULTISELECT"] = "multiselect";
        BuiltInType["RADIO"] = "radio";
        BuiltInType["TOGGLE"] = "toggle";
        BuiltInType["MULTISELECTCHECKBOXDROPDOWN"] = "multiSelectCheckboxDropdown";
        BuiltInType["TOGGLEDROPDOWN"] = "toggleDropdown";
        BuiltInType["CERTIFICATE"] = "certificate";
    })(BuiltInType = Field.BuiltInType || (Field.BuiltInType = {}));
})(Field || (Field = {}));

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class UtilityService {
    constructor(router, route, breadcrumbService) {
        this.router = router;
        this.route = route;
        this.breadcrumbService = breadcrumbService;
        // Individual components can subscribe to this to receive document click events
        this.documentClickedTarget = new Subject();
        this.navigationChanged = new ReplaySubject(1);
        this.permissionsChanged = new Subject();
    }
    generateUUID() {
        return v4();
    }
    setTitleAlias(alias, value, newPath) {
        let breadcrumb = {
            label: value,
        };
        if (newPath) {
            breadcrumb.routeInterceptor = () => newPath;
        }
        return this.breadcrumbService.set('@' + alias, breadcrumb);
    }
    isUndefined(value) {
        return value === undefined || value === null;
    }
    convertHexToRgbA(value) {
        value = value === undefined || value === null ? '#000000' : value;
        let hexcode;
        if (/^#([A-Fa-f0-9]{3}){1,2}$/.test(value)) {
            hexcode = value.substring(1).split('');
            if (hexcode.length === 3) {
                hexcode = [
                    hexcode[0],
                    hexcode[0],
                    hexcode[1],
                    hexcode[1],
                    hexcode[2],
                    hexcode[2],
                ];
            }
            hexcode = '0x' + hexcode.join('');
            return ('rgba(' +
                [(hexcode >> 16) & 255, (hexcode >> 8) & 255, hexcode & 255].join(',') +
                ',0.8)');
        }
        else {
            return 'rgba(0, 0, 0, 0.1)';
        }
    }
    //set parameters in URL
    setParametersInUrl(queryParams) {
        forEach(queryParams, (paramValue, paramKey) => {
            if (paramValue === '' || paramValue === null) {
                delete queryParams[paramKey];
            }
        });
        this.router.navigate([], {
            relativeTo: this.route,
            queryParams: queryParams,
        });
    }
    //append new parameter in URL
    appendNewParameterInUrl(newQueryParams) {
        this.router.navigate([], {
            relativeTo: this.route,
            queryParams: newQueryParams,
            queryParamsHandling: 'merge',
        });
    }
    filterFields(fields, search, fieldsAlreadyAdded) {
        return of(fields).pipe(map$1((fields) => {
            return fields.map((field) => field.asSearchableItem());
        }), map$1((items) => {
            return items.filter((item) => {
                return fieldsAlreadyAdded.indexOf(item.uuid) === -1;
            });
        }), map$1((items) => {
            return items.filter((item) => {
                return (___default.isString(item.display) &&
                    item.display.toLowerCase().indexOf(search.toLowerCase()) > -1);
            });
        }));
    }
    downloadFile(fileData, fileName, fileType) {
        let file;
        let downloadLink;
        // file
        file = new Blob([fileData], { type: fileType });
        const navigator = window.navigator;
        if (navigator && navigator.msSaveOrOpenBlob) {
            navigator.msSaveOrOpenBlob(file, fileName);
        }
        else {
            // Download link
            downloadLink = document.createElement('a');
            // File name
            downloadLink.download = fileName;
            // Create a link to the file
            downloadLink.href = window.URL.createObjectURL(file);
            // Hide download link
            downloadLink.style.display = 'none';
            // Add the link to DOM
            document.body.appendChild(downloadLink);
            // Click download link
            downloadLink.click();
        }
    }
    csvToJSON(CSVcontents) {
        let contents = CSVcontents.split('\r\n');
        let columnNames = contents[0].replace(/\n|\r/g, '').split(',');
        let data = [];
        for (let i = 1; i < contents.length; i++) {
            if (contents[i] !== '' &&
                contents[i] !== null &&
                contents[i] !== undefined) {
                let rowData = contents[i].replace(/\n|\r/g, '').split(',');
                let dataObj = {};
                for (let j = 0; j < rowData.length; j++) {
                    dataObj[columnNames[j]] = rowData[j];
                }
                data.push(dataObj);
            }
        }
        return { columns: columnNames, data: data };
    }
    newAttribute() {
        return {
            // uuid: $window.UUID.generate(),
            isNew: true,
            ownsRelationship: false,
            visibility: true,
            writeable: true,
            editable: true,
            gridColumn: false,
            defaultValue: '',
            value: null,
            validation: {
                required: false,
                minlength: 0,
                // maxlength: MAX_TEXT_LENGTH
            },
            name: '(Untitled)',
            title: '(Untitled)',
            descriptions: {
                singular: '(Untitled)',
            },
            formType: 'text',
            type: 'string',
        };
    }
    convertToCamelCase(string) {
        if (!isUndefined(string)) {
            return string
                .replace(/(?:^\w|[A-Z]|\b\w)/g, function (letter, index) {
                return index === 0 ? letter.toLowerCase() : letter.toUpperCase();
            })
                .replace(/\s+/g, '');
        }
        return string;
    }
    getBaseContextPath() {
        var baseHrefElement = document.querySelector('base');
        if (baseHrefElement) {
            return baseHrefElement.getAttribute('href') || '';
        }
        return '';
    }
    getIriApiPath(IRI) {
        if (IRI.charAt(0) === '/') {
            return IRI.substring(1);
        }
        // else if (IRI.indexOf('currentUserIri') > -1){
        //   return $interpolate(IRI)({currentUserIri: currentUserIriService});
        // }
        return IRI;
    }
    getOrigin() {
        return (location.protocol +
            '://' +
            location.host +
            ':' +
            location.port +
            this.getBaseContextPath());
    }
    prependIri(value) {
        return `${API.API_3_BASE}${value}`;
    }
    formatBytes(a, b = 2) {
        if (!+a)
            return '0 Bytes';
        const c = 0 > b ? 0 : b;
        const d = Math.floor(Math.log(a) / Math.log(1024));
        return `${parseFloat((a / Math.pow(1024, d)).toFixed(c))} ${['Bytes', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'][d]}`;
    }
    getTimeInterval(toDateStr, fromDateStr, ms_time) {
        let toDate, fromDate, ms;
        if (!ms_time) {
            toDate = new Date(toDateStr);
            fromDate = new Date(fromDateStr);
            ms = toDate - fromDate;
        }
        else {
            ms = ms_time;
        }
        let seconds = ms >= 1000 ? ms / 1000 : parseInt((ms / 1000).toString(), 10);
        ms = ms % 1000;
        let minutes = parseInt((seconds / 60).toString(), 10);
        seconds = parseInt((seconds % 60).toString(), 10);
        let hours = parseInt((minutes / 60).toString(), 10);
        minutes = minutes % 60;
        let returnVal = '';
        if (hours > 0) {
            returnVal += Math.round(hours) + ' hours ';
        }
        if (minutes > 0) {
            returnVal += Math.round(minutes) + ' minutes ';
        }
        if (seconds > 0) {
            returnVal += Math.round(seconds) + ' seconds ';
        }
        if (ms > 0) {
            returnVal += Math.round(ms) + ' ms';
        }
        return returnVal;
    }
    addJinjaBraces(value) {
        return `{{${value}}}`;
    }
    removeJinjaBraces(value) {
        return value.replace('{{', '').replace('}}', '').trim();
    }
    getTimeAgo(fromDateStr, toDateStr, ms_time) {
        let toDate, fromDate, ms;
        if (!ms_time) {
            toDate = toDateStr ? new Date(toDateStr) : new Date();
            fromDate = new Date(fromDateStr);
            ms = toDate - fromDate;
        }
        else {
            ms = ms_time;
        }
        let seconds = ms >= 1000 ? ms / 1000 : parseInt((ms / 1000).toString(), 10);
        ms = ms % 1000;
        let minutes = parseInt((seconds / 60).toString(), 10);
        seconds = parseInt((seconds % 60).toString(), 10);
        let hours = parseInt((minutes / 60).toString(), 10);
        minutes = minutes % 60;
        let days = parseInt((hours / 24).toString(), 10);
        let months = parseInt((days / 30).toString(), 10);
        let years = parseInt((months / 12).toString(), 10);
        let returnVal = '';
        if (ms > 0) {
            returnVal = Math.round(ms) + ' ms';
        }
        if (seconds > 0) {
            returnVal = Math.round(seconds) + ' second(s) ';
        }
        if (minutes > 0) {
            returnVal = Math.round(minutes) + ' minute(s) ';
        }
        if (hours > 0) {
            returnVal = Math.round(hours) + ' hour(s) ';
        }
        if (days > 0) {
            returnVal = Math.round(days) + ' day(s) ';
        }
        if (months > 0) {
            returnVal = Math.round(months) + ' month(s) ';
        }
        if (years > 0) {
            returnVal = Math.round(years) + ' year(s) ';
        }
        return returnVal;
    }
    typeOf(value) {
        if (___default.isArray(value)) {
            return 'list';
        }
        else if (___default.isNumber(value)) {
            return 'number';
        }
        else if (___default.isObject(value)) {
            return 'dict';
        }
        else if (___default.isString(value)) {
            return 'string';
        }
        else if (___default.isBoolean(value)) {
            return 'boolean';
        }
        else {
            return 'any';
        }
    }
    getFieldTypeByValue(value) {
        let dataType = Field.BuiltInType.TEXT;
        try {
            let val = JSON.parse(value);
            if (___default.isNumber(val)) {
                dataType = Field.BuiltInType.DECIMAL;
            }
            else if (___default.isBoolean(val)) {
                dataType = Field.BuiltInType.CHECKBOX;
            }
        }
        catch (error) {
            if (___default.isArray(value)) {
                dataType = Field.BuiltInType.ARRAY;
            }
            else if (___default.isObject(value)) {
                dataType = Field.BuiltInType.JSON;
            }
            else if (new Date(value).toString() !== 'Invalid Date') {
                dataType = Field.BuiltInType.DATETIME;
            }
        }
        return dataType;
    }
    getHigherVersionNumber(version1, version2) {
        const v1split = version1.split('.').map(Number);
        const v2split = version2.split('.').map(Number);
        let index = 0;
        while (index < v1split.length) {
            if (index === v2split.length) {
                return version1;
            }
            const v1Value = v1split[index];
            const v2Value = v2split[index];
            if (v1Value === v2Value) {
                index++;
                continue;
            }
            else if (v1Value > v2Value) {
                return version1;
            }
            else if (v2Value > v1Value) {
                return version2;
            }
        }
        return version2;
    }
    copyToClipboard(value) {
        return new Promise((resolve, reject) => {
            if (navigator.clipboard) {
                navigator.clipboard.writeText(value).then(() => {
                    resolve();
                }).catch((error) => {
                    reject(error);
                });
            }
            else {
                reject('Clipboard API not supported');
            }
        });
    }
    executeMethod(methodName, componentRef) {
        try {
            componentRef[methodName]();
        }
        catch {
            console.warn(`Method ${methodName} not found!`);
        }
    }
    static { this.ɵfac = function UtilityService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UtilityService)(i0.ɵɵinject(i1$2.Router), i0.ɵɵinject(i1$2.ActivatedRoute), i0.ɵɵinject(i2$1.BreadcrumbService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UtilityService, factory: UtilityService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UtilityService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], () => [{ type: i1$2.Router }, { type: i1$2.ActivatedRoute }, { type: i2$1.BreadcrumbService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function FormFieldComponent_ng_template_0_Template(rf, ctx) { }
class FormFieldComponent {
    constructor() {
        this.autoFocus = false;
        this.fieldOptions = new FieldOptions();
        this.jinjaToggled = new EventEmitter();
        this.onSubmit = new EventEmitter();
    }
    ngOnInit() {
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        if (this.field) {
            this.componentRef = viewContainerRef.createComponent(this.field.fieldComponent);
            this.componentRef.instance.field = this.field;
            this.componentRef.instance.autoFocus = this.autoFocus;
            this.componentRef.instance.fieldOptions = this.fieldOptions;
            this.componentRef.instance.fieldClass = this.fieldClass;
            this.componentRef.instance.jinjaToggled = this.jinjaToggled;
            this.componentRef.instance.onSubmit = this.onSubmit;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    ngOnChanges(changes) {
        if (this.componentRef) {
            if (!changes.field?.firstChange && changes.field?.currentValue.formType !== changes.field?.previousValue.formType) {
                this.ngOnInit();
                return;
            }
        }
    }
    writeValue(value) {
        if (this.componentRef) {
            this.componentRef.instance.writeValue(value);
        }
    }
    setDisabledState(isDisabled) {
        if (this.componentRef) {
            this.componentRef.instance.setDisabledState(isDisabled);
        }
    }
    registerOnChange(fn) {
        if (this.componentRef) {
            this.componentRef.instance.registerOnChange(fn);
        }
    }
    registerOnTouched(fn) {
        if (this.componentRef) {
            this.componentRef.instance.registerOnTouched(fn);
        }
    }
    validate(control) {
        if (this.componentRef) {
            return this.componentRef.instance.validate(control);
        }
        else {
            return null;
        }
    }
    get valid() {
        return this.componentRef.instance.valid;
    }
    focus() {
        if (this.componentRef) {
            this.componentRef.instance.focus();
        }
    }
    static { this.ɵfac = function FormFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FormFieldComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FormFieldComponent, selectors: [["xf-form-field"]], viewQuery: function FormFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { field: "field", autoFocus: "autoFocus", fieldOptions: "fieldOptions", fieldClass: "fieldClass" }, outputs: { jinjaToggled: "jinjaToggled", onSubmit: "onSubmit" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FormFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FormFieldComponent),
                    multi: true
                }]), i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["xfViewContainer", ""]], template: function FormFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FormFieldComponent_ng_template_0_Template, 0, 0, "ng-template", 0);
        } }, dependencies: [ViewContainerDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-form-field', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FormFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FormFieldComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<ng-template xfViewContainer></ng-template>\n" }]
    }], () => [], { field: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }], jinjaToggled: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FormFieldComponent, { className: "FormFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/form-field/form-field.component.ts", lineNumber: 27 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function FormViewComponent_ng_template_0_Template(rf, ctx) { }
class FormViewComponent extends AbstractViewComponent {
    ngOnInit() {
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.field.viewComponent);
        this.componentRef.instance.value = this.value;
        this.componentRef.instance.field = this.field;
        this.componentRef.instance.fieldOptions = this.fieldOptions;
        this.componentRef.instance.fieldClass = this.fieldClass;
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    ngOnChanges() {
        if (this.componentRef) {
            this.componentRef.instance.value = this.value;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵFormViewComponent_BaseFactory; return function FormViewComponent_Factory(__ngFactoryType__) { return (ɵFormViewComponent_BaseFactory || (ɵFormViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(FormViewComponent)))(__ngFactoryType__ || FormViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FormViewComponent, selectors: [["xf-form-view"]], viewQuery: function FormViewComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature, i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["xfViewContainer", ""]], template: function FormViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FormViewComponent_ng_template_0_Template, 0, 0, "ng-template", 0);
        } }, dependencies: [ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-form-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<ng-template xfViewContainer></ng-template>\n" }]
    }], null, { xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: true }]
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FormViewComponent, { className: "FormViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/form-view/form-view.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$r = ["formField"];
const _c1$g = a0 => ({ "editable": a0 });
function EditableFieldComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 6);
    i0.ɵɵlistener("click", function EditableFieldComponent_div_0_div_1_Template_div_click_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.toggleEditMode()); });
    i0.ɵɵelement(1, "xf-form-view", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(5, _c1$g, !ctx_r1.readOnly));
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.field)("fieldClass", ctx_r1.fieldClass)("value", ctx_r1.value)("fieldOptions", ctx_r1.fieldOptions);
} }
function EditableFieldComponent_div_0_form_2_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "form", 8);
    i0.ɵɵlistener("ngSubmit", function EditableFieldComponent_div_0_form_2_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.onSave()); });
    i0.ɵɵelement(1, "xf-form-field", 9, 0);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵclassMapInterpolate1("", ctx_r1.field.formType, "-form-type-container");
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(9, _c1$g, ctx_r1.field.alwaysEditMode))("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.field)("fieldOptions", ctx_r1.fieldOptions)("fieldClass", ctx_r1.fieldClass)("autoFocus", ctx_r1.autoFocus);
} }
function EditableFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, EditableFieldComponent_div_0_div_1_Template, 2, 7, "div", 4)(2, EditableFieldComponent_div_0_form_2_Template, 3, 11, "form", 5);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.editMode && !ctx_r1.field.alwaysEditMode || ctx_r1.readOnly);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r1.editMode || ctx_r1.field.alwaysEditMode) && ctx_r1.formGroup && !ctx_r1.readOnly);
} }
function EditableFieldComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 10);
} }
class EditableFieldComponent {
    constructor(utilityService, formBuilder, elementRef, changeDetectorRef) {
        this.utilityService = utilityService;
        this.formBuilder = formBuilder;
        this.elementRef = elementRef;
        this.changeDetectorRef = changeDetectorRef;
        this.editMode = false;
        this.readOnly = false;
        this.showLabel = false;
        this.showInline = false;
        this.disableSubmitOnEnter = false;
        this.autoFocus = false;
        this.editModeChange = new EventEmitter();
        this.valueChange = new EventEmitter();
        this.onSubmit = new EventEmitter();
    }
    ngOnChanges(changes) {
        if (changes.value && !changes.value.firstChange) {
            this.formGroup?.setValue({
                editableField: this.value
            });
        }
        this.changeDetectorRef.detectChanges();
    }
    ngDoCheck() {
        if (isObject(this.value) && this.value['@id'] !== this.oldValueIri) {
            this.oldValueIri = this.value['@id'];
            this.formGroup?.setValue({
                editableField: this.value
            });
            this.changeDetectorRef.detectChanges();
        }
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({
            editableField: []
        });
        this.fieldOptions = new FieldOptions({
            showLabel: this.showLabel,
            size: this.size
        });
        if (this.value) {
            this.formGroup?.setValue({
                editableField: this.value
            });
        }
        this.changeDetectorRef.detectChanges();
        this.formGroup.valueChanges
            .pipe(distinctUntilChanged(), map(values => values.editableField)).subscribe((value) => {
            if (!this.field) {
                return;
            }
            if (isEqual(this.value, value)) {
                return;
            }
            this.value = value;
            this.valueChange.emit(this.value);
            if (this.field.alwaysEditMode) {
                this.onSave();
            }
        });
    }
    ngOnDestroy() {
        this.unsubscribe();
    }
    subscribe() {
        this.subscription = this.utilityService.documentClickedTarget
            .subscribe(event => this.handleClickEvent(event));
    }
    unsubscribe() {
        this.subscription?.unsubscribe();
        this.subscription = undefined;
    }
    toggleEditMode() {
        if (this.readOnly) {
            return;
        }
        this.editMode = true;
        this.editModeChange.emit(this.editMode);
        this.changeDetectorRef.detectChanges();
        this.formField.focus();
        this.unsubscribe();
        setTimeout(() => this.subscribe());
    }
    handleClickEvent(event) {
        if (!this.elementRef.nativeElement.contains(event.target) && this.editMode) {
            this.onSave();
        }
    }
    onSave() {
        if (this.formGroup?.invalid) {
            return;
        }
        this.value = this.formGroup?.value.editableField;
        this.valueChange.emit(this.value);
        this.editMode = false;
        this.editModeChange.emit(this.editMode);
        this.onSubmit.emit();
        this.unsubscribe();
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function EditableFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditableFieldComponent)(i0.ɵɵdirectiveInject(UtilityService), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EditableFieldComponent, selectors: [["xf-editable-field"]], viewQuery: function EditableFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$r, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formField = _t.first);
        } }, inputs: { editMode: "editMode", readOnly: "readOnly", showLabel: "showLabel", size: "size", showInline: "showInline", disableSubmitOnEnter: "disableSubmitOnEnter", autoFocus: "autoFocus", field: "field", value: "value", fieldOptions: "fieldOptions", fieldClass: "fieldClass" }, outputs: { editModeChange: "editModeChange", valueChange: "valueChange", onSubmit: "onSubmit" }, features: [i0.ɵɵProvidersFeature([FormBuilder]), i0.ɵɵNgOnChangesFeature], decls: 2, vars: 2, consts: [["formField", ""], ["class", "editable-field-container", 4, "ngIf"], ["class", "bg-shimmer title-line", 4, "ngIf"], [1, "editable-field-container"], [3, "ngClass", "click", 4, "ngIf"], [3, "ngClass", "class", "formGroup", "ngSubmit", 4, "ngIf"], [3, "click", "ngClass"], [3, "field", "fieldClass", "value", "fieldOptions"], [3, "ngSubmit", "ngClass", "formGroup"], ["formControlName", "editableField", 3, "field", "fieldOptions", "fieldClass", "autoFocus"], [1, "bg-shimmer", "title-line"]], template: function EditableFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, EditableFieldComponent_div_0_Template, 3, 2, "div", 1)(1, EditableFieldComponent_div_1_Template, 1, 0, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.field && ctx.fieldOptions);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.editMode && (!ctx.field || ctx.value === undefined));
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FormFieldComponent, FormViewComponent], styles: [".editable-field-container[_ngcontent-%COMP%]   .editable[_ngcontent-%COMP%]:hover{background:var(--form-default-bg-color);cursor:pointer}.editable-field-container[_ngcontent-%COMP%]   .editable[_ngcontent-%COMP%]:hover.form-select{background:inherit}.editable-field-container[_ngcontent-%COMP%]   .editable.picklist-form-type-container[_ngcontent-%COMP%]:hover{background:none}.editable-field-container[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%]:focus, .editable-field-container[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%]:active{background:var(--form-default-bg-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditableFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-editable-field', providers: [FormBuilder], changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *ngIf=\"field && fieldOptions\" class=\"editable-field-container\">\n  <div [ngClass]=\"{'editable': !readOnly}\" *ngIf=\"(!editMode && !field.alwaysEditMode) || readOnly\" (click)=\"toggleEditMode()\">\n    <xf-form-view [field]=\"field\" [fieldClass]=\"fieldClass\" [value]=\"value\" [fieldOptions]=\"fieldOptions\"></xf-form-view>\n  </div>\n  <form *ngIf=\"(editMode || field.alwaysEditMode) && formGroup && !readOnly\" [ngClass]=\"{'editable': field.alwaysEditMode}\" class=\"{{field.formType}}-form-type-container\" [formGroup]=\"formGroup\" (ngSubmit)=\"onSave()\">\n    <xf-form-field formControlName=\"editableField\" [field]=\"field\" [fieldOptions]=\"fieldOptions\" [fieldClass]=\"fieldClass\" #formField [autoFocus]=\"autoFocus\"></xf-form-field>\n  </form>\n</div>\n<div *ngIf=\"!editMode && (!field || value === undefined)\" class=\"bg-shimmer title-line\"></div>\n", styles: [".editable-field-container .editable:hover{background:var(--form-default-bg-color);cursor:pointer}.editable-field-container .editable:hover.form-select{background:inherit}.editable-field-container .editable.picklist-form-type-container:hover{background:none}.editable-field-container .form-control:focus,.editable-field-container .form-control:active{background:var(--form-default-bg-color)}\n"] }]
    }], () => [{ type: UtilityService }, { type: i2.FormBuilder }, { type: i0.ElementRef }, { type: i0.ChangeDetectorRef }], { editMode: [{
            type: Input
        }], readOnly: [{
            type: Input
        }], showLabel: [{
            type: Input
        }], size: [{
            type: Input
        }], showInline: [{
            type: Input
        }], disableSubmitOnEnter: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], editModeChange: [{
            type: Output
        }], valueChange: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], field: [{
            type: Input
        }], value: [{
            type: Input
        }], formField: [{
            type: ViewChild,
            args: ['formField']
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(EditableFieldComponent, { className: "EditableFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/editable-field/editable-field.component.ts", lineNumber: 24 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ApiService {
    constructor() {
        this.http = inject(HttpClient);
    }
    getList(entity, type, params = {}) {
        return this.http.get(`${entity.baseUrl}${entity.type}/`, {
            params: params
        }).pipe(map$1((response) => {
            return type ? plainToInstance(type, response['hydra:member']) : response['hydra:member'];
        }));
    }
    getRecord(entity, uuid, type, ignoreErrors = false) {
        return this.http.get(`${entity.baseUrl}${entity.type}/${uuid}/`, {
            context: new HttpContext().set(IGNORE_ERRORS, ignoreErrors)
        }).pipe(map$1((response) => {
            return type ? plainToInstance(type, response) : response;
        }));
    }
    query(entity, queryBody, params = {}, ignoreErrors = false) {
        return this.http.post(`${entity.baseUrl}${API.QUERY_PART}${entity.type}/`, queryBody, {
            params: params,
            context: new HttpContext().set(IGNORE_ERRORS, ignoreErrors)
        }).pipe(map$1((response) => {
            return response;
        }));
    }
    updateRecord(entity, uuid, payload) {
        return this.http.patch(`${entity.baseUrl}${entity.type}/${uuid}/`, payload);
    }
    createRecord(entity, payload) {
        let url = `${entity.baseUrl}${entity.type}/`;
        return this.http.post(url, payload);
    }
    upsertRecord(entity, payload) {
        if (payload.uuid) {
            return this.updateRecord(entity, payload.uuid, payload);
        }
        else {
            return this.createRecord(entity, payload);
        }
    }
    deleteRecord(entity, uuid, ignoreErrors = false) {
        return this.http.delete(`${entity.baseUrl}${entity.type}/${uuid}/`, {
            context: new HttpContext().set(IGNORE_ERRORS, ignoreErrors)
        });
    }
    static { this.ɵfac = function ApiService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ApiService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ApiService, factory: ApiService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ApiService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class CheckboxFloatingFilterComponent {
    constructor() {
        this.formBuilder = inject(FormBuilder);
        this.currentValue = 'any';
        this.valueMappings = {};
        this.formGroup = this.formBuilder.group({
            value: ['any']
        });
        this.formGroup.valueChanges.subscribe((values) => {
            this.currentValue = values.value;
            this.updateFilter();
        });
    }
    agInit(params) {
        this.params = params;
        this.valueMappings = 'values' in params.filterParams ? params.filterParams.values : {};
    }
    onParentModelChanged(parentModel) {
        // When the filter is empty we will receive a null value here
        if (!parentModel) {
            this.currentValue = 'any';
        }
        else {
            this.currentValue = parentModel.filter;
        }
    }
    updateFilter() {
        this.params.parentFilterInstance((instance) => {
            instance.onFloatingFilterChanged('boolean', this.currentValue);
        });
    }
    static { this.ɵfac = function CheckboxFloatingFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CheckboxFloatingFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CheckboxFloatingFilterComponent, selectors: [["xf-checkbox-floating-filter"]], decls: 8, vars: 6, consts: [[1, "w-100", 3, "formGroup"], ["formControlName", "value", 1, "form-select", "form-control-xs", "w-100px"], [3, "ngValue"]], template: function CheckboxFloatingFilterComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "select", 1)(2, "option", 2);
            i0.ɵɵtext(3, "Any");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "option", 2);
            i0.ɵɵtext(5);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(6, "option", 2);
            i0.ɵɵtext(7);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngValue", "any");
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngValue", true);
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.valueMappings.true || "Checked");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngValue", false);
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.valueMappings.false || "Unchecked");
        } }, dependencies: [i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CheckboxFloatingFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-checkbox-floating-filter', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"w-100\" [formGroup]=\"formGroup\">\n  <select class=\"form-select form-control-xs w-100px\" formControlName=\"value\">\n    <option [ngValue]=\"'any'\">Any</option>\n    <option [ngValue]=\"true\">{{ valueMappings.true || 'Checked' }}</option>\n    <option [ngValue]=\"false\">{{ valueMappings.false || 'Unchecked' }}</option>\n  </select>\n</div>\n" }]
    }], () => [], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CheckboxFloatingFilterComponent, { className: "CheckboxFloatingFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/checkbox/checkbox-floating-filter/checkbox-floating-filter.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class CheckboxGridFilterComponent {
    agInit(params) {
        this.params = params;
    }
    isFilterActive() {
        return this.currentValue !== 'any';
    }
    doesFilterPass(params) {
        return true;
    }
    getModel() {
        return this.currentValue;
    }
    setModel(model) {
        this.currentValue = model;
    }
    onFloatingFilterChanged(type, value) {
        this.currentValue = {
            filterType: type,
            filter: value
        };
        this.updateFilter();
    }
    updateFilter() {
        this.params.filterChangedCallback();
    }
    static { this.ɵfac = function CheckboxGridFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CheckboxGridFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CheckboxGridFilterComponent, selectors: [["xf-checkbox-grid-filter"]], decls: 0, vars: 0, template: function CheckboxGridFilterComponent_Template(rf, ctx) { } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CheckboxGridFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-checkbox-grid-filter', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<!-- <h1>Should not be visible</h1> -->\n" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CheckboxGridFilterComponent, { className: "CheckboxGridFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/checkbox/checkbox-grid-filter/checkbox-grid-filter.component.ts", lineNumber: 15 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class CheckboxField extends Field {
    static { this.checkboxOperators = [
        new Operator('eq', 'Equals', CheckboxFieldComponent, this.evaluateEqual)
    ]; }
    static { this.operators = [...CheckboxField.checkboxOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.CHECKBOX);
        this.viewMode = 'toggle';
        this.customLabel = { labelOn: '', labelOff: '' };
        this.isFormField = true;
        this.isRelationship = false;
        this.alwaysEditMode = true;
        this.fieldComponent = CheckboxFieldComponent;
        this.viewComponent = CheckboxViewComponent;
        this.defaultColDef = {
            filter: CheckboxGridFilterComponent,
            floatingFilterComponent: CheckboxFloatingFilterComponent,
            cellRenderer: (params) => {
                let valueMappings = 'values' in params.colDef?.filterParams ? (params.colDef?.filterParams).values : {};
                return `<i class="align-middle fa fa-circle fa-lg font-size-8px ${params.value ? 'text-success' : 'text-muted muted-40'}"></i><span class="font-size-12px margin-left-8px muted-10">${params.value ? valueMappings.true || 'Checked' : valueMappings.false || 'Unchecked'}</span>`;
            },
            suppressFloatingFilterButton: true
        };
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DatetimeFilter extends Filter {
    constructor(field = null, value = null, secondValue = null) {
        super(field, null, value);
        this.secondValue = secondValue;
        this.secondValue = secondValue;
    }
    getFlatFilter() {
        let filters = [{
                field: this.field,
                operator: 'gte',
                value: this.value.toUTCString()
            }];
        if (this.secondValue) {
            filters.push({
                field: this.field,
                operator: 'lte',
                value: this.secondValue.toUTCString()
            });
        }
        return {
            logic: 'AND',
            filters: filters
        };
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function DatetimeFloatingFilterComponent_option_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 2);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r1 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", option_r1.value);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r1.name);
} }
class DatetimeFloatingFilterComponent {
    constructor() {
        this.formBuilder = inject(FormBuilder);
        this.currentValue = null;
        this.pastOptions = [
            { value: { differenceType: 'years', differenceValue: -1 }, name: 'Last Year' },
            { value: { differenceType: 'months', differenceValue: -6 }, name: 'Last 6 Months' },
            { value: { differenceType: 'months', differenceValue: -3 }, name: 'Last 3 Months' },
            { value: { differenceType: 'months', differenceValue: -1 }, name: 'Last Month' },
            { value: { differenceType: 'months', differenceValue: -1, lastDate: true }, name: 'Last Calendar Month' },
            { value: { differenceType: 'days', differenceValue: -15 }, name: 'Last 15 Days' },
            { value: { differenceType: 'days', differenceValue: -30 }, name: 'Last 30 Days' },
            { value: { differenceType: 'days', differenceValue: -7 }, name: 'Last 7 Days' },
            { value: { differenceType: 'hours', differenceValue: -24 }, name: 'Last 24 Hours' },
            { value: { differenceType: 'hours', differenceValue: -1 }, name: 'Last Hour' },
            { value: { differenceType: 'mins', differenceValue: -30 }, name: 'Last 30 Min' },
            { value: { differenceType: 'years', differenceValue: 0 }, name: 'This Year' },
            { value: { differenceType: 'months', differenceValue: 0, lastDate: true }, name: 'This Month' },
            { value: { differenceType: 'days', differenceValue: 0 }, name: 'Today' }
        ];
        this.futureOptions = [
            { value: { differenceType: 'years', differenceValue: 1 }, name: 'Next Year' },
            { value: { differenceType: 'days', differenceValue: 15 }, name: 'Next 15 Days' },
            { value: { differenceType: 'days', differenceValue: 7 }, name: 'Next 7 Days' },
            { value: { differenceType: 'hours', differenceValue: 24 }, name: 'Next 24 Hours' },
            { value: { differenceType: 'hours', differenceValue: 6 }, name: 'Next 6 Hours' }
        ];
        this.relativeOptions = [];
        this.formGroup = this.formBuilder.group({
            value: [null]
        });
        this.formGroup.valueChanges.subscribe((values) => {
            this.currentValue = values.value;
            this.updateFilter();
        });
    }
    agInit(params) {
        this.params = params;
        let relativeDates = params.filterParams.colDef.headerComponentParams.field.options?.relativeDates || 'past';
        if (relativeDates === 'both') {
            this.relativeOptions = [...this.pastOptions, ...this.futureOptions];
        }
        else if (relativeDates === 'past') {
            this.relativeOptions = this.pastOptions;
        }
        else if (relativeDates === 'future') {
            this.relativeOptions = this.futureOptions;
        }
    }
    onParentModelChanged(parentModel) {
        // When the filter is empty we will receive a null value here
        if (!parentModel) {
            this.currentValue = null;
        }
        else {
            this.currentValue = parentModel.filter;
        }
    }
    updateFilter() {
        if (!this.currentValue) {
            this.params.parentFilterInstance((instance) => {
                instance.onFloatingFilterChanged(null, null);
            });
        }
        this.params.parentFilterInstance((instance) => {
            instance.onFloatingFilterChanged('date', this.currentValue);
        });
    }
    static { this.ɵfac = function DatetimeFloatingFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DatetimeFloatingFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DatetimeFloatingFilterComponent, selectors: [["xf-lookup-floating-filter"]], decls: 5, vars: 3, consts: [[1, "d-inline-block", 3, "formGroup"], ["formControlName", "value", 1, "form-select", "w-auto", "form-select-xs"], [3, "ngValue"], [3, "ngValue", 4, "ngFor", "ngForOf"]], template: function DatetimeFloatingFilterComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "select", 1)(2, "option", 2);
            i0.ɵɵtext(3, "Select");
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(4, DatetimeFloatingFilterComponent_option_4_Template, 2, 2, "option", 3);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngValue", null);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.relativeOptions);
        } }, dependencies: [i1.NgForOf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeFloatingFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-lookup-floating-filter', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"d-inline-block\" [formGroup]=\"formGroup\">\n  <select class=\"form-select w-auto form-select-xs\" formControlName=\"value\">\n    <option [ngValue]=\"null\">Select</option>\n    <option *ngFor=\"let option of relativeOptions\" [ngValue]=\"option.value\">{{ option.name }}</option>\n  </select>\n</div>\n" }]
    }], () => [], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DatetimeFloatingFilterComponent, { className: "DatetimeFloatingFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/datetime/datetime-floating-filter/datetime-floating-filter.component.ts", lineNumber: 17 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DatetimeGridFilterComponent {
    constructor() {
        this.currentValue = null;
    }
    agInit(params) {
        this.params = params;
    }
    isFilterActive() {
        return this.currentValue !== null;
    }
    doesFilterPass(params) {
        console.log(params);
        return params.data.year >= 2010;
    }
    getModel() {
        return this.currentValue;
    }
    setModel(model) {
        this.currentValue = model;
    }
    onFloatingFilterChanged(type, value) {
        this.currentValue = {
            filterType: 'date',
            filter: value
        };
        this.updateFilter();
    }
    updateFilter() {
        this.params.filterChangedCallback();
    }
    static { this.ɵfac = function DatetimeGridFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DatetimeGridFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DatetimeGridFilterComponent, selectors: [["xf-datetime-grid-filter"]], decls: 0, vars: 0, template: function DatetimeGridFilterComponent_Template(rf, ctx) { } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeGridFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-datetime-grid-filter', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<!-- <h1>Should not be visible</h1> -->\n" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DatetimeGridFilterComponent, { className: "DatetimeGridFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/datetime/datetime-grid-filter/datetime-grid-filter.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DatetimeField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.DATETIME);
        this.isFormField = true;
        this.isRelationship = false;
        this.viewComponent = DatetimeViewComponent;
        this.fieldComponent = DatetimeFieldComponent;
        this.filter = DatetimeFilter;
        this.gridFloatingFilterComponent = DatetimeFloatingFilterComponent;
        this.gridFilterComponent = DatetimeGridFilterComponent;
    }
    static { this.dateOperators = [
        new Operator('date', 'Is In', null, this.evaluateIsIn)
    ]; }
    static { this.operators = [...Field.equalOperators, ...Field.greaterThanLessThanOperators, ...Field.nullOperator, ...DatetimeField.dateOperators]; }
    static evaluateIsIn(field, value) {
        console.log(field, value);
        return false;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DecimalField extends Field {
    static { this.operators = [...Field.equalOperators, ...Field.numericGreaterThanLessThanOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.DECIMAL);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class EmailField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.EMAIL);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: 255
        };
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class IntegerField extends Field {
    static { this.operators = [...Field.equalOperators, ...Field.greaterThanLessThanOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.INTEGER);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^[0-9]+$/;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    getFieldLength() {
        return {
            minlength: MIN_NUMBER_LIMIT,
            maxlength: ALL_RECORDS_SIZE
        };
    }
}

const _c0$q = ["multiselect"];
const _c1$f = a0 => ({ "pe-0": a0 });
const _c2$8 = a0 => ({ "is-invalid": a0 });
function MultiselectFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function MultiselectFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 13);
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function MultiselectFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 9);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, MultiselectFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 10)(3, MultiselectFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "multiselect-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function MultiselectFieldComponent_div_0_xf_form_messages_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 15);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
function MultiselectFieldComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 18);
    i0.ɵɵlistener("click", function MultiselectFieldComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function MultiselectFieldComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtemplate(1, MultiselectFieldComponent_div_0_div_7_button_1_Template, 2, 3, "button", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function MultiselectFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, MultiselectFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5);
    i0.ɵɵelement(4, "ng-multiselect-dropdown", 6, 0);
    i0.ɵɵtemplate(6, MultiselectFieldComponent_div_0_xf_form_messages_6_Template, 1, 1, "xf-form-messages", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, MultiselectFieldComponent_div_0_div_7_Template, 2, 1, "div", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(10, _c1$f, ctx_r0.field.allowJinjaToggle));
    i0.ɵɵadvance();
    i0.ɵɵproperty("id", "multiselect-" + ctx_r0.field.name)("placeholder", ctx_r0.field.placeholder || "")("settings", ctx_r0.dropdownSettings)("data", ctx_r0.options)("ngClass", i0.ɵɵpureFunction1(12, _c2$8, ctx_r0.fieldGroup.controls.input.invalid && ctx_r0.fieldGroup.controls.input.touched));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
class MultiselectFieldComponent extends AbstractFieldComponent {
    constructor(http, entityService, changeDetectorRef, formBuilder) {
        super(changeDetectorRef, formBuilder);
        this.http = http;
        this.entityService = entityService;
        this.options = [];
        this.dropdownSettings = {
            singleSelection: false,
            idField: 'value',
            textField: 'label',
            selectAllText: 'Select All',
            unSelectAllText: 'Deselect All',
            allowSearchFilter: true
        };
    }
    get value() {
        return this._value;
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.onChange(value);
            this.setSelectedOptions(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((options) => {
            const value = options.map((option) => option.value);
            this.onChange(value);
        });
        let options$;
        if (this.fieldOptions.options.length || this.field.options.length) {
            let options = this.fieldOptions.options.length > 0 ? this.fieldOptions.options : this.field.options || [];
            options$ = of(options);
        }
        else if (this.field.dataSource?.model) {
            options$ = this.entityService.build(this.field.dataSource.model).pipe(concatMap((entity) => {
                const url = `${this.field.dataSource.baseURL || API.QUERY}${this.field.dataSource.model}/`;
                const request = this.field.dataSource.requestType === 'GET' ? this.http.get(url, this.field.dataSource.query) : this.http.post(url, this.field.dataSource.query);
                return request.pipe(map((response) => {
                    return response['hydra:member'].map((item) => {
                        return {
                            value: item['@id'] || item.uuid,
                            label: this.entityService.getDisplayValue(entity, item)
                        };
                    });
                }));
            }));
        }
        else {
            options$ = of([]);
        }
        options$.subscribe((options) => {
            this.options = options;
            this.setSelectedOptions(this.value, false);
            this.changeDetectorRef.detectChanges();
        });
    }
    setSelectedOptions(value, emitEvent = true) {
        if (value && this.fieldGroup && this.fieldGroup.controls.input) {
            const selectedOptions = this.options.filter((option) => value.indexOf(option.value) > -1);
            this.fieldGroup?.controls.input.setValue(selectedOptions, { emitEvent: emitEvent });
        }
    }
    focus() {
        // not possible with ng-multiselect :/
    }
    static { this.ɵfac = function MultiselectFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || MultiselectFieldComponent)(i0.ɵɵdirectiveInject(i1$1.HttpClient), i0.ɵɵdirectiveInject(EntityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiselectFieldComponent, selectors: [["xf-multiselect-field"]], viewQuery: function MultiselectFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$q, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.multiselect = _t.first);
        } }, inputs: { field: "field" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["multiselect", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], ["formControlName", "input", 1, "multiselect-dropdown-wrapper", 3, "id", "placeholder", "settings", "data", "ngClass"], [3, "control", 4, "ngIf"], ["class", "w-auto ps-2", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "control"], [1, "w-auto", "ps-2"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"]], template: function MultiselectFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, MultiselectFieldComponent_div_0_Template, 8, 14, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i5.MultiSelectComponent, i3.NgbTooltip, FormMessagesComponent], styles: [".multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn{border-color:var(--form-default-border-color)!important;padding:8px!important;font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .selected-item{font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .selected-item a{color:rgb(var(--bs-danger-rgb))!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret{background-image:var(--form-select-dropdown-svg);background-repeat:no-repeat;background-position:right .75rem center;background-size:16px 12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret:before{content:unset!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list{background-color:var(--form-secondary-border-color);border-color:var(--form-default-border-color);box-shadow:0 1px 5px var(--form-default-border-color);margin-top:0}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .item1 .multiselect-item-checkbox{border-bottom:1px solid var(--form-default-border-color)!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .no-filtered-data h5{font-size:14px;opacity:.7}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox{border-bottom:1px solid var(--form-default-border-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox input{color:var(--form-field-input-font-color);background-color:var(--form-default-bg-color);border:1px solid var(--form-default-border-color)!important;padding:5px 5px 5px 40px!important;font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox input:focus{box-shadow:var(--form-default-box-shadow);background-color:var(--form-default-bg-color);color:var(--form-field-input-focus-font-color);border-color:var(--form-default-focus-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox:before{content:\"\\f002\";display:inline-block;position:absolute;font-family:\"Font Awesome 6 Pro\";opacity:.5;font-size:14px;top:11px;left:12px;padding:4px 8px;border-right:1px solid var(--border-primary-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]{background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]:checked+div:before{background-color:var(--highlight-active-color);background-image:var(--form-checkbox-bg-svg);background-position:center}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div{color:var(--font-primary-color);font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:before{background-color:var(--form-default-bg-color);border-color:var(--form-check-border-color);color:var(--form-field-input-font-color);border-radius:4px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:after{content:unset!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox:hover{background-color:var(--element-inverse-bg-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiselectFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-multiselect-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'multiselect-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <ng-multiselect-dropdown [id]=\"'multiselect-' + field.name\" [placeholder]=\"field.placeholder || ''\"\n        [settings]=\"dropdownSettings\" [data]=\"options\" formControlName=\"input\" class=\"multiselect-dropdown-wrapper\"\n        [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid && fieldGroup.controls.input.touched}\"\n        #multiselect></ng-multiselect-dropdown>\n      <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n    </div>\n    <div class=\"w-auto ps-2\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n\n</div>\n", styles: [".multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn{border-color:var(--form-default-border-color)!important;padding:8px!important;font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .selected-item{font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .selected-item a{color:rgb(var(--bs-danger-rgb))!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret{background-image:var(--form-select-dropdown-svg);background-repeat:no-repeat;background-position:right .75rem center;background-size:16px 12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret:before{content:unset!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list{background-color:var(--form-secondary-border-color);border-color:var(--form-default-border-color);box-shadow:0 1px 5px var(--form-default-border-color);margin-top:0}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .item1 .multiselect-item-checkbox{border-bottom:1px solid var(--form-default-border-color)!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .no-filtered-data h5{font-size:14px;opacity:.7}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox{border-bottom:1px solid var(--form-default-border-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox input{color:var(--form-field-input-font-color);background-color:var(--form-default-bg-color);border:1px solid var(--form-default-border-color)!important;padding:5px 5px 5px 40px!important;font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox input:focus{box-shadow:var(--form-default-box-shadow);background-color:var(--form-default-bg-color);color:var(--form-field-input-focus-font-color);border-color:var(--form-default-focus-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox:before{content:\"\\f002\";display:inline-block;position:absolute;font-family:\"Font Awesome 6 Pro\";opacity:.5;font-size:14px;top:11px;left:12px;padding:4px 8px;border-right:1px solid var(--border-primary-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]{background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]:checked+div:before{background-color:var(--highlight-active-color);background-image:var(--form-checkbox-bg-svg);background-position:center}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div{color:var(--font-primary-color);font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:before{background-color:var(--form-default-bg-color);border-color:var(--form-check-border-color);color:var(--form-field-input-font-color);border-radius:4px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:after{content:unset!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox:hover{background-color:var(--element-inverse-bg-color)}\n"] }]
    }], () => [{ type: i1$1.HttpClient }, { type: EntityService }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { field: [{
            type: Input
        }], multiselect: [{
            type: ViewChild,
            args: ['multiselect']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(MultiselectFieldComponent, { className: "MultiselectFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/multiselect/multiselect-field.component.ts", lineNumber: 28 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ManyToManyField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.MANY_TO_MANY);
        this.allowJinjaToggle = false;
        this.isFormField = false;
        this.isRelationship = true;
        this.fieldComponent = MultiselectFieldComponent;
    }
}

class PicklistName {
    constructor(uuid) {
        this.picklists = [];
        this.uuid = uuid;
    }
}

class PicklistService {
    constructor(http, storage, entityService) {
        this.http = http;
        this.storage = storage;
        this.entityService = entityService;
        this.picklists = null;
    }
    loadPicklistName(picklistName) {
        if (this.picklists && this.picklists[picklistName]) {
            return of(plainToInstance(PicklistName, this.picklists[picklistName]));
        }
        return this.http
            .get(API.API_3_BASE + 'picklist_names', {
            params: {
                name: picklistName
            }
        })
            .pipe(map((response) => plainToInstance(PicklistName, response['hydra:member'][0])));
    }
    getPicklistByIri(iri) {
        let iriParts = iri.split('/');
        let getChildPicklistValue = iriParts[3] === 'picklists';
        return this.loadAllPicklists().pipe(map((picklistNames) => {
            let result;
            if (getChildPicklistValue) {
                for (let i = 0; i < picklistNames.length; i++) {
                    let _picklistName = picklistNames[i];
                    result = _.find(_picklistName.picklists, (picklist) => {
                        return picklist['@id'] === iri;
                    });
                    if (result) {
                        break;
                    }
                }
            }
            else {
                result = _.find(picklistNames, (picklistName) => {
                    return picklistName['@id'] === iri;
                });
            }
            if (result) {
                return result;
            }
            else {
                return;
            }
        }));
    }
    getPicklistByUUID(uuid) {
        return this.loadAllPicklists().pipe(map((picklists) => {
            let result = _.find(picklists, (picklist) => {
                return picklist.uuid === uuid;
            });
            return result;
        }));
    }
    removeFromCache(picklist) {
        if (isObject(picklist)) {
            // this.storage.remove('picklists.'+picklist.name);
            // localStorageService.remove('picklists.'+$filter('getEndPathName')(picklist['@id']));
        }
        else {
            //localStorageService.remove('picklists.'+picklist);
        }
    }
    loadAllPicklists(useExport = false) {
        // TODO: Picklist URL needs to change
        //const url = `${API.API_3_BASE}picklist_names?$export=${useExport}&$limit=${ALL_RECORDS_SIZE}&$orderby=name&$relationships=true`;
        const url = 'assets/dummyData/picklists.json';
        if (this.picklists) {
            return of(this.picklists);
        }
        return this.http.get(url).pipe(map((response) => {
            this.picklists = {};
            forEach(response['hydra:member'], (picklist) => {
                this.picklists[picklist.name] = picklist;
            });
            return response['hydra:member'];
        }));
    }
    loadPicklists(field, metadata) {
        let picklists$ = new Subject();
        let entity$;
        if (!metadata) {
            entity$ = this.entityService.build('picklists').pipe(map((entity) => {
                metadata = entity;
                return metadata;
            }));
        }
        else {
            entity$ = of(metadata);
        }
        entity$.subscribe({
            next: (entity) => {
                if (field?.dataSource?.query?.filters?.length > 0 && field.dataSource?.query.filters[0]?.value) {
                    const picklists = this.storage.getItem('picklists.' + field.dataSource.query.filters[0].value);
                    if (picklists && picklists.length > 0) {
                        field.options = picklists;
                        this.entityService.setDisplayName(field, entity);
                        picklists$.next(field);
                        picklists$.complete();
                    }
                    else {
                        this.loadPicklistsByParams(field.dataSource.query.filters[0].value, 'name').subscribe({
                            next: (result) => {
                                if (result && result.length > 0) {
                                    field.options = result;
                                    this.entityService.setDisplayName(field, entity);
                                    this.storage.setItem('picklists.' + field.dataSource.query.filters[0].value, field.options);
                                    picklists$.next(field);
                                    picklists$.complete();
                                }
                                else {
                                    picklists$.next({});
                                    picklists$.complete();
                                }
                            }, error: (error) => {
                                picklists$.error(error);
                            }
                        });
                    }
                }
                else {
                    picklists$.error(false);
                }
            }, error: (error) => {
                picklists$.error(error);
            }
        });
        return picklists$.asObservable();
    }
    loadPicklistsByParams(itemVal, itemKey) {
        let picklists = this.storage.getItem(`picklists.${itemVal}`);
        if (picklists && picklists.length > 0) {
            return of(picklists);
        }
        else {
            let query = {
                limit: ALL_RECORDS_SIZE,
                $orderby: 'orderIndex'
            };
            query['listName__' + itemKey] = itemVal;
            return this.http.get(`${API.BASE}picklists`, { params: query }).pipe(map((result) => {
                if (result && result['hydra:member']) {
                    this.storage.setItem('picklists.' + itemVal, picklists);
                    return result['hydra:member'];
                }
                else {
                    return throwError(() => new Error('Not a valid picklist query'));
                }
            }), catchError$1(error => {
                return throwError(() => error);
            }));
        }
    }
    static { this.ɵfac = function PicklistService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistService)(i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(StorageService), i0.ɵɵinject(EntityService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PicklistService, factory: PicklistService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }, { type: StorageService }, { type: EntityService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ThemeService {
    constructor(systemSettingsService, document) {
        this.systemSettingsService = systemSettingsService;
        this.document = document;
        this.theme = THEMES.DEFAULT;
        this.themeChanged = new Subject();
    }
    getTheme() {
        let userPreferences = this.systemSettingsService.getUserPreferences();
        if (userPreferences.theme) {
            return userPreferences.theme;
        }
        let systemSettings = this.systemSettingsService.get();
        return systemSettings.preferences.theme || 'dark';
    }
    applyTheme(theme, customThemeLink = null) {
        const head = this.document.getElementsByTagName('head')[0];
        theme = theme ?? this.theme;
        this.theme = theme;
        const href = `${theme}.css`;
        this.themeChanged.next(this.theme);
        let themeLink = this.document.getElementById('client-theme');
        if (themeLink) {
            themeLink.href = href;
        }
        else {
            const style = this.document.createElement('link');
            style.id = 'client-theme';
            style.rel = 'stylesheet';
            style.href = href;
            head.appendChild(style);
        }
        if (customThemeLink) {
            this.applyCustomTheme(customThemeLink);
        }
    }
    applyCustomTheme(customThemeLink) {
        const head = this.document.getElementsByTagName('head')[0];
        let themeLink = this.document.getElementById('custom-theme');
        if (themeLink) {
            themeLink.href = customThemeLink;
        }
        else {
            const style = this.document.createElement('link');
            style.id = 'custom-theme';
            style.rel = 'stylesheet';
            style.href = customThemeLink;
            head.appendChild(style);
        }
    }
    static { this.ɵfac = function ThemeService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ThemeService)(i0.ɵɵinject(SystemSettingsService), i0.ɵɵinject(DOCUMENT)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ThemeService, factory: ThemeService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ThemeService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: SystemSettingsService }, { type: Document, decorators: [{
                type: Inject,
                args: [DOCUMENT]
            }] }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$p = (a0, a1, a2) => ({ "form-select-lg": a0, "form-select-xs": a1, "colored": a2 });
const _c1$e = (a0, a1) => ({ "background": a0, "color": a1 });
function PicklistFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 10);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function PicklistFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵelement(1, "i", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function PicklistFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 7);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, PicklistFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 8)(3, PicklistFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 9);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function PicklistFieldComponent_div_0_option_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 5);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", option_r2.uuid);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r2.itemValue);
} }
function PicklistFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, PicklistFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "select", 4, 0);
    i0.ɵɵpipe(4, "isHexColorLight");
    i0.ɵɵelementStart(5, "option", 5);
    i0.ɵɵtext(6, "Select");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, PicklistFieldComponent_div_0_option_7_Template, 2, 2, "option", 6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("form-select picklist ", ctx_r0.fieldClass, "");
    i0.ɵɵproperty("name", "picklist-" + ctx_r0.field.picklistName)("ngClass", i0.ɵɵpureFunction3(12, _c0$p, ctx_r0.fieldOptions.size === "large", ctx_r0.fieldOptions.size === "small", !!(ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color)))("ngStyle", i0.ɵɵpureFunction2(16, _c1$e, (ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color) ? ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color : "", (ctx_r0.value == null ? null : ctx_r0.value.color) && i0.ɵɵpipeBind1(4, 10, ctx_r0.value == null ? null : ctx_r0.value.color) ? "rgba(0, 0, 0, 0.8)" : (ctx_r0.value == null ? null : ctx_r0.value.color) ? "rgba(255, 255, 255, 0.8)" : !(ctx_r0.value == null ? null : ctx_r0.value.color) && ctx_r0.currentTheme === "light" ? "rgba(0, 0, 0, 0.8)" : "rgba(255, 255, 255, 0.8)"));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngValue", null);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r0.picklistItems);
} }
class PicklistFieldComponent extends AbstractFieldComponent {
    constructor(picklistService, _changeDetectorRef, _formBuilder, themeService) {
        super(_changeDetectorRef, _formBuilder);
        this.picklistService = picklistService;
        this._changeDetectorRef = _changeDetectorRef;
        this._formBuilder = _formBuilder;
        this.themeService = themeService;
        this.picklistItems = [];
        this.currentTheme = this.themeService.getTheme();
    }
    ngAfterViewInit() {
        if (!this.field) {
            return;
        }
        if (this.field.picklistName == '') {
            console.warn('Picklist name not specified');
            return;
        }
        this.picklistService.loadPicklistName(this.field.picklistName).subscribe((picklistName) => {
            if (!picklistName) {
                console.warn(`Picklist ${this.field.picklistName} not found`);
                return;
            }
            this.picklistItems = picklistName.picklists;
            if (this.value || this.field.defaultValue) {
                this.value = this.picklistItems.find((item) => (this.field.defaultValue || this.value) && (this.value.uuid || this.field.defaultValue) === item.uuid);
            }
            this.changeDetectorRef.detectChanges();
        });
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((value) => {
            this.value = isString(value) ? value : value.uuid;
        });
    }
    writeValue(value) {
        if (value && this.picklistItems.length) {
            this.value = this.picklistItems.find((item) => value && value.uuid === value.uuid);
        }
        else {
            this.value = value;
        }
    }
    static { this.ɵfac = function PicklistFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistFieldComponent)(i0.ɵɵdirectiveInject(PicklistService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PicklistFieldComponent, selectors: [["xf-field-picklist"]], inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["inputField", ""], ["class", "form-group w-fit-content", 3, "formGroup", 4, "ngIf"], [1, "form-group", "w-fit-content", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], ["formControlName", "input", 3, "name", "ngClass", "ngStyle"], [3, "ngValue"], [3, "ngValue", 4, "ngFor", "ngForOf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"]], template: function PicklistFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PicklistFieldComponent_div_0_Template, 8, 19, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i1.NgStyle, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, IsHexColorLightPipe], styles: [".max-width-200[_ngcontent-%COMP%]{width:100%;max-width:200px}.picklist-search[_ngcontent-%COMP%]{width:90%;margin:10px 5% 0}.picklist[_ngcontent-%COMP%]{cursor:pointer;border-radius:4px}.picklist.colored[_ngcontent-%COMP%]{color:#ffffffb3;text-align:center}.picklist[_ngcontent-%COMP%]:focus{box-shadow:none}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-picklist', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group w-fit-content\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n        <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <select [name]=\"'picklist-' + field.picklistName\"\n    [ngClass]=\"{'form-select-lg': fieldOptions.size === 'large', 'form-select-xs': fieldOptions.size === 'small', 'colored': !!fieldGroup.value.input?.color}\"\n    class=\"form-select picklist {{fieldClass}}\" formControlName=\"input\" #inputField [ngStyle]=\"{\n      'background': fieldGroup.value.input?.color ? fieldGroup.value.input?.color : '',\n      'color': (value?.color) && (value?.color | isHexColorLight) ? 'rgba(0, 0, 0, 0.8)' : value?.color ? 'rgba(255, 255, 255, 0.8)' : (!value?.color && currentTheme === 'light') ? 'rgba(0, 0, 0, 0.8)' : 'rgba(255, 255, 255, 0.8)'\n    }\">\n    <option [ngValue]=\"null\">Select</option>\n    <option *ngFor=\"let option of picklistItems\" [ngValue]=\"option.uuid\">{{ option.itemValue }}</option>\n  </select>\n</div>\n", styles: [".max-width-200{width:100%;max-width:200px}.picklist-search{width:90%;margin:10px 5% 0}.picklist{cursor:pointer;border-radius:4px}.picklist.colored{color:#ffffffb3;text-align:center}.picklist:focus{box-shadow:none}\n"] }]
    }], () => [{ type: PicklistService }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: ThemeService }], { field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PicklistFieldComponent, { className: "PicklistFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/picklist/picklist-field.component.ts", lineNumber: 22 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$o = (a0, a1) => ({ "background": a0, "color": a1 });
function PicklistViewComponent_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 3);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
} }
class PicklistViewComponent extends AbstractViewComponent {
    constructor(themeService, _changeDetectorRef, picklistService) {
        super(_changeDetectorRef);
        this.themeService = themeService;
        this._changeDetectorRef = _changeDetectorRef;
        this.picklistService = picklistService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngOnInit() {
        super.ngOnInit();
        if (isString(this.value)) {
            this.picklistService.getPicklistByUUID(this.value).subscribe((value) => {
                this.value = value;
                this._changeDetectorRef.detectChanges();
            });
        }
    }
    static { this.ɵfac = function PicklistViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistViewComponent)(i0.ɵɵdirectiveInject(ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(PicklistService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PicklistViewComponent, selectors: [["xf-picklist-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 5, vars: 12, consts: [[1, "form-group"], ["class", "form-label margin-bottom-4px d-block", 3, "for", 4, "ngIf"], [3, "ngClass", "ngStyle"], [1, "form-label", "margin-bottom-4px", "d-block", 3, "for"]], template: function PicklistViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, PicklistViewComponent_label_1_Template, 2, 2, "label", 1);
            i0.ɵɵelementStart(2, "p", 2);
            i0.ɵɵpipe(3, "isHexColorLight");
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fieldOptions.showLabel);
            i0.ɵɵadvance();
            i0.ɵɵclassMapInterpolate1("d-inline-block font-size-14px lh-1 minw-100px mw-fit-content picklist-view text-center ", ctx.fieldClass, "");
            i0.ɵɵproperty("ngClass", (ctx.value == null ? null : ctx.value.color) ? "content-font" : "")("ngStyle", i0.ɵɵpureFunction2(9, _c0$o, (ctx.value == null ? null : ctx.value.color) ? ctx.value.color : "", (ctx.value == null ? null : ctx.value.color) && i0.ɵɵpipeBind1(3, 7, ctx.value == null ? null : ctx.value.color) ? "rgba(0, 0, 0, 0.8)" : (ctx.value == null ? null : ctx.value.color) ? "rgba(255, 255, 255, 0.8)" : !(ctx.value == null ? null : ctx.value.color) && ctx.currentTheme === "light" ? "rgba(0, 0, 0, 0.8)" : "rgba(255, 255, 255, 0.8)"));
            i0.ɵɵadvance(2);
            i0.ɵɵtextInterpolate(ctx.value ? ctx.value.itemValue : "--");
        } }, dependencies: [i1.NgClass, i1.NgIf, i1.NgStyle, IsHexColorLightPipe], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-picklist-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px d-block\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n  </label>\n  <p class=\"d-inline-block font-size-14px lh-1 minw-100px mw-fit-content picklist-view text-center {{fieldClass}}\"\n    [ngClass]=\"value?.color ? 'content-font' : ''\" [ngStyle]=\"{\n    'background': value?.color ? value.color : '',\n    'color': (value?.color) && (value?.color | isHexColorLight) ? 'rgba(0, 0, 0, 0.8)' : value?.color ? 'rgba(255, 255, 255, 0.8)' : (!value?.color && currentTheme === 'light') ? 'rgba(0, 0, 0, 0.8)' : 'rgba(255, 255, 255, 0.8)'\n  }\">{{ value ? value.itemValue : '--' }}</p>\n</div>\n" }]
    }], () => [{ type: ThemeService }, { type: i0.ChangeDetectorRef }, { type: PicklistService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PicklistViewComponent, { className: "PicklistViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/picklist/picklist-view.component.ts", lineNumber: 19 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class PicklistField extends Field {
    static { this.operators = [...Field.equalOperators,
        ...Field.listOperators,
        ...Field.nullOperator]; }
    constructor(name, formType) {
        super(name, formType ? formType : Field.BuiltInType.PICKLIST);
        this._picklistName = '';
        this.displayConditions = {};
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = PicklistFieldComponent;
        this.viewComponent = PicklistViewComponent;
        this.alwaysEditMode = true;
    }
    set dataSource(value) {
        super.dataSource = value;
        this.model = value.model;
        this._picklistName = value.query.filters[0].value;
    }
    get picklistName() {
        return this._picklistName;
    }
    set picklistName(value) {
        this._picklistName = value;
        if (this._dataSource) {
            this._dataSource.query = {
                filters: [{
                        field: 'listName.name',
                        operator: 'eq',
                        value: value
                    }]
            };
        }
    }
    getFlatValue(value) {
        if (isObject(value)) {
            value = value['@id'];
        }
        else {
            value = value;
        }
        return value;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class MultiselectPicklistField extends PicklistField {
    constructor(name) {
        super(name, Field.BuiltInType.MULTISELECT_PICKLIST);
    }
    getFlatValue(value) {
        let newValues = [];
        value.forEach((val) => {
            if (isObject(val)) {
                newValues.push(val['@id']);
            }
            else {
                newValues.push(val);
            }
        });
        return newValues;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class OneToManyField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.ONE_TO_MANY);
        this.allowJinjaToggle = false;
        this.isFormField = false;
        this.isRelationship = true;
    }
    set dataSource(value) {
        super.dataSource = value;
        this.model = value.model;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class TextField extends Field {
    static { this.operators = [...Field.equalOperators,
        ...[
            new Operator('like', 'Contains', InputFieldComponent, TextField.evaluateLike),
            new Operator('notlike', 'Does Not Contain', InputFieldComponent, TextField.evaluateNotLike),
            new Operator('like_pattern', 'Matches Pattern', InputFieldComponent, TextField.evaluateLikePattern, 'like'),
            new Operator('notlike_pattern', 'Does Not Match Pattern', InputFieldComponent, TextField.evaluateNotLikePattern, 'notlike'),
        ],
        ...Field.listOperators,
        ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.TEXT);
        this.alwaysJinja = true;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    getFlatValue(value, operator) {
        return operator?.id === 'like' || operator?.id === 'notlike' ? `%${value}%` : value;
    }
    getViewValue(value) {
        return value;
    }
    static evaluateLike(field, value) {
        return true;
    }
    static evaluateNotLike(field, value) {
        return false;
    }
    static evaluateLikePattern(field, value) {
        return false;
    }
    static evaluateNotLikePattern(field, value) {
        return false;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: 255
        };
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class FileField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.FILE);
        this.allowJinjaToggle = false;
        this.isFormField = true;
        this.isRelationship = false;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function JsonEditorFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 10);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function JsonEditorFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵelement(1, "i", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function JsonEditorFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 7);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, JsonEditorFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 8)(3, JsonEditorFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 9);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function JsonEditorFieldComponent_div_0_p_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "p", 13);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.subtitle);
} }
function JsonEditorFieldComponent_div_0_div_4_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 16);
    i0.ɵɵlistener("click", function JsonEditorFieldComponent_div_0_div_4_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function JsonEditorFieldComponent_div_0_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, JsonEditorFieldComponent_div_0_div_4_button_1_Template, 2, 3, "button", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function JsonEditorFieldComponent_div_0_xf_form_messages_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 17);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input)("customErrorMessages", ctx_r0.fieldOptions.customErrorMessages);
} }
function JsonEditorFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, JsonEditorFieldComponent_div_0_label_1_Template, 4, 4, "label", 2)(2, JsonEditorFieldComponent_div_0_p_2_Template, 2, 1, "p", 3);
    i0.ɵɵelement(3, "json-editor", 4);
    i0.ɵɵtemplate(4, JsonEditorFieldComponent_div_0_div_4_Template, 2, 1, "div", 5)(5, JsonEditorFieldComponent_div_0_xf_form_messages_5_Template, 1, 2, "xf-form-messages", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.subtitle);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("json-editor-wrapper ", ctx_r0.fieldClass, "");
    i0.ɵɵproperty("id", "input-" + ctx_r0.field.name)("options", ctx_r0.editorOptions)("data", ctx_r0.field.data);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
} }
class JsonEditorFieldComponent extends AbstractFieldComponent {
    constructor(changeDetectorRef, formBuilder) {
        super(changeDetectorRef, formBuilder);
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.modes = [];
        this.data = {};
        this.editorOptions = new JsonEditorOptions();
        this.editor = new JsonEditorComponent();
    }
    ngOnInit() {
        super.ngOnInit();
        if (this.field.editorOptions) {
            this.editorOptions = this.field.editorOptions;
        }
        this.editorOptions.onChangeText = () => {
            let text = this.editor.getText();
            if (text === '') {
                this.value = text;
            }
        };
        this.editorOptions.modes = this.field.modes || ['code', 'text', 'tree', 'view']; // set all allowed modes  
        if (this.field.modes || this.modes.length > 0) {
            this.editorOptions.mode = this.field.modes ? this.field.modes[0] : this.modes[0]; //set default mode
        }
    }
    ngAfterViewInit() {
        this.fieldGroup?.valueChanges
            .pipe(map$1(values => values.input))
            .subscribe((value) => {
            this.value = value;
        });
    }
    static { this.ɵfac = function JsonEditorFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || JsonEditorFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: JsonEditorFieldComponent, selectors: [["xf-json-editor-field"]], viewQuery: function JsonEditorFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(JsonEditorComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.editor = _t.first);
        } }, inputs: { field: "field", modes: "modes", data: "data" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], ["class", "font-size-10px muted-30 font-italic", 4, "ngIf"], ["formControlName", "input", 3, "id", "options", "data"], ["class", "w-auto padding-left-6px", 4, "ngIf"], [3, "control", "customErrorMessages", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [1, "font-size-10px", "muted-30", "font-italic"], [1, "w-auto", "padding-left-6px"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"], [3, "control", "customErrorMessages"]], template: function JsonEditorFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, JsonEditorFieldComponent_div_0_Template, 6, 11, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, i4$1.JsonEditorComponent, FormMessagesComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(JsonEditorFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-json-editor-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <p *ngIf=\"field.subtitle\" class=\"font-size-10px muted-30 font-italic\">{{field.subtitle}}</p>\n  <json-editor class=\"json-editor-wrapper {{fieldClass}}\" [id]=\"'input-' + field.name\" [options]=\"editorOptions\"\n    [data]=\"field.data\" formControlName=\"input\"></json-editor>\n  <div class=\"w-auto padding-left-6px\" *ngIf=\"field.allowJinjaToggle\">\n    <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n      *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n      }}</button>\n  </div>\n  <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"\n    [customErrorMessages]=\"fieldOptions.customErrorMessages\"></xf-form-messages>\n</div>" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { field: [{
            type: Input
        }], modes: [{
            type: Input
        }], data: [{
            type: Input
        }], editor: [{
            type: ViewChild,
            args: [JsonEditorComponent, { static: false }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(JsonEditorFieldComponent, { className: "JsonEditorFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/json-editor-field/json-editor-field.component.ts", lineNumber: 18 }); })();

class JSONField extends Field {
    static { this.operators = [...Field.equalOperators,
        ...Field.listOperators,
        ...Field.greaterThanLessThanOperators,
        ...Field.listOperators,
        ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.JSON);
        this.data = {};
        this.allowJinjaToggle = false;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = JsonEditorFieldComponent;
        this.viewComponent = JsonEditorFieldComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class PhoneField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.PHONE);
        this.allowJinjaToggle = false;
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^\+?[1-9]\d{1,14}$/;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DomainField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.DOMAIN);
        this.isFormField = true;
        this.isRelationship = false;
        this.placeholder = 'Example, www.fortisoar.com';
        this.validation.pattern = /^(?!:\/\/)([a-zA-Z0-9]+\.)?[a-zA-Z0-9][a-zA-Z0-9-]+\.[a-zA-Z]{2,14}?$/i;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$n = a0 => ({ "pe-0": a0 });
const _c1$d = a0 => ({ "is-invalid": a0 });
function TextareaFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 13);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function TextareaFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 14);
    i0.ɵɵelement(1, "i", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function TextareaFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 10);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, TextareaFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 11)(3, TextareaFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "text-area-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function TextareaFieldComponent_div_0_p_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "p", 16);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.subtitle);
} }
function TextareaFieldComponent_div_0_xf_form_messages_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 17);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input)("customErrorMessages", ctx_r0.fieldOptions.customErrorMessages);
} }
function TextareaFieldComponent_div_0_div_9_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 20);
    i0.ɵɵlistener("click", function TextareaFieldComponent_div_0_div_9_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function TextareaFieldComponent_div_0_div_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 18);
    i0.ɵɵtemplate(1, TextareaFieldComponent_div_0_div_9_button_1_Template, 2, 3, "button", 19);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function TextareaFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, TextareaFieldComponent_div_0_label_1_Template, 4, 4, "label", 3)(2, TextareaFieldComponent_div_0_p_2_Template, 2, 1, "p", 4);
    i0.ɵɵelementStart(3, "div", 5)(4, "div", 6)(5, "textarea", 7, 0);
    i0.ɵɵtext(7, "      ");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(8, TextareaFieldComponent_div_0_xf_form_messages_8_Template, 1, 2, "xf-form-messages", 8);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(9, TextareaFieldComponent_div_0_div_9_Template, 2, 1, "div", 9);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.subtitle);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(13, _c0$n, ctx_r0.field.allowJinjaToggle));
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("form-control ", ctx_r0.fieldClass, "");
    i0.ɵɵpropertyInterpolate("cols", (ctx_r0.field.params == null ? null : ctx_r0.field.params.cols) || 50);
    i0.ɵɵpropertyInterpolate("rows", (ctx_r0.field.params == null ? null : ctx_r0.field.params.rows) || 1);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(15, _c1$d, ctx_r0.fieldGroup.controls.input.invalid && ctx_r0.fieldGroup.controls.input.touched))("placeholder", ctx_r0.field.placeholder || "");
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError && ctx_r0.fieldGroup.controls.input);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
class TextareaFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, themeService, _formBuilder) {
        super(_changeDetectorRef, _formBuilder);
        this._changeDetectorRef = _changeDetectorRef;
        this.themeService = themeService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((value) => {
            this.value = value;
        });
    }
    static { this.ɵfac = function TextareaFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TextareaFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(ThemeService), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TextareaFieldComponent, selectors: [["xf-text-area-field"]], inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }]), i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["inputField", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label", 3, "for", 4, "ngIf"], ["class", "font-size-10px muted-30 font-italic", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], ["formControlName", "input", 3, "ngClass", "placeholder", "cols", "rows"], [3, "control", "customErrorMessages", 4, "ngIf"], ["class", "w-auto ps-2", 4, "ngIf"], [1, "form-label", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [1, "font-size-10px", "muted-30", "font-italic"], [3, "control", "customErrorMessages"], [1, "w-auto", "ps-2"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"]], template: function TextareaFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, TextareaFieldComponent_div_0_Template, 10, 17, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.DefaultValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, FormMessagesComponent], styles: ["textarea[_ngcontent-%COMP%]{field-sizing:content}textarea.form-control-sm[_ngcontent-%COMP%]{min-height:110px}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextareaFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-text-area-field', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'text-area-' + field.name\" class=\"form-label\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <p *ngIf=\"field.subtitle\" class=\"font-size-10px muted-30 font-italic\">{{field.subtitle}}</p>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <textarea formControlName=\"input\" [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid && fieldGroup.controls.input.touched }\"\n        [placeholder]=\"field.placeholder || ''\" cols=\"{{field.params?.cols || 50}}\" rows=\"{{field.params?.rows || 1}}\"\n        #inputField class=\"form-control {{fieldClass}}\">\n      </textarea>\n      <xf-form-messages *ngIf=\"fieldOptions.showError && fieldGroup.controls.input\" [control]=\"fieldGroup.controls.input\"\n        [customErrorMessages]=\"fieldOptions.customErrorMessages\"></xf-form-messages>\n    </div>\n    <div class=\"w-auto ps-2\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n</div>\n", styles: ["textarea{field-sizing:content}textarea.form-control-sm{min-height:110px}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: ThemeService }, { type: i2.FormBuilder }], { field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TextareaFieldComponent, { className: "TextareaFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/textarea/textarea-field.component.ts", lineNumber: 28 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class FilehashField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.FILEHASH);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^[a-zA-Z0-9]*$/;
        this.fieldComponent = TextareaFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class IPv4Field extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.IPv4);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class IPv6Field extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.IPv6);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^(::|(([a-fA-F0-9]{1,4}):){7}(([a-fA-F0-9]{1,4}))|(:(:([a-fA-F0-9]{1,4})){1,6})|((([a-fA-F0-9]{1,4}):){1,6}:)|((([a-fA-F0-9]{1,4}):)(:([a-fA-F0-9]{1,4})){1,6})|((([a-fA-F0-9]{1,4}):){2}(:([a-fA-F0-9]{1,4})){1,5})|((([a-fA-F0-9]{1,4}):){3}(:([a-fA-F0-9]{1,4})){1,4})|((([a-fA-F0-9]{1,4}):){4}(:([a-fA-F0-9]{1,4})){1,3})|((([a-fA-F0-9]{1,4}):){5}(:([a-fA-F0-9]{1,4})){1,2}))$/i;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class HtmlEditorService {
    constructor(platformLocation, themeService) {
        this.platformLocation = platformLocation;
        this.themeService = themeService;
    }
    getDefaultConfig(toolbarSelector, theme) {
        return {
            debounce: true,
            inline: true,
            toolbar_mode: 'wrap',
            fixed_toolbar_container: toolbarSelector,
            browser_spellcheck: true,
            plugins: 'advlist lists code image link  media table fullscreen',
            height: 350,
            max_height: 600,
            menubar: false,
            toolbar: 'bold italic underline strikethrough superscript | blocks | removeformat | fontsize | forecolor backcolor | table bullist numlist | link image media | alignleft aligncenter alignright alignjustify | code fullscreen | dynamicValueButton',
            paste_data_images: true,
            extended_valid_elements: 'svg[*],defs[*],pattern[*],desc[*],metadata[*],g[*],mask[*],path[*],line[*],marker[*],rect[*],circle[*],ellipse[*],polygon[*],polyline[*],linearGradient[*],radialGradient[*],stop[*],image[*],view[*],text[*],textPath[*],title[*],tspan[*],glyph[*],symbol[*],switch[*],use[*]',
            autocompleteEnterKeyEvent: false,
            skin: false,
            base_url: `${this.platformLocation.getBaseHrefFromDOM()}tinymce/`,
        };
    }
    getBasicConfig(toolbarSelector, theme) {
        return {
            debounce: true,
            inline: true,
            toolbar_mode: 'wrap',
            fixed_toolbar_container: toolbarSelector,
            browser_spellcheck: true,
            allow_script_urls: true,
            plugins: 'advlist lists code fullscreen table',
            height: 350,
            max_height: 600,
            menubar: false,
            toolbar: 'bold italic underline strikethrough table code fullscreen',
            toolbar_items_size: 'small',
            paste_data_images: true,
            autocompleteEnterKeyEvent: false,
            skin: false,
            base_url: `${this.platformLocation.getBaseHrefFromDOM()}tinymce/`,
        };
    }
    static { this.ɵfac = function HtmlEditorService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || HtmlEditorService)(i0.ɵɵinject(i1.PlatformLocation), i0.ɵɵinject(ThemeService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: HtmlEditorService, factory: HtmlEditorService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(HtmlEditorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.PlatformLocation }, { type: ThemeService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
/**
 * Copyright (c) 2017-present, Ephox, Inc.
 *
 * This source code is licensed under the Apache 2 license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
const getTinymce = () => {
    const w = typeof window !== 'undefined' ? window : undefined;
    return w && w.tinymce ? w.tinymce : null;
};

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
/*
MIT License

Copyright (c) 2022 Ephox Corporation DBA Tiny Technologies, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
class Events {
    constructor() {
        this.onBeforePaste = new EventEmitter();
        this.onBlur = new EventEmitter();
        this.onClick = new EventEmitter();
        this.onCompositionEnd = new EventEmitter();
        this.onCompositionStart = new EventEmitter();
        this.onCompositionUpdate = new EventEmitter();
        this.onContextMenu = new EventEmitter();
        this.onCopy = new EventEmitter();
        this.onCut = new EventEmitter();
        this.onDblclick = new EventEmitter();
        this.onDrag = new EventEmitter();
        this.onDragDrop = new EventEmitter();
        this.onDragEnd = new EventEmitter();
        this.onDragGesture = new EventEmitter();
        this.onDragOver = new EventEmitter();
        this.onDrop = new EventEmitter();
        this.onFocus = new EventEmitter();
        this.onFocusIn = new EventEmitter();
        this.onFocusOut = new EventEmitter();
        this.onKeyDown = new EventEmitter();
        this.onKeyPress = new EventEmitter();
        this.onKeyUp = new EventEmitter();
        this.onMouseDown = new EventEmitter();
        this.onMouseEnter = new EventEmitter();
        this.onMouseLeave = new EventEmitter();
        this.onMouseMove = new EventEmitter();
        this.onMouseOut = new EventEmitter();
        this.onMouseOver = new EventEmitter();
        this.onMouseUp = new EventEmitter();
        this.onPaste = new EventEmitter();
        this.onSelectionChange = new EventEmitter();
        this.onActivate = new EventEmitter();
        this.onAddUndo = new EventEmitter();
        this.onBeforeAddUndo = new EventEmitter();
        this.onBeforeExecCommand = new EventEmitter();
        this.onBeforeGetContent = new EventEmitter();
        this.onBeforeRenderUI = new EventEmitter();
        this.onBeforeSetContent = new EventEmitter();
        this.onChange = new EventEmitter();
        this.onClearUndos = new EventEmitter();
        this.onDeactivate = new EventEmitter();
        this.onDirty = new EventEmitter();
        this.onExecCommand = new EventEmitter();
        this.onGetContent = new EventEmitter();
        this.onHide = new EventEmitter();
        this.onInit = new EventEmitter();
        this.onInput = new EventEmitter();
        this.onInitNgModel = new EventEmitter();
        this.onLoadContent = new EventEmitter();
        this.onNodeChange = new EventEmitter();
        this.onPostProcess = new EventEmitter();
        this.onPostRender = new EventEmitter();
        this.onPreInit = new EventEmitter();
        this.onPreProcess = new EventEmitter();
        this.onProgressState = new EventEmitter();
        this.onRedo = new EventEmitter();
        this.onRemove = new EventEmitter();
        this.onReset = new EventEmitter();
        this.onResizeEditor = new EventEmitter();
        this.onSaveContent = new EventEmitter();
        this.onSetAttrib = new EventEmitter();
        this.onObjectResizeStart = new EventEmitter();
        this.onObjectResized = new EventEmitter();
        this.onObjectSelected = new EventEmitter();
        this.onSetContent = new EventEmitter();
        this.onShow = new EventEmitter();
        this.onSubmit = new EventEmitter();
        this.onUndo = new EventEmitter();
        this.onVisualAid = new EventEmitter();
    }
    static { this.ɵfac = function Events_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || Events)(); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: Events, outputs: { onBeforePaste: "onBeforePaste", onBlur: "onBlur", onClick: "onClick", onCompositionEnd: "onCompositionEnd", onCompositionStart: "onCompositionStart", onCompositionUpdate: "onCompositionUpdate", onContextMenu: "onContextMenu", onCopy: "onCopy", onCut: "onCut", onDblclick: "onDblclick", onDrag: "onDrag", onDragDrop: "onDragDrop", onDragEnd: "onDragEnd", onDragGesture: "onDragGesture", onDragOver: "onDragOver", onDrop: "onDrop", onFocus: "onFocus", onFocusIn: "onFocusIn", onFocusOut: "onFocusOut", onKeyDown: "onKeyDown", onKeyPress: "onKeyPress", onKeyUp: "onKeyUp", onMouseDown: "onMouseDown", onMouseEnter: "onMouseEnter", onMouseLeave: "onMouseLeave", onMouseMove: "onMouseMove", onMouseOut: "onMouseOut", onMouseOver: "onMouseOver", onMouseUp: "onMouseUp", onPaste: "onPaste", onSelectionChange: "onSelectionChange", onActivate: "onActivate", onAddUndo: "onAddUndo", onBeforeAddUndo: "onBeforeAddUndo", onBeforeExecCommand: "onBeforeExecCommand", onBeforeGetContent: "onBeforeGetContent", onBeforeRenderUI: "onBeforeRenderUI", onBeforeSetContent: "onBeforeSetContent", onChange: "onChange", onClearUndos: "onClearUndos", onDeactivate: "onDeactivate", onDirty: "onDirty", onExecCommand: "onExecCommand", onGetContent: "onGetContent", onHide: "onHide", onInit: "onInit", onInput: "onInput", onInitNgModel: "onInitNgModel", onLoadContent: "onLoadContent", onNodeChange: "onNodeChange", onPostProcess: "onPostProcess", onPostRender: "onPostRender", onPreInit: "onPreInit", onPreProcess: "onPreProcess", onProgressState: "onProgressState", onRedo: "onRedo", onRemove: "onRemove", onReset: "onReset", onResizeEditor: "onResizeEditor", onSaveContent: "onSaveContent", onSetAttrib: "onSetAttrib", onObjectResizeStart: "onObjectResizeStart", onObjectResized: "onObjectResized", onObjectSelected: "onObjectSelected", onSetContent: "onSetContent", onShow: "onShow", onSubmit: "onSubmit", onUndo: "onUndo", onVisualAid: "onVisualAid" } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(Events, [{
        type: Directive
    }], null, { onBeforePaste: [{
            type: Output
        }], onBlur: [{
            type: Output
        }], onClick: [{
            type: Output
        }], onCompositionEnd: [{
            type: Output
        }], onCompositionStart: [{
            type: Output
        }], onCompositionUpdate: [{
            type: Output
        }], onContextMenu: [{
            type: Output
        }], onCopy: [{
            type: Output
        }], onCut: [{
            type: Output
        }], onDblclick: [{
            type: Output
        }], onDrag: [{
            type: Output
        }], onDragDrop: [{
            type: Output
        }], onDragEnd: [{
            type: Output
        }], onDragGesture: [{
            type: Output
        }], onDragOver: [{
            type: Output
        }], onDrop: [{
            type: Output
        }], onFocus: [{
            type: Output
        }], onFocusIn: [{
            type: Output
        }], onFocusOut: [{
            type: Output
        }], onKeyDown: [{
            type: Output
        }], onKeyPress: [{
            type: Output
        }], onKeyUp: [{
            type: Output
        }], onMouseDown: [{
            type: Output
        }], onMouseEnter: [{
            type: Output
        }], onMouseLeave: [{
            type: Output
        }], onMouseMove: [{
            type: Output
        }], onMouseOut: [{
            type: Output
        }], onMouseOver: [{
            type: Output
        }], onMouseUp: [{
            type: Output
        }], onPaste: [{
            type: Output
        }], onSelectionChange: [{
            type: Output
        }], onActivate: [{
            type: Output
        }], onAddUndo: [{
            type: Output
        }], onBeforeAddUndo: [{
            type: Output
        }], onBeforeExecCommand: [{
            type: Output
        }], onBeforeGetContent: [{
            type: Output
        }], onBeforeRenderUI: [{
            type: Output
        }], onBeforeSetContent: [{
            type: Output
        }], onChange: [{
            type: Output
        }], onClearUndos: [{
            type: Output
        }], onDeactivate: [{
            type: Output
        }], onDirty: [{
            type: Output
        }], onExecCommand: [{
            type: Output
        }], onGetContent: [{
            type: Output
        }], onHide: [{
            type: Output
        }], onInit: [{
            type: Output
        }], onInput: [{
            type: Output
        }], onInitNgModel: [{
            type: Output
        }], onLoadContent: [{
            type: Output
        }], onNodeChange: [{
            type: Output
        }], onPostProcess: [{
            type: Output
        }], onPostRender: [{
            type: Output
        }], onPreInit: [{
            type: Output
        }], onPreProcess: [{
            type: Output
        }], onProgressState: [{
            type: Output
        }], onRedo: [{
            type: Output
        }], onRemove: [{
            type: Output
        }], onReset: [{
            type: Output
        }], onResizeEditor: [{
            type: Output
        }], onSaveContent: [{
            type: Output
        }], onSetAttrib: [{
            type: Output
        }], onObjectResizeStart: [{
            type: Output
        }], onObjectResized: [{
            type: Output
        }], onObjectSelected: [{
            type: Output
        }], onSetContent: [{
            type: Output
        }], onShow: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], onUndo: [{
            type: Output
        }], onVisualAid: [{
            type: Output
        }] }); })();
const validEvents = [
    'onActivate',
    'onAddUndo',
    'onBeforeAddUndo',
    'onBeforeExecCommand',
    'onBeforeGetContent',
    'onBeforeRenderUI',
    'onBeforeSetContent',
    'onBeforePaste',
    'onBlur',
    'onChange',
    'onClearUndos',
    'onClick',
    'onCompositionEnd',
    'onCompositionStart',
    'onCompositionUpdate',
    'onContextMenu',
    'onCopy',
    'onCut',
    'onDblclick',
    'onDeactivate',
    'onDirty',
    'onDrag',
    'onDragDrop',
    'onDragEnd',
    'onDragGesture',
    'onDragOver',
    'onDrop',
    'onExecCommand',
    'onFocus',
    'onFocusIn',
    'onFocusOut',
    'onGetContent',
    'onHide',
    'onInit',
    'onInput',
    'onKeyDown',
    'onKeyPress',
    'onKeyUp',
    'onLoadContent',
    'onMouseDown',
    'onMouseEnter',
    'onMouseLeave',
    'onMouseMove',
    'onMouseOut',
    'onMouseOver',
    'onMouseUp',
    'onNodeChange',
    'onObjectResizeStart',
    'onObjectResized',
    'onObjectSelected',
    'onPaste',
    'onPostProcess',
    'onPostRender',
    'onPreProcess',
    'onProgressState',
    'onRedo',
    'onRemove',
    'onReset',
    'onResizeEditor',
    'onSaveContent',
    'onSelectionChange',
    'onSetAttrib',
    'onSetContent',
    'onShow',
    'onSubmit',
    'onUndo',
    'onVisualAid'
];

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
/**
 * Copyright (c) 2017-present, Ephox, Inc.
 *
 * This source code is licensed under the Apache 2 license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
// Caretaker note: `fromEvent` supports passing JQuery-style event targets, the editor has `on` and `off` methods which
// will be invoked upon subscription and teardown.
const listenTinyMCEEvent = (editor, eventName, destroy$) => fromEvent(editor, eventName).pipe(takeUntil(destroy$));
const bindHandlers = (ctx, editor, destroy$) => {
    const allowedEvents = getValidEvents(ctx);
    allowedEvents.forEach((eventName) => {
        const eventEmitter = ctx[eventName];
        listenTinyMCEEvent(editor, eventName.substring(2), destroy$).subscribe((event) => {
            // Caretaker note: `ngZone.run()` runs change detection since it notifies the forked Angular zone that it's
            // being re-entered. We don't want to run `ApplicationRef.tick()` if anyone listens to the specific event
            // within the template. E.g. if the `onSelectionChange` is not listened within the template like:
            // `<editor (onSelectionChange)="..."></editor>`
            // then it won't be "observed", and we won't run "dead" change detection.
            if (isObserved(eventEmitter)) {
                ctx.ngZone.run(() => eventEmitter.emit({ event, editor }));
            }
        });
    });
};
const getValidEvents = (ctx) => {
    const ignoredEvents = parseStringProperty(ctx.ignoreEvents, []);
    const allowedEvents = parseStringProperty(ctx.allowedEvents, validEvents).filter((event) => validEvents.includes(event) && !ignoredEvents.includes(event));
    return allowedEvents;
};
const parseStringProperty = (property, defaultValue) => {
    if (typeof property === 'string') {
        return property.split(',').map((value) => value.trim());
    }
    if (Array.isArray(property)) {
        return property;
    }
    return defaultValue;
};
let unique = 0;
const uuid = (prefix) => {
    const date = new Date();
    const time = date.getTime();
    const random = Math.floor(Math.random() * 1000000000);
    unique++;
    return prefix + '_' + random + unique + String(time);
};
const isTextarea = (element) => typeof element !== 'undefined' && element.tagName.toLowerCase() === 'textarea';
const normalizePluginArray = (plugins) => {
    if (typeof plugins === 'undefined' || plugins === '') {
        return [];
    }
    return Array.isArray(plugins) ? plugins : plugins.split(' ');
};
const mergePlugins = (initPlugins, inputPlugins) => normalizePluginArray(initPlugins).concat(normalizePluginArray(inputPlugins));
// eslint-disable-next-line @typescript-eslint/no-empty-function
const noop = () => { };
const isNullOrUndefined = (value) => value === null || value === undefined;
const isObserved = (o) => 
// RXJS is making the `observers` property internal in v8. So this is intended as a backwards compatible way of
// checking if a subject has observers.
o.observed || o.observers?.length > 0;

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
/*
MIT License

Copyright (c) 2022 Ephox Corporation DBA Tiny Technologies, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
/* eslint-disable @typescript-eslint/no-parameter-properties */
const TINYMCE_SCRIPT_SRC = new InjectionToken('TINYMCE_SCRIPT_SRC');
const EDITOR_COMPONENT_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => EditorComponent),
    multi: true
};
/**
 * @see {@link https://www.tiny.cloud/docs/tinymce/7/angular-ref/} for the TinyMCE Angular Technical Reference
 */
class EditorComponent extends Events {
    set disabled(val) {
        this._disabled = val;
        if (this._editor && this._editor.initialized) {
            if (typeof this._editor.mode?.set === 'function') {
                this._editor.mode.set(val ? 'readonly' : 'design');
            }
            else {
                // this._editor.setMode(val ? 'readonly' : 'design');
            }
        }
    }
    get disabled() {
        return this._disabled;
    }
    get editor() {
        return this._editor;
    }
    constructor(elementRef, ngZone, cdRef, platformId, tinymceScriptSrc) {
        super();
        this.cdRef = cdRef;
        this.platformId = platformId;
        this.tinymceScriptSrc = tinymceScriptSrc;
        this.cloudChannel = '7';
        this.apiKey = 'no-api-key';
        this.id = '';
        this.modelEvents = 'change input undo redo';
        this.onTouchedCallback = noop;
        this.destroy$ = new Subject();
        this.initialise = () => {
            const finalInit = {
                selector: undefined,
                target: this._element,
                inline: this.inline,
                readonly: this.disabled,
                license_key: 'gpl',
                plugins: mergePlugins((this.init && this.init.plugins), this.plugins),
                toolbar: this.toolbar || (this.init && this.init.toolbar),
                setup: (editor) => {
                    this._editor = editor;
                    listenTinyMCEEvent(editor, 'init', this.destroy$).subscribe(() => {
                        this.initEditor(editor);
                    });
                    bindHandlers(this, editor, this.destroy$);
                    if (this.init && typeof this.init.setup === 'function') {
                        this.init.setup(editor);
                    }
                },
                ...this.init,
            };
            if (isTextarea(this._element)) {
                this._element.style.visibility = '';
            }
            this.ngZone.runOutsideAngular(() => {
                getTinymce().init(finalInit);
            });
        };
        this._elementRef = elementRef;
        this.ngZone = ngZone;
    }
    writeValue(value) {
        if (this._editor && this._editor.initialized) {
            this._editor.setContent(isNullOrUndefined(value) ? '' : value);
        }
        else {
            this.initialValue = value === null ? undefined : value;
        }
    }
    registerOnChange(fn) {
        this.onChangeCallback = fn;
    }
    registerOnTouched(fn) {
        this.onTouchedCallback = fn;
    }
    setDisabledState(isDisabled) {
        this.disabled = isDisabled;
    }
    ngAfterViewInit() {
        if (isPlatformBrowser(this.platformId)) {
            this.id = this.id || uuid('tiny-angular');
            this.inline = this.inline !== undefined ? this.inline !== false : !!(this.init?.inline);
            this.createElement();
            if (getTinymce() !== null) {
                this.initialise();
            }
        }
    }
    ngOnDestroy() {
        this.destroy$.next();
        if (getTinymce() !== null) {
            getTinymce().remove(this._editor);
        }
    }
    createElement() {
        const tagName = typeof this.tagName === 'string' ? this.tagName : 'div';
        this._element = document.createElement(this.inline ? tagName : 'textarea');
        if (this._element) {
            const existingElement = document.getElementById(this.id);
            if (existingElement && existingElement !== this._elementRef.nativeElement) {
                /* eslint no-console: ["error", { allow: ["warn"] }] */
                console.warn(`TinyMCE-Angular: an element with id [${this.id}] already exists. Editors with duplicate Id will not be able to mount`);
            }
            this._element.id = this.id;
            if (isTextarea(this._element)) {
                this._element.style.visibility = 'hidden';
            }
            this._elementRef.nativeElement.appendChild(this._element);
        }
    }
    initEditor(editor) {
        listenTinyMCEEvent(editor, 'blur', this.destroy$).subscribe(() => {
            this.cdRef.markForCheck();
            this.ngZone.run(() => this.onTouchedCallback());
        });
        listenTinyMCEEvent(editor, this.modelEvents, this.destroy$).subscribe(() => {
            this.cdRef.markForCheck();
            this.ngZone.run(() => this.emitOnChange(editor));
        });
        if (typeof this.initialValue === 'string') {
            this.ngZone.run(() => {
                editor.setContent(this.initialValue);
                if (editor.getContent() !== this.initialValue) {
                    this.emitOnChange(editor);
                }
                if (this.onInitNgModel !== undefined) {
                    this.onInitNgModel.emit(editor);
                }
            });
        }
    }
    emitOnChange(editor) {
        if (this.onChangeCallback) {
            this.onChangeCallback(editor.getContent({ format: this.outputFormat }));
        }
    }
    static { this.ɵfac = function EditorComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditorComponent)(i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.NgZone), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(PLATFORM_ID), i0.ɵɵdirectiveInject(TINYMCE_SCRIPT_SRC, 8)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EditorComponent, selectors: [["editor"]], inputs: { cloudChannel: "cloudChannel", apiKey: "apiKey", licenseKey: "licenseKey", init: "init", id: "id", initialValue: "initialValue", outputFormat: "outputFormat", inline: "inline", tagName: "tagName", plugins: "plugins", toolbar: "toolbar", modelEvents: "modelEvents", allowedEvents: "allowedEvents", ignoreEvents: "ignoreEvents", disabled: "disabled" }, standalone: true, features: [i0.ɵɵProvidersFeature([EDITOR_COMPONENT_VALUE_ACCESSOR]), i0.ɵɵInheritDefinitionFeature, i0.ɵɵStandaloneFeature], decls: 0, vars: 0, template: function EditorComponent_Template(rf, ctx) { }, dependencies: [CommonModule, FormsModule], styles: ["[_nghost-%COMP%]{display:block}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditorComponent, [{
        type: Component,
        args: [{ selector: 'editor', template: '', providers: [EDITOR_COMPONENT_VALUE_ACCESSOR], standalone: true, imports: [CommonModule, FormsModule], changeDetection: ChangeDetectionStrategy.OnPush, styles: [":host{display:block}\n"] }]
    }], () => [{ type: i0.ElementRef }, { type: i0.NgZone }, { type: i0.ChangeDetectorRef }, { type: Object, decorators: [{
                type: Inject,
                args: [PLATFORM_ID]
            }] }, { type: undefined, decorators: [{
                type: Optional
            }, {
                type: Inject,
                args: [TINYMCE_SCRIPT_SRC]
            }] }], { cloudChannel: [{
            type: Input
        }], apiKey: [{
            type: Input
        }], licenseKey: [{
            type: Input
        }], init: [{
            type: Input
        }], id: [{
            type: Input
        }], initialValue: [{
            type: Input
        }], outputFormat: [{
            type: Input
        }], inline: [{
            type: Input
        }], tagName: [{
            type: Input
        }], plugins: [{
            type: Input
        }], toolbar: [{
            type: Input
        }], modelEvents: [{
            type: Input
        }], allowedEvents: [{
            type: Input
        }], ignoreEvents: [{
            type: Input
        }], disabled: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(EditorComponent, { className: "EditorComponent", filePath: "lib/form-fields/field-renderers/built-ins/richtext-html/html-editor-module/editor.component.ts", lineNumber: 80 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$m = (a0, a1) => ({ "form-floating": a0, "form-group": a1 });
const _c1$c = a0 => ({ "is-invalid": a0 });
const _c2$7 = a0 => ({ "pe-0": a0 });
function RichtextHTMLFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function RichtextHTMLFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 13);
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r1.field.tooltip);
} }
function RichtextHTMLFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 9);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, RichtextHTMLFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 10)(3, RichtextHTMLFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "toolbar_" + ctx_r1.editorId);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.tooltip);
} }
function RichtextHTMLFieldComponent_div_0_xf_form_messages_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 15);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r1.fieldGroup.controls.input);
} }
function RichtextHTMLFieldComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 18);
    i0.ɵɵlistener("click", function RichtextHTMLFieldComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r1.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function RichtextHTMLFieldComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtemplate(1, RichtextHTMLFieldComponent_div_0_div_7_button_1_Template, 2, 3, "button", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.allowJinjaToggle);
} }
function RichtextHTMLFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, RichtextHTMLFieldComponent_div_0_label_1_Template, 4, 4, "label", 2);
    i0.ɵɵelementStart(2, "div", 3)(3, "div", 4);
    i0.ɵɵelement(4, "div", 5);
    i0.ɵɵelementStart(5, "editor", 6);
    i0.ɵɵlistener("onInit", function RichtextHTMLFieldComponent_div_0_Template_editor_onInit_5_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.focusEditor($event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, RichtextHTMLFieldComponent_div_0_xf_form_messages_6_Template, 1, 1, "xf-form-messages", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, RichtextHTMLFieldComponent_div_0_div_7_Template, 2, 1, "div", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(13, _c0$m, ctx_r1.fieldOptions.showLabel, !ctx_r1.fieldOptions.showLabel))("ngClass", i0.ɵɵpureFunction1(16, _c1$c, ctx_r1.fieldGroup.controls.input.invalid))("formGroup", ctx_r1.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(18, _c2$7, ctx_r1.field.allowJinjaToggle));
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate("id", "toolbar_" + ctx_r1.editorId);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("margin-top-2px ", ctx_r1.fieldClass, "");
    i0.ɵɵproperty("init", ctx_r1.editorConfig)("required", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.allowJinjaToggle);
} }
class RichtextHTMLFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, htmlEditorService, utilityService, _formBuilder) {
        super(_changeDetectorRef, _formBuilder);
        this.htmlEditorService = htmlEditorService;
        this.utilityService = utilityService;
        this.editorConfig = {};
        this.editorId = '';
    }
    ngOnInit() {
        this.editorId = this.utilityService.generateUUID();
        this.editorConfig = this.field.params?.mode === 'basic' ? this.htmlEditorService.getBasicConfig(`#toolbar_${this.editorId}`, this.field.params?.theme) : this.htmlEditorService.getDefaultConfig(`#toolbar_${this.editorId}`, this.field.params?.theme);
        super.ngOnInit();
    }
    ngAfterViewInit() {
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((value) => {
            this.value = value;
        });
    }
    focusEditor(event) {
        this.editor = event.editor;
        event.editor.fire('focus');
    }
    static { this.ɵfac = function RichtextHTMLFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || RichtextHTMLFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(HtmlEditorService), i0.ɵɵdirectiveInject(UtilityService), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RichtextHTMLFieldComponent, selectors: [["xf-richtext-html-field"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [[3, "ngClass", "formGroup", 4, "ngIf"], [3, "ngClass", "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], [1, "tinymce-toolbar", "full-width", 3, "id"], ["formControlName", "input", 3, "onInit", "init", "required"], [3, "control", 4, "ngIf"], ["class", "w-auto ps-2", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "control"], [1, "w-auto", "ps-2"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"]], template: function RichtextHTMLFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, RichtextHTMLFieldComponent_div_0_Template, 8, 20, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.RequiredValidator, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, EditorComponent, FormMessagesComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RichtextHTMLFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-richtext-html-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div [ngClass]=\"{'form-floating': fieldOptions.showLabel, 'form-group': !fieldOptions.showLabel }\"\n  [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid}\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'toolbar_'+ editorId\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <div id=\"{{'toolbar_'+ editorId}}\" class=\"tinymce-toolbar full-width\"></div>\n      <editor formControlName=\"input\" class=\"margin-top-2px {{fieldClass}}\" [init]=\"editorConfig\"\n        (onInit)=\"focusEditor($event)\" [required]=\"field.validation?.required\">\n      </editor>\n      <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n    </div>\n    <div class=\"w-auto ps-2\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: HtmlEditorService }, { type: UtilityService }, { type: i2.FormBuilder }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(RichtextHTMLFieldComponent, { className: "RichtextHTMLFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/richtext-html/richtext-html-field.component.ts", lineNumber: 18 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class RichtextHTMLViewComponent extends AbstractViewComponent {
    constructor() {
        super(...arguments);
        this.sanitizer = inject(DomSanitizer);
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵRichtextHTMLViewComponent_BaseFactory; return function RichtextHTMLViewComponent_Factory(__ngFactoryType__) { return (ɵRichtextHTMLViewComponent_BaseFactory || (ɵRichtextHTMLViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(RichtextHTMLViewComponent)))(__ngFactoryType__ || RichtextHTMLViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RichtextHTMLViewComponent, selectors: [["xf-richtext-html-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [[1, "mb-0", 3, "innerHtml"]], template: function RichtextHTMLViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelement(0, "p", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("innerHtml", ctx.sanitizer.bypassSecurityTrustHtml(ctx.value) || "--", i0.ɵɵsanitizeHtml);
        } }, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RichtextHTMLViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-richtext-html-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p class=\"mb-0\" [innerHtml]=\"sanitizer.bypassSecurityTrustHtml(value) || '--'\"></p>\n" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(RichtextHTMLViewComponent, { className: "RichtextHTMLViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/richtext-html/richtext-html-view.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class RichtextHTMLField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.RICHTEXTHTML);
        this.allowJinjaToggle = false;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = RichtextHTMLFieldComponent;
        this.viewComponent = RichtextHTMLViewComponent;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: MAX_TEXT_LENGTH
        };
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$l = ["editor"];
const _c1$b = (a0, a1) => ({ "form-floating": a0, "form-group": a1 });
const _c2$6 = a0 => ({ "is-invalid": a0 });
const _c3$3 = a0 => ({ "pe-0": a0 });
function RichtextMarkdownFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function RichtextMarkdownFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵelement(1, "i", 13);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function RichtextMarkdownFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 8);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, RichtextMarkdownFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 9)(3, RichtextMarkdownFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "md-label-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function RichtextMarkdownFieldComponent_div_0_xf_form_messages_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 14);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
function RichtextMarkdownFieldComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 17);
    i0.ɵɵlistener("click", function RichtextMarkdownFieldComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function RichtextMarkdownFieldComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 15);
    i0.ɵɵtemplate(1, RichtextMarkdownFieldComponent_div_0_div_7_button_1_Template, 2, 3, "button", 16);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function RichtextMarkdownFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, RichtextMarkdownFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5);
    i0.ɵɵelement(4, "div", null, 0);
    i0.ɵɵtemplate(6, RichtextMarkdownFieldComponent_div_0_xf_form_messages_6_Template, 1, 1, "xf-form-messages", 6);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, RichtextMarkdownFieldComponent_div_0_div_7_Template, 2, 1, "div", 7);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(7, _c1$b, ctx_r0.fieldOptions.showLabel, !ctx_r0.fieldOptions.showLabel))("ngClass", i0.ɵɵpureFunction1(10, _c2$6, ctx_r0.fieldGroup.controls.input.invalid))("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(12, _c3$3, ctx_r0.field.allowJinjaToggle));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
class RichtextMarkdownFieldComponent extends AbstractFieldComponent {
    ngAfterViewInit() {
        // Initialize ProseMirror view with Markdown schema and plugins
        const state = EditorState.create({
            doc: defaultMarkdownParser.parse(this.value || '') ?? undefined,
            plugins: exampleSetup({ schema }),
        });
        this.view = new EditorView(this.editorElement.nativeElement, {
            state: state,
            dispatchTransaction: (transaction) => {
                const newState = this.view?.state.apply(transaction);
                this.view?.updateState(newState);
                if (transaction.docChanged) {
                    this.handleInputChange();
                }
            }
        });
    }
    handleInputChange() {
        const newContent = defaultMarkdownSerializer.serialize(this.view.state.doc);
        this.fieldGroup?.controls.input.setValue(newContent);
        this.value = newContent;
    }
    ngOnDestroy() {
        // Destroy ProseMirror view on component destruction
        this.view?.destroy();
    }
    // Implement ControlValueAccessor interface methods
    writeValue(value) {
        this.view?.dispatch(this.view.state.tr.replaceWith(0, this.view.state.doc.content.size, schema.node(value)));
        this.value = value;
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵRichtextMarkdownFieldComponent_BaseFactory; return function RichtextMarkdownFieldComponent_Factory(__ngFactoryType__) { return (ɵRichtextMarkdownFieldComponent_BaseFactory || (ɵRichtextMarkdownFieldComponent_BaseFactory = i0.ɵɵgetInheritedFactory(RichtextMarkdownFieldComponent)))(__ngFactoryType__ || RichtextMarkdownFieldComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RichtextMarkdownFieldComponent, selectors: [["xf-richtext-markdown-field"]], viewQuery: function RichtextMarkdownFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$l, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.editorElement = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["editor", ""], [3, "ngClass", "formGroup", 4, "ngIf"], [3, "ngClass", "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], [3, "control", 4, "ngIf"], ["class", "w-auto ps-2", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "control"], [1, "w-auto", "ps-2"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"]], template: function RichtextMarkdownFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, RichtextMarkdownFieldComponent_div_0_Template, 8, 14, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.NgControlStatusGroup, i2.FormGroupDirective, i3.NgbTooltip, FormMessagesComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RichtextMarkdownFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-richtext-markdown-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div [ngClass]=\"{'form-floating': fieldOptions.showLabel, 'form-group': !fieldOptions.showLabel }\"\n  [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid}\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'md-label-'+ field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <div #editor></div>\n      <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n    </div>\n    <div class=\"w-auto ps-2\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n</div>\n\n" }]
    }], null, { editorElement: [{
            type: ViewChild,
            args: ['editor']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(RichtextMarkdownFieldComponent, { className: "RichtextMarkdownFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/richtext-markdown/richtext-markdown-field.component.ts", lineNumber: 18 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$k = ["mdWrapper"];
class RichtextMarkdownViewComponent extends AbstractViewComponent {
    ngOnInit() {
        super.ngOnInit();
        if (this.value) {
            this.parseValueToHTML();
        }
        else {
            this.mdWrapper.nativeElement.innerHTML = '--';
        }
    }
    parseValueToHTML() {
        const doc = defaultMarkdownParser.parse(this.value);
        const serializer = DOMSerializer.fromSchema(schema);
        this.mdWrapper.nativeElement.innerHTML = '';
        serializer.serializeFragment(doc?.content, {}, this.mdWrapper.nativeElement);
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵRichtextMarkdownViewComponent_BaseFactory; return function RichtextMarkdownViewComponent_Factory(__ngFactoryType__) { return (ɵRichtextMarkdownViewComponent_BaseFactory || (ɵRichtextMarkdownViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(RichtextMarkdownViewComponent)))(__ngFactoryType__ || RichtextMarkdownViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RichtextMarkdownViewComponent, selectors: [["xf-richtext-markdown-view"]], viewQuery: function RichtextMarkdownViewComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$k, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.mdWrapper = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 0, consts: [["mdWrapper", ""], [1, "mb-0"]], template: function RichtextMarkdownViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelement(0, "p", 1, 0);
        } }, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RichtextMarkdownViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-richtext-markdown-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p class=\"mb-0\" #mdWrapper></p>\n" }]
    }], null, { mdWrapper: [{
            type: ViewChild,
            args: ['mdWrapper', { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(RichtextMarkdownViewComponent, { className: "RichtextMarkdownViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/richtext-markdown/richtext-markdown-view.component.ts", lineNumber: 17 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class RichtextMarkdownField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.RICHTEXTMARKDOWN);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = RichtextMarkdownFieldComponent;
        this.viewComponent = RichtextMarkdownViewComponent;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: MAX_TEXT_LENGTH
        };
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class TextareaField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.TEXTAREA);
        this.alwaysJinja = true;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = TextareaFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class URLField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.URL);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^(http|ftp|https):\/\/[\w\-_]+(\.[\w\-_]+)+([\w\-\.,@?^=%&amp;:\/~\+#]*[\w\-\@?^=%&amp;\/~\+#])?/i;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function LookupViewComponent_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 3);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
} }
class LookupViewComponent extends AbstractViewComponent {
    ngOnInit() {
        this.setDisplayValue();
    }
    setDisplayValue() {
        if (this.value) {
            this.value.displayValue = this.value.name ? this.value.name : this.value.firstname + ' ' + this.value.lastname;
        }
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵLookupViewComponent_BaseFactory; return function LookupViewComponent_Factory(__ngFactoryType__) { return (ɵLookupViewComponent_BaseFactory || (ɵLookupViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(LookupViewComponent)))(__ngFactoryType__ || LookupViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LookupViewComponent, selectors: [["xf-lookup-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 4, vars: 7, consts: [[1, "form-group"], ["class", "form-label margin-bottom-4px d-block", 3, "for", 4, "ngIf"], [3, "ngClass", "title"], [1, "form-label", "margin-bottom-4px", "d-block", 3, "for"]], template: function LookupViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, LookupViewComponent_label_1_Template, 2, 2, "label", 1);
            i0.ɵɵelementStart(2, "p", 2);
            i0.ɵɵtext(3);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fieldOptions.showLabel);
            i0.ɵɵadvance();
            i0.ɵɵclassMapInterpolate1("mb-0 p-0 d-inline ", ctx.fieldClass, "");
            i0.ɵɵpropertyInterpolate("title", ctx.value);
            i0.ɵɵproperty("ngClass", ctx.fieldOptions.size === "large" ? "font-size-18px fw-semibold" : "font-size-14px");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.value ? ctx.value.displayValue : "--");
        } }, dependencies: [i1.NgClass, i1.NgIf], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LookupViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-lookup-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n\n<div class=\"form-group\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px d-block\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n  </label>\n  <p class=\"mb-0 p-0 d-inline {{fieldClass}}\"\n    [ngClass]=\"fieldOptions.size === 'large' ? 'font-size-18px fw-semibold' : 'font-size-14px'\" title=\"{{value}}\">{{\n    value ? value.displayValue : '--' }}</p>\n</div>\n" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LookupViewComponent, { className: "LookupViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/lookup/lookup-view.component.ts", lineNumber: 15 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function LookupFloatingFilterComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵelement(1, "xf-form-field", 3, 0);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r0.lookupField)("fieldOptions", ctx_r0.fieldOptions);
} }
class LookupFloatingFilterComponent {
    constructor() {
        this.formBuilder = inject(FormBuilder);
        this.translocoService = inject(TranslocoService);
        this.formGroup = this.formBuilder.group({
            value: [null]
        });
        this.formGroup.valueChanges.subscribe((values) => {
            this.currentValue = values.value?.uuid || null;
            this.updateFilter();
        });
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
    }
    agInit(params) {
        this.params = params;
        let lookupField = params.column.getColDef().headerComponentParams?.field;
        lookupField.placeholder = this.translocoService.translate('Choose');
        lookupField.validation = {
            required: false
        };
        lookupField.params = {
            clearText: 'Any'
        };
        this.lookupField = lookupField;
    }
    onParentModelChanged(parentModel) {
        // When the filter is empty we will receive a null value here
        if (!parentModel) {
            this.currentValue = null;
        }
        else {
            this.currentValue = parentModel.filter;
        }
    }
    updateFilter() {
        if (!this.currentValue) {
            this.params.parentFilterInstance((instance) => {
                instance.onFloatingFilterChanged(null, null);
            });
        }
        this.params.parentFilterInstance((instance) => {
            instance.onFloatingFilterChanged('eq', this.currentValue);
        });
    }
    static { this.ɵfac = function LookupFloatingFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LookupFloatingFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LookupFloatingFilterComponent, selectors: [["xf-lookup-floating-filter"]], decls: 1, vars: 1, consts: [["formField", ""], ["style", "display: inline-block;", 3, "formGroup", 4, "ngIf"], [2, "display", "inline-block", 3, "formGroup"], ["formControlName", "value", "fieldClass", "form-control-xs", 3, "field", "fieldOptions"]], template: function LookupFloatingFilterComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LookupFloatingFilterComponent_div_0_Template, 3, 3, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.lookupField);
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LookupFloatingFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-lookup-floating-filter', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div style=\"display: inline-block;\" [formGroup]=\"formGroup\" *ngIf=\"lookupField\">\n  <xf-form-field [field]=\"lookupField\" #formField formControlName=\"value\" [fieldOptions]=\"fieldOptions\" fieldClass=\"form-control-xs\"></xf-form-field>\n</div>\n" }]
    }], () => [], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LookupFloatingFilterComponent, { className: "LookupFloatingFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/lookup/lookup-floating-filter/lookup-floating-filter.component.ts", lineNumber: 19 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class LookupGridFilterComponent {
    constructor() {
        this.currentValue = null;
    }
    agInit(params) {
        this.params = params;
    }
    isFilterActive() {
        return this.currentValue !== null;
    }
    doesFilterPass(params) {
        console.log(params);
        return true;
    }
    getModel() {
        return this.currentValue;
    }
    setModel(model) {
        this.currentValue = model;
    }
    onFloatingFilterChanged(type, value) {
        this.currentValue = type ? {
            filter: value,
            type: type
        } : null;
        this.updateFilter();
    }
    updateFilter() {
        this.params.filterChangedCallback();
    }
    static { this.ɵfac = function LookupGridFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LookupGridFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LookupGridFilterComponent, selectors: [["xf-lookup-grid-filter"]], decls: 0, vars: 0, template: function LookupGridFilterComponent_Template(rf, ctx) { } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LookupGridFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-lookup-grid-filter', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<!-- <h1>Should not be visible</h1> -->\n" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LookupGridFilterComponent, { className: "LookupGridFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/lookup/lookup-grid-filter/lookup-grid-filter.component.ts", lineNumber: 15 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class LookupField extends Field {
    static { this.operators = [...Field.equalOperators,
        ...Field.listOperators,
        ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.LOOKUP);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = LookupFieldComponent;
        this.viewComponent = LookupViewComponent;
        this.gridFloatingFilterComponent = LookupFloatingFilterComponent;
        this.gridFilterComponent = LookupGridFilterComponent;
        this.alwaysEditMode = true;
    }
    set dataSource(value) {
        this._dataSource = value;
        this.model = value.model;
    }
    get dataSource() {
        return this._dataSource;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ArrayField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.ARRAY);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = MultiselectFieldComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$j = a0 => ({ "pe-0": a0 });
const _c1$a = (a0, a1) => ({ "form-select-lg": a0, "form-select-xs": a1 });
function SelectFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 14);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function SelectFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 15);
    i0.ɵɵelement(1, "i", 16);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function SelectFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 11);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, SelectFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 12)(3, SelectFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 13);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function SelectFieldComponent_div_0_option_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 17);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", option_r2.value);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r2.label);
} }
function SelectFieldComponent_div_0_div_9_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 20);
    i0.ɵɵlistener("click", function SelectFieldComponent_div_0_div_9_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function SelectFieldComponent_div_0_div_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 18);
    i0.ɵɵtemplate(1, SelectFieldComponent_div_0_div_9_button_1_Template, 2, 3, "button", 19);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function SelectFieldComponent_div_0_xf_form_messages_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 21);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input)("customErrorMessages", ctx_r0.fieldOptions.customErrorMessages);
} }
function SelectFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, SelectFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5)(4, "select", 6, 0)(6, "option", 7);
    i0.ɵɵtext(7);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(8, SelectFieldComponent_div_0_option_8_Template, 2, 2, "option", 8);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(9, SelectFieldComponent_div_0_div_9_Template, 2, 1, "div", 9);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, SelectFieldComponent_div_0_xf_form_messages_10_Template, 1, 2, "xf-form-messages", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(13, _c0$j, ctx_r0.field.allowJinjaToggle));
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("form-select form-select-sm picklist ", ctx_r0.fieldClass, "");
    i0.ɵɵproperty("name", "select-" + ctx_r0.field.name)("ngClass", i0.ɵɵpureFunction2(15, _c1$a, ctx_r0.fieldOptions.size === "large", ctx_r0.fieldOptions.size === "small"));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("disabled", true);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r0.field.placeholder || "Select", " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r0.field.options);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
} }
class SelectFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, _formBuilder, themeService) {
        super(_changeDetectorRef, _formBuilder);
        this._changeDetectorRef = _changeDetectorRef;
        this._formBuilder = _formBuilder;
        this.themeService = themeService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngOnInit() {
        super.ngOnInit();
        if (!this.field) {
            return;
        }
        if (this.field.fieldOptions && this.field.fieldOptions.options) {
            this.field.options = this.field.fieldOptions.options;
            this._changeDetectorRef.detectChanges();
        }
        if (this.field.dataSource && this.field.dataSource.options) {
            this.field.options = this.field.dataSource.options;
        }
        this.fieldGroup?.valueChanges
            .pipe(map$1(values => values.input))
            .subscribe((value) => {
            this.value = value;
        });
    }
    onFocus() {
        setTimeout(() => {
            this.inputField?.nativeElement.select();
        });
    }
    static { this.ɵfac = function SelectFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SelectFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: SelectFieldComponent, selectors: [["xf-select-field"]], inputs: { field: "field" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["inputField", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], ["formControlName", "input", 3, "name", "ngClass"], ["value", "", 3, "disabled"], [3, "ngValue", 4, "ngFor", "ngForOf"], ["class", "w-auto padding-left-6px", 4, "ngIf"], [3, "control", "customErrorMessages", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "ngValue"], [1, "w-auto", "padding-left-6px"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"], [3, "control", "customErrorMessages"]], template: function SelectFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, SelectFieldComponent_div_0_Template, 11, 18, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, FormMessagesComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SelectFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-select-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">{{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <select [name]=\"'select-' + field.name\"\n        [ngClass]=\"{'form-select-lg': fieldOptions.size === 'large', 'form-select-xs': fieldOptions.size === 'small'}\"\n        class=\"form-select form-select-sm picklist {{fieldClass}}\" formControlName=\"input\" #inputField>\n        <option [disabled]=\"true\" value=\"\">{{field.placeholder || 'Select' }} </option>\n        <option *ngFor=\"let option of field.options\" [ngValue]=\"option.value\">{{ option.label }}</option>\n      </select>\n    </div>\n    <div class=\"w-auto padding-left-6px\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n\n  <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"\n    [customErrorMessages]=\"fieldOptions.customErrorMessages\"></xf-form-messages>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: ThemeService }], { field: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(SelectFieldComponent, { className: "SelectFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/select-field/select-field.component.ts", lineNumber: 18 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SelectViewComponent extends AbstractViewComponent {
    constructor(themeService, _changeDetectorRef) {
        super(_changeDetectorRef);
        this.themeService = themeService;
        this._changeDetectorRef = _changeDetectorRef;
        this.currentTheme = this.themeService.getTheme();
    }
    static { this.ɵfac = function SelectViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SelectViewComponent)(i0.ɵɵdirectiveInject(ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: SelectViewComponent, selectors: [["xf-select-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 5, consts: [[3, "title"]], template: function SelectViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "p", 0);
            i0.ɵɵtext(1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵclassMapInterpolate1("mb-0 p-0 d-inline ", ctx.fieldClass, "");
            i0.ɵɵpropertyInterpolate("title", ctx.value);
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.value ? ctx.value : "--");
        } }, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SelectViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-select-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p class=\"mb-0 p-0 d-inline {{fieldClass}}\" title=\"{{value}}\">{{ value ? value : '--' }}</p>" }]
    }], () => [{ type: ThemeService }, { type: i0.ChangeDetectorRef }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(SelectViewComponent, { className: "SelectViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/select-field/select-view.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SelectField extends Field {
    static { this.selectEqualsOperators = [
        new Operator('eq', 'Equals', SelectFieldComponent, this.evaluateEqual),
        new Operator('neq', 'Not Equals', SelectFieldComponent, this.evaluateNotEqual),
    ]; }
    static { this.operators = [...SelectField.selectEqualsOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.SELECT);
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = SelectFieldComponent;
        this.viewComponent = SelectViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$i = (a0, a1, a2) => ({ "form-select-lg": a0, "form-select-xs": a1, "is-invalid": a2 });
const _c1$9 = (a0, a1) => ({ "font-size-14px margin-top-6px": a0, "content-font margin-top-4px": a1 });
function ToggleDropdownFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 10);
    i0.ɵɵelement(1, "i", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function ToggleDropdownFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function ToggleDropdownFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 7);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, ToggleDropdownFieldComponent_div_0_label_1_span_2_Template, 2, 1, "span", 8)(3, ToggleDropdownFieldComponent_div_0_label_1_span_3_Template, 2, 0, "span", 9);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", ctx_r0.field.name)("ngClass", i0.ɵɵpureFunction2(5, _c1$9, ctx_r0.fieldOptions.size === "large", ctx_r0.fieldOptions.size === "small"));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
} }
function ToggleDropdownFieldComponent_div_0_option_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 13);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", option_r2.value);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r2.label);
} }
function ToggleDropdownFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, ToggleDropdownFieldComponent_div_0_label_1_Template, 4, 8, "label", 3);
    i0.ɵɵelementStart(2, "select", 4, 0);
    i0.ɵɵtemplate(4, ToggleDropdownFieldComponent_div_0_option_4_Template, 2, 2, "option", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(5, "xf-form-messages", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("form-select ", ctx_r0.fieldClass, " cursor-pointer");
    i0.ɵɵproperty("name", "select-" + ctx_r0.field.name)("ngClass", i0.ɵɵpureFunction3(9, _c0$i, ctx_r0.fieldOptions.size === "large", ctx_r0.fieldOptions.size === "small", ctx_r0.fieldGroup.controls.input.invalid));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r0.field.fieldOptions.options);
    i0.ɵɵadvance();
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
class ToggleDropdownFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, _formBuilder, themeService) {
        super(_changeDetectorRef, _formBuilder);
        this._changeDetectorRef = _changeDetectorRef;
        this._formBuilder = _formBuilder;
        this.themeService = themeService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngAfterViewInit() {
        if (!this.field) {
            return;
        }
        this.value = isUndefined(this.value) ? this.field.fieldOptions.options[0].value : this.value;
        this.fieldGroup?.valueChanges
            .pipe(map$1(values => values.input))
            .subscribe((value) => {
            this.value = value;
        });
    }
    static { this.ɵfac = function ToggleDropdownFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ToggleDropdownFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ToggleDropdownFieldComponent, selectors: [["xf-field-toggle-dropdown"]], inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["inputField", ""], ["class", "d-flex form-group align-items-baseline padding-left-10px padding-right-10px padding-top-8px toggle-dropdown-container rounded-4px", 3, "formGroup", 4, "ngIf"], [1, "d-flex", "form-group", "align-items-baseline", "padding-left-10px", "padding-right-10px", "padding-top-8px", "toggle-dropdown-container", "rounded-4px", 3, "formGroup"], ["class", "margin-right-8px muted-40 flex-shrink-0", 3, "for", "ngClass", 4, "ngIf"], ["formControlName", "input", 3, "name", "ngClass"], [3, "ngValue", 4, "ngFor", "ngForOf"], [3, "control"], [1, "margin-right-8px", "muted-40", "flex-shrink-0", 3, "for", "ngClass"], ["container", "body", "placement", "bottom", 3, "ngbTooltip", 4, "ngIf"], ["class", "text-danger margin-right-4px", 4, "ngIf"], ["container", "body", "placement", "bottom", 3, "ngbTooltip"], [1, "fa", "fa-light", "fa-info-circle", "text-warning"], [1, "text-danger", "margin-right-4px"], [3, "ngValue"]], template: function ToggleDropdownFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ToggleDropdownFieldComponent_div_0_Template, 6, 13, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, FormMessagesComponent], styles: [".toggle-dropdown-container[_ngcontent-%COMP%]{background:var(--element-inverse-bg-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ToggleDropdownFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-toggle-dropdown', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"d-flex form-group align-items-baseline padding-left-10px padding-right-10px padding-top-8px toggle-dropdown-container rounded-4px\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n    <label [for]=\"field.name\" class=\"margin-right-8px muted-40 flex-shrink-0\" [ngClass]=\"{'font-size-14px margin-top-6px': fieldOptions.size === 'large', 'content-font margin-top-4px': fieldOptions.size === 'small'}\" *ngIf=\"fieldOptions.showLabel\">\n        {{ field.title }}\n        <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\" container=\"body\" placement=\"bottom\">\n            <i class=\"fa fa-light fa-info-circle text-warning\"></i>\n        </span>\n        <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    </label>\n    <select [name]=\"'select-' + field.name\"\n        [ngClass]=\"{'form-select-lg': fieldOptions.size === 'large', 'form-select-xs': fieldOptions.size === 'small', 'is-invalid': fieldGroup.controls.input.invalid}\"\n        class=\"form-select {{fieldClass}} cursor-pointer\" formControlName=\"input\" #inputField>\n        <option *ngFor=\"let option of field.fieldOptions.options\" [ngValue]=\"option.value\">{{ option.label }}</option>\n    </select>\n    <xf-form-messages [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n</div>", styles: [".toggle-dropdown-container{background:var(--element-inverse-bg-color)}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: ThemeService }], { field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ToggleDropdownFieldComponent, { className: "ToggleDropdownFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/toggle-dropdown/toggle-dropdown-field.component.ts", lineNumber: 19 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ToggleDropdownField extends Field {
    static { this.operators = [...Field.equalOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.TOGGLEDROPDOWN);
        this.customText = {};
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = ToggleDropdownFieldComponent;
        this.viewComponent = ToggleDropdownFieldComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class CertificateField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.CERTIFICATE);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = TextareaFieldComponent;
        this.viewComponent = TextareaFieldComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$h = a0 => ({ "pe-0": a0 });
function TagsFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function TagsFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵelement(1, "i", 13);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function TagsFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 8);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, TagsFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 9)(3, TagsFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function TagsFieldComponent_div_0_div_5_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 16);
    i0.ɵɵlistener("click", function TagsFieldComponent_div_0_div_5_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function TagsFieldComponent_div_0_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, TagsFieldComponent_div_0_div_5_button_1_Template, 2, 3, "button", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function TagsFieldComponent_div_0_xf_form_messages_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 17);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
function TagsFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, TagsFieldComponent_div_0_label_1_Template, 4, 4, "label", 2);
    i0.ɵɵelementStart(2, "div", 3)(3, "div", 4);
    i0.ɵɵelement(4, "xf-tags-input", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, TagsFieldComponent_div_0_div_5_Template, 2, 1, "div", 6);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, TagsFieldComponent_div_0_xf_form_messages_6_Template, 1, 1, "xf-form-messages", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c0$h, ctx_r0.field.allowJinjaToggle));
    i0.ɵɵadvance();
    i0.ɵɵproperty("placeholder", ctx_r0.field.placeholder)("tagsBaseUrl", ctx_r0.field.baseUrl);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
} }
class TagsFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, _formBuilder, themeService) {
        super(_changeDetectorRef, _formBuilder);
        this.themeService = themeService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngAfterViewInit() {
        if (!this.field) {
            return;
        }
        this.fieldGroup?.valueChanges
            .pipe(map$1(values => values.input))
            .subscribe((value) => {
            this._value = value;
            this.onChange(value);
        });
    }
    static { this.ɵfac = function TagsFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TagsFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TagsFieldComponent, selectors: [["xf-tags-field"]], inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], ["formControlName", "input", 3, "placeholder", "tagsBaseUrl"], ["class", "w-auto padding-left-6px", 4, "ngIf"], [3, "control", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [1, "w-auto", "padding-left-6px"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"], [3, "control"]], template: function TagsFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, TagsFieldComponent_div_0_Template, 7, 9, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TagsFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-tags-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <xf-tags-input [placeholder]=\"field.placeholder\" formControlName=\"input\" [tagsBaseUrl]=\"field.baseUrl\"></xf-tags-input>\n    </div>\n    <div class=\"w-auto padding-left-6px\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n  <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: ThemeService }], { field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TagsFieldComponent, { className: "TagsFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/tags/tags-field.component.ts", lineNumber: 18 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function TagsViewComponent_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 2);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const tag_r1 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", tag_r1, " ");
} }
class TagsViewComponent extends AbstractViewComponent {
    constructor(_changeDetectorRef, themeService) {
        super(_changeDetectorRef);
        this.themeService = themeService;
        this.currentTheme = this.themeService.getTheme();
    }
    static { this.ɵfac = function TagsViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TagsViewComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TagsViewComponent, selectors: [["xf-tags-view"]], inputs: { value: "value", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 1, consts: [[1, "d-inline-block"], ["class", "tag-badge content-font", 4, "ngFor", "ngForOf"], [1, "tag-badge", "content-font"]], template: function TagsViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, TagsViewComponent_span_1_Template, 2, 1, "span", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.value);
        } }, dependencies: [i1.NgForOf] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TagsViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-tags-view', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"d-inline-block\">\n    <span *ngFor=\"let tag of value\" class=\"tag-badge content-font\">\n        {{ tag }}\n    </span>\n</div>" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: ThemeService }], { value: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TagsViewComponent, { className: "TagsViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/tags/tags-view.component.ts", lineNumber: 15 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class TagsField extends Field {
    static { this.operators = [
        new Operator('in', 'Is In List', TagsFieldComponent, this.evaluateIsInList),
        new Operator('nin', 'Is Not In List', TagsFieldComponent, this.evaluateIsNotInList)
    ]; }
    constructor(name, baseUrl) {
        super(name, Field.BuiltInType.TAGS);
        this.baseUrl = baseUrl;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = TagsFieldComponent;
        this.viewComponent = TagsViewComponent;
    }
}

class Entity {
    constructor(type) {
        this.module = '';
        this.displayName = '';
        this.descriptions = {
            singular: '',
            plural: ''
        };
        this.moduleDescription = '';
        this.defaultSort = [];
        this.uniqueConstraint = [];
        this.display = '';
        //TODO: Use external way to typecast the Field to specific Field type
        this.attributes = [];
        this.values = {};
        this.ownable = false;
        this.primaryKey = 'uuid';
        this.userOwnable = false;
        this.trackable = true;
        this.softDeleteable = false;
        this.queueable = false;
        this.indexable = true;
        this.peerReplicable = false;
        this.system = false;
        this.tableName = '';
        this.taggable = true;
        this.conditionalOwnable = false;
        this.writeable = true;
        this.bulkAction = {
            allow: false,
            buttonClass: 'btn btn-secondary btn-sm',
            buttonIcon: '',
            buttonText: '',
        };
        this.parentType = '';
        this.type = type;
        this.baseUrl = API.BASE + this.type;
    }
    get fields() {
        let fields = {};
        this.attributes.forEach((attribute) => {
            fields[attribute.name] = attribute;
        });
        return fields;
    }
    set fields(_fields) {
        forEach(_fields, (field) => {
            this.fields[field.name] = field;
            const index = this.attributes.findIndex((value) => {
                return value.name === field.name;
            });
            if (index === -1) {
                this.attributes.push(field);
            }
            else {
                this.attributes.splice(index, 0, field);
            }
        });
    }
    get relationships() {
        return this.attributes.filter((attribute) => attribute.isRelationship);
    }
    get iri() {
        return this.baseUrl + this.type + '/' + this.uuid;
    }
    evaluateAllFields() {
        this.attributes.forEach((field) => { });
    }
    get title() {
        return this.descriptions.plural;
    }
    getFormFields() {
        return this.attributes.filter((attribute) => attribute.isFormField);
    }
}
__decorate([
    Expose({ name: 'displayName' })
], Entity.prototype, "displayName", void 0);
__decorate([
    Type(() => Field, {
        discriminator: {
            property: 'formType',
            // Builtins
            subTypes: [
                { value: TextField, name: Field.BuiltInType.TEXT },
                { value: IntegerField, name: Field.BuiltInType.INTEGER },
                { value: CheckboxField, name: Field.BuiltInType.CHECKBOX },
                { value: DecimalField, name: Field.BuiltInType.DECIMAL },
                { value: EmailField, name: Field.BuiltInType.EMAIL },
                { value: DatetimeField, name: Field.BuiltInType.DATETIME },
                { value: MultiselectPicklistField, name: Field.BuiltInType.MULTISELECT_PICKLIST },
                { value: PicklistField, name: Field.BuiltInType.PICKLIST },
                { value: ManyToManyField, name: Field.BuiltInType.MANY_TO_MANY },
                { value: OneToManyField, name: Field.BuiltInType.ONE_TO_MANY },
                { value: FileField, name: Field.BuiltInType.FILE },
                { value: JSONField, name: Field.BuiltInType.JSON },
                { value: ArrayField, name: Field.BuiltInType.ARRAY },
                { value: TagsField, name: Field.BuiltInType.TAGS },
                { value: PhoneField, name: Field.BuiltInType.PHONE },
                { value: DomainField, name: Field.BuiltInType.DOMAIN },
                { value: FilehashField, name: Field.BuiltInType.FILEHASH },
                { value: IPv4Field, name: Field.BuiltInType.IPv4 },
                { value: IPv6Field, name: Field.BuiltInType.IPv6 },
                { value: RichtextHTMLField, name: Field.BuiltInType.RICHTEXTHTML },
                { value: RichtextMarkdownField, name: Field.BuiltInType.RICHTEXTMARKDOWN },
                { value: TextareaField, name: Field.BuiltInType.TEXTAREA },
                { value: LookupField, name: Field.BuiltInType.LOOKUP },
                { value: URLField, name: Field.BuiltInType.URL },
                { value: SelectField, name: Field.BuiltInType.SELECT },
                { value: ToggleDropdownField, name: Field.BuiltInType.TOGGLEDROPDOWN },
                { value: CertificateField, name: Field.BuiltInType.CERTIFICATE }
            ],
        },
    })
], Entity.prototype, "attributes", void 0);
(function (Entity) {
    ;
})(Entity || (Entity = {}));

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class MultiSelectField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.MULTISELECT);
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = MultiselectFieldComponent;
        this.viewComponent = MultiselectFieldComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class PasswordField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.PASSWORD);
        this.allowJinjaToggle = false;
        this.isFormField = true;
        this.isRelationship = false;
    }
    getFieldLength() {
        return {
            minlength: 8,
            maxlength: 63
        };
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const ModuleAttributeMap = {
    text: {
        formType: 'text',
        title: 'Text Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: true
        },
        field: TextField,
    },
    password: {
        formType: 'password',
        title: 'Password',
        type: 'string',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: PasswordField
    },
    checkbox: {
        formType: 'checkbox',
        title: 'Checkbox',
        type: 'boolean',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: CheckboxField
    },
    integer: {
        formType: 'integer',
        title: 'Integer Field',
        type: 'integer',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: IntegerField
    },
    decimal: {
        formType: 'decimal',
        title: 'Decimal Field',
        type: 'number',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: DecimalField
    },
    datetime: {
        formType: 'datetime',
        title: 'Date/Time Field',
        type: 'integer',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: DatetimeField
    },
    phone: {
        formType: 'phone',
        title: 'Phone Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: PhoneField
    },
    email: {
        formType: 'email',
        title: 'Email Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: EmailField
    },
    picklist: {
        formType: 'picklist',
        title: 'Picklist',
        type: 'picklists',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: PicklistField,
        dataSource: {
            model: 'picklists',
            query: {
                logic: 'AND',
                filters: [{
                        field: 'listName__name',
                        operator: 'eq',
                        value: null
                    }],
                sort: [{
                        field: 'orderIndex',
                        direction: 'ASC'
                    }]
            }
        },
        displayTemplate: '{{ itemValue }}'
    },
    multiselectpicklist: {
        formType: 'multiselectPicklist',
        title: 'Multiselect Picklist',
        type: 'picklists',
        isFormField: true,
        usable: false,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: 'picklists',
            query: {
                logic: 'AND',
                filters: [{
                        field: 'listName__name',
                        operator: 'eq',
                        value: null
                    }],
                sort: [{
                        field: 'orderIndex',
                        direction: 'ASC'
                    }]
            }
        },
        displayTemplate: '{{ itemValue }}',
        collection: true,
        ownsRelationship: false,
        field: MultiselectPicklistField
    },
    domain: {
        formType: 'domain',
        title: 'Domain',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: DomainField
    },
    url: {
        formType: 'url',
        title: 'URL',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: URLField
    },
    file: {
        formType: 'file',
        title: 'File Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: 'files'
        },
        field: FileField
    },
    fileHash: {
        formType: 'fileHash',
        title: 'FileHash',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: FilehashField
    },
    ipv4: {
        formType: 'ipv4',
        title: 'IPv4',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: IPv4Field
    },
    ipv6: {
        formType: 'ipv6',
        title: 'IPv6',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: IPv6Field
    },
    json: {
        formType: 'json',
        title: 'JSON Field',
        type: 'string',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: JSONField
    },
    lookup: {
        formType: 'lookup',
        title: 'Lookup (One to Many or One to One)',
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: null
        },
        field: LookupField
    },
    manyToMany: {
        formType: 'manyToMany',
        title: 'Many to Many',
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        collection: true,
        field: ManyToManyField
    },
    oneToMany: {
        formType: 'oneToMany',
        title: 'One To Many', // previously Many to One changing it as per form type // need to confirm
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: null
        },
        field: OneToManyField
    },
    html: {
        formType: 'html',
        title: 'Rich Text (HTML)',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: RichtextHTMLField
    },
    richtext: {
        formType: 'richtext',
        title: 'Rich Text (Markdown)',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: RichtextMarkdownField
    },
    tags: {
        formType: 'tags',
        title: 'Tags',
        type: 'tags',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: true,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: TagsField
    },
    textarea: {
        formType: 'textarea',
        title: 'Text Area',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: true,
            allowEncryption: true,
            allowSearchable: true,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: TextareaField
    },
    select: {
        formType: 'select',
        title: 'Select Field',
        type: 'select',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField
    },
    multiselect: {
        formType: 'multiselect',
        title: 'Multiselect Field',
        type: 'array',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: MultiSelectField
    },
    dynamicList: {
        formType: 'dynamicList',
        title: 'Dynamic List',
        type: 'array',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with dynamicList Field
    },
    array: {
        formType: 'text',
        title: 'Array Field',
        type: 'string',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with dynamicList Field
    },
    object: {
        formType: 'object',
        title: 'JSON',
        type: 'object',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: true,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with dynamicList Field
    },
    image: {
        formType: 'image',
        title: 'Image',
        type: null,
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with image Field
    },
    toManyList: {
        formType: 'manyToMany',
        title: 'Many to Many',
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: true,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        dataSource: {
            model: null
        },
        collection: true,
        field: SelectField // replace this with toManyList Field
    },
    label: {
        formType: 'label',
        title: 'Label',
        type: 'string',
        isFormField: false,
        usable: false,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: true
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with label Field
    },
    livesync: {
        formType: 'livesync',
        title: 'Live Sync',
        type: null,
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField // replace this with licesync Field
    },
    certificate: {
        formType: 'certificate',
        title: 'Certificate',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: false
        },
        field: TextareaField // replace this with certificate Field
    },
    codeEditor: {
        formType: 'codeEditor',
        title: 'Code Editor',
        type: 'codeEditor',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: false
        },
        connector: {
            allowUpdate: true
        },
        field: TextareaField
    },
    emailTemplate: {
        formType: 'emailTemplate',
        title: 'Email Template Field',
        type: 'string',
        isFormField: true,
        usable: true,
        mmd: {
            allowUpdate: false,
            allowGridColumn: false,
            allowEncryption: false,
            allowSearchable: false,
            lengthConstraint: false
        },
        playbook: {
            allowUpdate: true
        },
        connector: {
            allowUpdate: false
        },
        field: SelectField
    }
};
//     .attribute('checkbox.select', {
//       templateUrl: 'app/components/form/fields/checkbox.select.html'
//     })
//     .attribute('datetime.advance', {
//       templateUrl: 'app/components/form/fields/datetime.advance.html'
//     })
//     .attribute('datetime.quick', {
//       templateUrl: 'app/components/form/fields/datetime.quick.html'
//     })
//     .attribute('datetime.grid', {
//       templateUrl: 'app/components/form/fields/datetime.grid.html'
//     })
//     .attribute('datetime.defaultValue', {
//       templateUrl: 'app/components/form/fields/datetime.defaultValue.html'
//     })
//     .attribute('datetime.playbook', {
//       templateUrl: 'app/components/form/fields/datetime.playbook.html'
//     })
//     .attribute('select.input', {
//       formType: 'select',
//       title: 'Select Input',
//       type: 'string',
//       templateUrl: 'app/components/form/fields/selectInput.html'
//     })
//     .attribute('jinja.input', {
//       formType: 'text',
//       title: 'Text Field',
//       type: 'string',
//       templateUrl: 'app/components/form/fields/input.html'
//     })
//     .attribute('picklist.multi', {
//       templateUrl: 'app/components/form/fields/picklist.multi.html'
//     })
//     .attribute('relationshipFields.playbook', {
//       templateUrl: 'app/components/form/fields/input.html'
//     })
// }

class ModelMetadataService {
    constructor(http, storage) {
        this.http = http;
        this.storage = storage;
    }
    loadAllModules(forceUpdate = false) {
        return forkJoin([
            this.getModuleList(false, forceUpdate),
            this.getSystemModules(),
        ]);
    }
    getModuleList(staging = false, forceUpdateModelMeta = false) {
        const KEY = staging ? MMD.STAGING_METADATAS_KEY : MMD.MODEL_METADATAS_KEY;
        const modelMetadatas = (staging || forceUpdateModelMeta) ? null : this.storage.getItem(KEY);
        if (modelMetadatas === null) {
            return this.http
                .get(API.BASE + KEY, {
                params: {
                    limit: ALL_RECORDS_SIZE,
                    $relationships: true,
                    $orderby: 'type',
                },
            })
                .pipe(map((response) => {
                const metadata = response['hydra:member'];
                if (staging === false) {
                    this.storage.setItem(KEY, modelMetadatas);
                    metadata.forEach((model) => {
                        this.storage.setItem('metadata.' + model.type, model);
                    });
                }
                return metadata;
            }));
        }
        else {
            return of(modelMetadatas);
        }
    }
    getSystemModules() {
        return this.http.get(API.SYSTEM_MODULES).pipe(map((systemModelMetadatas) => {
            if (systemModelMetadatas) {
                systemModelMetadatas.forEach((systemModel) => {
                    this.storage.setItem('metadata.' + systemModel.type, systemModel);
                });
            }
            return systemModelMetadatas;
        }));
    }
    getMetadataByModuleType(type) {
        let modelMetadata = this.storage.getItem('metadata.' + type);
        if (!modelMetadata) {
            console.warn(type + ' module metadata not found');
            return;
        }
        //modelMetadata.attributes = modelMetadata.attributes.filter((attribute: any) => attribute.name !== 'uuid');
        return modelMetadata;
    }
    static { this.ɵfac = function ModelMetadataService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModelMetadataService)(i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModelMetadataService, factory: ModelMetadataService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModelMetadataService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], () => [{ type: i1$1.HttpClient }, { type: StorageService }], null); })();

class RoleService {
    constructor() {
        this.entities = [];
        this._checkAll = false;
    }
    get display() {
        return this.name;
    }
    get type() {
        return 'service';
    }
}

class RoleEntity {
    constructor(uuid) {
        this.uuid = uuid;
        this.permissions = [];
        this._checkAll = false;
        this.visible = true;
    }
    get display() {
        return this.name;
    }
    get type() {
        return 'entity';
    }
}

class RolePermission {
    constructor() {
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class PermissionService {
    constructor() {
        this.http = inject(HttpClient);
        this.storageService = inject(StorageService);
    }
    getPermission(entity) {
        let permissions = this.storageService.getItem(STORAGE_KEYS.CURRENT_PERMISSIONS);
        return permissions[entity] ? permissions[entity].map((permission) => permission.name) : [];
    }
    getPermissions(entities) {
        let entityMap = {};
        entities.forEach((entity) => {
            entityMap[entity] = this.getPermission(entity);
        });
        return entityMap;
    }
    getAllFlatPermissions() {
        let flatPermissions = [];
        let permissions = this.storageService.getItem(STORAGE_KEYS.CURRENT_PERMISSIONS);
        keys(permissions).forEach((entity) => {
            let permission = this.getPermission(entity);
            permission.forEach((permissionAction) => {
                flatPermissions.push(`${entity}.${permissionAction}`);
            });
        });
        return flatPermissions;
    }
    isAdmin() {
        return true;
    }
    availablePermission(entity, permission) {
        // TODO: implement
        return true;
    }
    availableFieldPermission(entity, fieldName, permission) {
        return true;
    }
    loadServices() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_SERVICES + '/', {
            params: {
                limit: 1000
            }
        }).pipe(map$1((response) => {
            return plainToInstance(RoleService, response['hydra:member']);
        }));
    }
    loadEntities() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_ENTITIES + '/', {
            params: {
                limit: 1000
            }
        }).pipe(map$1((response) => {
            return plainToInstance(RoleEntity, response['hydra:member']);
        }));
    }
    loadServicesAndEntities() {
        return this.loadServices().pipe(concatMap$1((services) => {
            return this.loadEntities().pipe(map$1((entities) => {
                services.forEach((service) => {
                    service.entities = entities.filter((entity) => entity.service === service.uuid && entity.visible);
                });
                return services;
            }));
        }));
    }
    loadPermissions() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_PERMISSIONS + '/').pipe(map$1((response) => {
            return plainToInstance(RolePermission, response['hydra:member']);
        }));
    }
    static { this.ɵfac = function PermissionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PermissionService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PermissionService, factory: PermissionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PermissionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class EntityService {
    constructor(modelMetadataService, permissionService, utilityService, getEndPathNamePipe, interpolate, unixToDatePipe) {
        this.modelMetadataService = modelMetadataService;
        this.permissionService = permissionService;
        this.utilityService = utilityService;
        this.getEndPathNamePipe = getEndPathNamePipe;
        this.interpolate = interpolate;
        this.unixToDatePipe = unixToDatePipe;
        this.apiService = inject(ApiService);
        this.loading$ = {};
        this.displayNameMapping = {};
        this.traitFields = {
            indexable: [
                plainToInstance(IntegerField, {
                    name: 'id',
                    descriptions: {
                        singular: 'ID'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'integer',
                    gridColumn: true,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: true,
                    title: 'ID',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: false
                })
            ],
            ownable: [
                plainToInstance(ManyToManyField, {
                    name: 'owners',
                    bulkAction: [],
                    dataSource: {
                        model: 'teams',
                        query: []
                    },
                    descriptions: {
                        singular: 'Owners'
                    },
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'manyToMany',
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Owners',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: true
                })
            ],
            queueable: [
                plainToInstance(LookupField, {
                    name: 'xfQueue',
                    descriptions: {
                        singular: 'Queue'
                    },
                    bulkAction: {
                        allow: true,
                        buttonClass: 'btn btn-secondary btn-sm',
                        buttonIcon: 'fa fa-users fa-light',
                        buttonText: 'Change Queue'
                    },
                    dataSource: {
                        model: 'xf_queues',
                        query: {
                            filters: [],
                            logic: 'AND'
                        }
                    },
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'lookup',
                    gridColumn: true,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Queue',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: true
                })
            ],
            taggable: [
                plainToInstance(TagsField, {
                    name: 'recordTags',
                    descriptions: {
                        singular: 'Tags'
                    },
                    bulkAction: [],
                    dataSource: {
                        model: 'tags',
                        query: []
                    },
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    baseUrl: '',
                    formType: 'tags',
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Tags',
                    tooltip: 'Special characters # ? , \' \'\' and / are not allowed in tag.',
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: true
                })
            ],
            trackable: [
                plainToInstance(LookupField, {
                    name: 'createUser',
                    descriptions: {
                        singular: 'Created By'
                    },
                    bulkAction: [],
                    dataSource: {
                        model: 'users',
                        query: {
                            filters: [{
                                    field: 'type',
                                    operator: 'eq',
                                    value: 'sso'
                                }],
                            logic: "AND"
                        }
                    },
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'lookup',
                    gridColumn: true,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Created By',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: false
                }),
                plainToInstance(DatetimeField, {
                    name: 'createDate',
                    descriptions: {
                        singular: 'Created On'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'datetime',
                    gridColumn: true,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Created On',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: false
                }),
                plainToInstance(LookupField, {
                    name: 'modifyUser',
                    descriptions: {
                        singular: 'Modified By'
                    },
                    bulkAction: [],
                    dataSource: {
                        model: 'users',
                        query: {
                            filters: [{
                                    field: 'type',
                                    operator: 'eq',
                                    value: 'sso'
                                }],
                            logic: "AND"
                        }
                    },
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'lookup',
                    gridColumn: true,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Modified By',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: false
                }),
                plainToInstance(DatetimeField, {
                    name: 'modifyDate',
                    descriptions: {
                        singular: 'Modified On'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'datetime',
                    gridColumn: true,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Modified On',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: false
                })
            ],
            peerReplicable: [
                plainToInstance(LookupField, {
                    name: 'tenant',
                    descriptions: {
                        singular: 'Tenant'
                    },
                    bulkAction: [],
                    dataSource: {
                        model: 'tenants',
                        query: {
                            logic: 'AND',
                            filters: null,
                            sort: [
                                {
                                    field: 'name',
                                    direction: 'ASC'
                                }
                            ]
                        }
                    },
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'lookup',
                    gridColumn: true,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: true,
                    title: 'Tenant',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: false
                }),
                plainToInstance(CheckboxField, {
                    name: 'conflict',
                    descriptions: {
                        singular: 'Conflict'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: false,
                    encrypted: false,
                    exportable: false,
                    formType: 'checkbox',
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Conflict',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: false,
                    writeable: false
                }),
                plainToInstance(IntegerField, {
                    name: 'tenantRecordId',
                    descriptions: {
                        singular: 'Tenant Record ID'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: false,
                    encrypted: false,
                    exportable: false,
                    formType: 'integer',
                    gridColumn: true,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: true,
                    title: 'Tenant Record ID',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: false
                })
            ],
            conditionalOwnable: [
                plainToInstance(ManyToManyField, {
                    name: 'owners',
                    descriptions: {
                        singular: 'Owners'
                    },
                    bulkAction: [],
                    dataSource: {
                        model: 'teams',
                        query: []
                    },
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'manyToMany',
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Owners',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: true
                }),
                plainToInstance(CheckboxField, {
                    name: 'isPrivate',
                    descriptions: {
                        singular: 'Is Private'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'checkbox',
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Is Private',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: true
                })
            ],
            softDelete: [
                plainToInstance(CheckboxField, {
                    name: 'is_deleted',
                    descriptions: {
                        singular: 'Is Deleted'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: false,
                    encrypted: false,
                    exportable: false,
                    formType: 'checkbox',
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Is Deleted',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: false,
                    writeable: false
                }),
                plainToInstance(DatetimeField, {
                    name: 'deleted_on',
                    descriptions: {
                        singular: 'Deleted On'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'datetime',
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Deleted On',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: false
                })
            ],
            userOwnable: [
                plainToInstance(Field, {
                    name: 'assignee',
                    descriptions: {
                        singular: 'Assignee'
                    },
                    bulkAction: [],
                    dataSource: null,
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: null,
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'Assignee',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: true
                }),
                plainToInstance(ManyToManyField, {
                    name: 'userOwners',
                    descriptions: {
                        singular: 'User Owners'
                    },
                    bulkAction: [],
                    dataSource: {
                        model: 'people',
                        query: []
                    },
                    dataSourceFilters: null,
                    defaultValue: null,
                    encrypted: false,
                    exportable: false,
                    formType: 'manyToMany',
                    gridColumn: false,
                    htmlEscape: false,
                    peerReplicable: true,
                    searchable: false,
                    title: 'User Owners',
                    tooltip: null,
                    unique: false,
                    validation: [],
                    visibility: true,
                    writeable: true
                })
            ]
        };
    }
    getEntities() {
        return this.modelMetadataService.getModuleList().pipe(concatMap((modules) => {
            return this.castEntities(modules).pipe(map((entityList) => {
                return keyBy(entityList, 'type');
            }));
        }));
    }
    getEntityList() {
        return this.getEntities().pipe(map((entities) => values(entities)));
    }
    castEntities(modules) {
        let entities$ = [];
        modules.forEach((module) => {
            let entity = plainToInstance(Entity, cloneDeep(module));
            entity.attributes = sortBy(entity.attributes, 'orderIndex');
            let fieldTypes$ = [];
            entity.attributes.forEach((attribute, attributeIndex) => {
                // if (attribute instanceof Field && attribute.formType) {
                //   const attributeObject = module.attributes[attributeIndex];
                //   let fieldType$ = this.fieldService.getFieldRenderer(attributeObject.formType).pipe(
                //     map((fieldType: Type<Field> | null) => {
                //       if (fieldType) {
                //         entity.attributes[attributeIndex] = plainToInstance(fieldType, attributeObject as object);
                //       } else {
                //         entity.attributes[attributeIndex] = plainToInstance(Field, attributeObject as object);
                //       }
                //     })
                //   );
                //   fieldTypes$.push(fieldType$);
                // }
            });
            if (fieldTypes$.length) {
                entities$.push(combineLatest(fieldTypes$).pipe(map(() => entity)));
            }
            else {
                entities$.push(of(entity));
            }
        });
        return combineLatest(entities$);
    }
    build(type, mode = 'add') {
        let entity$;
        let metadata = this.modelMetadataService.getMetadataByModuleType(type);
        if (!metadata) {
            throw new Error('Metadata for "' + type + '" not found');
        }
        entity$ = this.castEntities([metadata]).pipe(map((entities) => {
            if (!entities.length) {
                return {};
            }
            else {
                return entities[0];
            }
        }));
        return entity$.pipe(concatMap((entity) => {
            let updatedEntity$;
            if (entity.parentType) { // handles only one level of inheritance as in our product we have only one level as of now
                updatedEntity$ = this.castEntities([this.modelMetadataService.getMetadataByModuleType(entity.parentType)]).pipe(map((parentEntities) => {
                    if (parentEntities.length) {
                        entity.attributes = entity.attributes.concat(parentEntities[0].attributes);
                    }
                    return entity;
                }));
            }
            else {
                updatedEntity$ = of(entity);
            }
            return updatedEntity$.pipe(map((entity) => {
                this.buildFields(entity, mode);
                let canUpdate = this.permissionService.availablePermission(entity.type, 'update');
                entity.attributes = entity.attributes.map((attribute) => {
                    const fieldPermissionWrite = this.permissionService.availableFieldPermission(self.name, attribute.name, 'write');
                    attribute.readOnly = !canUpdate || !fieldPermissionWrite;
                    attribute.editable = attribute.editable && !attribute.readOnly;
                    return attribute;
                });
                entity.evaluateAllFields();
                return entity;
            }));
        }));
    }
    hydrate(entity, fieldNames = true, URLparams = new HttpParams()) {
        if (!entity || !entity.uuid) {
            return of();
        }
        let queryBody = {
            filters: [{
                    field: 'uuid',
                    operator: 'eq',
                    value: entity.uuid
                }],
            logic: 'AND'
        };
        if (isArray(fieldNames)) {
            queryBody.fields = fieldNames;
        }
        return this.apiService.query(entity, queryBody).pipe(map((response) => {
            return response['hydra:member'][0];
        }), map((values) => {
            entity.values = merge(entity.values, values);
            entity.display = this.getDisplayValue(entity, entity.values);
            return entity;
        }));
    }
    getRecordDisplay(entity, uuid) {
        if (this.displayNameMapping[uuid]) {
            return of(this.displayNameMapping[uuid]);
        }
        else if (this.loading$[uuid]) {
            return this.loading$[uuid];
        }
        this.loading$[uuid] = new Subject();
        return this.apiService.getRecord(entity, uuid, undefined, true).pipe(catchError(() => {
            this.displayNameMapping[uuid] = 'System';
            this.loading$[uuid].next(this.displayNameMapping[uuid]);
            this.loading$[uuid].complete();
            delete this.loading$[uuid];
            return of();
        }), map((item) => {
            let display = this.getDisplayValue(entity, item);
            this.displayNameMapping[uuid] = display || 'No display';
            this.loading$[uuid].next(display);
            this.loading$[uuid].complete();
            delete this.loading$[uuid];
            return display;
        }));
    }
    clearDisplayCache(uuid) {
        if (isBoolean(uuid) && uuid) {
            this.displayNameMapping = {};
            return;
        }
        else if (isString(uuid)) {
            delete this.displayNameMapping[uuid];
        }
    }
    save(entity, fieldNames) {
        let body = {};
        fieldNames.forEach((fieldName) => {
            // if entity.values[fieldName], fails for boolean fields with value false
            if (fieldName in entity.values) {
                body[fieldName] = entity.values[fieldName];
            }
        });
        //Update existing entity
        if (entity.uuid) {
            const uuid = entity.uuid;
            return this.apiService.updateRecord(entity, uuid, body).pipe(tap(() => this.clearDisplayCache(uuid)), map((values) => {
                entity.values = merge(entity.values, values);
                entity.display = this.getDisplayValue(entity, entity.values);
                return entity;
            }));
        }
        //Create new entity
        else {
            return this.apiService.createRecord(entity, body).pipe(map((values) => {
                entity.values = merge(entity.values, values);
                entity.display = this.getDisplayValue(entity, entity.values);
                return entity;
            }));
        }
    }
    buildFields(entity, mode) {
        this.addTraitFields(entity);
        entity.attributes.sort((attribute) => attribute.orderIndex || 99999);
        entity.attributes.forEach((property) => {
            if (property) {
                property.setMode(mode);
                if (property.model) {
                    this.setDisplayName(property, entity);
                }
                // if (property.formType === 'image') {
                //   let imagePromise = loadImage(field);// we are not using this function. only in PB collection we use image. So if we expose this property then this is required.
                // } else {
            }
        });
    }
    //TODO: for case management update this.
    addTraitFields(entity) {
        entity.attributes = entity.attributes.concat(entity.indexable ? this.traitFields.indexable : []);
        entity.attributes = entity.attributes.concat(entity.ownable ? this.traitFields.ownable : []);
        entity.attributes = entity.attributes.concat(entity.peerReplicable ? this.traitFields.peerReplicable : []);
        // entity.attributes = entity.attributes.concat(entity.taggable ? this.traitFields.taggable as any[]: []);
        entity.attributes = entity.attributes.concat(entity.trackable ? this.traitFields.trackable : []);
        entity.attributes = entity.attributes.concat(entity.queueable ? this.traitFields.queueable : []);
        entity.attributes = entity.attributes.concat(entity.conditionalOwnable ? this.traitFields.conditionalOwnable : []);
        entity.attributes = entity.attributes.concat(entity.userOwnable ? this.traitFields.userOwnable : []);
    }
    setDisplayName(field, entity) {
        if (entity && entity.displayName) {
            field.displayTemplate = entity.displayName || '';
            field.defaultSort = field.defaultSort && entity.defaultSort ? entity.defaultSort : [];
            field.trackable = entity.trackable || false;
        }
        else {
            if (!field.displayTemplate) {
                field.displayTemplate = '';
            }
        }
        let value = entity.values[field.name];
        if (value && typeof (value) === 'object') {
            if (Array.isArray(value) && value.length > 0) {
                if (field.formType === Field.BuiltInType.TAGS) {
                    field.display = '';
                    value.forEach((item) => {
                        if (item.display === '') {
                            item.display = this.getEndPathNamePipe.transform(item);
                        }
                        else {
                            item.display = item.display + ', ' + this.getEndPathNamePipe.transform(item);
                        }
                    });
                }
                // else {//added for multislect picklist
                //   field.display = '';
                //   value.forEach((item) => {
                //     if (field.display === '') {
                //       value.display = this.interpolate.transform(field.displayTemplate, item);
                //     } else {
                //       value.display = value.display + ', ' + this.interpolate.transform(field.displayTemplate, item);
                //     }
                //   });
                // }
            }
            else {
                if (field.displayTemplate) {
                    value.display = this.interpolate.transform(field.displayTemplate, value);
                }
            }
        }
        return field;
    }
    getDisplayValue(entity, data) {
        return this.interpolate.transform(entity.displayName, data);
    }
    getDisplayFields(entity) {
        let displayNameRegex = /\{\{\s*(?<fieldName>\w+)\.?\w*\s*\}\}/g;
        let result, fields = [];
        while ((result = displayNameRegex.exec(entity.displayName)) !== null) {
            if (result?.groups?.fieldName) {
                fields.push(result.groups.fieldName);
            }
        }
        return fields;
    }
    applyValues(entity, fields, data) {
        forEach(data, (value, key) => {
            if (key.indexOf('@') !== 0 && !fields[key] && isArray(value)) {
                fields[key] = new Field(key, Field.BuiltInType.TEXT);
            }
        });
        forEach(fields, (field) => {
            if (data && !isUndefined(data[field.name]) && data[field.name] !== null) {
                var value = data[field.name];
                switch (field.formType) {
                    case Field.BuiltInType.INTEGER:
                    case Field.BuiltInType.DECIMAL:
                        value = parseFloat(value);
                        break;
                    case Field.BuiltInType.DATETIME:
                        value = this.unixToDatePipe.transform(value);
                        break;
                        // case 'date':
                        //  value = $filter('unixToDate')(value);
                        break;
                    // case 'object':
                    //   //https://stackoverflow.com/questions/5491605/empty-arrays-seem-to-equal-true-and-false-at-the-same-time
                    //   if(value == ""){// jshint ignore:line
                    //     value = {};
                    //   }
                    //   break;
                    default:
                        break;
                }
                //field.value = value;
                entity.values[field.name] = value;
            }
        });
        forEach(fields, (field) => {
            this.setDisplayName(field, entity);
        });
        return fields;
    }
    buildSearchQuery(fields, search) {
        let searchWords = search.match(/\w+/g);
        let andFilters = [];
        searchWords?.forEach((searchWord) => {
            let orFilters = [];
            fields.forEach((field) => {
                orFilters.push(new Filter(field, 'icontains', searchWord));
            });
            andFilters.push(new FilterGroup(orFilters, 'OR'));
        });
        let queryObject = {
            filters: andFilters,
            logic: 'AND'
        };
        if (andFilters.length === 1) {
            queryObject = andFilters[0];
        }
        let query = new Query(queryObject);
        return query;
    }
    buildSearchQueryFromDisplayName(entity, search) {
        let fields = [];
        const displayFieldMatches = entity.displayName.matchAll(/{{(?<type>[\s\S]+?)}}/g);
        for (const match of displayFieldMatches) {
            const requiredKey = match?.groups?.type.trim();
            if (requiredKey) {
                fields.push(requiredKey);
            }
        }
        return this.buildSearchQuery(fields, search);
    }
    createEntityFromData(inputData = {}, name = 'filterEntity') {
        const data = cloneDeep(inputData);
        let entity = new Entity(name);
        entity.attributes = [];
        let attr = {};
        forEach(data, (value, key) => {
            let dataType = this.utilityService.getFieldTypeByValue(value);
            let field = new ModuleAttributeMap[dataType].field(key);
            field.title = key;
            if (field.formType === 'json') {
                field.data = value;
            }
            attr[key] = field;
        });
        entity.fields = attr;
        entity.values = data;
        return entity;
    }
    static { this.ɵfac = function EntityService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EntityService)(i0.ɵɵinject(ModelMetadataService), i0.ɵɵinject(PermissionService), i0.ɵɵinject(UtilityService), i0.ɵɵinject(GetEndPathNamePipe), i0.ɵɵinject(InterpolatePipe), i0.ɵɵinject(UnixToDatePipe)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EntityService, factory: EntityService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EntityService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: ModelMetadataService }, { type: PermissionService }, { type: UtilityService }, { type: GetEndPathNamePipe }, { type: InterpolatePipe }, { type: UnixToDatePipe }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$g = ["searchInput"];
function LookupFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 8);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function LookupFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 9);
    i0.ɵɵelement(1, "i", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r1.field.tooltip);
} }
function LookupFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 5);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, LookupFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 6)(3, LookupFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", ctx_r1.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r1.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.tooltip);
} }
function LookupFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, LookupFieldComponent_div_0_label_1_Template, 4, 4, "label", 2);
    i0.ɵɵelementStart(2, "div", 3)(3, "xf-searchable-dropdown", 4);
    i0.ɵɵlistener("searchQueryChange", function LookupFieldComponent_div_0_Template_xf_searchable_dropdown_searchQueryChange_3_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.loadItems($event)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("items", ctx_r1.items)("buttonStyle", ctx_r1.field.params == null ? null : ctx_r1.field.params.style)("placeholder", ctx_r1.field.placeholder)("clearText", ctx_r1.field.params == null ? null : ctx_r1.field.params.clearText);
} }
class LookupFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, _formBuilder, interpolate) {
        super(_changeDetectorRef, _formBuilder);
        this.interpolate = interpolate;
        this.searchText = '';
        this.loading = false;
        this.searchQueryChange = new Subject();
        this.items = [];
        this.entityService = inject(EntityService);
        this.apiService = inject(ApiService);
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((item) => {
            this.value = item?.value || null;
        });
    }
    ngAfterViewInit() {
        if (this.field && this.field.model) {
            this.entityService.build(this.field.model).subscribe((entity) => {
                this.entity = entity;
                if (this._value) {
                    this.setDisplayValue(this._value);
                }
            });
        }
    }
    loadItems(search) {
        if (!this.field.dataSource) {
            console.warn('No model specified for lookup');
            return;
        }
        let queryObject = new Query({
            filters: [],
            logic: 'AND'
        });
        if (this.field.dataSource.query) {
            queryObject.filters.push(this.field.dataSource.query);
        }
        if (search) {
            let searchQuery = this.entityService.buildSearchQueryFromDisplayName(this.entity, search);
            queryObject.filters.push(searchQuery.asFilterGroup());
        }
        const query = plainToInstance(Query, queryObject);
        this.apiService.query(this.entity, query.getQueryObject(), {
            limit: DEFAULT_LOOKUP_RECORDS
        }).pipe(map((response) => {
            let data = response['hydra:member'];
            let searchableItems = data.map((item) => {
                const display = this.interpolate.transform(this.entity.displayName, item);
                return new SearchableItem(display, item, item.uuid);
            });
            return searchableItems;
        }))
            .subscribe((searchableItems) => {
            this.items = searchableItems;
            this.changeDetectorRef.detectChanges();
        });
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.setDisplayValue(value);
            this.onChange(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    writeValue(value) {
        this.value = value;
        this.setDisplayValue(value);
    }
    setDisplayValue(value) {
        if (value && this.entity) {
            const display = this.interpolate.transform(this.entity.displayName, value);
            this.fieldGroup?.get('input')?.setValue(new SearchableItem(display, value, value.uuid));
        }
    }
    selectItem(item) {
        this.value = item;
        this.inputField?.nativeElement.focus();
    }
    focus() {
        this.dropdown.focus();
    }
    static { this.ɵfac = function LookupFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LookupFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(InterpolatePipe)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LookupFieldComponent, selectors: [["xf-field-lookup"]], viewQuery: function LookupFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$g, 5);
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label", 3, "for", 4, "ngIf"], [1, "picklist-field-container"], ["container", "body", "formControlName", "input", 3, "searchQueryChange", "items", "buttonStyle", "placeholder", "clearText"], [1, "form-label", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"]], template: function LookupFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LookupFieldComponent_div_0_Template, 4, 6, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, SearchableDropdownComponent, i3.NgbTooltip] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LookupFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-lookup', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"field.name\" *ngIf=\"fieldOptions.showLabel\" class=\"form-label\">{{ field.title}}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"picklist-field-container\">\n    <xf-searchable-dropdown container=\"body\" formControlName=\"input\" [items]=\"items\"\n      (searchQueryChange)=\"loadItems($event)\" [buttonStyle]=\"field.params?.style\"\n      [placeholder]=\"field.placeholder\" [clearText]=\"field.params?.clearText\"></xf-searchable-dropdown>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: InterpolatePipe }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], dropdown: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LookupFieldComponent, { className: "LookupFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/lookup/lookup-field.component.ts", lineNumber: 26 }); })();

class ConnectorFieldRendererParameter {
    constructor(name, type, renderer_type) {
        this.title = '';
        this.description = '';
        this.tooltip = '';
        this.apiOperation = '';
        this.visible = true;
        this.editable = false;
        this.required = false;
        this.placeholder = '';
        this.options = [];
        this.onchange = {};
        this.name = name;
        this.formType = renderer_type || type;
    }
}
__decorate([
    Expose({ name: 'type' })
], ConnectorFieldRendererParameter.prototype, "formType", void 0);
__decorate([
    Transform(({ value }) => {
        let values = [];
        if (typeof value[0] === 'string') {
            forEach(value, (option) => {
                values.push({ label: option, value: option });
            });
            return values;
        }
        return value;
    }, { toClassOnly: true })
], ConnectorFieldRendererParameter.prototype, "options", void 0);
class ConnectorActionRendererField extends ConnectorFieldRendererParameter {
    constructor() {
        super(...arguments);
        this._jinjaEnabled = false;
        this.parameters = [];
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$f = a0 => ({ "margin-bottom-lg": a0 });
function FieldRendererComponent_div_0_div_1_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-field-renderer", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("parameters", actionField_r1.parameters)("fieldValues", ctx_r1.fieldValues)("enableRecordFields", ctx_r1.enableRecordFields)("ignoreRequired", ctx_r1.ignoreRequired)("enableJinja", ctx_r1.enableJinja)("connectorFormGroup", ctx_r1.connectorFormGroup);
} }
function FieldRendererComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3)(1, "div")(2, "form", 4);
    i0.ɵɵelement(3, "xf-form-field", 5, 0);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(5, FieldRendererComponent_div_0_div_1_div_5_Template, 2, 6, "div", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c0$f, actionField_r1.field.formType === ctx_r1.checkbox));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("formGroup", ctx_r1.connectorFormGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", actionField_r1.field)("formControlName", actionField_r1.field.name)("fieldClass", "form-control-sm margin-bottom-8px w-100");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", actionField_r1.parameters.length > 0);
} }
function FieldRendererComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, FieldRendererComponent_div_0_div_1_Template, 6, 8, "div", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", actionField_r1.visible);
} }
class FieldRendererComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.fieldValues = {};
        this.parameters = [];
        //@Input() fieldForm: FormGroup = new FormGroup({});
        this.formMode = 'add';
        this.ignoreRequired = false;
        this.enableJinja = false;
        //@Input() focusMethod: any;
        //@Input() fieldModifyFunc: any;
        this.onFieldChange = new EventEmitter();
        this.actionFields = [];
        this.actionFieldsToRender = [];
        this.checkbox = Field.BuiltInType.SELECT;
        this.deletedParams = [];
        this.emitted = false;
        this.error = false;
        this.formControlNames = [];
    }
    ngOnChanges(changes) {
        if ((changes.parameters && !changes.parameters.firstChange) || (changes.fieldValues && !changes.fieldValues.firstChange)) {
            this.transformFields();
        }
    }
    ngOnInit() {
        this.connectorFormGroup = this.connectorFormGroup || new FormGroup({});
        this.transformFields();
    }
    ngOnDestroy() {
        this.removeExistingFormControls();
    }
    transformFields() {
        this.actionFields = plainToInstance(ConnectorFieldRendererParameter, this.parameters || []);
        this.actionFieldsToRender = [];
        this.removeExistingFormControls();
        this.changeDetectorRef.detectChanges();
        this.actionFields.forEach((actionField, index) => {
            let field = this.createField(actionField);
            let parameters = [];
            if (isUndefined(this.fieldValues[actionField.name]) && !isUndefined(actionField.value)) {
                this.fieldValues[actionField.name] = actionField.value;
            }
            this.fieldValues[actionField.name] = isUndefined(this.fieldValues[actionField.name]) ? (actionField.formType === Field.BuiltInType.CHECKBOX ? false : '') : this.fieldValues[actionField.name];
            if (Object.keys(actionField.onchange).length > 0) {
                let value = isUndefined(this.fieldValues[actionField.name]) ? actionField.value : this.fieldValues[actionField.name];
                if (actionField.formType === Field.BuiltInType.MULTISELECT && isArray(value)) {
                    value.forEach((selected) => {
                        if (actionField.onchange[selected]) {
                            parameters = parameters.concat(actionField.onchange[selected] || []);
                        }
                    });
                }
                else {
                    parameters = !isUndefined(value) && actionField.onchange[value] ? actionField.onchange[value] : [];
                }
            }
            let value = isUndefined(this.fieldValues[actionField.name]) ? (actionField.value || '') : this.fieldValues[actionField.name];
            let validators = actionField.required ? [Validators.required] : [];
            let formControl = new FormControl(value, validators);
            this.connectorFormGroup.addControl(actionField.name, formControl);
            this.formControlNames.push(actionField.name);
            this.parameters[index].value = value;
            this.connectorFormGroup.controls[actionField.name].valueChanges.pipe(debounceTime$1(300)).subscribe((value) => {
                this.parameters[index].value = value;
                this.setOnValuechanges(value, actionField, this.actionFieldsToRender[index]);
            });
            this.fetchOperationData(actionField);
            let obj = ___default.merge(actionField, { field: field, parameters: parameters });
            this.actionFieldsToRender.push(obj);
        });
    }
    //TODO: Need to implement for apiOperation
    fetchOperationData(field) {
        // if(field.apiOperation && (CommonUtils.isUndefined(field.processing) || field.processing === false)){
        //   field.processing = true;
        //   var argument = angular.copy(scope.connectorData);
        //   argument.targetField = field.name;
        //   argument.operation = field.apiOperation;
        //   argument.params = scope.params;
        //   scope.error = undefined;
        //   connectorService.getFieldData(argument).then(function(data) {
        //      if(data.id){
        //          websocketService.subscribe(data.id, function (result) {
        //            processOnApiChangeData(result, field);
        //            if (actionTimeout) {
        //              $timeout.cancel(actionTimeout);
        //            }
        //            actionSubscription = undefined;
        //            field.processing = false;
        //          }).then(function (sub) {
        //            actionSubscription = sub;
        //            setActionTimeout(field);
        //          }, function (error) {
        //              scope.error = error.data.message;
        //              field.processing = false;
        //          });
        //      }else{
        //        field.processing = false;
        //        processOnApiChangeData(data, field);
        //      }
        //     }, function (error) {
        //       field.processing = false;
        //       scope.error = error.data.message;
        //     });
        // }else{
        //   if(!CommonUtils.isUndefined(field.value) && field.value!==''){
        //    scope.onChange(field.value,field, true);
        //   }
        // }
        // if(scope.fieldModifyFunc){
        //   scope.fieldModifyFunc(field);
        // }
    }
    //TODO: Need to implment for apiOperation
    processOnApiChangeData(processeData, field) {
        // var dataTemplate = {};
        // if (field.apiOnchange) {
        //   dataTemplate = processeData.data;
        //   for (var key in dataTemplate) {
        //     if (key !== 'value') {
        //       field[key] = dataTemplate[key];
        //     }
        //   }
        // }
        // else {
        //   field.options = processeData.data;
        // }
        // if (!CommonUtils.isUndefined(field.value) && field.value !== '') {
        //   scope.onChange(field.value, field);
        // }
    }
    createField(action) {
        let field = new ModuleAttributeMap[action.formType].field(action.name);
        field.title = action.title;
        field.descriptions.singular = action.description;
        field.tooltip = action.tooltip;
        field.visible = action.visible;
        field.editable = action.editable;
        field.enableJinja = this.enableJinja;
        field.placeholder = action.placeholder;
        field.validation.required = this.ignoreRequired ? false : action.required;
        if (action.formType === Field.BuiltInType.SELECT || action.formType === Field.BuiltInType.MULTISELECT) {
            field.options = action.options;
        }
        if (action.formType === Field.BuiltInType.JSON) {
            field.modes = ['code', 'view'];
        }
        return field;
    }
    setOnValuechanges(value, actionField, renderField) {
        let parameters = [];
        if (Object.keys(actionField.onchange).length > 0) {
            this.deletedParams = [];
            this.deleteFieldParameters(renderField);
            if (actionField.formType === Field.BuiltInType.MULTISELECT && isArray(value)) {
                value.forEach((selected) => {
                    if (actionField.onchange[selected]) {
                        parameters = parameters.concat(actionField.onchange[selected] || []);
                    }
                });
            }
            else {
                parameters = actionField.onchange[value] || [];
            }
            renderField.parameters = parameters;
            this.changeDetectorRef.detectChanges();
        }
        this.fieldValues[actionField.name] = value;
        this.onFieldChange.emit(this.fieldValues);
    }
    deleteFieldParameters(field) {
        forEach(field.parameters, (param) => {
            if (param.onchange) {
                if (param.parameters) {
                    this.deleteFieldParameters(param);
                }
                else if (param.value) {
                    let tempField = {
                        parameters: param.onchange[param.value] || []
                    };
                    this.deleteFieldParameters(tempField);
                }
            }
            this.deletedParams.push(param.name);
            delete this.fieldValues[param.name];
        });
        return this.deletedParams;
    }
    removeExistingFormControls() {
        this.formControlNames.forEach((key) => {
            this.connectorFormGroup.removeControl(key, { emitEvent: false });
        });
        this.formControlNames = [];
    }
    focusOnFirstInvalidInput() {
        this.connectorFormGroup.markAllAsTouched();
        for (let formField of this.formFields) {
            if (!formField.valid) {
                formField.focus();
                return true;
            }
        }
        return false;
    }
    static { this.ɵfac = function FieldRendererComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldRendererComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldRendererComponent, selectors: [["xf-field-renderer"]], viewQuery: function FieldRendererComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, inputs: { fieldValues: "fieldValues", parameters: "parameters", formMode: "formMode", ignoreRequired: "ignoreRequired", enableJinja: "enableJinja", enableRecordFields: "enableRecordFields", connectorFormGroup: "connectorFormGroup" }, outputs: { onFieldChange: "onFieldChange" }, features: [i0.ɵɵNgOnChangesFeature], decls: 1, vars: 1, consts: [["formField", ""], [4, "ngFor", "ngForOf"], ["class", "form-group margin-top-10px", 3, "ngClass", 4, "ngIf"], [1, "form-group", "margin-top-10px", 3, "ngClass"], [3, "formGroup"], [3, "field", "formControlName", "fieldClass"], [4, "ngIf"], [3, "parameters", "fieldValues", "enableRecordFields", "ignoreRequired", "enableJinja", "connectorFormGroup"]], template: function FieldRendererComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FieldRendererComponent_div_0_Template, 2, 1, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngForOf", ctx.actionFieldsToRender);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FormFieldComponent, FieldRendererComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldRendererComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-renderer', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *ngFor=\"let actionField of actionFieldsToRender;\">\n  <div class=\"form-group margin-top-10px\" *ngIf=\"actionField.visible\"\n    [ngClass]=\"{'margin-bottom-lg': actionField.field.formType === checkbox}\">\n    <div>\n      <form [formGroup]=\"connectorFormGroup\">\n        <xf-form-field [field]=\"actionField.field\" #formField [formControlName]=\"actionField.field.name\"\n          [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\"></xf-form-field>\n      </form>\n      <!-- <span class='fa fa-refresh fa-spin margin-left-8px active-color' *ngIf=\"field.processing\"></span> -->\n    </div>\n    <div *ngIf=\"actionField.parameters.length > 0\">\n      <xf-field-renderer [parameters]=\"actionField.parameters\" [fieldValues]=\"fieldValues\"\n        [enableRecordFields]=\"enableRecordFields\" [ignoreRequired]=\"ignoreRequired\"\n        [enableJinja]=\"enableJinja\" [connectorFormGroup]=\"connectorFormGroup\"></xf-field-renderer>\n    </div>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }], { fieldValues: [{
            type: Input
        }], parameters: [{
            type: Input
        }], formMode: [{
            type: Input
        }], ignoreRequired: [{
            type: Input
        }], enableJinja: [{
            type: Input
        }], enableRecordFields: [{
            type: Input
        }], onFieldChange: [{
            type: Output
        }], formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }], connectorFormGroup: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldRendererComponent, { className: "FieldRendererComponent", filePath: "lib/form-fields/field-renderer/field-renderer.component.ts", lineNumber: 22 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$e = (a0, a1) => ({ "margin-right-40px": a0, "form-check-inline": a1 });
function RadioFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 10);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function RadioFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵelement(1, "i", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function RadioFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 7);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, RadioFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 8)(3, RadioFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 9);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function RadioFieldComponent_div_0_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 13);
    i0.ɵɵelement(1, "input", 14, 0);
    i0.ɵɵelementStart(3, "label", 15);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const option_r2 = ctx.$implicit;
    const lastOption_r3 = ctx.last;
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(6, _c0$e, !lastOption_r3, (ctx_r0.field.params == null ? null : ctx_r0.field.params.style) !== "vertical"));
    i0.ɵɵadvance();
    i0.ɵɵproperty("id", "input-" + option_r2.name)("value", option_r2.value)("checked", ctx_r0.value === option_r2.value);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("for", "input-" + option_r2.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r2.name);
} }
function RadioFieldComponent_div_0_xf_form_messages_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 16);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
function RadioFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, RadioFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "div", 4);
    i0.ɵɵtemplate(3, RadioFieldComponent_div_0_div_3_Template, 5, 9, "div", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(4, RadioFieldComponent_div_0_xf_form_messages_4_Template, 1, 1, "xf-form-messages", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r0.field.options);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
} }
class RadioFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, _formBuilder, themeService) {
        super(_changeDetectorRef, _formBuilder);
        this._changeDetectorRef = _changeDetectorRef;
        this._formBuilder = _formBuilder;
        this.themeService = themeService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngAfterViewInit() {
        if (!this.field) {
            return;
        }
        this.value = isUndefined(this.value) ? this.field.options[0].value : this.value;
        this.fieldGroup?.valueChanges
            .pipe(map$1(values => values.input))
            .subscribe((value) => {
            this.value = value;
        });
    }
    static { this.ɵfac = function RadioFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || RadioFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RadioFieldComponent, selectors: [["xf-radio-field"]], inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["inputField", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "form-check"], [3, "ngClass", 4, "ngFor", "ngForOf"], [3, "control", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "ngClass"], ["formControlName", "input", "mdbRadio", "", "type", "radio", 1, "form-check-input", 3, "id", "value", "checked"], [1, "content-font", "margin-left-6px", "form-check-label", 3, "for"], [3, "control"]], template: function RadioFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, RadioFieldComponent_div_0_Template, 5, 4, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.DefaultValueAccessor, i2.RadioControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, FormMessagesComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RadioFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-radio-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"form-check\">\n    <div *ngFor=\"let option of field.options; let lastOption = last; let firstOption = first; let i = index;\"\n      [ngClass]=\"{'margin-right-40px' : !lastOption, 'form-check-inline' :field.params?.style !== 'vertical'}\">\n      <input formControlName=\"input\" [id]=\"'input-' + option.name\" #inputField mdbRadio type=\"radio\"\n        [value]=\"option.value\" class=\"form-check-input\" [checked]=\"value === option.value\">\n      <label [for]=\"'input-' + option.name\" class=\"content-font margin-left-6px form-check-label\">{{option.name}}</label>\n    </div>\n  </div>\n  <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: ThemeService }], { field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(RadioFieldComponent, { className: "RadioFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/radio/radio-field.component.ts", lineNumber: 19 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$d = ["searchInput"];
const _c1$8 = a0 => ({ "d-inline-block me-2 mb-2": a0 });
const _c2$5 = a0 => ({ "checked": a0 });
function MultiSelectCheckboxDropdownFieldComponent_div_0_span_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.checkedList.join(", "));
} }
function MultiSelectCheckboxDropdownFieldComponent_div_0_span_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("(", ctx_r1.checkedList.length, ")");
} }
function MultiSelectCheckboxDropdownFieldComponent_div_0_li_20_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "li", 12)(1, "label", 13)(2, "a", 19);
    i0.ɵɵlistener("keydown.arrowup", function MultiSelectCheckboxDropdownFieldComponent_div_0_li_20_Template_a_keydown_arrowup_2_listener() { const i_r5 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.focusOnItem(i_r5)); })("keydown.arrowdown", function MultiSelectCheckboxDropdownFieldComponent_div_0_li_20_Template_a_keydown_arrowdown_2_listener() { const i_r5 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.focusOnItem(i_r5 + 2)); })("keydown.enter", function MultiSelectCheckboxDropdownFieldComponent_div_0_li_20_Template_a_keydown_enter_2_listener($event) { const option_r6 = i0.ɵɵrestoreView(_r4).$implicit; const ctx_r1 = i0.ɵɵnextContext(2); $event.preventDefault(); return i0.ɵɵresetView(ctx_r1.selectOption(option_r6)); });
    i0.ɵɵelement(3, "input", 20);
    i0.ɵɵelementStart(4, "span", 16);
    i0.ɵɵtext(5);
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    let tmp_7_0;
    const option_r6 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("for", "option-" + option_r6.value);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(5, _c2$5, (tmp_7_0 = ctx_r1.fieldGroup.get("options")) == null ? null : (tmp_7_0 = tmp_7_0.get("option-" + option_r6.value)) == null ? null : tmp_7_0.value));
    i0.ɵɵadvance();
    i0.ɵɵproperty("formControlName", "option-" + option_r6.value)("id", "option-" + option_r6.value);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(option_r6.label);
} }
function MultiSelectCheckboxDropdownFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 3)(1, "div", 4, 0);
    i0.ɵɵlistener("openChange", function MultiSelectCheckboxDropdownFieldComponent_div_0_Template_div_openChange_1_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onOpen($event)); });
    i0.ɵɵelementStart(3, "a", 5);
    i0.ɵɵlistener("focus", function MultiSelectCheckboxDropdownFieldComponent_div_0_Template_a_focus_3_listener() { i0.ɵɵrestoreView(_r1); const multiSelectDrop_r3 = i0.ɵɵreference(2); return i0.ɵɵresetView(multiSelectDrop_r3.open()); });
    i0.ɵɵelement(4, "i", 6);
    i0.ɵɵelementStart(5, "span", 7);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, MultiSelectCheckboxDropdownFieldComponent_div_0_span_7_Template, 2, 1, "span", 8)(8, MultiSelectCheckboxDropdownFieldComponent_div_0_span_8_Template, 2, 1, "span", 8);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "ul", 9)(10, "div", 10)(11, "input", 11, 1);
    i0.ɵɵlistener("keyup.arrowdown", function MultiSelectCheckboxDropdownFieldComponent_div_0_Template_input_keyup_arrowdown_11_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.focusOnItem(0)); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(13, "li", 12)(14, "label", 13)(15, "a", 14);
    i0.ɵɵlistener("keydown.arrowup", function MultiSelectCheckboxDropdownFieldComponent_div_0_Template_a_keydown_arrowup_15_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.focusOnItem(-1)); })("keydown.arrowdown", function MultiSelectCheckboxDropdownFieldComponent_div_0_Template_a_keydown_arrowdown_15_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.focusOnItem(1)); })("keydown.enter", function MultiSelectCheckboxDropdownFieldComponent_div_0_Template_a_keydown_enter_15_listener($event) { let tmp_5_0; i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); $event.preventDefault(); return i0.ɵɵresetView((tmp_5_0 = ctx_r1.fieldGroup.get("checkAll")) == null ? null : tmp_5_0.setValue(!((tmp_5_0 = ctx_r1.fieldGroup.get("checkAll")) == null ? null : tmp_5_0.value))); });
    i0.ɵɵelement(16, "input", 15);
    i0.ɵɵelementStart(17, "span", 16);
    i0.ɵɵtext(18);
    i0.ɵɵelementEnd()()()();
    i0.ɵɵelementContainerStart(19, 17);
    i0.ɵɵtemplate(20, MultiSelectCheckboxDropdownFieldComponent_div_0_li_20_Template, 6, 7, "li", 18);
    i0.ɵɵelementContainerEnd();
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    let tmp_13_0;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.fieldGroup)("ngClass", i0.ɵɵpureFunction1(16, _c1$8, ctx_r1.field.showInline));
    i0.ɵɵadvance(3);
    i0.ɵɵpropertyInterpolate1("id", "multiSelectDropdown-", ctx_r1.field.name, "");
    i0.ɵɵproperty("ngClass", ctx_r1.checkedList.length > 0 ? "btn-secondary" : "btn-default");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", ctx_r1.checkedList.length > 0 ? "muted-10" : "muted-80");
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.field.selectText);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.checkedList.length > 0 && ctx_r1.field.showSelectedList);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.checkedList.length > 0 && !ctx_r1.field.showSelectedList);
    i0.ɵɵadvance();
    i0.ɵɵattributeInterpolate1("aria-labelledby", "multiSelectDropdown-", ctx_r1.field.name, "");
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("for", "check-all-" + ctx_r1.field.name);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(18, _c2$5, (tmp_13_0 = ctx_r1.fieldGroup.get("checkAll")) == null ? null : tmp_13_0.value));
    i0.ɵɵadvance();
    i0.ɵɵproperty("id", "check-all-" + ctx_r1.field.name);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1("All (", ctx_r1.field.options.length, ")");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.filteredOptions);
} }
class MultiSelectCheckboxDropdownFieldComponent extends AbstractFieldComponent {
    // fieldGroup: FormGroup;
    constructor(_changeDetectorRef, formBuilder) {
        super(_changeDetectorRef, formBuilder);
        this._changeDetectorRef = _changeDetectorRef;
        this.checkedList = [];
        this.searchText = '';
        this.filteredOptions = [];
        this.loading = true;
    }
    writeValue(value) {
        this.checkedList = value;
        if (this.fieldGroup) {
            const optionsGroup = this.fieldGroup?.get('options');
            keys(optionsGroup.controls).forEach((controlKey) => {
                optionsGroup.get(controlKey)?.setValue(this.checkedList.find((item) => item.value === controlKey.replace('option-', '')), { emitEvent: false });
            });
            this.updateCheckAll();
        }
    }
    updateCheckAll() {
        const allChecked = this.checkedList.length === this.field.options.length;
        this.fieldGroup?.get('checkAll')?.setValue(allChecked, { emitEvent: false });
    }
    ngOnInit() {
        this.fieldGroup = this.formBuilder.group({
            checkAll: [false],
            options: this.formBuilder.group([]),
            search: ['']
        });
        this.filteredOptions = cloneDeep(this.field.options);
        this.field.options.forEach((option, index) => {
            const optionsGroup = this.fieldGroup?.get('options');
            const checkedItem = this.checkedList.find((item) => item.value === option.value);
            optionsGroup.addControl('option-' + option.value, new FormControl(!!checkedItem));
        });
        this.updateCheckAll();
        this.changeDetectorRef.detectChanges();
    }
    ngAfterViewInit() {
        this.dropdown.autoClose = 'outside';
        this.fieldGroup?.get('options')?.valueChanges.subscribe((data) => {
            this.checkedList = this.field.options.filter((option) => data['option-' + option.value]);
            this.value = cloneDeep(this.checkedList);
            const allChecked = this.checkedList.length === this.field.options.length;
            this.fieldGroup?.get('checkAll')?.setValue(allChecked, { emitEvent: false });
            this.changeDetectorRef.detectChanges();
        });
        this.fieldGroup?.get('checkAll')?.valueChanges.subscribe((checkAll) => {
            if (checkAll) {
                this.checkedList = this.field.options;
            }
            else {
                this.checkedList = [];
            }
            const optionsGroup = this.fieldGroup?.get('options');
            keys(optionsGroup.controls).forEach((controlKey) => {
                optionsGroup.get(controlKey)?.setValue(checkAll, { emitEvent: false });
            });
            this.value = cloneDeep(this.checkedList);
            this.changeDetectorRef.detectChanges();
        });
        this.fieldGroup?.get('search')?.valueChanges.pipe(debounceTime$1(300)).subscribe((searchText) => {
            this.searchText = searchText;
            this.filteredOptions = this.field.options.filter((option) => option.label.toLowerCase().indexOf(this.searchText.toLowerCase()) > -1);
            this.changeDetectorRef.detectChanges();
        });
        if (!this.field) {
            return;
        }
    }
    focusOnSearchInput() {
        setTimeout(() => {
            this.searchInput.nativeElement.focus();
            this.searchInput.nativeElement.select();
        });
    }
    focusOnItem(index) {
        if (index === -1) {
            this.focusOnSearchInput();
        }
        this.dropdownItems.get(index)?.nativeElement.focus();
    }
    onOpen(opened) {
        if (opened) {
            this.focusOnSearchInput();
        }
    }
    selectOption(option) {
        const control = this.fieldGroup?.get('options')?.get('option-' + option.value);
        control?.setValue(!control.value);
    }
    static { this.ɵfac = function MultiSelectCheckboxDropdownFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || MultiSelectCheckboxDropdownFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiSelectCheckboxDropdownFieldComponent, selectors: [["xf-multi-select-checkbox-dropdown-field"]], viewQuery: function MultiSelectCheckboxDropdownFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$d, 5);
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(NgbDropdownItem, 5, ElementRef);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownItems = _t);
        } }, inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["multiSelectDrop", "ngbDropdown"], ["searchInput", ""], ["class", "form-group w-fit-content multi-select-dropdown-checkbox-container", 3, "formGroup", "ngClass", 4, "ngIf"], [1, "form-group", "w-fit-content", "multi-select-dropdown-checkbox-container", 3, "formGroup", "ngClass"], ["ngbDropdown", "", "container", "body", 1, "dropdown", 3, "openChange"], ["role", "button", "ngbDropdownAnchor", "", "ngbDropdownToggle", "", 1, "btn", "dropdown-toggle", "content-font", "btn-sm", 3, "focus", "ngClass", "id"], [1, "fa", "fa-check-circle", "margin-right-8px", 3, "ngClass"], [1, "margin-right-4px"], [4, "ngIf"], ["ngbDropdownMenu", "", 1, "dropdown-menu", "shadow"], [1, "margin-left-12px", "margin-right-12px", "margin-bottom-12px"], ["type", "search", "id", "searchDropdown", "placeholder", "Search", "autocomplete", "off", "formControlName", "search", 1, "form-control", "lookup-search", "form-control-sm", 3, "keyup.arrowdown"], [1, "list-unstyled"], [1, "d-block", 3, "for"], ["tabindex", "1", "ngbDropdownItem", "", 1, "p-2", "dropdown-item", "text-start", "w-100", "content-font", "cursor-pointer", 3, "keydown.arrowup", "keydown.arrowdown", "keydown.enter", "ngClass"], ["type", "checkbox", "formControlName", "checkAll", 1, "form-check-input", 3, "id"], [1, "ms-2"], ["formGroupName", "options"], ["class", "list-unstyled", 4, "ngFor", "ngForOf"], ["tabindex", "1", "ngbDropdownItem", "", 1, "p-2", "text-start", "w-100", "content-font", "cursor-pointer", 3, "keydown.arrowup", "keydown.arrowdown", "keydown.enter", "ngClass"], ["type", "checkbox", 1, "form-check-input", 3, "formControlName", "id"]], template: function MultiSelectCheckboxDropdownFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, MultiSelectCheckboxDropdownFieldComponent_div_0_Template, 21, 20, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.DefaultValueAccessor, i2.CheckboxControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i2.FormGroupName, i3.NgbDropdown, i3.NgbDropdownAnchor, i3.NgbDropdownToggle, i3.NgbDropdownMenu, i3.NgbDropdownItem], styles: [".multi-select-dropdown-checkbox-container[_ngcontent-%COMP%]   .dropdown[_ngcontent-%COMP%]   .dropdown-toggle[_ngcontent-%COMP%]{transition:content .4s ease-in-out}.multi-select-dropdown-checkbox-container[_ngcontent-%COMP%]   .dropdown[_ngcontent-%COMP%]   .dropdown-item[_ngcontent-%COMP%]{border-left:2px solid transparent}.multi-select-dropdown-checkbox-container[_ngcontent-%COMP%]   .dropdown[_ngcontent-%COMP%]   .dropdown-item.checked[_ngcontent-%COMP%]{border-left-color:var(--highlight-active-color);background-color:var(--highlight-default-color)}.multi-select-dropdown-checkbox-container[_ngcontent-%COMP%]   .dropdown[_ngcontent-%COMP%]   .dropdown-item[_ngcontent-%COMP%]:hover, .multi-select-dropdown-checkbox-container[_ngcontent-%COMP%]   .dropdown[_ngcontent-%COMP%]   .dropdown-item[_ngcontent-%COMP%]:focus{background-color:var(--highlight-active-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiSelectCheckboxDropdownFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-multi-select-checkbox-dropdown-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group w-fit-content multi-select-dropdown-checkbox-container\" *ngIf=\"fieldGroup\"\n  [formGroup]=\"fieldGroup\" [ngClass]=\"{'d-inline-block me-2 mb-2' : field.showInline}\">\n  <div class=\"dropdown\" ngbDropdown #multiSelectDrop=\"ngbDropdown\" (openChange)=\"onOpen($event)\" container=\"body\">\n    <a class=\"btn dropdown-toggle content-font btn-sm\" [ngClass]=\"checkedList.length > 0 ? 'btn-secondary' : 'btn-default'\"\n      role=\"button\" id=\"multiSelectDropdown-{{field.name}}\" ngbDropdownAnchor (focus)=\"multiSelectDrop.open()\"\n      ngbDropdownToggle>\n      <i class=\"fa fa-check-circle margin-right-8px\" [ngClass]=\"checkedList.length > 0 ? 'muted-10' : 'muted-80'\"></i>\n      <span class=\"margin-right-4px\">{{field.selectText}}</span>\n      <span *ngIf=\"checkedList.length > 0 && field.showSelectedList\">{{checkedList.join(', ')}}</span>\n      <span *ngIf=\"checkedList.length > 0 && !field.showSelectedList\">({{checkedList.length}})</span>\n    </a>\n    <ul class=\"dropdown-menu shadow\" ngbDropdownMenu attr.aria-labelledby=\"multiSelectDropdown-{{field.name}}\">\n      <div class=\"margin-left-12px margin-right-12px margin-bottom-12px\">\n        <input type=\"search\" class=\"form-control lookup-search form-control-sm\" id=\"searchDropdown\" #searchInput\n          placeholder=\"Search\" (keyup.arrowdown)=\"focusOnItem(0)\" autocomplete=\"off\" formControlName=\"search\">\n      </div>\n      <li class=\"list-unstyled\">\n        <label [for]=\"'check-all-' + field.name\" class=\"d-block\">\n          <a class=\"p-2 dropdown-item text-start w-100 content-font cursor-pointer\" (keydown.arrowup)=\"focusOnItem(-1)\"\n            (keydown.arrowdown)=\"focusOnItem(1)\"\n            (keydown.enter)=\"$event.preventDefault();fieldGroup.get('checkAll')?.setValue(!fieldGroup.get('checkAll')?.value)\"\n            tabindex=\"1\" ngbDropdownItem [ngClass]=\"{'checked': fieldGroup.get('checkAll')?.value}\">\n            <input type=\"checkbox\" class=\"form-check-input\" formControlName=\"checkAll\"\n              [id]=\"'check-all-' + field.name\" />\n            <span class=\"ms-2\">All ({{ field.options.length }})</span>\n          </a>\n        </label>\n      </li>\n      <ng-container formGroupName=\"options\">\n        <li *ngFor=\"let option of filteredOptions; let i = index;\" class=\"list-unstyled\">\n          <label [for]=\"'option-' + option.value\" class=\"d-block\">\n            <a class=\"p-2 text-start w-100 content-font cursor-pointer\" tabindex=\"1\" (keydown.arrowup)=\"focusOnItem(i)\"\n              (keydown.arrowdown)=\"focusOnItem(i + 2)\" (keydown.enter)=\"$event.preventDefault();selectOption(option)\"\n              [ngClass]=\"{'checked': fieldGroup.get('options')?.get('option-' + option.value)?.value}\" ngbDropdownItem>\n              <input type=\"checkbox\" class=\"form-check-input\" [formControlName]=\"'option-' + option.value\"\n                [id]=\"'option-' + option.value\" />\n              <span class=\"ms-2\">{{option.label}}</span>\n            </a>\n          </label>\n        </li>\n      </ng-container>\n    </ul>\n  </div>\n</div>\n", styles: [".multi-select-dropdown-checkbox-container .dropdown .dropdown-toggle{transition:content .4s ease-in-out}.multi-select-dropdown-checkbox-container .dropdown .dropdown-item{border-left:2px solid transparent}.multi-select-dropdown-checkbox-container .dropdown .dropdown-item.checked{border-left-color:var(--highlight-active-color);background-color:var(--highlight-default-color)}.multi-select-dropdown-checkbox-container .dropdown .dropdown-item:hover,.multi-select-dropdown-checkbox-container .dropdown .dropdown-item:focus{background-color:var(--highlight-active-color)}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], dropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], dropdownItems: [{
            type: ViewChildren,
            args: [NgbDropdownItem, { read: ElementRef }]
        }], field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(MultiSelectCheckboxDropdownFieldComponent, { className: "MultiSelectCheckboxDropdownFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/multi-select-checkbox-dropdown/multi-select-checkbox-dropdown-field.component.ts", lineNumber: 19 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class MultiSelectCheckboxDropdownViewComponent extends AbstractViewComponent {
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵMultiSelectCheckboxDropdownViewComponent_BaseFactory; return function MultiSelectCheckboxDropdownViewComponent_Factory(__ngFactoryType__) { return (ɵMultiSelectCheckboxDropdownViewComponent_BaseFactory || (ɵMultiSelectCheckboxDropdownViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(MultiSelectCheckboxDropdownViewComponent)))(__ngFactoryType__ || MultiSelectCheckboxDropdownViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiSelectCheckboxDropdownViewComponent, selectors: [["xf-multi-select-checkbox-dropdown-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 0, template: function MultiSelectCheckboxDropdownViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "p");
            i0.ɵɵtext(1, "multi-select-checkbox-dropdown works!");
            i0.ɵɵelementEnd();
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiSelectCheckboxDropdownViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-multi-select-checkbox-dropdown-view', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p>multi-select-checkbox-dropdown works!</p>" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(MultiSelectCheckboxDropdownViewComponent, { className: "MultiSelectCheckboxDropdownViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/multi-select-checkbox-dropdown/multi-select-checkbox-dropdown-view.component.ts", lineNumber: 14 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class RadioViewComponent extends AbstractViewComponent {
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵRadioViewComponent_BaseFactory; return function RadioViewComponent_Factory(__ngFactoryType__) { return (ɵRadioViewComponent_BaseFactory || (ɵRadioViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(RadioViewComponent)))(__ngFactoryType__ || RadioViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RadioViewComponent, selectors: [["xf-tags-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 0, template: function RadioViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "p");
            i0.ɵɵtext(1, "radio-view works!");
            i0.ɵɵelementEnd();
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RadioViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-tags-view', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p>radio-view works!</p>\n" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(RadioViewComponent, { className: "RadioViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/radio/radio-view.component.ts", lineNumber: 14 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$c = a0 => ({ "d-inline-block": a0 });
const _c1$7 = a0 => ({ "is-invalid": a0 });
function ToggleFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 8);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function ToggleFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 9);
    i0.ɵɵelement(1, "i", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function ToggleFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 5);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, ToggleFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 6)(3, ToggleFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(4, _c0$c, (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) !== "toggle"));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function ToggleFieldComponent_div_0_div_2_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 17);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff);
} }
function ToggleFieldComponent_div_0_div_2_label_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 18);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn);
} }
function ToggleFieldComponent_div_0_div_2_label_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 19);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.fieldGroup.controls.input.value ? ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn : ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff);
} }
function ToggleFieldComponent_div_0_div_2_div_5_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 24);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff);
} }
function ToggleFieldComponent_div_0_div_2_div_5_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn);
} }
function ToggleFieldComponent_div_0_div_2_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 20)(1, "div", 21);
    i0.ɵɵtemplate(2, ToggleFieldComponent_div_0_div_2_div_5_div_2_Template, 2, 1, "div", 22)(3, ToggleFieldComponent_div_0_div_2_div_5_div_3_Template, 2, 1, "div", 23);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn);
} }
function ToggleFieldComponent_div_0_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 11);
    i0.ɵɵtemplate(1, ToggleFieldComponent_div_0_div_2_label_1_Template, 2, 2, "label", 12);
    i0.ɵɵelement(2, "input", 13);
    i0.ɵɵtemplate(3, ToggleFieldComponent_div_0_div_2_label_3_Template, 2, 2, "label", 14)(4, ToggleFieldComponent_div_0_div_2_label_4_Template, 2, 2, "label", 15)(5, ToggleFieldComponent_div_0_div_2_div_5_Template, 4, 2, "div", 16);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) === "toggle" ? "form-check form-switch align-items-center padding-left-12px" : "custom-toggle-button-type padding-right-12px rounded-4px margin-left-12px");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) !== "toggle" && (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c1$7, ctx_r0.fieldGroup.controls.input.invalid))("id", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) !== "toggle" && (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) === "toggle");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) !== "toggle");
} }
function ToggleFieldComponent_div_0_div_3_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 19);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.fieldGroup.controls.input.value ? ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn : ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff);
} }
function ToggleFieldComponent_div_0_div_3_label_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 17);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn);
} }
function ToggleFieldComponent_div_0_div_3_label_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 18);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff);
} }
function ToggleFieldComponent_div_0_div_3_div_5_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn);
} }
function ToggleFieldComponent_div_0_div_3_div_5_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff);
} }
function ToggleFieldComponent_div_0_div_3_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 20)(1, "div", 21);
    i0.ɵɵtemplate(2, ToggleFieldComponent_div_0_div_3_div_5_div_2_Template, 2, 1, "div", 23)(3, ToggleFieldComponent_div_0_div_3_div_5_div_3_Template, 2, 1, "div", 23);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff);
} }
function ToggleFieldComponent_div_0_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 25);
    i0.ɵɵtemplate(1, ToggleFieldComponent_div_0_div_3_label_1_Template, 2, 2, "label", 15)(2, ToggleFieldComponent_div_0_div_3_label_2_Template, 2, 2, "label", 12);
    i0.ɵɵelement(3, "input", 13);
    i0.ɵɵtemplate(4, ToggleFieldComponent_div_0_div_3_label_4_Template, 2, 2, "label", 14)(5, ToggleFieldComponent_div_0_div_3_div_5_Template, 4, 2, "div", 16);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) === "toggle" ? "form-check form-switch align-items-center padding-left-0px" : "custom-toggle-button-type padding-right-12px margin-left-12px");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) === "toggle");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) !== "toggle" && (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOn));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c1$7, ctx_r0.fieldGroup.controls.input.invalid))("id", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) !== "toggle" && (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOff));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.style) !== "toggle");
} }
function ToggleFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, ToggleFieldComponent_div_0_label_1_Template, 4, 6, "label", 2)(2, ToggleFieldComponent_div_0_div_2_Template, 6, 9, "div", 3)(3, ToggleFieldComponent_div_0_div_3_Template, 6, 9, "div", 4);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵclassMapInterpolate1("form-group custom-toggle-container ", ctx_r0.fieldClass, "");
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOnAlignment) === "right");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r0.field.customText == null ? null : ctx_r0.field.customText.labelOnAlignment) === "left");
} }
class ToggleFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, _formBuilder, themeService) {
        super(_changeDetectorRef, _formBuilder);
        this._changeDetectorRef = _changeDetectorRef;
        this._formBuilder = _formBuilder;
        this.themeService = themeService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngAfterViewInit() {
        super.ngAfterViewInit();
        if (!this.field) {
            return;
        }
        this.field.customText.labelOnAlignment = this.field.customText.labelOnAlignment ? this.field.customText.labelOnAlignment : 'left';
        this.field.customText.style = this.field.customText.style ? this.field.customText.style : 'toggle';
        this.fieldGroup?.valueChanges
            .pipe(map$1(values => values.input))
            .subscribe((value) => {
            this.value = value;
        });
    }
    writeValue(value) {
        this._value = value;
        this.fieldGroup?.controls.input.setValue(value, {
            emitEvent: false
        });
    }
    static { this.ɵfac = function ToggleFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ToggleFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ToggleFieldComponent, selectors: [["xf-toggle-field"]], inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [[3, "class", "formGroup", 4, "ngIf"], [3, "formGroup"], ["class", "form-label mb-0 muted-20 padding-top-4px", 3, "ngClass", 4, "ngIf"], ["class", "d-flex mb-0 label-on-right-alignment", 3, "ngClass", 4, "ngIf"], ["class", "d-flex mb-0 label-on-left-alignment", 3, "ngClass", 4, "ngIf"], [1, "form-label", "mb-0", "muted-20", "padding-top-4px", 3, "ngClass"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [1, "d-flex", "mb-0", "label-on-right-alignment", 3, "ngClass"], ["class", "align-top font-size-14px form-check-label margin-right-8px", 3, "for", 4, "ngIf"], ["type", "checkbox", "formControlName", "input", 1, "form-check-input", "float-none", "ms-0", "form-control", 3, "ngClass", "id"], ["class", "align-top font-size-14px form-check-label margin-left-8px", 3, "for", 4, "ngIf"], ["class", "align-self-end font-size-14px form-check-label margin-left-8px margin-right-8px", 3, "for", 4, "ngIf"], ["class", "switch-wrapper", 4, "ngIf"], [1, "align-top", "font-size-14px", "form-check-label", "margin-right-8px", 3, "for"], [1, "align-top", "font-size-14px", "form-check-label", "margin-left-8px", 3, "for"], [1, "align-self-end", "font-size-14px", "form-check-label", "margin-left-8px", "margin-right-8px", 3, "for"], [1, "switch-wrapper"], [1, "switch"], ["class", "", 4, "ngIf"], [4, "ngIf"], [1, ""], [1, "d-flex", "mb-0", "label-on-left-alignment", 3, "ngClass"]], template: function ToggleFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ToggleFieldComponent_div_0_Template, 4, 7, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i1.NgClass, i1.NgIf, i2.CheckboxControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip], styles: [".custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type[_ngcontent-%COMP%]{position:relative;background:var(--btn-default-toggle-inactive-bg);color:var(--btn-default-toggle-inactive-color);border:1px solid var(--btn-default-toggle-inactive-border)}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type[_ngcontent-%COMP%]   input.form-control[_ngcontent-%COMP%]{visibility:hidden;position:absolute;top:0}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type[_ngcontent-%COMP%]   label[_ngcontent-%COMP%]{width:50%;margin:0;cursor:pointer;font-size:12px;text-wrap:nowrap;padding:3px 15px;text-align:center;opacity:1}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type[_ngcontent-%COMP%]   .switch-wrapper[_ngcontent-%COMP%]{position:absolute;top:0;bottom:0;width:50%;z-index:3;transition:transform .2s cubic-bezier(.77,0,.175,1)}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type[_ngcontent-%COMP%]   .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]{background:var(--btn-default-toggle-active-bg);color:var(--btn-default-toggle-active-color);height:100%;border:1px solid var(--btn-default-toggle-active-border)}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type[_ngcontent-%COMP%]   .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]{width:100%;opacity:0;display:block;position:absolute;top:0;left:0;font-size:12px;text-wrap:nowrap;padding:3px 8px;text-align:center}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-left-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked ~ .switch-wrapper[_ngcontent-%COMP%]{left:0}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-left-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]{border-radius:2px 0 0 2px/2px 0px 0px 2px}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-left-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-of-type(1){opacity:1}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-left-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-of-type(2){opacity:0}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-left-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]{border-radius:0 2px 2px 0/0px 2px 2px 0px}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-left-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-of-type(2){opacity:1}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-right-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked ~ .switch-wrapper[_ngcontent-%COMP%]{right:0}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-right-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]{border-radius:0 2px 2px 0/0px 2px 2px 0px}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-right-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-of-type(2){opacity:1}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-right-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:checked ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-of-type(1){opacity:0}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-right-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]{border-radius:2px 0 0 2px/2px 0px 0px 2px}.custom-toggle-container[_ngcontent-%COMP%]   .custom-toggle-button-type.label-on-right-alignment[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] ~ .switch-wrapper[_ngcontent-%COMP%]   .switch[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-of-type(1){opacity:1}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ToggleFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-toggle-field', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-group custom-toggle-container {{fieldClass}}\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n    <label class=\"form-label mb-0 muted-20 padding-top-4px\" *ngIf=\"fieldOptions.showLabel\" [ngClass]=\"{'d-inline-block' : field.customText?.style !== 'toggle'}\">\n        {{ field.title }}\n        <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n        <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n            <i class=\"fa fa-duotone fa-info-circle\"></i>\n        </span>\n    </label>\n    <div class=\"d-flex mb-0 label-on-right-alignment\" *ngIf=\"field.customText?.labelOnAlignment === 'right'\"\n        [ngClass]=\"field.customText?.style === 'toggle' ? 'form-check form-switch align-items-center padding-left-12px' : 'custom-toggle-button-type padding-right-12px rounded-4px margin-left-12px'\">\n        <label *ngIf=\"field.customText?.style !== 'toggle' && field.customText?.labelOff\" class=\"align-top font-size-14px form-check-label margin-right-8px\" [for]=\"'input-' + field.name\">{{field.customText?.labelOff}}</label>\n        <input class=\"form-check-input float-none ms-0 form-control\" type=\"checkbox\"\n            [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid}\" [id]=\"'input-' + field.name\"\n            formControlName=\"input\">\n        <label *ngIf=\"field.customText?.style !== 'toggle' && field.customText?.labelOn\" class=\"align-top font-size-14px form-check-label margin-left-8px\" [for]=\"'input-' + field.name\">{{field.customText?.labelOn}}</label>\n        <label *ngIf=\"field.customText?.style === 'toggle'\" class=\"align-self-end font-size-14px form-check-label margin-left-8px margin-right-8px\" [for]=\"'input-' + field.name\">{{fieldGroup.controls.input.value ? field.customText?.labelOn : field.customText?.labelOff}}</label>\n\n        <div class=\"switch-wrapper\" *ngIf=\"field.customText?.style !== 'toggle'\">\n            <div class=\"switch\">\n                <div class=\"\" *ngIf=\"field.customText?.labelOff\">{{field.customText?.labelOff}}</div>\n                <div *ngIf=\"field.customText?.labelOn\">{{field.customText?.labelOn}}</div>\n            </div>\n        </div>\n    </div>\n    <div class=\"d-flex mb-0 label-on-left-alignment\" *ngIf=\"field.customText?.labelOnAlignment === 'left'\"\n        [ngClass]=\"field.customText?.style === 'toggle' ? 'form-check form-switch align-items-center padding-left-0px' : 'custom-toggle-button-type padding-right-12px margin-left-12px'\">\n        <label *ngIf=\"field.customText?.style === 'toggle'\" class=\"align-self-end font-size-14px form-check-label margin-left-8px margin-right-8px\" [for]=\"'input-' + field.name\">{{fieldGroup.controls.input.value ? field.customText?.labelOn : field.customText?.labelOff}}</label>\n        <label *ngIf=\"field.customText?.style !== 'toggle' && field.customText?.labelOn\" class=\"align-top font-size-14px form-check-label margin-right-8px\" [for]=\"'input-' + field.name\">{{field.customText?.labelOn}}</label>\n        <input class=\"form-check-input float-none ms-0 form-control\" type=\"checkbox\"\n            [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid}\" [id]=\"'input-' + field.name\"\n            formControlName=\"input\">\n        <label *ngIf=\"field.customText?.style !== 'toggle' && field.customText?.labelOff\" class=\"align-top font-size-14px form-check-label margin-left-8px\" [for]=\"'input-' + field.name\">{{field.customText?.labelOff}}</label>\n        <div class=\"switch-wrapper\" *ngIf=\"field.customText?.style !== 'toggle'\">\n            <div class=\"switch\">\n                <div *ngIf=\"field.customText?.labelOn\">{{field.customText?.labelOn}}</div>\n                <div *ngIf=\"field.customText?.labelOff\">{{field.customText?.labelOff}}</div>\n            </div>\n        </div>\n    </div>\n    <!-- <xf-form-messages [control]=\"fieldGroup.controls.input\" [field]=\"field\"></xf-form-messages> -->\n</div>", styles: [".custom-toggle-container .custom-toggle-button-type{position:relative;background:var(--btn-default-toggle-inactive-bg);color:var(--btn-default-toggle-inactive-color);border:1px solid var(--btn-default-toggle-inactive-border)}.custom-toggle-container .custom-toggle-button-type input.form-control{visibility:hidden;position:absolute;top:0}.custom-toggle-container .custom-toggle-button-type label{width:50%;margin:0;cursor:pointer;font-size:12px;text-wrap:nowrap;padding:3px 15px;text-align:center;opacity:1}.custom-toggle-container .custom-toggle-button-type .switch-wrapper{position:absolute;top:0;bottom:0;width:50%;z-index:3;transition:transform .2s cubic-bezier(.77,0,.175,1)}.custom-toggle-container .custom-toggle-button-type .switch-wrapper .switch{background:var(--btn-default-toggle-active-bg);color:var(--btn-default-toggle-active-color);height:100%;border:1px solid var(--btn-default-toggle-active-border)}.custom-toggle-container .custom-toggle-button-type .switch-wrapper .switch div{width:100%;opacity:0;display:block;position:absolute;top:0;left:0;font-size:12px;text-wrap:nowrap;padding:3px 8px;text-align:center}.custom-toggle-container .custom-toggle-button-type.label-on-left-alignment input:checked~.switch-wrapper{left:0}.custom-toggle-container .custom-toggle-button-type.label-on-left-alignment input:checked~.switch-wrapper .switch{border-radius:2px 0 0 2px/2px 0px 0px 2px}.custom-toggle-container .custom-toggle-button-type.label-on-left-alignment input:checked~.switch-wrapper .switch div:nth-of-type(1){opacity:1}.custom-toggle-container .custom-toggle-button-type.label-on-left-alignment input:checked~.switch-wrapper .switch div:nth-of-type(2){opacity:0}.custom-toggle-container .custom-toggle-button-type.label-on-left-alignment input~.switch-wrapper .switch{border-radius:0 2px 2px 0/0px 2px 2px 0px}.custom-toggle-container .custom-toggle-button-type.label-on-left-alignment input~.switch-wrapper .switch div:nth-of-type(2){opacity:1}.custom-toggle-container .custom-toggle-button-type.label-on-right-alignment input:checked~.switch-wrapper{right:0}.custom-toggle-container .custom-toggle-button-type.label-on-right-alignment input:checked~.switch-wrapper .switch{border-radius:0 2px 2px 0/0px 2px 2px 0px}.custom-toggle-container .custom-toggle-button-type.label-on-right-alignment input:checked~.switch-wrapper .switch div:nth-of-type(2){opacity:1}.custom-toggle-container .custom-toggle-button-type.label-on-right-alignment input:checked~.switch-wrapper .switch div:nth-of-type(1){opacity:0}.custom-toggle-container .custom-toggle-button-type.label-on-right-alignment input~.switch-wrapper .switch{border-radius:2px 0 0 2px/2px 0px 0px 2px}.custom-toggle-container .custom-toggle-button-type.label-on-right-alignment input~.switch-wrapper .switch div:nth-of-type(1){opacity:1}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: ThemeService }], { field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ToggleFieldComponent, { className: "ToggleFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/toggle/toggle-field.component.ts", lineNumber: 18 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ToggleViewComponent extends AbstractViewComponent {
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵToggleViewComponent_BaseFactory; return function ToggleViewComponent_Factory(__ngFactoryType__) { return (ɵToggleViewComponent_BaseFactory || (ɵToggleViewComponent_BaseFactory = i0.ɵɵgetInheritedFactory(ToggleViewComponent)))(__ngFactoryType__ || ToggleViewComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ToggleViewComponent, selectors: [["xf-toggle-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 0, template: function ToggleViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "p");
            i0.ɵɵtext(1, "toggle-view works!");
            i0.ɵɵelementEnd();
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ToggleViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-toggle-view', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<p>toggle-view works!</p>" }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ToggleViewComponent, { className: "ToggleViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/toggle/toggle-view.component.ts", lineNumber: 14 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SlideToggleComponent {
    constructor() {
        this.isChecked = false;
        this.inputId = 'toggle';
        this.onChange = () => { };
        this.onTouched = () => { };
    }
    writeValue(value) {
        this.isChecked = value;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setChecked(value) {
        this.isChecked = value;
        this.onChange(value);
        this.onTouched();
    }
    static { this.ɵfac = function SlideToggleComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SlideToggleComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: SlideToggleComponent, selectors: [["xf-slide-toggle"]], inputs: { inputId: "inputId" }, standalone: true, features: [i0.ɵɵProvidersFeature([
                {
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => SlideToggleComponent),
                    multi: true,
                },
            ]), i0.ɵɵStandaloneFeature], decls: 3, vars: 3, consts: [[1, "slide-toggle"], ["type", "checkbox", 3, "ngModelChange", "id", "ngModel"], [1, "slider", 3, "for"]], template: function SlideToggleComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "input", 1);
            i0.ɵɵlistener("ngModelChange", function SlideToggleComponent_Template_input_ngModelChange_1_listener($event) { return ctx.setChecked($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelement(2, "label", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("id", ctx.inputId)("ngModel", ctx.isChecked);
            i0.ɵɵadvance();
            i0.ɵɵproperty("for", ctx.inputId);
        } }, dependencies: [CommonModule, FormsModule, i2.CheckboxControlValueAccessor, i2.NgControlStatus, i2.NgModel], styles: [".slide-toggle[_ngcontent-%COMP%]{display:inline-block;position:relative;width:40px;height:20px}.slide-toggle[_ngcontent-%COMP%]   input[type=checkbox][_ngcontent-%COMP%]{display:none}.slider[_ngcontent-%COMP%]{position:absolute;cursor:pointer;inset:0;background-color:var(--btn-toggle-bg-color);transition:.3s;border-radius:15px}.slider[_ngcontent-%COMP%]:before{position:absolute;content:\"\";height:20px;width:20px;background-color:#fff;transition:.3s;border-radius:50%}input[_ngcontent-%COMP%]:checked + .slider[_ngcontent-%COMP%]{background-color:var(--btn-primary-bg-color)}input[_ngcontent-%COMP%]:focus + .slider[_ngcontent-%COMP%]{box-shadow:0 0 1px var(--btn-primary-bg-color)}input[_ngcontent-%COMP%]:checked + .slider[_ngcontent-%COMP%]:before{transform:translate(20px)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SlideToggleComponent, [{
        type: Component,
        args: [{ selector: 'xf-slide-toggle', providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => SlideToggleComponent),
                        multi: true,
                    },
                ], standalone: true, imports: [CommonModule, FormsModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"slide-toggle\">\n  <input\n    type=\"checkbox\"\n    [id]=\"inputId\"\n    [ngModel]=\"isChecked\"\n    (ngModelChange)=\"setChecked($event)\"\n  />\n  <label [for]=\"inputId\" class=\"slider\"></label>\n</div>\n", styles: [".slide-toggle{display:inline-block;position:relative;width:40px;height:20px}.slide-toggle input[type=checkbox]{display:none}.slider{position:absolute;cursor:pointer;inset:0;background-color:var(--btn-toggle-bg-color);transition:.3s;border-radius:15px}.slider:before{position:absolute;content:\"\";height:20px;width:20px;background-color:#fff;transition:.3s;border-radius:50%}input:checked+.slider{background-color:var(--btn-primary-bg-color)}input:focus+.slider{box-shadow:0 0 1px var(--btn-primary-bg-color)}input:checked+.slider:before{transform:translate(20px)}\n"] }]
    }], null, { inputId: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(SlideToggleComponent, { className: "SlideToggleComponent", filePath: "lib/components/slide-toggle/slide-toggle.component.ts", lineNumber: 24 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
/*
MIT License

Copyright (c) 2022 Ephox Corporation DBA Tiny Technologies, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
class HtmlEditorModule {
    static { this.ɵfac = function HtmlEditorModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || HtmlEditorModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: HtmlEditorModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [EditorComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(HtmlEditorModule, [{
        type: NgModule,
        args: [{
                imports: [EditorComponent],
                exports: [EditorComponent]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(HtmlEditorModule, { imports: [EditorComponent], exports: [EditorComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Tag {
    constructor(name) {
        this.name = name;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$b = ["searchInput"];
const _c1$6 = ["tagsBaseUrl", ""];
const _c2$4 = (a0, a1) => ({ "form-control-sm": a0, "form-control-xs": a1 });
const _c3$2 = a0 => ({ "invisible": a0 });
function TagsInputComponent_span_2_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "span", 5);
    i0.ɵɵtext(1);
    i0.ɵɵelementStart(2, "button", 6);
    i0.ɵɵlistener("click", function TagsInputComponent_span_2_Template_button_click_2_listener() { const tag_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.removeTag(tag_r2)); });
    i0.ɵɵtext(3, "\u00D7");
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const tag_r2 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", tag_r2, " ");
} }
function TagsInputComponent_div_3_li_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "li")(1, "a", 12);
    i0.ɵɵlistener("click", function TagsInputComponent_div_3_li_4_Template_a_click_1_listener() { const tag_r6 = i0.ɵɵrestoreView(_r5).$implicit; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.addTag(tag_r6)); })("keydown.enter", function TagsInputComponent_div_3_li_4_Template_a_keydown_enter_1_listener() { const tag_r6 = i0.ɵɵrestoreView(_r5).$implicit; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.addTag(tag_r6)); })("keydown.arrowup", function TagsInputComponent_div_3_li_4_Template_a_keydown_arrowup_1_listener() { const i_r7 = i0.ɵɵrestoreView(_r5).index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.focusOnItem(i_r7 - 1)); })("keydown.arrowdown", function TagsInputComponent_div_3_li_4_Template_a_keydown_arrowdown_1_listener() { const i_r7 = i0.ɵɵrestoreView(_r5).index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.focusOnItem(i_r7 + 1)); });
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const tag_r6 = ctx.$implicit;
    const t_r8 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", t_r8(tag_r6), " ");
} }
function TagsInputComponent_div_3_li_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li");
    i0.ɵɵelement(1, "div", 13);
    i0.ɵɵelementEnd();
} }
function TagsInputComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 7)(1, "input", 8, 0);
    i0.ɵɵlistener("keyup.arrowdown", function TagsInputComponent_div_3_Template_input_keyup_arrowdown_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.focusOnItem(0)); })("keydown.tab", function TagsInputComponent_div_3_Template_input_keydown_tab_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onTab()); })("keydown.enter", function TagsInputComponent_div_3_Template_input_keydown_enter_1_listener($event) { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onEnter($event)); })("keydown.backspace", function TagsInputComponent_div_3_Template_input_keydown_backspace_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onBackspace()); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 9);
    i0.ɵɵtemplate(4, TagsInputComponent_div_3_li_4_Template, 3, 1, "li", 10)(5, TagsInputComponent_div_3_li_5_Template, 2, 0, "li", 11);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(5, _c2$4, ctx_r2.size === "sm", ctx_r2.size === "xs"))("placeholder", ctx_r2.placeholder || "Press Tab to add a tag");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(8, _c3$2, !ctx_r2.filteredTags.length));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.filteredTags);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.loading);
} }
class TagsInputComponent {
    constructor(formBuilder) {
        this.loading = false;
        this.placeholder = '';
        this.size = 'sm';
        this.filteredTags = [];
        this.apiService = inject(ApiService);
        this.entityService = inject(EntityService);
        this.changeDetectorRef = inject(ChangeDetectorRef);
        this.tags = [];
        this.formGroup = formBuilder.group({
            searchText: ['']
        });
    }
    // Register change handler
    registerOnChange(fn) {
        this.onChange = fn;
    }
    // Register touched handler
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    // Write value
    writeValue(value) {
        if (Array.isArray(value)) {
            this.tags = value;
        }
    }
    ngOnInit() {
        this.formGroup.valueChanges.pipe(debounceTime$1(300), concatMap$1((values) => {
            if (values.searchText) {
                return this.applySearch(values.searchText);
            }
            return of();
        })).subscribe();
    }
    applySearch(searchText) {
        this.loading = true;
        return this.entityService.build(FIXED_MODULE.TAGS).pipe(concatMap$1((tagsEntity) => {
            tagsEntity.baseUrl = this.tagsBaseUrl;
            return this.apiService.getList(tagsEntity, Tag, {
                search: searchText
            }).pipe(map$1((tags) => {
                this.filteredTags = tags.map((tagObject) => tagObject.name).filter((tag) => this.tags.indexOf(tag) === -1);
                this.loading = false;
                this.dropdown.open(); // Ensure it is open
                this.changeDetectorRef.detectChanges();
            }));
        }));
    }
    onTab() {
        this.addTag(this.formGroup.get('searchText')?.value);
    }
    onEnter(event) {
        event.preventDefault();
        this.addTag(this.formGroup.get('searchText')?.value);
    }
    addTag(tag) {
        if (!tag) {
            return;
        }
        if (this.tags.indexOf(tag) === -1) {
            this.tags.push(tag);
        }
        this.formGroup.get('searchText')?.setValue('');
        if (this.onChange) {
            this.onChange(this.tags);
        }
        this.focusOnSearchInput();
        this.filteredTags = [];
        if (this.onTouched) {
            this.onTouched();
        }
    }
    focusOnSearchInput() {
        setTimeout(() => {
            this.searchInput.nativeElement.focus();
            this.searchInput.nativeElement.select();
        });
    }
    focusOnItem(index) {
        if (index === -1) {
            this.focusOnSearchInput();
        }
        this.dropdownItems.get(index)?.nativeElement.focus();
    }
    onBackspace() {
        if (!this.formGroup.get('searchText')?.value) {
            this.removeTag(this.tags[this.tags.length - 1]);
        }
    }
    removeTag(tag) {
        const index = this.tags.indexOf(tag);
        if (index !== -1) {
            this.tags.splice(index, 1);
        }
        if (this.onChange) {
            this.onChange(this.tags);
        }
        if (this.onTouched) {
            this.onTouched();
        }
    }
    static { this.ɵfac = function TagsInputComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TagsInputComponent)(i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TagsInputComponent, selectors: [["xf-tags-input", "tagsBaseUrl", ""]], viewQuery: function TagsInputComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$b, 5);
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(NgbDropdownItem, 5, ElementRef);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownItems = _t);
        } }, inputs: { placeholder: "placeholder", size: "size", tagsBaseUrl: "tagsBaseUrl" }, standalone: true, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => TagsInputComponent),
                    multi: true
                }]), i0.ɵɵStandaloneFeature], attrs: _c1$6, decls: 4, vars: 6, consts: [["searchInput", ""], [1, "form-control", "padding-0px", 3, "click", "ngClass", "formGroup"], [1, "d-inline-block"], ["class", "tag-chip", 4, "ngFor", "ngForOf"], ["ngbDropdown", "", "container", "body", "class", "d-inline-block", 4, "transloco"], [1, "tag-chip"], ["type", "button", 1, "close", 3, "click"], ["ngbDropdown", "", "container", "body", 1, "d-inline-block"], ["type", "text", "id", "searchDropdown", "formControlName", "searchText", "ngbDropdownToggle", "", "autocomplete", "off", 1, "lookup-search", "border-0", "shadow-none", "form-control", 3, "keyup.arrowdown", "keydown.tab", "keydown.enter", "keydown.backspace", "ngClass", "placeholder"], ["ngbDropdownMenu", "", "aria-labelledby", "tags", 1, "dropdown-menu", "mx-0", "border-0", "shadow", 3, "ngClass"], [4, "ngFor", "ngForOf"], [4, "ngIf"], ["ngbDropdownItem", "", "id", "clone-collection-btn", 1, "cursor-pointer", 3, "click", "keydown.enter", "keydown.arrowup", "keydown.arrowdown"], [1, "bg-shimmer", "content-line"]], template: function TagsInputComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 1);
            i0.ɵɵlistener("click", function TagsInputComponent_Template_div_click_0_listener() { return ctx.focusOnItem(-1); });
            i0.ɵɵelementStart(1, "div", 2);
            i0.ɵɵtemplate(2, TagsInputComponent_span_2_Template, 4, 1, "span", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(3, TagsInputComponent_div_3_Template, 6, 10, "div", 4);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(3, _c2$4, ctx.size === "sm", ctx.size === "xs"))("formGroup", ctx.formGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.tags);
        } }, dependencies: [RouterModule, CommonModule, i1.NgClass, i1.NgForOf, i1.NgIf, ReactiveFormsModule, i2.DefaultValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, NgbDropdownModule, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu, i3.NgbDropdownItem, TranslocoModule, i4.TranslocoDirective], styles: [".close[_ngcontent-%COMP%]{cursor:pointer;background:none;border:none;color:rgb(var(--bs-danger-rgb))}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TagsInputComponent, [{
        type: Component,
        args: [{ selector: 'xf-tags-input[tagsBaseUrl]', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => TagsInputComponent),
                        multi: true
                    }], standalone: true, imports: [RouterModule, CommonModule, ReactiveFormsModule, NgbDropdownModule, TranslocoModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-control padding-0px\" [ngClass]=\"{'form-control-sm': size === 'sm', 'form-control-xs': size === 'xs'}\" [formGroup]=\"formGroup\" (click)=\"focusOnItem(-1)\">\n  <div class=\"d-inline-block\">\n    <span *ngFor=\"let tag of tags\" class=\"tag-chip\">\n      {{ tag }}\n      <button type=\"button\" class=\"close\" (click)=\"removeTag(tag)\">&times;</button>\n    </span>\n  </div>\n  <div ngbDropdown *transloco=\"let t\" container=\"body\" class=\"d-inline-block\">\n    <input type=\"text\" class=\"lookup-search border-0 shadow-none form-control\" [ngClass]=\"{'form-control-sm': size === 'sm', 'form-control-xs': size === 'xs'}\" id=\"searchDropdown\" #searchInput\n      formControlName=\"searchText\" [placeholder]=\"placeholder || 'Press Tab to add a tag'\" ngbDropdownToggle (keyup.arrowdown)=\"focusOnItem(0)\"\n      autocomplete=\"off\" (keydown.tab)=\"onTab()\" (keydown.enter)=\"onEnter($event)\" (keydown.backspace)=\"onBackspace()\">\n    <div ngbDropdownMenu class=\"dropdown-menu mx-0 border-0 shadow\" [ngClass]=\"{'invisible': !filteredTags.length}\"\n      aria-labelledby=\"tags\">\n      <li *ngFor=\"let tag of filteredTags; let i = index\">\n        <a ngbDropdownItem id=\"clone-collection-btn\" class=\"cursor-pointer\" (click)=\"addTag(tag)\"\n          (keydown.enter)=\"addTag(tag)\" (keydown.arrowup)=\"focusOnItem(i - 1)\" (keydown.arrowdown)=\"focusOnItem(i + 1)\">\n          {{ t(tag) }}\n        </a>\n      </li>\n      <li *ngIf=\"loading\">\n        <div class=\"bg-shimmer content-line\"></div>\n      </li>\n    </div>\n  </div>\n\n</div>\n", styles: [".close{cursor:pointer;background:none;border:none;color:rgb(var(--bs-danger-rgb))}\n"] }]
    }], () => [{ type: i2.FormBuilder }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], dropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], dropdownItems: [{
            type: ViewChildren,
            args: [NgbDropdownItem, { read: ElementRef }]
        }], placeholder: [{
            type: Input
        }], size: [{
            type: Input
        }], tagsBaseUrl: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TagsInputComponent, { className: "TagsInputComponent", filePath: "lib/components/tags-input/tags-input.component.ts", lineNumber: 31 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class XFFormFieldsModule {
    static { this.ɵfac = function XFFormFieldsModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || XFFormFieldsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: XFFormFieldsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            UtilityModule,
            ReactiveFormsModule,
            SearchableDropdownModule,
            NgMultiSelectDropDownModule,
            NgbTooltipModule,
            NgbDatepickerModule,
            NgbTimepickerModule,
            NgbDropdownModule,
            NgJsonEditorModule,
            SlideToggleComponent,
            HtmlEditorModule,
            TagsInputComponent,
            TranslocoModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(XFFormFieldsModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    CheckboxFieldComponent,
                    CheckboxViewComponent,
                    CheckboxGridFilterComponent,
                    CheckboxFloatingFilterComponent,
                    FormFieldComponent,
                    InputFieldComponent,
                    InputViewComponent,
                    FormMessagesComponent,
                    FormViewComponent,
                    LookupFieldComponent,
                    LookupViewComponent,
                    LookupFloatingFilterComponent,
                    LookupGridFilterComponent,
                    PicklistFieldComponent,
                    PicklistViewComponent,
                    TextareaFieldComponent,
                    RichtextHTMLFieldComponent,
                    RichtextHTMLViewComponent,
                    EditableFieldComponent,
                    MultiselectFieldComponent,
                    FieldRendererComponent,
                    SelectFieldComponent,
                    SelectViewComponent,
                    DatetimeFieldComponent,
                    DatetimeViewComponent,
                    DatetimeFloatingFilterComponent,
                    RadioFieldComponent,
                    RadioViewComponent,
                    TagsFieldComponent,
                    TagsViewComponent,
                    ToggleViewComponent,
                    ToggleFieldComponent,
                    MultiSelectCheckboxDropdownFieldComponent,
                    MultiSelectCheckboxDropdownViewComponent,
                    ToggleDropdownFieldComponent,
                    JsonEditorFieldComponent,
                    RichtextMarkdownFieldComponent
                ],
                imports: [
                    CommonModule,
                    UtilityModule,
                    ReactiveFormsModule,
                    SearchableDropdownModule,
                    NgMultiSelectDropDownModule,
                    NgbTooltipModule,
                    NgbDatepickerModule,
                    NgbTimepickerModule,
                    NgbDropdownModule,
                    NgJsonEditorModule,
                    SlideToggleComponent,
                    HtmlEditorModule,
                    TagsInputComponent,
                    TranslocoModule
                ],
                exports: [
                    PicklistFieldComponent,
                    LookupFieldComponent,
                    LookupFloatingFilterComponent,
                    LookupGridFilterComponent,
                    CheckboxFieldComponent,
                    CheckboxGridFilterComponent,
                    CheckboxFloatingFilterComponent,
                    InputFieldComponent,
                    FormFieldComponent,
                    FormViewComponent,
                    EditableFieldComponent,
                    FormMessagesComponent,
                    MultiselectFieldComponent,
                    SelectFieldComponent,
                    SelectViewComponent,
                    FieldRendererComponent,
                    DatetimeFieldComponent,
                    DatetimeViewComponent,
                    DatetimeFloatingFilterComponent,
                    RadioFieldComponent,
                    RadioViewComponent,
                    JsonEditorFieldComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(XFFormFieldsModule, { declarations: [CheckboxFieldComponent,
        CheckboxViewComponent,
        CheckboxGridFilterComponent,
        CheckboxFloatingFilterComponent,
        FormFieldComponent,
        InputFieldComponent,
        InputViewComponent,
        FormMessagesComponent,
        FormViewComponent,
        LookupFieldComponent,
        LookupViewComponent,
        LookupFloatingFilterComponent,
        LookupGridFilterComponent,
        PicklistFieldComponent,
        PicklistViewComponent,
        TextareaFieldComponent,
        RichtextHTMLFieldComponent,
        RichtextHTMLViewComponent,
        EditableFieldComponent,
        MultiselectFieldComponent,
        FieldRendererComponent,
        SelectFieldComponent,
        SelectViewComponent,
        DatetimeFieldComponent,
        DatetimeViewComponent,
        DatetimeFloatingFilterComponent,
        RadioFieldComponent,
        RadioViewComponent,
        TagsFieldComponent,
        TagsViewComponent,
        ToggleViewComponent,
        ToggleFieldComponent,
        MultiSelectCheckboxDropdownFieldComponent,
        MultiSelectCheckboxDropdownViewComponent,
        ToggleDropdownFieldComponent,
        JsonEditorFieldComponent,
        RichtextMarkdownFieldComponent], imports: [CommonModule,
        UtilityModule,
        ReactiveFormsModule,
        SearchableDropdownModule,
        NgMultiSelectDropDownModule,
        NgbTooltipModule,
        NgbDatepickerModule,
        NgbTimepickerModule,
        NgbDropdownModule,
        NgJsonEditorModule,
        SlideToggleComponent,
        HtmlEditorModule,
        TagsInputComponent,
        TranslocoModule], exports: [PicklistFieldComponent,
        LookupFieldComponent,
        LookupFloatingFilterComponent,
        LookupGridFilterComponent,
        CheckboxFieldComponent,
        CheckboxGridFilterComponent,
        CheckboxFloatingFilterComponent,
        InputFieldComponent,
        FormFieldComponent,
        FormViewComponent,
        EditableFieldComponent,
        FormMessagesComponent,
        MultiselectFieldComponent,
        SelectFieldComponent,
        SelectViewComponent,
        FieldRendererComponent,
        DatetimeFieldComponent,
        DatetimeViewComponent,
        DatetimeFloatingFilterComponent,
        RadioFieldComponent,
        RadioViewComponent,
        JsonEditorFieldComponent] }); })();
i0.ɵɵsetComponentScope(LookupFloatingFilterComponent, [i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FormFieldComponent], []);
i0.ɵɵsetComponentScope(TagsFieldComponent, [i1.NgClass, i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, TagsInputComponent, FormMessagesComponent], []);

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function AddRecordComponent_div_9_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵelement(1, "xf-form-field", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r2 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", field_r2.value)("formControlName", field_r2.value.name)("fieldClass", "form-control-sm margin-bottom-8px w-100")("autoFocus", true)("fieldOptions", ctx_r2.nameFieldOptions);
} }
function AddRecordComponent_div_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, AddRecordComponent_div_9_div_1_Template, 2, 5, "div", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r2 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", field_r2.value.isFormField);
} }
class AddRecordComponent {
    constructor(activeOffcanvas, formBuilder, entityService) {
        this.activeOffcanvas = activeOffcanvas;
        this.formBuilder = formBuilder;
        this.entityService = entityService;
        this.saveBtnText = 'Save';
        this.nameFieldOptions = new FieldOptions();
        this.processing = false;
        this.translocoService = inject(TranslocoService);
        // Preserve original property order
        this.originalOrder = (a, b) => {
            return a.value.orderIndex > b.value.orderIndex ? 1 : a.value.orderIndex < b.value.orderIndex ? -1 : 0;
        };
        this.nameFieldOptions.customErrorMessages = {
            pattern: this.translocoService.translate('error.agentNameCannotContain')
        };
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({});
        forEach(this.entity.fields, (field) => {
            if (field.isFormField) {
                let validators = [];
                if (field.validation.required) {
                    validators.push(Validators.required);
                }
                if (field.validation.pattern) {
                    validators.push(Validators.pattern(field.validation.pattern));
                }
                let fieldCtrl = new FormControl(this.entity.values[field.name] || '', validators);
                this.formGroup.addControl(field.name, fieldCtrl);
                this.formGroup.controls[field.name].valueChanges.subscribe((value) => {
                    if (this.entity.type === 'playbooks' && field.formType === 'lookup') {
                        this.entity.values[field.name] = value.uuid;
                    }
                    else {
                        this.entity.values[field.name] = value;
                    }
                });
            }
        });
    }
    createRecord() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            for (let formFieldComponent of this.formFieldComponents) {
                if (!formFieldComponent.valid) {
                    formFieldComponent.focus();
                    return;
                }
            }
        }
        this.processing = true;
        forEach(this.entity.fields, (field) => {
            if (field.isFormField && this.entity.type === 'playbooks' && field.formType === 'lookup' && isObject(this.entity.values[field.name])) {
                this.entity.values[field.name] = this.entity.values[field.name].uuid;
            }
        });
        let entity = cloneDeep(this.entity);
        entity.uuid = undefined;
        this.entityService.save(entity, Object.keys(this.entity.values)).subscribe({
            next: (response) => {
                this.activeOffcanvas.close(response);
                this.processing = false;
            }, error: () => {
                this.processing = false;
            }
        });
    }
    static { this.ɵfac = function AddRecordComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AddRecordComponent)(i0.ɵɵdirectiveInject(i3.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AddRecordComponent, selectors: [["xf-add-record"]], viewQuery: function AddRecordComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFieldComponents = _t);
        } }, inputs: { entity: "entity", saveBtnText: "saveBtnText" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 18, vars: 11, consts: [["addModuleForm", "ngForm"], [3, "ngSubmit", "formGroup"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click", "disabled"], [1, "margin-top-20px", "modal-body"], [1, "row", "m-0"], [1, "col-md-12"], ["class", "form-group", 4, "ngFor", "ngForOf"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "submit", 1, "btn", "btn-primary", "btn-sm", "margin-left-6px", 3, "click", "disabled"], [1, "fa-light", "margin-right-4px", 3, "ngClass"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", 3, "click", "disabled"], [1, "fa", "fa-times", "margin-right-4px"], [1, "form-group"], ["class", "mb-2", 4, "ngIf"], [1, "mb-2"], [3, "field", "formControlName", "fieldClass", "autoFocus", "fieldOptions"]], template: function AddRecordComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "form", 1, 0);
            i0.ɵɵlistener("ngSubmit", function AddRecordComponent_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.createRecord()); });
            i0.ɵɵelementStart(2, "div", 2)(3, "h4", 3);
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "button", 4);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_5_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Cross click")); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 5)(7, "div", 6)(8, "div", 7);
            i0.ɵɵtemplate(9, AddRecordComponent_div_9_Template, 2, 1, "div", 8);
            i0.ɵɵpipe(10, "keyvalue");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(11, "div", 9)(12, "button", 10);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.createRecord()); });
            i0.ɵɵelement(13, "i", 11);
            i0.ɵɵtext(14);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(15, "button", 12);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Close click")); });
            i0.ɵɵelement(16, "i", 13);
            i0.ɵɵtext(17, "Cancel ");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(4);
            i0.ɵɵtextInterpolate1("Create ", ctx.entity.descriptions.singular, "");
            i0.ɵɵadvance();
            i0.ɵɵproperty("disabled", ctx.processing);
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind2(10, 8, ctx.entity.fields, ctx.originalOrder));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("disabled", ctx.processing);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", ctx.processing ? "fa-spin fa-spinner" : "fa fa-check");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1("", ctx.saveBtnText, " ");
            i0.ɵɵadvance();
            i0.ɵɵproperty("disabled", ctx.processing);
        } }, dependencies: [CommonModule, i1.NgClass, i1.NgForOf, i1.NgIf, i1.KeyValuePipe, FormsModule, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, XFFormFieldsModule, FormFieldComponent, ReactiveFormsModule, i2.FormGroupDirective, i2.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AddRecordComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [
                    CommonModule,
                    FormsModule,
                    XFFormFieldsModule,
                    ReactiveFormsModule
                ], selector: 'xf-add-record', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form #addModuleForm=\"ngForm\" (ngSubmit)=\"createRecord()\" [formGroup]=\"formGroup\">\n  <div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n    <h4 class=\"page-title-font modal-title muted-10\">Create {{entity.descriptions.singular}}</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"activeOffcanvas.dismiss('Cross click')\"\n      [disabled]=\"processing\"></button>\n  </div>\n  <div class=\"margin-top-20px modal-body\">\n    <div class=\"row m-0\">\n      <div class=\"col-md-12\">\n        <div class=\"form-group\" *ngFor=\"let field of entity.fields | keyvalue : originalOrder\">\n          <div class=\"mb-2\" *ngIf=\"field.value.isFormField\">\n            <xf-form-field [field]=\"field.value\" [formControlName]=\"field.value.name\"\n              [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\" [autoFocus]=\"true\" [fieldOptions]=\"nameFieldOptions\"></xf-form-field>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  <div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\">\n    <button type=\"submit\" class=\"btn btn-primary btn-sm margin-left-6px\" (click)=\"createRecord()\"\n      [disabled]=\"processing\">\n      <i class=\"fa-light margin-right-4px\"\n        [ngClass]=\"processing ? 'fa-spin fa-spinner' : 'fa fa-check'\"></i>{{saveBtnText}}\n    </button>\n    <button type=\"button\" class=\"btn btn-secondary btn-sm\" (click)=\"activeOffcanvas.dismiss('Close click')\"\n      [disabled]=\"processing\">\n      <i class=\"fa fa-times margin-right-4px\"></i>Cancel\n    </button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i3.NgbActiveOffcanvas }, { type: i2.FormBuilder }, { type: EntityService }], { entity: [{
            type: Input
        }], saveBtnText: [{
            type: Input
        }], formFieldComponents: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AddRecordComponent, { className: "AddRecordComponent", filePath: "lib/components/add-record/add-record.component.ts", lineNumber: 34 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function EditModuleComponent_div_9_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 16)(1, "xf-editable-field", 17);
    i0.ɵɵlistener("valueChange", function EditModuleComponent_div_9_div_1_Template_xf_editable_field_valueChange_1_listener($event) { i0.ɵɵrestoreView(_r2); const field_r3 = i0.ɵɵnextContext().$implicit; const ctx_r3 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r3.saveField(field_r3.value.name, $event, ctx_r3.entity.values[field_r3.value.name])); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const field_r3 = i0.ɵɵnextContext().$implicit;
    const ctx_r3 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", field_r3.value)("showLabel", true)("editMode", true)("value", ctx_r3.entity.values[field_r3.value.name])("fieldOptions", ctx_r3.fieldOptions)("autoFocus", true);
} }
function EditModuleComponent_div_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, EditModuleComponent_div_9_div_1_Template, 2, 6, "div", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r3 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", field_r3.value.isFormField);
} }
class EditModuleComponent {
    constructor(activeOffcanvas, formBuilder, entityService) {
        this.activeOffcanvas = activeOffcanvas;
        this.formBuilder = formBuilder;
        this.entityService = entityService;
        this.fieldOptions = { 'size': 'large' };
        // Preserve original property order
        this.originalOrder = (a, b) => {
            return 0;
        };
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({});
        forEach(this.entity.attributes, (field) => {
            if (field.isFormField) {
                let fieldCtrl = new FormControl('');
                this.formGroup.addControl(field.name, fieldCtrl);
                this.formGroup.controls[field.name].valueChanges.subscribe((value) => {
                    this.entity.values[field.name] = value;
                });
            }
        });
    }
    saveField(field, newValue, oldValue) {
        this.entity.values[field] = newValue;
    }
    updateModule() {
        let entity = cloneDeep(this.entity);
        this.entityService.save(entity, Object.keys(this.entity.values)).subscribe((response) => {
            this.activeOffcanvas.close(response);
        });
    }
    static { this.ɵfac = function EditModuleComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditModuleComponent)(i0.ɵɵdirectiveInject(i3.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EditModuleComponent, selectors: [["lib-edit-module"]], inputs: { entity: "entity" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 18, vars: 6, consts: [["addModuleForm", "ngForm"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "margin-top-20px", "modal-body"], [3, "ngSubmit", "formGroup"], [1, "row", "m-0"], [1, "col-md-12"], ["class", "form-group", 4, "ngFor", "ngForOf"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-left-6px", 3, "click"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"], [1, "form-group"], ["class", "mb-2", 4, "ngIf"], [1, "mb-2"], ["use-placeholder", "true", 1, "d-inline-block", "w-100", 3, "valueChange", "field", "showLabel", "editMode", "value", "fieldOptions", "autoFocus"]], template: function EditModuleComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "h4", 2);
            i0.ɵɵtext(2);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "button", 3);
            i0.ɵɵlistener("click", function EditModuleComponent_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Cross click")); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(4, "div", 4)(5, "form", 5, 0);
            i0.ɵɵlistener("ngSubmit", function EditModuleComponent_Template_form_ngSubmit_5_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.updateModule()); });
            i0.ɵɵelementStart(7, "div", 6)(8, "div", 7);
            i0.ɵɵtemplate(9, EditModuleComponent_div_9_Template, 2, 1, "div", 8);
            i0.ɵɵpipe(10, "keyvalue");
            i0.ɵɵelementEnd()()()();
            i0.ɵɵelementStart(11, "div", 9)(12, "button", 10);
            i0.ɵɵlistener("click", function EditModuleComponent_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.updateModule()); });
            i0.ɵɵelement(13, "i", 11);
            i0.ɵɵtext(14, "Save ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(15, "button", 12);
            i0.ɵɵlistener("click", function EditModuleComponent_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Close click")); });
            i0.ɵɵelement(16, "i", 13);
            i0.ɵɵtext(17, "Cancel ");
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵtextInterpolate1("Update ", ctx.entity.descriptions.singular, " Details");
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind2(10, 3, ctx.entity.fields, ctx.originalOrder));
        } }, dependencies: [CommonModule, i1.NgForOf, i1.NgIf, i1.KeyValuePipe, FormsModule, i2.ɵNgNoValidate, i2.NgControlStatusGroup, XFFormFieldsModule, EditableFieldComponent, ReactiveFormsModule, i2.FormGroupDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditModuleComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [
                    CommonModule,
                    FormsModule,
                    XFFormFieldsModule,
                    ReactiveFormsModule
                ], selector: 'lib-edit-module', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n    <h4 class=\"page-title-font modal-title muted-10\">Update {{entity.descriptions.singular}} Details</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\"\n        (click)=\"activeOffcanvas.dismiss('Cross click')\"></button>\n</div>\n<div class=\"margin-top-20px modal-body\">\n    <form #addModuleForm=\"ngForm\" (ngSubmit)=\"updateModule()\" [formGroup]=\"formGroup\">\n        <div class=\"row m-0\">\n            <div class=\"col-md-12\">\n                <div class=\"form-group\" *ngFor=\"let field of entity.fields | keyvalue : originalOrder\">\n                    <div class=\"mb-2\" *ngIf=\"field.value.isFormField\">\n                        <xf-editable-field [field]=\"field.value\" [showLabel]=\"true\" [editMode]=\"true\"\n                            class=\"d-inline-block w-100\" [value]=\"entity.values[field.value.name]\"\n                            (valueChange)=\"saveField(field.value.name, $event, entity.values[field.value.name])\"\n                            use-placeholder=\"true\" [fieldOptions]=\"fieldOptions\" [autoFocus]=\"true\">\n                        </xf-editable-field>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </form>\n</div>\n<div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\">\n    <button type=\"button\" class=\"btn btn-primary btn-sm margin-left-6px\" (click)=\"updateModule()\">\n        <i class=\"fa fa-check margin-right-4px\"></i>Save\n    </button>\n    <button type=\"button\" class=\"btn btn-secondary btn-sm\" (click)=\"activeOffcanvas.dismiss('Close click')\">\n        <i class=\"fa fa-times margin-right-4px\"></i>Cancel\n    </button>\n</div>" }]
    }], () => [{ type: i3.NgbActiveOffcanvas }, { type: i2.FormBuilder }, { type: EntityService }], { entity: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(EditModuleComponent, { className: "EditModuleComponent", filePath: "lib/components/edit-module/edit-module.component.ts", lineNumber: 26 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function BreadcrumbsComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 6)(1, "button", 7);
    i0.ɵɵelement(2, "span", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("routerLink", ctx_r0.backLink);
} }
function BreadcrumbsComponent_ng_container_4_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 11);
} }
function BreadcrumbsComponent_ng_container_4_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0, 12);
    i0.ɵɵtext(1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const breadcrumb_r2 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(breadcrumb_r2);
} }
function BreadcrumbsComponent_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, BreadcrumbsComponent_ng_container_4_div_1_Template, 1, 0, "div", 9)(2, BreadcrumbsComponent_ng_container_4_ng_container_2_Template, 2, 1, "ng-container", 10);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const breadcrumb_r2 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", breadcrumb_r2 === "...");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", breadcrumb_r2 !== "...");
} }
function BreadcrumbsComponent_ng_template_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 13);
} }
class BreadcrumbsComponent {
    constructor(route) {
        this.route = route;
        this.showBackButton = false;
        this.backLink = this.backLink ? this.backLink : (this.route.snapshot.queryParamMap.get('returnPath') || '..');
    }
    ngOnChanges(changes) {
        if (changes.backLink) {
            this.backLink = this.backLink ? this.backLink : (this.route.snapshot.queryParamMap.get('returnPath') || '..');
        }
    }
    static { this.ɵfac = function BreadcrumbsComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || BreadcrumbsComponent)(i0.ɵɵdirectiveInject(i1$2.ActivatedRoute)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BreadcrumbsComponent, selectors: [["xf-breadcrumbs"]], inputs: { showBackButton: "showBackButton", backLink: "backLink" }, standalone: true, features: [i0.ɵɵNgOnChangesFeature, i0.ɵɵStandaloneFeature], decls: 7, vars: 2, consts: [["iconTemplate", ""], [1, "align-items-center", "d-flex", "padding-top-6px", "padding-bottom-6px", "padding-left-6px"], ["class", "button-container margin-right-8px", 4, "ngIf"], [1, "breadcrumbs", "align-self-center"], [1, "text-capitalize", 3, "separator"], [4, "xngBreadcrumbItem"], [1, "button-container", "margin-right-8px"], [1, "btn", "padding-0px", 3, "routerLink"], [1, "fa-light", "fa", "fa-arrow-left", "font-size-18px"], ["class", "bg-shimmer breadcrumb-line d-inline-flex ms-3", 4, "ngIf"], ["class", "", 4, "ngIf"], [1, "bg-shimmer", "breadcrumb-line", "d-inline-flex", "ms-3"], [1, ""], [1, "fa", "fa-chevron-right"]], template: function BreadcrumbsComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 1);
            i0.ɵɵtemplate(1, BreadcrumbsComponent_div_1_Template, 3, 1, "div", 2);
            i0.ɵɵelementStart(2, "div", 3)(3, "xng-breadcrumb", 4);
            i0.ɵɵtemplate(4, BreadcrumbsComponent_ng_container_4_Template, 3, 2, "ng-container", 5);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(5, BreadcrumbsComponent_ng_template_5_Template, 1, 0, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            const iconTemplate_r3 = i0.ɵɵreference(6);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.showBackButton);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("separator", iconTemplate_r3);
        } }, dependencies: [CommonModule, i1.NgIf, BreadcrumbItemDirective, BreadcrumbComponent, RouterModule, i1$2.RouterLink], styles: [".breadcrumbs[_ngcontent-%COMP%]{min-width:500px}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BreadcrumbsComponent, [{
        type: Component,
        args: [{ selector: 'xf-breadcrumbs', standalone: true, imports: [CommonModule, BreadcrumbItemDirective, BreadcrumbComponent, RouterModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"align-items-center d-flex padding-top-6px padding-bottom-6px padding-left-6px\">\n  <div class=\"button-container margin-right-8px\" *ngIf=\"showBackButton\">\n    <button class=\"btn padding-0px\" [routerLink]=\"backLink\">\n      <span class=\"fa-light fa fa-arrow-left font-size-18px\"></span>\n    </button>\n  </div>\n  <div class=\"breadcrumbs align-self-center\">\n    <xng-breadcrumb [separator]=\"iconTemplate\" class=\"text-capitalize\">\n      <ng-container *xngBreadcrumbItem=\"let breadcrumb;\">\n        <div *ngIf=\"breadcrumb === '...'\" class=\"bg-shimmer breadcrumb-line d-inline-flex ms-3\"></div>\n        <ng-container *ngIf=\"breadcrumb !== '...'\" class=\"\">{{ breadcrumb }}</ng-container>\n      </ng-container>\n    </xng-breadcrumb>\n    <ng-template #iconTemplate>\n      <i class=\"fa fa-chevron-right\"></i>\n    </ng-template>\n  </div>\n</div>", styles: [".breadcrumbs{min-width:500px}\n"] }]
    }], () => [{ type: i1$2.ActivatedRoute }], { showBackButton: [{
            type: Input
        }], backLink: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(BreadcrumbsComponent, { className: "BreadcrumbsComponent", filePath: "lib/components/breadcrumbs/breadcrumbs.component.ts", lineNumber: 18 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$a = a0 => ({ "me-1": a0 });
function ButtonGroupComponent_div_0_div_1_button_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "i");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const button_r2 = i0.ɵɵnextContext(3).$implicit;
    i0.ɵɵadvance();
    i0.ɵɵclassMap(button_r2.iconClass);
} }
function ButtonGroupComponent_div_0_div_1_button_1_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0, 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const button_r2 = i0.ɵɵnextContext(3).$implicit;
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", button_r2.text, " ");
} }
function ButtonGroupComponent_div_0_div_1_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 5);
    i0.ɵɵlistener("click", function ButtonGroupComponent_div_0_div_1_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r1); const button_r2 = i0.ɵɵnextContext(2).$implicit; return i0.ɵɵresetView(button_r2.onClick()); });
    i0.ɵɵtemplate(1, ButtonGroupComponent_div_0_div_1_button_1_ng_container_1_Template, 2, 3, "ng-container", 2)(2, ButtonGroupComponent_div_0_div_1_button_1_ng_container_2_Template, 2, 1, "ng-container", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const button_r2 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵclassMapInterpolate2("btn btn-sm ", button_r2.class, " btn-", ctx_r2.buttonSize, "");
    i0.ɵɵpropertyInterpolate("id", button_r2.id);
    i0.ɵɵpropertyInterpolate("type", button_r2.type || "button");
    i0.ɵɵpropertyInterpolate("title", button_r2.tooltip);
    i0.ɵɵproperty("disabled", button_r2.disabled)("hidden", !button_r2.visible);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", button_r2.iconClass);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", button_r2.text);
} }
function ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_button_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "i");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const menuItem_r5 = i0.ɵɵnextContext(2).$implicit;
    i0.ɵɵadvance();
    i0.ɵɵclassMap(menuItem_r5.iconClass);
} }
function ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 14);
    i0.ɵɵlistener("click", function ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const menuItem_r5 = i0.ɵɵnextContext().$implicit; return i0.ɵɵresetView(menuItem_r5.onClick()); });
    i0.ɵɵtemplate(1, ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_button_1_ng_container_1_Template, 2, 3, "ng-container", 2);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const menuItem_r5 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵproperty("hidden", !menuItem_r5.visible);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", menuItem_r5.iconClass);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", menuItem_r5.text, " ");
} }
function ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 15);
} }
function ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_button_1_Template, 3, 3, "button", 12)(2, ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_div_2_Template, 1, 0, "div", 13);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const menuItem_r5 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", menuItem_r5);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !menuItem_r5);
} }
function ButtonGroupComponent_div_0_div_1_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8)(1, "button", 9);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 10);
    i0.ɵɵtemplate(4, ButtonGroupComponent_div_0_div_1_div_2_ng_container_4_Template, 3, 2, "ng-container", 11);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const button_r2 = i0.ɵɵnextContext(2).$implicit;
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(button_r2.text);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", button_r2.menuItems);
} }
function ButtonGroupComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, ButtonGroupComponent_div_0_div_1_button_1_Template, 3, 11, "button", 3)(2, ButtonGroupComponent_div_0_div_1_div_2_Template, 5, 2, "div", 4);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const button_r2 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !button_r2.menuItems);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", button_r2.menuItems);
} }
function ButtonGroupComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, ButtonGroupComponent_div_0_div_1_Template, 3, 2, "div", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const button_r2 = ctx.$implicit;
    const i_r6 = ctx.index;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("hidden", !button_r2.visible)("ngClass", i0.ɵɵpureFunction1(3, _c0$a, i_r6 !== ctx_r2.buttons.length - 1));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !button_r2.bulkAction);
} }
class ButtonGroupComponent {
    constructor() {
        this.buttons = [];
        this.buttonSize = 'sm';
        this.disabled = false;
        this.dropUp = false;
    }
    static { this.ɵfac = function ButtonGroupComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ButtonGroupComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ButtonGroupComponent, selectors: [["xf-button-group"]], inputs: { buttons: "buttons", buttonSize: "buttonSize", disabled: "disabled", dropUp: "dropUp" }, decls: 1, vars: 1, consts: [["class", "btn-group", 3, "hidden", "ngClass", 4, "ngFor", "ngForOf"], [1, "btn-group", 3, "hidden", "ngClass"], [4, "ngIf"], [3, "id", "class", "disabled", "type", "hidden", "title", "click", 4, "ngIf"], ["ngbDropdown", "", "container", "body", 4, "ngIf"], [3, "click", "id", "disabled", "type", "hidden", "title"], ["class", "margin-left-4px", 4, "ngIf"], [1, "margin-left-4px"], ["ngbDropdown", "", "container", "body"], ["type", "button", "ngbDropdownToggle", "", 1, "btn", "btn-primary", "btn-sm"], ["ngbDropdownMenu", ""], [4, "ngFor", "ngForOf"], ["ngbDropdownItem", "", 3, "hidden", "click", 4, "ngIf"], ["class", "dropdown-divider", 4, "ngIf"], ["ngbDropdownItem", "", 3, "click", "hidden"], [1, "dropdown-divider"]], template: function ButtonGroupComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ButtonGroupComponent_div_0_Template, 2, 5, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngForOf", ctx.buttons);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu, i3.NgbDropdownItem, i3.NgbDropdownButtonItem] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ButtonGroupComponent, [{
        type: Component,
        args: [{ selector: 'xf-button-group', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"btn-group\" *ngFor=\"let button of buttons; let i = index\" [hidden]=\"!button.visible\" [ngClass]=\"{'me-1': i !== buttons.length - 1}\">\n  <div *ngIf=\"!button.bulkAction\">\n    <button id=\"{{ button.id }}\" class=\"btn btn-sm {{button.class}} btn-{{buttonSize}}\" [disabled]=\"button.disabled\"\n      *ngIf=\"!button.menuItems\" type=\"{{button.type || 'button'}}\" (click)=\"button.onClick()\"\n      [hidden]=\"!button.visible\" title=\"{{button.tooltip}}\">\n      <ng-container *ngIf=\"button.iconClass\">\n        <i class=\"{{button.iconClass}}\"></i>\n      </ng-container>\n      <ng-container *ngIf=\"button.text\" class=\"margin-left-4px\">\n          {{button.text}}\n      </ng-container>\n    </button>\n    <div ngbDropdown container=\"body\" *ngIf=\"button.menuItems\">\n      <button type=\"button\" class=\"btn btn-primary btn-sm\" ngbDropdownToggle>{{ button.text }}</button>\n      <div ngbDropdownMenu>\n        <ng-container *ngFor=\"let menuItem of button.menuItems\">\n          <button ngbDropdownItem *ngIf=\"menuItem\" (click)=\"menuItem.onClick()\" [hidden]=\"!menuItem.visible\">\n            <ng-container *ngIf=\"menuItem.iconClass\">\n              <i class=\"{{menuItem.iconClass}}\"></i></ng-container>{{ menuItem.text }}\n          </button>\n          <div class=\"dropdown-divider\" *ngIf=\"!menuItem\"></div>\n        </ng-container>\n      </div>\n    </div>\n  </div>\n</div>\n" }]
    }], null, { buttons: [{
            type: Input
        }], buttonSize: [{
            type: Input
        }], disabled: [{
            type: Input
        }], dropUp: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ButtonGroupComponent, { className: "ButtonGroupComponent", filePath: "lib/components/button-group/button-group.component.ts", lineNumber: 14 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ButtonGroupModule {
    static { this.ɵfac = function ButtonGroupModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ButtonGroupModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ButtonGroupModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            NgbDropdownModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ButtonGroupModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    ButtonGroupComponent
                ],
                imports: [
                    CommonModule,
                    NgbDropdownModule
                ],
                exports: [
                    ButtonGroupComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ButtonGroupModule, { declarations: [ButtonGroupComponent], imports: [CommonModule,
        NgbDropdownModule], exports: [ButtonGroupComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class CodemirrorComponent {
    constructor(elementRef) {
        this.elementRef = elementRef;
        this.editorView = null;
        this.onChange = null;
        this.onTouched = null;
        this.code = '';
        this.themeService = inject(ThemeService);
        this.currentTheme = this.themeService.getTheme();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.extraKeyBindings = [];
        this.placeholder = '';
    }
    ngAfterViewInit() {
        const editorElement = this.elementRef.nativeElement.querySelector('div');
        let jinjaLanguage = StreamLanguage.define(jinja2);
        let customHighlights = HighlightStyle.define(customHighlightSpecs);
        const asyncCompletionSource = (context) => {
            if (!this.autocompleteGetter) {
                return null;
            }
            return this.autocompleteGetter(context);
        };
        const autocompleteExtension = autocompletion({
            override: [asyncCompletionSource], // Use async completion source
            activateOnTyping: true, // Enable suggestions on typing
        });
        let extensions = [
            basicSetup,
            jinjaLanguage,
            autocompleteExtension,
            keymap.of(completionKeymap),
            Prec.highest(keymap.of(this.extraKeyBindings)),
            EditorView$1.lineWrapping,
            this.handleUpdates(),
            this.handleFocusChanges(),
            placeholder(this.placeholder),
            syntaxHighlighting(customHighlights)
        ];
        if (this.linter) {
            let customLinter = this.linter;
            extensions.push(linter(view => customLinter(view)));
        }
        if (isBoolean(this.code)) {
            this.code = this.code ? '{{ True }}' : '{{ False }}';
        }
        const state = EditorState$1.create({
            doc: this.code ? this.code.toString() : '',
            extensions: extensions,
        });
        this.editorView = new EditorView$1({
            state,
            parent: editorElement
        });
        if (this.currentTheme === 'dark') {
            editorElement.classList.add('cm-dark-theme');
        }
    }
    handleUpdates() {
        return EditorView$1.updateListener.of((viewUpdate) => {
            if (viewUpdate.docChanged && this.onChange) {
                this.onChange(viewUpdate.state.doc.toString());
            }
        });
    }
    handleFocusChanges() {
        return EditorView$1.focusChangeEffect.of((state, focusing) => {
            if (focusing) {
                this.focus.emit();
            }
            else {
                this.blur.emit();
            }
            return null;
        });
    }
    replaceSelection(text, skipBrackets = false) {
        if (!this.editorView) {
            return;
        }
        const cursorIndex = this.editorView.state.selection.main.head;
        if (!skipBrackets && !this.isInCurlyBraces(this.editorView.state.doc.toString(), cursorIndex)) {
            text = `{{ ${text} }}`;
        }
        const tr = this.editorView.state.replaceSelection(text);
        this.editorView.dispatch(tr);
        setTimeout(() => {
            this.setFocus();
        });
    }
    isInCurlyBraces(s, index) {
        if (index < 0 || index >= s.length) {
            return false;
        }
        let i = 0;
        while (i < s.length) {
            if (s.substring(i, i + 2) === '{{') {
                const endIndex = s.indexOf('}}', i + 2);
                if (endIndex === -1) {
                    break;
                }
                if (i + 2 < index && index <= endIndex + 1) {
                    return true;
                }
                i = endIndex + 2;
            }
            else {
                i++;
            }
        }
        return false;
    }
    ngOnDestroy() {
        if (this.editorView) {
            this.editorView.destroy();
        }
    }
    // ControlValueAccessor methods
    writeValue(value) {
        this.code = value;
        if (this.editorView) {
            this.editorView.dispatch({
                changes: {
                    from: 0,
                    to: this.editorView.state.doc.length,
                    insert: value,
                },
            });
        }
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setFocus() {
        this.editorView?.focus();
        const location = this.code.length;
        this.editorView?.dispatch({ selection: { anchor: location, head: location } });
    }
    static { this.ɵfac = function CodemirrorComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CodemirrorComponent)(i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CodemirrorComponent, selectors: [["xf-code-mirror"]], inputs: { autocompleteGetter: "autocompleteGetter", linter: "linter", extraKeyBindings: "extraKeyBindings", placeholder: "placeholder" }, outputs: { focus: "focus", blur: "blur" }, standalone: true, features: [i0.ɵɵProvidersFeature([
                {
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => CodemirrorComponent),
                    multi: true,
                },
            ]), i0.ɵɵStandaloneFeature], decls: 1, vars: 0, template: function CodemirrorComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelement(0, "div");
        } }, dependencies: [CommonModule], encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CodemirrorComponent, [{
        type: Component,
        args: [{
                standalone: true,
                imports: [CommonModule],
                selector: 'xf-code-mirror',
                template: '<div></div>',
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => CodemirrorComponent),
                        multi: true,
                    },
                ]
            }]
    }], () => [{ type: i0.ElementRef }], { focus: [{
            type: Output
        }], blur: [{
            type: Output
        }], autocompleteGetter: [{
            type: Input
        }], linter: [{
            type: Input
        }], extraKeyBindings: [{
            type: Input
        }], placeholder: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CodemirrorComponent, { className: "CodemirrorComponent", filePath: "lib/components/codemirror/codemirror.component.ts", lineNumber: 45 }); })();
const customHighlightSpecs = [
    {
        tag: [tags.atom, tags.bool, tags.url, tags.contentSeparator, tags.labelName],
        class: 'cm-atom', style: ''
    },
    {
        tag: tags.keyword,
        class: 'cm-keyword',
        color: ''
    },
    {
        tag: tags.meta,
        color: "#404740"
    },
    {
        tag: tags.link,
        textDecoration: "underline"
    },
    {
        tag: tags.heading,
        textDecoration: "underline",
        fontWeight: "bold"
    },
    {
        tag: tags.emphasis,
        fontStyle: "italic"
    },
    {
        tag: tags.strong,
        fontWeight: "bold"
    },
    {
        tag: tags.strikethrough,
        textDecoration: "line-through"
    },
    {
        tag: [tags.literal, tags.inserted],
        color: "#164"
    },
    {
        tag: [tags.string, tags.deleted],
        color: "#a11"
    },
    {
        tag: [tags.regexp, tags.escape, tags.special(tags.string)],
        color: "#e40"
    },
    {
        tag: tags.definition(tags.variableName),
        color: "#00f"
    },
    {
        tag: tags.local(tags.variableName),
        color: "#30a"
    },
    {
        tag: [tags.typeName, tags.namespace],
        color: "#085"
    },
    {
        tag: tags.className,
        color: "#167"
    },
    {
        tag: [tags.special(tags.variableName), tags.macroName],
        color: "#256"
    },
    {
        tag: tags.definition(tags.propertyName),
        color: "#00c"
    },
    {
        tag: tags.comment,
        color: "#940"
    },
    {
        tag: tags.invalid,
        color: "#f00"
    }
];

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function ContextMenuComponent_div_1_hr_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "hr");
} }
function ContextMenuComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵlistener("click", function ContextMenuComponent_div_1_Template_div_click_0_listener() { const menuItem_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onClick(menuItem_r2)); });
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, ContextMenuComponent_div_1_hr_2_Template, 1, 0, "hr", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const menuItem_r2 = ctx.$implicit;
    const i_r4 = ctx.index;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", menuItem_r2.label, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", i_r4 < ctx_r2.menuItems.length - 1);
} }
class ContextMenuComponent {
    constructor(eRef) {
        this.eRef = eRef;
    }
    onClick(data) {
        data.click();
    }
    clickout(event) {
        if (!this.eRef.nativeElement.contains(event.target)) {
            this.menuClickOut();
        }
    }
    static { this.ɵfac = function ContextMenuComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ContextMenuComponent)(i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ContextMenuComponent, selectors: [["xf-context-menu"]], hostBindings: function ContextMenuComponent_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("click", function ContextMenuComponent_click_HostBindingHandler($event) { return ctx.clickout($event); }, false, i0.ɵɵresolveDocument);
        } }, inputs: { menuItems: "menuItems", contextMenuPosition: "contextMenuPosition", menuClickOut: "menuClickOut" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 2, vars: 5, consts: [[1, "context-menu"], ["class", "menu-item", 3, "click", 4, "ngFor", "ngForOf"], [1, "menu-item", 3, "click"], [4, "ngIf"]], template: function ContextMenuComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, ContextMenuComponent_div_1_Template, 3, 2, "div", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵstyleProp("left", ctx.contextMenuPosition.x, "px")("top", ctx.contextMenuPosition.y, "px");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.menuItems);
        } }, dependencies: [CommonModule, i1.NgForOf, i1.NgIf], styles: [".context-menu[_ngcontent-%COMP%]{display:block;border:1px solid;z-index:999;background-color:#fff;position:fixed;width:150px}.context-menu[_ngcontent-%COMP%]   .menu-item[_ngcontent-%COMP%]{height:25px;padding-left:5px}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ContextMenuComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [CommonModule], selector: 'xf-context-menu', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"context-menu\" [style.left.px]=\"contextMenuPosition.x\" [style.top.px]=\"contextMenuPosition.y\">\n  <div class=\"menu-item\" *ngFor=\"let menuItem of menuItems; index as i\" (click)=\"onClick(menuItem)\">\n    {{ menuItem.label }}\n    <hr *ngIf=\"i < menuItems.length - 1\" />\n  </div>\n</div>\n", styles: [".context-menu{display:block;border:1px solid;z-index:999;background-color:#fff;position:fixed;width:150px}.context-menu .menu-item{height:25px;padding-left:5px}\n"] }]
    }], () => [{ type: i0.ElementRef }], { menuItems: [{
            type: Input
        }], contextMenuPosition: [{
            type: Input
        }], menuClickOut: [{
            type: Input
        }], clickout: [{
            type: HostListener,
            args: ['document:click', ['$event']]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ContextMenuComponent, { className: "ContextMenuComponent", filePath: "lib/components/context-menu/context-menu.component.ts", lineNumber: 18 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function FieldSelectComponent_option_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r1 = ctx.$implicit;
    i0.ɵɵproperty("value", field_r1.formType);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(field_r1.title);
} }
function FieldSelectComponent_div_6_option_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r4 = ctx.$implicit;
    i0.ɵɵproperty("value", field_r4.formType);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(field_r4.title);
} }
function FieldSelectComponent_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "label", 9);
    i0.ɵɵtext(2, "Select Sub Type ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 10);
    i0.ɵɵlistener("change", function FieldSelectComponent_div_6_Template_select_change_3_listener() { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.fieldTypeChanged("subField")); });
    i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_div_6_Template_select_ngModelChange_3_listener($event) { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r2.field.formType, $event) || (ctx_r2.field.formType = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵtemplate(4, FieldSelectComponent_div_6_option_4_Template, 2, 2, "option", 4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("disabled", ctx_r2.field.system);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r2.field.formType);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.textFieldSubTypes);
} }
function FieldSelectComponent_div_7_option_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const picklist_r6 = ctx.$implicit;
    i0.ɵɵproperty("value", picklist_r6.uuid);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(picklist_r6.name);
} }
function FieldSelectComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 11)(1, "div", 12)(2, "label", 13);
    i0.ɵɵtext(3, "Picklist");
    i0.ɵɵelementStart(4, "span", 14);
    i0.ɵɵtext(5, "*");
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(6, "div")(7, "select", 15);
    i0.ɵɵlistener("change", function FieldSelectComponent_div_7_Template_select_change_7_listener() { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.picklistSelected()); });
    i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_div_7_Template_select_ngModelChange_7_listener($event) { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r2.selectedField.dataSource.query.filters[0].value, $event) || (ctx_r2.selectedField.dataSource.query.filters[0].value = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementStart(8, "option", 16);
    i0.ɵɵtext(9, "Select a Picklist");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, FieldSelectComponent_div_7_option_10_Template, 2, 2, "option", 4);
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(7);
    i0.ɵɵproperty("disabled", ctx_r2.selectedField.system)("required", true);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r2.selectedField.dataSource.query.filters[0].value);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngForOf", ctx_r2.picklists);
} }
class FieldSelectComponent {
    constructor(picklistService, getEndPathName) {
        this.picklistService = picklistService;
        this.getEndPathName = getEndPathName;
        this.primaryFields = [];
        this.subTextFields = [Field.BuiltInType.DOMAIN, Field.BuiltInType.FILEHASH, Field.BuiltInType.IPv4, Field.BuiltInType.IPv6, Field.BuiltInType.RICHTEXTHTML, Field.BuiltInType.RICHTEXTMARKDOWN, Field.BuiltInType.TEXTAREA, Field.BuiltInType.TEXT, Field.BuiltInType.URL];
        this.textFieldSubTypes = [];
        this.fieldTypechanged = new EventEmitter();
        this.picklists = [];
    }
    ngOnInit() {
        this.setFieldTypes();
        this.loadPicklists();
    }
    ngOnChanges(changes) {
        if (changes.field) {
            this.setFieldTypes();
        }
    }
    setFieldTypes() {
        this.fieldCopy = cloneDeep(this.field);
        this.selectedField = cloneDeep(this.field);
        this.textFieldSubTypes = [];
        this.primaryFields = [];
        forEach(this.fieldTypes, (attribute) => {
            if (this.subTextFields.indexOf(attribute.formType) !== -1) {
                this.textFieldSubTypes.push(attribute);
                if (attribute.formType === Field.BuiltInType.TEXT) {
                    const fieldCopy = cloneDeep(attribute);
                    fieldCopy.title = 'Text';
                    this.primaryFields.push(fieldCopy);
                }
            }
            else if ((attribute.formType !== 'manyToMany' && attribute.formType !== 'oneToMany')) {
                this.primaryFields.push(cloneDeep(attribute));
            }
            // else if(attributetype.formType === 'datetime' || attributetype.formType === 'date') {
            //     dateSubtype.push(attributetype);
            //     if(attributetype.formType === 'datetime'){
            //       textAttr = angular.copy(attributetype);
            //       textAttr.title = 'Datetime';
            //       attrtypes.push(textAttr);
            //     }
            //   }
            // else if (attributetype.formType === 'emailTemplate') {
            //   textAttr = angular.copy(attributetype);
            //   textAttr.title = 'Email Template Field';
            //   attrtypes.push(textAttr);
            // } else {
            //   if((attributetype.formType !== 'manyToMany' && attributetype.formType !== 'oneToMany') || !scope.hideRelationship){
            //     attrtypes.push(attributetype);
            //   }
            // }
        });
        if (this.subTextFields.indexOf(this.field.formType) !== -1) {
            this.fieldCopy.formType = Field.BuiltInType.TEXT;
        }
    }
    loadPicklists() {
        this.picklistService.loadAllPicklists().subscribe((picklists) => {
            this.picklists = picklists;
            this.validatePicklist(this.field);
        });
    }
    fieldTypeChanged(fieldType) {
        console.log(this.fieldCopy.formType);
        let selectedAttribute;
        let selectedField;
        if (fieldType === 'mainField') {
            selectedField = this.fieldCopy.formType === 'text' ? this.field : this.fieldCopy;
            selectedAttribute = (this.primaryFields.find((field) => field.formType === selectedField.formType) || this.textFieldSubTypes.find((field) => field.formType === selectedField.formType));
        }
        else {
            selectedField = this.field;
            selectedAttribute = this.textFieldSubTypes.find((field) => field.formType === selectedField.formType);
        }
        this.selectedField = Object.assign(selectedField, selectedAttribute);
        this.selectedAttribute = selectedAttribute;
        if (selectedAttribute.formType === Field.BuiltInType.PICKLIST || selectedAttribute.formType === Field.BuiltInType.MULTISELECT_PICKLIST) {
            this.validatePicklist(this.selectedField);
        }
        else {
            this.fieldTypechanged.emit({
                moduleAttribute: selectedAttribute,
                field: this.selectedField
            });
        }
    }
    picklistSelected() {
        console.log(this.fieldCopy);
        this.fieldTypechanged.emit({
            moduleAttribute: this.selectedAttribute,
            field: this.selectedField
        });
    }
    validatePicklist(field) {
        if (this.picklists && field.dataSource && field.dataSource.query?.filters.length) {
            const selectedPicklist = this.picklists[field.dataSource.query.filters[0].value];
            const displayConditions = field.displayConditions || {};
            if (selectedPicklist) {
                forEach(selectedPicklist, (option) => {
                    const uuid = this.getEndPathName.transform(option['@id']);
                    if (!displayConditions[uuid] || (field.formType === Field.BuiltInType.MULTISELECT_PICKLIST && ['disabled', 'enabled_condition'].indexOf(displayConditions[uuid].visibility) > -1)) {
                        const displayCondition = {
                            visibility: 'visible',
                            conditions: null
                        };
                        displayConditions[uuid] = displayCondition;
                    }
                    option.visibility = displayConditions[uuid].visibility;
                    option._conditions = displayConditions[uuid].conditions;
                });
            }
            else {
                field.dataSource.query.filters[0].value = null;
            }
            field.displayConditions = displayConditions;
        }
    }
    static { this.ɵfac = function FieldSelectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldSelectComponent)(i0.ɵɵdirectiveInject(PicklistService), i0.ɵɵdirectiveInject(GetEndPathNamePipe)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldSelectComponent, selectors: [["xf-field-select"]], inputs: { field: "field", modulesList: "modulesList", entity: "entity", moduleFields: "moduleFields", fieldTypes: "fieldTypes" }, outputs: { fieldTypechanged: "fieldTypechanged" }, standalone: true, features: [i0.ɵɵNgOnChangesFeature, i0.ɵɵStandaloneFeature], decls: 8, vars: 5, consts: [[1, "clearfix"], [1, "float-start", "padding-right-20px", "w-50"], ["for", "fieldType", 1, "control-label", "label-font"], ["id", "fieldType", "name", "fieldType", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "ngModelChange", "change", "disabled", "ngModel"], [3, "value", 4, "ngFor", "ngForOf"], ["class", "float-start padding-right-20px w-50 label-font", 4, "ngIf"], ["class", "margin-top-16px", 4, "ngIf"], [3, "value"], [1, "float-start", "padding-right-20px", "w-50", "label-font"], ["for", "textFieldSubType", 1, "control-label"], ["id", "textFieldSubType", "name", "textFieldSubType", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "change", "ngModelChange", "disabled", "ngModel"], [1, "margin-top-16px"], [1, "form-group"], ["for", "select-picklist", 1, "label-font"], [1, "text-danger"], ["id", "select-picklist", "name", "select-picklist", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "change", "ngModelChange", "disabled", "required", "ngModel"], ["value", "null"]], template: function FieldSelectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "label", 2);
            i0.ɵɵtext(3, "Select Field Type ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "select", 3);
            i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_Template_select_ngModelChange_4_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.fieldCopy.formType, $event) || (ctx.fieldCopy.formType = $event); return $event; });
            i0.ɵɵlistener("change", function FieldSelectComponent_Template_select_change_4_listener() { return ctx.fieldTypeChanged("mainField"); });
            i0.ɵɵtemplate(5, FieldSelectComponent_option_5_Template, 2, 2, "option", 4);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(6, FieldSelectComponent_div_6_Template, 5, 3, "div", 5);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(7, FieldSelectComponent_div_7_Template, 11, 4, "div", 6);
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("disabled", ctx.field.system);
            i0.ɵɵtwoWayProperty("ngModel", ctx.fieldCopy.formType);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.primaryFields);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fieldCopy.formType === "text");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.selectedField.formType === "picklist" || ctx.selectedField.formType === "multiselectpicklist");
        } }, dependencies: [FormsModule, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.RequiredValidator, i2.NgModel, CommonModule, i1.NgForOf, i1.NgIf] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldSelectComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-select', standalone: true, imports: [FormsModule, CommonModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"clearfix\">\n  <div class=\"float-start padding-right-20px w-50\">\n    <label class=\"control-label label-font\" for=\"fieldType\">Select Field Type\n    </label>\n    <select class=\"form-control form-control-sm margin-top-6px\" id=\"fieldType\" name=\"fieldType\"\n      [disabled]=\"field.system\" [(ngModel)]=\"fieldCopy.formType\" (change)=\"fieldTypeChanged('mainField')\">\n      <option *ngFor=\"let field of primaryFields;\" [value]=\"field.formType\">{{ field.title }}</option>\n    </select>\n  </div>\n  <div *ngIf=\"fieldCopy.formType === 'text'\" class=\"float-start padding-right-20px w-50 label-font\">\n    <label class=\"control-label\" for=\"textFieldSubType\">Select Sub Type\n    </label>\n    <select class=\"form-control form-control-sm margin-top-6px\" id=\"textFieldSubType\" name=\"textFieldSubType\"\n      [disabled]=\"field.system\" (change)=\"fieldTypeChanged('subField')\" [(ngModel)]=\"field.formType\">\n      <option *ngFor=\"let field of textFieldSubTypes;\" [value]=\"field.formType\">{{ field.title }}</option>\n    </select>\n  </div>\n</div>\n<div *ngIf=\"selectedField.formType === 'picklist' || selectedField.formType === 'multiselectpicklist'\"\n  class=\"margin-top-16px\">\n  <!-- <div class=\"form-group\" data-ng-class=\"{'has-error': (form.picklistSelect.$touched && !form.picklistSelect.$valid)|| field.dataSource.query.filters[0].value == ''}\"></div> -->\n  <div class=\"form-group\">\n    <label class=\"label-font\" for=\"select-picklist\">Picklist<span class=\"text-danger\">*</span></label>\n    <div>\n      <select class=\"form-control form-control-sm margin-top-6px\" id=\"select-picklist\" name=\"select-picklist\"\n        [disabled]=\"selectedField.system\" (change)=\"picklistSelected()\" [required]=\"true\"\n        [(ngModel)]=\"selectedField.dataSource.query.filters[0].value\">\n        <option value=\"null\">Select a Picklist</option>\n        <option *ngFor=\"let picklist of picklists;\" [value]=\"picklist.uuid\">{{ picklist.name }}</option>\n      </select>\n    </div>\n    <!-- <select class=\"form-control\" id=\"picklist-select--{{ $index }}\" name=\"picklistSelect\" data-ng-disabled=\"field.system === true\" data-ng-model=\"field.dataSource.query.filters[0].value\" data-ng-required=\"true\" data-ng-options=\"picklistName as picklistName for (picklistName, picklistValue) in picklistNames\"\n        data-ng-change=\"updateFieldType(false, '')\">\n\n      </select>\n      <span class=\"fa fa-sort-desc\"></span>\n      <div data-cs-messages=\"form.picklistSelect\"></div> -->\n  </div>\n  <!-- <div class=\"form-group\" data-ng-show=\"!inline\">\n    <button type=\"button\" class=\"btn btn-sm btn-default margin-top-3\" data-ng-disabled=\"field.system === true\" data-ng-hide=\"license && license.details.is_distributed &&  license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\" data-ng-click=\"quickPicklistEditor(null)\" id=\"create-new-picklist-btn--{{ $index }}\">Create picklist</button>\n    <button data-ng-if=\"field.dataSource.query.filters[0].value\" type=\"button\" class=\"btn btn-sm btn-default margin-top-3\" data-ng-disabled=\"field.system === true\" data-ng-hide=\"license && license.details.is_distributed &&  license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\" data-ng-click=\"quickPicklistEditor(field.dataSource.query.filters[0].value)\" id=\"modify-picklist-btn\">Modify picklist</button>\n  </div> -->\n  <!-- <div class=\"alert alert-info margin-top-sm\" data-ng-show=\"license && license.details.is_distributed && license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\">\n      <i class=\"icon icon-information\"></i>&nbsp;&nbsp;Picklists referred here are from the Master Node. Please ensure a sync between the picklists in Master and Tenant nodes for any edit to happen successfully.\n  </div> -->\n  <!-- <div class=\"form-group\" data-ng-if=\"field.dataSource.query.filters[0].value && picklistNames[field.dataSource.query.filters[0].value] && !hideVisibility\">\n    <div class=\"checkbox margin-bottom-md\">\n      <label>\n        <input id=\"picklist-item-visibility\" type=\"checkbox\" name=\"picklist-item-visibility\" data-ng-model=\"$parent.field.dataSource.useDisplayConditions\">&nbsp;&nbsp;Configure Picklist Item Visibility\n        <span data-uib-tooltip=\"Picklist option visibility allows you to hide picklist items for this field based on conditions\"\n          data-tooltip-append-to-body=\"true\"><i class=\"icon icon-information font-Size-13\"></i></span>\n      </label>\n    </div>\n    <div data-ng-show=\"$parent.field.dataSource.useDisplayConditions\">\n      <div class=\"picklist-item-visibility-container\" data-ng-repeat=\"(key, option) in picklistNames[field.dataSource.query.filters[0].value].picklists | orderBy: 'orderIndex'\">\n        <div class=\"row padding-bottom-sm\">\n          <div class=\"col-md-4 label\">\n            <p id=\"view-{{ ::option.itemValue }}\" data-ng-hide=\"option.color\" class=\"margin-0 text-left text-overflow line-height-normal {{defaultClass}}\">\n              <span class=\"{{ defaultClass ? 'rating': '' }}\" title=\"{{ option.itemValue && option.itemValue.length > 0 ?  option.itemValue : 'None'}}\">{{ option.itemValue && option.itemValue.length > 0 ?  option.itemValue : 'None'}}</p>\n            <p id=\"view-{{ ::option.itemValue }}\" data-ng-show=\"option.color\" class=\"margin-0 text-left {{defaultClass}}\">\n            <span class=\"rating\" data-ng-attr-style=\"background: {{ option.color }}; color: {{ (option.color | isHexColorLight) ? '#000' : '#fff' }}\"> {{ option.itemValue }}</span>\n            </p>\n          </div>\n          <div class=\"col-md-8 val\">\n            <div class=\"cs-select\">\n              <select class=\"form-control\" name=\"picklist-item-visibility-display-{{ $index }}\" data-ng-model=\"option._visibility\" data-ng-required=\"true\" data-ng-change=\"updatePicklistItemVisibility(option)\">\n                <option value=\"visible\">Visible</option>\n                <option value=\"disabled\" ng-if=\"field.formType === 'picklist'\">Disabled</option>\n                <option value=\"hidden\">Hidden</option>\n                <option value=\"visible_condition\">Conditionally Visible</option>\n                <option value=\"enabled_condition\" ng-if=\"field.formType === 'picklist'\">Conditionally Enabled</option>\n              </select>\n              <span class=\"fa fa-sort-desc\"></span>\n            </div>\n          </div>\n        </div>\n        <div data-ng-if=\"option._visibility == 'visible_condition' || option._visibility == 'enabled_condition'\" class=\"row\">\n          <div class=\"col-md-12 padding-left-6\">\n            <hr class=\"margin-top-sm margin-bottom-md\">\n            <div data-cs-conditional data-enable-nested-filter=\"$parent.enableNestedFilter\" data-fields=\"$parent.moduleFields\" data-ng-model=\"option._conditions\" data-value-changed-param=\"option\" data-value-changed=\"updatePicklistItemVisibility\" data-form-name=\"'fieldSelectForm'\"></div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div> -->\n</div>\n" }]
    }], () => [{ type: PicklistService }, { type: GetEndPathNamePipe }], { field: [{
            type: Input
        }], modulesList: [{
            type: Input
        }], entity: [{
            type: Input
        }], moduleFields: [{
            type: Input
        }], fieldTypes: [{
            type: Input
        }], fieldTypechanged: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldSelectComponent, { className: "FieldSelectComponent", filePath: "lib/components/field-select/field-select.component.ts", lineNumber: 25 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function FileUploadComponent_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9)(1, "span", 10);
    i0.ɵɵtext(2, "Supported file types: ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "span", 11);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(ctx_r1.acceptTypes);
} }
class FileUploadComponent {
    constructor() {
        this.files = [];
        this.acceptTypes = [];
        this.showSupportedFileType = false;
        this.fileDropped = new EventEmitter();
        this.toaster = inject(ToastrService);
        this.translocoService = inject(TranslocoService);
    }
    onFileDropped($event) {
        this.fileBrowseHandler($event);
    }
    fileBrowseHandler(event) {
        if (event.files.length > 0 && this.areValidFiles(event.files)) {
            this.fileDropped.emit(event.files);
        }
    }
    // Dragover listener
    onDragOver(event) {
        event.preventDefault();
        event.stopPropagation();
        this.fileOver = true;
    }
    // Dragleave listener
    onDragLeave(event) {
        event.preventDefault();
        event.stopPropagation();
        this.fileOver = false;
    }
    // Drop listener
    ondrop(event) {
        event.preventDefault();
        event.stopPropagation();
        this.fileOver = false;
        let files = event.dataTransfer.files;
        if (files.length > 0 && this.areValidFiles(files)) {
            this.fileDropped.emit(files);
        }
    }
    areValidFiles(files) {
        if (this.acceptTypes.length > 0) {
            const invalidFiles = Array.from(files).filter((file) => this.acceptTypes.indexOf(file.type) === -1);
            if (invalidFiles.length > 0) {
                this.toaster.error(this.translocoService.translate('components.fileUpload.invalidFileType', {
                    acceptTypes: this.acceptTypes.join(', ')
                }), 'Error');
                return false;
            }
        }
        return true;
    }
    static { this.ɵfac = function FileUploadComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FileUploadComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FileUploadComponent, selectors: [["xf-file-upload"]], hostVars: 2, hostBindings: function FileUploadComponent_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("dragover", function FileUploadComponent_dragover_HostBindingHandler($event) { return ctx.onDragOver($event); })("dragleave", function FileUploadComponent_dragleave_HostBindingHandler($event) { return ctx.onDragLeave($event); })("drop", function FileUploadComponent_drop_HostBindingHandler($event) { return ctx.ondrop($event); });
        } if (rf & 2) {
            i0.ɵɵclassProp("fileover", ctx.fileOver);
        } }, inputs: { acceptTypes: "acceptTypes", showSupportedFileType: "showSupportedFileType" }, outputs: { fileDropped: "fileDropped" }, decls: 11, vars: 2, consts: [["fileDropRef", ""], [1, "container", "rounded-8px", "cursor-pointer", 3, "fileDropped"], ["type", "file", "id", "fileDropRef", "multiple", "", 1, "cursor-pointer", 3, "change", "accept"], [1, "align-items-center", "d-flex", "h-100", "justify-content-center"], [1, "img-responsive", "d-info-image", "w-100", "h-200px", "file-upload-image"], [1, "label-font", "fw-normal", "margin-top-16px"], [1, "fw-semibold", "text-highlight"], [1, "muted-40"], ["class", "d-flex justify-content-center", 4, "ngIf"], [1, "d-flex", "justify-content-center"], [1, "font-size-10px", "text-warning"], [1, "font-size-10px", "margin-left-4px", "muted-40", "text-capitalize"]], template: function FileUploadComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1);
            i0.ɵɵlistener("fileDropped", function FileUploadComponent_Template_div_fileDropped_0_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.onFileDropped($event)); });
            i0.ɵɵelementStart(1, "input", 2, 0);
            i0.ɵɵlistener("change", function FileUploadComponent_Template_input_change_1_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.fileBrowseHandler($event.target)); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "div", 3);
            i0.ɵɵelement(4, "div", 4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "h3", 5)(6, "span", 6);
            i0.ɵɵtext(7, "Click to upload");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "span", 7);
            i0.ɵɵtext(9, " or drag and drop");
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(10, FileUploadComponent_div_10_Template, 5, 1, "div", 8);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("accept", ctx.acceptTypes.join(","));
            i0.ɵɵadvance(9);
            i0.ɵɵproperty("ngIf", ctx.showSupportedFileType);
        } }, dependencies: [i1.NgIf], styles: [".container[_ngcontent-%COMP%]{width:100%;padding:50px;text-align:center;border:dashed 2px var(--file-upload-border);position:relative;margin:0 auto}.container[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]{opacity:0;position:absolute;z-index:2;width:100%;height:100%;top:0;left:0}.fileover[_ngcontent-%COMP%]{animation:shake 1s;animation-iteration-count:infinite}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FileUploadComponent, [{
        type: Component,
        args: [{ selector: 'xf-file-upload', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"container rounded-8px cursor-pointer\" (fileDropped)=\"onFileDropped($event)\">\n  <input type=\"file\" class=\"cursor-pointer\" #fileDropRef id=\"fileDropRef\" multiple\n    (change)=\"fileBrowseHandler($event.target)\" [accept]=\"acceptTypes.join(',')\" />\n  <div class=\"align-items-center d-flex h-100 justify-content-center\">\n    <div class=\"img-responsive d-info-image w-100 h-200px file-upload-image\"></div>\n  </div>\n  <!-- <button type=\"button\" class=\"btn btn-primary\" (click)=\"fileBrowseHandler($event.target)\"></button> -->\n  <h3 class=\"label-font fw-normal margin-top-16px\"><span class=\"fw-semibold text-highlight\">Click to\n      upload</span><span class=\"muted-40\"> or drag and drop</span></h3>\n  <div *ngIf=\"showSupportedFileType\" class=\"d-flex justify-content-center\">\n    <span class=\"font-size-10px text-warning\">Supported file types: </span>\n    <span class=\"font-size-10px margin-left-4px muted-40 text-capitalize\">{{acceptTypes}}</span>\n  </div>\n</div>\n", styles: [".container{width:100%;padding:50px;text-align:center;border:dashed 2px var(--file-upload-border);position:relative;margin:0 auto}.container input{opacity:0;position:absolute;z-index:2;width:100%;height:100%;top:0;left:0}.fileover{animation:shake 1s;animation-iteration-count:infinite}\n"] }]
    }], null, { acceptTypes: [{
            type: Input
        }], showSupportedFileType: [{
            type: Input
        }], fileOver: [{
            type: HostBinding,
            args: ['class.fileover']
        }], fileDropped: [{
            type: Output
        }], onDragOver: [{
            type: HostListener,
            args: ['dragover', ['$event']]
        }], onDragLeave: [{
            type: HostListener,
            args: ['dragleave', ['$event']]
        }], ondrop: [{
            type: HostListener,
            args: ['drop', ['$event']]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FileUploadComponent, { className: "FileUploadComponent", filePath: "lib/components/file-upload/file-upload.component.ts", lineNumber: 15 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class FileUploadModule {
    static { this.ɵfac = function FileUploadModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FileUploadModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: FileUploadModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FileUploadModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    FileUploadComponent
                ],
                imports: [
                    CommonModule
                ],
                exports: [
                    FileUploadComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(FileUploadModule, { declarations: [FileUploadComponent], imports: [CommonModule], exports: [FileUploadComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Icon {
    constructor() {
        this.id = '';
        this.unicode = '';
    }
}

class IconService {
    constructor(http) {
        this.http = http;
    }
    get() {
        return this.http.get('assets/icons/icons.json').pipe(map$1((response) => {
            return plainToInstance(Icon, response.icons);
        }));
    }
    static { this.ɵfac = function IconService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IconService)(i0.ɵɵinject(i1$1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: IconService, factory: IconService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IconService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class IconSearchPipe {
    transform(icons, searchText) {
        return icons.filter((icon) => {
            return icon.id.indexOf(searchText.toLowerCase()) !== -1;
        });
    }
    static { this.ɵfac = function IconSearchPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IconSearchPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "iconSearch", type: IconSearchPipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: IconSearchPipe, factory: IconSearchPipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IconSearchPipe, [{
        type: Pipe,
        args: [{
                name: 'iconSearch',
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function IconComponent_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 10);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", ctx_r0.value);
} }
function IconComponent_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵtext(1, "None");
    i0.ɵɵelementEnd();
} }
function IconComponent_button_9_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 12);
    i0.ɵɵlistener("click", function IconComponent_button_9_Template_button_click_0_listener() { const icon_r3 = i0.ɵɵrestoreView(_r2).$implicit; const ctx_r0 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r0.iconSelected(icon_r3)); });
    i0.ɵɵelement(1, "span");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const icon_r3 = ctx.$implicit;
    const i_r4 = ctx.index;
    i0.ɵɵpropertyInterpolate("title", icon_r3.id);
    i0.ɵɵpropertyInterpolate1("id", "select-icons-btn-", i_r4, "");
    i0.ɵɵadvance();
    i0.ɵɵclassMap(icon_r3.id);
} }
class IconComponent {
    constructor(iconService, formBuilder, iconSearch) {
        this.iconService = iconService;
        this.iconSearch = iconSearch;
        this.value = 'fa fa-none';
        this.icons = [];
        this.searchText = '';
        this.allIcons = [];
        this.currentIcons = [];
        this.onChange = (evt) => { };
        this.onTouched = () => { };
        this.touched = false;
        this.disabled = false;
        this.fieldGroup = formBuilder.group({
            searchIcon: ['']
        });
    }
    writeValue(value) {
        this.value = value;
    }
    registerOnChange(onChange) {
        this.onChange = onChange;
    }
    registerOnTouched(onTouched) {
        this.onTouched = onTouched;
    }
    validate(control) {
        const value = control.value;
        return null;
    }
    ngOnChanges(changes) {
        console.log(changes);
    }
    ngOnInit() {
        this.fieldGroup.controls.searchIcon.valueChanges.subscribe((value) => {
            this.currentIcons = this.iconSearch.transform(this.allIcons, value);
            this.icons = this.currentIcons;
            // this.loadNextIcons();
        });
        this.iconService.get().subscribe((icons) => {
            this.allIcons = icons;
            this.icons = icons;
        });
    }
    loadNextIcons(loadNext = true) {
        this.icons = this.currentIcons.slice(this.icons.length - 1, 250);
    }
    onScrollingFinished() {
        console.log('Load next Icons');
        this.loadNextIcons();
    }
    iconSelected(icon) {
        this.value = icon.id;
        if (!this.disabled) {
            this.onChange(this.value);
            this.onTouched();
        }
    }
    static { this.ɵfac = function IconComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IconComponent)(i0.ɵɵdirectiveInject(IconService), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(IconSearchPipe)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: IconComponent, selectors: [["xf-icon"]], inputs: { value: "value" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: IconComponent,
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: IconComponent,
                    multi: true
                }]), i0.ɵɵNgOnChangesFeature], decls: 10, vars: 5, consts: [["ngbDropdown", "", 1, "dropdown", 3, "formGroup"], ["type", "button", "id", "icon-button-select", "name", "icon-button-select", "ngbDropdownToggle", "", 1, "btn", "btn-default", "btn-sm"], ["class", "padding-right-8px", 3, "ngClass", 4, "ngIf"], ["class", "padding-right-8px", 4, "ngIf"], ["ngbDropdownMenu", "", 1, "dropdown-menu", "item-picker-container"], [1, "icon-picker"], [1, "margin-right-8px", "margin-left-8px"], ["type", "text", "id", "icon-search", "name", "icon-search", "formControlName", "searchIcon", 1, "form-control", "form-control-sm", 3, "placeholder"], [1, "icon-picker-items"], ["class", "btn btn-default icon-item", 3, "title", "id", "click", 4, "ngFor", "ngForOf"], [1, "padding-right-8px", 3, "ngClass"], [1, "padding-right-8px"], [1, "btn", "btn-default", "icon-item", 3, "click", "title", "id"]], template: function IconComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "button", 1);
            i0.ɵɵtemplate(2, IconComponent_span_2_Template, 1, 1, "span", 2)(3, IconComponent_span_3_Template, 2, 0, "span", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "div", 4)(5, "div", 5)(6, "div", 6);
            i0.ɵɵelement(7, "input", 7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 8);
            i0.ɵɵtemplate(9, IconComponent_button_9_Template, 2, 6, "button", 9);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.fieldGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.value);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.value === "fa fa-none");
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("placeholder", "Filter Icons");
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.icons);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.DefaultValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu], styles: [".item-picker-container[_ngcontent-%COMP%]{width:300px;max-height:290px;overflow:auto}.item-picker-container[_ngcontent-%COMP%]   .icon-picker[_ngcontent-%COMP%]{overflow:hidden}.item-picker-container[_ngcontent-%COMP%]   .icon-picker[_ngcontent-%COMP%]   .icon-picker-items[_ngcontent-%COMP%]{position:relative;clear:both;float:none;padding:10px;background:transparent;margin:0;overflow:hidden;overflow-y:auto;min-height:49px;max-height:246px}.item-picker-container[_ngcontent-%COMP%]   .icon-picker[_ngcontent-%COMP%]   .icon-picker-items[_ngcontent-%COMP%]   .icon-item[_ngcontent-%COMP%]{float:left;margin:2px;width:40px;height:40px;text-align:center}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IconComponent, [{
        type: Component,
        args: [{ selector: 'xf-icon', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: IconComponent,
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: IconComponent,
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div ngbDropdown class=\"dropdown\" [formGroup]=\"fieldGroup\">\n  <button type=\"button\" id=\"icon-button-select\" name=\"icon-button-select\" class=\"btn btn-default btn-sm\"\n    ngbDropdownToggle>\n    <span class=\"padding-right-8px\" [ngClass]=\"value\" *ngIf=\"value\"></span>\n    <span class=\"padding-right-8px\" *ngIf=\"value ==='fa fa-none'\">None</span>\n  </button>\n  <div class=\"dropdown-menu item-picker-container\" ngbDropdownMenu>\n    <div class=\"icon-picker\">\n      <div class=\"margin-right-8px margin-left-8px\">\n        <input type=\"text\" class=\"form-control form-control-sm\" id=\"icon-search\" name=\"icon-search\"\n          [placeholder]=\"'Filter Icons'\" formControlName=\"searchIcon\">\n      </div>\n      <div class=\"icon-picker-items\">\n        <button *ngFor=\"let icon of icons; let i = index\"\n          class=\"btn btn-default icon-item\" (click)=\"iconSelected(icon)\" title=\"{{ icon.id }}\"\n          id=\"select-icons-btn-{{ i }}\">\n          <span class=\"{{ icon.id }}\"></span>\n        </button>\n      </div>\n    </div>\n  </div>\n</div>\n", styles: [".item-picker-container{width:300px;max-height:290px;overflow:auto}.item-picker-container .icon-picker{overflow:hidden}.item-picker-container .icon-picker .icon-picker-items{position:relative;clear:both;float:none;padding:10px;background:transparent;margin:0;overflow:hidden;overflow-y:auto;min-height:49px;max-height:246px}.item-picker-container .icon-picker .icon-picker-items .icon-item{float:left;margin:2px;width:40px;height:40px;text-align:center}\n"] }]
    }], () => [{ type: IconService }, { type: i2.FormBuilder }, { type: IconSearchPipe }], { value: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(IconComponent, { className: "IconComponent", filePath: "lib/components/icons/component/icon.component.ts", lineNumber: 26 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class IconsModule {
    static { this.ɵfac = function IconsModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IconsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: IconsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            ReactiveFormsModule,
            NgbDropdownModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IconsModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    IconComponent,
                    IconSearchPipe
                ],
                imports: [
                    CommonModule,
                    ReactiveFormsModule,
                    NgbDropdownModule
                ],
                exports: [IconComponent]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(IconsModule, { declarations: [IconComponent,
        IconSearchPipe], imports: [CommonModule,
        ReactiveFormsModule,
        NgbDropdownModule], exports: [IconComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class EditorService {
    constructor() {
        this.loaded = false;
        this.loadingFinished = new Subject();
    }
    finishLoading() {
        this.loaded = true;
        this.loadingFinished.next();
    }
    load() {
        // load the assets
        const baseUrl = './assets' + '/monaco-editor/min/vs';
        if (typeof window.monaco === 'object') {
            this.finishLoading();
            return;
        }
        const onGotAmdLoader = () => {
            // load Monaco
            window.require.config({ paths: { vs: `${baseUrl}` } });
            window.require([`vs/editor/editor.main`], () => {
                this.finishLoading();
            });
        };
        // load AMD loader, if necessary
        if (!window.require) {
            const loaderScript = document.createElement('script');
            loaderScript.type = 'text/javascript';
            loaderScript.src = `${baseUrl}/loader.js`;
            loaderScript.addEventListener('load', onGotAmdLoader);
            document.body.appendChild(loaderScript);
        }
        else {
            onGotAmdLoader();
        }
    }
    static { this.ɵfac = function EditorService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditorService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EditorService, factory: EditorService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], () => [], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$9 = ["editor"];
const _c1$5 = ["nodeInput"];
const _c2$3 = a0 => ({ "code-editor": a0 });
const _c3$1 = (a0, a1) => ({ "col-lg-2": a0, "explorer-collapsed": a1 });
const _c4$1 = a0 => ({ "tab-selected": a0 });
function IdeComponent_div_2_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtext(1, "EXPLORER");
    i0.ɵɵelementEnd();
} }
function IdeComponent_div_2_div_5_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 21);
    i0.ɵɵelement(1, "xf-context-menu", 22);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("menuItems", ctx_r1.getMenuOption(ctx_r1.selectedNode.data))("menuClickOut", ctx_r1.menuClickOut)("contextMenuPosition", ctx_r1.contextMenuPosition);
} }
function IdeComponent_div_2_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 17)(1, "div", 18);
    i0.ɵɵelement(2, "div", 19);
    i0.ɵɵtemplate(3, IdeComponent_div_2_div_5_div_3_Template, 2, 3, "div", 20);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r1.contextMenuClicked);
} }
function IdeComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 10)(1, "div", 11);
    i0.ɵɵtemplate(2, IdeComponent_div_2_div_2_Template, 2, 0, "div", 12);
    i0.ɵɵelementStart(3, "div", 13);
    i0.ɵɵlistener("click", function IdeComponent_div_2_Template_div_click_3_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.collapsed = !ctx_r1.collapsed); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(4, "div", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, IdeComponent_div_2_div_5_Template, 4, 1, "div", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(4, _c3$1, !ctx_r1.collapsed, ctx_r1.collapsed));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.collapsed);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", ctx_r1.collapsed ? "fa-caret-right fload-start" : "fa-caret-left float-end");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.collapsed);
} }
function IdeComponent_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 23);
} }
function IdeComponent_div_5_li_2_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "li", 27)(1, "div", 28)(2, "a", 29);
    i0.ɵɵlistener("click", function IdeComponent_div_5_li_2_Template_a_click_2_listener() { const file_r4 = i0.ɵɵrestoreView(_r3).$implicit; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.setSelectedTab(file_r4)); });
    i0.ɵɵelementStart(3, "span");
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "i", 30);
    i0.ɵɵlistener("click", function IdeComponent_div_5_li_2_Template_i_click_5_listener() { const i_r5 = i0.ɵɵrestoreView(_r3).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.closeFile(i_r5)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const file_r4 = ctx.$implicit;
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(2, _c4$1, file_r4.selected));
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(file_r4.name);
} }
function IdeComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 24)(1, "ul", 25);
    i0.ɵɵtemplate(2, IdeComponent_div_5_li_2_Template, 6, 4, "li", 26);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.openedFiles);
} }
function IdeComponent_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtext(1, " Loading Editor ... ");
    i0.ɵɵelementEnd();
} }
class IdeComponent {
    constructor(EditorService, changeDetectorRef) {
        this.EditorService = EditorService;
        this.changeDetectorRef = changeDetectorRef;
        // Editor
        this.loadIde = false;
        this.editorOptions = {
            theme: 'vs-light',
            automaticLayout: true,
            inlayHints: true
        };
        this.editorLanguageMap = {
            'js': 'javascript',
            'ts': 'typescript',
            'html': 'html',
            'css': 'css',
            'json': 'json',
            'py': 'python',
            'txt': 'javascript'
        };
        this.monacoEditorLoaded = false;
        // Context Menu
        this.contextMenuClicked = false;
        this.contextMenuPosition = {
            x: 0,
            y: 0
        };
        this.nodeCMItems = [{
                label: 'Rename',
                name: 'rename',
                click: () => this.onRenameNode()
            }, {
                label: 'Copy Path',
                name: 'copyPath'
            }, {
                label: 'Delete',
                name: 'deleteNode',
                click: () => this.deleteNode()
            }];
        this.rootNodeCMItems = [{
                label: 'New File',
                name: 'newNode',
                click: () => this.onAddNode()
            }, {
                label: 'New Folder',
                name: 'newGroupNode',
                click: () => this.onAddGroupNode()
            }];
        this.groupNodeCMItems = [{
                label: 'New File',
                name: 'newNode',
                click: () => this.onAddNode()
            }, {
                label: 'New Folder',
                name: 'newGroupNode',
                click: () => this.onAddGroupNode()
            }, {
                label: 'Delete',
                name: 'deleteGroupNode',
                click: () => this.deleteNode()
            }, {
                label: 'Rename',
                name: 'rename',
                click: () => this.onRenameNode()
            }];
        this.contextMeuClickMap = {
            'rename': () => this.onRenameNode(),
            'newNode': () => this.onAddNode(),
            'deleteNode': () => this.deleteNode(),
            'newGroupNode': () => this.onAddGroupNode(),
            'deleteGroupNode': () => this.deleteGroupNode()
        };
        // Tree
        this.collapsed = false;
        this.actionMapping = {
            mouse: {
                click: (tree, node, $event) => this.onOpenNode(node, $event),
                contextMenu: (tree, node, $event) => this.onOpenContextMenu(node, $event)
            },
        };
        this.treeOptions = {
            displayField: 'name',
            idField: 'id',
            isExpandedField: 'expanded',
            hasChildrenField: 'isFolder',
            childrenField: 'files',
            actionMapping: this.actionMapping
        };
        this.menuClickOut = () => {
            this.contextMenuClicked = false;
        };
    }
    ngOnInit() {
        if (!this.EditorService.loaded) {
            this.EditorService.load();
            this.EditorService.loadingFinished.subscribe(() => {
                this.monacoEditorLoaded = true;
                monaco.languages.typescript.typescriptDefaults.setCompilerOptions({
                    experimentalDecorators: true,
                    allowSyntheticDefaultImports: true,
                    moduleResolution: monaco.languages.typescript.ModuleResolutionKind.NodeJs,
                    allowNonTsExtensions: true,
                    target: monaco.languages.typescript.ScriptTarget.ES2020,
                });
                this.changeDetectorRef.detectChanges();
                this.loadEditor();
            });
        }
        else {
            this.monacoEditorLoaded = true;
            this.changeDetectorRef.detectChanges();
            this.loadEditor();
        }
    }
    ngOnDestroy() {
        monaco.editor.getModels().forEach((m) => m.dispose());
        // destroy the editor as well?
    }
    loadEditor() {
        this.editorOptions.language = this.editorLanguageMap[this.openedFiles[0].ext];
        this.openedFiles[0].model = monaco.editor.createModel(this.openedFiles[0].fileContent, this.editorLanguageMap[this.openedFiles[0].ext]);
        this.editorOptions.model = this.openedFiles[0].model;
        this.monacoEditor = monaco.editor.create(this.editor.nativeElement, this.editorOptions);
        this.detectContentChange(this.openedFiles[0]);
    }
    getMenuOption(nodeData) {
        if (nodeData.isRootFolder) {
            return this.rootNodeCMItems;
        }
        else if (nodeData.isFolder && !nodeData.isRootFolder) {
            return this.groupNodeCMItems;
        }
        else {
            return this.nodeCMItems;
        }
    }
    onOpenContextMenu(node, event) {
        event.preventDefault();
        this.contextMenuClicked = true;
        this.selectedNode = node;
        this.contextMenuPosition.x = event.x;
        this.contextMenuPosition.y = event.y;
    }
    inputFileKeyUp(newValue, node) {
        if (newValue === '') {
            node.parent.data.files = node.parent.data.files.filter((file) => { return file.xpath !== node.data.xpath; });
            this.tree.treeModel.update();
        }
        else {
            if (!node.data.isFolder) {
                this.addNode(newValue, node);
            }
            else if (node.data.isFolder) {
                this.addGroupNode(newValue, node);
            }
        }
    }
    inputFocusOut(newValue, node) {
        if (newValue !== '') {
            if (!node.data.isFolder && node.data.new) {
                this.addNode(newValue, node);
            }
            else if (!node.data.isFolder && node.data.rename) {
                this.renameNode(newValue, node);
            }
            else if (node.data.isFolder && node.data.new) {
                this.addGroupNode(newValue, node);
            }
            else if (node.data.isFolder && node.data.rename) {
                this.renameNode(newValue, node);
            }
        }
        else {
            node.parent.data.files = node.parent.data.files.filter((file) => { return file.xpath !== node.data.xpath; });
            this.tree.treeModel.update();
        }
    }
    autoFocusInput() {
        setTimeout(() => {
            this.tref.nativeElement.focus();
        }, 10);
    }
    // File Operations
    onOpenNode(node, event) {
        this.selectedNode = node;
        if (!node.data.isFolder && !node.data.rename && !node.data.new) {
            let file = node.data;
            this.treeOperationAPI.openNode(file).subscribe((response) => {
                file.fileContent = response.fileContent;
                this.openedFiles.push(file);
                this.setSelectedTab(file);
            });
        }
    }
    onAddNode(node = null) {
        this.contextMenuClicked = false;
        if (node) {
            this.selectedNode = node;
        }
        this.selectedNode.data.files.unshift({ name: '', new: true, isFolder: false, xpath: this.selectedNode.data.xpath + '/tmp' });
        this.tree.treeModel.update();
        this.autoFocusInput();
    }
    addNode(newValue, node) {
        node.data.name = false;
        let newNodePath = '/' + node.data.xpath.substr(0, node.data.xpath.lastIndexOf('/')) + '/' + newValue;
        let oldNodePath = node.data.xpath; // in case api fails
        node.data.xpath = newNodePath;
        node.data.name = newValue;
        node.data.ext = newValue.split('/').pop()?.split('.').pop();
        this.treeOperationAPI.createNode(node.data).subscribe(() => {
            node.data.new = false;
            this.openedFiles.push(node.data);
            this.tree.treeModel.update();
            this.setSelectedTab(node.data);
        });
    }
    onRenameNode() {
        this.contextMenuClicked = false;
        this.selectedNode.data.rename = true;
        this.tree.treeModel.update();
        this.autoFocusInput();
    }
    renameNode(newValue, node) {
        node.data.rename = false;
        if (newValue !== node.data.name) {
            let oldValue = node.data.name; // needed in case API call fails
            this.treeOperationAPI.renameNode(node.data).subscribe((response) => {
                node.data.xpath = response.newData.xpath;
                node.data.name = newValue;
                this.tree.treeModel.update();
                this.updateOpenedFiles(response.oldData.xpath, response.newData);
            });
        }
        else {
            this.tree.treeModel.update();
        }
    }
    deleteNode() {
        this.treeOperationAPI.deleteNode(this.selectedNode.data).subscribe(() => {
            this.selectedNode.parent.data.files = this.selectedNode.parent.data.files.filter((file) => { return file.xpath !== this.selectedNode.data.xpath; });
            this.tree.treeModel.update();
            // this.removeOpenedFile(file.identifier);
        });
    }
    // Folder Operations
    onAddGroupNode(node = null) {
        this.contextMenuClicked = false;
        if (node) {
            this.selectedNode = node;
        }
        this.selectedNode.data.files.unshift({ name: '', new: true, isFolder: true, xpath: this.selectedNode.data.xpath + '/tmp', expanded: false, files: [] });
        this.tree.treeModel.update();
        this.autoFocusInput();
    }
    addGroupNode(newValue, node) {
        node.data.name = false;
        let newNodePath = node.data.xpath.substr(0, node.data.xpath.lastIndexOf('/')) + '/' + newValue;
        let oldNodePath = node.data.xpath; // in case api fails
        node.data.xpath = newNodePath;
        node.data.name = newValue;
        this.treeOperationAPI.createGroupNode(node.data).subscribe(() => {
            node.data.new = false;
            this.tree.treeModel.update();
        });
    }
    deleteGroupNode() {
        if (this.selectedNode && !this.selectedNode.data.isRootFolder) {
            this.treeOperationAPI.deleteGroupNode(this.selectedNode.data).subscribe(() => {
                this.selectedNode.parent.data.files = this.selectedNode.parent.data.files.filter((file) => { return file.xpath !== this.selectedNode.data.xpath; });
                this.tree.treeModel.update();
            });
        }
    }
    // Editor Operations
    detectContentChange(file) {
        const model = this.monacoEditor.getModel();
        model.onDidChangeContent(() => {
            this.updateOpenedFiles(file.xpath, { fileContent: model.getValue(), fileContentChanged: true });
        });
    }
    loadSelectedTab(file) {
        this.monacoEditor.setModel(file.model);
        this.monacoEditor.restoreViewState(file.state);
        this.monacoEditor.focus();
        this.detectContentChange(file);
        this.changeDetectorRef.detectChanges();
    }
    setSelectedTab(file) {
        this.openedFiles.forEach((f, i) => {
            if (file.xpath === f.xpath) {
                this.openedFiles[i].selected = true;
                this.openedFiles[i].state = this.monacoEditor.saveViewState();
                if (!this.openedFiles[i].model) {
                    this.openedFiles[i].model = monaco.editor.createModel(file.fileContent, this.editorLanguageMap[file.ext], this.editorLanguageMap[file.ext].compilerOptions);
                    this.editorOptions.model = this.openedFiles[i].model;
                }
                this.loadSelectedTab(file);
            }
            else {
                this.openedFiles[i].selected = false;
            }
        });
        this.changeDetectorRef.detectChanges();
    }
    closeFile(index) {
        this.openedFiles.splice(index, 1);
    }
    updateOpenedFiles(identifier, data) {
        let index = this.openedFiles.findIndex(file => file.identifier === identifier);
        let oldData = this.openedFiles[index];
        let updatedData = { ...oldData, ...data };
        this.openedFiles[index] = updatedData;
    }
    removeOpenedFile(identifier) {
        let index = this.openedFiles.findIndex(file => file.identifier === identifier);
        if (index > -1) {
            this.openedFiles.splice(index, 1);
        }
    }
    static { this.ɵfac = function IdeComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IdeComponent)(i0.ɵɵdirectiveInject(EditorService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: IdeComponent, selectors: [["xf-ide"]], viewQuery: function IdeComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$9, 5);
            i0.ɵɵviewQuery(_c1$5, 5, ElementRef);
            i0.ɵɵviewQuery(TreeComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.editor = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.tref = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.tree = _t.first);
        } }, inputs: { treeData: "treeData", openedFiles: "openedFiles", treeOperationAPI: "treeOperationAPI" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 10, vars: 8, consts: [["editor", ""], [1, "ide"], [1, "body"], ["class", "explorer", 3, "ngClass", 4, "ngIf"], [1, "editor-wrapper", 3, "ngClass"], ["class", "editor-settings", 4, "ngIf"], ["class", "editor-tabs", 4, "ngIf"], [4, "ngIf"], [3, "ngClass"], [1, "editor"], [1, "explorer", 3, "ngClass"], [1, "margin-top-sm"], ["class", "float-start font-size-14", 4, "ngIf"], [1, "fa", "padding-top-2", 3, "click", "ngClass"], [1, "clearfix"], ["class", "tree-wrapper", 4, "ngIf"], [1, "float-start", "font-size-14"], [1, "tree-wrapper"], [1, "container"], [1, "box"], ["class", "overlay", 4, "ngIf"], [1, "overlay"], [1, "absolute-position", 3, "menuItems", "menuClickOut", "contextMenuPosition"], [1, "editor-settings"], [1, "editor-tabs"], [1, "nav", "nav-tabs"], ["class", "uib-tab nav-item", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "uib-tab", "nav-item", 3, "ngClass"], [1, "tab"], [1, "nav-link", "name", 3, "click"], ["role", "button", 1, "close", "fa", "fa-close", 3, "click"]], template: function IdeComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2);
            i0.ɵɵtemplate(2, IdeComponent_div_2_Template, 6, 7, "div", 3);
            i0.ɵɵelementStart(3, "div", 4);
            i0.ɵɵtemplate(4, IdeComponent_div_4_Template, 1, 0, "div", 5)(5, IdeComponent_div_5_Template, 3, 1, "div", 6)(6, IdeComponent_div_6_Template, 2, 0, "div", 7);
            i0.ɵɵelementStart(7, "div", 8);
            i0.ɵɵelement(8, "div", 9, 0);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.treeData);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", ctx.collapsed ? "col-lg-11 editor-wrapper-expanded" : "col-lg-10 editor-wrapper-collapsed");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.openedFiles.length > 0);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.monacoEditorLoaded);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.monacoEditorLoaded);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c2$3, ctx.monacoEditorLoaded));
        } }, dependencies: [CommonModule, i1.NgClass, i1.NgForOf, i1.NgIf, ContextMenuComponent], styles: [".ide[_ngcontent-%COMP%]{padding-left:25px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]{display:flex}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer[_ngcontent-%COMP%]{padding-top:10px;float:left;width:140px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer[_ngcontent-%COMP%]   .tree-wrapper[_ngcontent-%COMP%]{border:1px solid;overflow-x:auto;overflow-y:auto;height:calc(100vh - 160px);width:auto;padding-left:10px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer[_ngcontent-%COMP%]   .root-node[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]{margin-left:10px;margin-right:2px;font-size:12px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer[_ngcontent-%COMP%]   .node-selected[_ngcontent-%COMP%]{color:red}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer-collapsed[_ngcontent-%COMP%]{margin-top:5px;border:1px solid;height:calc(100vh - 60px)}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]{margin:5px;float:right}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-settings[_ngcontent-%COMP%]{border:1px solid;height:40px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-tabs[_ngcontent-%COMP%]{margin-top:2px;border:1px solid;height:auto}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-tabs[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]{display:flex}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-tabs[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]   .name[_ngcontent-%COMP%]{padding-left:5px;padding-right:5px;cursor:pointer}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-tabs[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]   .close[_ngcontent-%COMP%]{margin-top:13px;margin-right:10px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .tab-selected[_ngcontent-%COMP%]{background:var(--navbar-active-bg-color)}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .code-editor[_ngcontent-%COMP%]{height:70vh}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   [hidden][_ngcontent-%COMP%]{display:none!important}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper-collapsed[_ngcontent-%COMP%]{width:calc(80vw - 118px)}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper-expanded[_ngcontent-%COMP%]{width:calc(90vw - 45px)}.ide[_ngcontent-%COMP%]   .editor[_ngcontent-%COMP%]{height:100%;border:1px solid!important;overflow:auto}.ide[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]{position:relative}.ide[_ngcontent-%COMP%]   .box[_ngcontent-%COMP%]{position:absolute;top:0;left:0}.ide[_ngcontent-%COMP%]   .overlay[_ngcontent-%COMP%]{z-index:9}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IdeComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [CommonModule, ContextMenuComponent], selector: 'xf-ide', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n\n\n<div class=\"ide\">\n  <div class=\"body\">\n    <!-- Tree -->\n    <div *ngIf=\"treeData\" class=\"explorer\" [ngClass]=\"{'col-lg-2' : !collapsed, 'explorer-collapsed': collapsed}\">\n      <div class=\"margin-top-sm\">\n        <div class=\"float-start font-size-14\" *ngIf=\"!collapsed\">EXPLORER</div>\n        <div class=\"fa padding-top-2\" (click)=\"collapsed = !collapsed\"\n          [ngClass]=\"collapsed ? 'fa-caret-right fload-start' : 'fa-caret-left float-end'\"></div>\n        <div class=\"clearfix\"></div>\n      </div>\n      <div *ngIf=\"!collapsed\" class=\"tree-wrapper\">\n\n        <div class=\"container\">\n          <div class=\"box\">\n            <!-- <tree-root #tree class=\"relative-position\" [nodes]=\"treeData\" [options]=\"treeOptions\">\n              <ng-template #treeNodeTemplate let-node let-index=\"index\">\n                <span *ngIf=\"!node.data.rename && !node.data.new\" [ngClass]=\"{'node-selected': node.isFocused}\">{{\n                  node.data.name\n                  }}</span>\n                <span *ngIf=\"node.data.isRootFolder\" class=\"root-node\">\n                  <em class=\"fa fa-file item\" (click)=\"onAddNode(node)\"></em>\n                  <em class=\"fa fa-folder item\" (click)=\"onAddGroupNode(node)\"></em>\n                  <em class=\" fa fa-upload item\"></em>\n                  <em class=\"fa fa-trash item\" (click)=\"node.data.isFolder ? deleteGroupNode() : deleteNode()\"></em>\n                </span>\n                <input *ngIf=\"node.data.rename || node.data.new\" #nodeInput type=\"text\" value=\"{{ node.data.name }}\"\n                  (keyup.enter)=\"inputFileKeyUp(nodeInput.value, node)\"\n                  (focusout)=\"inputFocusOut(nodeInput.value, node)\">\n\n              </ng-template>\n            </tree-root> -->\n\n          </div>\n          <div *ngIf=\"contextMenuClicked\" class=\"overlay\">\n            <xf-context-menu class=\"absolute-position\" [menuItems]=\"getMenuOption(selectedNode.data)\"\n              [menuClickOut]=\"menuClickOut\" [contextMenuPosition]=\"contextMenuPosition\">\n            </xf-context-menu>\n          </div>\n        </div>\n      </div>\n    </div>\n    <!-- Editor  -->\n    <div class=\"editor-wrapper\"\n      [ngClass]=\"collapsed ? 'col-lg-11 editor-wrapper-expanded' : 'col-lg-10 editor-wrapper-collapsed'\">\n      <div *ngIf=\"openedFiles.length > 0\" class=\"editor-settings\"></div>\n      <div *ngIf=\"monacoEditorLoaded\" class=\"editor-tabs\">\n        <ul class=\"nav nav-tabs\">\n          <li *ngFor=\"let file of openedFiles; let i = index\" class=\"uib-tab nav-item\"\n            [ngClass]=\"{'tab-selected': file.selected}\">\n            <div class=\"tab\">\n              <a (click)=\"setSelectedTab(file)\" class=\"nav-link name\">\n                <span>{{file.name}}</span>\n              </a>\n              <i class=\"close fa fa-close\" (click)=\"closeFile(i)\" role=\"button\"></i>\n            </div>\n\n          </li>\n        </ul>\n      </div>\n      <div *ngIf=\"!monacoEditorLoaded\">\n        Loading Editor ...\n      </div>\n\n      <div [ngClass]=\"{'code-editor': monacoEditorLoaded}\">\n        <div class=\"editor\" #editor></div>\n      </div>\n    </div>\n  </div>\n</div>\n", styles: [".ide{padding-left:25px}.ide .body{display:flex}.ide .body .explorer{padding-top:10px;float:left;width:140px}.ide .body .explorer .tree-wrapper{border:1px solid;overflow-x:auto;overflow-y:auto;height:calc(100vh - 160px);width:auto;padding-left:10px}.ide .body .explorer .root-node .item{margin-left:10px;margin-right:2px;font-size:12px}.ide .body .explorer .node-selected{color:red}.ide .body .explorer-collapsed{margin-top:5px;border:1px solid;height:calc(100vh - 60px)}.ide .body .editor-wrapper{margin:5px;float:right}.ide .body .editor-wrapper .editor-settings{border:1px solid;height:40px}.ide .body .editor-wrapper .editor-tabs{margin-top:2px;border:1px solid;height:auto}.ide .body .editor-wrapper .editor-tabs .tab{display:flex}.ide .body .editor-wrapper .editor-tabs .tab .name{padding-left:5px;padding-right:5px;cursor:pointer}.ide .body .editor-wrapper .editor-tabs .tab .close{margin-top:13px;margin-right:10px}.ide .body .editor-wrapper .tab-selected{background:var(--navbar-active-bg-color)}.ide .body .editor-wrapper .code-editor{height:70vh}.ide .body .editor-wrapper [hidden]{display:none!important}.ide .body .editor-wrapper-collapsed{width:calc(80vw - 118px)}.ide .body .editor-wrapper-expanded{width:calc(90vw - 45px)}.ide .editor{height:100%;border:1px solid!important;overflow:auto}.ide .container{position:relative}.ide .box{position:absolute;top:0;left:0}.ide .overlay{z-index:9}\n"] }]
    }], () => [{ type: EditorService }, { type: i0.ChangeDetectorRef }], { treeData: [{
            type: Input
        }], openedFiles: [{
            type: Input
        }], treeOperationAPI: [{
            type: Input
        }], editor: [{
            type: ViewChild,
            args: ['editor', { static: false }]
        }], tref: [{
            type: ViewChild,
            args: ["nodeInput", { read: ElementRef }]
        }], tree: [{
            type: ViewChild,
            args: [TreeComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(IdeComponent, { className: "IdeComponent", filePath: "lib/components/ide/ide.component.ts", lineNumber: 25 }); })();

class TreeOperationAPI {
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class LogoutPromptComponent {
    constructor(activeModal, formBuilder) {
        this.activeModal = activeModal;
        this.formBuilder = formBuilder;
        this.logoutMessage = 'You are being force logged out by the admin for administrative purposes. Please get in touch with admin for more information.';
    }
    ngOnInit() {
        this.field = new TextareaField('logoutMessage');
        this.field.title = `Provide a custom message to show the user while being forced a logout:`;
        this.field.placeholder = `Add custom message to show user being force logged out...`;
        this.field.validation = {
            required: true,
            maxlength: 255
        };
        this.field.params = {
            rows: 4
        };
        this.formGroup = this.formBuilder.group({
            editableField: []
        });
        this.formGroup.setValue({
            editableField: this.logoutMessage
        });
    }
    logout() {
        this.activeModal.close(this.formGroup.controls.editableField.value);
    }
    static { this.ɵfac = function LogoutPromptComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LogoutPromptComponent)(i0.ɵɵdirectiveInject(i3.NgbActiveModal), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LogoutPromptComponent, selectors: [["xf-logout-prompt"]], standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 12, vars: 3, consts: [[3, "formGroup"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body", "p-3"], ["formControlName", "editableField", 3, "field"], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "button", "ngbAutofocus", "", 1, "btn", "btn-outline-primary", 3, "click", "disabled"]], template: function LogoutPromptComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "form", 0)(1, "div", 1)(2, "h4", 2);
            i0.ɵɵtext(3, "Force Logout User");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "button", 3);
            i0.ɵɵlistener("click", function LogoutPromptComponent_Template_button_click_4_listener() { return ctx.activeModal.close(false); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 4);
            i0.ɵɵelement(6, "xf-form-field", 5);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(7, "div", 6)(8, "button", 7);
            i0.ɵɵlistener("click", function LogoutPromptComponent_Template_button_click_8_listener() { return ctx.activeModal.close(false); });
            i0.ɵɵtext(9, "Cancel");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(10, "button", 8);
            i0.ɵɵlistener("click", function LogoutPromptComponent_Template_button_click_10_listener() { return ctx.logout(); });
            i0.ɵɵtext(11, "Confirm");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(6);
            i0.ɵɵproperty("field", ctx.field);
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("disabled", ctx.formGroup.invalid);
        } }, dependencies: [CommonModule, XFFormFieldsModule, FormFieldComponent, ReactiveFormsModule, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LogoutPromptComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [CommonModule, XFFormFieldsModule, ReactiveFormsModule], selector: 'xf-logout-prompt', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form [formGroup]=\"formGroup\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Force Logout User</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"activeModal.close(false)\"></button>\n  </div>\n  <div class=\"modal-body p-3\">\n    <xf-form-field [field]=\"field\" formControlName=\"editableField\"></xf-form-field>\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"activeModal.close(false)\">Cancel</button>\n    <button type=\"button\" class=\"btn btn-outline-primary\" ngbAutofocus (click)=\"logout()\"\n      [disabled]=\"formGroup.invalid\">Confirm</button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i3.NgbActiveModal }, { type: i2.FormBuilder }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LogoutPromptComponent, { className: "LogoutPromptComponent", filePath: "lib/components/logout-prompt/logout-prompt.component.ts", lineNumber: 21 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$8 = ["message", ""];
class AlertModalComponent {
    constructor(activeModal) {
        this.activeModal = activeModal;
    }
    static { this.ɵfac = function AlertModalComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AlertModalComponent)(i0.ɵɵdirectiveInject(i3.NgbActiveModal)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AlertModalComponent, selectors: [["xf-alert-modal", "message", ""]], inputs: { modalTitle: "modalTitle", message: "message" }, attrs: _c0$8, decls: 11, vars: 2, consts: [[1, "modal-header", "padding-bottom-0px", "padding-left-18px", "padding-right-18px", "padding-top-20px", "alert-modal-header"], [1, "d-flex"], [1, "alert-icon"], [1, "modal-title", "font-size-20px"], ["type", "button", "aria-label", "Close", 1, "btn", "btn-close", "btn-sm", "modal-btn-close", 3, "click"], [1, "modal-body"], [1, "font-size-14px", "margin-left-40px", "muted-10", "padding-left-12px", "padding-right-12px", 3, "innerHTML"], [1, "modal-footer", "padding-bottom-8px", "padding-top-8px", "padding-left-18px", "padding-right-18px", "alert-modal-footer"], ["type", "button", "ngbAutofocus", "", 1, "btn", "btn-primary", "btn-sm", 3, "click"]], template: function AlertModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1);
            i0.ɵɵelement(2, "span", 2);
            i0.ɵɵelementStart(3, "h4", 3);
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "button", 4);
            i0.ɵɵlistener("click", function AlertModalComponent_Template_button_click_5_listener() { return ctx.activeModal.close(false); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 5);
            i0.ɵɵelement(7, "p", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 7)(9, "button", 8);
            i0.ɵɵlistener("click", function AlertModalComponent_Template_button_click_9_listener() { return ctx.activeModal.close(true); });
            i0.ɵɵtext(10, "OK");
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵtextInterpolate(ctx.modalTitle || "Alert");
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("innerHTML", ctx.message, i0.ɵɵsanitizeHtml);
        } }, styles: [".modal-header[_ngcontent-%COMP%]{border-top:4px solid var(--toaster-warning-color)}.modal-header.alert-modal-header[_ngcontent-%COMP%]{border-bottom:none}.modal-header[_ngcontent-%COMP%]   .alert-icon[_ngcontent-%COMP%]{background-image:var(--toaster-warning-svg);background-size:28px 28px;width:28px;height:28px;margin-right:12px;background-repeat:no-repeat}.modal-header[_ngcontent-%COMP%]   .modal-btn-close[_ngcontent-%COMP%]{background-image:var(--modal-close-btn-icon);background-size:10px}.modal-footer[_ngcontent-%COMP%]{border-top:1px solid var(--highlight-default-color)}.modal-footer.alert-modal-footer[_ngcontent-%COMP%]{border-top:1px solid var(--modal-footer-border-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AlertModalComponent, [{
        type: Component,
        args: [{ selector: 'xf-alert-modal[message]', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"modal-header padding-bottom-0px padding-left-18px padding-right-18px padding-top-20px alert-modal-header\">\n  <div class=\"d-flex\">\n    <span class=\"alert-icon\"></span>\n    <h4 class=\"modal-title font-size-20px\">{{ modalTitle || 'Alert' }}</h4>\n  </div>\n  <button type=\"button\" class=\"btn btn-close btn-sm modal-btn-close\" aria-label=\"Close\"\n    (click)=\"activeModal.close(false)\"></button>\n</div>\n<div class=\"modal-body\">\n  <p class=\"font-size-14px margin-left-40px muted-10 padding-left-12px padding-right-12px\" [innerHTML]=\"message\"></p>\n</div>\n<div class=\"modal-footer padding-bottom-8px padding-top-8px padding-left-18px padding-right-18px alert-modal-footer\">\n  <button type=\"button\" class=\"btn btn-primary btn-sm\" ngbAutofocus (click)=\"activeModal.close(true)\">OK</button>\n</div>\n\n", styles: [".modal-header{border-top:4px solid var(--toaster-warning-color)}.modal-header.alert-modal-header{border-bottom:none}.modal-header .alert-icon{background-image:var(--toaster-warning-svg);background-size:28px 28px;width:28px;height:28px;margin-right:12px;background-repeat:no-repeat}.modal-header .modal-btn-close{background-image:var(--modal-close-btn-icon);background-size:10px}.modal-footer{border-top:1px solid var(--highlight-default-color)}.modal-footer.alert-modal-footer{border-top:1px solid var(--modal-footer-border-color)}\n"] }]
    }], () => [{ type: i3.NgbActiveModal }], { modalTitle: [{
            type: Input
        }], message: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AlertModalComponent, { className: "AlertModalComponent", filePath: "lib/components/modals/alert-modal/alert-modal.component.ts", lineNumber: 14 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$7 = ["message", ""];
class ConfirmationModalComponent {
    constructor(activeModal) {
        this.activeModal = activeModal;
    }
    static { this.ɵfac = function ConfirmationModalComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ConfirmationModalComponent)(i0.ɵɵdirectiveInject(i3.NgbActiveModal)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ConfirmationModalComponent, selectors: [["xf-alert-modal", "message", ""]], inputs: { modalTitle: "modalTitle", message: "message" }, attrs: _c0$7, decls: 13, vars: 2, consts: [[1, "modal-header", "padding-bottom-0px", "padding-left-18px", "padding-right-18px", "padding-top-20px", "confirmation-modal-header"], [1, "d-flex"], [1, "confirmation-icon"], [1, "modal-title", "font-size-20px"], ["type", "button", "aria-label", "Close", 1, "btn", "btn-close", "btn-sm", "modal-btn-close", 3, "click"], [1, "modal-body"], [1, "font-size-14px", "margin-left-40px", "muted-10", "padding-left-12px", "padding-right-12px", 3, "innerHTML"], [1, "modal-footer", "padding-bottom-8px", "padding-top-8px", "padding-left-18px", "padding-right-18px", "confirmation-modal-footer"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", 3, "click"], ["type", "submit", "ngbAutofocus", "", 1, "btn", "btn-primary", "btn-sm", 3, "click"]], template: function ConfirmationModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1);
            i0.ɵɵelement(2, "span", 2);
            i0.ɵɵelementStart(3, "h4", 3);
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "button", 4);
            i0.ɵɵlistener("click", function ConfirmationModalComponent_Template_button_click_5_listener() { return ctx.activeModal.close(false); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 5);
            i0.ɵɵelement(7, "p", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 7)(9, "button", 8);
            i0.ɵɵlistener("click", function ConfirmationModalComponent_Template_button_click_9_listener() { return ctx.activeModal.close(false); });
            i0.ɵɵtext(10, "Cancel");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(11, "button", 9);
            i0.ɵɵlistener("click", function ConfirmationModalComponent_Template_button_click_11_listener() { return ctx.activeModal.close(true); });
            i0.ɵɵtext(12, "Yes, Confirm");
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵtextInterpolate(ctx.modalTitle || "Confirmation");
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("innerHTML", ctx.message, i0.ɵɵsanitizeHtml);
        } }, styles: [".modal-header[_ngcontent-%COMP%]{border-top:4px solid var(--toaster-info-color)}.modal-header.confirmation-modal-header[_ngcontent-%COMP%]{border-bottom:none}.modal-header[_ngcontent-%COMP%]   .confirmation-icon[_ngcontent-%COMP%]{background-image:var(--toaster-info-svg);background-size:28px 28px;width:28px;height:28px;margin-right:12px;background-repeat:no-repeat}.modal-header[_ngcontent-%COMP%]   .modal-btn-close[_ngcontent-%COMP%]{background-image:var(--modal-close-btn-icon);background-size:10px}.modal-footer[_ngcontent-%COMP%]{border-top:1px solid var(--highlight-default-color)}.modal-footer.confirmation-modal-footer[_ngcontent-%COMP%]{border-top:1px solid var(--modal-footer-border-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ConfirmationModalComponent, [{
        type: Component,
        args: [{ selector: 'xf-alert-modal[message]', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n\n<div class=\"modal-header padding-bottom-0px padding-left-18px padding-right-18px padding-top-20px confirmation-modal-header\">\n  <div class=\"d-flex\">\n    <span class=\"confirmation-icon\"></span>\n    <h4 class=\"modal-title font-size-20px\">{{ modalTitle || 'Confirmation' }}</h4>\n  </div>\n  <button type=\"button\" class=\"btn btn-close btn-sm modal-btn-close\" aria-label=\"Close\"\n    (click)=\"activeModal.close(false)\"></button>\n</div>\n<div class=\"modal-body\">\n  <p class=\"font-size-14px margin-left-40px muted-10 padding-left-12px padding-right-12px\" [innerHTML]=\"message\"></p>\n</div>\n<div class=\"modal-footer padding-bottom-8px padding-top-8px padding-left-18px padding-right-18px confirmation-modal-footer\">\n  <button type=\"button\" class=\"btn btn-secondary btn-sm\" (click)=\"activeModal.close(false)\">Cancel</button>\n  <button type=\"submit\" class=\"btn btn-primary btn-sm\" (click)=\"activeModal.close(true)\" ngbAutofocus>Yes, Confirm</button>\n</div>\n", styles: [".modal-header{border-top:4px solid var(--toaster-info-color)}.modal-header.confirmation-modal-header{border-bottom:none}.modal-header .confirmation-icon{background-image:var(--toaster-info-svg);background-size:28px 28px;width:28px;height:28px;margin-right:12px;background-repeat:no-repeat}.modal-header .modal-btn-close{background-image:var(--modal-close-btn-icon);background-size:10px}.modal-footer{border-top:1px solid var(--highlight-default-color)}.modal-footer.confirmation-modal-footer{border-top:1px solid var(--modal-footer-border-color)}\n"] }]
    }], () => [{ type: i3.NgbActiveModal }], { modalTitle: [{
            type: Input
        }], message: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ConfirmationModalComponent, { className: "ConfirmationModalComponent", filePath: "lib/components/modals/confirmation-modal/confirmation-modal.component.ts", lineNumber: 14 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ModalService {
    constructor(ngbModalService) {
        this.ngbModalService = ngbModalService;
    }
    confirm(message, modalTitle, modalClass = 'default') {
        let modalRef = this.ngbModalService.open(ConfirmationModalComponent, {
            backdrop: 'static'
        });
        modalRef.componentInstance.message = message;
        if (modalTitle) {
            modalRef.componentInstance.modalTitle = modalTitle;
        }
        let response$ = new Subject();
        modalRef.result.then((response) => {
            if (response) {
                response$.next(response);
                response$.complete();
            }
            else {
                response$.error(false);
            }
        }, () => {
            response$.error(false);
        });
        return response$.asObservable();
    }
    alert(message, modalTitle) {
        let modalRef = this.ngbModalService.open(AlertModalComponent, {
            backdrop: 'static'
        });
        modalRef.componentInstance.message = message;
        if (modalTitle) {
            modalRef.componentInstance.modalTitle = modalTitle;
        }
        return modalRef.closed;
    }
    static { this.ɵfac = function ModalService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModalService)(i0.ɵɵinject(i3.NgbModal)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModalService, factory: ModalService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModalService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i3.NgbModal }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$6 = ["formField"];
const _c1$4 = ["filterField"];
function FilterComponent_Conditional_6_option_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 12);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const operator_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", operator_r2.id);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(operator_r2.title);
} }
function FilterComponent_Conditional_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "select", 6);
    i0.ɵɵtemplate(1, FilterComponent_Conditional_6_option_1_Template, 2, 2, "option", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.field.operators);
} }
function FilterComponent_Conditional_8_ng_template_0_Template(rf, ctx) { }
function FilterComponent_Conditional_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, FilterComponent_Conditional_8_ng_template_0_Template, 0, 0, "ng-template", 7);
} }
function FilterComponent_Conditional_10_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 13);
    i0.ɵɵlistener("click", function FilterComponent_Conditional_10_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.deleteFilter()); });
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} }
function FilterComponent_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 10);
    i0.ɵɵelement(1, "xf-filter", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r2.subEntity)("isChild", true);
} }
class FilterComponent {
    constructor(changeDetectorRef, entityService, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.formBuilder = formBuilder;
        this.isChild = false;
        this.items = [];
        this.field = null;
        this.fieldRenderer = null;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.value = new Filter();
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
        this.formGroup = this.formBuilder.group({
            filterField: [null, Validators.required],
            operator: [null, Validators.required],
            value: [null],
            subDataFilter: [null]
        });
    }
    writeValue(value) {
        this.value = value || new Filter();
        let field = this.value.field;
        let subFilter = null;
        if (this.value.field && this.value.field?.indexOf('.') > -1) {
            const parts = this.value.field.split('.');
            field = parts[0];
            parts.shift();
            subFilter = cloneDeep(value);
            subFilter.field = parts.join('.');
            this.formGroup.controls.operator.clearValidators();
        }
        else {
            this.formGroup.controls.operator.setValidators(Validators.required);
        }
        this.fieldValue = field && this.entity.fields[field] ? this.entity.fields[field].asSearchableItem() : null;
        if (this.fieldValue) {
            this.setField(this.fieldValue.value);
        }
        this.formGroup.setValue({
            filterField: this.fieldValue,
            operator: this.value.operator,
            value: this.value.originalValue || this.value.value,
            subDataFilter: subFilter
        }, {
            emitEvent: false
        });
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnInit() {
        this.formGroup.controls.operator.valueChanges.subscribe((value) => this.operatorChanged(value));
        this.formGroup.controls.value.valueChanges.subscribe((value) => this.valueChanged(value));
        this.formGroup.controls.filterField.valueChanges.subscribe((value) => {
            this.fieldValue = value;
            this.fieldChanged();
        });
        this.formGroup.controls.subDataFilter.valueChanges.subscribe((value) => {
            if (!value) {
                this.onChange(null);
                return;
            }
            let fullValue = cloneDeep(value);
            fullValue.field = this.field?.name + '.' + value.field;
            this.value = fullValue;
            this.onChange(fullValue);
        });
        this.filterFields('');
    }
    filterFields(search) {
        of(this.entity.attributes).pipe(map((fields) => {
            return fields.map((field) => field.asSearchableItem());
        }), map((items) => {
            return items.filter((item) => {
                return isString(item.display) && item.display.toLowerCase().indexOf(search.toLowerCase()) > -1;
            });
        })).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    setField(field) {
        if (field && this.entity.fields[field.name].formType !== field.formType) {
            // Reset view
            this.field = null;
            this.fieldRenderer = null;
            this.changeDetectorRef.detectChanges();
        }
        this.field = field;
        if (field.data) {
            this.subEntity = this.entityService.createEntityFromData(field.data, 'sub-field-' + field.name);
            this.changeDetectorRef.detectChanges();
            return;
        }
        else {
            this.subEntity = undefined;
            this.changeDetectorRef.detectChanges();
        }
        if (this.value.operator) {
            const operator = this.field?.getOperator(this.value.operator);
            this.setRenderer(operator);
        }
        else {
            const defaultOperator = field.operators[0];
            this.setRenderer(defaultOperator);
            this.formGroup.controls.operator.setValue(defaultOperator.id);
        }
        this.changeDetectorRef.detectChanges();
    }
    fieldChanged() {
        if (!this.fieldValue) {
            return;
        }
        this.value.operator = null;
        this.value.field = this.fieldValue.value.name;
        this.setField(this.fieldValue.value);
        this.onChange(this.value);
    }
    operatorChanged(newOperatorId) {
        const operator = this.field?.getOperator(newOperatorId);
        this.value.operator = operator?.id || null;
        this.setRenderer(operator);
        this.onChange(this.value);
    }
    setRenderer(operator) {
        if (operator?.renderer) {
            this.fieldRenderer = operator.renderer;
        }
        else {
            this.fieldRenderer = InputFieldComponent;
        }
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        if (!this.field) {
            return;
        }
        let field = cloneDeep(this.field);
        field.name = field.name + '-renderer';
        this.componentRef = viewContainerRef.createComponent(this.fieldRenderer);
        this.componentRef.instance.field = field;
        this.componentRef.instance.fieldClass = 'form-control-sm';
        this.componentRef.instance.fieldOptions = this.fieldOptions;
        this.componentRef.instance.writeValue(this.value.value);
        this.componentRef.instance.onChange = (value) => this.valueChanged(value);
        if (!this.value.value && this.field.defaultValue) {
            this.componentRef.instance.value = this.field.defaultValue;
        }
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    valueChanged(value) {
        this.value.originalValue = value;
        this.value.value = this.field?.getFlatValue(value, this.field?.operators.find((operator) => this.value.operator === operator.id));
        this.onChange(this.value);
    }
    deleteFilter() {
        this.onChange(null);
    }
    validate(control) {
        return !this.value?.operator || !this.value?.field ? {
            required: true
        } : null;
    }
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        if (this.filterField.invalid) {
            this.filterField.setTouched();
            this.filterField.focus();
            return true;
        }
        return false;
    }
    static { this.ɵfac = function FilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(EntityService), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FilterComponent, selectors: [["xf-filter"]], viewQuery: function FilterComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$6, 5);
            i0.ɵɵviewQuery(_c1$4, 5);
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.filterField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.fieldSelect = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { entity: "entity", isChild: "isChild" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FilterComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FilterComponent),
                    multi: true
                }])], decls: 12, vars: 6, consts: [["filterField", ""], [3, "formGroup"], [1, "d-flex", "align-items-center"], [1, "col", "pe-1"], ["buttonStyle", "select", "formControlName", "filterField", "placeholder", "Select Field", 3, "searchQueryChange", "items"], [1, "col", "px-1"], ["formControlName", "operator", 1, "form-select", "form-select-sm"], ["xfViewContainer", ""], [1, "col", "col-delete", "ps-1"], ["type", "button", 1, "btn", "btn-sm", "btn-outline"], [1, "mt-2"], [3, "ngValue", 4, "ngFor", "ngForOf"], [3, "ngValue"], ["type", "button", 1, "btn", "btn-sm", "btn-outline", 3, "click"], [1, "fa", "fa-close", "text-danger"], ["formControlName", "subDataFilter", 3, "entity", "isChild"]], template: function FilterComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2)(2, "div", 3)(3, "xf-searchable-dropdown", 4, 0);
            i0.ɵɵlistener("searchQueryChange", function FilterComponent_Template_xf_searchable_dropdown_searchQueryChange_3_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.filterFields($event)); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5);
            i0.ɵɵtemplate(6, FilterComponent_Conditional_6_Template, 2, 1, "select", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(7, "div", 5);
            i0.ɵɵtemplate(8, FilterComponent_Conditional_8_Template, 1, 0, null, 7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(9, "div", 8);
            i0.ɵɵtemplate(10, FilterComponent_Conditional_10_Template, 2, 0, "button", 9);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(11, FilterComponent_Conditional_11_Template, 2, 2, "div", 10);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("items", ctx.items);
            i0.ɵɵadvance(3);
            i0.ɵɵconditional(ctx.field && !ctx.subEntity ? 6 : -1);
            i0.ɵɵadvance(2);
            i0.ɵɵconditional(!ctx.subEntity ? 8 : -1);
            i0.ɵɵadvance(2);
            i0.ɵɵconditional(!ctx.isChild ? 10 : -1);
            i0.ɵɵadvance();
            i0.ɵɵconditional(ctx.field && ctx.subEntity ? 11 : -1);
        } }, dependencies: [i1.NgForOf, ViewContainerDirective, SearchableDropdownComponent, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FilterComponent], styles: [".col-delete[_ngcontent-%COMP%]{flex:0 0 0}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-filter', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FilterComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FilterComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div [formGroup]=\"formGroup\">\n  <div class=\"d-flex align-items-center\">\n    <div class=\"col pe-1\">\n      <xf-searchable-dropdown #filterField buttonStyle=\"select\" formControlName=\"filterField\" [items]=\"items\"\n      placeholder=\"Select Field\" (searchQueryChange)=\"filterFields($event)\"></xf-searchable-dropdown>\n    </div>\n    <div class=\"col px-1\">\n      @if (field && !subEntity) {\n        <select class=\"form-select form-select-sm\" formControlName=\"operator\">\n          <option *ngFor=\"let operator of field.operators\" [ngValue]=\"operator.id\">{{ operator.title }}</option>\n        </select>\n      }\n    </div>\n    <div class=\"col px-1\">\n      @if (!subEntity) {\n        <!-- <xf-form-field *ngIf=\"fieldRenderer\" formControlName=\"value\" [field]=\"fieldRenderer\" [fieldOptions]=\"fieldOptions\" [fieldClass]=\"'form-control-sm'\" #formField></xf-form-field> -->\n        <ng-template xfViewContainer></ng-template>\n      }\n    </div>\n    <div class=\"col col-delete ps-1\">\n      @if (!isChild) {\n        <button type=\"button\" class=\"btn btn-sm btn-outline\" (click)=\"deleteFilter()\">\n          <i class=\"fa fa-close text-danger\"></i>\n        </button>\n      }\n    </div>\n  </div>\n  @if (field && subEntity) {\n    <div class=\"mt-2\">\n      <xf-filter [entity]=\"subEntity\" formControlName=\"subDataFilter\" [isChild]=\"true\"></xf-filter>\n    </div>\n  }\n\n</div>\n", styles: [".col-delete{flex:0 0 0}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: EntityService }, { type: i2.FormBuilder }], { entity: [{
            type: Input
        }], isChild: [{
            type: Input
        }], formField: [{
            type: ViewChild,
            args: ['formField', { static: false }]
        }], filterField: [{
            type: ViewChild,
            args: ['filterField', { static: false }]
        }], fieldSelect: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }], xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FilterComponent, { className: "FilterComponent", filePath: "lib/query-filters/filter/filter.component.ts", lineNumber: 38 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$5 = ["filterComponent"];
const _c1$3 = ["entity", ""];
const _c2$2 = (a0, a1) => ({ "margin-top-16px": a0, "border-start ms-0": a1 });
function FilterGroupComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 13);
    i0.ɵɵtext(1, "Filter Conditions");
    i0.ɵɵelementEnd();
} }
function FilterGroupComponent_div_0_label_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 14);
    i0.ɵɵtext(1, "Where");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "field-" + ctx_r1.depth);
} }
function FilterGroupComponent_div_0_select_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "select", 15)(1, "option");
    i0.ɵɵtext(2, "AND");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "option");
    i0.ɵɵtext(4, "OR");
    i0.ɵɵelementEnd()();
} }
function FilterGroupComponent_div_0_div_7_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-filter-group", 18, 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const filterIndex_r3 = i0.ɵɵnextContext().index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.entity)("formControlName", filterIndex_r3)("depth", ctx_r1.depth + 1);
} }
function FilterGroupComponent_div_0_div_7_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-filter", 19, 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const filterIndex_r3 = i0.ɵɵnextContext().index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.entity)("formControlName", filterIndex_r3);
} }
function FilterGroupComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtemplate(1, FilterGroupComponent_div_0_div_7_ng_container_1_Template, 3, 3, "ng-container", 17)(2, FilterGroupComponent_div_0_div_7_ng_container_2_Template, 3, 2, "ng-container", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const formControl_r4 = ctx.$implicit;
    const filterIndex_r3 = ctx.index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(3, _c2$2, filterIndex_r3 > 0, ctx_r1.depth > 0));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", formControl_r4.value == null ? null : formControl_r4.value.filters == null ? null : formControl_r4.value.filters.length);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !(formControl_r4.value == null ? null : formControl_r4.value.filters == null ? null : formControl_r4.value.filters.length));
} }
function FilterGroupComponent_div_0_button_11_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 20);
    i0.ɵɵlistener("click", function FilterGroupComponent_div_0_button_11_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.addFilter(true)); });
    i0.ɵɵtext(1, "+ Add Group");
    i0.ɵɵelementEnd();
} }
function FilterGroupComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, FilterGroupComponent_div_0_label_1_Template, 2, 0, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5);
    i0.ɵɵtemplate(4, FilterGroupComponent_div_0_label_4_Template, 2, 1, "label", 6)(5, FilterGroupComponent_div_0_select_5_Template, 5, 0, "select", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "div", 8);
    i0.ɵɵtemplate(7, FilterGroupComponent_div_0_div_7_Template, 3, 6, "div", 9);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(8, "div", 10)(9, "button", 11);
    i0.ɵɵlistener("click", function FilterGroupComponent_div_0_Template_button_click_9_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.addFilter()); });
    i0.ɵɵtext(10, "+ Add Condition");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(11, FilterGroupComponent_div_0_button_11_Template, 2, 0, "button", 12);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.depth === 0);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r1.filtersFormArray.controls.length === 1);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.filtersFormArray.controls.length > 1);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.filtersFormArray.controls);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngIf", ctx_r1.depth < 2);
} }
class FilterGroupComponent {
    constructor(changeDetectorRef, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.depth = 0;
        this.FilterGroup = FilterGroup;
        this.Filter = Filter;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.filtersFormArray = this.formBuilder.array([]);
        this.formGroup = this.formBuilder.group({
            logic: new FormControl('AND'),
            filters: this.filtersFormArray
        });
        this.formGroup.valueChanges.pipe(map$1((values) => {
            if (this.value) {
                this.value.logic = values.logic;
                values.filters.forEach((filter, filterIndex) => {
                    if (!filter) {
                        this.filtersFormArray.removeAt(filterIndex);
                    }
                });
                this.value.filters = compact(values.filters);
            }
            if (this.depth === 0 || this.value?.filters.length) {
                this.onChange(this.value);
            }
            else {
                // Remove the group if all filters are deleted
                this.onChange(null);
            }
            this.changeDetectorRef.detectChanges();
        })).subscribe();
    }
    writeValue(value) {
        // Clear it first
        while (this.filtersFormArray.length !== 0) {
            this.filtersFormArray.removeAt(0);
        }
        value?.filters.forEach((filter) => {
            this.filtersFormArray.push(new FormControl(filter));
        });
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    addFilter(group = false) {
        const newFilter = new Filter();
        const filter = group ? new FilterGroup([newFilter], 'AND') : newFilter;
        this.filtersFormArray.push(new FormControl(filter), {
            emitEvent: false
        });
        setTimeout(() => this.onChange(this.value));
    }
    validate(control) {
        return this.formGroup.invalid ? {
            required: true
        } : null;
    }
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        for (let filterComponent of this.filterComponents) {
            if (filterComponent.focusOnFirstInvalidInput()) {
                return true;
            }
        }
        return false;
    }
    static { this.ɵfac = function FilterGroupComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterGroupComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FilterGroupComponent, selectors: [["xf-filter-group", "entity", ""]], viewQuery: function FilterGroupComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$5, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.filterComponents = _t);
        } }, inputs: { entity: "entity", depth: "depth" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FilterGroupComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FilterGroupComponent),
                    multi: true
                }])], attrs: _c1$3, decls: 1, vars: 1, consts: [["filterComponent", ""], [3, "formGroup", 4, "ngIf"], [3, "formGroup"], ["class", "form-label", 4, "ngIf"], [1, "d-flex"], [1, "w-80px", "d-flex", "align-items-start"], ["class", "col-form-label font-size-14px mx-2", 3, "for", 4, "ngIf"], ["formControlName", "logic", "class", "form-select w-auto form-select-sm", 4, "ngIf"], ["formArrayName", "filters", 1, "flex-grow-1"], [3, "ngClass", 4, "ngFor", "ngForOf"], [1, "btn-group", "margin-top-16px"], ["type", "button", 1, "btn", "btn-link", "btn-xs", "p-0", "margin-right-12px", 3, "click"], ["type", "button", "class", "btn btn-link btn-xs p-0", 3, "click", 4, "ngIf"], [1, "form-label"], [1, "col-form-label", "font-size-14px", "mx-2", 3, "for"], ["formControlName", "logic", 1, "form-select", "w-auto", "form-select-sm"], [3, "ngClass"], [4, "ngIf"], [3, "entity", "formControlName", "depth"], [3, "entity", "formControlName"], ["type", "button", 1, "btn", "btn-link", "btn-xs", "p-0", 3, "click"]], template: function FilterGroupComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FilterGroupComponent_div_0_Template, 12, 6, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.value);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i2.FormArrayName, FilterGroupComponent, FilterComponent], styles: [".w-120px[_ngcontent-%COMP%]{width:120px}.select-block[_ngcontent-%COMP%]{border:1px solid var(--element-default-border-color);border-radius:3px;color:var(--btn-select-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterGroupComponent, [{
        type: Component,
        args: [{ selector: 'xf-filter-group[entity]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FilterGroupComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FilterGroupComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *ngIf=\"value\" [formGroup]=\"formGroup\">\n  <label class=\"form-label\" *ngIf=\"depth === 0\">Filter Conditions</label>\n  <div class=\"d-flex\">\n    <div class=\"w-80px d-flex align-items-start\">\n      <label [for]=\"'field-' + depth\" class=\"col-form-label font-size-14px mx-2\"\n        *ngIf=\"filtersFormArray.controls.length === 1\">Where</label>\n      <select formControlName=\"logic\" class=\"form-select w-auto form-select-sm\" *ngIf=\"filtersFormArray.controls.length > 1\">\n        <option>AND</option>\n        <option>OR</option>\n      </select>\n    </div>\n    <div formArrayName=\"filters\" class=\"flex-grow-1\">\n      <div [ngClass]=\"{'margin-top-16px': filterIndex > 0, 'border-start ms-0': depth > 0}\"\n        *ngFor=\"let formControl of filtersFormArray.controls; let filterIndex = index\">\n        <!-- <span class=\"content-font padding-bottom-6px padding-left-16px padding-right-16px padding-top-6px select-block\" *ngIf=\"filterIndex > 1\">{{\n          value.logic }}</span> -->\n        <ng-container *ngIf=\"$any(formControl.value)?.filters?.length\">\n          <xf-filter-group [entity]=\"entity\" [formControlName]=\"filterIndex\" [depth]=\"depth + 1\" #filterComponent></xf-filter-group>\n        </ng-container>\n        <ng-container *ngIf=\"!$any(formControl.value)?.filters?.length\">\n          <xf-filter [entity]=\"entity\" [formControlName]=\"filterIndex\" #filterComponent></xf-filter>\n        </ng-container>\n      </div>\n    </div>\n  </div>\n  <div class=\"btn-group margin-top-16px\">\n    <button type=\"button\" class=\"btn btn-link btn-xs p-0 margin-right-12px\" (click)=\"addFilter()\">+ Add\n      Condition</button>\n    <button type=\"button\" class=\"btn btn-link btn-xs p-0\" (click)=\"addFilter(true)\" *ngIf=\"depth < 2\">+ Add\n      Group</button>\n  </div>\n\n</div>\n", styles: [".w-120px{width:120px}.select-block{border:1px solid var(--element-default-border-color);border-radius:3px;color:var(--btn-select-color)}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { filterComponents: [{
            type: ViewChildren,
            args: ['filterComponent']
        }], entity: [{
            type: Input
        }], depth: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FilterGroupComponent, { className: "FilterGroupComponent", filePath: "lib/query-filters/filter-group/filter-group.component.ts", lineNumber: 30 }); })();

function BulkDeleteModalComponent_form_0_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "xf-filter-group", 11);
    i0.ɵɵtwoWayListener("ngModelChange", function BulkDeleteModalComponent_form_0_ng_container_9_Template_xf_filter_group_ngModelChange_1_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); i0.ɵɵtwoWayBindingSet(ctx_r1.filterGroup, $event) || (ctx_r1.filterGroup = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵlistener("ngModelChange", function BulkDeleteModalComponent_form_0_ng_container_9_Template_xf_filter_group_ngModelChange_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.filterGroupChange()); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.filterGroup);
    i0.ɵɵproperty("entity", ctx_r1.entity);
} }
function BulkDeleteModalComponent_form_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "form", 2, 0);
    i0.ɵɵlistener("ngSubmit", function BulkDeleteModalComponent_form_0_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.runDelete()); });
    i0.ɵɵelementStart(2, "div", 3)(3, "h4", 4);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "button", 5);
    i0.ɵɵlistener("click", function BulkDeleteModalComponent_form_0_Template_button_click_5_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(6, "div", 6)(7, "p");
    i0.ɵɵtext(8);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(9, BulkDeleteModalComponent_form_0_ng_container_9_Template, 2, 2, "ng-container", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(10, "div", 8)(11, "button", 9);
    i0.ɵɵlistener("click", function BulkDeleteModalComponent_form_0_Template_button_click_11_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵtext(12, "Cancel");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(13, "button", 10);
    i0.ɵɵtext(14, "Delete");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("Delete ", ctx_r1.entity.descriptions.plural, " By Condition");
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", ctx_r1.entity.descriptions.plural, " that match the following filters will be deleted:");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.filterGroup && ctx_r1.entity);
} }
class BulkDeleteModalComponent {
    constructor(activeModal, http, modalService) {
        this.activeModal = activeModal;
        this.http = http;
        this.modalService = modalService;
        this.filterGroup = null;
    }
    ngOnInit() {
        this.filterGroup = this.query;
    }
    filterGroupChange() {
        if (!this.filterGroup) {
            return;
        }
        this.query = this.filterGroup;
    }
    runDelete() {
        const data = this.query.getQueryObject();
        this.http.post(API.QUERY + this.entity.type, data, {
            params: {
                $limit: 1
            }
        }).pipe(concatMap$1((response) => {
            return this.modalService.confirm('Are you sure you want to delete ' + response['hydra:totalItems'] + ' ' + this.entity.descriptions.plural + '?')
                .pipe(concatMap$1((result) => {
                if (!result) {
                    return of();
                }
                return this.http.request('delete', API.DELETE_WITH_QUERY + this.entity.type, { body: data });
            }));
        })).subscribe(() => {
            this.activeModal.close();
        });
    }
    cancel() {
        this.activeModal.dismiss();
    }
    static { this.ɵfac = function BulkDeleteModalComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || BulkDeleteModalComponent)(i0.ɵɵdirectiveInject(i3.NgbActiveModal), i0.ɵɵdirectiveInject(i1$1.HttpClient), i0.ɵɵdirectiveInject(ModalService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BulkDeleteModalComponent, selectors: [["xf-bulk-delete-modal"]], inputs: { entity: "entity", query: "query" }, decls: 1, vars: 0, consts: [["formElement", ""], ["name", "generate-shifts", "novalidate", "", 3, "ngSubmit", 4, "transloco"], ["name", "generate-shifts", "novalidate", "", 3, "ngSubmit"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body", "px-3", "pb-5"], [4, "ngIf"], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-danger"], ["name", "filterGroup", 3, "ngModelChange", "ngModel", "entity"]], template: function BulkDeleteModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, BulkDeleteModalComponent_form_0_Template, 15, 3, "form", 1);
        } }, dependencies: [i1.NgIf, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.NgModel, i2.NgForm, i4.TranslocoDirective, FilterGroupComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BulkDeleteModalComponent, [{
        type: Component,
        args: [{ selector: 'xf-bulk-delete-modal', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form name=\"generate-shifts\" (ngSubmit)=\"runDelete()\" novalidate #formElement *transloco=\"let t\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Delete {{ entity.descriptions.plural }} By Condition</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"cancel()\"></button>\n  </div>\n  <div class=\"modal-body px-3 pb-5\">\n    <p>{{ entity.descriptions.plural }} that match the following filters will be deleted:</p>\n    <ng-container *ngIf=\"filterGroup && entity\">\n      <xf-filter-group [(ngModel)]=\"filterGroup\" (ngModelChange)=\"filterGroupChange()\" name=\"filterGroup\" [entity]=\"entity\">\n      </xf-filter-group>\n    </ng-container>\n\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"cancel()\">Cancel</button>\n    <button type=\"submit\" class=\"btn btn-outline-danger\">Delete</button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i3.NgbActiveModal }, { type: i1$1.HttpClient }, { type: ModalService }], { entity: [{
            type: Input
        }], query: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(BulkDeleteModalComponent, { className: "BulkDeleteModalComponent", filePath: "lib/components/modals/bulk-delete-modal/bulk-delete-modal.component.ts", lineNumber: 21 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class QueryFiltersModule {
    static { this.ɵfac = function QueryFiltersModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || QueryFiltersModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: QueryFiltersModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            UtilityModule,
            SearchableDropdownModule,
            ReactiveFormsModule,
            XFFormFieldsModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(QueryFiltersModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    FilterGroupComponent,
                    FilterComponent
                ],
                imports: [
                    CommonModule,
                    UtilityModule,
                    SearchableDropdownModule,
                    ReactiveFormsModule,
                    XFFormFieldsModule
                ],
                exports: [
                    FilterComponent,
                    FilterGroupComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(QueryFiltersModule, { declarations: [FilterGroupComponent,
        FilterComponent], imports: [CommonModule,
        UtilityModule,
        SearchableDropdownModule,
        ReactiveFormsModule,
        XFFormFieldsModule], exports: [FilterComponent,
        FilterGroupComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ModalsModule {
    static { this.ɵfac = function ModalsModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModalsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ModalsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            TranslocoModule,
            QueryFiltersModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModalsModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    ConfirmationModalComponent,
                    BulkDeleteModalComponent,
                    AlertModalComponent
                ],
                imports: [
                    CommonModule,
                    FormsModule,
                    TranslocoModule,
                    QueryFiltersModule
                ],
                exports: [
                    ConfirmationModalComponent,
                    BulkDeleteModalComponent,
                    AlertModalComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ModalsModule, { declarations: [ConfirmationModalComponent,
        BulkDeleteModalComponent,
        AlertModalComponent], imports: [CommonModule,
        FormsModule,
        TranslocoModule,
        QueryFiltersModule], exports: [ConfirmationModalComponent,
        BulkDeleteModalComponent,
        AlertModalComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$4 = () => [""];
function ErrorPageComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵelement(1, "img", 4);
    i0.ɵɵelementStart(2, "div", 5)(3, "h1", 6);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "h2");
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "p", 7);
    i0.ɵɵtext(8);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "p", 8);
    i0.ɵɵtext(10);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(11, "button", 9);
    i0.ɵɵlistener("click", function ErrorPageComponent_div_0_div_1_Template_button_click_11_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.goBack()); });
    i0.ɵɵtext(12);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(13, "button", 10);
    i0.ɵɵtext(14);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const t_r3 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("src", ctx_r1.errorObjects[ctx_r1.errorCode].icon, i0.ɵɵsanitizeUrl);
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(ctx_r1.errorCode);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.errorObjects[ctx_r1.errorCode].error);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.errorObjects[ctx_r1.errorCode].errorText);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.errorObjects[ctx_r1.errorCode].description);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(t_r3("error.errorPage.goBack"));
    i0.ɵɵadvance();
    i0.ɵɵproperty("routerLink", i0.ɵɵpureFunction0(8, _c0$4));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(t_r3("error.errorPage.goHome"));
} }
function ErrorPageComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, ErrorPageComponent_div_0_div_1_Template, 15, 9, "div", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.errorObjects[ctx_r1.errorCode]);
} }
class ErrorPageComponent {
    constructor(location) {
        this.location = location;
        this.errorCode = 404;
    }
    ngOnInit() {
        if (!this.errorCode) {
            this.errorCode = 404;
        }
        this.errorObjects = ERROR_OBJECTS;
    }
    goBack() {
        this.location.back();
    }
    static { this.ɵfac = function ErrorPageComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ErrorPageComponent)(i0.ɵɵdirectiveInject(i1.Location)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ErrorPageComponent, selectors: [["xf-error-page"]], inputs: { errorCode: [2, "errorCode", "errorCode", numberAttribute], errorObjects: "errorObjects" }, standalone: true, features: [i0.ɵɵInputTransformsFeature, i0.ɵɵStandaloneFeature], decls: 1, vars: 0, consts: [["class", "h-100 d-flex align-items-center justify-content-center error-page", 4, "transloco"], [1, "h-100", "d-flex", "align-items-center", "justify-content-center", "error-page"], ["class", "d-flex", 4, "ngIf"], [1, "d-flex"], [1, "h-250px", 3, "src"], [1, "error-contianer"], [1, "font-size-100px"], [1, "text-body", "mb-1"], [1, "text-body-tertiary"], ["id", "go-home", "type", "button", 1, "btn", "btn-sm", "btn-primary", "margin-right-8px", 3, "click"], ["id", "go-home", "type", "button", 1, "btn", "btn-sm", "btn-primary", "margin-right-8px", 3, "routerLink"]], template: function ErrorPageComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ErrorPageComponent_div_0_Template, 2, 1, "div", 0);
        } }, dependencies: [CommonModule, i1.NgIf, RouterModule, i1$2.RouterLink, TranslocoModule, i4.TranslocoDirective], styles: [".error-page[_ngcontent-%COMP%]{background-image:url(/assets/images/error_page_bg.svg);background-repeat:no-repeat;background-size:cover}.error-contianer[_ngcontent-%COMP%]{max-width:1000px;margin-left:200px}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ErrorPageComponent, [{
        type: Component,
        args: [{ selector: 'xf-error-page', standalone: true, imports: [CommonModule, RouterModule, TranslocoModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"h-100 d-flex align-items-center justify-content-center error-page\" *transloco=\"let t\">\n  <div class=\"d-flex\" *ngIf=\"errorObjects[errorCode]\">\n    <img [src]=\"errorObjects[errorCode].icon\" class=\"h-250px\">\n    <div class=\"error-contianer\">\n      <h1 class=\"font-size-100px\">{{errorCode}}</h1>\n      <h2>{{errorObjects[errorCode].error}}</h2>\n      <p class=\"text-body mb-1\">{{errorObjects[errorCode].errorText}}</p>\n      <p class=\"text-body-tertiary\">{{errorObjects[errorCode].description}}</p>\n      <button class=\"btn btn-sm btn-primary margin-right-8px\" id=\"go-home\" type=\"button\"\n        (click)=\"goBack()\">{{t('error.errorPage.goBack') }}</button>\n      <button class=\"btn btn-sm btn-primary margin-right-8px\" id=\"go-home\" type=\"button\"\n        [routerLink]=\"['']\">{{t('error.errorPage.goHome') }}</button>\n    </div>\n  </div>\n</div>\n", styles: [".error-page{background-image:url(/assets/images/error_page_bg.svg);background-repeat:no-repeat;background-size:cover}.error-contianer{max-width:1000px;margin-left:200px}\n"] }]
    }], () => [{ type: i1.Location }], { errorCode: [{
            type: Input,
            args: [{ transform: numberAttribute }]
        }], errorObjects: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ErrorPageComponent, { className: "ErrorPageComponent", filePath: "lib/components/error-page/error-page.component.ts", lineNumber: 19 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function TabPageComponent_ng_container_0_h3_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "h3", 6);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r2 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(t_r2(ctx_r2.title));
} }
function TabPageComponent_ng_container_0_li_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li", 7)(1, "a", 8);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const link_r4 = ctx.$implicit;
    const i_r5 = ctx.index;
    const t_r2 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵproperty("ngbNavItem", i_r5);
    i0.ɵɵadvance();
    i0.ɵɵproperty("routerLink", link_r4.href);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(t_r2(link_r4.text));
} }
function TabPageComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, TabPageComponent_ng_container_0_h3_1_Template, 2, 1, "h3", 2);
    i0.ɵɵelementStart(2, "ul", 3, 0);
    i0.ɵɵtwoWayListener("activeIdChange", function TabPageComponent_ng_container_0_Template_ul_activeIdChange_2_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r2 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r2.activeLinkIndex, $event) || (ctx_r2.activeLinkIndex = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵtemplate(4, TabPageComponent_ng_container_0_li_4_Template, 3, 3, "li", 4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "div", 5);
    i0.ɵɵelement(6, "router-outlet");
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.title);
    i0.ɵɵadvance();
    i0.ɵɵtwoWayProperty("activeId", ctx_r2.activeLinkIndex);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r2.links);
} }
class TabPageComponent {
    constructor(router) {
        this.router = router;
        this.links = [];
        this.title = '';
        this.activeLinkIndex = 0;
    }
    ngOnInit() {
        this.router.events.pipe(filter(event => event instanceof NavigationEnd)).subscribe(() => {
            this.setActiveIndex();
        });
        this.setActiveIndex();
    }
    setActiveIndex() {
        const endPathName = this.router.url.split('/').pop();
        const foundLink = this.links.find(link => link.href === endPathName);
        this.activeLinkIndex = foundLink ? this.links.indexOf(foundLink) : 0;
    }
    static { this.ɵfac = function TabPageComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TabPageComponent)(i0.ɵɵdirectiveInject(i1$2.Router)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TabPageComponent, selectors: [["xf-tab-page"]], inputs: { links: "links", title: "title" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 1, vars: 0, consts: [["nav", "ngbNav"], [4, "transloco"], ["class", "mt-3 mb-3", 4, "ngIf"], ["ngbNav", "", 1, "nav-tabs", "primary-nav-tabs", 3, "activeIdChange", "activeId"], [3, "ngbNavItem", 4, "ngFor", "ngForOf"], [1, "tab-content", "padding-0px"], [1, "mt-3", "mb-3"], [3, "ngbNavItem"], ["ngbNavLink", "", 3, "routerLink"]], template: function TabPageComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, TabPageComponent_ng_container_0_Template, 7, 3, "ng-container", 1);
        } }, dependencies: [RouterModule, i1$2.RouterOutlet, i1$2.RouterLink, CommonModule, i1.NgForOf, i1.NgIf, NgbNavModule, i3.NgbNav, i3.NgbNavItem, i3.NgbNavItemRole, i3.NgbNavLink, i3.NgbNavLinkBase, TranslocoModule, i4.TranslocoDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TabPageComponent, [{
        type: Component,
        args: [{ selector: 'xf-tab-page', standalone: true, imports: [RouterModule, CommonModule, NgbNavModule, TranslocoModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<ng-container *transloco=\"let t\">\n  <h3 class=\"mt-3 mb-3\" *ngIf=\"title\">{{t(title)}}</h3>\n  <ul ngbNav #nav=\"ngbNav\" [(activeId)]=\"activeLinkIndex\" class=\"nav-tabs primary-nav-tabs\">\n    <li *ngFor=\"let link of links; let i = index\" [ngbNavItem]=\"i\">\n      <a ngbNavLink [routerLink]=\"link.href\">{{t(link.text)}}</a>\n    </li>\n  </ul>\n  <div class=\"tab-content padding-0px\">\n    <router-outlet></router-outlet>\n  </div>\n</ng-container>\n" }]
    }], () => [{ type: i1$2.Router }], { links: [{
            type: Input
        }], title: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TabPageComponent, { className: "TabPageComponent", filePath: "lib/components/tab-page/tab-page.component.ts", lineNumber: 21 }); })();

var timezones = [
	{
		value: "UTC-11",
		abbr: "U",
		offset: -11,
		isdst: false,
		utcOffset: "UTC-11:00",
		text: "(UTC-11:00) Coordinated Universal Time-11",
		utc: [
			"Pacific/Midway",
			"Pacific/Niue",
			"Pacific/Pago_Pago"
		]
	},
	{
		value: "Hawaiian Standard Time",
		abbr: "HST",
		offset: -10,
		isdst: false,
		utcOffset: "UTC-10:00",
		text: "(UTC-10:00) Hawaii",
		utc: [
			"Pacific/Honolulu",
			"Pacific/Rarotonga",
			"Pacific/Tahiti"
		]
	},
	{
		value: "Alaskan Standard Time",
		abbr: "AKDT",
		offset: -8,
		isdst: true,
		utcOffset: "UTC-09:00",
		text: "(UTC-09:00) Alaska",
		utc: [
			"America/Anchorage",
			"America/Juneau",
			"America/Nome",
			"America/Sitka",
			"America/Yakutat"
		]
	},
	{
		value: "Pacific Daylight Time",
		abbr: "PDT",
		offset: -7,
		isdst: true,
		utcOffset: "UTC-07:00",
		text: "(UTC-07:00) Pacific Time (US & Canada)",
		utc: [
			"America/Dawson",
			"America/Los_Angeles",
			"America/Tijuana",
			"America/Vancouver",
			"America/Whitehorse"
		]
	},
	{
		value: "Pacific Standard Time",
		abbr: "PST",
		offset: -8,
		isdst: false,
		utcOffset: "UTC-08:00",
		text: "(UTC-08:00) Pacific Time (US & Canada)",
		utc: [
			"America/Dawson",
			"America/Los_Angeles",
			"America/Tijuana",
			"America/Vancouver",
			"America/Whitehorse"
		]
	},
	{
		value: "US Mountain Standard Time",
		abbr: "UMST",
		offset: -7,
		isdst: false,
		utcOffset: "UTC-07:00",
		text: "(UTC-07:00) Arizona",
		utc: [
			"America/Creston",
			"America/Dawson_Creek",
			"America/Hermosillo",
			"America/Phoenix"
		]
	},
	{
		value: "Mountain Standard Time (Mexico)",
		abbr: "MDT",
		offset: -6,
		isdst: true,
		utcOffset: "UTC-07:00",
		text: "(UTC-07:00) Chihuahua, La Paz, Mazatlan",
		utc: [
			"America/Chihuahua",
			"America/Mazatlan"
		]
	},
	{
		value: "Mountain Standard Time",
		abbr: "MDT",
		offset: -6,
		isdst: true,
		utcOffset: "UTC-07:00",
		text: "(UTC-07:00) Mountain Time (US & Canada)",
		utc: [
			"America/Boise",
			"America/Cambridge_Bay",
			"America/Denver",
			"America/Edmonton",
			"America/Inuvik",
			"America/Ojinaga",
			"America/Yellowknife"
		]
	},
	{
		value: "Central America Standard Time",
		abbr: "CAST",
		offset: -6,
		isdst: false,
		utcOffset: "UTC-06:00",
		text: "(UTC-06:00) Central America",
		utc: [
			"America/Belize",
			"America/Costa_Rica",
			"America/El_Salvador",
			"America/Guatemala",
			"America/Managua",
			"America/Tegucigalpa",
			"Pacific/Galapagos"
		]
	},
	{
		value: "Central Standard Time",
		abbr: "CDT",
		offset: -5,
		isdst: true,
		utcOffset: "UTC-06:00",
		text: "(UTC-06:00) Central Time (US & Canada)",
		utc: [
			"America/Chicago",
			"America/Indiana/Knox",
			"America/Indiana/Tell_City",
			"America/Matamoros",
			"America/Menominee",
			"America/North_Dakota/Beulah",
			"America/North_Dakota/Center",
			"America/North_Dakota/New_Salem",
			"America/Rainy_River",
			"America/Rankin_Inlet",
			"America/Resolute",
			"America/Winnipeg"
		]
	},
	{
		value: "Central Standard Time (Mexico)",
		abbr: "CDT",
		offset: -5,
		isdst: true,
		utcOffset: "UTC-06:00",
		text: "(UTC-06:00) Guadalajara, Mexico City, Monterrey",
		utc: [
			"America/Bahia_Banderas",
			"America/Cancun",
			"America/Merida",
			"America/Mexico_City",
			"America/Monterrey"
		]
	},
	{
		value: "Canada Central Standard Time",
		abbr: "CCST",
		offset: -6,
		isdst: false,
		utcOffset: "UTC-06:00",
		text: "(UTC-06:00) Saskatchewan",
		utc: [
			"America/Regina",
			"America/Swift_Current"
		]
	},
	{
		value: "SA Pacific Standard Time",
		abbr: "SPST",
		offset: -5,
		isdst: false,
		utcOffset: "UTC-05:00",
		text: "(UTC-05:00) Bogota, Lima, Quito",
		utc: [
			"America/Bogota",
			"America/Cayman",
			"America/Atikokan",
			"America/Eirunepe",
			"America/Guayaquil",
			"America/Jamaica",
			"America/Lima",
			"America/Panama",
			"America/Rio_Branco"
		]
	},
	{
		value: "Eastern Standard Time",
		abbr: "EDT",
		offset: -4,
		isdst: true,
		utcOffset: "UTC-04:00",
		text: "(UTC-04:00) Eastern Time (US & Canada)",
		utc: [
			"America/Detroit",
			"America/Havana",
			"America/Indiana/Petersburg",
			"America/Indiana/Vincennes",
			"America/Indiana/Winamac",
			"America/Iqaluit",
			"America/Kentucky/Monticello",
			"America/Kentucky/Louisville",
			"America/Nassau",
			"America/New_York",
			"America/Nipigon",
			"America/Pangnirtung",
			"America/Port-au-Prince",
			"America/Thunder_Bay",
			"America/Toronto"
		]
	},
	{
		value: "US Eastern Standard Time",
		abbr: "UEDT",
		offset: -4,
		isdst: true,
		utcOffset: "UTC-05:00",
		text: "(UTC-05:00) Indiana (East)",
		utc: [
			"America/Indiana/Marengo",
			"America/Indiana/Vevay",
			"America/Indiana/Indianapolis"
		]
	},
	{
		value: "Venezuela Standard Time",
		abbr: "VST",
		offset: -4.5,
		isdst: false,
		utcOffset: "UTC-04:30",
		text: "(UTC-04:30) Caracas",
		utc: [
			"America/Caracas"
		]
	},
	{
		value: "Paraguay Standard Time",
		abbr: "PYT",
		offset: -4,
		isdst: false,
		utcOffset: "UTC-04:00",
		text: "(UTC-04:00) Asuncion",
		utc: [
			"America/Asuncion"
		]
	},
	{
		value: "Atlantic Standard Time",
		abbr: "ADT",
		offset: -3,
		isdst: true,
		utcOffset: "UTC-04:00",
		text: "(UTC-04:00) Atlantic Time (Canada)",
		utc: [
			"America/Glace_Bay",
			"America/Goose_Bay",
			"America/Halifax",
			"America/Moncton",
			"America/Thule",
			"Atlantic/Bermuda"
		]
	},
	{
		value: "Central Brazilian Standard Time",
		abbr: "CBST",
		offset: -4,
		isdst: false,
		utcOffset: "UTC-04:00",
		text: "(UTC-04:00) Cuiaba",
		utc: [
			"America/Campo_Grande",
			"America/Cuiaba"
		]
	},
	{
		value: "SA Western Standard Time",
		abbr: "SWST",
		offset: -4,
		isdst: false,
		utcOffset: "UTC-04:00",
		text: "(UTC-04:00) Georgetown, La Paz, Manaus, San Juan",
		utc: [
			"America/Anguilla",
			"America/Antigua",
			"America/Aruba",
			"America/Barbados",
			"America/Blanc-Sablon",
			"America/Boa_Vista",
			"America/Curacao",
			"America/Dominica",
			"America/Grand_Turk",
			"America/Grenada",
			"America/Guadeloupe",
			"America/Guyana",
			"America/Kralendijk",
			"America/La_Paz",
			"America/Lower_Princes",
			"America/Manaus",
			"America/Marigot",
			"America/Martinique",
			"America/Montserrat",
			"America/Port_of_Spain",
			"America/Porto_Velho",
			"America/Puerto_Rico",
			"America/Santo_Domingo",
			"America/St_Barthelemy",
			"America/St_Kitts",
			"America/St_Lucia",
			"America/St_Thomas",
			"America/St_Vincent",
			"America/Tortola"
		]
	},
	{
		value: "Pacific SA Standard Time",
		abbr: "PSST",
		offset: -4,
		isdst: false,
		utcOffset: "UTC-04:00",
		text: "(UTC-04:00) Santiago",
		utc: [
			"America/Santiago",
			"Antarctica/Palmer"
		]
	},
	{
		value: "Newfoundland Standard Time",
		abbr: "NDT",
		offset: -2.5,
		isdst: true,
		utcOffset: "UTC-03:30",
		text: "(UTC-03:30) Newfoundland",
		utc: [
			"America/St_Johns"
		]
	},
	{
		value: "E. South America Standard Time",
		abbr: "ESAST",
		offset: -3,
		isdst: false,
		utcOffset: "UTC-03:00",
		text: "(UTC-03:00) Brasilia",
		utc: [
			"America/Sao_Paulo"
		]
	},
	{
		value: "Argentina Standard Time",
		abbr: "AST",
		offset: -3,
		isdst: false,
		utcOffset: "UTC-03:00",
		text: "(UTC-03:00) Buenos Aires",
		utc: [
			"America/Argentina/La_Rioja",
			"America/Argentina/Rio_Gallegos",
			"America/Argentina/Salta",
			"America/Argentina/San_Juan",
			"America/Argentina/San_Luis",
			"America/Argentina/Tucuman",
			"America/Argentina/Ushuaia",
			"America/Argentina/Buenos_Aires",
			"America/Argentina/Catamarca",
			"America/Argentina/Cordoba",
			"America/Argentina/Jujuy",
			"America/Argentina/Mendoza"
		]
	},
	{
		value: "SA Eastern Standard Time",
		abbr: "SEST",
		offset: -3,
		isdst: false,
		utcOffset: "UTC-03:00",
		text: "(UTC-03:00) Cayenne, Fortaleza",
		utc: [
			"America/Araguaina",
			"America/Belem",
			"America/Cayenne",
			"America/Fortaleza",
			"America/Maceio",
			"America/Paramaribo",
			"America/Recife",
			"America/Santarem",
			"Antarctica/Rothera",
			"Atlantic/Stanley"
		]
	},
	{
		value: "Greenland Standard Time",
		abbr: "GDT",
		offset: -3,
		isdst: true,
		utcOffset: "UTC-03:00",
		text: "(UTC-03:00) Greenland",
		utc: [
			"America/Godthab"
		]
	},
	{
		value: "Montevideo Standard Time",
		abbr: "MST",
		offset: -3,
		isdst: false,
		utcOffset: "UTC-03:00",
		text: "(UTC-03:00) Montevideo",
		utc: [
			"America/Montevideo"
		]
	},
	{
		value: "Bahia Standard Time",
		abbr: "BST",
		offset: -3,
		isdst: false,
		utcOffset: "UTC-03:00",
		text: "(UTC-03:00) Salvador",
		utc: [
			"America/Bahia"
		]
	},
	{
		value: "UTC-02",
		abbr: "U",
		offset: -2,
		isdst: false,
		utcOffset: "UTC-02:00",
		text: "(UTC-02:00) Coordinated Universal Time-02",
		utc: [
			"America/Noronha",
			"Atlantic/South_Georgia"
		]
	},
	{
		value: "Azores Standard Time",
		abbr: "ADT",
		offset: 0,
		isdst: true,
		text: "(UTC-01:00) Azores",
		utc: [
			"America/Scoresbysund",
			"Atlantic/Azores"
		]
	},
	{
		value: "Cape Verde Standard Time",
		abbr: "CVST",
		offset: -1,
		isdst: false,
		utcOffset: "UTC-01:00",
		text: "(UTC-01:00) Cape Verde Is.",
		utc: [
			"Atlantic/Cape_Verde"
		]
	},
	{
		value: "Morocco Standard Time",
		abbr: "MDT",
		offset: 1,
		isdst: true,
		utcOffset: "UTC",
		text: "(UTC) Casablanca",
		utc: [
			"Africa/Casablanca",
			"Africa/El_Aaiun"
		]
	},
	{
		value: "UTC",
		abbr: "UTC",
		offset: 0,
		isdst: false,
		utcOffset: "UTC",
		text: "(UTC) Coordinated Universal Time",
		utc: [
			"America/Danmarkshavn",
			"UTC"
		]
	},
	{
		value: "Greenwich Mean Time",
		abbr: "GMT",
		offset: 0,
		isdst: false,
		utcOffset: "UTC",
		text: "(UTC) Edinburgh, London",
		utc: [
			"Europe/Isle_of_Man",
			"Europe/Guernsey",
			"Europe/Jersey",
			"Europe/London"
		]
	},
	{
		value: "British Summer Time",
		abbr: "BST",
		offset: 1,
		isdst: true,
		utcOffset: "UTC+01:00",
		text: "(UTC+01:00) Edinburgh, London",
		utc: [
			"Europe/Isle_of_Man",
			"Europe/Guernsey",
			"Europe/Jersey",
			"Europe/London"
		]
	},
	{
		value: "GMT Standard Time",
		abbr: "GDT",
		offset: 1,
		isdst: true,
		utcOffset: "UTC",
		text: "(UTC) Dublin, Lisbon",
		utc: [
			"Atlantic/Canary",
			"Atlantic/Faroe",
			"Atlantic/Madeira",
			"Europe/Dublin",
			"Europe/Lisbon"
		]
	},
	{
		value: "Greenwich Standard Time",
		abbr: "GST",
		offset: 0,
		isdst: false,
		utcOffset: "UTC",
		text: "(UTC) Monrovia, Reykjavik",
		utc: [
			"Africa/Abidjan",
			"Africa/Accra",
			"Africa/Bamako",
			"Africa/Banjul",
			"Africa/Bissau",
			"Africa/Conakry",
			"Africa/Dakar",
			"Africa/Freetown",
			"Africa/Lome",
			"Africa/Monrovia",
			"Africa/Nouakchott",
			"Africa/Ouagadougou",
			"Africa/Sao_Tome",
			"Atlantic/Reykjavik",
			"Atlantic/St_Helena"
		]
	},
	{
		value: "W. Europe Standard Time",
		abbr: "WEDT",
		offset: 2,
		isdst: true,
		utcOffset: "UTC+01:00",
		text: "(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",
		utc: [
			"Arctic/Longyearbyen",
			"Europe/Amsterdam",
			"Europe/Andorra",
			"Europe/Berlin",
			"Europe/Busingen",
			"Europe/Gibraltar",
			"Europe/Luxembourg",
			"Europe/Malta",
			"Europe/Monaco",
			"Europe/Oslo",
			"Europe/Rome",
			"Europe/San_Marino",
			"Europe/Stockholm",
			"Europe/Vaduz",
			"Europe/Vatican",
			"Europe/Vienna",
			"Europe/Zurich"
		]
	},
	{
		value: "Central Europe Standard Time",
		abbr: "CEDT",
		offset: 2,
		isdst: true,
		utcOffset: "UTC+01:00",
		text: "(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague",
		utc: [
			"Europe/Belgrade",
			"Europe/Bratislava",
			"Europe/Budapest",
			"Europe/Ljubljana",
			"Europe/Podgorica",
			"Europe/Prague",
			"Europe/Tirane"
		]
	},
	{
		value: "Romance Standard Time",
		abbr: "RDT",
		offset: 2,
		isdst: true,
		utcOffset: "UTC+01:00",
		text: "(UTC+01:00) Brussels, Copenhagen, Madrid, Paris",
		utc: [
			"Africa/Ceuta",
			"Europe/Brussels",
			"Europe/Copenhagen",
			"Europe/Madrid",
			"Europe/Paris"
		]
	},
	{
		value: "Central European Standard Time",
		abbr: "CEDT",
		offset: 2,
		isdst: true,
		utcOffset: "UTC+01:00",
		text: "(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb",
		utc: [
			"Europe/Sarajevo",
			"Europe/Skopje",
			"Europe/Warsaw",
			"Europe/Zagreb"
		]
	},
	{
		value: "W. Central Africa Standard Time",
		abbr: "WCAST",
		offset: 1,
		isdst: false,
		utcOffset: "UTC+01:00",
		text: "(UTC+01:00) West Central Africa",
		utc: [
			"Africa/Algiers",
			"Africa/Bangui",
			"Africa/Brazzaville",
			"Africa/Douala",
			"Africa/Kinshasa",
			"Africa/Lagos",
			"Africa/Libreville",
			"Africa/Luanda",
			"Africa/Malabo",
			"Africa/Ndjamena",
			"Africa/Niamey",
			"Africa/Porto-Novo",
			"Africa/Tunis"
		]
	},
	{
		value: "Namibia Standard Time",
		abbr: "NST",
		offset: 1,
		isdst: false,
		utcOffset: "UTC+01:00",
		text: "(UTC+01:00) Windhoek",
		utc: [
			"Africa/Windhoek"
		]
	},
	{
		value: "GTB Standard Time",
		abbr: "GDT",
		offset: 3,
		isdst: true,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) Athens, Bucharest",
		utc: [
			"Asia/Nicosia",
			"Europe/Athens",
			"Europe/Bucharest",
			"Europe/Chisinau"
		]
	},
	{
		value: "Middle East Standard Time",
		abbr: "MEDT",
		offset: 3,
		isdst: true,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) Beirut",
		utc: [
			"Asia/Beirut"
		]
	},
	{
		value: "Egypt Standard Time",
		abbr: "EST",
		offset: 2,
		isdst: false,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) Cairo",
		utc: [
			"Africa/Cairo"
		]
	},
	{
		value: "Syria Standard Time",
		abbr: "SDT",
		offset: 3,
		isdst: true,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) Damascus",
		utc: [
			"Asia/Damascus"
		]
	},
	{
		value: "E. Europe Standard Time",
		abbr: "EEDT",
		offset: 3,
		isdst: true,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) E. Europe",
		utc: [
			"Asia/Nicosia",
			"Europe/Athens",
			"Europe/Bucharest",
			"Europe/Chisinau",
			"Europe/Helsinki",
			"Europe/Kiev",
			"Europe/Mariehamn",
			"Europe/Riga",
			"Europe/Sofia",
			"Europe/Tallinn",
			"Europe/Uzhgorod",
			"Europe/Vilnius",
			"Europe/Zaporozhye"
		]
	},
	{
		value: "South Africa Standard Time",
		abbr: "SAST",
		offset: 2,
		isdst: false,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) Harare, Pretoria",
		utc: [
			"Africa/Blantyre",
			"Africa/Bujumbura",
			"Africa/Gaborone",
			"Africa/Harare",
			"Africa/Johannesburg",
			"Africa/Kigali",
			"Africa/Lubumbashi",
			"Africa/Lusaka",
			"Africa/Maputo",
			"Africa/Maseru",
			"Africa/Mbabane"
		]
	},
	{
		value: "FLE Standard Time",
		abbr: "FDT",
		offset: 3,
		isdst: true,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius",
		utc: [
			"Europe/Helsinki",
			"Europe/Kiev",
			"Europe/Mariehamn",
			"Europe/Riga",
			"Europe/Sofia",
			"Europe/Tallinn",
			"Europe/Uzhgorod",
			"Europe/Vilnius",
			"Europe/Zaporozhye"
		]
	},
	{
		value: "Turkey Standard Time",
		abbr: "TDT",
		offset: 3,
		isdst: false,
		utcOffset: "UTC+02:00",
		text: "(UTC+03:00) Istanbul",
		utc: [
			"Europe/Istanbul"
		]
	},
	{
		value: "Israel Standard Time",
		abbr: "JDT",
		offset: 3,
		isdst: true,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) Jerusalem",
		utc: [
			"Asia/Jerusalem"
		]
	},
	{
		value: "Libya Standard Time",
		abbr: "LST",
		offset: 2,
		isdst: false,
		utcOffset: "UTC+02:00",
		text: "(UTC+02:00) Tripoli",
		utc: [
			"Africa/Tripoli"
		]
	},
	{
		value: "Jordan Standard Time",
		abbr: "JST",
		offset: 3,
		isdst: false,
		utcOffset: "UTC+03:00",
		text: "(UTC+03:00) Amman",
		utc: [
			"Asia/Amman"
		]
	},
	{
		value: "Arabic Standard Time",
		abbr: "AST",
		offset: 3,
		isdst: false,
		utcOffset: "UTC+03:00",
		text: "(UTC+03:00) Baghdad",
		utc: [
			"Asia/Baghdad"
		]
	},
	{
		value: "Kaliningrad Standard Time",
		abbr: "KST",
		offset: 3,
		isdst: false,
		utcOffset: "UTC+03:00",
		text: "(UTC+03:00) Kaliningrad, Minsk",
		utc: [
			"Europe/Kaliningrad",
			"Europe/Minsk"
		]
	},
	{
		value: "Arab Standard Time",
		abbr: "AST",
		offset: 3,
		isdst: false,
		utcOffset: "UTC+03:00",
		text: "(UTC+03:00) Kuwait, Riyadh",
		utc: [
			"Asia/Aden",
			"Asia/Bahrain",
			"Asia/Kuwait",
			"Asia/Qatar",
			"Asia/Riyadh"
		]
	},
	{
		value: "E. Africa Standard Time",
		abbr: "EAST",
		offset: 3,
		isdst: false,
		utcOffset: "UTC+03:00",
		text: "(UTC+03:00) Nairobi",
		utc: [
			"Africa/Addis_Ababa",
			"Africa/Asmara",
			"Africa/Dar_es_Salaam",
			"Africa/Djibouti",
			"Africa/Juba",
			"Africa/Kampala",
			"Africa/Khartoum",
			"Africa/Mogadishu",
			"Africa/Nairobi",
			"Antarctica/Syowa",
			"Indian/Antananarivo",
			"Indian/Comoro",
			"Indian/Mayotte"
		]
	},
	{
		value: "Moscow Standard Time",
		abbr: "MSK",
		offset: 3,
		isdst: false,
		utcOffset: "UTC+03:00",
		text: "(UTC+03:00) Moscow, St. Petersburg, Volgograd",
		utc: [
			"Europe/Kirov",
			"Europe/Moscow",
			"Europe/Simferopol",
			"Europe/Volgograd"
		]
	},
	{
		value: "Samara Time",
		abbr: "SAMT",
		offset: 4,
		isdst: false,
		utcOffset: "UTC+04:00",
		text: "(UTC+04:00) Samara, Ulyanovsk, Saratov",
		utc: [
			"Europe/Astrakhan",
			"Europe/Samara",
			"Europe/Ulyanovsk"
		]
	},
	{
		value: "Iran Standard Time",
		abbr: "IDT",
		offset: 4.5,
		isdst: true,
		utcOffset: "UTC+03:30",
		text: "(UTC+03:30) Tehran",
		utc: [
			"Asia/Tehran"
		]
	},
	{
		value: "Arabian Standard Time",
		abbr: "AST",
		offset: 4,
		isdst: false,
		utcOffset: "UTC+04:00",
		text: "(UTC+04:00) Abu Dhabi, Muscat",
		utc: [
			"Asia/Dubai",
			"Asia/Muscat"
		]
	},
	{
		value: "Azerbaijan Standard Time",
		abbr: "ADT",
		offset: 5,
		isdst: true,
		utcOffset: "UTC+04:00",
		text: "(UTC+04:00) Baku",
		utc: [
			"Asia/Baku"
		]
	},
	{
		value: "Mauritius Standard Time",
		abbr: "MST",
		offset: 4,
		isdst: false,
		utcOffset: "UTC+04:00",
		text: "(UTC+04:00) Port Louis",
		utc: [
			"Indian/Mahe",
			"Indian/Mauritius",
			"Indian/Reunion"
		]
	},
	{
		value: "Georgian Standard Time",
		abbr: "GST",
		offset: 4,
		isdst: false,
		utcOffset: "UTC+04:00",
		text: "(UTC+04:00) Tbilisi",
		utc: [
			"Asia/Tbilisi"
		]
	},
	{
		value: "Caucasus Standard Time",
		abbr: "CST",
		offset: 4,
		isdst: false,
		utcOffset: "UTC+04:00",
		text: "(UTC+04:00) Yerevan",
		utc: [
			"Asia/Yerevan"
		]
	},
	{
		value: "Afghanistan Standard Time",
		abbr: "AST",
		offset: 4.5,
		isdst: false,
		utcOffset: "UTC+04:30",
		text: "(UTC+04:30) Kabul",
		utc: [
			"Asia/Kabul"
		]
	},
	{
		value: "West Asia Standard Time",
		abbr: "WAST",
		offset: 5,
		isdst: false,
		utcOffset: "UTC+05:00",
		text: "(UTC+05:00) Ashgabat, Tashkent",
		utc: [
			"Antarctica/Mawson",
			"Asia/Aqtau",
			"Asia/Aqtobe",
			"Asia/Ashgabat",
			"Asia/Dushanbe",
			"Asia/Oral",
			"Asia/Samarkand",
			"Asia/Tashkent",
			"Indian/Kerguelen",
			"Indian/Maldives"
		]
	},
	{
		value: "Yekaterinburg Time",
		abbr: "YEKT",
		offset: 5,
		isdst: false,
		utcOffset: "UTC+05:00",
		text: "(UTC+05:00) Yekaterinburg",
		utc: [
			"Asia/Yekaterinburg"
		]
	},
	{
		value: "Pakistan Standard Time",
		abbr: "PKT",
		offset: 5,
		isdst: false,
		utcOffset: "UTC+05:00",
		text: "(UTC+05:00) Islamabad, Karachi",
		utc: [
			"Asia/Karachi"
		]
	},
	{
		value: "India Standard Time",
		abbr: "IST",
		offset: 5.5,
		isdst: false,
		utcOffset: "UTC+05:30",
		text: "(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi",
		utc: [
			"Asia/Kolkata"
		]
	},
	{
		value: "Sri Lanka Standard Time",
		abbr: "SLST",
		offset: 5.5,
		isdst: false,
		utcOffset: "UTC+05:30",
		text: "(UTC+05:30) Sri Jayawardenepura",
		utc: [
			"Asia/Colombo"
		]
	},
	{
		value: "Nepal Standard Time",
		abbr: "NST",
		offset: 5.75,
		isdst: false,
		utcOffset: "UTC+05:45",
		text: "(UTC+05:45) Kathmandu",
		utc: [
			"Asia/Kathmandu"
		]
	},
	{
		value: "Central Asia Standard Time",
		abbr: "CAST",
		offset: 6,
		isdst: false,
		utcOffset: "UTC+06:00",
		text: "(UTC+06:00) Astana",
		utc: [
			"Antarctica/Vostok",
			"Asia/Almaty",
			"Asia/Bishkek",
			"Asia/Qyzylorda",
			"Asia/Urumqi",
			"Indian/Chagos"
		]
	},
	{
		value: "Bangladesh Standard Time",
		abbr: "BST",
		offset: 6,
		isdst: false,
		utcOffset: "UTC+06:00",
		text: "(UTC+06:00) Dhaka",
		utc: [
			"Asia/Dhaka",
			"Asia/Thimphu"
		]
	},
	{
		value: "Myanmar Standard Time",
		abbr: "MST",
		offset: 6.5,
		isdst: false,
		utcOffset: "UTC+06:30",
		text: "(UTC+06:30) Yangon (Rangoon)",
		utc: [
			"Asia/Yangon",
			"Indian/Cocos"
		]
	},
	{
		value: "SE Asia Standard Time",
		abbr: "SAST",
		offset: 7,
		isdst: false,
		utcOffset: "UTC+07:00",
		text: "(UTC+07:00) Bangkok, Hanoi, Jakarta",
		utc: [
			"Antarctica/Davis",
			"Asia/Bangkok",
			"Asia/Hovd",
			"Asia/Jakarta",
			"Asia/Phnom_Penh",
			"Asia/Pontianak",
			"Asia/Ho_Chi_Minh",
			"Asia/Vientiane",
			"Indian/Christmas"
		]
	},
	{
		value: "N. Central Asia Standard Time",
		abbr: "NCAST",
		offset: 7,
		isdst: false,
		utcOffset: "UTC+07:00",
		text: "(UTC+07:00) Novosibirsk",
		utc: [
			"Asia/Novokuznetsk",
			"Asia/Novosibirsk",
			"Asia/Omsk"
		]
	},
	{
		value: "China Standard Time",
		abbr: "CST",
		offset: 8,
		isdst: false,
		utcOffset: "UTC+08:00",
		text: "(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi",
		utc: [
			"Asia/Hong_Kong",
			"Asia/Macau",
			"Asia/Shanghai"
		]
	},
	{
		value: "North Asia Standard Time",
		abbr: "NAST",
		offset: 8,
		isdst: false,
		utcOffset: "UTC+08:00",
		text: "(UTC+08:00) Krasnoyarsk",
		utc: [
			"Asia/Krasnoyarsk"
		]
	},
	{
		value: "Singapore Standard Time",
		abbr: "MPST",
		offset: 8,
		isdst: false,
		utcOffset: "UTC+08:00",
		text: "(UTC+08:00) Kuala Lumpur, Singapore",
		utc: [
			"Asia/Brunei",
			"Asia/Kuala_Lumpur",
			"Asia/Kuching",
			"Asia/Makassar",
			"Asia/Manila",
			"Asia/Singapore"
		]
	},
	{
		value: "W. Australia Standard Time",
		abbr: "WAST",
		offset: 8,
		isdst: false,
		utcOffset: "UTC+08:00",
		text: "(UTC+08:00) Perth",
		utc: [
			"Antarctica/Casey",
			"Australia/Perth"
		]
	},
	{
		value: "Taipei Standard Time",
		abbr: "TST",
		offset: 8,
		isdst: false,
		utcOffset: "UTC+08:00",
		text: "(UTC+08:00) Taipei",
		utc: [
			"Asia/Taipei"
		]
	},
	{
		value: "Ulaanbaatar Standard Time",
		abbr: "UST",
		offset: 8,
		isdst: false,
		utcOffset: "UTC+08:00",
		text: "(UTC+08:00) Ulaanbaatar",
		utc: [
			"Asia/Choibalsan",
			"Asia/Ulaanbaatar"
		]
	},
	{
		value: "North Asia East Standard Time",
		abbr: "NAEST",
		offset: 8,
		isdst: false,
		utcOffset: "UTC+08:00",
		text: "(UTC+08:00) Irkutsk",
		utc: [
			"Asia/Irkutsk"
		]
	},
	{
		value: "Japan Standard Time",
		abbr: "JST",
		offset: 9,
		isdst: false,
		utcOffset: "UTC+09:00",
		text: "(UTC+09:00) Osaka, Sapporo, Tokyo",
		utc: [
			"Asia/Dili",
			"Asia/Jayapura",
			"Asia/Tokyo",
			"Pacific/Palau"
		]
	},
	{
		value: "Korea Standard Time",
		abbr: "KST",
		offset: 9,
		isdst: false,
		utcOffset: "UTC+09:00",
		text: "(UTC+09:00) Seoul",
		utc: [
			"Asia/Pyongyang",
			"Asia/Seoul"
		]
	},
	{
		value: "Cen. Australia Standard Time",
		abbr: "CAST",
		offset: 9.5,
		isdst: false,
		utcOffset: "UTC+09:30",
		text: "(UTC+09:30) Adelaide",
		utc: [
			"Australia/Adelaide",
			"Australia/Broken_Hill"
		]
	},
	{
		value: "AUS Central Standard Time",
		abbr: "ACST",
		offset: 9.5,
		isdst: false,
		utcOffset: "UTC+09:30",
		text: "(UTC+09:30) Darwin",
		utc: [
			"Australia/Darwin"
		]
	},
	{
		value: "E. Australia Standard Time",
		abbr: "EAST",
		offset: 10,
		isdst: false,
		utcOffset: "UTC+10:00",
		text: "(UTC+10:00) Brisbane",
		utc: [
			"Australia/Brisbane",
			"Australia/Lindeman"
		]
	},
	{
		value: "AUS Eastern Standard Time",
		abbr: "AEST",
		offset: 10,
		isdst: false,
		utcOffset: "UTC+10:00",
		text: "(UTC+10:00) Canberra, Melbourne, Sydney",
		utc: [
			"Australia/Melbourne",
			"Australia/Sydney"
		]
	},
	{
		value: "West Pacific Standard Time",
		abbr: "WPST",
		offset: 10,
		isdst: false,
		utcOffset: "UTC+10:00",
		text: "(UTC+10:00) Guam, Port Moresby",
		utc: [
			"Antarctica/DumontDUrville",
			"Pacific/Guam",
			"Pacific/Port_Moresby",
			"Pacific/Saipan",
			"Pacific/Chuuk"
		]
	},
	{
		value: "Tasmania Standard Time",
		abbr: "TST",
		offset: 10,
		isdst: false,
		utcOffset: "UTC+10:00",
		text: "(UTC+10:00) Hobart",
		utc: [
			"Australia/Currie",
			"Australia/Hobart"
		]
	},
	{
		value: "Yakutsk Standard Time",
		abbr: "YST",
		offset: 9,
		isdst: false,
		utcOffset: "UTC+09:00",
		text: "(UTC+09:00) Yakutsk",
		utc: [
			"Asia/Chita",
			"Asia/Khandyga",
			"Asia/Yakutsk"
		]
	},
	{
		value: "Central Pacific Standard Time",
		abbr: "CPST",
		offset: 11,
		isdst: false,
		utcOffset: "UTC+11:00",
		text: "(UTC+11:00) Solomon Is., New Caledonia",
		utc: [
			"Antarctica/Macquarie",
			"Pacific/Efate",
			"Pacific/Guadalcanal",
			"Pacific/Kosrae",
			"Pacific/Noumea",
			"Pacific/Pohnpei"
		]
	},
	{
		value: "Vladivostok Standard Time",
		abbr: "VST",
		offset: 11,
		isdst: false,
		utcOffset: "UTC+11:00",
		text: "(UTC+11:00) Vladivostok",
		utc: [
			"Asia/Sakhalin",
			"Asia/Ust-Nera",
			"Asia/Vladivostok"
		]
	},
	{
		value: "New Zealand Standard Time",
		abbr: "NZST",
		offset: 12,
		isdst: false,
		utcOffset: "UTC+12:00",
		text: "(UTC+12:00) Auckland, Wellington",
		utc: [
			"Antarctica/McMurdo",
			"Pacific/Auckland"
		]
	},
	{
		value: "UTC+12",
		abbr: "U",
		offset: 12,
		isdst: false,
		utcOffset: "UTC+12:00",
		text: "(UTC+12:00) Coordinated Universal Time+12",
		utc: [
			"Pacific/Funafuti",
			"Pacific/Kwajalein",
			"Pacific/Majuro",
			"Pacific/Nauru",
			"Pacific/Tarawa",
			"Pacific/Wake",
			"Pacific/Wallis"
		]
	},
	{
		value: "Fiji Standard Time",
		abbr: "FST",
		offset: 12,
		isdst: false,
		utcOffset: "UTC+12:00",
		text: "(UTC+12:00) Fiji",
		utc: [
			"Pacific/Fiji"
		]
	},
	{
		value: "Magadan Standard Time",
		abbr: "MST",
		offset: 12,
		isdst: false,
		utcOffset: "UTC+12:00",
		text: "(UTC+12:00) Magadan",
		utc: [
			"Asia/Anadyr",
			"Asia/Kamchatka",
			"Asia/Magadan",
			"Asia/Srednekolymsk"
		]
	},
	{
		value: "Kamchatka Standard Time",
		abbr: "KDT",
		offset: 13,
		isdst: true,
		utcOffset: "UTC+12:00",
		text: "(UTC+12:00) Petropavlovsk-Kamchatsky - Old",
		utc: [
			"Asia/Kamchatka"
		]
	},
	{
		value: "Tonga Standard Time",
		abbr: "TST",
		offset: 13,
		isdst: false,
		utcOffset: "UTC+13:00",
		text: "(UTC+13:00) Nuku\"alofa",
		utc: [
			"Pacific/Enderbury",
			"Pacific/Fakaofo",
			"Pacific/Tongatapu"
		]
	},
	{
		value: "Samoa Standard Time",
		abbr: "SST",
		offset: 13,
		isdst: false,
		utcOffset: "UTC+13:00",
		text: "(UTC+13:00) Samoa",
		utc: [
			"Pacific/Apia"
		]
	}
];
var timezoneData = {
	timezones: timezones
};

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class TimezoneService {
    constructor() { }
    getList() {
        const timezones = timezoneData.timezones;
        return timezones;
    }
    getUtcList() {
        return this.getList().map((timezone) => {
            return timezone.utc.map((value) => {
                return {
                    value: value,
                    abbr: timezone.abbr,
                    text: `${value} (${timezone.abbr})`,
                    utcOffset: timezone.utcOffset
                };
            });
        }).flat();
    }
    getTimezoneByName(name) {
        const timezones = this.getUtcList();
        return timezones.find(timezone => timezone.value === name);
    }
    getTimezoneByAbbr(abbr) {
        const timezones = timezoneData.timezones;
        return timezones.find(timezone => timezone.abbr === abbr);
    }
    getLocalTimezone() {
        const list = this.getList();
        const localTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
        return list.find((timezone) => timezone.utc.indexOf(localTimezone) > -1);
    }
    static { this.ɵfac = function TimezoneService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TimezoneService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: TimezoneService, factory: TimezoneService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimezoneService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class TimezoneSelectComponent {
    constructor(timezoneService, changeDetectorRef) {
        this.timezoneService = timezoneService;
        this.changeDetectorRef = changeDetectorRef;
        this.timezoneList = [];
        this.items = [];
        this.filteredItems = [];
        this.selectedValue = null;
        this.selectedTimezone = null;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.touched = false;
        this.disabled = false;
    }
    valueChange(value) {
        this.selectedTimezone = this.timezoneList.find((timezone) => timezone.value === value) || null;
        this.onChange(this.selectedTimezone);
    }
    ngOnInit() {
        this.timezoneList = this.timezoneService.getUtcList();
        this.items = this.timezoneList.map((timezone) => {
            return {
                display: timezone.text,
                value: timezone.value,
                uuid: timezone.value
            };
        });
        this.selectSearchableItem();
    }
    selectSearchableItem() {
        this.selectedValue = this.items.find((item) => item.uuid === this.selectedTimezone?.value) || null;
    }
    loadItems(search) {
        search = search.toLowerCase();
        this.filteredItems = this.items.filter((item) => item.display.toLowerCase().indexOf(search) > -1 || item.value.toLowerCase().indexOf(search) > -1);
        this.changeDetectorRef.detectChanges();
    }
    writeValue(value) {
        this.selectedTimezone = value;
        this.selectSearchableItem();
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    markAsTouched() {
        if (!this.touched) {
            this.onTouched();
            this.touched = true;
        }
    }
    focus() {
        this.searchableDropdownComponent.focus();
    }
    get valid() {
        return !this.searchableDropdownComponent.invalid;
    }
    setDisabledState(disabled) {
        this.disabled = disabled;
    }
    validate(control) {
        const required = control.value;
        if (required <= 0) {
            return {
                required: {
                    required
                }
            };
        }
        return null;
    }
    static { this.ɵfac = function TimezoneSelectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TimezoneSelectComponent)(i0.ɵɵdirectiveInject(TimezoneService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TimezoneSelectComponent, selectors: [["xf-timezone-select"]], viewQuery: function TimezoneSelectComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchableDropdownComponent = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => TimezoneSelectComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => TimezoneSelectComponent),
                    multi: true
                }])], decls: 2, vars: 3, consts: [[1, "form-group"], [3, "ngModelChange", "searchQueryChange", "ngModel", "items", "buttonStyle"]], template: function TimezoneSelectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "xf-searchable-dropdown", 1);
            i0.ɵɵtwoWayListener("ngModelChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_ngModelChange_1_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.selectedValue, $event) || (ctx.selectedValue = $event); return $event; });
            i0.ɵɵlistener("ngModelChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_ngModelChange_1_listener() { return ctx.valueChange(ctx.selectedValue == null ? null : ctx.selectedValue.value); })("searchQueryChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_searchQueryChange_1_listener($event) { return ctx.loadItems($event); });
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵtwoWayProperty("ngModel", ctx.selectedValue);
            i0.ɵɵproperty("items", ctx.filteredItems)("buttonStyle", "select");
        } }, dependencies: [SearchableDropdownComponent, i2.NgControlStatus, i2.NgModel] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimezoneSelectComponent, [{
        type: Component,
        args: [{ selector: 'xf-timezone-select', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => TimezoneSelectComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => TimezoneSelectComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n\n<div class=\"form-group\">\n  <xf-searchable-dropdown [(ngModel)]=\"selectedValue\" (ngModelChange)=\"valueChange(selectedValue?.value)\" [items]=\"filteredItems\" (searchQueryChange)=\"loadItems($event)\" [buttonStyle]=\"'select'\"></xf-searchable-dropdown>\n</div>\n" }]
    }], () => [{ type: TimezoneService }, { type: i0.ChangeDetectorRef }], { searchableDropdownComponent: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TimezoneSelectComponent, { className: "TimezoneSelectComponent", filePath: "lib/components/timezone/timezone-select/timezone-select.component.ts", lineNumber: 26 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class TimezoneModule {
    static { this.ɵfac = function TimezoneModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TimezoneModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: TimezoneModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            SearchableDropdownModule,
            FormsModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimezoneModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    TimezoneSelectComponent
                ],
                imports: [
                    CommonModule,
                    SearchableDropdownModule,
                    FormsModule
                ],
                exports: [
                    TimezoneSelectComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(TimezoneModule, { declarations: [TimezoneSelectComponent], imports: [CommonModule,
        SearchableDropdownModule,
        FormsModule], exports: [TimezoneSelectComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class AbstractWizardStepComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
    }
    ngOnDestroy() {
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
    }
    static { this.ɵfac = function AbstractWizardStepComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractWizardStepComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractWizardStepComponent, selectors: [["xf-abstract-wizard-step"]], inputs: { wizard: "wizard", step: "step", wizardForm: "wizardForm" }, decls: 0, vars: 0, template: function AbstractWizardStepComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractWizardStepComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-wizard-step',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }], { wizard: [{
            type: Input
        }], step: [{
            type: Input
        }], wizardForm: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractWizardStepComponent, { className: "AbstractWizardStepComponent", filePath: "lib/components/wizard/abstract-wizard-step.component.ts", lineNumber: 16 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$3 = ["wizardForm"];
const _c1$2 = ["wizard", ""];
const _c2$1 = (a0, a1) => ({ "wizard-with-title": a0, "wizard-no-secondary-nav": a1 });
const _c3 = a0 => ({ "padding-left-16px padding-right-16px padding-top-8px padding-bottom-8px": a0 });
const _c4 = (a0, a1) => ({ "completed": a0, "active": a1 });
const _c5 = (a0, a1) => ({ "fa-check font-size-10px": a0, "fa-circle font-size-8px": a1 });
const _c6 = (a0, a1, a2, a3) => ({ "first": a0, "last": a1, "active": a2, "completed": a3 });
const _c7 = (a0, a1, a2, a3) => ({ "float-end": a0, "btn-primary": a1, "btn-secondary": a2, "btn-outline-secondary": a3 });
function WizardComponent_div_5_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 10)(2, "div", 11);
    i0.ɵɵelement(3, "span", 12);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(4, "div", 13);
    i0.ɵɵelementStart(5, "div", 14);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const step_r1 = ctx.$implicit;
    const i_r2 = ctx.index;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(4, _c4, step_r1.isComplete || ctx_r2.wizard.currentStepIndex === ctx_r2.enabledSteps.length - 1, i_r2 === ctx_r2.wizard.currentStepIndex));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(7, _c5, step_r1.isComplete, !step_r1.isComplete));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction4(10, _c6, i_r2 === 0, i_r2 === ctx_r2.enabledSteps.length - 1, i_r2 === ctx_r2.wizard.currentStepIndex, step_r1.isComplete));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(step_r1.title);
} }
function WizardComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵtemplate(1, WizardComponent_div_5_ng_container_1_Template, 7, 15, "ng-container", 8);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.enabledSteps);
} }
function WizardComponent_ng_template_7_Template(rf, ctx) { }
function WizardComponent_ng_container_9_button_1_i_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 19);
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon ? button_r5.disabledIcon : button_r5.icon);
} }
function WizardComponent_ng_container_9_button_1_i_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 20);
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon ? button_r5.disabledIcon : button_r5.icon);
} }
function WizardComponent_ng_container_9_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 16);
    i0.ɵɵlistener("click", function WizardComponent_ng_container_9_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const button_r5 = i0.ɵɵnextContext().$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.buttonClicked(button_r5)); });
    i0.ɵɵtemplate(1, WizardComponent_ng_container_9_button_1_i_1_Template, 1, 1, "i", 17);
    i0.ɵɵtext(2);
    i0.ɵɵtemplate(3, WizardComponent_ng_container_9_button_1_i_3_Template, 1, 1, "i", 18);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("disabled", button_r5.disabled)("ngClass", i0.ɵɵpureFunction4(6, _c7, button_r5.pullRight, button_r5.type === "primary", button_r5.type === "secondary", button_r5.type !== "primary" && button_r5.type !== "secondary"))("id", "wizard-" + button_r5.name + "-btn");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (button_r5.icon || (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon) && button_r5.iconPosition === "left");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledText ? button_r5.disabledText : button_r5.text, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (button_r5.icon || (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon) && button_r5.iconPosition === "right");
} }
function WizardComponent_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, WizardComponent_ng_container_9_button_1_Template, 4, 11, "button", 15);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const button_r5 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", button_r5 && !button_r5.hidden);
} }
class WizardComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.subscriptions = [];
        this.loading = false;
        this.enabledSteps = [];
        this.onClose = new EventEmitter();
    }
    ngOnInit() {
        this.enabledSteps = this.wizard.steps.filter((step) => !step.disabled);
        let subscription = this.wizard.wizardChanged$.subscribe(() => {
            this.enabledSteps = this.wizard.steps.filter((step) => !step.disabled);
            this.changeDetectorRef.detectChanges();
        });
        this.wizard.next = () => this.next();
        this.wizard.back = () => this.back();
        this.wizard.close = (buttonName) => this.close(buttonName);
        this.subscriptions.push(subscription);
    }
    ngAfterViewInit() {
        this.loadStepView(this.wizard.currentStepIndex);
    }
    loadStepView(stepIndex) {
        const step = this.enabledSteps[stepIndex];
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(step.component);
        this.componentRef.instance.wizard = this.wizard;
        this.componentRef.instance.step = step;
        this.componentRef.instance.wizardForm = this.wizardForm;
        this.changeDetectorRef.detectChanges();
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    buttonClicked(button) {
        button.disabled = true;
        this.loading = true;
        this.changeDetectorRef.detectChanges();
        let observable$ = of(null);
        if (button.action === 'next') {
            observable$ = this.next(button.name);
        }
        else if (button.action === 'back') {
            this.back();
            this.loading = false;
        }
        else if (button.action === 'close') {
            this.close(button.name);
            return;
        }
        else if (button.action === 'submit') {
            observable$ = this.submit(button.name);
        }
        else if (button.action === 'skip') {
            this.skipToStep(this.wizard.currentStepIndex + 2);
        }
        if (this.buttonSubscription) {
            this.buttonSubscription.unsubscribe();
        }
        this.buttonSubscription = observable$.subscribe({
            complete: () => {
                button.disabled = false;
                this.loading = false;
                this.changeDetectorRef.detectChanges();
                this.buttonSubscription = undefined;
            }
        });
        this.subscriptions.push(this.buttonSubscription);
    }
    submit(buttonName) {
        const currentStep = this.enabledSteps[this.wizard.currentStepIndex];
        let observable$;
        if (currentStep && this.componentRef) {
            observable$ = this.componentRef.instance.submit(buttonName).pipe(map$1((valid) => {
                if (valid) {
                    currentStep.isComplete = true;
                }
                return valid;
            }));
        }
        else {
            observable$ = of(false);
        }
        return observable$;
    }
    next(buttonName) {
        return this.submit(buttonName).pipe(map$1((valid) => {
            if (valid) {
                this.wizard.currentStepIndex = this.wizard.currentStepIndex + 1;
                this.loadStepView(this.wizard.currentStepIndex);
            }
        }));
    }
    back() {
        this.wizard.currentStepIndex = this.wizard.currentStepIndex - 1;
        this.loadStepView(this.wizard.currentStepIndex);
    }
    close(buttonName) {
        this.onClose.emit();
    }
    navigateToStep(stepIndex) {
        this.wizard.currentStepIndex = stepIndex;
        // this.enabledSteps.forEach((step, index) => {
        //   if (stepIndex < index) {
        //     step.isComplete = false;
        //   }
        // });
        this.loadStepView(this.wizard.currentStepIndex);
    }
    skipToStep(stepIndex) {
        this.wizard.currentStepIndex = stepIndex;
        this.enabledSteps.forEach((step, index) => {
            if (stepIndex > index) {
                step.isComplete = true;
            }
        });
        this.loadStepView(this.wizard.currentStepIndex);
    }
    ngOnDestroy() {
        this.subscriptions.forEach((subscription) => subscription.unsubscribe());
    }
    static { this.ɵfac = function WizardComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WizardComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: WizardComponent, selectors: [["xf-wizard", "wizard", ""]], viewQuery: function WizardComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
            i0.ɵɵviewQuery(_c0$3, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.wizardForm = _t.first);
        } }, inputs: { wizard: "wizard" }, outputs: { onClose: "onClose" }, attrs: _c1$2, decls: 10, vars: 9, consts: [["wizardForm", "ngForm"], [1, "wizard", 3, "ngClass"], [1, "wizard-header-container"], [1, "wizard-header", "padding-left-16px", "padding-right-16px", "solid-border-bottom-1"], ["class", "wizard-steps w-100", 4, "ngIf"], [1, "wizard-body", "padding-left-16px", "padding-right-16px", "padding-bottom-40px"], ["xfViewContainer", "", 1, "h-100"], [1, "wizard-footer", 3, "ngClass"], [4, "ngFor", "ngForOf"], [1, "wizard-steps", "w-100"], [1, "wizard-step", 3, "ngClass"], [1, "step-counter"], [1, "fa", 3, "ngClass"], [1, "step-progress-bar", "w-100", 3, "ngClass"], [1, "step-name"], ["type", "button", "class", "btn btn-secondary btn-sm margin-left-8px", 3, "disabled", "ngClass", "id", "click", 4, "ngIf"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "margin-left-8px", 3, "click", "disabled", "ngClass", "id"], ["class", "me-1", 3, "ngClass", 4, "ngIf"], ["class", "ms-1", 3, "ngClass", 4, "ngIf"], [1, "me-1", 3, "ngClass"], [1, "ms-1", 3, "ngClass"]], template: function WizardComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "form", null, 0)(2, "div", 1)(3, "div", 2)(4, "div", 3);
            i0.ɵɵtemplate(5, WizardComponent_div_5_Template, 2, 1, "div", 4);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 5);
            i0.ɵɵtemplate(7, WizardComponent_ng_template_7_Template, 0, 0, "ng-template", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 7);
            i0.ɵɵtemplate(9, WizardComponent_ng_container_9_Template, 2, 1, "ng-container", 8);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(4, _c2$1, ctx.wizard.title, ctx.wizard.data.noSecondaryNav));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngIf", ctx.enabledSteps.length > 1);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c3, ctx.enabledSteps[ctx.wizard.currentStepIndex].buttons.length > 0));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.enabledSteps[ctx.wizard.currentStepIndex].buttons);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.ɵNgNoValidate, i2.NgControlStatusGroup, i2.NgForm, ViewContainerDirective], styles: [".wizard.wizard-with-title[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]{padding-bottom:0}.wizard[_ngcontent-%COMP%]   .wizard-header-container[_ngcontent-%COMP%]{position:sticky;top:0;z-index:1}.wizard[_ngcontent-%COMP%]   .wizard-header-container[_ngcontent-%COMP%]   .wizard-title-content[_ngcontent-%COMP%]{background:var(--wizard-header-bg-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]{display:inline-flex;justify-content:space-between;margin:15px auto 10px}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]{position:relative;display:flex;flex-direction:column;align-items:center;flex:1}@media (max-width: 768px){.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]{font-size:12px}}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]{font-weight:700}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]   .step-name[_ngcontent-%COMP%]{font-weight:400}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{outline:4px solid var(--wizard-step-active-color);background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]   .step-name[_ngcontent-%COMP%]{font-size:12px;font-weight:400}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{position:relative;z-index:5;display:flex;justify-content:center;align-items:center;width:25px;height:25px;border-radius:50%;background:var(--wizard-body-bg-color);border:1px solid var(--wizard-step-default-color);margin-bottom:6px}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.completed[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar[_ngcontent-%COMP%]{position:absolute;display:inline-block;top:13px;border:1px solid #ccc;background-color:#ccc}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.active[_ngcontent-%COMP%], .wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.completed[_ngcontent-%COMP%], .wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.first[_ngcontent-%COMP%]{border:1px solid var(--wizard-step-highlight-color);background-color:var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.first[_ngcontent-%COMP%]{left:50%}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.last[_ngcontent-%COMP%]{right:50%;z-index:0}.wizard[_ngcontent-%COMP%]   .wizard-body[_ngcontent-%COMP%]{height:calc(100vh - 265px);overflow:auto;background:var(--wizard-body-bg-color)}.wizard[_ngcontent-%COMP%]   .wizard-footer[_ngcontent-%COMP%]{background:var(--wizard-footer-bg-color);border-top:1px solid var(--footer-border-color);position:absolute;bottom:0;right:0;transition:left .4s linear;width:100%;z-index:11}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WizardComponent, [{
        type: Component,
        args: [{ selector: 'xf-wizard[wizard]', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form #wizardForm=\"ngForm\">\n  <div class=\"wizard\"\n    [ngClass]=\"{'wizard-with-title' : wizard.title, 'wizard-no-secondary-nav' : wizard.data.noSecondaryNav}\">\n    <div class=\"wizard-header-container\">\n      <div class=\"wizard-header padding-left-16px padding-right-16px solid-border-bottom-1\">\n        <div class=\"wizard-steps w-100\" *ngIf=\"enabledSteps.length > 1\">\n          <ng-container *ngFor=\"let step of enabledSteps; let i = index\">\n            <div class=\"wizard-step\"\n              [ngClass]=\"{'completed': step.isComplete || wizard.currentStepIndex === enabledSteps.length - 1, 'active': i === wizard.currentStepIndex}\">\n              <div class=\"step-counter\">\n                <span class=\"fa\" [ngClass]=\"{'fa-check font-size-10px': step.isComplete, 'fa-circle font-size-8px': !step.isComplete}\"></span>\n              </div>\n              <div class=\"step-progress-bar w-100\"\n                [ngClass]=\"{'first': i === 0, 'last': i === enabledSteps.length - 1, 'active': i === wizard.currentStepIndex, 'completed': step.isComplete}\">\n              </div>\n              <div class=\"step-name\">{{step.title}}</div>\n            </div>\n          </ng-container>\n        </div>\n      </div>\n    </div>\n    <div class=\"wizard-body padding-left-16px padding-right-16px padding-bottom-40px\">\n      <ng-template xfViewContainer class=\"h-100\"></ng-template>\n    </div>\n    <div class=\"wizard-footer\"\n      [ngClass]=\"{'padding-left-16px padding-right-16px padding-top-8px padding-bottom-8px' : enabledSteps[wizard.currentStepIndex].buttons.length > 0}\">\n      <ng-container *ngFor=\"let button of enabledSteps[wizard.currentStepIndex].buttons\">\n        <button type=\"button\" class=\"btn btn-secondary btn-sm margin-left-8px\" (click)=\"buttonClicked(button)\"\n          [disabled]=\"button.disabled\" *ngIf=\"button && !button.hidden\"\n          [ngClass]=\"{'float-end': button.pullRight, 'btn-primary': button.type === 'primary', 'btn-secondary': button.type === 'secondary', 'btn-outline-secondary': button.type !== 'primary' && button.type !== 'secondary'}\"\n          [id]=\"'wizard-' + button.name + '-btn'\">\n          <i *ngIf=\"(button.icon || ((loading || button.disabled) && button.disabledIcon)) && button.iconPosition === 'left'\"\n            [ngClass]=\"(loading || button.disabled) && button.disabledIcon ? button.disabledIcon : button.icon\"\n            class=\"me-1\"></i>\n          {{ (loading || button.disabled) && button.disabledText ? button.disabledText : button.text }}\n          <i *ngIf=\"(button.icon || ((loading || button.disabled) && button.disabledIcon)) && button.iconPosition === 'right'\"\n            [ngClass]=\"(loading || button.disabled) && button.disabledIcon ? button.disabledIcon : button.icon\"\n            class=\"ms-1\"></i>\n        </button>\n      </ng-container>\n    </div>\n  </div>\n</form>\n", styles: [".wizard.wizard-with-title .wizard-header{padding-bottom:0}.wizard .wizard-header-container{position:sticky;top:0;z-index:1}.wizard .wizard-header-container .wizard-title-content{background:var(--wizard-header-bg-color)}.wizard .wizard-header .wizard-steps{display:inline-flex;justify-content:space-between;margin:15px auto 10px}.wizard .wizard-header .wizard-steps .wizard-step{position:relative;display:flex;flex-direction:column;align-items:center;flex:1}@media (max-width: 768px){.wizard .wizard-header .wizard-steps .wizard-step{font-size:12px}}.wizard .wizard-header .wizard-steps .wizard-step.active{font-weight:700}.wizard .wizard-header .wizard-steps .wizard-step.active .step-name{font-weight:400}.wizard .wizard-header .wizard-steps .wizard-step.active .step-counter{outline:4px solid var(--wizard-step-active-color);background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .wizard-step .step-name{font-size:12px;font-weight:400}.wizard .wizard-header .wizard-steps .wizard-step .step-counter{position:relative;z-index:5;display:flex;justify-content:center;align-items:center;width:25px;height:25px;border-radius:50%;background:var(--wizard-body-bg-color);border:1px solid var(--wizard-step-default-color);margin-bottom:6px}.wizard .wizard-header .wizard-steps .wizard-step.completed .step-counter{background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .step-progress-bar{position:absolute;display:inline-block;top:13px;border:1px solid #ccc;background-color:#ccc}.wizard .wizard-header .wizard-steps .step-progress-bar.active,.wizard .wizard-header .wizard-steps .step-progress-bar.completed,.wizard .wizard-header .wizard-steps .step-progress-bar.first{border:1px solid var(--wizard-step-highlight-color);background-color:var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .step-progress-bar.first{left:50%}.wizard .wizard-header .wizard-steps .step-progress-bar.last{right:50%;z-index:0}.wizard .wizard-body{height:calc(100vh - 265px);overflow:auto;background:var(--wizard-body-bg-color)}.wizard .wizard-footer{background:var(--wizard-footer-bg-color);border-top:1px solid var(--footer-border-color);position:absolute;bottom:0;right:0;transition:left .4s linear;width:100%;z-index:11}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }], { xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective]
        }], wizardForm: [{
            type: ViewChild,
            args: ['wizardForm']
        }], wizard: [{
            type: Input
        }], onClose: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(WizardComponent, { className: "WizardComponent", filePath: "lib/components/wizard/wizard.component.ts", lineNumber: 19 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class WizardModule {
    static { this.ɵfac = function WizardModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WizardModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: WizardModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            RouterModule,
            UtilityModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WizardModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    WizardComponent
                ],
                imports: [
                    CommonModule,
                    FormsModule,
                    RouterModule,
                    UtilityModule
                ],
                exports: [
                    WizardComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(WizardModule, { declarations: [WizardComponent], imports: [CommonModule,
        FormsModule,
        RouterModule,
        UtilityModule], exports: [WizardComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Bitmask {
    constructor(value, padding = 8) {
        this.padding = padding;
        if (isNumber(value) || isString(value)) {
            this.integer = parseInt(value, padding);
            this.bits = this.integerToArray(this.integer, padding);
        }
        else if (isArray(value)) {
            this.bits = value.map((el) => { return parseInt(el) & 1; });
            this.integer = this.arrayToInteger(this.bits);
        }
        else {
            throw "Constructor needs either a number or an array o bits";
        }
    }
    getInteger() {
        return this.integer;
    }
    getBits() {
        return this.bits;
    }
    hasBit(bit) {
        return this.bits[bit] & 1;
    }
    setBit(bit, status) {
        status = status === true ? 1 : 0;
        this.bits[bit] = status;
        this.integer = this.arrayToInteger(this.bits);
    }
    toggleBit(bit) {
        let status = !(this.hasBit(bit));
        this.setBit(bit, status);
    }
    rShift(positions) {
        positions = positions || 1;
        this.integer = this.integer >> positions;
        this.bits = this.integerToArray(this.integer, this.padding);
    }
    lShift(positions) {
        positions = positions || 1;
        this.integer = this.integer << positions;
        this.bits = this.integerToArray(this.integer, this.padding);
    }
    integerToArray(integer, padding) {
        let bits = [];
        while (integer !== 0) {
            bits.push(integer & 1);
            integer = integer >> 1;
            padding--;
        }
        while (padding-- > 0) {
            bits.push(0);
        }
        return bits;
    }
    arrayToInteger(array) {
        return array.reduce((p, c, i) => { return p + Math.pow(2, i) * c; });
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ConnectorConfiguration {
    // teams: @type - pending teams model
    constructor(connector, name) {
        this.config = {};
        this.default = false;
        this.health_status = {};
        this.remote_status = {};
        this.connector = connector;
        this.name = name;
    }
}

class ConnectorOperation {
    constructor(connector, operation, title) {
        this.annotation = '';
        this.description = '';
        this.enabled = true;
        this.output_schema = {};
        this.visible = true;
        this.parameters = [];
        this.connector = connector;
        this.operation = operation;
        this.title = title;
    }
}

class Connector {
    constructor({ name, version, label, id } = {}) {
        this.active = false;
        this.cs_compatible = false;
        this.ingestion_supported = false;
        this.cs_approved = false;
        this.development = false;
        this.installed = false;
        this.metadata = {};
        this.install_result = {};
        this.tags = {};
        this.remote_status = {};
        this.name = name;
        this.version = version;
        this.label = label;
        this.id = id;
    }
}
__decorate([
    Type(() => ConnectorConfiguration, {})
], Connector.prototype, "configuration", void 0);
__decorate([
    Type(() => ConnectorOperation, {})
], Connector.prototype, "operations", void 0);

class Channel {
    constructor(name) {
        this.description = '';
        this.config = {};
        this.type = 'connector';
        this.defaultParams = {};
        this.isActive = true;
        this.name = name;
    }
    get iri() {
        return `${API.RULE_ENGINE}${FIXED_MODULE.CHANNEL}/${this.uuid}/`;
    }
    asSaved() {
        return {
            uuid: this.uuid,
            name: this.name,
            default_params: this.defaultParams,
            is_active: this.isActive,
            config: this.config,
            description: this.description,
            type: this.type
        };
    }
}
__decorate([
    Expose({ name: 'default_params' })
], Channel.prototype, "defaultParams", void 0);
__decorate([
    Expose({ name: 'is_active' })
], Channel.prototype, "isActive", void 0);

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Agent {
    constructor() {
        this.agent_name = '';
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Credentials {
    constructor(username, password) {
        this.username = username;
        this.password = password;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class XFFile {
    get iri() {
        return API.BASE + FIXED_MODULE.FILES + '/' + this.uuid;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class NavigationLink {
    constructor(link) {
        this.text = link.text;
        this.href = link.href;
    }
}

class PagedCollectionService {
    constructor(http) {
        this.http = http;
        this.countCache = {};
    }
    getCount(uuid) {
        this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        return this.countCache[uuid];
    }
    setCount(uuid, count) {
        this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        this.countCache[uuid].next(count);
    }
    load(pagedCollection, query, uuid) {
        if (uuid) {
            this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        }
        let params = pagedCollection.getURLData(query);
        // if (params.requestType === 'post') {
        //   return this.http.post(params.url, params.payload, { params: params.queryParams }).pipe(
        //     map((result: any) => {
        //       pagedCollection.setPage(result, query);
        //       if (uuid) {
        //         this.setCount(uuid, pagedCollection.totalItems || 0);
        //       }
        //       return pagedCollection;
        //     })
        //   );
        // } else {
        let queryParams = query.getURLQuery(pagedCollection.entity);
        return this.http.get(params.url, { params: queryParams }).pipe(map((result) => {
            pagedCollection.setPage(result, query);
            if (uuid) {
                this.setCount(uuid, pagedCollection.totalItems || 0);
            }
            return pagedCollection;
        }));
        // }
    }
    static { this.ɵfac = function PagedCollectionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PagedCollectionService)(i0.ɵɵinject(i1$1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PagedCollectionService, factory: PagedCollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PagedCollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }], null); })();

class PagedCollection {
    constructor(module, entity, relatedField, relatedUuid) {
        this.module = '';
        this.entity = {};
        this.currentPageNumber = 1;
        this.data = [];
        this.totalItems = 0;
        this.itemsPerPage = 30;
        this.query = new Query();
        this.service = PagedCollectionService;
        this.urlRequestType = 'post';
        this.type = 'base';
        this.module = module;
        this.entity = entity || new Entity(this.module);
        this.relatedField = relatedField;
        this.relatedUuid = relatedUuid;
    }
    getURLData(query) {
        let payload = query.getQueryObject();
        // if (!sortApplied) {
        //   query.buildOrderForPostRequest(self.entity, preparedQuery);
        // }
        // check for default query
        // let url = this.currentPageUrl || (this.urlRequestType === 'post' ? `${API.QUERY}${this.module}` : `${API.API_3_BASE}${this.module}`);
        //Integration with new PBaaS API's
        let url = this.currentPageUrl || (this.urlRequestType === 'post' ? `${API.SEALAB}+${this.module}` : `${API.SEALAB}${this.module}`);
        if (this.relatedField && this.relatedUuid) {
            url = url + '/' + this.relatedUuid + '/' + this.relatedField;
        }
        let urlParams;
        if (!this.currentPageUrl) {
            urlParams = query.getURLParameters();
        }
        return {
            requestType: this.urlRequestType,
            url: url,
            payload: payload,
            queryParams: urlParams
        };
    }
    setPage(data, query) {
        this.data = data['hydra:member'];
        // self.id = data['@id'];
        let id = data['@id'];
        // self.title = data['hydra:title'];
        //let title = data['hydra:title'];
        // self.error = data['@type'] === 'Error' || false;
        //let error = data['@type'] === 'Error' || false;
        // self.description = data['hydra:description'];
        let description = data['hydra:description'];
        // self.totalItems = data['hydra:totalItems'];
        this.totalItems = data['hydra:totalItems'];
        // self.itemsPerPage = data['hydra:itemsPerPage'] || angular.copy(self.query.limit);
        this.itemsPerPage = data['hydra:itemsPerPage'] || (query.limit);
        // if (self.id) {
        if (id) {
            //   var pageIndex = self.id.indexOf('page=');
            let pageIndex = id.indexOf('page=');
            //   if (pageIndex > 0) {
            if (pageIndex > 0) {
                //     var currentPageNum = self.id.substring(pageIndex + 5);
                var currentPageNum = id.substring(pageIndex + 5);
                //     self.currPageNum = isNaN(currentPageNum) ? self.currPageNum : currentPageNum;
                this.currentPageNumber = isNaN(currentPageNum) ? this.currentPageNumber : currentPageNum;
            }
        }
        let firstItemNum = (this.itemsPerPage * this.currentPageNumber) - this.itemsPerPage + 1;
        let lastItemNum = firstItemNum + data['hydra:member'].length - 1;
        this.totalPages = Math.ceil(this.totalItems / this.itemsPerPage);
        if (data['hydra:view']) {
            this.firstPageUrl = data['hydra:view']['hydra:first'];
            this.lastPageUrl = data['hydra:view']['hydra:last'];
            this.nextPageUrl = data['hydra:view']['hydra:next'];
            this.previousPageUrl = data['hydra:view']['hydra:previous'];
            this.gotoPageUrl = this.lastPageUrl ? this.lastPageUrl.substring(0, this.lastPageUrl.length - String(this.totalPages).length) : undefined;
        }
        else {
            this.firstPageUrl = undefined;
            this.lastPageUrl = undefined;
            this.nextPageUrl = undefined;
            this.previousPageUrl = undefined;
            this.currentPageUrl = undefined;
            this.gotoPageUrl = undefined;
        }
    }
    pageFirst() {
        this.currentPageNumber = 1;
        this.currentPageUrl = this.firstPageUrl;
    }
    pageLast() {
        this.currentPageNumber = 1;
        this.currentPageUrl = this.lastPageUrl;
    }
    pageNext() {
        this.currentPageNumber++;
        this.currentPageUrl = this.nextPageUrl;
    }
    pagePrevious() {
        this.currentPageNumber--;
        this.currentPageUrl = this.previousPageUrl;
    }
    ;
    recordPerPageChange() {
        this.currentPageNumber = 1;
        this.currentPageUrl = undefined;
    }
    gotoPage(page) {
        this.currentPageNumber = page;
        this.currentPageUrl = this.gotoPageUrl ? `${this.gotoPageUrl}${page}` : undefined;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Person {
    constructor(uuid) {
        this.uuid = uuid;
    }
    get display() {
        return this.firstname + ' ' + this.lastname;
    }
    get type() {
        return 'user';
    }
    get iri() {
        return API.BASE + FIXED_MODULE.PEOPLE + '/' + this.uuid;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Record {
    constructor(uuid) {
        this.uuid = uuid;
    }
}

class RecordTypeRule {
    constructor(name, recordType) {
        this.name = name;
        this.recordType = recordType;
        this.priority = 50;
        this.eventType = 'create';
        this.isChangedFields = [];
    }
}
__decorate([
    Type(() => FilterGroup)
], RecordTypeRule.prototype, "condition", void 0);

class Role {
    constructor() {
        this._permissions = [];
    }
    get display() {
        return this.name;
    }
    get type() {
        return 'role';
    }
}

class Rule {
    constructor(name) {
        this.recordTypeRules = [];
        this.recordTypes = [];
        this.isActive = false;
        this.eventSource = 'workflow';
        this.modules = '';
        this.actions = [];
        this.name = name;
    }
    get iri() {
        return `${API.RULE_ENGINE}${FIXED_MODULE.RULE}/${this.uuid}/`;
    }
    asSaved() {
        return {
            uuid: this.uuid,
            name: this.name,
            entity_type: this.entityType,
            event_type: this.eventType,
            trigger_condition: this.triggerCondition,
            actions: this.actions,
            is_active: this.isActive,
            event_source: this.eventSource
        };
    }
}
__decorate([
    Type(() => RecordTypeRule)
], Rule.prototype, "recordTypeRules", void 0);
__decorate([
    Expose({ name: 'entity_type' })
], Rule.prototype, "entityType", void 0);
__decorate([
    Expose({ name: 'event_type' })
], Rule.prototype, "eventType", void 0);
__decorate([
    Expose({ name: 'trigger_condition' })
], Rule.prototype, "triggerCondition", void 0);
__decorate([
    Expose({ name: 'is_active' })
], Rule.prototype, "isActive", void 0);
__decorate([
    Expose({ name: 'event_source' })
], Rule.prototype, "eventSource", void 0);

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Shift {
    constructor(uuid, name, startDate, endDate, users) {
        this.leader = null;
        this.uuid = uuid;
        this.name = name;
        this.startDate = startDate;
        this.endDate = endDate;
        this.users = users;
    }
    get endDateDifferent() {
        return this.getStartDate().toDateString() !== this.getEndDate().toDateString();
    }
    getStartDate() {
        return new Date(this.startDate * 1000);
    }
    getEndDate() {
        return new Date(this.endDate * 1000);
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ShiftPagedCollection extends PagedCollection {
    constructor() {
        super(...arguments);
        this.data = [];
    }
    setPage(data, query) {
        data['hydra:member'] = plainToInstance(Shift, data['hydra:member']);
        super.setPage(data, query);
    }
}

class Team {
    constructor(uuid) {
        this.uuid = uuid;
        this.users = [];
    }
    get display() {
        return this.name;
    }
    get type() {
        return 'team';
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class User {
    constructor() {
        this.teams = [];
        this.roles = [];
        this.first_name = '';
        this.last_name = '';
        this.is_active = false;
        this.is_superuser = false;
        this.type = 'sso';
    }
    get display() {
        return this.first_name + ' ' + this.last_name;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Wizard {
    constructor(title, steps, currentStepIndex, data) {
        this.title = title;
        this.steps = steps;
        this.currentStepIndex = currentStepIndex;
        this.data = data;
        this.close = () => { };
        this.next = () => of();
        this.back = () => { };
        this.wizardChanged$ = new EventEmitter();
    }
    // get loadingPercentage(): number {
    //   if (this.itemsLoading === 0) {
    //     return 100;
    //   } else {
    //     const tick = this.itemsLoading > 0 ? (100 / this.itemsLoading) : 0;
    //     return tick * this.itemsLoaded;
    //   }
    // }
    get currentStep() {
        const enabledSteps = this.steps.filter((step) => !step.disabled);
        return enabledSteps[this.currentStepIndex];
    }
}
class WizardStep {
    constructor(title, buttons, 
    // public icon: string,
    component, visible, disabled) {
        this.title = title;
        this.buttons = buttons;
        this.component = component;
        this.visible = visible;
        this.disabled = disabled;
        this.isComplete = false;
        this.visible = true;
    }
}
class WizardButton {
    constructor(text, action) {
        this.text = text;
        this.action = action;
        this.pullRight = false;
        this.name = '';
        this.disabled = false;
        this.hidden = false;
        this.type = 'secondary';
        this.iconPosition = 'left';
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Cron {
    constructor() {
        this.timezone = 'UTC';
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class AttributeService {
    getMMDAttributes() {
        const attributes = {};
        forEach(ModuleAttributeMap, (attribute, key) => {
            if (attribute.formType && attribute.mmd.allowUpdate) {
                attributes[key] = attribute;
            }
        });
        return attributes;
    }
    getFormAttributes() {
        const attributes = {};
        forEach(ModuleAttributeMap, (attribute, key) => {
            if (attribute.formType && attribute.usable) {
                attributes[key] = attribute;
            }
        });
        return attributes;
    }
    static { this.ɵfac = function AttributeService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AttributeService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: AttributeService, factory: AttributeService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AttributeService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class CollectionService {
    constructor(permission, http) {
        this.permission = permission;
        this.http = http;
    }
    getCollectionNames() {
        const workflowsReadPermission = this.permission.availablePermission(FIXED_MODULE.PLAYBOOK, 'read');
        let collectionSub = new Subject();
        if (!workflowsReadPermission) {
            collectionSub.next({});
            collectionSub.complete();
        }
        const params = new HttpParams().set('__selectFields', 'name');
        this.http.post(`${API.QUERY}workflow_collections`, {
            limit: ALL_RECORDS_SIZE
        }, { params }).subscribe((response) => {
            const collectionNamesList = response['hydra:member'];
            let collectionNames = {};
            collectionNamesList.forEach((collection) => {
                if (collection.hasOwnProperty('@id') && collection.hasOwnProperty('name')) {
                    Object.defineProperty(collectionNames, collection['@id'], collection.name);
                }
            });
            collectionSub.next(collectionNames);
            collectionSub.complete();
        });
        //}
        return collectionSub;
    }
    static { this.ɵfac = function CollectionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CollectionService)(i0.ɵɵinject(PermissionService), i0.ɵɵinject(i1$1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: CollectionService, factory: CollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: PermissionService }, { type: i1$1.HttpClient }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ConnectorService {
    constructor(http, utilityService) {
        this.http = http;
        this.utilityService = utilityService;
        this.cache = {};
    }
    // Connector Operations
    getConnector(name, version, agent, ignoreErrors = true) {
        let params = {};
        if (agent) {
            params.agent = agent;
        }
        const api = `${API.INTEGRATIONS}connectors/${name}/${version}/?format=json`;
        return this.http.post(api, {}, { params: params, context: new HttpContext().set(IGNORE_ERRORS, ignoreErrors) }).pipe(map$1((response) => {
            return plainToInstance(Connector, response);
        }));
    }
    updateConnector(id, data = {}) {
        const api = `${API.INTEGRATIONS}connectors/${id}/?format=json`;
        return this.http.put(api, data).pipe(map$1((response) => {
            return plainToInstance(Connector, response);
        }));
    }
    deleteConnector(id) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/delete/files/?format=json`;
        return this.http.delete(api);
    }
    // Connector Config Operatons
    createConnectorConfig(data) {
        const api = `${API.INTEGRATIONS}configuration/?format=json`;
        return this.http.post(api, data).pipe(map$1((response) => {
            return plainToInstance(ConnectorConfiguration, response);
        }));
    }
    updateConnectorConfig(id, data) {
        const api = `${API.INTEGRATIONS}configuration/${id}/?format=json`;
        return this.http.put(api, data).pipe(map$1((response) => {
            return plainToInstance(ConnectorConfiguration, response);
        }));
    }
    deleteConnectorConfig(id) {
        const api = `${API.INTEGRATIONS}configuration/${id}/`;
        return this.http.delete(api);
    }
    // Development Connector
    getDevelopmentConnector(id) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/?format=json`;
        return this.http.post(api, {}).pipe(map$1((response) => {
            return plainToInstance(Connector, response);
        }));
    }
    createDevelopmentConnector(data = {}) {
        const api = `${API.INTEGRATIONS}connector/development/entity/?format=json`;
        return this.http.post(api, data).pipe(map$1((response) => {
            return plainToInstance(Connector, response);
        }));
    }
    // Connector File Oeprations
    getConnectorFile(id) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/files/?format=json`;
        return this.http.post(api, {});
    }
    getConnectorFileContent(id, filepath) {
        const api = API.INTEGRATIONS + 'connector/development/entity/' + id + '/files' + '/?format=json';
        return this.http.post(api, { 'xpath': filepath });
    }
    createConnectorFile(id, data) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/files/?format=json`;
        return this.http.post(api, { xpath: data });
    }
    updateConnectorFile(id, data) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/rename/files/?format=json`;
        return this.http.post(api, data);
    }
    deleteConnectorFile(id, data) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/delete/files/?format=json`;
        return this.http.post(api, data);
    }
    // Connector folder operations
    createConnectorFolder(id, data) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/folders/?format=json`;
        return this.http.put(api, data).pipe(map$1((response) => {
            return response.data;
        }));
    }
    deleteConnectorFolder(id, data) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/delete/folders/?format=json`;
        return this.http.post(api, data);
    }
    getConnectorHealth(connector, config_id, agent) {
        let params = {
            config_id: config_id,
            connector_name: connector.name,
            connector_version: connector.version,
            agent: agent
        };
        const api = `${API.INTEGRATIONS}healthcheck/`;
        return this.http.post(api, params);
    }
    getConnectorOutputSchema(connectorName, connectorVersion, operation, config, params, agent) {
        const key = `${connectorName}/${connectorVersion}/${operation}`;
        if (this.cache[key] && !this.cache[key].error) {
            // TODO: Ensure this doesn't increase browser memory too much
            return of(this.cache[key]);
        }
        let queryParams = {};
        if (agent) {
            queryParams = { agent: agent };
        }
        const api = `${API.INTEGRATIONS}connector_output_schema/${connectorName}/${connectorVersion}/`;
        const data = {
            'operation': operation,
            'config': config,
            'params': params
        };
        return this.http.post(api, data, { params: queryParams, context: new HttpContext().set(IGNORE_ERRORS, true) }).pipe(catchError$1((error) => {
            console.warn(error);
            return of({
                data: {
                    output_schema: {}
                },
                error: true
            });
        }), tap$1((response) => {
            this.cache[key] = response;
        }));
        // Pending error handling
    }
    // Maybe common for dev and installed? or does not matter?
    executeConnectorAction(connector, operation, configuration, params, audit, auditInfo, agent) {
        const api = `${API.INTEGRATIONS}execute/?format=json`;
        let requestParams = {
            connector: connector.name,
            version: connector.version,
            config: configuration.config,
            operation: operation.operation,
            params: params,
            audit: audit,
            audit_info: auditInfo
        };
        if (agent) {
            requestParams.agent = agent;
        }
        return this.http.post(api, requestParams, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        });
    }
    // Maybe common for dev and installed? or does not matter?
    exportDevelopedConnector(id) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/export/?format=json`;
        return this.http.get(api, { responseType: 'arraybuffer' });
        // Pending error handling
    }
    // Below is a list of pending functions - need to figure out if some can be consolidated together
    // publishConnector
    // installConnector
    // getAgents
    // getIngestionPlaybookCollectionUUID
    // getSamplePlaybooks
    // getDataSources
    // loadConnectors - this is dev or installed ?
    // loadByTags
    // getConfiguredConnectorList
    // getConnectorActionDetails
    // getConfiguredConnectors
    // getConnectorOutputSchema
    // getCategories
    // getAnnotations
    // getAnnotationConnectors
    // applyRolesToActions
    // downloadHelpPDF
    getDependencyStatus(connector) {
        const api = `${API.INTEGRATIONS}connectors/dependencies_check/${connector.name}/${connector.version}/?format=json`;
        return this.http.get(api).pipe(map$1((response) => {
            return response;
        }));
    }
    getFieldData(data) {
        const api = `${API.INTEGRATIONS}execute/?format=json`;
        return this.http.post(api, data, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        });
    }
    // installDependencies
    filterConnectorOperations(operation, installed) {
        installed = (!this.utilityService.isUndefined(installed) && _.isBoolean(installed)) ? installed : true;
        if (installed) {
            return (operation.enabled && (this.utilityService.isUndefined(operation.visible) || operation.visible === true));
        }
        return this.utilityService.isUndefined(operation.visible) || operation.visible === true;
    }
    getDevelopedConnector(id) {
        const api = `${API.INTEGRATIONS}connector/development/entity/${id}/?format=json`;
        return this.http.post(api, {});
    }
    //Get Connector Template
    getConnectorTemplates(data) {
        const api = `${API.INTEGRATIONS}connector/development/templates/?format=json`;
        return this.http.post(api, data);
    }
    //Create New connector
    createConnector(connectorConfig) {
        const api = `${API.INTEGRATIONS}connector/development/entity/?format=json`;
        return this.http.post(api, connectorConfig);
    }
    loadConnectors(params = {}) {
        params.page_size = ALL_RECORDS_SIZE;
        return this.http.get(`${API.INTEGRATIONS}connectors/`, { params: params }).pipe(map$1((response) => {
            return plainToInstance(Connector, response['hydra:member']);
        }));
    }
    //get agents in connector configs
    getAgents(connector, installed) {
        let config = {
            'active': true
        };
        if (installed) {
            config.installed = true;
        }
        // versionService.getIntergrationVersionDetails().then(function (integrationVersionDetails) {
        return this.http.get(`${API.INTEGRATIONS}${FIXED_MODULE.CONNECTORS}/${FIXED_MODULE.AGENTS}/${connector.name}/`, { params: config }).pipe(map$1((installedAgents) => {
            if (installedAgents['hydra:member'].length > 0) {
                //TO DO: Agent compatibilty
                //installedAgents['hydra:member'].forEach((agent: any) => {
                //var minimumCompatibilityVersion = integrationVersionDetails.minimum_compatibility_version.split('-')[0];
                //agent.isIncompatible = parseFloat(agent.agent_version.replace(/\./g, '')) >= parseFloat(minimumCompatibilityVersion.replace(/\./g, '')) ? false : true;
                //});
            }
            return plainToInstance(Agent, installedAgents['hydra:member']);
        }));
    }
    getConfiguredAgents() {
        return this.http.get(`${API.INTEGRATIONS}${FIXED_MODULE.AGENTS}/`).pipe(map$1((response) => {
            return response['hydra:member'];
        }));
    }
    installConnectorOnAgents(name, version, queryParams = {}, payload) {
        queryParams.replace = true;
        queryParams.trust = true;
        return this.http.post(`${API.INTEGRATIONS}import-connector/${name}/${version}/`, payload, { params: queryParams });
    }
    getConnectorConfigurations(name, version, queryparams = {}) {
        return this.http.get(`${API.INTEGRATIONS}configuration/${name}/${version}/`, { params: queryparams });
    }
    getConfigurationDetail(uuid) {
        return this.http.get(`${API.INTEGRATIONS}configuration/${uuid}/`);
    }
    getConfigId(configurations, configId) {
        const defaultConfig = _.find(configurations, (config) => {
            return config.default;
        });
        let config_id = '';
        let isJinja = false;
        if (configId && configId.replace(/'/g, '').length > 0) {
            if (UUID_REGEX.test(configId) || /^[0-9a-f]{32}$/.test(configId)) {
                let foundConfig = _.find(configurations, (config) => {
                    return config.config_id === configId;
                });
                if (foundConfig) {
                    config_id = configId;
                }
                else if (defaultConfig) {
                    config_id = defaultConfig.config_id;
                }
            }
            else {
                isJinja = true;
                config_id = configId;
            }
        }
        else if (configurations.length > 0) {
            if (defaultConfig) {
                config_id = defaultConfig.config_id;
            }
            else if (configurations.length === 1) {
                configId = configurations[0].config_id;
            }
        }
        return { config_id, isJinja };
    }
    static { this.ɵfac = function ConnectorService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ConnectorService)(i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(UtilityService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ConnectorService, factory: ConnectorService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ConnectorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }, { type: UtilityService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const WS_ENDPOINT = 'wss://' + location.host + '/api/ws/';
const RECONNECT_INTERVAL = 5000;
class WebsocketService {
    constructor(storageService) {
        this.storageService = storageService;
        this.websocketSessionID = null;
        this.observablesTopics = {};
        this.status$ = new BehaviorSubject(false);
        this.messages$ = new Subject();
    }
    connect() {
        this.create();
        this.connectionStatus$.pipe(skip(1), filter$1(status => !status), tap(() => this.create())).subscribe();
    }
    set(websocketSessionID) {
        this.websocketSessionID = websocketSessionID;
    }
    create() {
        this.close();
        this.websocketSessionID = this.websocketSessionID ?? v4();
        let queryParams = `?websocketSessionID=${this.websocketSessionID}&token=${this.storageService.getItem(TOKEN.ACCESS_KEY)}`;
        const openObserver = new Subject();
        this.openObserverSubscription = openObserver.subscribe(() => {
            this.status$.next(true);
            forEach(this.observablesTopics, (value, key) => {
                this.websocketSubscribe(key, true);
            });
        });
        const closeObserver = new Subject();
        this.closeObserverSubscription = closeObserver.pipe(map((_) => false)).subscribe(this.status$);
        this.ws = webSocket({
            url: WS_ENDPOINT + queryParams,
            openObserver,
            closeObserver,
        });
        this.ws.pipe(retry({
            delay: (errs) => {
                this.status$.next(false);
                console.log(`Websocket connection down, will attempt reconnection in ${RECONNECT_INTERVAL}ms`);
                return timer(RECONNECT_INTERVAL);
            }
        })).subscribe(this.messages$);
    }
    get connectionStatus$() {
        return this.status$.pipe(distinctUntilChanged());
    }
    close() {
        if (this.ws) {
            this.openObserverSubscription.unsubscribe();
            this.closeObserverSubscription.unsubscribe();
            this.ws.unsubscribe();
        }
    }
    message(message) {
        this.connectionStatus$.pipe(filter$1(status => status), tap(() => this.ws.next(message)), take(1)).subscribe();
    }
    websocketSubscribe(topic, reconnect = false) {
        if (this.observablesTopics[topic] && !reconnect) {
            return this.observablesTopics[topic];
        }
        else {
            let messagesSubject$ = this.observablesTopics[topic] || new ReplaySubject(1);
            if (this.status$.value) {
                messagesSubject$.next(this.ws.multiplex(() => ({ subscribe: [topic] }), () => ({ unsubscribe: [topic] }), (message) => {
                    return message.topics.includes(topic);
                }).pipe(map((message) => message.message), finalize(() => {
                    if (!this.observablesTopics[topic].observed) {
                        this.observablesTopics[topic].complete();
                        delete this.observablesTopics[topic];
                    }
                })));
            }
            else {
                messagesSubject$.next(of());
            }
            this.observablesTopics[topic] = messagesSubject$;
            return this.observablesTopics[topic].pipe(switchAll());
        }
    }
    static { this.ɵfac = function WebsocketService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WebsocketService)(i0.ɵɵinject(StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: WebsocketService, factory: WebsocketService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WebsocketService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: StorageService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DataProviderService {
    constructor(entityService, websocketService) {
        this.entityService = entityService;
        this.websocketService = websocketService;
        this.topics$ = {};
        this.websocketTopics$ = {};
    }
    clear() {
        Object.keys(this.topics$).forEach((topic) => {
            if (this.topics$[topic]) {
                this.topics$[topic].complete();
                delete this.topics$[topic];
            }
        });
        Object.keys(this.websocketTopics$).forEach((topic) => {
            if (this.websocketTopics$[topic]) {
                this.websocketTopics$[topic].unsubscribe();
                delete this.websocketTopics$[topic];
            }
        });
    }
    observe(entity, uuid, relatedField, queryObject) {
        let topic = `${entity.type}${uuid ? '/' + uuid : ''}${relatedField ? '/' + relatedField : ''}`;
        if (!this.websocketTopics$[topic]) {
            this.websocketTopics$[topic] = this.websocketService.websocketSubscribe('/topic/' + topic).pipe(concatMap$1((message) => this.handleWebsocketUpdates(message, topic))).subscribe();
        }
        let selectedFields = queryObject?.selectedFields || ['uuid'];
        if (!this.topics$[topic]) {
            this.topics$[topic] = new BehaviorSubject({
                entity: entity,
                changedFields: selectedFields,
                sourceId: 'entityCache'
            });
        }
        entity = this.topics$[topic].value.entity;
        let newFields = difference(selectedFields ? selectedFields : [], keys(entity.values || {}));
        entity.uuid = uuid;
        return this.getData(topic, entity, newFields).pipe(concatMap$1(() => this.topics$[topic].pipe(filter((entityChange) => !queryObject?.selectedFields || intersection(entityChange.changedFields, queryObject?.selectedFields).length > 0))));
    }
    save(entityChange) {
        let topic = `${entityChange.entity.type}${entityChange.entity.uuid ? '/' + entityChange.entity.uuid : ''}`;
        return this.entityService.save(entityChange.entity, entityChange.changedFields).pipe(tap$1((entity) => {
            this.topics$[topic].next({
                entity: entity,
                changedFields: entityChange.changedFields,
                sourceId: 'entityCache'
            });
        }));
    }
    handleWebsocketUpdates(message, topic) {
        if (message.websocketSessionID !== this.websocketService.websocketSessionID && this.topics$[topic].value) {
            let entity = this.topics$[topic].value?.entity;
            let interestedFields = intersection(keys(this.topics$[topic].value?.entity.values || {}), message.data[0].changedata);
            if (interestedFields.length > 0) {
                return this.getData(topic, entity, interestedFields);
            }
        }
        return of(null);
    }
    getData(topic, entity, selectedFields = []) {
        if (!selectedFields.length) {
            return of(entity);
        }
        return this.entityService.hydrate(entity, selectedFields).pipe(tap$1((updatedEntity) => {
            this.topics$[topic].next({
                entity: updatedEntity,
                changedFields: selectedFields,
                sourceId: 'entityCache'
            });
        }));
    }
    static { this.ɵfac = function DataProviderService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DataProviderService)(i0.ɵɵinject(EntityService), i0.ɵɵinject(WebsocketService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DataProviderService, factory: DataProviderService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DataProviderService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: EntityService }, { type: WebsocketService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DateService {
    constructor() { }
    buildDateFilterGroup(datetimeFilter, fieldName) {
        let filters = [];
        const currentDate = new Date();
        let date1 = new Date();
        let date2 = new Date();
        switch (datetimeFilter.differenceType) {
            case 'years':
                let startOfYear = new Date(currentDate.getFullYear() + datetimeFilter.differenceValue, 0, 1);
                let endOfYear = new Date(currentDate.getFullYear() + datetimeFilter.differenceValue, 11, 31);
                date1 = startOfYear;
                date2 = endOfYear;
                break;
            case 'months':
                let startOfMonth = new Date(currentDate.getFullYear(), currentDate.getMonth() + datetimeFilter.differenceValue, 1);
                let endOfMonth = new Date(currentDate.getFullYear(), currentDate.getMonth() + datetimeFilter.differenceValue + 1, 0);
                let exactTimeAgo = new Date(currentDate);
                exactTimeAgo.setMonth(currentDate.getMonth() + datetimeFilter.differenceValue);
                if (datetimeFilter.differenceValue <= 0) {
                    date1 = datetimeFilter.lastDate ? startOfMonth : exactTimeAgo;
                    date2 = datetimeFilter.lastDate ? endOfMonth : currentDate;
                }
                else {
                    date1 = datetimeFilter.lastDate ? startOfMonth : currentDate;
                    date2 = datetimeFilter.lastDate ? endOfMonth : exactTimeAgo;
                }
                break;
            case 'days':
                if (datetimeFilter.differenceValue <= 0) {
                    date1 = new Date(currentDate);
                    date1.setDate(currentDate.getDate() + datetimeFilter.differenceValue);
                    date1.setHours(0);
                    date1.setMinutes(0);
                    date1.setSeconds(0);
                    date1.setMilliseconds(0);
                    date2 = new Date(currentDate);
                }
                else {
                    date1 = new Date(currentDate);
                    date2 = new Date(currentDate);
                    date2.setDate(currentDate.getDate() + datetimeFilter.differenceValue);
                    date1.setHours(23);
                    date1.setMinutes(59);
                    date1.setSeconds(59);
                    date1.setMilliseconds(999);
                }
                break;
            case 'hours':
                if (datetimeFilter.differenceValue < 0) {
                    date1 = new Date(currentDate);
                    date1.setHours(currentDate.getHours() + datetimeFilter.differenceValue);
                    date2 = new Date(currentDate);
                }
                else {
                    date1 = new Date(currentDate);
                    date2 = new Date(currentDate);
                    date2.setHours(currentDate.getHours() + datetimeFilter.differenceValue);
                }
                break;
            case 'mins':
                if (datetimeFilter.differenceValue < 0) {
                    date1 = new Date(currentDate);
                    date1.setMinutes(currentDate.getMinutes() + datetimeFilter.differenceValue);
                    date2 = new Date(currentDate);
                }
                else {
                    date1 = new Date(currentDate);
                    date2 = new Date(currentDate);
                    date2.setMinutes(currentDate.getMinutes() + datetimeFilter.differenceValue);
                }
                break;
            default:
                console.log('wrong difference type selected');
        }
        filters = [
            new Filter(fieldName, 'gte', date1.toISOString()),
            new Filter(fieldName, 'lte', date2.toISOString())
        ];
        return new FilterGroup(filters);
    }
    static { this.ɵfac = function DateService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DateService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DateService, factory: DateService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();

class ExportService {
    constructor(getEndPathNamePipe, http, entityService) {
        this.getEndPathNamePipe = getEndPathNamePipe;
        this.http = http;
        this.entityService = entityService;
    }
    /**
      * @ngdoc method
      * @name xf-ui#exportService#loadRowsForExport
      * @methodOf exportService
      *
      * @description
      * Loads exported versions of the given rows from CH.
      *
      * @param {array} rows An array of entity objects to export. Each object must have '@id' key.
      * @param {string} entityType The name of the entity (workflow).
      * @returns {Promise} Promise that will resolve with the exported hydra response
      **/
    loadRowsForExport(rows, entityType, selectedFields, skipExportFlag = false, includeVersions, childEntityName) {
        if (rows.length === 0) {
            return of([]);
        }
        let ids = rows.map((row) => {
            return row['@id'] ? this.getEndPathNamePipe.transform(row['@id']) : row.uuid;
        });
        let operator = rows.length > 1 ? 'in' : 'eq';
        let queryBody = new Query({
            logic: 'AND',
            filters: [new Filter('uuid', operator, ids.join('|'))]
        });
        if (selectedFields) {
            queryBody.selectedFields = selectedFields;
        }
        if (entityType === 'workflows' || entityType === 'workflow_collections') {
            queryBody.ignoreFields = ['createDate', 'createUser', 'modifyDate', 'modifyUser'];
        }
        let queryParams = {
            $export: !skipExportFlag,
            limit: ALL_RECORDS_SIZE
        };
        if (includeVersions) {
            queryParams.$versions = true;
        }
        if (!childEntityName) {
            queryParams.$relationships = true;
        }
        return this.entityService.build(entityType).pipe(concatMap$1((entity) => {
            return this.http.post(`${API.QUERY}${entityType}`, queryBody.getQueryObject(), { params: queryParams }).pipe(concatMap$1((data) => {
                if (!childEntityName) {
                    return of(data['hydra:member']);
                }
                const collectionUuids = ___default.map(data['hydra:member'], 'uuid');
                let childQueryBody = new Query({
                    logic: 'AND',
                    filters: [new Filter('collection.uuid', 'in', collectionUuids.join('|'))]
                });
                let childQueryParams = {
                    $relationships: true,
                    $export: !skipExportFlag,
                    limit: ALL_RECORDS_SIZE
                };
                if (includeVersions) {
                    childQueryParams.$versions = true;
                }
                if (childEntityName && childEntityName === 'workflows') {
                    childQueryBody.ignoreFields = ['createDate', 'createUser', 'modifyDate', 'modifyUser'];
                }
                return this.http.post(`${API.QUERY}${childEntityName}`, childQueryBody.getQueryObject(), { params: childQueryParams }).pipe(map$1((childData) => {
                    data['hydra:member'].forEach((collection) => {
                        let childItems = ___default.filter(childData['hydra:member'], (childItem) => {
                            return this.getEndPathNamePipe.transform(childItem.collection) === collection.uuid;
                        });
                        collection[childEntityName] = childItems;
                    });
                    return data['hydra:member'];
                }));
            }));
        }));
    }
    static { this.ɵfac = function ExportService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ExportService)(i0.ɵɵinject(GetEndPathNamePipe), i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(EntityService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ExportService, factory: ExportService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ExportService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: GetEndPathNamePipe }, { type: i1$1.HttpClient }, { type: EntityService }], null); })();

class FileService {
    constructor(http, fileSaverService) {
        this.http = http;
        this.fileSaverService = fileSaverService;
    }
    download(file) {
        return this.downloadBinaryFromIri(file.iri, file.mimeType, file.filename);
    }
    downloadBinaryFromIri(filePath, mimeType = '', filename = 'file') {
        return this.http.get(filePath, {
            responseType: 'arraybuffer',
            headers: {
            // 'Accept': 'application/octet-stream'
            }
        }).pipe(map$1((response) => {
            let blob = new Blob([response], {
                type: mimeType
            });
            this.fileSaverService.save(blob, filename);
        }));
    }
    upload(file, iri) {
        const formData = new FormData();
        formData.append('file', file);
        return this.http.post(iri, formData);
    }
    downloadJsonFile(data, fileName) {
        let json = JSON.stringify(data);
        let blob = new Blob([json], {
            type: 'application/json;charset=utf-8;'
        });
        this.fileSaverService.save(blob, fileName + '.json');
    }
    static { this.ɵfac = function FileService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FileService)(i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(i2$2.FileSaverService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FileService, factory: FileService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FileService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }, { type: i2$2.FileSaverService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SubscriptionQueueService {
    constructor() {
        this.queue = {};
    }
    get(key) {
        return this.queue[key];
    }
    set(key, subscription) {
        this.queue[key] = subscription;
    }
    clear(key) {
        if (key) {
            delete this.queue[key];
        }
        else {
            this.queue = {};
        }
    }
    static { this.ɵfac = function SubscriptionQueueService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SubscriptionQueueService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: SubscriptionQueueService, factory: SubscriptionQueueService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SubscriptionQueueService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

class FilterCollectionService {
    constructor(subscriptionService, http, getEndPathNamePipe, picklistService, modelMetadatasService, interpolate, settingsService) {
        this.subscriptionService = subscriptionService;
        this.http = http;
        this.getEndPathNamePipe = getEndPathNamePipe;
        this.picklistService = picklistService;
        this.modelMetadatasService = modelMetadatasService;
        this.interpolate = interpolate;
        this.settingsService = settingsService;
    }
    load(type) {
        let KEY = `queries_${type}`;
        let _subscription = this.subscriptionService.get(KEY);
        if (isUndefined(_subscription)) {
            _subscription = this.http.get(`${API.API_3_BASE}queries?$limit=${ALL_RECORDS_SIZE}&$relationships=true&models__type=${type}`);
            this.subscriptionService.set(KEY, _subscription);
        }
        return _subscription.pipe(map((response) => {
            return response['hydra:member'];
        }));
    }
    saveUserQuery(query) {
        return this.save(query, 'user_queries');
    }
    saveSystemQuery(query) {
        return this.save(query, 'system_queries');
    }
    save(query, queryType) {
        if (isUndefined(queryType)) {
            queryType = query['@type'] === 'UserQuery' ? 'user_queries' : 'system_queries';
        }
        let queryToSave = cloneDeep(query);
        queryToSave.models = isArray(queryToSave.models) ? queryToSave.models[0] : null;
        let _subscription;
        if (query['@id']) {
            _subscription = this.http.put(`${API.API_3_BASE}${queryType}/${this.getEndPathNamePipe.transform(query['@id'])}?$relationships=true`, queryToSave);
        }
        else {
            _subscription = this.http.post(`${API.API_3_BASE}${queryType}?$relationships=true`, queryToSave);
        }
        return _subscription.pipe(map((response) => {
            return response.data;
        }));
    }
    deleteQuery(query) {
        let module = query['@type'] === 'UserQuery' ? 'user_queries' : 'system_queries';
        return this.http.delete(`${API.API_3_BASE}${module}/${this.getEndPathNamePipe.transform(query['@id'])}`);
    }
    loadQueryFilterValues(query) {
        let filters = query ? query.query.filters : [];
        let _subscriptions = [];
        forEach(filters, (filter) => {
            if (filter.value && filter.type) {
                if (filter.type === 'object' && isString(filter.value)) {
                    let _subscription = this._loadResource(filter.value).subscribe((data) => {
                        filter.value = data;
                    });
                    _subscriptions.push(_subscription);
                }
                else if (filter.type === 'array') {
                    forEach(filter.value, (item, index) => {
                        if (isString(item)) {
                            let _subscription = this._loadResource(item).subscribe((data) => {
                                filter.value[index] = data;
                            });
                            _subscriptions.push(_subscription);
                        }
                    });
                }
            }
        });
        if (_subscriptions.length) {
            return forkJoin(_subscriptions);
        }
        else {
            return of(filters);
        }
    }
    _loadResource(iri) {
        let _subscription = this.subscriptionService.get(iri);
        if (!_subscription) {
            if (iri.indexOf('picklist') >= 0) {
                _subscription = this.picklistService.getPicklistByIri(iri);
            }
            else {
                //_subscription = this.http.get(CommonUtils.getIriApiPath(iri)).get({})
                _subscription = this.http.get(iri);
            }
            this.subscriptionService.set(iri, _subscription);
        }
        return _subscription.pipe(map((data) => {
            let type = data['@type'];
            if (type !== 'Picklist') {
                var classMetaData = this.modelMetadatasService.getMetadataByModuleType(type);
                data.display = classMetaData ? this.interpolate.transform(classMetaData.displayName, data) : '';
            }
            return data;
        }));
    }
    static { this.ɵfac = function FilterCollectionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterCollectionService)(i0.ɵɵinject(SubscriptionQueueService), i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(GetEndPathNamePipe), i0.ɵɵinject(PicklistService), i0.ɵɵinject(ModelMetadataService), i0.ɵɵinject(InterpolatePipe), i0.ɵɵinject(SystemSettingsService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FilterCollectionService, factory: FilterCollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterCollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: SubscriptionQueueService }, { type: i1$1.HttpClient }, { type: GetEndPathNamePipe }, { type: PicklistService }, { type: ModelMetadataService }, { type: InterpolatePipe }, { type: SystemSettingsService }], null); })();

class LicenseService {
    constructor(http, storageService) {
        this.http = http;
        this.storageService = storageService;
        this.license = null;
    }
    getLicenseDetails() {
        let licenseDetails = this.storageService.getItem(STORAGE_KEYS.LICENSE_DETAILS);
        if (licenseDetails) {
            return of(licenseDetails);
        }
        else {
            return this.setLicense();
        }
    }
    setLicense() {
        return this.http.get(API.AUTH + 'licenses/').pipe(map$1((response) => {
            this.storageService.setItem(STORAGE_KEYS.LICENSE_DETAILS, response['hydra:member'][0]);
            return response['hydra:member'][0];
        }));
    }
    getWorkflowMetrics() {
        return this.http.get(API.WORKFLOW + 'workflows/license/metrics/?format=json');
    }
    set licenseType(type) {
        this.license_type = type;
    }
    get licenseType() {
        return this.license_type;
    }
    static { this.ɵfac = function LicenseService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LicenseService)(i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LicenseService, factory: LicenseService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LicenseService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }, { type: StorageService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ManifestService {
    constructor() {
    }
    set(appManifests) {
        this.appManifests = appManifests;
    }
    get() {
        return this.appManifests;
    }
    static { this.ɵfac = function ManifestService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ManifestService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ManifestService, factory: ManifestService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ManifestService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();

class ModulesService {
    constructor(http) {
        this.http = http;
        this.API = API;
    }
    get(module, params) {
        return this.http.get(this.API.BASE + module);
    }
    static { this.ɵfac = function ModulesService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModulesService)(i0.ɵɵinject(i1$1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModulesService, factory: ModulesService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModulesService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DjangoPagedCollectionService extends PagedCollectionService {
    load(pagedCollection, query, uuid) {
        return super.load(pagedCollection, query, uuid).pipe(map$1((response) => {
            return response;
        }));
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵDjangoPagedCollectionService_BaseFactory; return function DjangoPagedCollectionService_Factory(__ngFactoryType__) { return (ɵDjangoPagedCollectionService_BaseFactory || (ɵDjangoPagedCollectionService_BaseFactory = i0.ɵɵgetInheritedFactory(DjangoPagedCollectionService)))(__ngFactoryType__ || DjangoPagedCollectionService); }; })(); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DjangoPagedCollectionService, factory: DjangoPagedCollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DjangoPagedCollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class DjangoPagedCollection extends PagedCollection {
    constructor(endpoint, module, entity) {
        super(module, entity);
        this.endpoint = '';
        this.endpoint = endpoint;
        this.service = DjangoPagedCollectionService;
        this.urlRequestType = 'get';
        this.type = 'django';
    }
    getURLData(query) {
        return {
            requestType: this.urlRequestType,
            url: this.endpoint,
            payload: {},
            queryParams: {}
        };
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class PlaybookService {
    constructor(http, permission, collectionService, exportService) {
        this.http = http;
        this.permission = permission;
        this.collectionService = collectionService;
        this.exportService = exportService;
    }
    getActionPlaybooks(entity, useConditions, rows) {
        let workflowsExecutePermission = this.permission.availablePermission(FIXED_MODULE.PLAYBOOK, 'update');
        let actionPBSub = new Subject();
        if (workflowsExecutePermission === true) {
            // if (service.loadedPlaybookActions.hasOwnProperty(entity.module)) {
            //   if (useConditions) {
            //     return filterPlaybooks(service.loadedPlaybookActions[entity.module], rows, entity);
            //   } else {
            //     defer.resolve(service.loadedPlaybookActions[entity.module].playbooks);
            //     return defer.promise;
            //   }
            // }
            this.collectionService.getCollectionNames().subscribe((collectionNames) => {
                let queryParams = new HttpParams({
                    fromObject: {
                        type: entity.module || entity.type,
                        isActive: true,
                        $relationships: true,
                        $triggerOnly: true,
                        $limit: MAX_PLAYBOOK_RECORDS
                    }
                });
                this.http.get(API.WORKFLOW_ACTION, { params: queryParams }).subscribe({
                    next: (response) => {
                        response['hydra:member'].forEach((playbook) => {
                            playbook.collectionName = collectionNames[playbook.collection];
                            if (!isUndefined(playbook.steps[0].arguments.title) && playbook.steps[0].arguments.title !== '') {
                                playbook.actionTriggerName = playbook.steps[0].arguments.title;
                            }
                            else {
                                playbook.actionTriggerName = playbook.name;
                            }
                        });
                        let playbookData = {
                            playbooks: response['hydra:member'],
                            selectedFields: this.loadFieldsFromPlaybookConditions(response['hydra:member'])
                        };
                        //service.loadedPlaybookActions[entity.module] = playbookData;
                        if (useConditions) {
                            this.filterPlaybooks(playbookData, rows, entity).subscribe();
                        }
                        else {
                            actionPBSub.next(response['hydra:member']);
                            actionPBSub.complete();
                        }
                    }, error: (error) => {
                        //statusCodeService(response);
                        actionPBSub.error(error);
                    }
                });
            });
        }
        else {
            actionPBSub.next([]);
        }
        return actionPBSub;
    }
    loadFieldsFromPlaybookConditions(playbooks) {
        var selectFields = ['uuid'];
        playbooks.forEach((playbook) => {
            var triggerstep = this.getTriggerStep(playbook);
            if (!isUndefined(triggerstep)) {
                var fieldsFromFilters = this.extractFieldsFromFilters(triggerstep.arguments.displayConditions);
                selectFields = selectFields.concat(fieldsFromFilters);
            }
        });
        return _.uniq(selectFields);
    }
    getTriggerStep(playbook) {
        return _.find(playbook.steps, (step) => {
            return step.uuid === playbook.triggerstep;
        });
    }
    extractFieldsFromFilters(filters) {
        let fields = [];
        forEach(filters, (filter) => {
            if (filter.filters) {
                fields = fields.concat(this.extractFieldsFromFilters(filter.filters));
                return;
            }
            let field = filter.field || filter._field;
            fields.push(field);
        });
        return _.uniq(fields);
    }
    filterPlaybooks(playbookData, rows = [], entity) {
        let playbooks = playbookData.playbooks;
        let filteredPlaybooks = [];
        let selectedFields = playbookData.selectedFields;
        return this.exportService.loadRowsForExport(rows, entity.type, selectedFields, true).pipe(map$1((response) => {
            let fullRows = response;
            let entityRows = [];
            //build entity
            fullRows.forEach((row) => {
                let rowEntity = cloneDeep(entity);
                //entityFieldsService.applyValues(rowEntity.fields, row);
                entityRows.push(rowEntity);
            });
            //   angular.forEach(playbooks, function (playbook) {
            //     var triggerstep = service.getTriggerStep(playbook);
            //     if (!angular.isUndefined(triggerstep)) {
            //       if (triggerstep.arguments.displayConditions && (entity.id || rows.length > 0) && !triggerstep.arguments.noRecordExecution) {
            //         playbook._hide = false;
            //         var displayConditions = new Query(triggerstep.arguments.displayConditions[entity.module]);
            //         if (rows.length > 0) {
            //           $q.all(promises).then(function () {
            //             angular.forEach(entityRows, function (rowEntity) {
            //               var result = rowEntity.evaluate(displayConditions);
            //               playbook._hide = playbook._hide || !result;
            //             });
            //           });
            //         } else {
            //           var result = entity.evaluate(displayConditions);
            //           playbook._hide = !result;
            //         }
            //       }
            //       if (((entity.id || rows.length > 0) && !triggerstep.arguments.noRecordExecution) || (!entity.id && rows.length === 0 && triggerstep.arguments.noRecordExecution)) {
            //         filteredPlaybooks.push(playbook);
            //       }
            //     }
            //   });
            return filteredPlaybooks;
        }));
    }
    static { this.ɵfac = function PlaybookService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PlaybookService)(i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(PermissionService), i0.ɵɵinject(CollectionService), i0.ɵɵinject(ExportService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PlaybookService, factory: PlaybookService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PlaybookService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }, { type: PermissionService }, { type: CollectionService }, { type: ExportService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class SpinnerService {
    constructor() {
        this.loading$ = new BehaviorSubject(false);
    }
    watch() {
        return this.loading$.asObservable();
    }
    start() {
        this.loading$.next(true);
    }
    stop() {
        this.loading$.next(false);
    }
    static { this.ɵfac = function SpinnerService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SpinnerService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: SpinnerService, factory: SpinnerService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SpinnerService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class UserService {
    constructor(storageService) {
        this.storageService = storageService;
    }
    getCurrentUser() {
        return this.storageService.getItem(STORAGE_KEYS.CURRENT_USER);
    }
    static { this.ɵfac = function UserService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UserService)(i0.ɵɵinject(StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UserService, factory: UserService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UserService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], () => [{ type: StorageService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class HeaderService {
    constructor() {
        this.header = new BehaviorSubject('show');
    }
    hideHeader() {
        this.header.next('hide');
    }
    static { this.ɵfac = function HeaderService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || HeaderService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: HeaderService, factory: HeaderService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(HeaderService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class AuditService {
    constructor(http, storageService) {
        this.http = http;
        this.storageService = storageService;
    }
    purgeLogs(data) {
        return this.http.delete(`${API.AUDIT}audit-logs/delete/`, { 'body': data });
    }
    getSettingsByName(name) {
        return this.http.get(`${API.AUDIT}settings/?name=${name}`).pipe(map$1((result) => {
            if (!result['hydra:member'].length) {
                throw new Error('No audit purge schedule found');
            }
            return result['hydra:member'][0];
        }));
    }
    updateSettings(setting) {
        return this.http.put(`${API.AUDIT}settings/${setting.uuid}/`, setting).pipe(map$1((result) => {
            return result;
        }));
    }
    getAuditData(uuid) {
        return this.http.get(`${API.AUDIT}${FIXED_MODULE.AUDIT_LOGS}/${uuid}`);
    }
    static { this.ɵfac = function AuditService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AuditService)(i0.ɵɵinject(i1$1.HttpClient), i0.ɵɵinject(StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: AuditService, factory: AuditService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AuditService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }, { type: StorageService }], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class PendingDecisionService {
    constructor() {
        this.http = inject(HttpClient);
    }
    getPendingDecision(manaulInputId, owners, allowUnauthenticated = true, is_approval = false) {
        let unauthenticatedInputClause = '';
        if (!allowUnauthenticated) {
            unauthenticatedInputClause = '&unauthenticated_input=false';
        }
        let payload = {
            ...owners, ...{
                is_approval: is_approval
            }
        };
        return this.http.post(`${API.SEALAB}manual-wf-input/${manaulInputId}/retrieve_wfinput/?${unauthenticatedInputClause}`, payload).pipe(map$1((response) => {
            return response;
        }), catchError$1((error) => {
            if (error.status === 404) {
                return of({});
            }
            if (error.status === 403) {
                //     toaster.error({
                //       body: 'You do not have permission to resume a pending input. Contact your system administrator to add the \'Workflow-execute\' permission to your user role.'
                //     });
            }
            else if (error.status !== 401) {
                // toaster.error({
                //   body: 'Error in opening Pending Input dialog.'
                // });
            }
            return throwError(() => error);
        }));
    }
    resumeAwaitingPlaybook(payload, workflowId) {
        return this.http.post(`${API.SEALAB}workflows/${workflowId}/wfinput_resume/`, payload);
    }
    deleteManualInput(id) {
        return this.http.delete(`${API.WORKFLOW}manual-wf-input/${id}/`);
    }
    static { this.ɵfac = function PendingDecisionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PendingDecisionService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PendingDecisionService, factory: PendingDecisionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PendingDecisionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class Picklist {
    constructor(uuid, itemValue) {
        this.uuid = uuid;
        this.itemValue = itemValue;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class MultiSelectCheckboxDropdownField extends Field {
    static { this.operators = [...Field.equalOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.MULTISELECTCHECKBOXDROPDOWN);
        this.options = [];
        this.showSelectedList = false;
        this.selectText = "Select";
        this.showInline = false;
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = MultiSelectCheckboxDropdownFieldComponent;
        this.viewComponent = MultiSelectCheckboxDropdownViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class RadioField extends Field {
    static { this.operators = [...Field.equalOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.RADIO);
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = RadioFieldComponent;
        this.viewComponent = RadioViewComponent;
    }
}

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class ToggleField extends Field {
    static { this.operators = [...Field.equalOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.TOGGLE);
        this.customText = {};
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = ToggleFieldComponent;
        this.viewComponent = ToggleViewComponent;
    }
}

const _c0$2 = ["formControlName", ""];
function UserMultiselectComponent_div_0_ng_template_2_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 7);
} }
function UserMultiselectComponent_div_0_ng_template_2_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 8);
} }
function UserMultiselectComponent_div_0_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, UserMultiselectComponent_div_0_ng_template_2_span_1_Template, 1, 0, "span", 5)(2, UserMultiselectComponent_div_0_ng_template_2_span_2_Template, 1, 0, "span", 6);
    i0.ɵɵelementStart(3, "label");
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const option_r1 = ctx.option;
    const id_r2 = ctx.id;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r2].type === "team");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r2].type === "user");
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", option_r1, " ");
} }
function UserMultiselectComponent_div_0_ng_template_4_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 7);
} }
function UserMultiselectComponent_div_0_ng_template_4_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 8);
} }
function UserMultiselectComponent_div_0_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, UserMultiselectComponent_div_0_ng_template_4_span_1_Template, 1, 0, "span", 5)(2, UserMultiselectComponent_div_0_ng_template_4_span_2_Template, 1, 0, "span", 6);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r4 = ctx.option;
    const id_r5 = ctx.id;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r5].type === "team");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r5].type === "user");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", option_r4, " ");
} }
function UserMultiselectComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3)(1, "ng-multiselect-dropdown", 4);
    i0.ɵɵtemplate(2, UserMultiselectComponent_div_0_ng_template_2_Template, 5, 3, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor)(4, UserMultiselectComponent_div_0_ng_template_4_Template, 4, 3, "ng-template", null, 1, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r6 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r2.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("placeholder", t_r6("Select users"))("settings", ctx_r2.dropdownSettings)("data", ctx_r2.userTeamList);
} }
class UserMultiselectComponent {
    constructor(http, changeDetectorRef, formBuilder) {
        this.http = http;
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.dropdownSettings = {
            singleSelection: false,
            idField: 'uuid',
            textField: 'display',
            selectAllText: 'Select All',
            unSelectAllText: 'Deselect All',
            allowSearchFilter: true
        };
        this.includeTeams = false;
        this.excludeIris = [];
        this.userTeamList = [];
        this.value = [];
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.formGroup = this.formBuilder.group({
            users: [[]]
        });
    }
    writeValue(value) {
        this.value = value;
        this.formGroup.controls.users.setValue(value);
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnChanges() {
        this.loadUsersAndTeams();
    }
    loadUsersAndTeams() {
        zip(this.loadUsers(), this.loadTeams())
            .subscribe((result) => {
            let userTeamList = flatten(result);
            let filteredList = userTeamList.filter((item) => this.excludeIris.indexOf(item.uuid) === -1);
            this.userTeamList = filteredList;
            this.changeDetectorRef.detectChanges();
        });
    }
    ngOnInit() {
        this.formGroup.controls.users.valueChanges.subscribe((items) => {
            let users = uniq(flatten(items.map((item) => {
                const userOrTeam = this.getItems[item.uuid];
                if (userOrTeam instanceof Person) {
                    return userOrTeam.iri;
                }
                else {
                    return userOrTeam.users;
                }
            })));
            this.onChange(users);
        });
    }
    loadUsers() {
        let body = {
            logic: 'AND',
            filters: [{
                    field: 'csActive',
                    operator: 'eq',
                    value: true
                }],
            __selectFields: ['firstname', 'lastname', 'uuid']
        };
        return this.http.post(API.QUERY + FIXED_MODULE.PEOPLE, body)
            .pipe(map$1((response) => {
            return plainToInstance(Person, response['hydra:member']);
        }));
    }
    loadTeams() {
        if (!this.includeTeams) {
            return of([]);
        }
        let body = {
            logic: 'AND',
            filters: [],
            __selectFields: ['actors', 'name', 'uuid']
        };
        return this.http.post(API.QUERY + FIXED_MODULE.TEAMS, body)
            .pipe(map$1((response) => {
            return plainToInstance(Team, response['hydra:member']);
        }));
    }
    get getItems() {
        return keyBy(this.userTeamList, 'uuid');
    }
    static { this.ɵfac = function UserMultiselectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UserMultiselectComponent)(i0.ɵɵdirectiveInject(i1$1.HttpClient), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: UserMultiselectComponent, selectors: [["xf-user-multiselect", "formControlName", ""]], inputs: { includeTeams: "includeTeams", excludeIris: "excludeIris" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => UserMultiselectComponent),
                    multi: true
                }]), i0.ɵɵNgOnChangesFeature], attrs: _c0$2, decls: 1, vars: 0, consts: [["optionsTemplate", ""], ["optionSelectedTemplate", ""], ["class", "minw-300px", 3, "formGroup", 4, "transloco"], [1, "minw-300px", 3, "formGroup"], ["formControlName", "users", "name", "module-select", 3, "placeholder", "settings", "data"], ["class", "fa fa-users me-1", 4, "ngIf"], ["class", "fa fa-user me-1", 4, "ngIf"], [1, "fa", "fa-users", "me-1"], [1, "fa", "fa-user", "me-1"]], template: function UserMultiselectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, UserMultiselectComponent_div_0_Template, 6, 4, "div", 2);
        } }, dependencies: [i1.NgIf, i5.MultiSelectComponent, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i4.TranslocoDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UserMultiselectComponent, [{
        type: Component,
        args: [{ selector: 'xf-user-multiselect[formControlName]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => UserMultiselectComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"minw-300px\" *transloco=\"let t\" [formGroup]=\"formGroup\">\n  <ng-multiselect-dropdown [placeholder]=\"t('Select users')\" [settings]=\"dropdownSettings\" [data]=\"userTeamList\"\n    formControlName=\"users\" name=\"module-select\">\n    <ng-template #optionsTemplate let-item let-option=\"option\" let-id=\"id\" let-isSelected=\"isSelected\">\n      <div>\n        <span *ngIf=\"getItems[id].type === 'team'\" class=\"fa fa-users me-1\"></span>\n        <span *ngIf=\"getItems[id].type === 'user'\" class=\"fa fa-user me-1\"></span>\n        <label>\n          {{option}}\n        </label>\n      </div>\n    </ng-template>\n    <ng-template #optionSelectedTemplate let-option=\"option\" let-id=\"id\">\n      <div>\n        <span *ngIf=\"getItems[id].type === 'team'\" class=\"fa fa-users me-1\"></span>\n        <span *ngIf=\"getItems[id].type === 'user'\" class=\"fa fa-user me-1\"></span>\n        {{option}}\n      </div>\n    </ng-template>\n  </ng-multiselect-dropdown>\n</div>\n" }]
    }], () => [{ type: i1$1.HttpClient }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { includeTeams: [{
            type: Input
        }], excludeIris: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(UserMultiselectComponent, { className: "UserMultiselectComponent", filePath: "lib/components/user-multiselect/user-multiselect.component.ts", lineNumber: 28 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
class UserMultiselectModule {
    static { this.ɵfac = function UserMultiselectModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UserMultiselectModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: UserMultiselectModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            NgMultiSelectDropDownModule,
            ReactiveFormsModule,
            TranslocoModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UserMultiselectModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    UserMultiselectComponent
                ],
                imports: [
                    CommonModule,
                    NgMultiSelectDropDownModule,
                    ReactiveFormsModule,
                    TranslocoModule
                ],
                exports: [
                    UserMultiselectComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(UserMultiselectModule, { declarations: [UserMultiselectComponent], imports: [CommonModule,
        NgMultiSelectDropDownModule,
        ReactiveFormsModule,
        TranslocoModule], exports: [UserMultiselectComponent] }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
function CronTimePickerComponent_option_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 2);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "number");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const hour_r1 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", hour_r1);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind2(2, 2, hour_r1, "2.0"));
} }
function CronTimePickerComponent_option_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 2);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "number");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const minute_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", minute_r2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind2(2, 2, minute_r2, "2.0"));
} }
function CronTimePickerComponent_option_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 2);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const hourType_r3 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", hourType_r3);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(hourType_r3);
} }
class CronTimePickerComponent {
    constructor() {
        this.change = new EventEmitter();
    }
    ngOnInit() {
        this.hours = this.getRange(1, 12);
        this.minutes = this.getRange(0, 59);
        this.hourTypes = ['AM', 'PM'];
        if (this.time.hourType === 'PM' && this.time.hours > 12) {
            this.time.hours = this.time.hours - 12;
        }
        else if (this.time.hourType === 'AM' && this.time.hours === 0) {
            this.time.hours = 12;
        }
    }
    getRange(startFrom, until) {
        return Array.from({ length: (until + 1 - startFrom) }, (_, k) => k + startFrom);
    }
    static { this.ɵfac = function CronTimePickerComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CronTimePickerComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CronTimePickerComponent, selectors: [["xf-cron-time-picker"]], inputs: { time: "time" }, outputs: { change: "change" }, decls: 6, vars: 6, consts: [[1, "time-input", 3, "change", "ngModelChange", "ngModel"], [3, "ngValue", 4, "ngFor", "ngForOf"], [3, "ngValue"]], template: function CronTimePickerComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "select", 0);
            i0.ɵɵlistener("change", function CronTimePickerComponent_Template_select_change_0_listener() { return ctx.change.emit(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronTimePickerComponent_Template_select_ngModelChange_0_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.time.hours, $event) || (ctx.time.hours = $event); return $event; });
            i0.ɵɵtemplate(1, CronTimePickerComponent_option_1_Template, 3, 5, "option", 1);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(2, "select", 0);
            i0.ɵɵlistener("change", function CronTimePickerComponent_Template_select_change_2_listener() { return ctx.change.emit(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronTimePickerComponent_Template_select_ngModelChange_2_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.time.minutes, $event) || (ctx.time.minutes = $event); return $event; });
            i0.ɵɵtemplate(3, CronTimePickerComponent_option_3_Template, 3, 5, "option", 1);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "select", 0);
            i0.ɵɵlistener("change", function CronTimePickerComponent_Template_select_change_4_listener() { return ctx.change.emit(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronTimePickerComponent_Template_select_ngModelChange_4_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.time.hourType, $event) || (ctx.time.hourType = $event); return $event; });
            i0.ɵɵtemplate(5, CronTimePickerComponent_option_5_Template, 2, 2, "option", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵtwoWayProperty("ngModel", ctx.time.hours);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.hours);
            i0.ɵɵadvance();
            i0.ɵɵtwoWayProperty("ngModel", ctx.time.minutes);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.minutes);
            i0.ɵɵadvance();
            i0.ɵɵtwoWayProperty("ngModel", ctx.time.hourType);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.hourTypes);
        } }, dependencies: [i1.NgForOf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgModel, i1.DecimalPipe], styles: [".time-input[_ngcontent-%COMP%]{margin-left:10px;border:1px solid rgba(0,0,0,.15);background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CronTimePickerComponent, [{
        type: Component,
        args: [{ selector: 'xf-cron-time-picker', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<!-- hour -->\n<select class=\"time-input\" (change)=\"change.emit()\" [(ngModel)]=\"time.hours\">\n  <option *ngFor=\"let hour of hours\" [ngValue]=\"hour\">{{hour | number: '2.0'}}</option>\n</select>\n\n<!-- minute -->\n<select class=\"time-input\" (change)=\"change.emit()\" [(ngModel)]=\"time.minutes\">\n  <option *ngFor=\"let minute of minutes\" [ngValue]=\"minute\">{{minute | number: '2.0'}}</option>\n</select>\n\n<!-- am/pm -->\n<select class=\"time-input\" (change)=\"change.emit()\" [(ngModel)]=\"time.hourType\">\n  <option *ngFor=\"let hourType of hourTypes\" [ngValue]=\"hourType\">{{hourType}}</option>\n</select>\n", styles: [".time-input{margin-left:10px;border:1px solid rgba(0,0,0,.15);background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}\n"] }]
    }], null, { change: [{
            type: Output
        }], time: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CronTimePickerComponent, { className: "CronTimePickerComponent", filePath: "lib/components/cron-editor/cron-time-picker/cron-time-picker.component.ts", lineNumber: 13 }); })();

/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
const _c0$1 = a0 => ({ "error": a0 });
const _c1$1 = a0 => ({ "active-tab": a0 });
const _c2 = a0 => ({ "active": a0 });
function CronEditorComponent_div_24_option_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const minute_r3 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", minute_r3);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", minute_r3, " ");
} }
function CronEditorComponent_div_24_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 40)(1, "span");
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.state.validation.errorMessage);
} }
function CronEditorComponent_div_24_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 12)(1, "div", 13);
    i0.ɵɵtext(2, " Every ");
    i0.ɵɵelementStart(3, "select", 37);
    i0.ɵɵlistener("change", function CronEditorComponent_div_24_Template_select_change_3_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.regenerateCron()); });
    i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_div_24_Template_select_ngModelChange_3_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r1.state.minutes, $event) || (ctx_r1.state.minutes = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵtemplate(4, CronEditorComponent_div_24_option_4_Template, 2, 2, "option", 15);
    i0.ɵɵelementEnd();
    i0.ɵɵtext(5, " minute(s) ");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, CronEditorComponent_div_24_div_6_Template, 3, 1, "div", 38);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(4, _c2, ctx_r1.activeTab === "minutes"));
    i0.ɵɵadvance(3);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.state.minutes);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.selectOptions.minutes);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.state.validation.isValid);
} }
function CronEditorComponent_option_29_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const hour_r4 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", hour_r4);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", hour_r4, " ");
} }
function CronEditorComponent_option_32_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "number");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const minute_r5 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", minute_r5);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", i0.ɵɵpipeBind2(2, 2, minute_r5, "2.0"), " ");
} }
function CronEditorComponent_option_86_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const monthDaysWithLast_r6 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", monthDaysWithLast_r6);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthDayDisplay(monthDaysWithLast_r6), " ");
} }
function CronEditorComponent_option_89_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const month_r7 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", month_r7);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", month_r7, " ");
} }
function CronEditorComponent_option_99_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const month_r8 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", month_r8);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthDisplay(month_r8), " ");
} }
function CronEditorComponent_option_102_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const monthDaysWithLast_r9 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", monthDaysWithLast_r9);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthDayDisplay(monthDaysWithLast_r9), " ");
} }
function CronEditorComponent_option_111_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const monthWeek_r10 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", monthWeek_r10);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthWeekDisplay(monthWeek_r10), " ");
} }
function CronEditorComponent_option_113_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const day_r11 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", day_r11);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.dayDisplay(day_r11), " ");
} }
function CronEditorComponent_option_116_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const month_r12 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", month_r12);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthDisplay(month_r12), " ");
} }
function CronEditorComponent_div_119_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 44)(1, "span");
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.state.validation.errorMessage);
} }
function CronEditorComponent_div_119_Template(rf, ctx) { if (rf & 1) {
    const _r13 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 41);
    i0.ɵɵtext(1, " Cron Expression ");
    i0.ɵɵelementStart(2, "input", 42);
    i0.ɵɵlistener("keyup", function CronEditorComponent_div_119_Template_input_keyup_2_listener() { i0.ɵɵrestoreView(_r13); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.regenerateCron()); });
    i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_div_119_Template_input_ngModelChange_2_listener($event) { i0.ɵɵrestoreView(_r13); const ctx_r1 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r1.state.advanced.expression, $event) || (ctx_r1.state.advanced.expression = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, CronEditorComponent_div_119_div_3_Template, 3, 1, "div", 43);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(3, _c2, ctx_r1.activeTab === "advanced"));
    i0.ɵɵadvance(2);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.state.advanced.expression);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.state.validation.isValid);
} }
const Days = {
    'MON': 1,
    'TUE': 2,
    'WED': 3,
    'THU': 4,
    'FRI': 5,
    'SAT': 6,
    'SUN': 7
};
const DayMap = {
    1: 'MON',
    2: 'TUE',
    3: 'WED',
    4: 'THU',
    5: 'FRI',
    6: 'SAT',
    7: 'SUN'
};
const DisplayDays = {
    'MON': 'Monday',
    'TUE': 'Tuesday',
    'WED': 'Wednesday',
    'THU': 'Thursday',
    'FRI': 'Friday',
    'SAT': 'Saturday',
    'SUN': 'Sunday'
};
const MonthWeeks = {
    1: 'First',
    2: 'Second',
    3: 'Third',
    4: 'Fourth',
    5: 'Fifth'
};
var Months;
(function (Months) {
    Months[Months["January"] = 1] = "January";
    Months[Months["February"] = 2] = "February";
    Months[Months["March"] = 3] = "March";
    Months[Months["April"] = 4] = "April";
    Months[Months["May"] = 5] = "May";
    Months[Months["June"] = 6] = "June";
    Months[Months["July"] = 7] = "July";
    Months[Months["August"] = 8] = "August";
    Months[Months["September"] = 9] = "September";
    Months[Months["October"] = 10] = "October";
    Months[Months["November"] = 11] = "November";
    Months[Months["December"] = 12] = "December";
})(Months || (Months = {}));
class CronEditorComponent {
    constructor(changeDetectorRef, licenseService) {
        this.changeDetectorRef = changeDetectorRef;
        this.licenseService = licenseService;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.selectOptions = {
            months: this.getRange(1, 12),
            monthWeeks: [1, 2, 3, 4, 5],
            days: ['MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT', 'SUN'],
            minutes: this.getRange(0, 59),
            fullMinutes: this.getRange(0, 59),
            hours: this.getRange(1, 23),
            monthDays: this.getRange(1, 31),
            monthDaysWithLasts: [...this.getRange(1, 31).map(String), 'L'],
            hourType: ['AM', 'PM']
        };
        this.defaultHours = 10;
        this.defaultHourType = 'PM';
        this.defaultMinutes = 0;
        this.state = {
            minutes: this.defaultMinutes,
            hourly: {
                hours: this.defaultHours,
                minutes: this.defaultMinutes
            },
            daily: {
                subTab: 'everyDays',
                everyDays: {
                    days: 1,
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHourType
                },
                everyWeekDay: {
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHourType
                }
            },
            weekly: {
                MON: true,
                TUE: false,
                WED: false,
                THU: false,
                FRI: false,
                SAT: false,
                SUN: false,
                hours: this.defaultHours,
                minutes: this.defaultMinutes,
                hourType: this.defaultHourType
            },
            monthly: {
                subTab: 'specificDay',
                runOnWeekday: false,
                specificDay: {
                    day: '1',
                    months: 1,
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHourType
                },
                specificWeekDay: {
                    monthWeek: 1,
                    day: 'MON',
                    startMonth: 1,
                    months: 1,
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHourType
                }
            },
            yearly: {
                subTab: 'specificMonthDay',
                runOnWeekday: false,
                specificMonthDay: {
                    month: 1,
                    day: '1',
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHours
                },
                specificMonthWeek: {
                    monthWeek: 1,
                    day: 'MON',
                    month: 1,
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHours
                }
            },
            advanced: {
                expression: '0 0 * * *'
            },
            validation: {
                isValid: true,
                errorMessage: ''
            },
            formRadioClass: null
        };
        this.regenCallBacks = {
            'minutes': () => this.regenerateMinutes(),
            'hourly': () => this.regenerateHourly(),
            'daily': () => this.regenerateDaily(),
            'weekly': () => this.regenerateWeekly(),
            'monthly': () => this.regenerateMonthly(),
            'yearly': () => this.regenerateYearly()
        };
        this.licenseService.getLicenseDetails().subscribe((result) => {
            this.eventFreq = +result.info.polling_frequency;
        });
    }
    validate(control) {
        if (!this.state.validation.isValid) {
            return {
                error: {
                    message: this.state.validation.errorMessage
                }
            };
        }
        return null;
    }
    writeValue(value) {
        if (value) {
            this.cron = value;
        }
        else {
            this.cron = {
                minute: `*/${this.eventFreq}`,
                hour: '*',
                day_of_month: '*',
                day_of_week: '*',
                month_of_year: '*',
                timezone: ''
            };
        }
        this.setInitCron(this.cron);
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnInit() {
        if (this.cron) {
            this.setInitCron(this.cron);
        }
    }
    setActiveTab(tab) {
        this.activeTab = tab;
        this.regenerateCron();
    }
    setInitCron(cron) {
        const monthlySpecificDayReg = /^\*\/(1[0-2]|[1-9])$/;
        // Minutes
        if (cron.hour === '*' && cron.day_of_month === '*' && cron.month_of_year === '*' && cron.day_of_week === '*') {
            this.activeTab = 'minutes';
            this.state.minutes = +cron.minute.split('/')[1];
            if (this.checkIsAdvanced(this.state.minutes)) {
                this.setAdvancedTab(cron);
            }
        }
        // Hourly
        else if (cron.hour.indexOf('*/') > -1 && cron.day_of_month === '*' && cron.month_of_year === '*' && cron.day_of_week === '*') {
            this.activeTab = 'hourly';
            this.state.hourly.minutes = Number(cron.minute);
            this.state.hourly.hours = +cron.hour.split('/')[1];
            if (this.checkIsAdvanced(this.state.hourly)) {
                this.setAdvancedTab(cron);
            }
        }
        // Daily - everyDays
        else if (cron.month_of_year === '*' && cron.day_of_week === '*') {
            this.activeTab = 'daily';
            this.state.daily.subTab = 'everyDays';
            this.state.daily.everyDays.days = cron.day_of_month === '*' ? 1 : Number(cron.day_of_month.substring(2));
            const parsedHours = Number(cron.hour);
            this.state.daily.everyDays.hours = parsedHours;
            this.state.daily.everyDays.hourType = this.getHourType(parsedHours);
            this.state.daily.everyDays.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.daily)) {
                this.setAdvancedTab(cron);
            }
        }
        // Daily - everyWeekDay
        else if (cron.day_of_month === '*' && cron.month_of_year === '*' && cron.day_of_week === '1-5') {
            this.activeTab = 'daily';
            this.state.daily.subTab = 'everyWeekDay';
            const parsedHours = Number(cron.hour);
            this.state.daily.everyWeekDay.hours = parsedHours;
            this.state.daily.everyWeekDay.hourType = this.getHourType(parsedHours);
            this.state.daily.everyWeekDay.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.daily)) {
                this.setAdvancedTab(cron);
            }
        }
        // Weekly
        else if (cron.day_of_month === '*' && cron.month_of_year === '*' && _.every(cron.day_of_week.split(','), item => _.includes(['1', '2', '3', '4', '5', '6', '7'], item))) {
            this.activeTab = 'weekly';
            this.selectOptions.days.forEach(weekDay => this.state.weekly[weekDay] = false);
            cron.day_of_week.split(',').forEach(weekDay => this.state.weekly[DayMap[weekDay]] = true);
            const parsedHours = Number(cron.hour);
            this.state.weekly.hours = parsedHours;
            this.state.weekly.hourType = this.getHourType(parsedHours);
            this.state.weekly.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.weekly[this.state.weekly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        // Monthly - specificDay
        else if (cron.day_of_week === '*' && monthlySpecificDayReg.test(cron.month_of_year)) {
            // SAME AS BELOW
            this.activeTab = 'monthly';
            this.state.monthly.subTab = 'specificDay';
            if (cron.day_of_month.indexOf('W') !== -1) {
                this.state.monthly.specificDay.day = cron.day_of_month.charAt(0);
                this.state.monthly.runOnWeekday = true;
            }
            else {
                this.state.monthly.specificDay.day = cron.day_of_month;
            }
            this.state.monthly.specificDay.months = Number(cron.month_of_year.substring(2));
            const parsedHours = Number(cron.hour);
            this.state.monthly.specificDay.hours = parsedHours;
            this.state.monthly.specificDay.hourType = this.getHourType(parsedHours);
            this.state.monthly.specificDay.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.monthly[this.state.monthly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        // Monthly - specificWeekDay
        else if (cron.day_of_week === '*' && cron.month_of_year === '1/1' && cron.day_of_month === '*') {
            //SAME AS ABOVE
            this.activeTab = 'monthly';
            this.state.monthly.subTab = 'specificWeekDay';
            const day = cron.day_of_week.substr(0, 3);
            const monthWeek = cron.day_of_week.substr(3);
            this.state.monthly.specificWeekDay.monthWeek = monthWeek;
            this.state.monthly.specificWeekDay.day = day;
            if (cron.month_of_year.indexOf('/') !== -1) {
                const [startMonth, months] = cron.month_of_year.split('/').map(Number);
                this.state.monthly.specificWeekDay.months = months;
                this.state.monthly.specificWeekDay.startMonth = startMonth;
            }
            const parsedHours = Number(cron.hour);
            this.state.monthly.specificWeekDay.hours = parsedHours;
            this.state.monthly.specificWeekDay.hourType = this.getHourType(parsedHours);
            this.state.monthly.specificWeekDay.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.monthly[this.state.monthly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        // Yearly - specificMonthDay
        else if (cron.day_of_week === '*' && cron.month_of_year in this.selectOptions.months) {
            // SAME AS ABOVE
            this.activeTab = 'yearly';
            this.state.yearly.subTab = 'specificMonthDay';
            this.state.yearly.specificMonthDay.month = Number(cron.month_of_year);
            if (cron.month_of_year.indexOf('W') !== -1) {
                this.state.yearly.specificMonthDay.day = cron.day_of_month.charAt(0);
                this.state.yearly.runOnWeekday = true;
            }
            else {
                this.state.yearly.specificMonthDay.day = cron.day_of_month;
            }
            const parsedHours = Number(cron.hour);
            this.state.yearly.specificMonthDay.hours = parsedHours;
            this.state.yearly.specificMonthDay.hourType = this.getHourType(parsedHours);
            this.state.yearly.specificMonthDay.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.yearly[this.state.yearly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        // Yearly - specificMonthWeek
        else if (cron.day_of_month.indexOf('-') > -1) {
            // SAME AS ABOVE
            this.activeTab = 'yearly';
            this.state.yearly.subTab = 'specificMonthWeek';
            // Convert 8-14 to 2
            const monthWeek = (Number(cron.day_of_month.split('-')[0]) + 6) / 7;
            this.state.yearly.specificMonthWeek.monthWeek = monthWeek;
            this.state.yearly.specificMonthWeek.day = cron.day_of_week;
            this.state.yearly.specificMonthWeek.month = Number(cron.month_of_year);
            const parsedHours = Number(cron.hour);
            this.state.yearly.specificMonthWeek.hours = parsedHours;
            this.state.yearly.specificMonthWeek.hourType = this.getHourType(parsedHours);
            this.state.yearly.specificMonthWeek.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.yearly[this.state.yearly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        else {
            this.setAdvancedTab(cron);
        }
        this.regenerateCron(false);
    }
    setAdvancedTab(cron) {
        this.activeTab = 'advanced';
        this.state.advanced.expression = this.cronJsonToString(cron);
    }
    checkIsAdvanced(obj) {
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                const value = obj[key];
                if (typeof value === 'number' && isNaN(value)) {
                    return true;
                }
            }
        }
        return false;
    }
    // Regenerate Cron
    regenerateMinutes() {
        // Keeping the commented code in case of decision to emit expression
        // this.cron = `0/${this.state.minutes.minutes} * 1/1 * ?`;
        this.cron = {
            minute: `*/${this.state.minutes}`,
            hour: '*',
            day_of_month: '*',
            month_of_year: '*',
            day_of_week: '*',
            timezone: ''
        };
    }
    regenerateHourly() {
        // Keeping the commented code in case of decision to emit expression
        // this.cron = `${this.state.hourly.minutes} 0/${this.state.hourly.hours} 1/1 * ?`;
        this.cron = {
            minute: this.state.hourly.minutes,
            hour: `*/${this.state.hourly.hours}`,
            day_of_month: '*',
            month_of_year: '*',
            day_of_week: '*',
            timezone: ''
        };
    }
    regenerateDaily() {
        switch (this.state.daily.subTab) {
            case 'everyDays':
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.daily.everyDays.minutes} ${this.hourToCron(this.state.daily.everyDays.hours, this.state.daily.everyDays.hourType)} 1/${this.state.daily.everyDays.days} * ?`;
                this.cron = {
                    minute: this.state.daily.everyDays.minutes,
                    hour: this.hourToCron(this.state.daily.everyDays.hours, this.state.daily.everyDays.hourType) + '',
                    day_of_month: `*/${this.state.daily.everyDays.days}`,
                    month_of_year: '*',
                    day_of_week: '*',
                    timezone: ''
                };
                break;
            case 'everyWeekDay':
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.daily.everyWeekDay.minutes} ${this.hourToCron(this.state.daily.everyWeekDay.hours, this.state.daily.everyWeekDay.hourType)} ? * MON-FRI`;
                this.cron = {
                    minute: this.state.daily.everyDays.minutes,
                    hour: this.hourToCron(this.state.daily.everyWeekDay.hours, this.state.daily.everyWeekDay.hourType) + '',
                    day_of_month: '*',
                    month_of_year: '*',
                    day_of_week: '1-5',
                    timezone: ''
                };
                break;
            default:
                throw new Error('Invalid cron daily subtab selection');
        }
    }
    regenerateWeekly() {
        // Keeping the commented code in case of decision to emit expression
        // this.cron = `${this.state.weekly.minutes} ${this.hourToCron(this.state.weekly.hours, this.state.weekly.hourType)} ? * ${days}`;
        const days = this.selectOptions.days
            .reduce((acc, day) => this.state.weekly[day] ? acc.concat(Days[day]) : acc, [])
            .join(',');
        this.cron = {
            minute: this.state.weekly.minutes,
            hour: this.hourToCron(this.state.weekly.hours, this.state.weekly.hourType) + '',
            day_of_month: '*',
            month_of_year: '*',
            day_of_week: days,
            timezone: ''
        };
    }
    regenerateMonthly() {
        switch (this.state.monthly.subTab) {
            case 'specificDay':
                const day = this.state.monthly.runOnWeekday ? `${this.state.monthly.specificDay.day}W` : this.state.monthly.specificDay.day;
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.monthly.specificDay.minutes} ${this.hourToCron(this.state.monthly.specificDay.hours, this.state.monthly.specificDay.hourType)} ${day} 1/${this.state.monthly.specificDay.months} ?`;
                this.cron = {
                    minute: this.state.monthly.specificDay.minutes,
                    hour: this.hourToCron(this.state.monthly.specificDay.hours, this.state.monthly.specificDay.hourType) + '',
                    day_of_month: day,
                    month_of_year: `*/${this.state.monthly.specificDay.months}`,
                    day_of_week: '*',
                    timezone: ''
                };
                break;
            case 'specificWeekDay':
                // this.cron = `${this.state.monthly.specificWeekDay.minutes}
                // ${this.hourToCron(this.state.monthly.specificWeekDay.hours, this.state.monthly.specificWeekDay.hourType)}
                // ?
                //${this.state.monthly.specificWeekDay.startMonth}/${this.state.monthly.specificWeekDay.months}
                //${this.state.monthly.specificWeekDay.day}${this.state.monthly.specificWeekDay.monthWeek}`;
                this.cron = {
                    minute: this.state.monthly.specificWeekDay.minutes,
                    hour: this.hourToCron(this.state.monthly.specificWeekDay.hours, this.state.monthly.specificWeekDay.hourType) + '',
                    day_of_month: `${this.state.monthly.specificWeekDay.monthWeek * 7 - 6}-${Math.min(this.state.monthly.specificWeekDay.monthWeek * 7, 31)}`,
                    month_of_year: `${this.state.monthly.specificWeekDay.startMonth}/${this.state.monthly.specificWeekDay.months}`,
                    day_of_week: `${this.state.monthly.specificWeekDay.day}`,
                    timezone: ''
                };
                break;
            default:
                throw new Error('Invalid cron');
        }
    }
    regenerateYearly() {
        switch (this.state.yearly.subTab) {
            case 'specificMonthDay':
                const day = this.state.yearly.runOnWeekday ? `${this.state.yearly.specificMonthDay.day}W` : this.state.yearly.specificMonthDay.day;
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.yearly.specificMonthDay.minutes} ${this.hourToCron(this.state.yearly.specificMonthDay.hours, this.state.yearly.specificMonthDay.hourType)} ${day} ${this.state.yearly.specificMonthDay.month} ?`;
                this.cron = {
                    minute: this.state.yearly.specificMonthDay.minutes,
                    hour: this.hourToCron(this.state.yearly.specificMonthDay.hours, this.state.yearly.specificMonthDay.hourType) + '',
                    day_of_month: day,
                    month_of_year: this.state.yearly.specificMonthDay.month + '',
                    day_of_week: '*',
                    timezone: ''
                };
                break;
            case 'specificMonthWeek':
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.yearly.specificMonthWeek.minutes} ${this.hourToCron(this.state.yearly.specificMonthWeek.hours, this.state.yearly.specificMonthWeek.hourType)} ? ${this.state.yearly.specificMonthWeek.month} ${this.state.yearly.specificMonthWeek.day}${this.state.yearly.specificMonthWeek.monthWeek}`;
                this.cron = {
                    minute: this.state.yearly.specificMonthWeek.minutes,
                    hour: this.hourToCron(this.state.yearly.specificMonthWeek.hours, this.state.yearly.specificMonthWeek.hourType) + '',
                    day_of_month: `${this.state.yearly.specificMonthWeek.monthWeek * 7 - 6}-${Math.min(this.state.yearly.specificMonthWeek.monthWeek * 7, 31)}`,
                    month_of_year: this.state.yearly.specificMonthWeek.month,
                    day_of_week: this.state.yearly.specificMonthWeek.day,
                    timezone: ''
                };
                break;
            default:
                throw new Error('Invalid cron yearly subtab selection');
        }
    }
    regenerateCron(regenerate = true) {
        if (this.activeTab !== 'advanced') {
            if (regenerate) {
                this.regenCallBacks[this.activeTab]();
            }
            this._validate(this.cronJsonToString(this.cron));
            if (this.state.validation.isValid) {
                this.cronDescriber = cronstrue.toString(`${this.cron.minute} ${this.cron.hour} ${this.cron.day_of_month} ${this.cron.month_of_year} ${this.cron.day_of_week}`);
                this.state.advanced.expression = this.cronJsonToString(this.cron);
            }
            this.changeDetectorRef.detectChanges();
        }
        if (this.activeTab === 'advanced') {
            this.onTouched();
            this.cronDescriber = '';
            this._validate(this.state.advanced.expression);
            if (this.state.validation.isValid) {
                this.cronStringToJson(this.state.advanced.expression);
                try {
                    this.cronDescriber = cronstrue.toString(`${this.cron.minute} ${this.cron.hour} ${this.cron.day_of_month} ${this.cron.month_of_year} ${this.cron.day_of_week}`);
                }
                catch (error) {
                    this.state.validation.isValid = false;
                    this.state.validation.errorMessage = error;
                }
            }
            this.changeDetectorRef.detectChanges();
        }
    }
    hourToCron(hour, hourType) {
        return hourType === 'AM' ? (hour === 12 ? 0 : hour) : (hour >= 12 ? hour : hour + 12);
    }
    dayDisplay(day) {
        return DisplayDays[day];
    }
    monthWeekDisplay(monthWeekNumber) {
        return MonthWeeks[monthWeekNumber];
    }
    monthDisplay(month) {
        return Months[month];
    }
    getHourType(hour) {
        return hour >= 12 ? 'PM' : 'AM';
    }
    monthDayDisplay(month) {
        if (month === 'L') {
            return 'Last Day';
        }
        else if (month === 'LW') {
            return 'Last Weekday';
        }
        else if (month === '1W') {
            return 'First Weekday';
        }
        else {
            return `${month}${this.getOrdinalSuffix(month)} day`;
        }
    }
    getOrdinalSuffix(value) {
        if (value.length > 1) {
            const secondToLastDigit = value.charAt(value.length - 2);
            if (secondToLastDigit === '1') {
                return 'th';
            }
        }
        const lastDigit = value.charAt(value.length - 1);
        switch (lastDigit) {
            case '1':
                return 'st';
            case '2':
                return 'nd';
            case '3':
                return 'rd';
            default:
                return 'th';
        }
    }
    cronStringToJson(cronSeven) {
        const [minutes, hours, day_of_month, month_of_year, day_of_week] = cronSeven.split(' ');
        return this.cron = {
            minute: minutes,
            hour: hours,
            day_of_month: day_of_month,
            month_of_year: month_of_year,
            day_of_week: day_of_week,
            timezone: ''
        };
    }
    cronJsonToString(cronJson) {
        return `${cronJson.minute} ${cronJson.hour} ${cronJson.day_of_month} ${cronJson.month_of_year} ${cronJson.day_of_week}`;
    }
    _validate(cron) {
        this.state.validation.isValid = false;
        this.state.validation.errorMessage = '';
        let cronJson = this.cronStringToJson(cron);
        if (!cron) {
            this.state.validation.errorMessage = 'Cron expression cannot be null';
            this.onChange(null);
            return;
        }
        const cronParts = cron.split(' ');
        let expected = 5;
        if (cronParts.length !== expected && this.activeTab === 'advanced') {
            this.state.validation.errorMessage = `Invalid cron expression, there must be ${expected} segments`;
            this.onChange(null);
            return;
        }
        if (cronJson.hour === '*' && cronJson.day_of_month === '*' && cronJson.month_of_year === '*' && cronJson.day_of_week === '*') {
            let minFreq = +cronJson.minute.split('/')[1];
            if (minFreq < this.eventFreq) {
                this.state.validation.errorMessage = `As per your entitlement, the schedule frequency must be greater than ${this.eventFreq} minutes`;
                this.cronDescriber = '';
                this.onChange(null);
                return;
            }
        }
        this.state.validation.isValid = true;
        this.onChange(this.cron);
    }
    getRange(startFrom, until) {
        return Array.from({ length: (until + 1 - startFrom) }, (_, k) => k + startFrom);
    }
    static { this.ɵfac = function CronEditorComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CronEditorComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(LicenseService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CronEditorComponent, selectors: [["xf-cron-editor"]], features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => CronEditorComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => CronEditorComponent),
                    multi: true
                }])], decls: 123, vars: 82, consts: [[1, "cron-editor", 3, "ngClass"], ["role", "tablist", 1, "tabs-container"], [1, "tab", 3, "click", "ngClass"], ["aria-controls", "minutes", "role", "tab", "data-toggle", "tab"], ["aria-controls", "hourly", "role", "tab", "data-toggle", "tab"], ["aria-controls", "daily", "role", "tab", "data-toggle", "tab"], ["aria-controls", "weekly", "role", "tab", "data-toggle", "tab"], ["aria-controls", "monthly", "role", "tab", "data-toggle", "tab"], ["aria-controls", "yearly", "role", "tab", "data-toggle", "tab"], ["aria-controls", "advanced", "role", "tab", "data-toggle", "tab"], [1, "tab-content"], ["class", "tab-pane", 3, "ngClass", 4, "ngIf"], [1, "tab-pane", 3, "ngClass"], [1, "well", "well-small"], [1, "cron-input", 3, "change", "ngModelChange", "ngModel"], [3, "ngValue", 4, "ngFor", "ngForOf"], ["for", "daily-subtab"], ["type", "radio", "name", "daily-radio", "value", "everyDays", "id", "daily-subtab", "checked", "checked", 3, "change", "ngModelChange", "ngModel", "ngClass"], ["type", "number", "min", "1", "max", "31", 1, "form-control", "form-control-sm", "w-auto", "d-inline-block", "mx-1", 3, "change", "ngModelChange", "ngModel"], [3, "change", "time"], [1, "well", "well-small", "mt-3"], ["for", "everyWeekDay"], ["type", "radio", "name", "daily-radio", "value", "everyWeekDay", "id", "everyWeekDay", 3, "change", "ngModelChange", "ngModel", "ngClass"], [1, "row"], [1, "col-sm-3"], [1, "advanced-cron-editor-label"], ["type", "checkbox", 3, "change", "ngModelChange", "ngModel"], [1, "row", "mt-3"], [1, "col-sm-6"], ["for", "specificDay"], ["for", "yearly-specificMonthDay"], ["type", "radio", "name", "yearly-radio", "value", "specificMonthDay", "id", "yearly-specificMonthDay", 3, "change", "ngModelChange", "ngModel", "ngClass"], [1, "well", "well-small", "mt-4"], ["for", "yearly-specificMonthWeek"], ["type", "radio", "name", "yearly-radio", "value", "specificMonthWeek", "id", "yearly-specificMonthWeek", 3, "change", "ngModelChange", "ngModel", "ngClass"], [3, "ngClass", 4, "ngIf"], [1, "evaluated-cron"], [1, "cron-input", "ms-2", 3, "change", "ngModelChange", "ngModel"], ["class", "text-danger mt-2", 4, "ngIf"], [3, "ngValue"], [1, "text-danger", "mt-2"], [3, "ngClass"], ["type", "text", "ng-disabled", "disabled || activeTab !== 'advanced'", 1, "cron-input", "form-control", 3, "keyup", "ngModelChange", "ngModel"], ["class", "text-danger", 4, "ngIf"], [1, "text-danger"]], template: function CronEditorComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "ul", 1)(2, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_2_listener() { return ctx.setActiveTab("minutes"); });
            i0.ɵɵelementStart(3, "a", 3);
            i0.ɵɵtext(4, " Minutes ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_5_listener() { return ctx.setActiveTab("hourly"); });
            i0.ɵɵelementStart(6, "a", 4);
            i0.ɵɵtext(7, " Hourly ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(8, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_8_listener() { return ctx.setActiveTab("daily"); });
            i0.ɵɵelementStart(9, "a", 5);
            i0.ɵɵtext(10, " Daily ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(11, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_11_listener() { return ctx.setActiveTab("weekly"); });
            i0.ɵɵelementStart(12, "a", 6);
            i0.ɵɵtext(13, " Weekly ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(14, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_14_listener() { return ctx.setActiveTab("monthly"); });
            i0.ɵɵelementStart(15, "a", 7);
            i0.ɵɵtext(16, " Monthly ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(17, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_17_listener() { return ctx.setActiveTab("yearly"); });
            i0.ɵɵelementStart(18, "a", 8);
            i0.ɵɵtext(19, " Yearly ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(20, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_20_listener() { return ctx.setActiveTab("advanced"); });
            i0.ɵɵelementStart(21, "a", 9);
            i0.ɵɵtext(22, " Advanced ");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(23, "div", 10);
            i0.ɵɵtemplate(24, CronEditorComponent_div_24_Template, 7, 6, "div", 11);
            i0.ɵɵelementStart(25, "div", 12)(26, "div", 13);
            i0.ɵɵtext(27, " Every ");
            i0.ɵɵelementStart(28, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_28_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_28_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.hourly.hours, $event) || (ctx.state.hourly.hours = $event); return $event; });
            i0.ɵɵtemplate(29, CronEditorComponent_option_29_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(30, " hour(s) on minute ");
            i0.ɵɵelementStart(31, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_31_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_31_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.hourly.minutes, $event) || (ctx.state.hourly.minutes = $event); return $event; });
            i0.ɵɵtemplate(32, CronEditorComponent_option_32_Template, 3, 5, "option", 15);
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(33, "div", 12)(34, "div", 13)(35, "label", 16)(36, "input", 17);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_36_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_36_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.daily.subTab, $event) || (ctx.state.daily.subTab = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(37, " Every ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(38, "input", 18);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_38_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_38_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.daily.everyDays.days, $event) || (ctx.state.daily.everyDays.days = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(39, " day(s) at ");
            i0.ɵɵelementStart(40, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_40_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(41, "div", 20)(42, "label", 21)(43, "input", 22);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_43_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_43_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.daily.subTab, $event) || (ctx.state.daily.subTab = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(44, " Every working day at ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(45, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_45_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(46, "div", 12)(47, "div", 13)(48, "div", 23)(49, "div", 24)(50, "label", 25)(51, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_51_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_51_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.MON, $event) || (ctx.state.weekly.MON = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(52, " Monday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(53, "div", 24)(54, "label", 25)(55, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_55_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_55_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.TUE, $event) || (ctx.state.weekly.TUE = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(56, " Tuesday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(57, "div", 24)(58, "label", 25)(59, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_59_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_59_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.WED, $event) || (ctx.state.weekly.WED = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(60, " Wednesday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(61, "div", 24)(62, "label", 25)(63, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_63_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_63_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.THU, $event) || (ctx.state.weekly.THU = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(64, " Thursday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(65, "div", 24)(66, "label", 25)(67, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_67_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_67_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.FRI, $event) || (ctx.state.weekly.FRI = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(68, " Friday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(69, "div", 24)(70, "label", 25)(71, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_71_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_71_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.SAT, $event) || (ctx.state.weekly.SAT = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(72, " Saturday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(73, "div", 24)(74, "label", 25)(75, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_75_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_75_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.SUN, $event) || (ctx.state.weekly.SUN = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(76, " Sunday");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(77, "div", 27)(78, "div", 28);
            i0.ɵɵtext(79, " at ");
            i0.ɵɵelementStart(80, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_80_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd()()()()();
            i0.ɵɵelementStart(81, "div", 12)(82, "div", 13)(83, "label", 29);
            i0.ɵɵtext(84, " On the ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(85, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_85_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_85_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.monthly.specificDay.day, $event) || (ctx.state.monthly.specificDay.day = $event); return $event; });
            i0.ɵɵtemplate(86, CronEditorComponent_option_86_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(87, " of every ");
            i0.ɵɵelementStart(88, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_88_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_88_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.monthly.specificDay.months, $event) || (ctx.state.monthly.specificDay.months = $event); return $event; });
            i0.ɵɵtemplate(89, CronEditorComponent_option_89_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(90, " month(s) at ");
            i0.ɵɵelementStart(91, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_91_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(92, "\u00A0 ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(93, "div", 12)(94, "div", 13)(95, "label", 30)(96, "input", 31);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_96_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_96_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.subTab, $event) || (ctx.state.yearly.subTab = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(97, " Every ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(98, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_98_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_98_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthDay.month, $event) || (ctx.state.yearly.specificMonthDay.month = $event); return $event; });
            i0.ɵɵtemplate(99, CronEditorComponent_option_99_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(100, " on the ");
            i0.ɵɵelementStart(101, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_101_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_101_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthDay.day, $event) || (ctx.state.yearly.specificMonthDay.day = $event); return $event; });
            i0.ɵɵtemplate(102, CronEditorComponent_option_102_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(103, " at ");
            i0.ɵɵelementStart(104, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_104_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(105, "\u00A0 ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(106, "div", 32)(107, "label", 33)(108, "input", 34);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_108_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_108_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.subTab, $event) || (ctx.state.yearly.subTab = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(109, " On the ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(110, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_110_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_110_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthWeek.monthWeek, $event) || (ctx.state.yearly.specificMonthWeek.monthWeek = $event); return $event; });
            i0.ɵɵtemplate(111, CronEditorComponent_option_111_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(112, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_112_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_112_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthWeek.day, $event) || (ctx.state.yearly.specificMonthWeek.day = $event); return $event; });
            i0.ɵɵtemplate(113, CronEditorComponent_option_113_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(114, " of ");
            i0.ɵɵelementStart(115, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_115_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_115_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthWeek.month, $event) || (ctx.state.yearly.specificMonthWeek.month = $event); return $event; });
            i0.ɵɵtemplate(116, CronEditorComponent_option_116_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(117, " at ");
            i0.ɵɵelementStart(118, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_118_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd()()();
            i0.ɵɵtemplate(119, CronEditorComponent_div_119_Template, 4, 5, "div", 35);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(120, "div")(121, "span", 36);
            i0.ɵɵtext(122);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(56, _c0$1, !ctx.state.validation.isValid));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(58, _c1$1, ctx.activeTab === "minutes"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(60, _c1$1, ctx.activeTab === "hourly"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(62, _c1$1, ctx.activeTab === "daily"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(64, _c1$1, ctx.activeTab === "weekly"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(66, _c1$1, ctx.activeTab === "monthly"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(68, _c1$1, ctx.activeTab === "yearly"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(70, _c1$1, ctx.activeTab === "advanced"));
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("ngIf", ctx.activeTab === "minutes");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(72, _c2, ctx.activeTab === "hourly"));
            i0.ɵɵadvance(3);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.hourly.hours);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.hours);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.hourly.minutes);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.fullMinutes);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(74, _c2, ctx.activeTab === "daily"));
            i0.ɵɵadvance(3);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.daily.subTab);
            i0.ɵɵproperty("ngClass", ctx.state.formRadioClass);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.daily.everyDays.days);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("time", ctx.state.daily.everyDays);
            i0.ɵɵadvance(3);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.daily.subTab);
            i0.ɵɵproperty("ngClass", ctx.state.formRadioClass);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("time", ctx.state.daily.everyWeekDay);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(76, _c2, ctx.activeTab === "weekly"));
            i0.ɵɵadvance(5);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.MON);
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.TUE);
            i0.ɵɵadvan