import { HttpClient } from '@angular/common/http';
import { IServerSideGetRowsParams, IServerSideGetRowsRequest, SortModelItem } from 'ag-grid-community';
import { Observable } from 'rxjs';
import { ApiService, DateService, Entity, EntityService, GetEndPathNamePipe, HydraResponse, Query } from "shared";
import { GridDataSource } from './grid-data-source';
import * as i0 from "@angular/core";
export declare class GridDataSourceService {
    private http;
    private apiService;
    private dateService;
    private getEndPathNamePipe;
    entityService: EntityService;
    constructor(http: HttpClient, apiService: ApiService, dateService: DateService, getEndPathNamePipe: GetEndPathNamePipe);
    getDataSource(entity: Entity, baseQuery?: Query, dataInterceptor?: Function, alwaysIncludeColList?: string[], treeFilterField?: string): GridDataSource;
    loadLookupData(rows: any[], entity: Entity): any[];
    getDatasourceByParams(entity: Entity, queryParams: any): {
        getRows: (params: IServerSideGetRowsParams<any, any>) => void;
        selectedRows: never[];
        destroy: () => void;
        entity: Entity;
    };
    getDatasourceByCustomRequest(request: {
        url: string;
        type: "GET" | "POST";
        body?: any;
    } | undefined, queryParams: any, entity: Entity, dataInterceptor?: Function): {
        getRows: (params: IServerSideGetRowsParams<any, any>) => void;
        selectedRows: never[];
        destroy: () => void;
        entity: Entity;
    };
    loadRows(entity: Entity, request: IServerSideGetRowsRequest, baseQuery?: Query, availableFieldNames?: string[]): Observable<HydraResponse>;
    convertAgGridQueryToQueryApi(filterModel: any, sortModel: SortModelItem[], groupKeys: string[]): Query;
    static ɵfac: i0.ɵɵFactoryDeclaration<GridDataSourceService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<GridDataSourceService>;
}
