import { ColDef, DataTypeDefinition, GridApi, RowModelType } from "ag-grid-community";
import { Observable } from "rxjs";
import { Button } from "shared";
import { GridColumn } from "../../services/grid-column.service";
export interface XFGridOptions {
    loadDefaultFilter?: boolean;
    loadAllFilters?: boolean;
    defaultFilter?: any;
    columnsJSON?: string | GridColumn[];
    onView?: (param: any) => any;
    onAdd?: () => any;
    onRegisterApi?: (params: GridApi) => any;
    allowAdd?: boolean;
    addText?: string;
    skipRowId?: boolean;
    allowLink?: boolean;
    allowUnlink?: boolean;
    allowDelete?: boolean;
    allowClone?: boolean;
    allowGlobalFilter?: boolean;
    allowModuleFilter?: boolean;
    customRecordTypeFilter?: boolean;
    allowDateFilter?: boolean;
    allowUserFilter?: boolean;
    allowGridFilter?: boolean;
    allowCardView?: boolean;
    auditLogView?: boolean;
    viewType?: string;
    allowActions?: boolean;
    allowPlaybookActions?: boolean;
    showPagination?: boolean;
    searchPlaceholder?: string;
    enableSearch?: boolean;
    cloneRelationshipsByDefault?: boolean;
    clone?: boolean;
    isRelationship?: boolean;
    searchMinLength?: number;
    enableSelectMenu?: boolean;
    hideCheckboxes?: boolean;
    selectOnClick?: boolean;
    enableCellTextSelection?: boolean;
    enableSavedFilters?: boolean;
    wideSearchBar?: boolean;
    unlinkButtonText?: string;
    isFullScreenMode?: boolean;
    bulkButtons?: Button[];
    buttons?: Button[];
    selectButtons?: Button[];
    detailCellRenderer?: any;
    detailRowHeight?: number;
    expandable?: boolean;
    customGridHeaderComponent?: any;
    customGridHeaderData$?: Observable<any>;
    customColumnTypes?: Record<string, ColDef>;
    customDataTypeDefinitions?: Record<string, DataTypeDefinition>;
    adjustGridRowHeight?: boolean;
    rowModelType?: RowModelType;
    rowData?: Array<any>;
    treeData?: boolean;
    isServerSideGroup?: (dataItem: any) => boolean;
    getServerSideGroupKey?: (dataItem: any) => string;
    autoGroupColumnDef?: ColDef;
}
