import { HttpClient } from '@angular/common/http';
import { ChangeDetectorRef } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { NgbOffcanvas, NgbOffcanvasRef } from '@ng-bootstrap/ng-bootstrap';
import { Observable } from 'rxjs';
import { Entity, EntityService, PicklistName, ThemeService } from "shared";
import { AbstractWidgetComponent } from 'shared/view-templates';
import { GridConfig } from '../grid-config';
import { GridDataSourceService } from '../../../services/grid-data-source.service';
import { GridDataSource } from '../../../services/grid-data-source';
import { ViewTemplateContext } from 'shared/view-templates';
import * as i0 from "@angular/core";
export declare class GridViewComponent extends AbstractWidgetComponent {
    private http;
    private offcanvasService;
    themeService: ThemeService;
    _changeDetectorRef: ChangeDetectorRef;
    private entityService;
    private router;
    private route;
    private gridDataSourceService;
    title: string | undefined;
    entity?: Entity;
    gridConfig: GridConfig;
    offcanvasInstance?: NgbOffcanvasRef;
    dataSource: GridDataSource;
    constructor(http: HttpClient, offcanvasService: NgbOffcanvas, themeService: ThemeService, _changeDetectorRef: ChangeDetectorRef, entityService: EntityService, router: Router, route: ActivatedRoute, gridDataSourceService: GridDataSourceService);
    ngOnInit(): void;
    widgetConfigChanged(widgetConfig: GridConfig): void;
    openRecord(event: any): void;
    loadDatasource(): void;
    addModule(): void;
    loadPicklistNames(picklistName: string): Observable<PicklistName>;
    contextChanged(context: ViewTemplateContext): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<GridViewComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<GridViewComponent, "xf-grid-view", never, {}, {}, never, never, false, never>;
}
