import { DataSource } from "./data-source";
import { ModelMetadata } from "./model-metadata";
export type AppManifest = {
    remoteEntry: string;
    exposedModule: string;
    name: string;
    routes?: {
        [page: string]: AppRoute[];
    };
    models?: ModelMetadata[];
    views: {
        navigation: any[];
        settings: any[];
        portingConfigs: {
            label: string;
            name: string;
            exportFilterComponent: string;
            importFilterComponent: string;
            countLabel: string;
            dataSource: DataSource;
            service?: string;
            permissions: string[];
        }[];
    };
};
export type AppRoute = {
    path: string;
    exposedModule: string;
    remoteEntry?: string;
    parentPath?: string;
    title?: string;
    breadcrumb?: any;
    roles?: any;
    permissions?: string[];
    moduleName?: string;
};
