import { Field } from "./field";
export declare class ConnectorFieldRendererParameter {
    name: string;
    formType: Field.BuiltInType | string;
    title: string;
    description: string;
    tooltip: string;
    apiOperation: string;
    visible: boolean;
    editable: boolean;
    required: boolean;
    placeholder: string;
    dataSource?: {
        model: string;
        query: any;
        baseURL?: string;
        requestType?: 'GET' | 'POST';
    };
    value: any;
    params: any;
    renderer_type?: string;
    options: {
        label: string;
        value: string;
    }[];
    onchange: {
        [name: string]: ConnectorFieldRendererParameter[];
    };
    constructor(name: string, type: string, renderer_type?: string);
}
export declare class ConnectorActionRendererField extends ConnectorFieldRendererParameter {
    field: Field;
    _jinjaEnabled?: boolean;
    parameters: ConnectorFieldRendererParameter[];
}
