import { Type } from "@angular/core";
import { Subject } from "rxjs";
import { PagedCollectionService } from "../services/paged-collection.service";
import { Entity } from "./entity";
import { Query } from "../../query-filters/models/query";
export declare class PagedCollection {
    module: string;
    entity: Entity;
    currentPageNumber?: number;
    data: any[];
    totalItems?: number;
    itemsPerPage?: number;
    totalPages?: number;
    firstPageUrl?: string;
    lastPageUrl?: string;
    nextPageUrl?: string;
    previousPageUrl?: string;
    gotoPageUrl?: string;
    currentPageUrl?: string;
    query: Query;
    relatedField?: string;
    relatedUuid?: string;
    service: Type<PagedCollectionService>;
    subject?: Subject<any>;
    urlRequestType: 'post' | 'get';
    type: 'base' | 'actor' | 'django';
    constructor(module: string, entity?: Entity, relatedField?: string, relatedUuid?: string);
    getURLData(query: Query): {
        requestType: "get" | "post";
        url: string;
        payload: any;
        queryParams: any;
    };
    setPage(data: any, query: Query): void;
    pageFirst(): void;
    pageLast(): void;
    pageNext(): void;
    pagePrevious(): void;
    recordPerPageChange(): void;
    gotoPage(page: number): void;
}
