import { EventEmitter, Type } from "@angular/core";
import { Observable } from "rxjs";
import { AbstractWizardStepComponent } from "../../components/wizard/abstract-wizard-step.component";
export declare class Wizard {
    title: string;
    steps: WizardStep[];
    currentStepIndex: number;
    data: any;
    close: (buttonName?: string) => void;
    next: () => Observable<void>;
    back: () => void;
    wizardChanged$: EventEmitter<void>;
    constructor(title: string, steps: WizardStep[], currentStepIndex: number, data: any);
    get currentStep(): WizardStep;
}
export declare class WizardStep {
    title: string;
    buttons: WizardButton[];
    component: Type<AbstractWizardStepComponent>;
    visible?: boolean | undefined;
    disabled?: boolean | undefined;
    isComplete?: boolean;
    constructor(title: string, buttons: WizardButton[], component: Type<AbstractWizardStepComponent>, visible?: boolean | undefined, disabled?: boolean | undefined);
}
export declare class WizardButton {
    text: string;
    action: 'next' | 'back' | 'close' | 'submit' | 'skip';
    pullRight?: boolean;
    name?: string;
    icon?: string;
    disabled?: boolean | undefined;
    hidden?: boolean | undefined;
    disabledText?: string;
    disabledIcon?: string;
    type?: string | undefined;
    iconPosition?: string;
    constructor(text: string, action: 'next' | 'back' | 'close' | 'submit' | 'skip');
}
