import { AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, OnInit } from '@angular/core';
import { AbstractControl, ControlValueAccessor, FormBuilder, FormGroup, ValidationErrors, Validator } from '@angular/forms';
import { Field } from '../../../core/models/field';
import { FieldOptions } from '../../models/field-options';
import { FieldService } from '../../../core/services/field.service';
import * as i0 from "@angular/core";
export declare abstract class AbstractFieldComponent implements ControlValueAccessor, OnInit, Validator, AfterViewInit {
    changeDetectorRef: ChangeDetectorRef;
    formBuilder: FormBuilder;
    field: Field;
    fieldOptions: FieldOptions;
    fieldClass?: string;
    autoFocus: boolean;
    jinjaToggled: EventEmitter<boolean>;
    onSubmit: EventEmitter<void>;
    control?: AbstractControl;
    params: any;
    _value: any;
    inputField?: ElementRef;
    onChange: (_: any) => void;
    onTouched: () => void;
    fieldGroup?: FormGroup;
    isDisabled: boolean;
    fieldService: FieldService;
    constructor(changeDetectorRef: ChangeDetectorRef, formBuilder: FormBuilder);
    ngAfterViewInit(): void;
    ngOnInit(): void;
    setDisabledState(isDisabled: boolean): void;
    get value(): any;
    set value(value: any);
    writeValue(value: any): void;
    registerOnChange(fn: (value: string) => void): void;
    registerOnTouched(fn: () => void): void;
    onBlur(): void;
    onFocus(): void;
    validate(control: AbstractControl): ValidationErrors | null;
    get valid(): boolean;
    focus(): void;
    ngDoCheck(): void;
    toggleJinja(jinjaEnabled: boolean): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<AbstractFieldComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<AbstractFieldComponent, "xf-abstract-field", never, { "field": { "alias": "field"; "required": false; }; "fieldOptions": { "alias": "fieldOptions"; "required": false; }; "fieldClass": { "alias": "fieldClass"; "required": false; }; "autoFocus": { "alias": "autoFocus"; "required": false; }; }, { "jinjaToggled": "jinjaToggled"; "onSubmit": "onSubmit"; }, never, never, false, never>;
}
