import { ChangeDetectorRef, QueryList } from '@angular/core';
import { AbstractControl, ControlValueAccessor, FormArray, FormBuilder, FormGroup, ValidationErrors, Validator } from '@angular/forms';
import { Entity } from '../../core/models/entity';
import { Filter } from '../models/filter';
import { FilterGroup } from '../models/filter-group';
import { FilterComponent } from '../filter/filter.component';
import * as i0 from "@angular/core";
export declare class FilterGroupComponent implements ControlValueAccessor, Validator {
    private changeDetectorRef;
    private formBuilder;
    filterComponents: QueryList<FilterComponent | FilterGroupComponent>;
    value?: FilterGroup;
    entity: Entity;
    depth: number;
    FilterGroup: typeof FilterGroup;
    Filter: typeof Filter;
    onChange: (_: any) => void;
    onTouched: () => void;
    filtersFormArray: FormArray;
    formGroup: FormGroup;
    constructor(changeDetectorRef: ChangeDetectorRef, formBuilder: FormBuilder);
    writeValue(value: FilterGroup): void;
    registerOnChange(fn: (value: string) => void): void;
    registerOnTouched(fn: () => void): void;
    addFilter(group?: boolean): void;
    validate(control: AbstractControl): ValidationErrors | null;
    focusOnFirstInvalidInput(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<FilterGroupComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<FilterGroupComponent, "xf-filter-group[entity]", never, { "entity": { "alias": "entity"; "required": false; }; "depth": { "alias": "depth"; "required": false; }; }, {}, never, never, false, never>;
}
