import { ChangeDetectorRef, EventEmitter } from '@angular/core';
import { Observable, Subscription } from 'rxjs';
import { PortingConfig } from '../porting-config';
import { ExportConfigService } from './export-config.service';
import { ExportOption } from './models/export-option';
import { Wizard } from 'shared';
import * as i0 from "@angular/core";
export declare abstract class AbstractExportFilterComponent {
    protected exportService: ExportConfigService;
    protected changeDetectorRef: ChangeDetectorRef;
    wizard: Wizard;
    includeAll$: Observable<boolean>;
    dataChange: EventEmitter<void>;
    subscription?: Subscription;
    config?: PortingConfig;
    checkAlls: Record<string, boolean>;
    options: ExportOption[];
    configKey: string;
    serviceKey: string;
    constructor(exportService: ExportConfigService, changeDetectorRef: ChangeDetectorRef);
    ngOnInit(): void;
    ngOnDestroy(): void;
    checkAllChanged(key?: 'include'): void;
    onOptionsChange(): void;
    buttonClicked(option: ExportOption, key?: 'include'): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<AbstractExportFilterComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<AbstractExportFilterComponent, "xf-abstract-section-config", never, { "wizard": { "alias": "wizard"; "required": false; }; "includeAll$": { "alias": "includeAll$"; "required": false; }; }, { "dataChange": "dataChange"; }, never, never, false, never>;
}
