import { XFFile } from 'shared';
export declare class ImportJob {
    file: XFFile | string | null;
    fileName?: string;
    status: string | null;
    errorMessage: string | null;
    logMessages: {
        date: number;
        message: string;
    }[];
    progressPercent: number;
    currentlyImporting: string | null;
    options: {
        [section: string]: {
            [configType: string]: ImportJobOption[];
        };
    };
    type: string;
    solutionPack: string | null;
    uuid: string | null;
    constructor();
    get iri(): string;
}
export interface ImportJobOption {
    label: string;
    include: boolean;
    exists: boolean;
    value: string;
    [additionalKey: string]: any;
}
