import { ChangeDetectorRef, OnInit, QueryList } from "@angular/core";
import { FormBuilder, FormGroup } from "@angular/forms";
import { ActivatedRoute, Router } from "@angular/router";
import { NgbOffcanvas, NgbOffcanvasRef } from "@ng-bootstrap/ng-bootstrap";
import { Button, FormFieldComponent, ModalService, SpinnerService } from "shared";
import { UniqueValidatorService } from "./unique.validator";
import { ViewTemplateService } from "./view-template/view-template.service";
import { ViewTemplate } from "./models/view-template";
import * as i0 from "@angular/core";
export declare abstract class AbstractViewTemplateComponent implements OnInit {
    protected offcanvasService: NgbOffcanvas;
    protected router: Router;
    protected viewTemplateService: ViewTemplateService;
    protected route: ActivatedRoute;
    protected changeDetectorRef: ChangeDetectorRef;
    protected spinnerService: SpinnerService;
    protected modalService: ModalService;
    viewTemplate: ViewTemplate | null;
    viewTemplates: ViewTemplate[];
    offcanvasInstance?: NgbOffcanvasRef;
    types: typeof ViewTemplate.Types;
    formGroup: FormGroup;
    mode: string | null;
    uuid: string | null;
    loading: boolean;
    currentModule?: string | null | undefined;
    viewTemplateType: ViewTemplate.Types;
    loadMultipleViews: boolean;
    uniqueValidatorService: UniqueValidatorService;
    formFields: QueryList<FormFieldComponent>;
    headerButtons: Button[];
    constructor(offcanvasService: NgbOffcanvas, router: Router, viewTemplateService: ViewTemplateService, route: ActivatedRoute, changeDetectorRef: ChangeDetectorRef, spinnerService: SpinnerService, modalService: ModalService, formBuilder: FormBuilder);
    ngOnInit(): void;
    onSaveTemplate(): void;
    onDuplicateTemplate(): import("rxjs").Subscription | undefined;
    onDeleteTemplate(): void;
    onCancel(): void;
    onEditTemplate(): void;
    updateViews(mode?: string, viewTemplate?: ViewTemplate): void;
    _updateOnNew(viewTemplate: ViewTemplate): void;
    loadViews(): import("rxjs").Observable<void>;
    loadView(): import("rxjs").Observable<void>;
    navigate(): void;
    updateHeaderButtons(): void;
    abstract newViewTemplate(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<AbstractViewTemplateComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<AbstractViewTemplateComponent, "xf-abstract-view-template", never, {}, {}, never, never, false, never>;
}
