/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { WidgetConfig } from "shared/view-templates";
import { GridColumn } from "../../services/grid-column.service";
import { GridEditComponent } from "./grid-edit/grid-edit.component";
import { GridViewComponent } from "./grid-view/grid-view.component";
export class GridConfig extends WidgetConfig {
    constructor(title, configuration, options) {
        if (configuration && configuration.columns && configuration.columns[0] && typeof configuration.columns[0] === 'string') {
            let columns = [];
            let stringColumns = configuration.columns;
            stringColumns.forEach((columnName) => {
                columns.push(new GridColumn({ name: columnName }));
            });
            configuration.columns = columns;
        }
        super(title, configuration);
        this.title = title;
        this.options = options;
        this.type = 'grid';
        this._count = 0;
        this.configuration = configuration;
        this.viewComponent = GridViewComponent;
        this.editComponent = GridEditComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,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