import { ChangeDetectionStrategy, Component } from '@angular/core';
import { map } from 'rxjs/operators';
import { API, AddRecordComponent } from "shared";
import { AbstractWidgetComponent } from 'shared/view-templates';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "@ng-bootstrap/ng-bootstrap";
import * as i3 from "shared";
import * as i4 from "@angular/router";
import * as i5 from "../../../services/grid-data-source.service";
function GridViewComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 1);
    i0.ɵɵelement(2, "xf-grid", 2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("dataSource", ctx_r0.dataSource)("gridConfig", ctx_r0.gridConfig);
} }
export class GridViewComponent extends AbstractWidgetComponent {
    constructor(http, offcanvasService, themeService, _changeDetectorRef, entityService, router, route, gridDataSourceService) {
        super(_changeDetectorRef);
        this.http = http;
        this.offcanvasService = offcanvasService;
        this.themeService = themeService;
        this._changeDetectorRef = _changeDetectorRef;
        this.entityService = entityService;
        this.router = router;
        this.route = route;
        this.gridDataSourceService = gridDataSourceService;
    }
    ngOnInit() {
        super.ngOnInit();
    }
    widgetConfigChanged(widgetConfig) {
        this.gridConfig = widgetConfig;
        this.title = widgetConfig.title;
        this.changeDetectorRef.detectChanges();
    }
    openRecord(event) {
        const module = event.data['@id'].split('/')[3];
        const onClickState = this.gridConfig.configuration.onClickState || 'module';
        if (onClickState === 'preview') {
            this.router.navigate(['.'], {
                relativeTo: this.route,
                queryParams: {
                    preview: true,
                    recordId: event.data.uuid
                },
                queryParamsHandling: 'merge'
            });
        }
        else {
            this.router.navigate([onClickState, module, 'detail'], {
                queryParams: {
                    recordId: event.data.uuid
                }
            });
        }
    }
    loadDatasource() {
        this.gridConfig.options = this.gridConfig.options || {};
        this.gridConfig.options.onView = (_event) => this.openRecord(_event);
        this.gridConfig.options.addText = 'Add';
        this.entityService.build(this.gridConfig.configuration.module).subscribe((entity) => {
            if (!this.context || !this.gridConfig) {
                return;
            }
            this.entity = entity;
            let relatedField;
            let relatedUuid;
            let primaryModule = this.gridConfig.configuration.module;
            if (this.gridConfig.configuration.onlyRelated && this.context.module && this.context.uuid) {
                relatedField = this.gridConfig.configuration.module;
                relatedUuid = this.context.uuid;
                primaryModule = this.context.module;
            }
            // TODO: Implement related records grid
            this.dataSource = this.gridDataSourceService.getDataSource(this.entity);
            // this.pagedCollection = new PagedCollection(primaryModule, this.entity, relatedField, relatedUuid);
            this.changeDetectorRef.detectChanges();
        });
    }
    addModule() {
        if (this.offcanvasInstance) {
            this.offcanvasInstance.close();
        }
        this.offcanvasInstance = this.offcanvasService.open(AddRecordComponent, {
            position: 'end',
            container: '.content'
        });
    }
    loadPicklistNames(picklistName) {
        return this.http
            .get(API.API_3_BASE + 'picklist_names', {
            params: {
                name: picklistName
            }
        })
            .pipe(map(response => response['hydra:member'][0]));
    }
    contextChanged(context) {
        this.context = context;
        this.loadDatasource();
    }
    static { this.ɵfac = function GridViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridViewComponent)(i0.ɵɵdirectiveInject(i1.HttpClient), i0.ɵɵdirectiveInject(i2.NgbOffcanvas), i0.ɵɵdirectiveInject(i3.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.EntityService), i0.ɵɵdirectiveInject(i4.Router), i0.ɵɵdirectiveInject(i4.ActivatedRoute), i0.ɵɵdirectiveInject(i5.GridDataSourceService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridViewComponent, selectors: [["xf-grid-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [[4, "ngIf"], [1, "m-2", "ms-0"], [3, "dataSource", "gridConfig"]], template: function GridViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, GridViewComponent_div_0_Template, 3, 2, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.dataSource);
        } }, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *ngIf=\"dataSource\">\n  <div class=\"m-2 ms-0\">\n    <!-- <button class=\"btn btn-primary btn-sm\" (click)=\"addModule()\">Add {{ entity?.descriptions?.singular }}</button> -->\n    <xf-grid [dataSource]=\"dataSource\" [gridConfig]=\"gridConfig\"></xf-grid>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1.HttpClient }, { type: i2.NgbOffcanvas }, { type: i3.ThemeService }, { type: i0.ChangeDetectorRef }, { type: i3.EntityService }, { type: i4.Router }, { type: i4.ActivatedRoute }, { type: i5.GridDataSourceService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridViewComponent, { className: "GridViewComponent", filePath: "src/widgets/grid-widget/grid-view/grid-view.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,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