import { Injectable } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import { isArray } from 'lodash-es';
import { throwError } from 'rxjs';
import { catchError, concatMap, map, toArray } from 'rxjs/operators';
import { VIEW_TEMPLATES } from "shared";
import { GridColumn } from '../../services/grid-column.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common/http";
export class GridService {
    constructor(filterCollectionService, http) {
        this.filterCollectionService = filterCollectionService;
        this.http = http;
    }
    loadUserPreferenceColumns() {
        return this.http.get(`${VIEW_TEMPLATES.VIEW_API_BASE}${VIEW_TEMPLATES.GRID_COLUMNS}`).pipe(map((result) => {
            result.config = isArray(result.config) ? {} : result.config;
            return result;
        }, catchError((error) => {
            return throwError(error);
        })));
    }
    saveUserPreferences(page, template) {
        return this.http.post(`${VIEW_TEMPLATES.VIEW_API_BASE}${VIEW_TEMPLATES.GRID_COLUMNS}`, template).pipe(map((result) => {
            return result;
        }));
    }
    loadColumnsJson(jsonURL) {
        return this.http.get(jsonURL).pipe(concatMap((response) => response.data.columns), map((column) => {
            return plainToInstance(GridColumn, column);
        }), toArray());
    }
    static { this.ɵfac = function GridService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridService)(i0.ɵɵinject(i1.FilterCollectionService), i0.ɵɵinject(i2.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GridService, factory: GridService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.FilterCollectionService }, { type: i2.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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