/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
const _c0 = a0 => ({ "disabled": a0 });
function PaginationComponent_option_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 16);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const pageSize_r2 = ctx.$implicit;
    i0.ɵɵproperty("value", pageSize_r2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(pageSize_r2);
} }
const FILTER_PAG_REGEX = /[^0-9]/g;
export class PaginationComponent {
    set totalItems(value) {
        this._totalItems = value;
        this.calculatePaginationSize();
    }
    get totalItems() {
        return this._totalItems;
    }
    constructor() {
        //@Input() totalRecords: number = 0;
        this.itemsPerPage = 30;
        this.paginationSize = [5, 10, 30, 50, 100, 250];
        this.pageChanged = new EventEmitter();
        this.page = 1;
        this.noOfPages = 1;
        this._totalItems = 0;
    }
    ngOnInit() {
    }
    calculatePaginationSize() {
        this.noOfPages = Math.ceil(this._totalItems / this.itemsPerPage);
    }
    selectPage(page) {
        let _pageChange = parseInt(page) || 1;
        this.gotoPage(_pageChange, paginationEventType.directPage);
    }
    gotoPage(page, eventType) {
        if (page > this.noOfPages) {
            page = this.noOfPages;
        }
        else if (page < 0) {
            page = 1;
        }
        this.page = page;
        this.fireEvent(eventType);
    }
    formatInput(input) {
        input.value = input.value.replace(FILTER_PAG_REGEX, '');
    }
    recordsSizeChanged() {
        this.page = 1;
        this.calculatePaginationSize();
        this.fireEvent(paginationEventType.recordsPerPageChange);
    }
    fireEvent(eventType) {
        this.pageChanged.emit({
            currentPage: this.page,
            itemsPerPage: this.itemsPerPage,
            eventType: eventType
        });
    }
    firstPage() {
        this.gotoPage(1, paginationEventType.pageFirst);
    }
    previousPage() {
        this.gotoPage(this.page - 1, paginationEventType.pagePrevious);
    }
    nextPage() {
        this.gotoPage(this.page + 1, paginationEventType.pageNext);
    }
    lastPage() {
        this.gotoPage(this.noOfPages, paginationEventType.pageLast);
    }
    static { this.ɵfac = function PaginationComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PaginationComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PaginationComponent, selectors: [["xf-pagination"]], inputs: { itemsPerPage: "itemsPerPage", paginationSize: "paginationSize", totalItems: "totalItems" }, outputs: { pageChanged: "pageChanged" }, decls: 20, vars: 16, consts: [["pageInput", ""], [1, "pagination-wrapper", "d-flex", "justify-content-end"], [1, "align-items-center", "d-flex", "me-4"], ["for", "itemsPerPageDD", 1, "me-2", "ps-2", "content-font"], ["id", "itemsPerPageDD", "name", "itemsPerPageDD", 1, "form-select", "form-select-xs", "text-center", "w-auto", 3, "ngModelChange", "change", "ngModel"], [3, "value", 4, "ngFor", "ngForOf"], [1, "align-items-center", "d-flex"], [1, "btn", "btn-xs", "btn-secondary", 3, "click", "ngClass"], [1, "fa-light", "fa", "fa-chevron-double-left", "content-font"], [1, "btn", "btn-xs", "mx-1", "btn-secondary", 3, "click", "ngClass"], [1, "fa-light", "fa", "fa-chevron-left", "content-font"], ["type", "text", "pattern", "[0-9]*", "id", "paginationInput", "aria-labelledby", "paginationInputLabel paginationDescription", 1, "form-control", "form-control-xs", "mx-2", "text-center", 2, "width", "3.5rem", 3, "keyup.enter", "blur", "input", "value"], [1, "me-2", "content-font"], [1, "fa-light", "fa", "fa-chevron-right", "content-font"], [1, "fa-light", "fa", "fa-chevron-double-right", "content-font"], [1, "clearfix"], [3, "value"]], template: function PaginationComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2)(2, "label", 3);
            i0.ɵɵtext(3, "Items Per Page");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "select", 4);
            i0.ɵɵtwoWayListener("ngModelChange", function PaginationComponent_Template_select_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r1); i0.ɵɵtwoWayBindingSet(ctx.itemsPerPage, $event) || (ctx.itemsPerPage = $event); return i0.ɵɵresetView($event); });
            i0.ɵɵlistener("change", function PaginationComponent_Template_select_change_4_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.recordsSizeChanged()); });
            i0.ɵɵtemplate(5, PaginationComponent_option_5_Template, 2, 2, "option", 5);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 6)(7, "button", 7);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_7_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.firstPage()); });
            i0.ɵɵelement(8, "i", 8);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(9, "button", 9);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_9_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.previousPage()); });
            i0.ɵɵelement(10, "i", 10);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(11, "input", 11, 0);
            i0.ɵɵlistener("keyup.enter", function PaginationComponent_Template_input_keyup_enter_11_listener() { i0.ɵɵrestoreView(_r1); const pageInput_r3 = i0.ɵɵreference(12); return i0.ɵɵresetView(ctx.selectPage(pageInput_r3.value)); })("blur", function PaginationComponent_Template_input_blur_11_listener() { i0.ɵɵrestoreView(_r1); const pageInput_r3 = i0.ɵɵreference(12); return i0.ɵɵresetView(ctx.selectPage(pageInput_r3.value)); })("input", function PaginationComponent_Template_input_input_11_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.formatInput($event.target)); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(13, "label", 12);
            i0.ɵɵtext(14);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(15, "button", 9);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.nextPage()); });
            i0.ɵɵelement(16, "i", 13);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(17, "button", 7);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_17_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.lastPage()); });
            i0.ɵɵelement(18, "i", 14);
            i0.ɵɵelementEnd()();
            i0.ɵɵelement(19, "div", 15);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.itemsPerPage);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.paginationSize);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(8, _c0, ctx.page === 1));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(10, _c0, ctx.page === 1));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("value", ctx.page);
            i0.ɵɵadvance(3);
            i0.ɵɵtextInterpolate1(" of ", ctx.noOfPages, "");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(12, _c0, ctx.page === ctx.noOfPages));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(14, _c0, ctx.page === ctx.noOfPages));
        } }, dependencies: [i1.NgClass, i1.NgForOf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgModel] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PaginationComponent, [{
        type: Component,
        args: [{ selector: 'xf-pagination', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"pagination-wrapper d-flex justify-content-end\">\n    <div class=\"align-items-center d-flex me-4\">\n        <label for=\"itemsPerPageDD\" class=\"me-2 ps-2 content-font\">Items Per Page</label>\n        <select class=\"form-select form-select-xs text-center w-auto\" id=\"itemsPerPageDD\"\n            name=\"itemsPerPageDD\" [(ngModel)]=\"itemsPerPage\" (change)=\"recordsSizeChanged()\">\n            <option *ngFor=\"let pageSize of paginationSize\" [value]=\"pageSize\">{{ pageSize }}</option>\n        </select>\n    </div>\n    <div class=\"align-items-center d-flex\">\n        <button class=\"btn btn-xs btn-secondary\" [ngClass]=\"{'disabled': page === 1 }\" (click)=\"firstPage()\">\n            <i class=\"fa-light fa fa-chevron-double-left content-font\"></i>\n        </button>\n        <button class=\"btn btn-xs mx-1 btn-secondary\" [ngClass]=\"{'disabled': page === 1 }\" (click)=\"previousPage()\">\n            <i class=\"fa-light fa fa-chevron-left content-font\"></i>\n        </button>\n        <input #pageInput type=\"text\" pattern=\"[0-9]*\" class=\"form-control form-control-xs mx-2 text-center\"\n            id=\"paginationInput\" [value]=\"page\" (keyup.enter)=\"selectPage(pageInput.value)\"\n            (blur)=\"selectPage(pageInput.value)\" (input)=\"formatInput($any($event).target)\"\n            aria-labelledby=\"paginationInputLabel paginationDescription\" style=\"width: 3.5rem\" />\n        <label class=\"me-2 content-font\"> of {{ noOfPages }}</label>\n        <button class=\"btn btn-xs mx-1 btn-secondary\" [ngClass]=\"{'disabled': page === noOfPages }\" (click)=\"nextPage()\">\n            <i class=\"fa-light fa fa-chevron-right content-font\"></i>\n        </button>\n        <button class=\"btn btn-xs btn-secondary\" [ngClass]=\"{'disabled': page === noOfPages }\" (click)=\"lastPage()\">\n            <i class=\"fa-light fa fa-chevron-double-right content-font\"></i>\n        </button>\n    </div>\n    <div class=\"clearfix\"></div>\n</div>" }]
    }], () => [], { itemsPerPage: [{
            type: Input
        }], paginationSize: [{
            type: Input
        }], pageChanged: [{
            type: Output
        }], totalItems: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PaginationComponent, { className: "PaginationComponent", filePath: "src/widgets/grid-widget/pagination/pagination.component.ts", lineNumber: 14 }); })();
export var paginationEventType;
(function (paginationEventType) {
    paginationEventType["pageFirst"] = "pageFirst";
    paginationEventType["pageLast"] = "pageLast";
    paginationEventType["pageNext"] = "pageNext";
    paginationEventType["pagePrevious"] = "pagePrevious";
    paginationEventType["recordsPerPageChange"] = "recordsPerPageChange";
    paginationEventType["directPage"] = "directPage";
})(paginationEventType || (paginationEventType = {}));
//# sourceMappingURL=data:application/json;base64,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