/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { CommonModule } from '@angular/common';
import { Component, Input, ViewChildren, inject } from '@angular/core';
import { FormControl, FormsModule, ReactiveFormsModule, Validators } from '@angular/forms';
import { XFFormFieldsModule } from '../../form-fields/form-fields.module';
import { cloneDeep, forEach } from 'lodash-es';
import { isObject } from 'lodash-es';
import { FormFieldComponent } from '../../form-fields/field-renderers/built-ins/form-field/form-field.component';
import { FieldOptions } from '../../form-fields/models/field-options';
import { TranslocoService } from '@jsverse/transloco';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/forms";
import * as i3 from "../../core/services/entity.service";
import * as i4 from "@angular/common";
import * as i5 from "../../form-fields/field-renderers/built-ins/form-field/form-field.component";
function AddRecordComponent_div_9_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵelement(1, "xf-form-field", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r2 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", field_r2.value)("formControlName", field_r2.value.name)("fieldClass", "form-control-sm margin-bottom-8px w-100")("autoFocus", true)("fieldOptions", ctx_r2.nameFieldOptions);
} }
function AddRecordComponent_div_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, AddRecordComponent_div_9_div_1_Template, 2, 5, "div", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r2 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", field_r2.value.isFormField);
} }
export class AddRecordComponent {
    constructor(activeOffcanvas, formBuilder, entityService) {
        this.activeOffcanvas = activeOffcanvas;
        this.formBuilder = formBuilder;
        this.entityService = entityService;
        this.saveBtnText = 'Save';
        this.nameFieldOptions = new FieldOptions();
        this.processing = false;
        this.translocoService = inject(TranslocoService);
        // Preserve original property order
        this.originalOrder = (a, b) => {
            return a.value.orderIndex > b.value.orderIndex ? 1 : a.value.orderIndex < b.value.orderIndex ? -1 : 0;
        };
        this.nameFieldOptions.customErrorMessages = {
            pattern: this.translocoService.translate('error.agentNameCannotContain')
        };
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({});
        forEach(this.entity.fields, (field) => {
            if (field.isFormField) {
                let validators = [];
                if (field.validation.required) {
                    validators.push(Validators.required);
                }
                if (field.validation.pattern) {
                    validators.push(Validators.pattern(field.validation.pattern));
                }
                let fieldCtrl = new FormControl(this.entity.values[field.name] || '', validators);
                this.formGroup.addControl(field.name, fieldCtrl);
                this.formGroup.controls[field.name].valueChanges.subscribe((value) => {
                    if (this.entity.type === 'playbooks' && field.formType === 'lookup') {
                        this.entity.values[field.name] = value.uuid;
                    }
                    else {
                        this.entity.values[field.name] = value;
                    }
                });
            }
        });
    }
    createRecord() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            for (let formFieldComponent of this.formFieldComponents) {
                if (!formFieldComponent.valid) {
                    formFieldComponent.focus();
                    return;
                }
            }
        }
        this.processing = true;
        forEach(this.entity.fields, (field) => {
            if (field.isFormField && this.entity.type === 'playbooks' && field.formType === 'lookup' && isObject(this.entity.values[field.name])) {
                this.entity.values[field.name] = this.entity.values[field.name].uuid;
            }
        });
        let entity = cloneDeep(this.entity);
        entity.uuid = undefined;
        this.entityService.save(entity, Object.keys(this.entity.values)).subscribe({
            next: (response) => {
                this.activeOffcanvas.close(response);
                this.processing = false;
            }, error: () => {
                this.processing = false;
            }
        });
    }
    static { this.ɵfac = function AddRecordComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AddRecordComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i3.EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AddRecordComponent, selectors: [["xf-add-record"]], viewQuery: function AddRecordComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFieldComponents = _t);
        } }, inputs: { entity: "entity", saveBtnText: "saveBtnText" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 18, vars: 11, consts: [["addModuleForm", "ngForm"], [3, "ngSubmit", "formGroup"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click", "disabled"], [1, "margin-top-20px", "modal-body"], [1, "row", "m-0"], [1, "col-md-12"], ["class", "form-group", 4, "ngFor", "ngForOf"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "submit", 1, "btn", "btn-primary", "btn-sm", "margin-left-6px", 3, "click", "disabled"], [1, "fa-light", "margin-right-4px", 3, "ngClass"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", 3, "click", "disabled"], [1, "fa", "fa-times", "margin-right-4px"], [1, "form-group"], ["class", "mb-2", 4, "ngIf"], [1, "mb-2"], [3, "field", "formControlName", "fieldClass", "autoFocus", "fieldOptions"]], template: function AddRecordComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "form", 1, 0);
            i0.ɵɵlistener("ngSubmit", function AddRecordComponent_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.createRecord()); });
            i0.ɵɵelementStart(2, "div", 2)(3, "h4", 3);
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "button", 4);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_5_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Cross click")); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 5)(7, "div", 6)(8, "div", 7);
            i0.ɵɵtemplate(9, AddRecordComponent_div_9_Template, 2, 1, "div", 8);
            i0.ɵɵpipe(10, "keyvalue");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(11, "div", 9)(12, "button", 10);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.createRecord()); });
            i0.ɵɵelement(13, "i", 11);
            i0.ɵɵtext(14);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(15, "button", 12);
            i0.ɵɵlistener("click", function AddRecordComponent_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Close click")); });
            i0.ɵɵelement(16, "i", 13);
            i0.ɵɵtext(17, "Cancel ");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(4);
            i0.ɵɵtextInterpolate1("Create ", ctx.entity.descriptions.singular, "");
            i0.ɵɵadvance();
            i0.ɵɵproperty("disabled", ctx.processing);
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind2(10, 8, ctx.entity.fields, ctx.originalOrder));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("disabled", ctx.processing);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", ctx.processing ? "fa-spin fa-spinner" : "fa fa-check");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1("", ctx.saveBtnText, " ");
            i0.ɵɵadvance();
            i0.ɵɵproperty("disabled", ctx.processing);
        } }, dependencies: [CommonModule, i4.NgClass, i4.NgForOf, i4.NgIf, i4.KeyValuePipe, FormsModule, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, XFFormFieldsModule, i5.FormFieldComponent, ReactiveFormsModule, i2.FormGroupDirective, i2.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AddRecordComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [
                    CommonModule,
                    FormsModule,
                    XFFormFieldsModule,
                    ReactiveFormsModule
                ], selector: 'xf-add-record', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form #addModuleForm=\"ngForm\" (ngSubmit)=\"createRecord()\" [formGroup]=\"formGroup\">\n  <div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n    <h4 class=\"page-title-font modal-title muted-10\">Create {{entity.descriptions.singular}}</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"activeOffcanvas.dismiss('Cross click')\"\n      [disabled]=\"processing\"></button>\n  </div>\n  <div class=\"margin-top-20px modal-body\">\n    <div class=\"row m-0\">\n      <div class=\"col-md-12\">\n        <div class=\"form-group\" *ngFor=\"let field of entity.fields | keyvalue : originalOrder\">\n          <div class=\"mb-2\" *ngIf=\"field.value.isFormField\">\n            <xf-form-field [field]=\"field.value\" [formControlName]=\"field.value.name\"\n              [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\" [autoFocus]=\"true\" [fieldOptions]=\"nameFieldOptions\"></xf-form-field>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  <div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\">\n    <button type=\"submit\" class=\"btn btn-primary btn-sm margin-left-6px\" (click)=\"createRecord()\"\n      [disabled]=\"processing\">\n      <i class=\"fa-light margin-right-4px\"\n        [ngClass]=\"processing ? 'fa-spin fa-spinner' : 'fa fa-check'\"></i>{{saveBtnText}}\n    </button>\n    <button type=\"button\" class=\"btn btn-secondary btn-sm\" (click)=\"activeOffcanvas.dismiss('Close click')\"\n      [disabled]=\"processing\">\n      <i class=\"fa fa-times margin-right-4px\"></i>Cancel\n    </button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i1.NgbActiveOffcanvas }, { type: i2.FormBuilder }, { type: i3.EntityService }], { entity: [{
            type: Input
        }], saveBtnText: [{
            type: Input
        }], formFieldComponents: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AddRecordComponent, { className: "AddRecordComponent", filePath: "lib/components/add-record/add-record.component.ts", lineNumber: 34 }); })();
//# sourceMappingURL=data:application/json;base64,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