/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { CommonModule } from '@angular/common';
import { Component, Input } from '@angular/core';
import { FormControl, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { XFFormFieldsModule } from '../../form-fields/form-fields.module';
import { cloneDeep, forEach } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/forms";
import * as i3 from "../../core/services/entity.service";
import * as i4 from "@angular/common";
import * as i5 from "../../form-fields/field-renderers/built-ins/editable-field/editable-field.component";
function EditModuleComponent_div_9_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 16)(1, "xf-editable-field", 17);
    i0.ɵɵlistener("valueChange", function EditModuleComponent_div_9_div_1_Template_xf_editable_field_valueChange_1_listener($event) { i0.ɵɵrestoreView(_r2); const field_r3 = i0.ɵɵnextContext().$implicit; const ctx_r3 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r3.saveField(field_r3.value.name, $event, ctx_r3.entity.values[field_r3.value.name])); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const field_r3 = i0.ɵɵnextContext().$implicit;
    const ctx_r3 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", field_r3.value)("showLabel", true)("editMode", true)("value", ctx_r3.entity.values[field_r3.value.name])("fieldOptions", ctx_r3.fieldOptions)("autoFocus", true);
} }
function EditModuleComponent_div_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, EditModuleComponent_div_9_div_1_Template, 2, 6, "div", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r3 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", field_r3.value.isFormField);
} }
export class EditModuleComponent {
    constructor(activeOffcanvas, formBuilder, entityService) {
        this.activeOffcanvas = activeOffcanvas;
        this.formBuilder = formBuilder;
        this.entityService = entityService;
        this.fieldOptions = { 'size': 'large' };
        // Preserve original property order
        this.originalOrder = (a, b) => {
            return 0;
        };
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({});
        forEach(this.entity.attributes, (field) => {
            if (field.isFormField) {
                let fieldCtrl = new FormControl('');
                this.formGroup.addControl(field.name, fieldCtrl);
                this.formGroup.controls[field.name].valueChanges.subscribe((value) => {
                    this.entity.values[field.name] = value;
                });
            }
        });
    }
    saveField(field, newValue, oldValue) {
        this.entity.values[field] = newValue;
    }
    updateModule() {
        let entity = cloneDeep(this.entity);
        this.entityService.save(entity, Object.keys(this.entity.values)).subscribe((response) => {
            this.activeOffcanvas.close(response);
        });
    }
    static { this.ɵfac = function EditModuleComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditModuleComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i3.EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EditModuleComponent, selectors: [["lib-edit-module"]], inputs: { entity: "entity" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 18, vars: 6, consts: [["addModuleForm", "ngForm"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "margin-top-20px", "modal-body"], [3, "ngSubmit", "formGroup"], [1, "row", "m-0"], [1, "col-md-12"], ["class", "form-group", 4, "ngFor", "ngForOf"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-left-6px", 3, "click"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"], [1, "form-group"], ["class", "mb-2", 4, "ngIf"], [1, "mb-2"], ["use-placeholder", "true", 1, "d-inline-block", "w-100", 3, "valueChange", "field", "showLabel", "editMode", "value", "fieldOptions", "autoFocus"]], template: function EditModuleComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "h4", 2);
            i0.ɵɵtext(2);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "button", 3);
            i0.ɵɵlistener("click", function EditModuleComponent_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Cross click")); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(4, "div", 4)(5, "form", 5, 0);
            i0.ɵɵlistener("ngSubmit", function EditModuleComponent_Template_form_ngSubmit_5_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.updateModule()); });
            i0.ɵɵelementStart(7, "div", 6)(8, "div", 7);
            i0.ɵɵtemplate(9, EditModuleComponent_div_9_Template, 2, 1, "div", 8);
            i0.ɵɵpipe(10, "keyvalue");
            i0.ɵɵelementEnd()()()();
            i0.ɵɵelementStart(11, "div", 9)(12, "button", 10);
            i0.ɵɵlistener("click", function EditModuleComponent_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.updateModule()); });
            i0.ɵɵelement(13, "i", 11);
            i0.ɵɵtext(14, "Save ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(15, "button", 12);
            i0.ɵɵlistener("click", function EditModuleComponent_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.activeOffcanvas.dismiss("Close click")); });
            i0.ɵɵelement(16, "i", 13);
            i0.ɵɵtext(17, "Cancel ");
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵtextInterpolate1("Update ", ctx.entity.descriptions.singular, " Details");
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind2(10, 3, ctx.entity.fields, ctx.originalOrder));
        } }, dependencies: [CommonModule, i4.NgForOf, i4.NgIf, i4.KeyValuePipe, FormsModule, i2.ɵNgNoValidate, i2.NgControlStatusGroup, XFFormFieldsModule, i5.EditableFieldComponent, ReactiveFormsModule, i2.FormGroupDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditModuleComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [
                    CommonModule,
                    FormsModule,
                    XFFormFieldsModule,
                    ReactiveFormsModule
                ], selector: 'lib-edit-module', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n    <h4 class=\"page-title-font modal-title muted-10\">Update {{entity.descriptions.singular}} Details</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\"\n        (click)=\"activeOffcanvas.dismiss('Cross click')\"></button>\n</div>\n<div class=\"margin-top-20px modal-body\">\n    <form #addModuleForm=\"ngForm\" (ngSubmit)=\"updateModule()\" [formGroup]=\"formGroup\">\n        <div class=\"row m-0\">\n            <div class=\"col-md-12\">\n                <div class=\"form-group\" *ngFor=\"let field of entity.fields | keyvalue : originalOrder\">\n                    <div class=\"mb-2\" *ngIf=\"field.value.isFormField\">\n                        <xf-editable-field [field]=\"field.value\" [showLabel]=\"true\" [editMode]=\"true\"\n                            class=\"d-inline-block w-100\" [value]=\"entity.values[field.value.name]\"\n                            (valueChange)=\"saveField(field.value.name, $event, entity.values[field.value.name])\"\n                            use-placeholder=\"true\" [fieldOptions]=\"fieldOptions\" [autoFocus]=\"true\">\n                        </xf-editable-field>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </form>\n</div>\n<div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\">\n    <button type=\"button\" class=\"btn btn-primary btn-sm margin-left-6px\" (click)=\"updateModule()\">\n        <i class=\"fa fa-check margin-right-4px\"></i>Save\n    </button>\n    <button type=\"button\" class=\"btn btn-secondary btn-sm\" (click)=\"activeOffcanvas.dismiss('Close click')\">\n        <i class=\"fa fa-times margin-right-4px\"></i>Cancel\n    </button>\n</div>" }]
    }], () => [{ type: i1.NgbActiveOffcanvas }, { type: i2.FormBuilder }, { type: i3.EntityService }], { entity: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(EditModuleComponent, { className: "EditModuleComponent", filePath: "lib/components/edit-module/edit-module.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,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