/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { CommonModule } from '@angular/common';
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { cloneDeep, forEach } from 'lodash-es';
import { Field } from '../../core/models/field';
import * as i0 from "@angular/core";
import * as i1 from "../../form-fields/field-renderers/built-ins/picklist/picklist.service";
import * as i2 from "../../utility/pipes/get-end-path-name.pipe";
import * as i3 from "@angular/forms";
import * as i4 from "@angular/common";
function FieldSelectComponent_option_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r1 = ctx.$implicit;
    i0.ɵɵproperty("value", field_r1.formType);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(field_r1.title);
} }
function FieldSelectComponent_div_6_option_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r4 = ctx.$implicit;
    i0.ɵɵproperty("value", field_r4.formType);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(field_r4.title);
} }
function FieldSelectComponent_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "label", 9);
    i0.ɵɵtext(2, "Select Sub Type ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 10);
    i0.ɵɵlistener("change", function FieldSelectComponent_div_6_Template_select_change_3_listener() { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.fieldTypeChanged("subField")); });
    i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_div_6_Template_select_ngModelChange_3_listener($event) { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r2.field.formType, $event) || (ctx_r2.field.formType = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵtemplate(4, FieldSelectComponent_div_6_option_4_Template, 2, 2, "option", 4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("disabled", ctx_r2.field.system);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r2.field.formType);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.textFieldSubTypes);
} }
function FieldSelectComponent_div_7_option_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const picklist_r6 = ctx.$implicit;
    i0.ɵɵproperty("value", picklist_r6.uuid);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(picklist_r6.name);
} }
function FieldSelectComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 11)(1, "div", 12)(2, "label", 13);
    i0.ɵɵtext(3, "Picklist");
    i0.ɵɵelementStart(4, "span", 14);
    i0.ɵɵtext(5, "*");
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(6, "div")(7, "select", 15);
    i0.ɵɵlistener("change", function FieldSelectComponent_div_7_Template_select_change_7_listener() { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.picklistSelected()); });
    i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_div_7_Template_select_ngModelChange_7_listener($event) { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r2.selectedField.dataSource.query.filters[0].value, $event) || (ctx_r2.selectedField.dataSource.query.filters[0].value = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementStart(8, "option", 16);
    i0.ɵɵtext(9, "Select a Picklist");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, FieldSelectComponent_div_7_option_10_Template, 2, 2, "option", 4);
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(7);
    i0.ɵɵproperty("disabled", ctx_r2.selectedField.system)("required", true);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r2.selectedField.dataSource.query.filters[0].value);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngForOf", ctx_r2.picklists);
} }
export class FieldSelectComponent {
    constructor(picklistService, getEndPathName) {
        this.picklistService = picklistService;
        this.getEndPathName = getEndPathName;
        this.primaryFields = [];
        this.subTextFields = [Field.BuiltInType.DOMAIN, Field.BuiltInType.FILEHASH, Field.BuiltInType.IPv4, Field.BuiltInType.IPv6, Field.BuiltInType.RICHTEXTHTML, Field.BuiltInType.RICHTEXTMARKDOWN, Field.BuiltInType.TEXTAREA, Field.BuiltInType.TEXT, Field.BuiltInType.URL];
        this.textFieldSubTypes = [];
        this.fieldTypechanged = new EventEmitter();
        this.picklists = [];
    }
    ngOnInit() {
        this.setFieldTypes();
        this.loadPicklists();
    }
    ngOnChanges(changes) {
        if (changes.field) {
            this.setFieldTypes();
        }
    }
    setFieldTypes() {
        this.fieldCopy = cloneDeep(this.field);
        this.selectedField = cloneDeep(this.field);
        this.textFieldSubTypes = [];
        this.primaryFields = [];
        forEach(this.fieldTypes, (attribute) => {
            if (this.subTextFields.indexOf(attribute.formType) !== -1) {
                this.textFieldSubTypes.push(attribute);
                if (attribute.formType === Field.BuiltInType.TEXT) {
                    const fieldCopy = cloneDeep(attribute);
                    fieldCopy.title = 'Text';
                    this.primaryFields.push(fieldCopy);
                }
            }
            else if ((attribute.formType !== 'manyToMany' && attribute.formType !== 'oneToMany')) {
                this.primaryFields.push(cloneDeep(attribute));
            }
            // else if(attributetype.formType === 'datetime' || attributetype.formType === 'date') {
            //     dateSubtype.push(attributetype);
            //     if(attributetype.formType === 'datetime'){
            //       textAttr = angular.copy(attributetype);
            //       textAttr.title = 'Datetime';
            //       attrtypes.push(textAttr);
            //     }
            //   }
            // else if (attributetype.formType === 'emailTemplate') {
            //   textAttr = angular.copy(attributetype);
            //   textAttr.title = 'Email Template Field';
            //   attrtypes.push(textAttr);
            // } else {
            //   if((attributetype.formType !== 'manyToMany' && attributetype.formType !== 'oneToMany') || !scope.hideRelationship){
            //     attrtypes.push(attributetype);
            //   }
            // }
        });
        if (this.subTextFields.indexOf(this.field.formType) !== -1) {
            this.fieldCopy.formType = Field.BuiltInType.TEXT;
        }
    }
    loadPicklists() {
        this.picklistService.loadAllPicklists().subscribe((picklists) => {
            this.picklists = picklists;
            this.validatePicklist(this.field);
        });
    }
    fieldTypeChanged(fieldType) {
        console.log(this.fieldCopy.formType);
        let selectedAttribute;
        let selectedField;
        if (fieldType === 'mainField') {
            selectedField = this.fieldCopy.formType === 'text' ? this.field : this.fieldCopy;
            selectedAttribute = (this.primaryFields.find((field) => field.formType === selectedField.formType) || this.textFieldSubTypes.find((field) => field.formType === selectedField.formType));
        }
        else {
            selectedField = this.field;
            selectedAttribute = this.textFieldSubTypes.find((field) => field.formType === selectedField.formType);
        }
        this.selectedField = Object.assign(selectedField, selectedAttribute);
        this.selectedAttribute = selectedAttribute;
        if (selectedAttribute.formType === Field.BuiltInType.PICKLIST || selectedAttribute.formType === Field.BuiltInType.MULTISELECT_PICKLIST) {
            this.validatePicklist(this.selectedField);
        }
        else {
            this.fieldTypechanged.emit({
                moduleAttribute: selectedAttribute,
                field: this.selectedField
            });
        }
    }
    picklistSelected() {
        console.log(this.fieldCopy);
        this.fieldTypechanged.emit({
            moduleAttribute: this.selectedAttribute,
            field: this.selectedField
        });
    }
    validatePicklist(field) {
        if (this.picklists && field.dataSource && field.dataSource.query?.filters.length) {
            const selectedPicklist = this.picklists[field.dataSource.query.filters[0].value];
            const displayConditions = field.displayConditions || {};
            if (selectedPicklist) {
                forEach(selectedPicklist, (option) => {
                    const uuid = this.getEndPathName.transform(option['@id']);
                    if (!displayConditions[uuid] || (field.formType === Field.BuiltInType.MULTISELECT_PICKLIST && ['disabled', 'enabled_condition'].indexOf(displayConditions[uuid].visibility) > -1)) {
                        const displayCondition = {
                            visibility: 'visible',
                            conditions: null
                        };
                        displayConditions[uuid] = displayCondition;
                    }
                    option.visibility = displayConditions[uuid].visibility;
                    option._conditions = displayConditions[uuid].conditions;
                });
            }
            else {
                field.dataSource.query.filters[0].value = null;
            }
            field.displayConditions = displayConditions;
        }
    }
    static { this.ɵfac = function FieldSelectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldSelectComponent)(i0.ɵɵdirectiveInject(i1.PicklistService), i0.ɵɵdirectiveInject(i2.GetEndPathNamePipe)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldSelectComponent, selectors: [["xf-field-select"]], inputs: { field: "field", modulesList: "modulesList", entity: "entity", moduleFields: "moduleFields", fieldTypes: "fieldTypes" }, outputs: { fieldTypechanged: "fieldTypechanged" }, standalone: true, features: [i0.ɵɵNgOnChangesFeature, i0.ɵɵStandaloneFeature], decls: 8, vars: 5, consts: [[1, "clearfix"], [1, "float-start", "padding-right-20px", "w-50"], ["for", "fieldType", 1, "control-label", "label-font"], ["id", "fieldType", "name", "fieldType", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "ngModelChange", "change", "disabled", "ngModel"], [3, "value", 4, "ngFor", "ngForOf"], ["class", "float-start padding-right-20px w-50 label-font", 4, "ngIf"], ["class", "margin-top-16px", 4, "ngIf"], [3, "value"], [1, "float-start", "padding-right-20px", "w-50", "label-font"], ["for", "textFieldSubType", 1, "control-label"], ["id", "textFieldSubType", "name", "textFieldSubType", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "change", "ngModelChange", "disabled", "ngModel"], [1, "margin-top-16px"], [1, "form-group"], ["for", "select-picklist", 1, "label-font"], [1, "text-danger"], ["id", "select-picklist", "name", "select-picklist", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "change", "ngModelChange", "disabled", "required", "ngModel"], ["value", "null"]], template: function FieldSelectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "label", 2);
            i0.ɵɵtext(3, "Select Field Type ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "select", 3);
            i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_Template_select_ngModelChange_4_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.fieldCopy.formType, $event) || (ctx.fieldCopy.formType = $event); return $event; });
            i0.ɵɵlistener("change", function FieldSelectComponent_Template_select_change_4_listener() { return ctx.fieldTypeChanged("mainField"); });
            i0.ɵɵtemplate(5, FieldSelectComponent_option_5_Template, 2, 2, "option", 4);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(6, FieldSelectComponent_div_6_Template, 5, 3, "div", 5);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(7, FieldSelectComponent_div_7_Template, 11, 4, "div", 6);
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("disabled", ctx.field.system);
            i0.ɵɵtwoWayProperty("ngModel", ctx.fieldCopy.formType);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.primaryFields);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fieldCopy.formType === "text");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.selectedField.formType === "picklist" || ctx.selectedField.formType === "multiselectpicklist");
        } }, dependencies: [FormsModule, i3.NgSelectOption, i3.ɵNgSelectMultipleOption, i3.SelectControlValueAccessor, i3.NgControlStatus, i3.RequiredValidator, i3.NgModel, CommonModule, i4.NgForOf, i4.NgIf] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldSelectComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-select', standalone: true, imports: [FormsModule, CommonModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"clearfix\">\n  <div class=\"float-start padding-right-20px w-50\">\n    <label class=\"control-label label-font\" for=\"fieldType\">Select Field Type\n    </label>\n    <select class=\"form-control form-control-sm margin-top-6px\" id=\"fieldType\" name=\"fieldType\"\n      [disabled]=\"field.system\" [(ngModel)]=\"fieldCopy.formType\" (change)=\"fieldTypeChanged('mainField')\">\n      <option *ngFor=\"let field of primaryFields;\" [value]=\"field.formType\">{{ field.title }}</option>\n    </select>\n  </div>\n  <div *ngIf=\"fieldCopy.formType === 'text'\" class=\"float-start padding-right-20px w-50 label-font\">\n    <label class=\"control-label\" for=\"textFieldSubType\">Select Sub Type\n    </label>\n    <select class=\"form-control form-control-sm margin-top-6px\" id=\"textFieldSubType\" name=\"textFieldSubType\"\n      [disabled]=\"field.system\" (change)=\"fieldTypeChanged('subField')\" [(ngModel)]=\"field.formType\">\n      <option *ngFor=\"let field of textFieldSubTypes;\" [value]=\"field.formType\">{{ field.title }}</option>\n    </select>\n  </div>\n</div>\n<div *ngIf=\"selectedField.formType === 'picklist' || selectedField.formType === 'multiselectpicklist'\"\n  class=\"margin-top-16px\">\n  <!-- <div class=\"form-group\" data-ng-class=\"{'has-error': (form.picklistSelect.$touched && !form.picklistSelect.$valid)|| field.dataSource.query.filters[0].value == ''}\"></div> -->\n  <div class=\"form-group\">\n    <label class=\"label-font\" for=\"select-picklist\">Picklist<span class=\"text-danger\">*</span></label>\n    <div>\n      <select class=\"form-control form-control-sm margin-top-6px\" id=\"select-picklist\" name=\"select-picklist\"\n        [disabled]=\"selectedField.system\" (change)=\"picklistSelected()\" [required]=\"true\"\n        [(ngModel)]=\"selectedField.dataSource.query.filters[0].value\">\n        <option value=\"null\">Select a Picklist</option>\n        <option *ngFor=\"let picklist of picklists;\" [value]=\"picklist.uuid\">{{ picklist.name }}</option>\n      </select>\n    </div>\n    <!-- <select class=\"form-control\" id=\"picklist-select--{{ $index }}\" name=\"picklistSelect\" data-ng-disabled=\"field.system === true\" data-ng-model=\"field.dataSource.query.filters[0].value\" data-ng-required=\"true\" data-ng-options=\"picklistName as picklistName for (picklistName, picklistValue) in picklistNames\"\n        data-ng-change=\"updateFieldType(false, '')\">\n\n      </select>\n      <span class=\"fa fa-sort-desc\"></span>\n      <div data-cs-messages=\"form.picklistSelect\"></div> -->\n  </div>\n  <!-- <div class=\"form-group\" data-ng-show=\"!inline\">\n    <button type=\"button\" class=\"btn btn-sm btn-default margin-top-3\" data-ng-disabled=\"field.system === true\" data-ng-hide=\"license && license.details.is_distributed &&  license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\" data-ng-click=\"quickPicklistEditor(null)\" id=\"create-new-picklist-btn--{{ $index }}\">Create picklist</button>\n    <button data-ng-if=\"field.dataSource.query.filters[0].value\" type=\"button\" class=\"btn btn-sm btn-default margin-top-3\" data-ng-disabled=\"field.system === true\" data-ng-hide=\"license && license.details.is_distributed &&  license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\" data-ng-click=\"quickPicklistEditor(field.dataSource.query.filters[0].value)\" id=\"modify-picklist-btn\">Modify picklist</button>\n  </div> -->\n  <!-- <div class=\"alert alert-info margin-top-sm\" data-ng-show=\"license && license.details.is_distributed && license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\">\n      <i class=\"icon icon-information\"></i>&nbsp;&nbsp;Picklists referred here are from the Master Node. Please ensure a sync between the picklists in Master and Tenant nodes for any edit to happen successfully.\n  </div> -->\n  <!-- <div class=\"form-group\" data-ng-if=\"field.dataSource.query.filters[0].value && picklistNames[field.dataSource.query.filters[0].value] && !hideVisibility\">\n    <div class=\"checkbox margin-bottom-md\">\n      <label>\n        <input id=\"picklist-item-visibility\" type=\"checkbox\" name=\"picklist-item-visibility\" data-ng-model=\"$parent.field.dataSource.useDisplayConditions\">&nbsp;&nbsp;Configure Picklist Item Visibility\n        <span data-uib-tooltip=\"Picklist option visibility allows you to hide picklist items for this field based on conditions\"\n          data-tooltip-append-to-body=\"true\"><i class=\"icon icon-information font-Size-13\"></i></span>\n      </label>\n    </div>\n    <div data-ng-show=\"$parent.field.dataSource.useDisplayConditions\">\n      <div class=\"picklist-item-visibility-container\" data-ng-repeat=\"(key, option) in picklistNames[field.dataSource.query.filters[0].value].picklists | orderBy: 'orderIndex'\">\n        <div class=\"row padding-bottom-sm\">\n          <div class=\"col-md-4 label\">\n            <p id=\"view-{{ ::option.itemValue }}\" data-ng-hide=\"option.color\" class=\"margin-0 text-left text-overflow line-height-normal {{defaultClass}}\">\n              <span class=\"{{ defaultClass ? 'rating': '' }}\" title=\"{{ option.itemValue && option.itemValue.length > 0 ?  option.itemValue : 'None'}}\">{{ option.itemValue && option.itemValue.length > 0 ?  option.itemValue : 'None'}}</p>\n            <p id=\"view-{{ ::option.itemValue }}\" data-ng-show=\"option.color\" class=\"margin-0 text-left {{defaultClass}}\">\n            <span class=\"rating\" data-ng-attr-style=\"background: {{ option.color }}; color: {{ (option.color | isHexColorLight) ? '#000' : '#fff' }}\"> {{ option.itemValue }}</span>\n            </p>\n          </div>\n          <div class=\"col-md-8 val\">\n            <div class=\"cs-select\">\n              <select class=\"form-control\" name=\"picklist-item-visibility-display-{{ $index }}\" data-ng-model=\"option._visibility\" data-ng-required=\"true\" data-ng-change=\"updatePicklistItemVisibility(option)\">\n                <option value=\"visible\">Visible</option>\n                <option value=\"disabled\" ng-if=\"field.formType === 'picklist'\">Disabled</option>\n                <option value=\"hidden\">Hidden</option>\n                <option value=\"visible_condition\">Conditionally Visible</option>\n                <option value=\"enabled_condition\" ng-if=\"field.formType === 'picklist'\">Conditionally Enabled</option>\n              </select>\n              <span class=\"fa fa-sort-desc\"></span>\n            </div>\n          </div>\n        </div>\n        <div data-ng-if=\"option._visibility == 'visible_condition' || option._visibility == 'enabled_condition'\" class=\"row\">\n          <div class=\"col-md-12 padding-left-6\">\n            <hr class=\"margin-top-sm margin-bottom-md\">\n            <div data-cs-conditional data-enable-nested-filter=\"$parent.enableNestedFilter\" data-fields=\"$parent.moduleFields\" data-ng-model=\"option._conditions\" data-value-changed-param=\"option\" data-value-changed=\"updatePicklistItemVisibility\" data-form-name=\"'fieldSelectForm'\"></div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div> -->\n</div>\n" }]
    }], () => [{ type: i1.PicklistService }, { type: i2.GetEndPathNamePipe }], { field: [{
            type: Input
        }], modulesList: [{
            type: Input
        }], entity: [{
            type: Input
        }], moduleFields: [{
            type: Input
        }], fieldTypes: [{
            type: Input
        }], fieldTypechanged: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldSelectComponent, { className: "FieldSelectComponent", filePath: "lib/components/field-select/field-select.component.ts", lineNumber: 25 }); })();
//# sourceMappingURL=data:application/json;base64,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