/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, Input } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import * as i0 from "@angular/core";
import * as i1 from "../service/icon.service";
import * as i2 from "@angular/forms";
import * as i3 from "../pipes/icon-search.pipe";
import * as i4 from "@angular/common";
import * as i5 from "@ng-bootstrap/ng-bootstrap";
function IconComponent_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 10);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", ctx_r0.value);
} }
function IconComponent_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵtext(1, "None");
    i0.ɵɵelementEnd();
} }
function IconComponent_button_9_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 12);
    i0.ɵɵlistener("click", function IconComponent_button_9_Template_button_click_0_listener() { const icon_r3 = i0.ɵɵrestoreView(_r2).$implicit; const ctx_r0 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r0.iconSelected(icon_r3)); });
    i0.ɵɵelement(1, "span");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const icon_r3 = ctx.$implicit;
    const i_r4 = ctx.index;
    i0.ɵɵpropertyInterpolate("title", icon_r3.id);
    i0.ɵɵpropertyInterpolate1("id", "select-icons-btn-", i_r4, "");
    i0.ɵɵadvance();
    i0.ɵɵclassMap(icon_r3.id);
} }
export class IconComponent {
    constructor(iconService, formBuilder, iconSearch) {
        this.iconService = iconService;
        this.iconSearch = iconSearch;
        this.value = 'fa fa-none';
        this.icons = [];
        this.searchText = '';
        this.allIcons = [];
        this.currentIcons = [];
        this.onChange = (evt) => { };
        this.onTouched = () => { };
        this.touched = false;
        this.disabled = false;
        this.fieldGroup = formBuilder.group({
            searchIcon: ['']
        });
    }
    writeValue(value) {
        this.value = value;
    }
    registerOnChange(onChange) {
        this.onChange = onChange;
    }
    registerOnTouched(onTouched) {
        this.onTouched = onTouched;
    }
    validate(control) {
        const value = control.value;
        return null;
    }
    ngOnChanges(changes) {
        console.log(changes);
    }
    ngOnInit() {
        this.fieldGroup.controls.searchIcon.valueChanges.subscribe((value) => {
            this.currentIcons = this.iconSearch.transform(this.allIcons, value);
            this.icons = this.currentIcons;
            // this.loadNextIcons();
        });
        this.iconService.get().subscribe((icons) => {
            this.allIcons = icons;
            this.icons = icons;
        });
    }
    loadNextIcons(loadNext = true) {
        this.icons = this.currentIcons.slice(this.icons.length - 1, 250);
    }
    onScrollingFinished() {
        console.log('Load next Icons');
        this.loadNextIcons();
    }
    iconSelected(icon) {
        this.value = icon.id;
        if (!this.disabled) {
            this.onChange(this.value);
            this.onTouched();
        }
    }
    static { this.ɵfac = function IconComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IconComponent)(i0.ɵɵdirectiveInject(i1.IconService), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i3.IconSearchPipe)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: IconComponent, selectors: [["xf-icon"]], inputs: { value: "value" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: IconComponent,
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: IconComponent,
                    multi: true
                }]), i0.ɵɵNgOnChangesFeature], decls: 10, vars: 5, consts: [["ngbDropdown", "", 1, "dropdown", 3, "formGroup"], ["type", "button", "id", "icon-button-select", "name", "icon-button-select", "ngbDropdownToggle", "", 1, "btn", "btn-default", "btn-sm"], ["class", "padding-right-8px", 3, "ngClass", 4, "ngIf"], ["class", "padding-right-8px", 4, "ngIf"], ["ngbDropdownMenu", "", 1, "dropdown-menu", "item-picker-container"], [1, "icon-picker"], [1, "margin-right-8px", "margin-left-8px"], ["type", "text", "id", "icon-search", "name", "icon-search", "formControlName", "searchIcon", 1, "form-control", "form-control-sm", 3, "placeholder"], [1, "icon-picker-items"], ["class", "btn btn-default icon-item", 3, "title", "id", "click", 4, "ngFor", "ngForOf"], [1, "padding-right-8px", 3, "ngClass"], [1, "padding-right-8px"], [1, "btn", "btn-default", "icon-item", 3, "click", "title", "id"]], template: function IconComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "button", 1);
            i0.ɵɵtemplate(2, IconComponent_span_2_Template, 1, 1, "span", 2)(3, IconComponent_span_3_Template, 2, 0, "span", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "div", 4)(5, "div", 5)(6, "div", 6);
            i0.ɵɵelement(7, "input", 7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 8);
            i0.ɵɵtemplate(9, IconComponent_button_9_Template, 2, 6, "button", 9);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.fieldGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.value);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.value === "fa fa-none");
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("placeholder", "Filter Icons");
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.icons);
        } }, dependencies: [i4.NgClass, i4.NgForOf, i4.NgIf, i2.DefaultValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i5.NgbDropdown, i5.NgbDropdownToggle, i5.NgbDropdownMenu], styles: [".item-picker-container[_ngcontent-%COMP%]{width:300px;max-height:290px;overflow:auto}.item-picker-container[_ngcontent-%COMP%]   .icon-picker[_ngcontent-%COMP%]{overflow:hidden}.item-picker-container[_ngcontent-%COMP%]   .icon-picker[_ngcontent-%COMP%]   .icon-picker-items[_ngcontent-%COMP%]{position:relative;clear:both;float:none;padding:10px;background:transparent;margin:0;overflow:hidden;overflow-y:auto;min-height:49px;max-height:246px}.item-picker-container[_ngcontent-%COMP%]   .icon-picker[_ngcontent-%COMP%]   .icon-picker-items[_ngcontent-%COMP%]   .icon-item[_ngcontent-%COMP%]{float:left;margin:2px;width:40px;height:40px;text-align:center}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IconComponent, [{
        type: Component,
        args: [{ selector: 'xf-icon', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: IconComponent,
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: IconComponent,
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div ngbDropdown class=\"dropdown\" [formGroup]=\"fieldGroup\">\n  <button type=\"button\" id=\"icon-button-select\" name=\"icon-button-select\" class=\"btn btn-default btn-sm\"\n    ngbDropdownToggle>\n    <span class=\"padding-right-8px\" [ngClass]=\"value\" *ngIf=\"value\"></span>\n    <span class=\"padding-right-8px\" *ngIf=\"value ==='fa fa-none'\">None</span>\n  </button>\n  <div class=\"dropdown-menu item-picker-container\" ngbDropdownMenu>\n    <div class=\"icon-picker\">\n      <div class=\"margin-right-8px margin-left-8px\">\n        <input type=\"text\" class=\"form-control form-control-sm\" id=\"icon-search\" name=\"icon-search\"\n          [placeholder]=\"'Filter Icons'\" formControlName=\"searchIcon\">\n      </div>\n      <div class=\"icon-picker-items\">\n        <button *ngFor=\"let icon of icons; let i = index\"\n          class=\"btn btn-default icon-item\" (click)=\"iconSelected(icon)\" title=\"{{ icon.id }}\"\n          id=\"select-icons-btn-{{ i }}\">\n          <span class=\"{{ icon.id }}\"></span>\n        </button>\n      </div>\n    </div>\n  </div>\n</div>\n", styles: [".item-picker-container{width:300px;max-height:290px;overflow:auto}.item-picker-container .icon-picker{overflow:hidden}.item-picker-container .icon-picker .icon-picker-items{position:relative;clear:both;float:none;padding:10px;background:transparent;margin:0;overflow:hidden;overflow-y:auto;min-height:49px;max-height:246px}.item-picker-container .icon-picker .icon-picker-items .icon-item{float:left;margin:2px;width:40px;height:40px;text-align:center}\n"] }]
    }], () => [{ type: i1.IconService }, { type: i2.FormBuilder }, { type: i3.IconSearchPipe }], { value: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(IconComponent, { className: "IconComponent", filePath: "lib/components/icons/component/icon.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,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