/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import * as i0 from "@angular/core";
export class EditorService {
    constructor() {
        this.loaded = false;
        this.loadingFinished = new Subject();
    }
    finishLoading() {
        this.loaded = true;
        this.loadingFinished.next();
    }
    load() {
        // load the assets
        const baseUrl = './assets' + '/monaco-editor/min/vs';
        if (typeof window.monaco === 'object') {
            this.finishLoading();
            return;
        }
        const onGotAmdLoader = () => {
            // load Monaco
            window.require.config({ paths: { vs: `${baseUrl}` } });
            window.require([`vs/editor/editor.main`], () => {
                this.finishLoading();
            });
        };
        // load AMD loader, if necessary
        if (!window.require) {
            const loaderScript = document.createElement('script');
            loaderScript.type = 'text/javascript';
            loaderScript.src = `${baseUrl}/loader.js`;
            loaderScript.addEventListener('load', onGotAmdLoader);
            document.body.appendChild(loaderScript);
        }
        else {
            onGotAmdLoader();
        }
    }
    static { this.ɵfac = function EditorService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditorService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EditorService, factory: EditorService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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