/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { CommonModule } from '@angular/common';
import { HttpErrorResponse } from '@angular/common/http';
import { Component, EventEmitter, inject, Input, Output } from '@angular/core';
import { FormBuilder, FormControl, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { NgbActiveModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslocoModule, TranslocoService } from '@jsverse/transloco';
import _, { cloneDeep, forEach, isUndefined } from 'lodash-es';
import { isArray } from 'lodash-es';
import { ToastrService } from 'ngx-toastr';
import { catchError, finalize, switchMap, throwError } from 'rxjs';
import { XFFormFieldsModule } from '../../form-fields/form-fields.module';
import { PermissionService } from '../../core/services/permission.service';
import { UserService } from '../../core/services/user.service';
import { PendingDecisionService } from '../../core/services/pending-decision.service';
import { UtilityService } from '../../core/services/utility.service';
import { ModalService } from '../../core/services/modal.service';
import { Entity } from '../../core/models/entity';
import { RichtextHTMLField } from '../../form-fields/field-types/richtext-html';
import { FIXED_MODULE, PERMISSION } from '../../core/constants';
import { ModuleAttributeMap } from '../../core/models/attribute-map';
import { Field } from '../../core/models/field';
import { EmbedService } from '../../core/services/embed.service';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "../../form-fields/field-renderers/built-ins/form-field/form-field.component";
import * as i4 from "../../form-fields/field-renderers/built-ins/editable-field/editable-field.component";
import * as i5 from "@jsverse/transloco";
import * as i6 from "@ng-bootstrap/ng-bootstrap";
const _c0 = a0 => ({ "margin-bottom-12px": a0 });
const _c1 = a0 => ({ "margin-top-10px": a0 });
function PendingDecisionComponent_form_1_h4_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "h4", 14);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.decisionInput.input.schema.title, "");
} }
function PendingDecisionComponent_form_1_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 15);
    i0.ɵɵlistener("click", function PendingDecisionComponent_form_1_button_3_Template_button_click_0_listener($event) { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.closePopup($event)); });
    i0.ɵɵelement(1, "i", 16);
    i0.ɵɵelementEnd();
} }
function PendingDecisionComponent_form_1_xf_editable_field_6_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "xf-editable-field", 17);
    i0.ɵɵtwoWayListener("valueChange", function PendingDecisionComponent_form_1_xf_editable_field_6_Template_xf_editable_field_valueChange_0_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r0 = i0.ɵɵnextContext(2); i0.ɵɵtwoWayBindingSet(ctx_r0.decisionInput.input.schema.description, $event) || (ctx_r0.decisionInput.input.schema.description = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵpropertyInterpolate("title", ctx_r0.decisionDescriptionField.title);
    i0.ɵɵproperty("field", ctx_r0.decisionDescriptionField)("ngClass", i0.ɵɵpureFunction1(6, _c0, (ctx_r0.decisionInput.input.schema.inputVariables == null ? null : ctx_r0.decisionInput.input.schema.inputVariables.length) === 0));
    i0.ɵɵtwoWayProperty("value", ctx_r0.decisionInput.input.schema.description);
    i0.ɵɵproperty("fieldClass", "form-control-sm")("readOnly", true);
} }
function PendingDecisionComponent_form_1_div_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 18);
    i0.ɵɵelement(2, "xf-form-field", 19);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const field_r4 = ctx.$implicit;
    const first_r5 = ctx.first;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(3, _c1, !first_r5));
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", field_r4.value)("formControlName", field_r4.key);
} }
function PendingDecisionComponent_form_1_div_10_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 22);
    i0.ɵɵlistener("click", function PendingDecisionComponent_form_1_div_10_button_1_Template_button_click_0_listener() { const option_r7 = i0.ɵɵrestoreView(_r6).$implicit; const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.submitDecision(option_r7)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r7 = ctx.$implicit;
    const i_r8 = ctx.index;
    i0.ɵɵpropertyInterpolate1("id", "submit-pending-decision-btn-", i_r8, "");
    i0.ɵɵproperty("ngClass", option_r7.primary ? "btn-primary" : "btn-secondary");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r7.option);
} }
function PendingDecisionComponent_form_1_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 20);
    i0.ɵɵtemplate(1, PendingDecisionComponent_form_1_div_10_button_1_Template, 2, 4, "button", 21);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r0.decisionInput.response_mapping.options);
} }
function PendingDecisionComponent_form_1_Conditional_11_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r9 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 13)(1, "span", 24);
    i0.ɵɵlistener("click", function PendingDecisionComponent_form_1_Conditional_11_div_0_Template_span_click_1_listener() { i0.ɵɵrestoreView(_r9); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.deleteManualInput()); });
    i0.ɵɵelement(2, "i", 25);
    i0.ɵɵelementStart(3, "span", 26);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "span", 27);
    i0.ɵɵelement(6, "i", 28);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r10 = ctx.$implicit;
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(t_r10("NOTIFICATIONS.DISCARD_USER_INPUT"));
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate("ngbTooltip", t_r10("NOTIFICATIONS.DISCARD_USER_INPUT_TOOLTIP"));
} }
function PendingDecisionComponent_form_1_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, PendingDecisionComponent_form_1_Conditional_11_div_0_Template, 7, 2, "div", 23);
} }
function PendingDecisionComponent_form_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "form", 3)(1, "div", 4);
    i0.ɵɵtemplate(2, PendingDecisionComponent_form_1_h4_2_Template, 2, 1, "h4", 5)(3, PendingDecisionComponent_form_1_button_3_Template, 2, 0, "button", 6);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 7)(5, "div", 8);
    i0.ɵɵtemplate(6, PendingDecisionComponent_form_1_xf_editable_field_6_Template, 1, 8, "xf-editable-field", 9);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "div", 10);
    i0.ɵɵtemplate(8, PendingDecisionComponent_form_1_div_8_Template, 3, 5, "div", 11);
    i0.ɵɵpipe(9, "keyvalue");
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(10, PendingDecisionComponent_form_1_div_10_Template, 2, 1, "div", 12)(11, PendingDecisionComponent_form_1_Conditional_11_Template, 1, 0, "div", 13);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.formGroup);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r0.decisionInput.input.schema.title);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.type === "modal");
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r0.decisionDescriptionField);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind2(9, 7, ctx_r0.fields, ctx_r0.originalOrder));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", (ctx_r0.decisionInput.response_mapping.options == null ? null : ctx_r0.decisionInput.response_mapping.options.length) > 0);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r0.type === "modal" && ctx_r0.playbookExecutePermission ? 11 : -1);
} }
function PendingDecisionComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 29)(1, "div", 30);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r0.decisionInput.response_mapping.customSuccessMessage ? ctx_r0.decisionInput.response_mapping.customSuccessMessage : "Playbook successfully resumed.");
} }
export class PendingDecisionComponent {
    constructor() {
        this.decisionInput = {};
        this.unauthenticated = false;
        this.type = 'inline';
        this.mode = 'edit';
        this.submitResponse = new EventEmitter();
        this.permissionsService = inject(PermissionService);
        this.usersService = inject(UserService);
        this.pendingDecisionService = inject(PendingDecisionService);
        this.utilityService = inject(UtilityService);
        this.toaster = inject(ToastrService);
        this.activeOffCanvas = inject(NgbActiveModal);
        this.translocoService = inject(TranslocoService);
        this.embedService = inject(EmbedService);
        this.modalService = inject(ModalService);
        this.formBuilder = inject(FormBuilder);
        this.playbookExecutePermission = false;
        this.playbookReadPermission = false;
        this.fields = {};
        this.processing = false;
        this.playbookResumed = false;
        this.isEmbed = false;
        // Preserve original property order
        this.originalOrder = (a, b) => {
            return 0;
        };
    }
    ngOnInit() {
        if (window.isEmbed) {
            this.isEmbed = true;
        }
        this.formGroup = this.formBuilder.group({});
        this.checkPermissions();
        this.currentUser = this.usersService.getCurrentUser();
        this.createDescriptionField();
        this.initializeInputParams();
    }
    checkPermissions() {
        if (this.unauthenticated) {
            this.playbookExecutePermission = true;
            this.playbookReadPermission = true;
        }
        else {
            const playbookPermissions = this.permissionsService.getPermission(FIXED_MODULE.PLAYBOOK);
            this.playbookExecutePermission = playbookPermissions.includes(PERMISSION.EXECUTE);
            this.playbookReadPermission = playbookPermissions.includes(PERMISSION.READ);
        }
    }
    initializeInputParams() {
        if (this.decisionInput.input.schema.inputVariables.length > 0) {
            this.processing = true;
            let stepDataVariables = this.decisionInput.input.schema.inputVariables;
            var moduleField = _.find(stepDataVariables, function (variable) {
                return variable.useRecordFieldDefault || variable.useModuleField;
            });
            if (!isUndefined(moduleField)) {
                if (isUndefined(this.entity)) {
                    //TODO: In case of record fields
                    //var recordEntity = FormEntityService.get();
                    //var recordModule = $filter('getModuleName')(this.decisionInput.record);
                    // if (recordEntity && recordEntity.module === recordModule && angular.equals({}, recordEntity.originalData) || !recordEntity) {
                    //   entity = new Entity(recordModule);
                    //   entity.get($filter('getEndPathName')(this.decisionInput.record)).then(function () {
                    //     _prepareVariableData(stepDataVariables);
                    //   });
                    // } else {
                    //   entity = recordEntity;
                    //   _prepareVariableData(stepDataVariables);
                    // }
                }
            }
            else {
                this.prepareVariableData(stepDataVariables);
            }
        }
    }
    prepareVariableData(stepDataVariables) {
        this.fields = {};
        //var firstField;
        let rows = !isUndefined(this.entity) ? [this.entity.originalData] : [];
        forEach(stepDataVariables, (inputVariable) => {
            let field;
            let fieldMetadata = cloneDeep(inputVariable);
            let formControl;
            fieldMetadata.title = fieldMetadata.label; // || $filter('camelCaseToHuman')(inputVariable.name);
            if (inputVariable.useRecordFieldDefault || inputVariable.useModuleField) {
                // field = angular.copy(entity.fields[inputVariable.moduleField]);
                // if(angular.isUndefined(field)){
                //   scope.processing = false;
                //   scope.error = '<span class="fa fa-exclamation-triangle warning-icon font-size-10"></span> <span class="font-bold font-italic">'+inputVariable.title + ' </span> field not found in ' + entity.descriptions.plural + ' module.';
                //   return;
                // }
                // var commonValue = CommonUtils.getCommonValue(rows, field.name);
                // field.value = field.type === 'datetime' ? new Date(commonValue * 1000) : commonValue;
                // if (angular.isObject(commonValue)) {
                //   field.value.display = field.getExportValue();
                // }
                // field.title = inputVariable.title ? inputVariable.title : field.title;
                // field.name = inputVariable.name ? inputVariable.name : field.name;
                // field.tooltip = inputVariable.tooltip ? inputVariable.tooltip : field.tooltip;
                // field.validation = {
                //   'required': angular.isDefined(inputVariable.required) ? inputVariable.required : true
                // };
                // field.required = angular.isDefined(inputVariable.required) ? inputVariable.required : true;
                // field.buttonClasses = 'btn btn-link';
            }
            else {
                fieldMetadata.writeable = true;
                const fieldAttributes = ModuleAttributeMap[fieldMetadata.formType];
                field = new fieldAttributes.field(fieldMetadata.name);
                //field = new Field(inputVariable);
                if (field.formType === Field.BuiltInType.SELECT) {
                    field.isMultiple = fieldMetadata.isMultiple;
                    if (isArray(fieldMetadata.options)) {
                        field.fieldOptions = { options: fieldMetadata.options.map((option) => {
                                return { label: option, value: option };
                            })
                        };
                    }
                }
                let defaultValue = inputVariable.defaultValue || '';
                if (field.formType === Field.BuiltInType.CHECKBOX) {
                    defaultValue = this.utilityService.isUndefined(inputVariable.defaultValue) || inputVariable.defaultValue === '' ? false : inputVariable.defaultValue;
                }
                field.defaultValue = defaultValue;
                formControl = new FormControl(defaultValue);
                field.title = inputVariable.label;
                field.tooltip = fieldMetadata.tooltip;
                field.validation = {
                    required: !isUndefined(fieldMetadata.required) ? fieldMetadata.required : true
                };
                field.required = !isUndefined(fieldMetadata.required) ? fieldMetadata.required : true;
                if (field.formType === Field.BuiltInType.CHECKBOX) {
                    field.viewMode = 'checkbox';
                }
                if (field.formType === Field.BuiltInType.JSON) {
                    field.modes = ['code', 'view'];
                }
                if (this.unauthenticated && field.formType === Field.BuiltInType.RICHTEXTHTML) {
                    field.params = { theme: 'dark' };
                }
                if (field.formType.indexOf('datetime') === 0 && fieldMetadata.value) {
                    // if (angular.isObject(field.value) && field.value.hasOwnProperty('differenceType')) {
                    //   field.value = convertToRelativeDateService(field.value);
                    // }
                    // evaluateDateFieldValue(field);
                }
            }
            // TODO: Visibility conditions
            //field.visibility = inputVariable.visibilityQuery && inputVariable.visibilityQuery.filters && inputVariable.visibilityQuery.filters.length > 0 ? inputVariable.visibilityQuery : true;
            if (field.formType === Field.BuiltInType.PICKLIST || field.formType === Field.BuiltInType.MULTISELECT_PICKLIST) {
                //picklistsService.loadPicklists(field);
            }
            this.fields[field.name] = field;
            this.formGroup.addControl(fieldMetadata.name, formControl);
        });
        this.inputVariableEntity = new Entity('inputVariables');
        this.inputVariableEntity.fields = this.fields;
        this.inputVariableEntity.evaluateAllFields();
        this.processing = false;
    }
    createDescriptionField() {
        if (this.decisionInput.input.schema.description) {
            let field = new RichtextHTMLField('decisionDescription');
            this.decisionDescriptionField = field;
        }
    }
    submitDecision(option) {
        let payload = {
            input: {},
            step_uuid: option.step_uuid,
            step_id: this.decisionInput.step_id,
            manual_input_id: this.decisionInput.id
        };
        if (this.decisionInput.is_approval) {
            payload.approved = option.primary;
        }
        if (!this.unauthenticated) {
            payload.user = this.currentUser.uuid;
        }
        // Add form values to payload
        payload.input = this.formGroup.value;
        this.pendingDecisionService.resumeAwaitingPlaybook(payload, this.decisionInput.workflow).pipe(finalize(() => {
            if (this.type === 'modal') {
                //this.activeOffCanvas.close('resumed');
            }
            else {
                this.playbookResumed = true;
            }
        })).subscribe({
            next: (data) => {
                let successMsg = this.utilityService.isUndefined(this.decisionInput.response_mapping.customSuccessMessage) ? this.decisionInput.response_mapping.customSuccessMessage : 'Awaiting Playbook resumed successfully';
                this.toaster.success(successMsg || data.message, 'Success');
                if (this.isEmbed) {
                    this.embedService.sendEventData({
                        'type': 'XF_MANUAL_INPUT_RESPONSE',
                        'data': {
                            'status': 'success',
                            'data': data
                        }
                    });
                }
                this.submitResponse.emit();
            }, error: (error) => {
                this.toaster.error(error.error.message, 'Error');
            }
        });
    }
    ;
    closePopup(event) {
        event.stopPropagation();
        this.submitResponse.emit(true);
        this.activeOffCanvas.dismiss();
    }
    deleteManualInput() {
        this.modalService.confirm(this.translocoService.translate('NOTIFICATIONS.MANUAL_INPUT_DELETE_NOTIFICATION_CONFIRMATION_MESSAGE')).pipe(switchMap(() => {
            return this.pendingDecisionService.deleteManualInput(this.decisionInput.id);
        }), catchError(error => {
            return throwError(() => error);
        })).subscribe({
            next: () => {
                this.submitResponse.emit(true);
                this.activeOffCanvas.dismiss();
                this.toaster.success(this.translocoService.translate('NOTIFICATIONS.MANUAL_INPUT_DELETE_SUCCESS_MESSAGE'), 'Success');
            }, error: (e) => {
                if (e instanceof HttpErrorResponse) {
                    this.toaster.error(e.error.message, 'Error');
                }
            }
        });
    }
    static { this.ɵfac = function PendingDecisionComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PendingDecisionComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PendingDecisionComponent, selectors: [["xf-pending-decision"]], inputs: { decisionInput: "decisionInput", unauthenticated: "unauthenticated", type: "type", mode: "mode" }, outputs: { submitResponse: "submitResponse" }, standalone: true, features: [i0.ɵɵProvidersFeature([
                NgbActiveModal,
            ]), i0.ɵɵStandaloneFeature], decls: 3, vars: 2, consts: [[1, "position-relative"], [3, "formGroup", 4, "ngIf"], ["class", "padding-top-lg padding-bottom-lg", 4, "ngIf"], [3, "formGroup"], [1, "modal-header", "padding-bottom-8px", "padding-left-12px", "padding-right-16px", "padding-top-8px", "modal-close-left"], ["class", "page-title-font modal-title", 4, "ngIf"], ["ype", "button", "aria-label", "Close", "class", "btn btn-sm ms-auto", 3, "click", 4, "ngIf"], [1, "h-auto", "modal-body"], [1, "padding-left-12px"], ["class", "d-block", "use-placeholder", "true", 3, "field", "ngClass", "value", "fieldClass", "readOnly", "title", "valueChange", 4, "ngIf"], [1, "padding-left-12px", "padding-right-16px", "padding-top-8px", "padding-bottom-8px"], [4, "ngFor", "ngForOf"], ["class", "flex-row modal-footer padding-bottom-12px padding-left-12px padding-right-16px padding-top-16px position-relative", 4, "ngIf"], [1, "border-1", "border-dark", "border-top", "padding-bottom-6px", "padding-left-20px", "padding-right-20px", "padding-top-6px", "text-end"], [1, "page-title-font", "modal-title"], ["ype", "button", "aria-label", "Close", 1, "btn", "btn-sm", "ms-auto", 3, "click"], [1, "fa", "fa-close"], ["use-placeholder", "true", 1, "d-block", 3, "valueChange", "field", "ngClass", "value", "fieldClass", "readOnly", "title"], [3, "ngClass"], [3, "field", "formControlName"], [1, "flex-row", "modal-footer", "padding-bottom-12px", "padding-left-12px", "padding-right-16px", "padding-top-16px", "position-relative"], ["type", "button", "class", "btn btn-sm margin-right-4px", 3, "ngClass", "id", "click", 4, "ngFor", "ngForOf"], ["type", "button", 1, "btn", "btn-sm", "margin-right-4px", 3, "click", "ngClass", "id"], ["class", "border-1 border-dark border-top padding-bottom-6px padding-left-20px padding-right-20px padding-top-6px text-end", 4, "transloco"], [1, "font-size-12px", "text-danger", "cursor-pointer", 3, "click"], [1, "fa", "fa-light", "fa-trash-alt"], [1, "margin-left-6px"], ["container", "body", 3, "ngbTooltip"], [1, "content-font", "fa-circle-info", "fa-duotone", "fa-light", "margin-left-4px"], [1, "padding-top-lg", "padding-bottom-lg"], [1, "text-center", "content-font"]], template: function PendingDecisionComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, PendingDecisionComponent_form_1_Template, 12, 10, "form", 1)(2, PendingDecisionComponent_div_2_Template, 3, 1, "div", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.playbookResumed);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.playbookResumed);
        } }, dependencies: [CommonModule, i1.NgClass, i1.NgForOf, i1.NgIf, i1.KeyValuePipe, FormsModule, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, ReactiveFormsModule, i2.FormGroupDirective, i2.FormControlName, XFFormFieldsModule, i3.FormFieldComponent, i4.EditableFieldComponent, TranslocoModule, i5.TranslocoDirective, NgbTooltipModule, i6.NgbTooltip] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PendingDecisionComponent, [{
        type: Component,
        args: [{ selector: 'xf-pending-decision', standalone: true, providers: [
                    NgbActiveModal,
                ], imports: [CommonModule, FormsModule, ReactiveFormsModule, XFFormFieldsModule, TranslocoModule, NgbTooltipModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"position-relative\">\n  <form [formGroup]=\"formGroup\" *ngIf=\"!playbookResumed\">\n    <div class=\"modal-header padding-bottom-8px padding-left-12px padding-right-16px padding-top-8px modal-close-left\">\n      <h4 class=\"page-title-font modal-title\" *ngIf=\"decisionInput.input.schema.title\">\n        {{decisionInput.input.schema.title}}</h4>\n      <button ype=\"button\" *ngIf=\"type === 'modal'\" aria-label=\"Close\" class=\"btn btn-sm ms-auto\"\n        (click)=\"closePopup($event);\">\n        <i class=\"fa fa-close\"></i>\n      </button>\n\n    </div>\n    <div class=\"h-auto modal-body\">\n      <div class=\"padding-left-12px\">\n        <xf-editable-field *ngIf=\"decisionDescriptionField\" [field]=\"decisionDescriptionField\" class=\"d-block\"\n          [ngClass]=\"{ 'margin-bottom-12px' : decisionInput.input.schema.inputVariables?.length === 0 }\"\n          [(value)]=\"decisionInput.input.schema.description\" use-placeholder=\"true\" [fieldClass]=\"'form-control-sm'\"\n          [readOnly]=\"true\" title=\"{{decisionDescriptionField.title}}\">\n        </xf-editable-field>\n      </div>\n      <div class=\"padding-left-12px padding-right-16px padding-top-8px padding-bottom-8px\">\n        <div *ngFor=\"let field of fields | keyvalue: originalOrder; let first = first;\">\n          <div [ngClass]=\"{'margin-top-10px' : !first }\">\n            <xf-form-field [field]=\"field.value\" [formControlName]=\"field.key\"></xf-form-field>\n          </div>\n        </div>\n      </div>\n    </div>\n    <!-- footer -->\n    <div\n      class=\"flex-row modal-footer padding-bottom-12px padding-left-12px padding-right-16px padding-top-16px position-relative\"\n      *ngIf=\"decisionInput.response_mapping.options?.length > 0\">\n      <button *ngFor=\"let option of decisionInput.response_mapping.options; let i = index;\" type=\"button\"\n        [ngClass]=\"option.primary ? 'btn-primary': 'btn-secondary'\" class=\"btn btn-sm margin-right-4px\"\n        (click)=\"submitDecision(option)\" id=\"submit-pending-decision-btn-{{i}}\">{{option.option}}</button>\n    </div>\n    <!-- Delete user Input -->\n    @if (type === 'modal' && playbookExecutePermission) {\n      <div class=\"border-1 border-dark border-top padding-bottom-6px padding-left-20px padding-right-20px padding-top-6px text-end\"  *transloco=\"let t\">\n        <span class=\"font-size-12px text-danger cursor-pointer\" (click)=\"deleteManualInput()\"><i class=\"fa fa-light fa-trash-alt\"></i>\n          <span class=\"margin-left-6px\">{{ t('NOTIFICATIONS.DISCARD_USER_INPUT') }}</span>\n        </span>\n        <span ngbTooltip=\"{{ t('NOTIFICATIONS.DISCARD_USER_INPUT_TOOLTIP') }}\" container=\"body\">\n        <i class=\"content-font fa-circle-info fa-duotone fa-light margin-left-4px\"></i></span>\n      </div>\n    }\n  </form>\n  <div class=\"padding-top-lg padding-bottom-lg\" *ngIf=\"playbookResumed\">\n    <div class=\"text-center content-font\">{{decisionInput.response_mapping.customSuccessMessage ?\n      decisionInput.response_mapping.customSuccessMessage : 'Playbook successfully resumed.'}}</div>\n  </div>\n</div>\n" }]
    }], () => [], { decisionInput: [{
            type: Input
        }], unauthenticated: [{
            type: Input
        }], type: [{
            type: Input
        }], mode: [{
            type: Input
        }], submitResponse: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PendingDecisionComponent, { className: "PendingDecisionComponent", filePath: "lib/components/pending-decision/pending-decision.component.ts", lineNumber: 42 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGVuZGluZy1kZWNpc2lvbi5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9jb21wb25lbnRzL3BlbmRpbmctZGVjaXNpb24vcGVuZGluZy1kZWNpc2lvbi5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9jb21wb25lbnRzL3BlbmRpbmctZGVjaXNpb24vcGVuZGluZy1kZWNpc2lvbi5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7OztrQkFJa0I7QUFDbEIsT0FBTyxFQUFFLFlBQVksRUFBWSxNQUFNLGlCQUFpQixDQUFDO0FBQ3pELE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxNQUFNLHNCQUFzQixDQUFDO0FBQ3pELE9BQU8sRUFBRSxTQUFTLEVBQUUsWUFBWSxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQVUsTUFBTSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQ3ZGLE9BQU8sRUFBRSxXQUFXLEVBQUUsV0FBVyxFQUFhLFdBQVcsRUFBRSxtQkFBbUIsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQ3ZHLE9BQU8sRUFBRSxjQUFjLEVBQUUsZ0JBQWdCLEVBQUUsTUFBTSw0QkFBNEIsQ0FBQztBQUM5RSxPQUFPLEVBQUUsZUFBZSxFQUFFLGdCQUFnQixFQUFFLE1BQU0sb0JBQW9CLENBQUM7QUFDdkUsT0FBTyxDQUFDLEVBQUUsRUFBRSxTQUFTLEVBQUUsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLFdBQVcsQ0FBQztBQUMvRCxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQ3BDLE9BQU8sRUFBRSxhQUFhLEVBQUUsTUFBTSxZQUFZLENBQUM7QUFDM0MsT0FBTyxFQUFFLFVBQVUsRUFBRSxRQUFRLEVBQUUsU0FBUyxFQUFFLFVBQVUsRUFBRSxNQUFNLE1BQU0sQ0FBQztBQUNuRSxPQUFPLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSxzQ0FBc0MsQ0FBQztBQUMxRSxPQUFPLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSx3Q0FBd0MsQ0FBQztBQUMzRSxPQUFPLEVBQUUsV0FBVyxFQUFFLE1BQU0sa0NBQWtDLENBQUM7QUFDL0QsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sOENBQThDLENBQUM7QUFDdEYsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLHFDQUFxQyxDQUFDO0FBQ3JFLE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxtQ0FBbUMsQ0FBQztBQUNqRSxPQUFPLEVBQUUsTUFBTSxFQUFFLE1BQU0sMEJBQTBCLENBQUM7QUFDbEQsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0sNkNBQTZDLENBQUM7QUFDaEYsT0FBTyxFQUFFLFlBQVksRUFBRSxVQUFVLEVBQUUsTUFBTSxzQkFBc0IsQ0FBQztBQUNoRSxPQUFPLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSxpQ0FBaUMsQ0FBQztBQUNyRSxPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0seUJBQXlCLENBQUM7QUFDaEQsT0FBTyxFQUFFLFlBQVksRUFBZSxNQUFNLG1DQUFtQyxDQUFDOzs7Ozs7Ozs7OztJQ2xCeEUsOEJBQWlGO0lBQy9FLFlBQW9DO0lBQUEsaUJBQUs7OztJQUF6QyxjQUFvQztJQUFwQyx1RUFBb0M7Ozs7SUFDdEMsa0NBQ2dDO0lBQTlCLHFNQUFTLHlCQUFrQixLQUFFO0lBQzdCLHdCQUEyQjtJQUM3QixpQkFBUzs7OztJQUtQLDZDQUcrRDtJQUQ3RCxrWUFBa0Q7SUFFcEQsaUJBQW9COzs7SUFEQSx3RUFBMEM7SUFGNUQsQUFEa0QsdURBQWtDLDBLQUNVO0lBQzlGLDJFQUFrRDtJQUNsRCxBQUQwRSw4Q0FBZ0Msa0JBQ3pGOzs7SUFLakIsQUFERiwyQkFBZ0YsY0FDL0I7SUFDN0Msb0NBQW1GO0lBRXZGLEFBREUsaUJBQU0sRUFDRjs7OztJQUhDLGNBQXlDO0lBQXpDLCtEQUF5QztJQUM3QixjQUFxQjtJQUFDLEFBQXRCLHNDQUFxQixpQ0FBOEI7Ozs7SUFTeEUsa0NBRTBFO0lBQXhFLGtPQUFTLGdDQUFzQixLQUFDO0lBQXdDLFlBQWlCO0lBQUEsaUJBQVM7Ozs7SUFBakUseUVBQXNDO0lBRHZFLDZFQUEyRDtJQUNhLGNBQWlCO0lBQWpCLHNDQUFpQjs7O0lBTDdGLCtCQUU2RDtJQUMzRCw4RkFFMEU7SUFDNUUsaUJBQU07OztJQUh1QixjQUEyQztJQUEzQyx1RUFBMkM7Ozs7SUFPcEUsQUFERiwrQkFBa0osZUFDMUQ7SUFBOUIseU1BQVMsMEJBQW1CLEtBQUM7SUFBQyx3QkFBd0M7SUFDNUgsZ0NBQThCO0lBQUEsWUFBMkM7SUFDM0UsQUFEMkUsaUJBQU8sRUFDM0U7SUFDUCxnQ0FBd0Y7SUFDeEYsd0JBQStFO0lBQ2pGLEFBRGlGLGlCQUFPLEVBQ2xGOzs7SUFKNEIsZUFBMkM7SUFBM0MsK0RBQTJDO0lBRXJFLGNBQWdFO0lBQWhFLHlGQUFnRTs7O0lBSnhFLGdHQUFrSjs7O0lBbkNwSixBQURGLCtCQUF1RCxhQUM4RDtJQUdqSCxBQUZBLDhFQUFpRix5RUFHakQ7SUFJbEMsaUJBQU07SUFFSixBQURGLDhCQUErQixhQUNFO0lBQzdCLDRHQUcrRDtJQUVqRSxpQkFBTTtJQUNOLCtCQUFxRjtJQUNuRixpRkFBZ0Y7O0lBTXBGLEFBREUsaUJBQU0sRUFDRjtJQVVOLEFBUkEsbUZBRTZELDhFQU1SO0lBU3ZELGlCQUFPOzs7SUE1Q0QsNENBQXVCO0lBRWdCLGVBQXNDO0lBQXRDLDhEQUFzQztJQUV6RCxjQUFzQjtJQUF0Qiw4Q0FBc0I7SUFRdEIsZUFBOEI7SUFBOUIsc0RBQThCO0lBTzNCLGVBQXFDO0lBQXJDLG1GQUFxQztJQVU3RCxlQUF3RDtJQUF4RCxnSkFBd0Q7SUFNM0QsY0FRQztJQVJELHVGQVFDOzs7SUFHRCxBQURGLCtCQUFzRSxjQUM5QjtJQUFBLFlBQ29EO0lBQzVGLEFBRDRGLGlCQUFNLEVBQzVGOzs7SUFGa0MsZUFDb0Q7SUFEcEQsZ0xBQ29EOztBRFo5RixNQUFNLE9BQU8sd0JBQXdCO0lBNkJuQztRQTNCUyxrQkFBYSxHQUF3QixFQUFFLENBQUM7UUFDeEMsb0JBQWUsR0FBWSxLQUFLLENBQUM7UUFDakMsU0FBSSxHQUF1QixRQUFRLENBQUM7UUFDcEMsU0FBSSxHQUF1QixNQUFNLENBQUM7UUFDakMsbUJBQWMsR0FBRyxJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ3RDLHVCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQy9DLGlCQUFZLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ25DLDJCQUFzQixHQUFHLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ3hELG1CQUFjLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ3hDLFlBQU8sR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDaEMsb0JBQWUsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDekMscUJBQWdCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDNUMsaUJBQVksR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDNUMsaUJBQVksR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDcEMsZ0JBQVcsR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDbEMsOEJBQXlCLEdBQUcsS0FBSyxDQUFDO1FBQ2xDLDJCQUFzQixHQUFHLEtBQUssQ0FBQztRQUcvQixXQUFNLEdBQXdCLEVBQUUsQ0FBQztRQUVqQyxlQUFVLEdBQVksS0FBSyxDQUFDO1FBRzVCLG9CQUFlLEdBQVksS0FBSyxDQUFDO1FBQ2pDLFlBQU8sR0FBWSxLQUFLLENBQUM7UUFxTXpCLG1DQUFtQztRQUNuQyxrQkFBYSxHQUFHLENBQUMsQ0FBcUIsRUFBRSxDQUFxQixFQUFVLEVBQUU7WUFDdkUsT0FBTyxDQUFDLENBQUM7UUFDWCxDQUFDLENBQUE7SUF0TWMsQ0FBQztJQUVoQixRQUFRO1FBQ04sSUFBSSxNQUFNLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDbkIsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7UUFDdEIsQ0FBQztRQUNELElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLENBQUM7UUFDNUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7UUFDeEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLGNBQWMsRUFBRSxDQUFDO1FBQ3RELElBQUksQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO1FBQzlCLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO0lBQy9CLENBQUM7SUFFTyxnQkFBZ0I7UUFDdEIsSUFBSSxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7WUFDekIsSUFBSSxDQUFDLHlCQUF5QixHQUFHLElBQUksQ0FBQztZQUN0QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsSUFBSSxDQUFDO1FBQ3JDLENBQUM7YUFBTSxDQUFDO1lBQ04sTUFBTSxtQkFBbUIsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUN6RixJQUFJLENBQUMseUJBQXlCLEdBQUcsbUJBQW1CLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUNsRixJQUFJLENBQUMsc0JBQXNCLEdBQUcsbUJBQW1CLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM5RSxDQUFDO0lBQ0gsQ0FBQztJQUVPLHFCQUFxQjtRQUMzQixJQUFJLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQzlELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1lBQ3ZCLElBQUksaUJBQWlCLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQztZQUN2RSxJQUFJLFdBQVcsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLGlCQUFpQixFQUFFLFVBQVUsUUFBUTtnQkFDNUQsT0FBTyxRQUFRLENBQUMscUJBQXFCLElBQUksUUFBUSxDQUFDLGNBQWMsQ0FBQztZQUNuRSxDQUFDLENBQUMsQ0FBQztZQUNILElBQUksQ0FBQyxXQUFXLENBQUMsV0FBVyxDQUFDLEVBQUUsQ0FBQztnQkFDOUIsSUFBSSxXQUFXLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUM7b0JBQzdCLGdDQUFnQztvQkFDaEMsNkNBQTZDO29CQUM3Qyx5RUFBeUU7b0JBQ3pFLGdJQUFnSTtvQkFDaEksdUNBQXVDO29CQUN2Qyx3RkFBd0Y7b0JBQ3hGLCtDQUErQztvQkFDL0MsUUFBUTtvQkFDUixXQUFXO29CQUNYLDJCQUEyQjtvQkFDM0IsNkNBQTZDO29CQUM3QyxJQUFJO2dCQUNOLENBQUM7WUFDSCxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGlCQUFpQixDQUFDLENBQUM7WUFDOUMsQ0FBQztRQUNILENBQUM7SUFDSCxDQUFDO0lBRU8sbUJBQW1CLENBQUMsaUJBQXdCO1FBQ2xELElBQUksQ0FBQyxNQUFNLEdBQUcsRUFBRSxDQUFDO1FBQ2pCLGlCQUFpQjtRQUNqQixJQUFJLElBQUksR0FBRyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO1FBQ3ZFLE9BQU8sQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLGFBQWtDLEVBQUUsRUFBRTtZQUNoRSxJQUFJLEtBQUssQ0FBQztZQUNWLElBQUksYUFBYSxHQUFHLFNBQVMsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUM3QyxJQUFJLFdBQVcsQ0FBQztZQUNoQixhQUFhLENBQUMsS0FBSyxHQUFHLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxzREFBc0Q7WUFDakcsSUFBSSxhQUFhLENBQUMscUJBQXFCLElBQUksYUFBYSxDQUFDLGNBQWMsRUFBRSxDQUFDO2dCQUN4RSxrRUFBa0U7Z0JBQ2xFLGtDQUFrQztnQkFDbEMsOEJBQThCO2dCQUM5QixvT0FBb087Z0JBQ3BPLFlBQVk7Z0JBQ1osSUFBSTtnQkFDSixrRUFBa0U7Z0JBQ2xFLHdGQUF3RjtnQkFDeEYsdUNBQXVDO2dCQUN2QyxrREFBa0Q7Z0JBQ2xELElBQUk7Z0JBQ0oseUVBQXlFO2dCQUN6RSxxRUFBcUU7Z0JBQ3JFLGlGQUFpRjtnQkFDakYsdUJBQXVCO2dCQUN2QiwwRkFBMEY7Z0JBQzFGLEtBQUs7Z0JBQ0wsOEZBQThGO2dCQUM5Rix3Q0FBd0M7WUFDMUMsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLGFBQWEsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDO2dCQUMvQixNQUFNLGVBQWUsR0FBRyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUM7Z0JBQ25FLEtBQUssR0FBRyxJQUFJLGVBQWUsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxDQUFDO2dCQUN0RCxtQ0FBbUM7Z0JBQ25DLElBQUksS0FBSyxDQUFDLFFBQVEsS0FBSyxLQUFLLENBQUMsV0FBVyxDQUFDLE1BQU0sRUFBRSxDQUFDO29CQUNoRCxLQUFLLENBQUMsVUFBVSxHQUFHLGFBQWEsQ0FBQyxVQUFVLENBQUM7b0JBQzVDLElBQUcsT0FBTyxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO3dCQUNsQyxLQUFLLENBQUMsWUFBWSxHQUFHLEVBQUUsT0FBTyxFQUFFLGFBQWEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUN2RCxDQUFDLE1BQWMsRUFBQyxFQUFFO2dDQUNoQixPQUFPLEVBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFDLENBQUE7NEJBQ3ZDLENBQUMsQ0FBQzt5QkFDSCxDQUFBO29CQUNILENBQUM7Z0JBQ0gsQ0FBQztnQkFDRCxJQUFJLFlBQVksR0FBRyxhQUFhLENBQUMsWUFBWSxJQUFJLEVBQUUsQ0FBQztnQkFDcEQsSUFBRyxLQUFLLENBQUMsUUFBUSxLQUFLLEtBQUssQ0FBQyxXQUFXLENBQUMsUUFBUSxFQUFFLENBQUM7b0JBQ2pELFlBQVksR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUFDLElBQUksYUFBYSxDQUFDLFlBQVksS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQztnQkFDdkosQ0FBQztnQkFDRCxLQUFLLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQztnQkFDbEMsV0FBVyxHQUFHLElBQUksV0FBVyxDQUFDLFlBQVksQ0FBQyxDQUFDO2dCQUM1QyxLQUFLLENBQUMsS0FBSyxHQUFHLGFBQWEsQ0FBQyxLQUFLLENBQUM7Z0JBQ2xDLEtBQUssQ0FBQyxPQUFPLEdBQUcsYUFBYSxDQUFDLE9BQU8sQ0FBQztnQkFDdEMsS0FBSyxDQUFDLFVBQVUsR0FBRztvQkFDakIsUUFBUSxFQUFFLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsSUFBSTtpQkFDL0UsQ0FBQztnQkFDRixLQUFLLENBQUMsUUFBUSxHQUFHLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO2dCQUN0RixJQUFHLEtBQUssQ0FBQyxRQUFRLEtBQUssS0FBSyxDQUFDLFdBQVcsQ0FBQyxRQUFRLEVBQUUsQ0FBQztvQkFDakQsS0FBSyxDQUFDLFFBQVEsR0FBRyxVQUFVLENBQUM7Z0JBQzlCLENBQUM7Z0JBQ0QsSUFBRyxLQUFLLENBQUMsUUFBUSxLQUFLLEtBQUssQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLENBQUM7b0JBQzdDLEtBQUssQ0FBQyxLQUFLLEdBQUcsQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7Z0JBQ2pDLENBQUM7Z0JBQ0QsSUFBRyxJQUFJLENBQUMsZUFBZSxJQUFJLEtBQUssQ0FBQyxRQUFRLEtBQUssS0FBSyxDQUFDLFdBQVcsQ0FBQyxZQUFZLEVBQUUsQ0FBQztvQkFDN0UsS0FBSyxDQUFDLE1BQU0sR0FBRyxFQUFDLEtBQUssRUFBRSxNQUFNLEVBQUMsQ0FBQztnQkFDakMsQ0FBQztnQkFDRCxJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsSUFBSSxhQUFhLENBQUMsS0FBSyxFQUFFLENBQUM7b0JBQ3BFLHVGQUF1RjtvQkFDdkYsNkRBQTZEO29CQUM3RCxJQUFJO29CQUNKLGlDQUFpQztnQkFDbkMsQ0FBQztZQUNILENBQUM7WUFDRCw4QkFBOEI7WUFDOUIsdUxBQXVMO1lBQ3ZMLElBQUksS0FBSyxDQUFDLFFBQVEsS0FBSyxLQUFLLENBQUMsV0FBVyxDQUFDLFFBQVEsSUFBSSxLQUFLLENBQUMsUUFBUSxLQUFLLEtBQUssQ0FBQyxXQUFXLENBQUMsb0JBQW9CLEVBQUUsQ0FBQztnQkFDL0csd0NBQXdDO1lBQzFDLENBQUM7WUFDRCxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUM7WUFDaEMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxXQUFXLENBQUMsQ0FBQztRQUM3RCxDQUFDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ3hELElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztRQUM5QyxJQUFJLENBQUMsbUJBQW1CLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztRQUM3QyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBRU8sc0JBQXNCO1FBQzVCLElBQUksSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ2hELElBQUksS0FBSyxHQUFHLElBQUksaUJBQWlCLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUN6RCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDO1FBQ3hDLENBQUM7SUFDSCxDQUFDO0lBRUQsY0FBYyxDQUFDLE1BQTJCO1FBQ3hDLElBQUksT0FBTyxHQUF3QjtZQUNqQyxLQUFLLEVBQUUsRUFBRTtZQUNULFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixPQUFPLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPO1lBQ25DLGVBQWUsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLEVBQUU7U0FDdkMsQ0FBQztRQUNGLElBQUksSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUNuQyxPQUFPLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDcEMsQ0FBQztRQUNELElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7WUFDMUIsT0FBTyxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQztRQUN2QyxDQUFDO1FBQ0QsNkJBQTZCO1FBQzdCLE9BQU8sQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUM7UUFFckMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLHNCQUFzQixDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDLElBQUksQ0FDM0YsUUFBUSxDQUFDLEdBQUcsRUFBRTtZQUNaLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxPQUFPLEVBQUUsQ0FBQztnQkFDMUIsd0NBQXdDO1lBQzFDLENBQUM7aUJBQU0sQ0FBQztnQkFDTixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQztZQUM5QixDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7WUFDWixJQUFJLEVBQUUsQ0FBQyxJQUFTLEVBQUUsRUFBRTtnQkFDbEIsSUFBSSxVQUFVLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGdCQUFnQixDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQyx3Q0FBd0MsQ0FBQztnQkFDak4sSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUUsU0FBUyxDQUFDLENBQUM7Z0JBQzVELElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO29CQUNqQixJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQzt3QkFDOUIsTUFBTSxFQUFFLDBCQUEwQjt3QkFDbEMsTUFBTSxFQUFFOzRCQUNOLFFBQVEsRUFBRSxTQUFTOzRCQUNuQixNQUFNLEVBQUUsSUFBSTt5QkFDYjtxQkFDRixDQUFDLENBQUE7Z0JBQ0osQ0FBQztnQkFDRCxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxDQUFDO1lBQzdCLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxLQUF3QixFQUFFLEVBQUU7Z0JBQ3JDLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1lBQ25ELENBQUM7U0FDRixDQUFDLENBQUM7SUFFUCxDQUFDO0lBQUEsQ0FBQztJQUVGLFVBQVUsQ0FBQyxLQUFpQjtRQUMxQixLQUFLLENBQUMsZUFBZSxFQUFFLENBQUM7UUFDeEIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDL0IsSUFBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUNqQyxDQUFDO0lBT0QsaUJBQWlCO1FBQ2YsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxxRUFBcUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUNwSSxTQUFTLENBQUMsR0FBRyxFQUFFO1lBQ2IsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxFQUFFLENBQUMsQ0FBQTtRQUM3RSxDQUFDLENBQUMsRUFDRixVQUFVLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDakIsT0FBTyxVQUFVLENBQUMsR0FBRyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDakMsQ0FBQyxDQUFDLENBQ0gsQ0FBQyxTQUFTLENBQUM7WUFDVixJQUFJLEVBQUUsR0FBRyxFQUFFO2dCQUNULElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO2dCQUMvQixJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sRUFBRSxDQUFDO2dCQUMvQixJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLG1EQUFtRCxDQUFDLEVBQUUsU0FBUyxDQUFDLENBQUM7WUFDeEgsQ0FBQyxFQUFFLEtBQUssRUFBRSxDQUFDLENBQThCLEVBQUUsRUFBRTtnQkFDM0MsSUFBSSxDQUFDLFlBQVksaUJBQWlCLEVBQUUsQ0FBQztvQkFDbkMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7Z0JBQy9DLENBQUM7WUFDSCxDQUFDO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzt5SEF4UFUsd0JBQXdCO29FQUF4Qix3QkFBd0Isc1BBTHhCO2dCQUNULGNBQWM7YUFDZjtZQ2pDSCw4QkFBK0I7WUE4QzdCLEFBN0NBLDZFQUF1RCw0REE2Q2U7WUFJeEUsaUJBQU07O1lBakQyQixjQUFzQjtZQUF0QiwyQ0FBc0I7WUE2Q04sY0FBcUI7WUFBckIsMENBQXFCOzRCRFoxRCxZQUFZLG9EQUFFLFdBQVcsaUVBQUUsbUJBQW1CLDZDQUFFLGtCQUFrQixvREFBRSxlQUFlLHlCQUFFLGdCQUFnQjs7aUZBRXBHLHdCQUF3QjtjQVZwQyxTQUFTOzJCQUNFLHFCQUFxQixjQUduQixJQUFJLGFBQ0w7b0JBQ1QsY0FBYztpQkFDZixXQUNRLENBQUMsWUFBWSxFQUFFLFdBQVcsRUFBRSxtQkFBbUIsRUFBRSxrQkFBa0IsRUFBRSxlQUFlLEVBQUUsZ0JBQWdCLENBQUM7b0JBSXZHLGFBQWE7a0JBQXJCLEtBQUs7WUFDRyxlQUFlO2tCQUF2QixLQUFLO1lBQ0csSUFBSTtrQkFBWixLQUFLO1lBQ0csSUFBSTtrQkFBWixLQUFLO1lBQ0ksY0FBYztrQkFBdkIsTUFBTTs7a0ZBTkksd0JBQXdCIiwic291cmNlc0NvbnRlbnQiOlsiLyogQ29weXJpZ2h0IHN0YXJ0XG4gIENvcHlyaWdodCAoQykgMjAwOCAtIDIwMjUgRm9ydGluZXQgSW5jLlxuICBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICBGT1JUSU5FVCBDT05GSURFTlRJQUwgJiBGT1JUSU5FVCBQUk9QUklFVEFSWSBTT1VSQ0UgQ09ERVxuICBDb3B5cmlnaHQgZW5kICovXG5pbXBvcnQgeyBDb21tb25Nb2R1bGUsIEtleVZhbHVlIH0gZnJvbSAnQGFuZ3VsYXIvY29tbW9uJztcbmltcG9ydCB7IEh0dHBFcnJvclJlc3BvbnNlIH0gZnJvbSAnQGFuZ3VsYXIvY29tbW9uL2h0dHAnO1xuaW1wb3J0IHsgQ29tcG9uZW50LCBFdmVudEVtaXR0ZXIsIGluamVjdCwgSW5wdXQsIE9uSW5pdCwgT3V0cHV0IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBGb3JtQnVpbGRlciwgRm9ybUNvbnRyb2wsIEZvcm1Hcm91cCwgRm9ybXNNb2R1bGUsIFJlYWN0aXZlRm9ybXNNb2R1bGUgfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XG5pbXBvcnQgeyBOZ2JBY3RpdmVNb2RhbCwgTmdiVG9vbHRpcE1vZHVsZSB9IGZyb20gJ0BuZy1ib290c3RyYXAvbmctYm9vdHN0cmFwJztcbmltcG9ydCB7IFRyYW5zbG9jb01vZHVsZSwgVHJhbnNsb2NvU2VydmljZSB9IGZyb20gJ0Bqc3ZlcnNlL3RyYW5zbG9jbyc7XG5pbXBvcnQgXywgeyBjbG9uZURlZXAsIGZvckVhY2gsIGlzVW5kZWZpbmVkIH0gZnJvbSAnbG9kYXNoLWVzJztcbmltcG9ydCB7IGlzQXJyYXkgfSBmcm9tICdsb2Rhc2gtZXMnO1xuaW1wb3J0IHsgVG9hc3RyU2VydmljZSB9IGZyb20gJ25neC10b2FzdHInO1xuaW1wb3J0IHsgY2F0Y2hFcnJvciwgZmluYWxpemUsIHN3aXRjaE1hcCwgdGhyb3dFcnJvciB9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHsgWEZGb3JtRmllbGRzTW9kdWxlIH0gZnJvbSAnLi4vLi4vZm9ybS1maWVsZHMvZm9ybS1maWVsZHMubW9kdWxlJztcbmltcG9ydCB7IFBlcm1pc3Npb25TZXJ2aWNlIH0gZnJvbSAnLi4vLi4vY29yZS9zZXJ2aWNlcy9wZXJtaXNzaW9uLnNlcnZpY2UnO1xuaW1wb3J0IHsgVXNlclNlcnZpY2UgfSBmcm9tICcuLi8uLi9jb3JlL3NlcnZpY2VzL3VzZXIuc2VydmljZSc7XG5pbXBvcnQgeyBQZW5kaW5nRGVjaXNpb25TZXJ2aWNlIH0gZnJvbSAnLi4vLi4vY29yZS9zZXJ2aWNlcy9wZW5kaW5nLWRlY2lzaW9uLnNlcnZpY2UnO1xuaW1wb3J0IHsgVXRpbGl0eVNlcnZpY2UgfSBmcm9tICcuLi8uLi9jb3JlL3NlcnZpY2VzL3V0aWxpdHkuc2VydmljZSc7XG5pbXBvcnQgeyBNb2RhbFNlcnZpY2UgfSBmcm9tICcuLi8uLi9jb3JlL3NlcnZpY2VzL21vZGFsLnNlcnZpY2UnO1xuaW1wb3J0IHsgRW50aXR5IH0gZnJvbSAnLi4vLi4vY29yZS9tb2RlbHMvZW50aXR5JztcbmltcG9ydCB7IFJpY2h0ZXh0SFRNTEZpZWxkIH0gZnJvbSAnLi4vLi4vZm9ybS1maWVsZHMvZmllbGQtdHlwZXMvcmljaHRleHQtaHRtbCc7XG5pbXBvcnQgeyBGSVhFRF9NT0RVTEUsIFBFUk1JU1NJT04gfSBmcm9tICcuLi8uLi9jb3JlL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBNb2R1bGVBdHRyaWJ1dGVNYXAgfSBmcm9tICcuLi8uLi9jb3JlL21vZGVscy9hdHRyaWJ1dGUtbWFwJztcbmltcG9ydCB7IEZpZWxkIH0gZnJvbSAnLi4vLi4vY29yZS9tb2RlbHMvZmllbGQnO1xuaW1wb3J0IHsgRW1iZWRTZXJ2aWNlLCBFbWJlZFdpbmRvdyB9IGZyb20gJy4uLy4uL2NvcmUvc2VydmljZXMvZW1iZWQuc2VydmljZSc7XG5cblxuZGVjbGFyZSBsZXQgd2luZG93OiBFbWJlZFdpbmRvdztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAneGYtcGVuZGluZy1kZWNpc2lvbicsXG4gIHRlbXBsYXRlVXJsOiAnLi9wZW5kaW5nLWRlY2lzaW9uLmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vcGVuZGluZy1kZWNpc2lvbi5jb21wb25lbnQuc2NzcyddLFxuICBzdGFuZGFsb25lOiB0cnVlLFxuICBwcm92aWRlcnM6IFtcbiAgICBOZ2JBY3RpdmVNb2RhbCxcbiAgXSxcbiAgaW1wb3J0czogW0NvbW1vbk1vZHVsZSwgRm9ybXNNb2R1bGUsIFJlYWN0aXZlRm9ybXNNb2R1bGUsIFhGRm9ybUZpZWxkc01vZHVsZSwgVHJhbnNsb2NvTW9kdWxlLCBOZ2JUb29sdGlwTW9kdWxlXVxufSlcbmV4cG9ydCBjbGFzcyBQZW5kaW5nRGVjaXNpb25Db21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xuXG4gIEBJbnB1dCgpIGRlY2lzaW9uSW5wdXQ6IFJlY29yZDxzdHJpbmcsIGFueT4gPSB7fTtcbiAgQElucHV0KCkgdW5hdXRoZW50aWNhdGVkOiBib29sZWFuID0gZmFsc2U7XG4gIEBJbnB1dCgpIHR5cGU6ICdpbmxpbmUnIHwgJ21vZGFsJyA9ICdpbmxpbmUnO1xuICBASW5wdXQoKSBtb2RlOiAncHJldmlldycgfCAnZWRpdCcgPSAnZWRpdCc7XG4gIEBPdXRwdXQoKSBzdWJtaXRSZXNwb25zZSA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcbiAgcHJpdmF0ZSBwZXJtaXNzaW9uc1NlcnZpY2UgPSBpbmplY3QoUGVybWlzc2lvblNlcnZpY2UpO1xuICBwcml2YXRlIHVzZXJzU2VydmljZSA9IGluamVjdChVc2VyU2VydmljZSk7XG4gIHByaXZhdGUgcGVuZGluZ0RlY2lzaW9uU2VydmljZSA9IGluamVjdChQZW5kaW5nRGVjaXNpb25TZXJ2aWNlKTtcbiAgcHJpdmF0ZSB1dGlsaXR5U2VydmljZSA9IGluamVjdChVdGlsaXR5U2VydmljZSk7XG4gIHByaXZhdGUgdG9hc3RlciA9IGluamVjdChUb2FzdHJTZXJ2aWNlKTtcbiAgcHJpdmF0ZSBhY3RpdmVPZmZDYW52YXMgPSBpbmplY3QoTmdiQWN0aXZlTW9kYWwpO1xuICBwcml2YXRlIHRyYW5zbG9jb1NlcnZpY2UgPSBpbmplY3QoVHJhbnNsb2NvU2VydmljZSk7XG4gIHByaXZhdGUgZW1iZWRTZXJ2aWNlID0gaW5qZWN0KEVtYmVkU2VydmljZSk7XG4gIG1vZGFsU2VydmljZSA9IGluamVjdChNb2RhbFNlcnZpY2UpO1xuICBmb3JtQnVpbGRlciA9IGluamVjdChGb3JtQnVpbGRlcik7XG4gIHBsYXlib29rRXhlY3V0ZVBlcm1pc3Npb24gPSBmYWxzZTtcbiAgcGxheWJvb2tSZWFkUGVybWlzc2lvbiA9IGZhbHNlO1xuICBjdXJyZW50VXNlcjogYW55O1xuICBlbnRpdHk6IGFueTtcbiAgZmllbGRzOiBSZWNvcmQ8c3RyaW5nLCBhbnk+ID0ge307XG4gIGlucHV0VmFyaWFibGVFbnRpdHk/OiBFbnRpdHk7XG4gIHByb2Nlc3Npbmc6IGJvb2xlYW4gPSBmYWxzZTtcbiAgZm9ybUdyb3VwITogRm9ybUdyb3VwO1xuICBkZWNpc2lvbkRlc2NyaXB0aW9uRmllbGQ/OiBSaWNodGV4dEhUTUxGaWVsZDtcbiAgcGxheWJvb2tSZXN1bWVkOiBib29sZWFuID0gZmFsc2U7XG4gIGlzRW1iZWQ6IGJvb2xlYW4gPSBmYWxzZTtcblxuICBjb25zdHJ1Y3RvcigpIHt9XG5cbiAgbmdPbkluaXQoKTogdm9pZCB7XG4gICAgaWYgKHdpbmRvdy5pc0VtYmVkKSB7XG4gICAgICB0aGlzLmlzRW1iZWQgPSB0cnVlO1xuICAgIH1cbiAgICB0aGlzLmZvcm1Hcm91cCA9IHRoaXMuZm9ybUJ1aWxkZXIuZ3JvdXAoe30pO1xuICAgIHRoaXMuY2hlY2tQZXJtaXNzaW9ucygpO1xuICAgIHRoaXMuY3VycmVudFVzZXIgPSB0aGlzLnVzZXJzU2VydmljZS5nZXRDdXJyZW50VXNlcigpO1xuICAgIHRoaXMuY3JlYXRlRGVzY3JpcHRpb25GaWVsZCgpO1xuICAgIHRoaXMuaW5pdGlhbGl6ZUlucHV0UGFyYW1zKCk7XG4gIH1cblxuICBwcml2YXRlIGNoZWNrUGVybWlzc2lvbnMoKSB7XG4gICAgaWYgKHRoaXMudW5hdXRoZW50aWNhdGVkKSB7XG4gICAgICB0aGlzLnBsYXlib29rRXhlY3V0ZVBlcm1pc3Npb24gPSB0cnVlO1xuICAgICAgdGhpcy5wbGF5Ym9va1JlYWRQZXJtaXNzaW9uID0gdHJ1ZTtcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3QgcGxheWJvb2tQZXJtaXNzaW9ucyA9IHRoaXMucGVybWlzc2lvbnNTZXJ2aWNlLmdldFBlcm1pc3Npb24oRklYRURfTU9EVUxFLlBMQVlCT09LKTtcbiAgICAgIHRoaXMucGxheWJvb2tFeGVjdXRlUGVybWlzc2lvbiA9IHBsYXlib29rUGVybWlzc2lvbnMuaW5jbHVkZXMoUEVSTUlTU0lPTi5FWEVDVVRFKTtcbiAgICAgIHRoaXMucGxheWJvb2tSZWFkUGVybWlzc2lvbiA9IHBsYXlib29rUGVybWlzc2lvbnMuaW5jbHVkZXMoUEVSTUlTU0lPTi5SRUFEKTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGluaXRpYWxpemVJbnB1dFBhcmFtcygpIHtcbiAgICBpZiAodGhpcy5kZWNpc2lvbklucHV0LmlucHV0LnNjaGVtYS5pbnB1dFZhcmlhYmxlcy5sZW5ndGggPiAwKSB7XG4gICAgICB0aGlzLnByb2Nlc3NpbmcgPSB0cnVlO1xuICAgICAgbGV0IHN0ZXBEYXRhVmFyaWFibGVzID0gdGhpcy5kZWNpc2lvbklucHV0LmlucHV0LnNjaGVtYS5pbnB1dFZhcmlhYmxlcztcbiAgICAgIHZhciBtb2R1bGVGaWVsZCA9IF8uZmluZChzdGVwRGF0YVZhcmlhYmxlcywgZnVuY3Rpb24gKHZhcmlhYmxlKSB7XG4gICAgICAgIHJldHVybiB2YXJpYWJsZS51c2VSZWNvcmRGaWVsZERlZmF1bHQgfHwgdmFyaWFibGUudXNlTW9kdWxlRmllbGQ7XG4gICAgICB9KTtcbiAgICAgIGlmICghaXNVbmRlZmluZWQobW9kdWxlRmllbGQpKSB7XG4gICAgICAgIGlmIChpc1VuZGVmaW5lZCh0aGlzLmVudGl0eSkpIHtcbiAgICAgICAgICAvL1RPRE86IEluIGNhc2Ugb2YgcmVjb3JkIGZpZWxkc1xuICAgICAgICAgIC8vdmFyIHJlY29yZEVudGl0eSA9IEZvcm1FbnRpdHlTZXJ2aWNlLmdldCgpO1xuICAgICAgICAgIC8vdmFyIHJlY29yZE1vZHVsZSA9ICRmaWx0ZXIoJ2dldE1vZHVsZU5hbWUnKSh0aGlzLmRlY2lzaW9uSW5wdXQucmVjb3JkKTtcbiAgICAgICAgICAvLyBpZiAocmVjb3JkRW50aXR5ICYmIHJlY29yZEVudGl0eS5tb2R1bGUgPT09IHJlY29yZE1vZHVsZSAmJiBhbmd1bGFyLmVxdWFscyh7fSwgcmVjb3JkRW50aXR5Lm9yaWdpbmFsRGF0YSkgfHwgIXJlY29yZEVudGl0eSkge1xuICAgICAgICAgIC8vICAgZW50aXR5ID0gbmV3IEVudGl0eShyZWNvcmRNb2R1bGUpO1xuICAgICAgICAgIC8vICAgZW50aXR5LmdldCgkZmlsdGVyKCdnZXRFbmRQYXRoTmFtZScpKHRoaXMuZGVjaXNpb25JbnB1dC5yZWNvcmQpKS50aGVuKGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAvLyAgICAgX3ByZXBhcmVWYXJpYWJsZURhdGEoc3RlcERhdGFWYXJpYWJsZXMpO1xuICAgICAgICAgIC8vICAgfSk7XG4gICAgICAgICAgLy8gfSBlbHNlIHtcbiAgICAgICAgICAvLyAgIGVudGl0eSA9IHJlY29yZEVudGl0eTtcbiAgICAgICAgICAvLyAgIF9wcmVwYXJlVmFyaWFibGVEYXRhKHN0ZXBEYXRhVmFyaWFibGVzKTtcbiAgICAgICAgICAvLyB9XG4gICAgICAgIH1cbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRoaXMucHJlcGFyZVZhcmlhYmxlRGF0YShzdGVwRGF0YVZhcmlhYmxlcyk7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBwcmVwYXJlVmFyaWFibGVEYXRhKHN0ZXBEYXRhVmFyaWFibGVzOiBhbnlbXSkge1xuICAgIHRoaXMuZmllbGRzID0ge307XG4gICAgLy92YXIgZmlyc3RGaWVsZDtcbiAgICBsZXQgcm93cyA9ICFpc1VuZGVmaW5lZCh0aGlzLmVudGl0eSkgPyBbdGhpcy5lbnRpdHkub3JpZ2luYWxEYXRhXSA6IFtdO1xuICAgIGZvckVhY2goc3RlcERhdGFWYXJpYWJsZXMsIChpbnB1dFZhcmlhYmxlOiBSZWNvcmQ8c3RyaW5nLCBhbnk+KSA9PiB7XG4gICAgICBsZXQgZmllbGQ7XG4gICAgICBsZXQgZmllbGRNZXRhZGF0YSA9IGNsb25lRGVlcChpbnB1dFZhcmlhYmxlKTtcbiAgICAgIGxldCBmb3JtQ29udHJvbDtcbiAgICAgIGZpZWxkTWV0YWRhdGEudGl0bGUgPSBmaWVsZE1ldGFkYXRhLmxhYmVsOyAvLyB8fCAkZmlsdGVyKCdjYW1lbENhc2VUb0h1bWFuJykoaW5wdXRWYXJpYWJsZS5uYW1lKTtcbiAgICAgIGlmIChpbnB1dFZhcmlhYmxlLnVzZVJlY29yZEZpZWxkRGVmYXVsdCB8fCBpbnB1dFZhcmlhYmxlLnVzZU1vZHVsZUZpZWxkKSB7XG4gICAgICAgIC8vIGZpZWxkID0gYW5ndWxhci5jb3B5KGVudGl0eS5maWVsZHNbaW5wdXRWYXJpYWJsZS5tb2R1bGVGaWVsZF0pO1xuICAgICAgICAvLyBpZihhbmd1bGFyLmlzVW5kZWZpbmVkKGZpZWxkKSl7XG4gICAgICAgIC8vICAgc2NvcGUucHJvY2Vzc2luZyA9IGZhbHNlO1xuICAgICAgICAvLyAgIHNjb3BlLmVycm9yID0gJzxzcGFuIGNsYXNzPVwiZmEgZmEtZXhjbGFtYXRpb24tdHJpYW5nbGUgd2FybmluZy1pY29uIGZvbnQtc2l6ZS0xMFwiPjwvc3Bhbj4gPHNwYW4gY2xhc3M9XCJmb250LWJvbGQgZm9udC1pdGFsaWNcIj4nK2lucHV0VmFyaWFibGUudGl0bGUgKyAnIDwvc3Bhbj4gZmllbGQgbm90IGZvdW5kIGluICcgKyBlbnRpdHkuZGVzY3JpcHRpb25zLnBsdXJhbCArICcgbW9kdWxlLic7XG4gICAgICAgIC8vICAgcmV0dXJuO1xuICAgICAgICAvLyB9XG4gICAgICAgIC8vIHZhciBjb21tb25WYWx1ZSA9IENvbW1vblV0aWxzLmdldENvbW1vblZhbHVlKHJvd3MsIGZpZWxkLm5hbWUpO1xuICAgICAgICAvLyBmaWVsZC52YWx1ZSA9IGZpZWxkLnR5cGUgPT09ICdkYXRldGltZScgPyBuZXcgRGF0ZShjb21tb25WYWx1ZSAqIDEwMDApIDogY29tbW9uVmFsdWU7XG4gICAgICAgIC8vIGlmIChhbmd1bGFyLmlzT2JqZWN0KGNvbW1vblZhbHVlKSkge1xuICAgICAgICAvLyAgIGZpZWxkLnZhbHVlLmRpc3BsYXkgPSBmaWVsZC5nZXRFeHBvcnRWYWx1ZSgpO1xuICAgICAgICAvLyB9XG4gICAgICAgIC8vIGZpZWxkLnRpdGxlID0gaW5wdXRWYXJpYWJsZS50aXRsZSA/IGlucHV0VmFyaWFibGUudGl0bGUgOiBmaWVsZC50aXRsZTtcbiAgICAgICAgLy8gZmllbGQubmFtZSA9IGlucHV0VmFyaWFibGUubmFtZSA/IGlucHV0VmFyaWFibGUubmFtZSA6IGZpZWxkLm5hbWU7XG4gICAgICAgIC8vIGZpZWxkLnRvb2x0aXAgPSBpbnB1dFZhcmlhYmxlLnRvb2x0aXAgPyBpbnB1dFZhcmlhYmxlLnRvb2x0aXAgOiBmaWVsZC50b29sdGlwO1xuICAgICAgICAvLyBmaWVsZC52YWxpZGF0aW9uID0ge1xuICAgICAgICAvLyAgICdyZXF1aXJlZCc6IGFuZ3VsYXIuaXNEZWZpbmVkKGlucHV0VmFyaWFibGUucmVxdWlyZWQpID8gaW5wdXRWYXJpYWJsZS5yZXF1aXJlZCA6IHRydWVcbiAgICAgICAgLy8gfTtcbiAgICAgICAgLy8gZmllbGQucmVxdWlyZWQgPSBhbmd1bGFyLmlzRGVmaW5lZChpbnB1dFZhcmlhYmxlLnJlcXVpcmVkKSA/IGlucHV0VmFyaWFibGUucmVxdWlyZWQgOiB0cnVlO1xuICAgICAgICAvLyBmaWVsZC5idXR0b25DbGFzc2VzID0gJ2J0biBidG4tbGluayc7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBmaWVsZE1ldGFkYXRhLndyaXRlYWJsZSA9IHRydWU7XG4gICAgICAgIGNvbnN0IGZpZWxkQXR0cmlidXRlcyA9IE1vZHVsZUF0dHJpYnV0ZU1hcFtmaWVsZE1ldGFkYXRhLmZvcm1UeXBlXTtcbiAgICAgICAgZmllbGQgPSBuZXcgZmllbGRBdHRyaWJ1dGVzLmZpZWxkKGZpZWxkTWV0YWRhdGEubmFtZSk7XG4gICAgICAgIC8vZmllbGQgPSBuZXcgRmllbGQoaW5wdXRWYXJpYWJsZSk7XG4gICAgICAgIGlmIChmaWVsZC5mb3JtVHlwZSA9PT0gRmllbGQuQnVpbHRJblR5cGUuU0VMRUNUKSB7XG4gICAgICAgICAgZmllbGQuaXNNdWx0aXBsZSA9IGZpZWxkTWV0YWRhdGEuaXNNdWx0aXBsZTtcbiAgICAgICAgICBpZihpc0FycmF5KGZpZWxkTWV0YWRhdGEub3B0aW9ucykpIHtcbiAgICAgICAgICAgIGZpZWxkLmZpZWxkT3B0aW9ucyA9IHsgb3B0aW9uczogZmllbGRNZXRhZGF0YS5vcHRpb25zLm1hcChcbiAgICAgICAgICAgICAgKG9wdGlvbjogc3RyaW5nKT0+IHtcbiAgICAgICAgICAgICAgICByZXR1cm4ge2xhYmVsOiBvcHRpb24sIHZhbHVlOiBvcHRpb259XG4gICAgICAgICAgICAgIH0pXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIGxldCBkZWZhdWx0VmFsdWUgPSBpbnB1dFZhcmlhYmxlLmRlZmF1bHRWYWx1ZSB8fCAnJztcbiAgICAgICAgaWYoZmllbGQuZm9ybVR5cGUgPT09IEZpZWxkLkJ1aWx0SW5UeXBlLkNIRUNLQk9YKSB7XG4gICAgICAgICAgZGVmYXVsdFZhbHVlID0gdGhpcy51dGlsaXR5U2VydmljZS5pc1VuZGVmaW5lZChpbnB1dFZhcmlhYmxlLmRlZmF1bHRWYWx1ZSkgfHwgaW5wdXRWYXJpYWJsZS5kZWZhdWx0VmFsdWUgPT09ICcnID8gZmFsc2UgOiBpbnB1dFZhcmlhYmxlLmRlZmF1bHRWYWx1ZTtcbiAgICAgICAgfVxuICAgICAgICBmaWVsZC5kZWZhdWx0VmFsdWUgPSBkZWZhdWx0VmFsdWU7XG4gICAgICAgIGZvcm1Db250cm9sID0gbmV3IEZvcm1Db250cm9sKGRlZmF1bHRWYWx1ZSk7XG4gICAgICAgIGZpZWxkLnRpdGxlID0gaW5wdXRWYXJpYWJsZS5sYWJlbDtcbiAgICAgICAgZmllbGQudG9vbHRpcCA9IGZpZWxkTWV0YWRhdGEudG9vbHRpcDtcbiAgICAgICAgZmllbGQudmFsaWRhdGlvbiA9IHtcbiAgICAgICAgICByZXF1aXJlZDogIWlzVW5kZWZpbmVkKGZpZWxkTWV0YWRhdGEucmVxdWlyZWQpID8gZmllbGRNZXRhZGF0YS5yZXF1aXJlZCA6IHRydWVcbiAgICAgICAgfTtcbiAgICAgICAgZmllbGQucmVxdWlyZWQgPSAhaXNVbmRlZmluZWQoZmllbGRNZXRhZGF0YS5yZXF1aXJlZCkgPyBmaWVsZE1ldGFkYXRhLnJlcXVpcmVkIDogdHJ1ZTtcbiAgICAgICAgaWYoZmllbGQuZm9ybVR5cGUgPT09IEZpZWxkLkJ1aWx0SW5UeXBlLkNIRUNLQk9YKSB7XG4gICAgICAgICAgZmllbGQudmlld01vZGUgPSAnY2hlY2tib3gnO1xuICAgICAgICB9XG4gICAgICAgIGlmKGZpZWxkLmZvcm1UeXBlID09PSBGaWVsZC5CdWlsdEluVHlwZS5KU09OKSB7XG4gICAgICAgICAgZmllbGQubW9kZXMgPSBbJ2NvZGUnLCAndmlldyddO1xuICAgICAgICB9XG4gICAgICAgIGlmKHRoaXMudW5hdXRoZW50aWNhdGVkICYmIGZpZWxkLmZvcm1UeXBlID09PSBGaWVsZC5CdWlsdEluVHlwZS5SSUNIVEVYVEhUTUwpIHtcbiAgICAgICAgICBmaWVsZC5wYXJhbXMgPSB7dGhlbWU6ICdkYXJrJ307XG4gICAgICAgIH1cbiAgICAgICAgaWYgKGZpZWxkLmZvcm1UeXBlLmluZGV4T2YoJ2RhdGV0aW1lJykgPT09IDAgJiYgZmllbGRNZXRhZGF0YS52YWx1ZSkge1xuICAgICAgICAgIC8vIGlmIChhbmd1bGFyLmlzT2JqZWN0KGZpZWxkLnZhbHVlKSAmJiBmaWVsZC52YWx1ZS5oYXNPd25Qcm9wZXJ0eSgnZGlmZmVyZW5jZVR5cGUnKSkge1xuICAgICAgICAgIC8vICAgZmllbGQudmFsdWUgPSBjb252ZXJ0VG9SZWxhdGl2ZURhdGVTZXJ2aWNlKGZpZWxkLnZhbHVlKTtcbiAgICAgICAgICAvLyB9XG4gICAgICAgICAgLy8gZXZhbHVhdGVEYXRlRmllbGRWYWx1ZShmaWVsZCk7XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICAgIC8vIFRPRE86IFZpc2liaWxpdHkgY29uZGl0aW9uc1xuICAgICAgLy9maWVsZC52aXNpYmlsaXR5ID0gaW5wdXRWYXJpYWJsZS52aXNpYmlsaXR5UXVlcnkgJiYgaW5wdXRWYXJpYWJsZS52aXNpYmlsaXR5UXVlcnkuZmlsdGVycyAmJiBpbnB1dFZhcmlhYmxlLnZpc2liaWxpdHlRdWVyeS5maWx0ZXJzLmxlbmd0aCA+IDAgPyBpbnB1dFZhcmlhYmxlLnZpc2liaWxpdHlRdWVyeSA6IHRydWU7XG4gICAgICBpZiAoZmllbGQuZm9ybVR5cGUgPT09IEZpZWxkLkJ1aWx0SW5UeXBlLlBJQ0tMSVNUIHx8IGZpZWxkLmZvcm1UeXBlID09PSBGaWVsZC5CdWlsdEluVHlwZS5NVUxUSVNFTEVDVF9QSUNLTElTVCkge1xuICAgICAgICAvL3BpY2tsaXN0c1NlcnZpY2UubG9hZFBpY2tsaXN0cyhmaWVsZCk7XG4gICAgICB9XG4gICAgICB0aGlzLmZpZWxkc1tmaWVsZC5uYW1lXSA9IGZpZWxkO1xuICAgICAgdGhpcy5mb3JtR3JvdXAuYWRkQ29udHJvbChmaWVsZE1ldGFkYXRhLm5hbWUsIGZvcm1Db250cm9sKTtcbiAgICB9KTtcbiAgICB0aGlzLmlucHV0VmFyaWFibGVFbnRpdHkgPSBuZXcgRW50aXR5KCdpbnB1dFZhcmlhYmxlcycpO1xuICAgIHRoaXMuaW5wdXRWYXJpYWJsZUVudGl0eS5maWVsZHMgPSB0aGlzLmZpZWxkcztcbiAgICB0aGlzLmlucHV0VmFyaWFibGVFbnRpdHkuZXZhbHVhdGVBbGxGaWVsZHMoKTtcbiAgICB0aGlzLnByb2Nlc3NpbmcgPSBmYWxzZTtcbiAgfVxuXG4gIHByaXZhdGUgY3JlYXRlRGVzY3JpcHRpb25GaWVsZCgpIHtcbiAgICBpZiAodGhpcy5kZWNpc2lvbklucHV0LmlucHV0LnNjaGVtYS5kZXNjcmlwdGlvbikge1xuICAgICAgbGV0IGZpZWxkID0gbmV3IFJpY2h0ZXh0SFRNTEZpZWxkKCdkZWNpc2lvbkRlc2NyaXB0aW9uJyk7XG4gICAgICB0aGlzLmRlY2lzaW9uRGVzY3JpcHRpb25GaWVsZCA9IGZpZWxkO1xuICAgIH1cbiAgfVxuXG4gIHN1Ym1pdERlY2lzaW9uKG9wdGlvbjogUmVjb3JkPHN0cmluZywgYW55Pikge1xuICAgIGxldCBwYXlsb2FkOiBSZWNvcmQ8c3RyaW5nLCBhbnk+ID0ge1xuICAgICAgaW5wdXQ6IHt9LFxuICAgICAgc3RlcF91dWlkOiBvcHRpb24uc3RlcF91dWlkLFxuICAgICAgc3RlcF9pZDogdGhpcy5kZWNpc2lvbklucHV0LnN0ZXBfaWQsXG4gICAgICBtYW51YWxfaW5wdXRfaWQ6IHRoaXMuZGVjaXNpb25JbnB1dC5pZFxuICAgIH07XG4gICAgaWYgKHRoaXMuZGVjaXNpb25JbnB1dC5pc19hcHByb3ZhbCkge1xuICAgICAgcGF5bG9hZC5hcHByb3ZlZCA9IG9wdGlvbi5wcmltYXJ5O1xuICAgIH1cbiAgICBpZiAoIXRoaXMudW5hdXRoZW50aWNhdGVkKSB7XG4gICAgICBwYXlsb2FkLnVzZXIgPSB0aGlzLmN1cnJlbnRVc2VyLnV1aWQ7XG4gICAgfVxuICAgIC8vIEFkZCBmb3JtIHZhbHVlcyB0byBwYXlsb2FkXG4gICAgcGF5bG9hZC5pbnB1dCA9IHRoaXMuZm9ybUdyb3VwLnZhbHVlO1xuXG4gICAgdGhpcy5wZW5kaW5nRGVjaXNpb25TZXJ2aWNlLnJlc3VtZUF3YWl0aW5nUGxheWJvb2socGF5bG9hZCwgdGhpcy5kZWNpc2lvbklucHV0LndvcmtmbG93KS5waXBlKFxuICAgICAgZmluYWxpemUoKCkgPT4ge1xuICAgICAgICBpZiAodGhpcy50eXBlID09PSAnbW9kYWwnKSB7XG4gICAgICAgICAgLy90aGlzLmFjdGl2ZU9mZkNhbnZhcy5jbG9zZSgncmVzdW1lZCcpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHRoaXMucGxheWJvb2tSZXN1bWVkID0gdHJ1ZTtcbiAgICAgICAgfVxuICAgICAgfSkpLnN1YnNjcmliZSh7XG4gICAgICAgIG5leHQ6IChkYXRhOiBhbnkpID0+IHtcbiAgICAgICAgICBsZXQgc3VjY2Vzc01zZyA9IHRoaXMudXRpbGl0eVNlcnZpY2UuaXNVbmRlZmluZWQodGhpcy5kZWNpc2lvbklucHV0LnJlc3BvbnNlX21hcHBpbmcuY3VzdG9tU3VjY2Vzc01lc3NhZ2UpID8gdGhpcy5kZWNpc2lvbklucHV0LnJlc3BvbnNlX21hcHBpbmcuY3VzdG9tU3VjY2Vzc01lc3NhZ2UgOiAnQXdhaXRpbmcgUGxheWJvb2sgcmVzdW1lZCBzdWNjZXNzZnVsbHknO1xuICAgICAgICAgIHRoaXMudG9hc3Rlci5zdWNjZXNzKHN1Y2Nlc3NNc2cgfHwgZGF0YS5tZXNzYWdlLCAnU3VjY2VzcycpO1xuICAgICAgICAgIGlmICh0aGlzLmlzRW1iZWQpIHsgXG4gICAgICAgICAgICB0aGlzLmVtYmVkU2VydmljZS5zZW5kRXZlbnREYXRhKHtcbiAgICAgICAgICAgICAgJ3R5cGUnOiAnWEZfTUFOVUFMX0lOUFVUX1JFU1BPTlNFJyxcbiAgICAgICAgICAgICAgJ2RhdGEnOiB7XG4gICAgICAgICAgICAgICAgJ3N0YXR1cyc6ICdzdWNjZXNzJyxcbiAgICAgICAgICAgICAgICAnZGF0YSc6IGRhdGFcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSlcbiAgICAgICAgICB9XG4gICAgICAgICAgdGhpcy5zdWJtaXRSZXNwb25zZS5lbWl0KCk7XG4gICAgICAgIH0sIGVycm9yOiAoZXJyb3I6IEh0dHBFcnJvclJlc3BvbnNlKSA9PiB7XG4gICAgICAgICAgdGhpcy50b2FzdGVyLmVycm9yKGVycm9yLmVycm9yLm1lc3NhZ2UsICdFcnJvcicpO1xuICAgICAgICB9XG4gICAgICB9KTtcblxuICB9O1xuXG4gIGNsb3NlUG9wdXAoZXZlbnQ6IE1vdXNlRXZlbnQpIHtcbiAgICBldmVudC5zdG9wUHJvcGFnYXRpb24oKTtcbiAgICB0aGlzLnN1Ym1pdFJlc3BvbnNlLmVtaXQodHJ1ZSk7XG4gICAgdGhpcy5hY3RpdmVPZmZDYW52YXMuZGlzbWlzcygpO1xuICB9XG5cbiAgLy8gUHJlc2VydmUgb3JpZ2luYWwgcHJvcGVydHkgb3JkZXJcbiAgb3JpZ2luYWxPcmRlciA9IChhOiBLZXlWYWx1ZTxhbnksIGFueT4sIGI6IEtleVZhbHVlPGFueSwgYW55Pik6IG51bWJlciA9PiB7XG4gICAgcmV0dXJuIDA7XG4gIH1cblxuICBkZWxldGVNYW51YWxJbnB1dCgpIHtcbiAgICB0aGlzLm1vZGFsU2VydmljZS5jb25maXJtKHRoaXMudHJhbnNsb2NvU2VydmljZS50cmFuc2xhdGUoJ05PVElGSUNBVElPTlMuTUFOVUFMX0lOUFVUX0RFTEVURV9OT1RJRklDQVRJT05fQ09ORklSTUFUSU9OX01FU1NBR0UnKSkucGlwZShcbiAgICAgIHN3aXRjaE1hcCgoKSA9PiB7XG4gICAgICAgIHJldHVybiB0aGlzLnBlbmRpbmdEZWNpc2lvblNlcnZpY2UuZGVsZXRlTWFudWFsSW5wdXQodGhpcy5kZWNpc2lvbklucHV0LmlkKVxuICAgICAgfSksXG4gICAgICBjYXRjaEVycm9yKGVycm9yID0+IHtcbiAgICAgICAgcmV0dXJuIHRocm93RXJyb3IoKCkgPT4gZXJyb3IpO1xuICAgICAgfSlcbiAgICApLnN1YnNjcmliZSh7XG4gICAgICBuZXh0OiAoKSA9PiB7XG4gICAgICAgIHRoaXMuc3VibWl0UmVzcG9uc2UuZW1pdCh0cnVlKTtcbiAgICAgICAgdGhpcy5hY3RpdmVPZmZDYW52YXMuZGlzbWlzcygpO1xuICAgICAgICB0aGlzLnRvYXN0ZXIuc3VjY2Vzcyh0aGlzLnRyYW5zbG9jb1NlcnZpY2UudHJhbnNsYXRlKCdOT1RJRklDQVRJT05TLk1BTlVBTF9JTlBVVF9ERUxFVEVfU1VDQ0VTU19NRVNTQUdFJyksICdTdWNjZXNzJyk7XG4gICAgICB9LCBlcnJvcjogKGU6IEh0dHBFcnJvclJlc3BvbnNlIHwgYm9vbGVhbikgPT4geyAvLyByZXR1cm4gZmFsc2UgaW4gY2FzZSBvZiBjYW5jZWwgY29uZmlybWF0aW9uXG4gICAgICAgIGlmIChlIGluc3RhbmNlb2YgSHR0cEVycm9yUmVzcG9uc2UpIHtcbiAgICAgICAgICB0aGlzLnRvYXN0ZXIuZXJyb3IoZS5lcnJvci5tZXNzYWdlLCAnRXJyb3InKTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0pO1xuICB9XG5cbn1cbiIsIjwhLS0gQ29weXJpZ2h0IHN0YXJ0XG4gIENvcHlyaWdodCAoQykgMjAwOCAtIDIwMjUgRm9ydGluZXQgSW5jLlxuICBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICBGT1JUSU5FVCBDT05GSURFTlRJQUwgJiBGT1JUSU5FVCBQUk9QUklFVEFSWSBTT1VSQ0UgQ09ERVxuICBDb3B5cmlnaHQgZW5kIC0tPlxuPGRpdiBjbGFzcz1cInBvc2l0aW9uLXJlbGF0aXZlXCI+XG4gIDxmb3JtIFtmb3JtR3JvdXBdPVwiZm9ybUdyb3VwXCIgKm5nSWY9XCIhcGxheWJvb2tSZXN1bWVkXCI+XG4gICAgPGRpdiBjbGFzcz1cIm1vZGFsLWhlYWRlciBwYWRkaW5nLWJvdHRvbS04cHggcGFkZGluZy1sZWZ0LTEycHggcGFkZGluZy1yaWdodC0xNnB4IHBhZGRpbmctdG9wLThweCBtb2RhbC1jbG9zZS1sZWZ0XCI+XG4gICAgICA8aDQgY2xhc3M9XCJwYWdlLXRpdGxlLWZvbnQgbW9kYWwtdGl0bGVcIiAqbmdJZj1cImRlY2lzaW9uSW5wdXQuaW5wdXQuc2NoZW1hLnRpdGxlXCI+XG4gICAgICAgIHt7ZGVjaXNpb25JbnB1dC5pbnB1dC5zY2hlbWEudGl0bGV9fTwvaDQ+XG4gICAgICA8YnV0dG9uIHlwZT1cImJ1dHRvblwiICpuZ0lmPVwidHlwZSA9PT0gJ21vZGFsJ1wiIGFyaWEtbGFiZWw9XCJDbG9zZVwiIGNsYXNzPVwiYnRuIGJ0bi1zbSBtcy1hdXRvXCJcbiAgICAgICAgKGNsaWNrKT1cImNsb3NlUG9wdXAoJGV2ZW50KTtcIj5cbiAgICAgICAgPGkgY2xhc3M9XCJmYSBmYS1jbG9zZVwiPjwvaT5cbiAgICAgIDwvYnV0dG9uPlxuXG4gICAgPC9kaXY+XG4gICAgPGRpdiBjbGFzcz1cImgtYXV0byBtb2RhbC1ib2R5XCI+XG4gICAgICA8ZGl2IGNsYXNzPVwicGFkZGluZy1sZWZ0LTEycHhcIj5cbiAgICAgICAgPHhmLWVkaXRhYmxlLWZpZWxkICpuZ0lmPVwiZGVjaXNpb25EZXNjcmlwdGlvbkZpZWxkXCIgW2ZpZWxkXT1cImRlY2lzaW9uRGVzY3JpcHRpb25GaWVsZFwiIGNsYXNzPVwiZC1ibG9ja1wiXG4gICAgICAgICAgW25nQ2xhc3NdPVwieyAnbWFyZ2luLWJvdHRvbS0xMnB4JyA6IGRlY2lzaW9uSW5wdXQuaW5wdXQuc2NoZW1hLmlucHV0VmFyaWFibGVzPy5sZW5ndGggPT09IDAgfVwiXG4gICAgICAgICAgWyh2YWx1ZSldPVwiZGVjaXNpb25JbnB1dC5pbnB1dC5zY2hlbWEuZGVzY3JpcHRpb25cIiB1c2UtcGxhY2Vob2xkZXI9XCJ0cnVlXCIgW2ZpZWxkQ2xhc3NdPVwiJ2Zvcm0tY29udHJvbC1zbSdcIlxuICAgICAgICAgIFtyZWFkT25seV09XCJ0cnVlXCIgdGl0bGU9XCJ7e2RlY2lzaW9uRGVzY3JpcHRpb25GaWVsZC50aXRsZX19XCI+XG4gICAgICAgIDwveGYtZWRpdGFibGUtZmllbGQ+XG4gICAgICA8L2Rpdj5cbiAgICAgIDxkaXYgY2xhc3M9XCJwYWRkaW5nLWxlZnQtMTJweCBwYWRkaW5nLXJpZ2h0LTE2cHggcGFkZGluZy10b3AtOHB4IHBhZGRpbmctYm90dG9tLThweFwiPlxuICAgICAgICA8ZGl2ICpuZ0Zvcj1cImxldCBmaWVsZCBvZiBmaWVsZHMgfCBrZXl2YWx1ZTogb3JpZ2luYWxPcmRlcjsgbGV0IGZpcnN0ID0gZmlyc3Q7XCI+XG4gICAgICAgICAgPGRpdiBbbmdDbGFzc109XCJ7J21hcmdpbi10b3AtMTBweCcgOiAhZmlyc3QgfVwiPlxuICAgICAgICAgICAgPHhmLWZvcm0tZmllbGQgW2ZpZWxkXT1cImZpZWxkLnZhbHVlXCIgW2Zvcm1Db250cm9sTmFtZV09XCJmaWVsZC5rZXlcIj48L3hmLWZvcm0tZmllbGQ+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgPC9kaXY+XG4gICAgPCEtLSBmb290ZXIgLS0+XG4gICAgPGRpdlxuICAgICAgY2xhc3M9XCJmbGV4LXJvdyBtb2RhbC1mb290ZXIgcGFkZGluZy1ib3R0b20tMTJweCBwYWRkaW5nLWxlZnQtMTJweCBwYWRkaW5nLXJpZ2h0LTE2cHggcGFkZGluZy10b3AtMTZweCBwb3NpdGlvbi1yZWxhdGl2ZVwiXG4gICAgICAqbmdJZj1cImRlY2lzaW9uSW5wdXQucmVzcG9uc2VfbWFwcGluZy5vcHRpb25zPy5sZW5ndGggPiAwXCI+XG4gICAgICA8YnV0dG9uICpuZ0Zvcj1cImxldCBvcHRpb24gb2YgZGVjaXNpb25JbnB1dC5yZXNwb25zZV9tYXBwaW5nLm9wdGlvbnM7IGxldCBpID0gaW5kZXg7XCIgdHlwZT1cImJ1dHRvblwiXG4gICAgICAgIFtuZ0NsYXNzXT1cIm9wdGlvbi5wcmltYXJ5ID8gJ2J0bi1wcmltYXJ5JzogJ2J0bi1zZWNvbmRhcnknXCIgY2xhc3M9XCJidG4gYnRuLXNtIG1hcmdpbi1yaWdodC00cHhcIlxuICAgICAgICAoY2xpY2spPVwic3VibWl0RGVjaXNpb24ob3B0aW9uKVwiIGlkPVwic3VibWl0LXBlbmRpbmctZGVjaXNpb24tYnRuLXt7aX19XCI+e3tvcHRpb24ub3B0aW9ufX08L2J1dHRvbj5cbiAgICA8L2Rpdj5cbiAgICA8IS0tIERlbGV0ZSB1c2VyIElucHV0IC0tPlxuICAgIEBpZiAodHlwZSA9PT0gJ21vZGFsJyAmJiBwbGF5Ym9va0V4ZWN1dGVQZXJtaXNzaW9uKSB7XG4gICAgICA8ZGl2IGNsYXNzPVwiYm9yZGVyLTEgYm9yZGVyLWRhcmsgYm9yZGVyLXRvcCBwYWRkaW5nLWJvdHRvbS02cHggcGFkZGluZy1sZWZ0LTIwcHggcGFkZGluZy1yaWdodC0yMHB4IHBhZGRpbmctdG9wLTZweCB0ZXh0LWVuZFwiICAqdHJhbnNsb2NvPVwibGV0IHRcIj5cbiAgICAgICAgPHNwYW4gY2xhc3M9XCJmb250LXNpemUtMTJweCB0ZXh0LWRhbmdlciBjdXJzb3ItcG9pbnRlclwiIChjbGljayk9XCJkZWxldGVNYW51YWxJbnB1dCgpXCI+PGkgY2xhc3M9XCJmYSBmYS1saWdodCBmYS10cmFzaC1hbHRcIj48L2k+XG4gICAgICAgICAgPHNwYW4gY2xhc3M9XCJtYXJnaW4tbGVmdC02cHhcIj57eyB0KCdOT1RJRklDQVRJT05TLkRJU0NBUkRfVVNFUl9JTlBVVCcpIH19PC9zcGFuPlxuICAgICAgICA8L3NwYW4+XG4gICAgICAgIDxzcGFuIG5nYlRvb2x0aXA9XCJ7eyB0KCdOT1RJRklDQVRJT05TLkRJU0NBUkRfVVNFUl9JTlBVVF9UT09MVElQJykgfX1cIiBjb250YWluZXI9XCJib2R5XCI+XG4gICAgICAgIDxpIGNsYXNzPVwiY29udGVudC1mb250IGZhLWNpcmNsZS1pbmZvIGZhLWR1b3RvbmUgZmEtbGlnaHQgbWFyZ2luLWxlZnQtNHB4XCI+PC9pPjwvc3Bhbj5cbiAgICAgIDwvZGl2PlxuICAgIH1cbiAgPC9mb3JtPlxuICA8ZGl2IGNsYXNzPVwicGFkZGluZy10b3AtbGcgcGFkZGluZy1ib3R0b20tbGdcIiAqbmdJZj1cInBsYXlib29rUmVzdW1lZFwiPlxuICAgIDxkaXYgY2xhc3M9XCJ0ZXh0LWNlbnRlciBjb250ZW50LWZvbnRcIj57e2RlY2lzaW9uSW5wdXQucmVzcG9uc2VfbWFwcGluZy5jdXN0b21TdWNjZXNzTWVzc2FnZSA/XG4gICAgICBkZWNpc2lvbklucHV0LnJlc3BvbnNlX21hcHBpbmcuY3VzdG9tU3VjY2Vzc01lc3NhZ2UgOiAnUGxheWJvb2sgc3VjY2Vzc2Z1bGx5IHJlc3VtZWQuJ319PC9kaXY+XG4gIDwvZGl2PlxuPC9kaXY+XG4iXX0=