/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, forwardRef, ViewChild } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import { SearchableDropdownComponent } from '../../searchable-dropdown/searchable-dropdown.component';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/timezone.service";
import * as i2 from "../../searchable-dropdown/searchable-dropdown.component";
import * as i3 from "@angular/forms";
export class TimezoneSelectComponent {
    constructor(timezoneService, changeDetectorRef) {
        this.timezoneService = timezoneService;
        this.changeDetectorRef = changeDetectorRef;
        this.timezoneList = [];
        this.items = [];
        this.filteredItems = [];
        this.selectedValue = null;
        this.selectedTimezone = null;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.touched = false;
        this.disabled = false;
    }
    valueChange(value) {
        this.selectedTimezone = this.timezoneList.find((timezone) => timezone.value === value) || null;
        this.onChange(this.selectedTimezone);
    }
    ngOnInit() {
        this.timezoneList = this.timezoneService.getUtcList();
        this.items = this.timezoneList.map((timezone) => {
            return {
                display: timezone.text,
                value: timezone.value,
                uuid: timezone.value
            };
        });
        this.selectSearchableItem();
    }
    selectSearchableItem() {
        this.selectedValue = this.items.find((item) => item.uuid === this.selectedTimezone?.value) || null;
    }
    loadItems(search) {
        search = search.toLowerCase();
        this.filteredItems = this.items.filter((item) => item.display.toLowerCase().indexOf(search) > -1 || item.value.toLowerCase().indexOf(search) > -1);
        this.changeDetectorRef.detectChanges();
    }
    writeValue(value) {
        this.selectedTimezone = value;
        this.selectSearchableItem();
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    markAsTouched() {
        if (!this.touched) {
            this.onTouched();
            this.touched = true;
        }
    }
    focus() {
        this.searchableDropdownComponent.focus();
    }
    get valid() {
        return !this.searchableDropdownComponent.invalid;
    }
    setDisabledState(disabled) {
        this.disabled = disabled;
    }
    validate(control) {
        const required = control.value;
        if (required <= 0) {
            return {
                required: {
                    required
                }
            };
        }
        return null;
    }
    static { this.ɵfac = function TimezoneSelectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TimezoneSelectComponent)(i0.ɵɵdirectiveInject(i1.TimezoneService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TimezoneSelectComponent, selectors: [["xf-timezone-select"]], viewQuery: function TimezoneSelectComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchableDropdownComponent = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => TimezoneSelectComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => TimezoneSelectComponent),
                    multi: true
                }])], decls: 2, vars: 3, consts: [[1, "form-group"], [3, "ngModelChange", "searchQueryChange", "ngModel", "items", "buttonStyle"]], template: function TimezoneSelectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "xf-searchable-dropdown", 1);
            i0.ɵɵtwoWayListener("ngModelChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_ngModelChange_1_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.selectedValue, $event) || (ctx.selectedValue = $event); return $event; });
            i0.ɵɵlistener("ngModelChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_ngModelChange_1_listener() { return ctx.valueChange(ctx.selectedValue == null ? null : ctx.selectedValue.value); })("searchQueryChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_searchQueryChange_1_listener($event) { return ctx.loadItems($event); });
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵtwoWayProperty("ngModel", ctx.selectedValue);
            i0.ɵɵproperty("items", ctx.filteredItems)("buttonStyle", "select");
        } }, dependencies: [i2.SearchableDropdownComponent, i3.NgControlStatus, i3.NgModel] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimezoneSelectComponent, [{
        type: Component,
        args: [{ selector: 'xf-timezone-select', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => TimezoneSelectComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => TimezoneSelectComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n\n<div class=\"form-group\">\n  <xf-searchable-dropdown [(ngModel)]=\"selectedValue\" (ngModelChange)=\"valueChange(selectedValue?.value)\" [items]=\"filteredItems\" (searchQueryChange)=\"loadItems($event)\" [buttonStyle]=\"'select'\"></xf-searchable-dropdown>\n</div>\n" }]
    }], () => [{ type: i1.TimezoneService }, { type: i0.ChangeDetectorRef }], { searchableDropdownComponent: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TimezoneSelectComponent, { className: "TimezoneSelectComponent", filePath: "lib/components/timezone/timezone-select/timezone-select.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGltZXpvbmUtc2VsZWN0LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zcmMvbGliL2NvbXBvbmVudHMvdGltZXpvbmUvdGltZXpvbmUtc2VsZWN0L3RpbWV6b25lLXNlbGVjdC5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9jb21wb25lbnRzL3RpbWV6b25lL3RpbWV6b25lLXNlbGVjdC90aW1lem9uZS1zZWxlY3QuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7a0JBSWtCO0FBQ2xCLE9BQU8sRUFBcUIsU0FBUyxFQUFFLFVBQVUsRUFBVSxTQUFTLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDNUYsT0FBTyxFQUF5QyxhQUFhLEVBQUUsaUJBQWlCLEVBQStCLE1BQU0sZ0JBQWdCLENBQUM7QUFHdEksT0FBTyxFQUFFLDJCQUEyQixFQUFFLE1BQU0seURBQXlELENBQUM7Ozs7O0FBZ0J0RyxNQUFNLE9BQU8sdUJBQXVCO0lBYWxDLFlBQ1UsZUFBZ0MsRUFDaEMsaUJBQW9DO1FBRHBDLG9CQUFlLEdBQWYsZUFBZSxDQUFpQjtRQUNoQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQW1CO1FBYjlDLGlCQUFZLEdBQWtCLEVBQUUsQ0FBQztRQUNqQyxVQUFLLEdBQXFCLEVBQUUsQ0FBQztRQUM3QixrQkFBYSxHQUFxQixFQUFFLENBQUM7UUFDckMsa0JBQWEsR0FBMEIsSUFBSSxDQUFDO1FBQzVDLHFCQUFnQixHQUF1QixJQUFJLENBQUM7UUFFNUMsYUFBUSxHQUFHLENBQUMsQ0FBTSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDM0IsY0FBUyxHQUFHLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUN0QixZQUFPLEdBQUcsS0FBSyxDQUFDO1FBQ2hCLGFBQVEsR0FBRyxLQUFLLENBQUM7SUFPakIsQ0FBQztJQUVELFdBQVcsQ0FBQyxLQUFVO1FBQ3BCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxDQUFDLFFBQXFCLEVBQUUsRUFBRSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEtBQUssS0FBSyxDQUFDLElBQUksSUFBSSxDQUFDO1FBQzVHLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVELFFBQVE7UUFDTixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDdEQsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFFBQXFCLEVBQUUsRUFBRTtZQUMzRCxPQUFPO2dCQUNMLE9BQU8sRUFBRSxRQUFRLENBQUMsSUFBSTtnQkFDdEIsS0FBSyxFQUFFLFFBQVEsQ0FBQyxLQUFLO2dCQUNyQixJQUFJLEVBQUUsUUFBUSxDQUFDLEtBQUs7YUFDckIsQ0FBQztRQUNKLENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUM7SUFDOUIsQ0FBQztJQUVELG9CQUFvQjtRQUNsQixJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBb0IsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksS0FBSyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLElBQUksSUFBSSxDQUFDO0lBQ3JILENBQUM7SUFFRCxTQUFTLENBQUMsTUFBYztRQUN0QixNQUFNLEdBQUcsTUFBTSxDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQzlCLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFvQixFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ25LLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN6QyxDQUFDO0lBRUQsVUFBVSxDQUFDLEtBQVU7UUFDbkIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztRQUM5QixJQUFJLENBQUMsb0JBQW9CLEVBQUUsQ0FBQztRQUM1QixJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDekMsQ0FBQztJQUVNLGdCQUFnQixDQUFDLEVBQTJCO1FBQ2pELElBQUksQ0FBQyxRQUFRLEdBQUcsRUFBRSxDQUFDO0lBQ3JCLENBQUM7SUFFTSxpQkFBaUIsQ0FBQyxFQUFjO1FBQ3JDLElBQUksQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFDO0lBQ3RCLENBQUM7SUFFRCxhQUFhO1FBQ1gsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUNsQixJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7WUFDakIsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7UUFDdEIsQ0FBQztJQUNILENBQUM7SUFFRCxLQUFLO1FBQ0gsSUFBSSxDQUFDLDJCQUEyQixDQUFDLEtBQUssRUFBRSxDQUFDO0lBQzNDLENBQUM7SUFFRCxJQUFJLEtBQUs7UUFDUCxPQUFPLENBQUMsSUFBSSxDQUFDLDJCQUEyQixDQUFDLE9BQU8sQ0FBQztJQUNuRCxDQUFDO0lBRUQsZ0JBQWdCLENBQUMsUUFBaUI7UUFDaEMsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7SUFDM0IsQ0FBQztJQUVELFFBQVEsQ0FBQyxPQUF3QjtRQUMvQixNQUFNLFFBQVEsR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDO1FBQy9CLElBQUksUUFBUSxJQUFJLENBQUMsRUFBRSxDQUFDO1lBQ2xCLE9BQU87Z0JBQ0wsUUFBUSxFQUFFO29CQUNSLFFBQVE7aUJBQ1Q7YUFDRixDQUFDO1FBQ0osQ0FBQztRQUNELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzt3SEExRlUsdUJBQXVCO29FQUF2Qix1QkFBdUI7MkJBT3ZCLDJCQUEyQjs7Ozs4Q0FqQjNCLENBQUM7b0JBQ1YsT0FBTyxFQUFFLGlCQUFpQjtvQkFDMUIsV0FBVyxFQUFFLFVBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQztvQkFDdEQsS0FBSyxFQUFFLElBQUk7aUJBQ1osRUFBRTtvQkFDRCxPQUFPLEVBQUUsYUFBYTtvQkFDdEIsV0FBVyxFQUFFLFVBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQztvQkFDdEQsS0FBSyxFQUFFLElBQUk7aUJBQ1osQ0FBQztZQ2hCRixBQURGLDhCQUF3QixnQ0FDMks7WUFBekssNE9BQTJCO1lBQTZFLEFBQTVFLG9JQUFpQiwyRUFBaUMsSUFBQyxxSUFBOEMscUJBQWlCLElBQUM7WUFDekssQUFEbU0saUJBQXlCLEVBQ3ROOztZQURvQixjQUEyQjtZQUEzQixpREFBMkI7WUFBcUgsQUFBaEUseUNBQXVCLHlCQUFpRTs7O2lGRGtCckwsdUJBQXVCO2NBZG5DLFNBQVM7MkJBQ0Usb0JBQW9CLGFBR25CLENBQUM7d0JBQ1YsT0FBTyxFQUFFLGlCQUFpQjt3QkFDMUIsV0FBVyxFQUFFLFVBQVUsQ0FBQyxHQUFHLEVBQUUsd0JBQXdCLENBQUM7d0JBQ3RELEtBQUssRUFBRSxJQUFJO3FCQUNaLEVBQUU7d0JBQ0QsT0FBTyxFQUFFLGFBQWE7d0JBQ3RCLFdBQVcsRUFBRSxVQUFVLENBQUMsR0FBRyxFQUFFLHdCQUF3QixDQUFDO3dCQUN0RCxLQUFLLEVBQUUsSUFBSTtxQkFDWixDQUFDO2dGQVNzQywyQkFBMkI7a0JBQWxFLFNBQVM7bUJBQUMsMkJBQTJCOztrRkFQM0IsdUJBQXVCIiwic291cmNlc0NvbnRlbnQiOlsiLyogQ29weXJpZ2h0IHN0YXJ0XG4gIENvcHlyaWdodCAoQykgMjAwOCAtIDIwMjUgRm9ydGluZXQgSW5jLlxuICBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICBGT1JUSU5FVCBDT05GSURFTlRJQUwgJiBGT1JUSU5FVCBQUk9QUklFVEFSWSBTT1VSQ0UgQ09ERVxuICBDb3B5cmlnaHQgZW5kICovXG5pbXBvcnQgeyBDaGFuZ2VEZXRlY3RvclJlZiwgQ29tcG9uZW50LCBmb3J3YXJkUmVmLCBPbkluaXQsIFZpZXdDaGlsZCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQWJzdHJhY3RDb250cm9sLCBDb250cm9sVmFsdWVBY2Nlc3NvciwgTkdfVkFMSURBVE9SUywgTkdfVkFMVUVfQUNDRVNTT1IsIFZhbGlkYXRpb25FcnJvcnMsIFZhbGlkYXRvciB9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcbmltcG9ydCB7IFRpbWV6b25lLCBUaW1lem9uZVNlcnZpY2UsIFRpbWV6b25lVVRDIH0gZnJvbSAnLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy90aW1lem9uZS5zZXJ2aWNlJztcbmltcG9ydCB7IFNlYXJjaGFibGVJdGVtIH0gZnJvbSAnLi4vLi4vc2VhcmNoYWJsZS1kcm9wZG93bi9zZWFyY2hhYmxlLWl0ZW0nO1xuaW1wb3J0IHsgU2VhcmNoYWJsZURyb3Bkb3duQ29tcG9uZW50IH0gZnJvbSAnLi4vLi4vc2VhcmNoYWJsZS1kcm9wZG93bi9zZWFyY2hhYmxlLWRyb3Bkb3duLmNvbXBvbmVudCc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ3hmLXRpbWV6b25lLXNlbGVjdCcsXG4gIHRlbXBsYXRlVXJsOiAnLi90aW1lem9uZS1zZWxlY3QuY29tcG9uZW50Lmh0bWwnLFxuICBzdHlsZVVybHM6IFsnLi90aW1lem9uZS1zZWxlY3QuY29tcG9uZW50LnNjc3MnXSxcbiAgcHJvdmlkZXJzOiBbe1xuICAgIHByb3ZpZGU6IE5HX1ZBTFVFX0FDQ0VTU09SLFxuICAgIHVzZUV4aXN0aW5nOiBmb3J3YXJkUmVmKCgpID0+IFRpbWV6b25lU2VsZWN0Q29tcG9uZW50KSxcbiAgICBtdWx0aTogdHJ1ZVxuICB9LCB7XG4gICAgcHJvdmlkZTogTkdfVkFMSURBVE9SUyxcbiAgICB1c2VFeGlzdGluZzogZm9yd2FyZFJlZigoKSA9PiBUaW1lem9uZVNlbGVjdENvbXBvbmVudCksXG4gICAgbXVsdGk6IHRydWVcbiAgfV1cbn0pXG5leHBvcnQgY2xhc3MgVGltZXpvbmVTZWxlY3RDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIENvbnRyb2xWYWx1ZUFjY2Vzc29yLCBWYWxpZGF0b3Ige1xuXG4gIHRpbWV6b25lTGlzdDogVGltZXpvbmVVVENbXSA9IFtdO1xuICBpdGVtczogU2VhcmNoYWJsZUl0ZW1bXSA9IFtdO1xuICBmaWx0ZXJlZEl0ZW1zOiBTZWFyY2hhYmxlSXRlbVtdID0gW107XG4gIHNlbGVjdGVkVmFsdWU6IFNlYXJjaGFibGVJdGVtIHwgbnVsbCA9IG51bGw7XG4gIHNlbGVjdGVkVGltZXpvbmU6IFRpbWV6b25lVVRDIHwgbnVsbCA9IG51bGw7XG4gIEBWaWV3Q2hpbGQoU2VhcmNoYWJsZURyb3Bkb3duQ29tcG9uZW50KSBzZWFyY2hhYmxlRHJvcGRvd25Db21wb25lbnQhOiBTZWFyY2hhYmxlRHJvcGRvd25Db21wb25lbnQ7XG4gIG9uQ2hhbmdlID0gKF86IGFueSkgPT4geyB9O1xuICBvblRvdWNoZWQgPSAoKSA9PiB7IH07XG4gIHRvdWNoZWQgPSBmYWxzZTtcbiAgZGlzYWJsZWQgPSBmYWxzZTtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHRpbWV6b25lU2VydmljZTogVGltZXpvbmVTZXJ2aWNlLFxuICAgIHByaXZhdGUgY2hhbmdlRGV0ZWN0b3JSZWY6IENoYW5nZURldGVjdG9yUmVmXG4gICkge1xuXG4gIH1cblxuICB2YWx1ZUNoYW5nZSh2YWx1ZTogYW55KSB7XG4gICAgdGhpcy5zZWxlY3RlZFRpbWV6b25lID0gdGhpcy50aW1lem9uZUxpc3QuZmluZCgodGltZXpvbmU6IFRpbWV6b25lVVRDKSA9PiB0aW1lem9uZS52YWx1ZSA9PT0gdmFsdWUpIHx8IG51bGw7XG4gICAgdGhpcy5vbkNoYW5nZSh0aGlzLnNlbGVjdGVkVGltZXpvbmUpO1xuICB9XG5cbiAgbmdPbkluaXQoKSB7XG4gICAgdGhpcy50aW1lem9uZUxpc3QgPSB0aGlzLnRpbWV6b25lU2VydmljZS5nZXRVdGNMaXN0KCk7XG4gICAgdGhpcy5pdGVtcyA9IHRoaXMudGltZXpvbmVMaXN0Lm1hcCgodGltZXpvbmU6IFRpbWV6b25lVVRDKSA9PiB7XG4gICAgICByZXR1cm4ge1xuICAgICAgICBkaXNwbGF5OiB0aW1lem9uZS50ZXh0LFxuICAgICAgICB2YWx1ZTogdGltZXpvbmUudmFsdWUsXG4gICAgICAgIHV1aWQ6IHRpbWV6b25lLnZhbHVlXG4gICAgICB9O1xuICAgIH0pO1xuICAgIHRoaXMuc2VsZWN0U2VhcmNoYWJsZUl0ZW0oKTtcbiAgfVxuXG4gIHNlbGVjdFNlYXJjaGFibGVJdGVtKCkge1xuICAgIHRoaXMuc2VsZWN0ZWRWYWx1ZSA9IHRoaXMuaXRlbXMuZmluZCgoaXRlbTogU2VhcmNoYWJsZUl0ZW0pID0+IGl0ZW0udXVpZCA9PT0gdGhpcy5zZWxlY3RlZFRpbWV6b25lPy52YWx1ZSkgfHwgbnVsbDtcbiAgfVxuXG4gIGxvYWRJdGVtcyhzZWFyY2g6IHN0cmluZykge1xuICAgIHNlYXJjaCA9IHNlYXJjaC50b0xvd2VyQ2FzZSgpO1xuICAgIHRoaXMuZmlsdGVyZWRJdGVtcyA9IHRoaXMuaXRlbXMuZmlsdGVyKChpdGVtOiBTZWFyY2hhYmxlSXRlbSkgPT4gaXRlbS5kaXNwbGF5LnRvTG93ZXJDYXNlKCkuaW5kZXhPZihzZWFyY2gpID4gLTEgfHwgaXRlbS52YWx1ZS50b0xvd2VyQ2FzZSgpLmluZGV4T2Yoc2VhcmNoKSA+IC0xKTtcbiAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgfVxuXG4gIHdyaXRlVmFsdWUodmFsdWU6IGFueSkge1xuICAgIHRoaXMuc2VsZWN0ZWRUaW1lem9uZSA9IHZhbHVlO1xuICAgIHRoaXMuc2VsZWN0U2VhcmNoYWJsZUl0ZW0oKTtcbiAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgfVxuXG4gIHB1YmxpYyByZWdpc3Rlck9uQ2hhbmdlKGZuOiAodmFsdWU6IHN0cmluZykgPT4gdm9pZCk6IHZvaWQge1xuICAgIHRoaXMub25DaGFuZ2UgPSBmbjtcbiAgfVxuXG4gIHB1YmxpYyByZWdpc3Rlck9uVG91Y2hlZChmbjogKCkgPT4gdm9pZCk6IHZvaWQge1xuICAgIHRoaXMub25Ub3VjaGVkID0gZm47XG4gIH1cblxuICBtYXJrQXNUb3VjaGVkKCkge1xuICAgIGlmICghdGhpcy50b3VjaGVkKSB7XG4gICAgICB0aGlzLm9uVG91Y2hlZCgpO1xuICAgICAgdGhpcy50b3VjaGVkID0gdHJ1ZTtcbiAgICB9XG4gIH1cblxuICBmb2N1cygpIHtcbiAgICB0aGlzLnNlYXJjaGFibGVEcm9wZG93bkNvbXBvbmVudC5mb2N1cygpO1xuICB9XG5cbiAgZ2V0IHZhbGlkKCkge1xuICAgIHJldHVybiAhdGhpcy5zZWFyY2hhYmxlRHJvcGRvd25Db21wb25lbnQuaW52YWxpZDtcbiAgfVxuXG4gIHNldERpc2FibGVkU3RhdGUoZGlzYWJsZWQ6IGJvb2xlYW4pIHtcbiAgICB0aGlzLmRpc2FibGVkID0gZGlzYWJsZWQ7XG4gIH1cblxuICB2YWxpZGF0ZShjb250cm9sOiBBYnN0cmFjdENvbnRyb2wpOiBWYWxpZGF0aW9uRXJyb3JzIHwgbnVsbCB7XG4gICAgY29uc3QgcmVxdWlyZWQgPSBjb250cm9sLnZhbHVlO1xuICAgIGlmIChyZXF1aXJlZCA8PSAwKSB7XG4gICAgICByZXR1cm4ge1xuICAgICAgICByZXF1aXJlZDoge1xuICAgICAgICAgIHJlcXVpcmVkXG4gICAgICAgIH1cbiAgICAgIH07XG4gICAgfVxuICAgIHJldHVybiBudWxsO1xuICB9XG59XG4iLCI8IS0tIENvcHlyaWdodCBzdGFydFxuICBDb3B5cmlnaHQgKEMpIDIwMDggLSAyMDI1IEZvcnRpbmV0IEluYy5cbiAgQWxsIHJpZ2h0cyByZXNlcnZlZC5cbiAgRk9SVElORVQgQ09ORklERU5USUFMICYgRk9SVElORVQgUFJPUFJJRVRBUlkgU09VUkNFIENPREVcbiAgQ29weXJpZ2h0IGVuZCAtLT5cblxuPGRpdiBjbGFzcz1cImZvcm0tZ3JvdXBcIj5cbiAgPHhmLXNlYXJjaGFibGUtZHJvcGRvd24gWyhuZ01vZGVsKV09XCJzZWxlY3RlZFZhbHVlXCIgKG5nTW9kZWxDaGFuZ2UpPVwidmFsdWVDaGFuZ2Uoc2VsZWN0ZWRWYWx1ZT8udmFsdWUpXCIgW2l0ZW1zXT1cImZpbHRlcmVkSXRlbXNcIiAoc2VhcmNoUXVlcnlDaGFuZ2UpPVwibG9hZEl0ZW1zKCRldmVudClcIiBbYnV0dG9uU3R5bGVdPVwiJ3NlbGVjdCdcIj48L3hmLXNlYXJjaGFibGUtZHJvcGRvd24+XG48L2Rpdj5cbiJdfQ==