import { ChangeDetectionStrategy, Component, forwardRef, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import { flatten, keyBy, uniq } from 'lodash-es';
import { map, of, zip } from 'rxjs';
import { API, FIXED_MODULE } from '../../core/constants';
import { Person } from '../../core/models/person';
import { Team } from '../../core/models/team';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "ng-multiselect-dropdown";
import * as i5 from "@jsverse/transloco";
const _c0 = ["formControlName", ""];
function UserMultiselectComponent_div_0_ng_template_2_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 7);
} }
function UserMultiselectComponent_div_0_ng_template_2_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 8);
} }
function UserMultiselectComponent_div_0_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, UserMultiselectComponent_div_0_ng_template_2_span_1_Template, 1, 0, "span", 5)(2, UserMultiselectComponent_div_0_ng_template_2_span_2_Template, 1, 0, "span", 6);
    i0.ɵɵelementStart(3, "label");
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const option_r1 = ctx.option;
    const id_r2 = ctx.id;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r2].type === "team");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r2].type === "user");
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", option_r1, " ");
} }
function UserMultiselectComponent_div_0_ng_template_4_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 7);
} }
function UserMultiselectComponent_div_0_ng_template_4_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 8);
} }
function UserMultiselectComponent_div_0_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, UserMultiselectComponent_div_0_ng_template_4_span_1_Template, 1, 0, "span", 5)(2, UserMultiselectComponent_div_0_ng_template_4_span_2_Template, 1, 0, "span", 6);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r4 = ctx.option;
    const id_r5 = ctx.id;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r5].type === "team");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r5].type === "user");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", option_r4, " ");
} }
function UserMultiselectComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3)(1, "ng-multiselect-dropdown", 4);
    i0.ɵɵtemplate(2, UserMultiselectComponent_div_0_ng_template_2_Template, 5, 3, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor)(4, UserMultiselectComponent_div_0_ng_template_4_Template, 4, 3, "ng-template", null, 1, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r6 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r2.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("placeholder", t_r6("Select users"))("settings", ctx_r2.dropdownSettings)("data", ctx_r2.userTeamList);
} }
export class UserMultiselectComponent {
    constructor(http, changeDetectorRef, formBuilder) {
        this.http = http;
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.dropdownSettings = {
            singleSelection: false,
            idField: 'uuid',
            textField: 'display',
            selectAllText: 'Select All',
            unSelectAllText: 'Deselect All',
            allowSearchFilter: true
        };
        this.includeTeams = false;
        this.excludeIris = [];
        this.userTeamList = [];
        this.value = [];
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.formGroup = this.formBuilder.group({
            users: [[]]
        });
    }
    writeValue(value) {
        this.value = value;
        this.formGroup.controls.users.setValue(value);
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnChanges() {
        this.loadUsersAndTeams();
    }
    loadUsersAndTeams() {
        zip(this.loadUsers(), this.loadTeams())
            .subscribe((result) => {
            let userTeamList = flatten(result);
            let filteredList = userTeamList.filter((item) => this.excludeIris.indexOf(item.uuid) === -1);
            this.userTeamList = filteredList;
            this.changeDetectorRef.detectChanges();
        });
    }
    ngOnInit() {
        this.formGroup.controls.users.valueChanges.subscribe((items) => {
            let users = uniq(flatten(items.map((item) => {
                const userOrTeam = this.getItems[item.uuid];
                if (userOrTeam instanceof Person) {
                    return userOrTeam.iri;
                }
                else {
                    return userOrTeam.users;
                }
            })));
            this.onChange(users);
        });
    }
    loadUsers() {
        let body = {
            logic: 'AND',
            filters: [{
                    field: 'csActive',
                    operator: 'eq',
                    value: true
                }],
            __selectFields: ['firstname', 'lastname', 'uuid']
        };
        return this.http.post(API.QUERY + FIXED_MODULE.PEOPLE, body)
            .pipe(map((response) => {
            return plainToInstance(Person, response['hydra:member']);
        }));
    }
    loadTeams() {
        if (!this.includeTeams) {
            return of([]);
        }
        let body = {
            logic: 'AND',
            filters: [],
            __selectFields: ['actors', 'name', 'uuid']
        };
        return this.http.post(API.QUERY + FIXED_MODULE.TEAMS, body)
            .pipe(map((response) => {
            return plainToInstance(Team, response['hydra:member']);
        }));
    }
    get getItems() {
        return keyBy(this.userTeamList, 'uuid');
    }
    static { this.ɵfac = function UserMultiselectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UserMultiselectComponent)(i0.ɵɵdirectiveInject(i1.HttpClient), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: UserMultiselectComponent, selectors: [["xf-user-multiselect", "formControlName", ""]], inputs: { includeTeams: "includeTeams", excludeIris: "excludeIris" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => UserMultiselectComponent),
                    multi: true
                }]), i0.ɵɵNgOnChangesFeature], attrs: _c0, decls: 1, vars: 0, consts: [["optionsTemplate", ""], ["optionSelectedTemplate", ""], ["class", "minw-300px", 3, "formGroup", 4, "transloco"], [1, "minw-300px", 3, "formGroup"], ["formControlName", "users", "name", "module-select", 3, "placeholder", "settings", "data"], ["class", "fa fa-users me-1", 4, "ngIf"], ["class", "fa fa-user me-1", 4, "ngIf"], [1, "fa", "fa-users", "me-1"], [1, "fa", "fa-user", "me-1"]], template: function UserMultiselectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, UserMultiselectComponent_div_0_Template, 6, 4, "div", 2);
        } }, dependencies: [i3.NgIf, i4.MultiSelectComponent, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i5.TranslocoDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UserMultiselectComponent, [{
        type: Component,
        args: [{ selector: 'xf-user-multiselect[formControlName]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => UserMultiselectComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"minw-300px\" *transloco=\"let t\" [formGroup]=\"formGroup\">\n  <ng-multiselect-dropdown [placeholder]=\"t('Select users')\" [settings]=\"dropdownSettings\" [data]=\"userTeamList\"\n    formControlName=\"users\" name=\"module-select\">\n    <ng-template #optionsTemplate let-item let-option=\"option\" let-id=\"id\" let-isSelected=\"isSelected\">\n      <div>\n        <span *ngIf=\"getItems[id].type === 'team'\" class=\"fa fa-users me-1\"></span>\n        <span *ngIf=\"getItems[id].type === 'user'\" class=\"fa fa-user me-1\"></span>\n        <label>\n          {{option}}\n        </label>\n      </div>\n    </ng-template>\n    <ng-template #optionSelectedTemplate let-option=\"option\" let-id=\"id\">\n      <div>\n        <span *ngIf=\"getItems[id].type === 'team'\" class=\"fa fa-users me-1\"></span>\n        <span *ngIf=\"getItems[id].type === 'user'\" class=\"fa fa-user me-1\"></span>\n        {{option}}\n      </div>\n    </ng-template>\n  </ng-multiselect-dropdown>\n</div>\n" }]
    }], () => [{ type: i1.HttpClient }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { includeTeams: [{
            type: Input
        }], excludeIris: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(UserMultiselectComponent, { className: "UserMultiselectComponent", filePath: "lib/components/user-multiselect/user-multiselect.component.ts", lineNumber: 28 }); })();
//# sourceMappingURL=data:application/json;base64,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