/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { map, of } from "rxjs";
import { ViewContainerDirective } from '../../utility/directives/view-container.directive';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "../../utility/directives/view-container.directive";
const _c0 = ["wizardForm"];
const _c1 = ["wizard", ""];
const _c2 = (a0, a1) => ({ "wizard-with-title": a0, "wizard-no-secondary-nav": a1 });
const _c3 = a0 => ({ "padding-left-16px padding-right-16px padding-top-8px padding-bottom-8px": a0 });
const _c4 = (a0, a1) => ({ "completed": a0, "active": a1 });
const _c5 = (a0, a1) => ({ "fa-check font-size-10px": a0, "fa-circle font-size-8px": a1 });
const _c6 = (a0, a1, a2, a3) => ({ "first": a0, "last": a1, "active": a2, "completed": a3 });
const _c7 = (a0, a1, a2, a3) => ({ "float-end": a0, "btn-primary": a1, "btn-secondary": a2, "btn-outline-secondary": a3 });
function WizardComponent_div_5_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 10)(2, "div", 11);
    i0.ɵɵelement(3, "span", 12);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(4, "div", 13);
    i0.ɵɵelementStart(5, "div", 14);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const step_r1 = ctx.$implicit;
    const i_r2 = ctx.index;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(4, _c4, step_r1.isComplete || ctx_r2.wizard.currentStepIndex === ctx_r2.enabledSteps.length - 1, i_r2 === ctx_r2.wizard.currentStepIndex));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(7, _c5, step_r1.isComplete, !step_r1.isComplete));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction4(10, _c6, i_r2 === 0, i_r2 === ctx_r2.enabledSteps.length - 1, i_r2 === ctx_r2.wizard.currentStepIndex, step_r1.isComplete));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(step_r1.title);
} }
function WizardComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵtemplate(1, WizardComponent_div_5_ng_container_1_Template, 7, 15, "ng-container", 8);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.enabledSteps);
} }
function WizardComponent_ng_template_7_Template(rf, ctx) { }
function WizardComponent_ng_container_9_button_1_i_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 19);
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon ? button_r5.disabledIcon : button_r5.icon);
} }
function WizardComponent_ng_container_9_button_1_i_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 20);
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon ? button_r5.disabledIcon : button_r5.icon);
} }
function WizardComponent_ng_container_9_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 16);
    i0.ɵɵlistener("click", function WizardComponent_ng_container_9_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const button_r5 = i0.ɵɵnextContext().$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.buttonClicked(button_r5)); });
    i0.ɵɵtemplate(1, WizardComponent_ng_container_9_button_1_i_1_Template, 1, 1, "i", 17);
    i0.ɵɵtext(2);
    i0.ɵɵtemplate(3, WizardComponent_ng_container_9_button_1_i_3_Template, 1, 1, "i", 18);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("disabled", button_r5.disabled)("ngClass", i0.ɵɵpureFunction4(6, _c7, button_r5.pullRight, button_r5.type === "primary", button_r5.type === "secondary", button_r5.type !== "primary" && button_r5.type !== "secondary"))("id", "wizard-" + button_r5.name + "-btn");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (button_r5.icon || (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon) && button_r5.iconPosition === "left");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledText ? button_r5.disabledText : button_r5.text, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (button_r5.icon || (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon) && button_r5.iconPosition === "right");
} }
function WizardComponent_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, WizardComponent_ng_container_9_button_1_Template, 4, 11, "button", 15);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const button_r5 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", button_r5 && !button_r5.hidden);
} }
export class WizardComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.subscriptions = [];
        this.loading = false;
        this.enabledSteps = [];
        this.onClose = new EventEmitter();
    }
    ngOnInit() {
        this.enabledSteps = this.wizard.steps.filter((step) => !step.disabled);
        let subscription = this.wizard.wizardChanged$.subscribe(() => {
            this.enabledSteps = this.wizard.steps.filter((step) => !step.disabled);
            this.changeDetectorRef.detectChanges();
        });
        this.wizard.next = () => this.next();
        this.wizard.back = () => this.back();
        this.wizard.close = (buttonName) => this.close(buttonName);
        this.subscriptions.push(subscription);
    }
    ngAfterViewInit() {
        this.loadStepView(this.wizard.currentStepIndex);
    }
    loadStepView(stepIndex) {
        const step = this.enabledSteps[stepIndex];
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(step.component);
        this.componentRef.instance.wizard = this.wizard;
        this.componentRef.instance.step = step;
        this.componentRef.instance.wizardForm = this.wizardForm;
        this.changeDetectorRef.detectChanges();
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    buttonClicked(button) {
        button.disabled = true;
        this.loading = true;
        this.changeDetectorRef.detectChanges();
        let observable$ = of(null);
        if (button.action === 'next') {
            observable$ = this.next(button.name);
        }
        else if (button.action === 'back') {
            this.back();
            this.loading = false;
        }
        else if (button.action === 'close') {
            this.close(button.name);
            return;
        }
        else if (button.action === 'submit') {
            observable$ = this.submit(button.name);
        }
        else if (button.action === 'skip') {
            this.skipToStep(this.wizard.currentStepIndex + 2);
        }
        if (this.buttonSubscription) {
            this.buttonSubscription.unsubscribe();
        }
        this.buttonSubscription = observable$.subscribe({
            complete: () => {
                button.disabled = false;
                this.loading = false;
                this.changeDetectorRef.detectChanges();
                this.buttonSubscription = undefined;
            }
        });
        this.subscriptions.push(this.buttonSubscription);
    }
    submit(buttonName) {
        const currentStep = this.enabledSteps[this.wizard.currentStepIndex];
        let observable$;
        if (currentStep && this.componentRef) {
            observable$ = this.componentRef.instance.submit(buttonName).pipe(map((valid) => {
                if (valid) {
                    currentStep.isComplete = true;
                }
                return valid;
            }));
        }
        else {
            observable$ = of(false);
        }
        return observable$;
    }
    next(buttonName) {
        return this.submit(buttonName).pipe(map((valid) => {
            if (valid) {
                this.wizard.currentStepIndex = this.wizard.currentStepIndex + 1;
                this.loadStepView(this.wizard.currentStepIndex);
            }
        }));
    }
    back() {
        this.wizard.currentStepIndex = this.wizard.currentStepIndex - 1;
        this.loadStepView(this.wizard.currentStepIndex);
    }
    close(buttonName) {
        this.onClose.emit();
    }
    navigateToStep(stepIndex) {
        this.wizard.currentStepIndex = stepIndex;
        // this.enabledSteps.forEach((step, index) => {
        //   if (stepIndex < index) {
        //     step.isComplete = false;
        //   }
        // });
        this.loadStepView(this.wizard.currentStepIndex);
    }
    skipToStep(stepIndex) {
        this.wizard.currentStepIndex = stepIndex;
        this.enabledSteps.forEach((step, index) => {
            if (stepIndex > index) {
                step.isComplete = true;
            }
        });
        this.loadStepView(this.wizard.currentStepIndex);
    }
    ngOnDestroy() {
        this.subscriptions.forEach((subscription) => subscription.unsubscribe());
    }
    static { this.ɵfac = function WizardComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WizardComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: WizardComponent, selectors: [["xf-wizard", "wizard", ""]], viewQuery: function WizardComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.wizardForm = _t.first);
        } }, inputs: { wizard: "wizard" }, outputs: { onClose: "onClose" }, attrs: _c1, decls: 10, vars: 9, consts: [["wizardForm", "ngForm"], [1, "wizard", 3, "ngClass"], [1, "wizard-header-container"], [1, "wizard-header", "padding-left-16px", "padding-right-16px", "solid-border-bottom-1"], ["class", "wizard-steps w-100", 4, "ngIf"], [1, "wizard-body", "padding-left-16px", "padding-right-16px", "padding-bottom-40px"], ["xfViewContainer", "", 1, "h-100"], [1, "wizard-footer", 3, "ngClass"], [4, "ngFor", "ngForOf"], [1, "wizard-steps", "w-100"], [1, "wizard-step", 3, "ngClass"], [1, "step-counter"], [1, "fa", 3, "ngClass"], [1, "step-progress-bar", "w-100", 3, "ngClass"], [1, "step-name"], ["type", "button", "class", "btn btn-secondary btn-sm margin-left-8px", 3, "disabled", "ngClass", "id", "click", 4, "ngIf"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "margin-left-8px", 3, "click", "disabled", "ngClass", "id"], ["class", "me-1", 3, "ngClass", 4, "ngIf"], ["class", "ms-1", 3, "ngClass", 4, "ngIf"], [1, "me-1", 3, "ngClass"], [1, "ms-1", 3, "ngClass"]], template: function WizardComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "form", null, 0)(2, "div", 1)(3, "div", 2)(4, "div", 3);
            i0.ɵɵtemplate(5, WizardComponent_div_5_Template, 2, 1, "div", 4);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 5);
            i0.ɵɵtemplate(7, WizardComponent_ng_template_7_Template, 0, 0, "ng-template", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 7);
            i0.ɵɵtemplate(9, WizardComponent_ng_container_9_Template, 2, 1, "ng-container", 8);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(4, _c2, ctx.wizard.title, ctx.wizard.data.noSecondaryNav));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngIf", ctx.enabledSteps.length > 1);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c3, ctx.enabledSteps[ctx.wizard.currentStepIndex].buttons.length > 0));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.enabledSteps[ctx.wizard.currentStepIndex].buttons);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.ɵNgNoValidate, i2.NgControlStatusGroup, i2.NgForm, i3.ViewContainerDirective], styles: [".wizard.wizard-with-title[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]{padding-bottom:0}.wizard[_ngcontent-%COMP%]   .wizard-header-container[_ngcontent-%COMP%]{position:sticky;top:0;z-index:1}.wizard[_ngcontent-%COMP%]   .wizard-header-container[_ngcontent-%COMP%]   .wizard-title-content[_ngcontent-%COMP%]{background:var(--wizard-header-bg-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]{display:inline-flex;justify-content:space-between;margin:15px auto 10px}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]{position:relative;display:flex;flex-direction:column;align-items:center;flex:1}@media (max-width: 768px){.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]{font-size:12px}}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]{font-weight:700}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]   .step-name[_ngcontent-%COMP%]{font-weight:400}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{outline:4px solid var(--wizard-step-active-color);background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]   .step-name[_ngcontent-%COMP%]{font-size:12px;font-weight:400}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{position:relative;z-index:5;display:flex;justify-content:center;align-items:center;width:25px;height:25px;border-radius:50%;background:var(--wizard-body-bg-color);border:1px solid var(--wizard-step-default-color);margin-bottom:6px}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.completed[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar[_ngcontent-%COMP%]{position:absolute;display:inline-block;top:13px;border:1px solid #ccc;background-color:#ccc}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.active[_ngcontent-%COMP%], .wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.completed[_ngcontent-%COMP%], .wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.first[_ngcontent-%COMP%]{border:1px solid var(--wizard-step-highlight-color);background-color:var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.first[_ngcontent-%COMP%]{left:50%}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.last[_ngcontent-%COMP%]{right:50%;z-index:0}.wizard[_ngcontent-%COMP%]   .wizard-body[_ngcontent-%COMP%]{height:calc(100vh - 265px);overflow:auto;background:var(--wizard-body-bg-color)}.wizard[_ngcontent-%COMP%]   .wizard-footer[_ngcontent-%COMP%]{background:var(--wizard-footer-bg-color);border-top:1px solid var(--footer-border-color);position:absolute;bottom:0;right:0;transition:left .4s linear;width:100%;z-index:11}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WizardComponent, [{
        type: Component,
        args: [{ selector: 'xf-wizard[wizard]', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form #wizardForm=\"ngForm\">\n  <div class=\"wizard\"\n    [ngClass]=\"{'wizard-with-title' : wizard.title, 'wizard-no-secondary-nav' : wizard.data.noSecondaryNav}\">\n    <div class=\"wizard-header-container\">\n      <div class=\"wizard-header padding-left-16px padding-right-16px solid-border-bottom-1\">\n        <div class=\"wizard-steps w-100\" *ngIf=\"enabledSteps.length > 1\">\n          <ng-container *ngFor=\"let step of enabledSteps; let i = index\">\n            <div class=\"wizard-step\"\n              [ngClass]=\"{'completed': step.isComplete || wizard.currentStepIndex === enabledSteps.length - 1, 'active': i === wizard.currentStepIndex}\">\n              <div class=\"step-counter\">\n                <span class=\"fa\" [ngClass]=\"{'fa-check font-size-10px': step.isComplete, 'fa-circle font-size-8px': !step.isComplete}\"></span>\n              </div>\n              <div class=\"step-progress-bar w-100\"\n                [ngClass]=\"{'first': i === 0, 'last': i === enabledSteps.length - 1, 'active': i === wizard.currentStepIndex, 'completed': step.isComplete}\">\n              </div>\n              <div class=\"step-name\">{{step.title}}</div>\n            </div>\n          </ng-container>\n        </div>\n      </div>\n    </div>\n    <div class=\"wizard-body padding-left-16px padding-right-16px padding-bottom-40px\">\n      <ng-template xfViewContainer class=\"h-100\"></ng-template>\n    </div>\n    <div class=\"wizard-footer\"\n      [ngClass]=\"{'padding-left-16px padding-right-16px padding-top-8px padding-bottom-8px' : enabledSteps[wizard.currentStepIndex].buttons.length > 0}\">\n      <ng-container *ngFor=\"let button of enabledSteps[wizard.currentStepIndex].buttons\">\n        <button type=\"button\" class=\"btn btn-secondary btn-sm margin-left-8px\" (click)=\"buttonClicked(button)\"\n          [disabled]=\"button.disabled\" *ngIf=\"button && !button.hidden\"\n          [ngClass]=\"{'float-end': button.pullRight, 'btn-primary': button.type === 'primary', 'btn-secondary': button.type === 'secondary', 'btn-outline-secondary': button.type !== 'primary' && button.type !== 'secondary'}\"\n          [id]=\"'wizard-' + button.name + '-btn'\">\n          <i *ngIf=\"(button.icon || ((loading || button.disabled) && button.disabledIcon)) && button.iconPosition === 'left'\"\n            [ngClass]=\"(loading || button.disabled) && button.disabledIcon ? button.disabledIcon : button.icon\"\n            class=\"me-1\"></i>\n          {{ (loading || button.disabled) && button.disabledText ? button.disabledText : button.text }}\n          <i *ngIf=\"(button.icon || ((loading || button.disabled) && button.disabledIcon)) && button.iconPosition === 'right'\"\n            [ngClass]=\"(loading || button.disabled) && button.disabledIcon ? button.disabledIcon : button.icon\"\n            class=\"ms-1\"></i>\n        </button>\n      </ng-container>\n    </div>\n  </div>\n</form>\n", styles: [".wizard.wizard-with-title .wizard-header{padding-bottom:0}.wizard .wizard-header-container{position:sticky;top:0;z-index:1}.wizard .wizard-header-container .wizard-title-content{background:var(--wizard-header-bg-color)}.wizard .wizard-header .wizard-steps{display:inline-flex;justify-content:space-between;margin:15px auto 10px}.wizard .wizard-header .wizard-steps .wizard-step{position:relative;display:flex;flex-direction:column;align-items:center;flex:1}@media (max-width: 768px){.wizard .wizard-header .wizard-steps .wizard-step{font-size:12px}}.wizard .wizard-header .wizard-steps .wizard-step.active{font-weight:700}.wizard .wizard-header .wizard-steps .wizard-step.active .step-name{font-weight:400}.wizard .wizard-header .wizard-steps .wizard-step.active .step-counter{outline:4px solid var(--wizard-step-active-color);background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .wizard-step .step-name{font-size:12px;font-weight:400}.wizard .wizard-header .wizard-steps .wizard-step .step-counter{position:relative;z-index:5;display:flex;justify-content:center;align-items:center;width:25px;height:25px;border-radius:50%;background:var(--wizard-body-bg-color);border:1px solid var(--wizard-step-default-color);margin-bottom:6px}.wizard .wizard-header .wizard-steps .wizard-step.completed .step-counter{background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .step-progress-bar{position:absolute;display:inline-block;top:13px;border:1px solid #ccc;background-color:#ccc}.wizard .wizard-header .wizard-steps .step-progress-bar.active,.wizard .wizard-header .wizard-steps .step-progress-bar.completed,.wizard .wizard-header .wizard-steps .step-progress-bar.first{border:1px solid var(--wizard-step-highlight-color);background-color:var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .step-progress-bar.first{left:50%}.wizard .wizard-header .wizard-steps .step-progress-bar.last{right:50%;z-index:0}.wizard .wizard-body{height:calc(100vh - 265px);overflow:auto;background:var(--wizard-body-bg-color)}.wizard .wizard-footer{background:var(--wizard-footer-bg-color);border-top:1px solid var(--footer-border-color);position:absolute;bottom:0;right:0;transition:left .4s linear;width:100%;z-index:11}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }], { xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective]
        }], wizardForm: [{
            type: ViewChild,
            args: ['wizardForm']
        }], wizard: [{
            type: Input
        }], onClose: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(WizardComponent, { className: "WizardComponent", filePath: "lib/components/wizard/wizard.component.ts", lineNumber: 19 }); })();
//# sourceMappingURL=data:application/json;base64,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